


--[[ Status messages ]]--
-- Displays on load
RECIPEBOOK_LOADED = string.format(RECIPEBOOK_VERSION_TEXT.." loaded! Enter "..RB_HEXCOLOR["yellow"].."/recipebook help"..RB_HEXCOLOR["end"].." or "..RB_HEXCOLOR["yellow"].."/rb help"..RB_HEXCOLOR["end"].." for options; "..RB_HEXCOLOR["yellow"].."/rb config"..RB_HEXCOLOR["end"].." for a graphical configuration.");
-- Help file
RECIPEBOOK_HELP = {
	RB_HEXCOLOR["green"].."Usage:"..RB_HEXCOLOR["end"].." Use "..RB_HEXCOLOR["yellow"].."/recipebook config"..RB_HEXCOLOR["end"].." or "..RB_HEXCOLOR["yellow"].."/rb config"..RB_HEXCOLOR["end"].." for a graphical options display.  Some slash commands are available: ",
	"   "..RB_HEXCOLOR["yellow"].."help"..RB_HEXCOLOR["end"].." : Display this help message.",
	"   "..RB_HEXCOLOR["yellow"].."on|off"..RB_HEXCOLOR["end"].." : Turns RecipeBook data display on and off.",
	"   "..RB_HEXCOLOR["yellow"].."config"..RB_HEXCOLOR["end"].." : Opens a graphical configuration window.",
	"   ",
	"   "..RB_HEXCOLOR["yellow"].."send [<alt>] to <person>"..RB_HEXCOLOR["end"].." : Sends your RecipeBook data for a specific alt to the named person.  Use 'guild' to do a guild-wide update.  You may use 'me' to send only the current character's data.",
	"   "..RB_HEXCOLOR["yellow"].."share"..RB_HEXCOLOR["end"].." : Opens the sharing and updates configuration panel",
	"   ",
	"   "..RB_HEXCOLOR["yellow"].."skill"..RB_HEXCOLOR["end"].." : Displays the currently-known recipes for a character.",
	"   "..RB_HEXCOLOR["yellow"].."search <search string>"..RB_HEXCOLOR["end"].." : Searches the RecipeBook database for items that match your search string.",
	"   "..RB_HEXCOLOR["yellow"].."searchmats <search string>"..RB_HEXCOLOR["end"].." : As /rb search, only searches only materials data.",
	"   ",
	"   "..RB_HEXCOLOR["yellow"].."bank"..RB_HEXCOLOR["end"].." : Display the RecipeBook Banking tab.",
	"   ",
	};
RECIPEBOOK_ERR_BADARG = "Sorry, I don't know what to do with '%s'.  Here's some help.";
RECIPEBOOK_TXT_SUPPLIES = "Supplies required for ";
RECIPEBOOK_ADDED_SPECIALS = "Found and added the following tradeskill specializations: ";

--[[ Data strings for parsing recipes ]]--
-- Whatever "ItemType" is for recipes in your locale
RECIPEBOOK_RECIPEWORD = "Recipe";
RECIPEBOOK_WORD_TRANSMUTE = "Transmute";
RECIPEBOOK_TRADESKILLS = {
	["Alchemy"] 		= "Alchemy", --1
	["Blacksmithing"] 	= "Blacksmithing", --2
	["Enchanting"] 		= "Enchanting", --3
	["Engineering"] 	= "Engineering", --4
	["Jewelcrafting"] 	= "Jewelcrafting", --5
	["Leatherworking"] 	= "Leatherworking", --6
	["Mining"] 			= "Mining", --7
	["Skinning"] 		= "Skinning", --8
	["Tailoring"] 		= "Tailoring", --9
	["Cooking"]			= "Cooking", --10
	["First Aid"] 		= "First Aid", --11
	["Fishing"] 		= "Fishing", --12
	["Herbalism"]       = "Herbalism", --13
}

--Specializations
RECIPEBOOK_SPECIALS = {
	["Blacksmithing"] 	= {"Armorsmith", "Weaponsmith"},
	["Engineering"] 	= {"Goblin Engineer", "Gnomish Engineer"},
	["Leatherworking"] 	= {"Tribal Leatherworking", "Elemental Leatherworking", "Dragonscale Leatherworking"},
	["Tailoring"]       = {"Shadoweave Tailoring", "Spellfire Tailoring", "Mooncloth Tailoring"},
	["Alchemy"]         = {"Potion Master", "Elixir Master", "Transmutation Master"},
};
-- Subspecializations
RECIPEBOOK_SUBSPECIALS = {
	["Blacksmithing"] = {"Master Swordsmith", "Master Axesmith", "Master Hammersmith" },
};

--[[ Regex parsed items; these may need adjustment for your language. ]]--
RECIPEBOOK_CHAT_SKILLUP = gsub(gsub(ERR_SKILL_UP_SI, "%%s", "(%%w*)"), "%%d.", "(%%d+)%%.");
RECIPEBOOK_REGEX_SKILL = string.gsub(string.gsub(ITEM_MIN_SKILL, "%%s", "%(%[%%w%%s%]+%)" ), "%(%%d%)", "%%%(%(%%d+%)%%%)");
RECIPEBOOK_REGEX_SPECIALTY = string.gsub(ITEM_REQ_SKILL, "%%s", "%(%[%%w%%s%]+%)" );
RECIPEBOOK_REGEX_REPUTATION = string.gsub(string.gsub(ITEM_REQ_REPUTATION, "%-", "%%%-"), "%%s", "%(%[%%w %]+%)" );
RECIPEBOOK_REGEX_NOTONLINE = string.gsub(ERR_CHAT_PLAYER_NOT_FOUND_S, "%%s", "%(%%w+%)");
RECIPEBOOK_REGEX_UNLEARNSKILL = string.gsub(ERR_SPELL_UNLEARNED_S, "%%s", "(%%w+)");
RECIPEBOOK_REGEX_LEARNRECIPE = string.gsub(ERR_LEARN_RECIPE_S, "%%s", "%(%[%%w%%s%]+%)");
RECIPEBOOK_REGEX_LEARNSPELL = string.gsub(ERR_LEARN_SPELL_S, "%%s", "%(%[%%w%%s%]+%)");
RECIPEBOOK_REGEX_ONLINE = string.gsub(string.gsub(string.gsub(ERR_FRIEND_ONLINE_SS, "%]", "%%%]"), "%[", "%%%["), "%%s", "%(%[%%w%]+%)");
	local a = string.find(LOOT_ITEM_PUSHED_SELF, "%s", 1, true);
RECIPEBOOK_REGEX_GETITEM = string.sub(LOOT_ITEM_PUSHED_SELF, 1, a-1);




--[[ Output prefixes ]]--
--== Chatframe Output ==--
RECIPEBOOK_CHATFRAME_KNOWNBY = " is already known by: ";
RECIPEBOOK_CHATFRAME_NONEKNOWN = " is known by no alts";
RECIPEBOOK_CHATFRAME_CANLEARN = " can be learned by: ";
RECIPEBOOK_CHATFRAME_NONELEARN = " cannot be learned by any alts";
RECIPEBOOK_CHATFRAME_WILLLEARN = " will eventually be learnable by (current skill): ";
RECIPEBOOK_CHATFRAME_NONEWILLLEARN = " has no alts who need only skillups to learn it.";
RECIPEBOOK_CHATFRAME_BANKED = " has been banked by: ";
RECIPEBOOK_CHATFRAME_NOTBANKED = " has not been banked.";
RECIPEBOOK_CHATFRAME_CANMAKE = " can be made by: ";

--== Tooltip Output ==--
-- RECIPEBOOK_TOOLTIPPREFIX = "\194\183";
RECIPEBOOK_KNOWNBY = "Already known by: ";
RECIPEBOOK_CANLEARN = "Can be learned by: ";
RECIPEBOOK_WILLLEARN = "Will be learnable by: ";
RECIPEBOOK_CANMAKE = "Can be made by: ";
RECIPEBOOK_ISBANKED = "Banked by: ";
-- RECIPEBOOK_NODATA = RECIPEBOOK_TOOLTIPPREFIX.."No alts know or can use this recipe." -- For future use
RECIPEBOOK_ERR_DATANOTLOADED = "RecipeBook data not yet loaded.\nWait a few seconds and try again.";

--[[ Options display text; name is RBOPTIONS_(option)_(suboption) ]]--
RBOPTIONS_STATUS = "RecipeBook data output: %s (data collection is always on).  Use /rb (or /rbk) config to configure RecipeBook.";
-- Chatframe options display has been outmoded; using GUI instead.  Options default to RBOptions_NotFound
RBOPTIONS_NOTFOUND = "Other options may be viewed in the configuration pane (/rb config)";
-- Cn/off colored text
RBOPTIONS_ON = RB_HEXCOLOR["green"].."On"..RB_HEXCOLOR["end"];
RBOPTIONS_OFF = RB_HEXCOLOR["red"].."Off"..RB_HEXCOLOR["end"];

--== RBOutput_Print() ==--
RECIPEBOOK_ERROR_PREFIX = "|cffffff00<|cffff0000RecipeBook Error|cffffff00>|r ";
RECIPEBOOK_PREFIX = "|cffffff00<RecipeBook>|r ";


--========================[[ Configuration Screens ]]============================--
---------------------------------- Main Frame and Subframe Tabs  -------------------------------------------
RECIPEBOOK_SFTAB_SEARCH = "Search";
RECIPEBOOK_SFTAB_BROWSE = "Browse";
RECIPEBOOK_SFTAB_OPTIONS = "Options";
RECIPEBOOK_SFTAB_SHARING = "Sharing";
RECIPEBOOK_SFTAB_BANKING = "Banking";
RECIPEBOOK_SFSUBTAB_AA = "Auto-Accept";
RECIPEBOOK_SFSUBTAB_AD = "Auto-Decline";
RECIPEBOOK_SFSUBTAB_AU = "Auto-Update";

---------------------------------- Main Frame and Subframe Buttons -------------------------------------------
RECIPEBOOK_CFG_B_MAKEDEFAULT = "Make Default";

--------------------------------- Search Panel  (tab 1) -------------------------------------------
RECIPEBOOK_SFTITLE_SEARCH = "Search for Recipes/Materials";
-- Single/plural versions of this template
RECIPEBOOK_TEMPLATE_KNOWNS = "  Known by: 1 alt";
RECIPEBOOK_TEMPLATE_KNOWNM = "  Known by: %d alts";
-- Single/plural versions of this template
RECIPEBOOK_TEMPLATE_HAVES = " (1 additional has %s)";
RECIPEBOOK_TEMPLATE_HAVEM = " (%d additional have %s)";
RECIPEBOOK_TXT_KNOWNBY = "Known by (difficulty): ";
RECIPEBOOK_TXT_HASKILL = "Has %s (rank): ";
RECIPEBOOK_TXT_NOKNOWNBY = "Known by no alts";
RECIPEBOOK_TEMPLATE_KNOWNMATS = "  Uses: ";
RECIPEBOOK_CBX_SEARCHITEMS = "Search in known recipes";
RECIPEBOOK_CBX_TT_SEARCHITEMS = "Check to search for created items that match the search text.";
RECIPEBOOK_CBX_SEARCHMATS = "Search in materials";
RECIPEBOOK_CBX_TT_SEARCHMATS = "Check to search for items which use a reagent matching the search text.";
RECIPEBOOK_CBX_SEARCHEXACT = "Search exact phrase only";
RECIPEBOOK_CBX_TT_SEARCHEXACT = "If this is unchecked, matches all words in your search string (i.e. \"white mask\" would match White Bandit Mask).  If it is checked, finds only exact matches for what you enter.";
RECIPEBOOK_CBX_SEARCHBOOSTS = "Only items that will boost an alt";
RECIPEBOOK_CBX_TT_SEARCHBOOSTS = "Only returns items that have the potential to boost an alt (green, yellow, or orange)";
RECIPEBOOK_ERR_NOSEARCHRESULT = RB_HEXCOLOR["red"].."No matches for that search"..RB_HEXCOLOR["end"];

--------------------------------- Skill Browse Panel (tab 2) -------------------------------------------
RECIPEBOOK_SFTITLE_SKILL = "Browse known skills";
RECIPEBOOK_BROWSE_FS_NOSPEC = "No Specialization";
RECIPEBOOK_BROWSE_FS_NODATA = "No data";
RECIPEBOOK_BROWSE_FS_NOTRACKED = "Not tracked";
RECIPEBOOK_BROWSE_FS_NODATE = "No Date";

RECIPEBOOK_BROWSE_FS_CLICK = "[click to change]";
RECIPEBOOK_BROWSE_BUT_SHOW = "Show";
RECIPEBOOK_BROWSE_FS_SHARED = "Shared";
RECIPEBOOK_BROWSE_FS_PERSONAL = "Personal";
RECIPEBOOK_BROWSE_FS_NOTRADESKILL = "No tradeskill found";

RECIPEBOOK_BROWSE_FS_SEARCH = "Enter search text";

RECIPEBOOK_BROWSE_FS_ITEM = "Item";
RECIPEBOOK_BROWSE_FS_RECIPE = "Recipe Makes";
RECIPEBOOK_BROWSE_FS_INFOITEMLEVEL = "Item Level";
RECIPEBOOK_BROWSE_FS_INFOMINLEVEL = "Level Req";

RECIPEBOOK_BROWSE_DD_SORTALPHA = "Alphabetical";
RECIPEBOOK_BROWSE_DD_SORTDIFF = "Difficulty";
RECIPEBOOK_BROWSE_DD_SORTILVL = "Item Level";
RECIPEBOOK_BROWSE_DD_SORTMLVL = "Min Level Req";
RECIPEBOOK_BROWSE_DD_SORTITYPE = "Type/Location";

RECIPEBOOK_CFG_CBX_SU = "Show all items in database";
RECIPEBOOK_CFG_MOUSEOVER_SU = "Show items that are in the RecipeBook database for the selected skill, but which the current character does not know.";
--------------------------------- Skill Tracking Subframe -------------------------------------------
RECIPEBOOK_BROWSE_TT_APPLY = "Applies changes, deleting tradeskill data for non-tracked skills.";
RECIPEBOOK_BROWSE_TT_RESET = "Discards changes.";
RECIPEBOOK_BROWSE_TT_SHOW = "Uncheck to deprecate data (prevent recipes with this skill from showing up as 'learnable' or 'will be able to learn')"
RECIPEBOOK_BROWSE_TT_DEFAULTS = "Resets all tracking options back to defaults, then applies this change.";
RECIPEBOOK_BROWSE_FS_TRACKED = "Tracked Skills";
RECIPEBOOK_BROWSE_TT_TRACKED = "Set tradeskill tracking options for this character."
RECIPEBOOK_BROWSE_TT_REFRESH = "Reload this tradeskill window.";
RECIPEBOOK_BROWSE_TT_DELETE = "Delete all tradeskill data for this alt.";
RECIPEBOOK_BROWSE_TT_UNCONFIRMEDHEADER = "Uncached Item:";
RECIPEBOOK_BROWSE_TT_UNCONFIRMEDITEM = {
	"One of the queries for this item has failed.",
	"Consequently, this item is unsafe.  To view this item without risk of disconnection, you need to have first seen it in the game world.  This is a restriction enforced by Blizzard since patch 1.10.",
	"You may click to attempt to query the server.  You may be disconnected."
};
--------------------------------- Sharing Panel (tab 3) -------------------------------------------
RECIPEBOOK_SFTITLE_SHARING = "Shared Data";
RECIPEBOOK_CFG_HEADER_SHARING = "Shared (Friends) Data";
RECIPEBOOK_CFG_FS_SHARECATEGORIES = "Show recipes that are: ";
RECIPEBOOK_CFG_CBX_SK = "Known";
RECIPEBOOK_CFG_CBX_SC = "Learnable";
RECIPEBOOK_CFG_CBX_SW = "Has Skill";
RECIPEBOOK_CFG_FS_SHAREFACTION = "Show shared recipe data for:";
RECIPEBOOK_CFG_CBX_SSF = "Same Faction";
RECIPEBOOK_CFG_CBX_SOF = "Opposite Faction";

RECIPEBOOK_CFG_RADIO_CAPTION = "On share request from:"
RECIPEBOOK_CFG_RADIO_HEADER = "Accept    Decline    Prompt"
RECIPEBOOK_CFG_RADIO_FRIENDS = "Friends";
RECIPEBOOK_CFG_RADIO_GUILD = "Guildmates";
RECIPEBOOK_CFG_RADIO_DEFAULT = "Default Response";

RECIPEBOOK_CFG_HEADER_AUTOUPDATE = "AutoUpdate Configuration";
RECIPEBOOK_CFG_FS_AUFREQ = "Send AutoUpdate for data older than:";
RECIPEBOOK_CFG_RADIO_DAY = "1 Day";
RECIPEBOOK_CFG_RADIO_WEEK = "1 Week";
RECIPEBOOK_CFG_RADIO_NEVER = "Never";
RECIPEBOOK_CFG_FS_AUSOURCE = "Accept inbound AutoUpdates from:"
RECIPEBOOK_CFG_CBX_G = "Guild Send";
RECIPEBOOK_CFG_MOUSEOVER_G = "Accept updates from Guildmembers who use '/rb send me to guild'";
RECIPEBOOK_CFG_CBX_A = "Auto-Accept list";
RECIPEBOOK_CFG_MOUSEOVER_A = "Accept inbound AutoUpdates IF the sender is on your auto-accept list."
RECIPEBOOK_CFG_CBX_GU = "Send update to Guild on login"; -- For future use

RECIPEBOOK_CFG_DDHEADER_UPDATEFROM = "Also auto-update from:";

--== see below for parser information ==--
--------------------------------- Banking Panel (tab 3) -------------------------------------------
RECIPEBOOK_SFTITLE_BANKING = "Banking Configuration";
RECIPEBOOK_CFG_HEADER_BANKLIST = "Banked on This Server/Faction:";
RECIPEBOOK_CFG_HEADER_BANKOPTIONS = "Banking Options:";
RECIPEBOOK_CFG_CBX_B = "Show Banked Status";
RECIPEBOOK_CFG_CBX_BT = "Show banked and unbanked notifications";
RECIPEBOOK_CFG_FS_AUTOBANK = "Automatically track banked recipes for:";
RECIPEBOOK_CFG_CBX_BK = "Your bank slots";
RECIPEBOOK_CFG_CBX_BG = "Your bags";
RECIPEBOOK_CFG_TT_UNBANK = "Delete item from this character's banked list";

--== Chatframe Banking Messages ==--
RECIPEBOOK_AUTOHELD = "Added to banked list: ";
RECIPEBOOK_AUTOUNHELDSUCCEED = "Removed from %s's banked list: %s";
RECIPEBOOK_AUTOUNHELDFAIL = "Sorry, %s does not have %s banked.";
RECIPEBOOK_INFO_CANLEARNONSKILLUP = "You may now be able to learn %s, banked by %s.";

--------------------------------- Options Panel (tab 4) -------------------------------------------
RECIPEBOOK_SFTITLE_OPTIONS = "RecipeBook Options";
RECIPEBOOK_CFG_FS_SELECTFACTION = "Tracked Factions (global)";
RECIPEBOOK_CFG_CBX_S = "Display Recipe Book Output";
RECIPEBOOK_CFG_CBX_MM = "Show Minimap Button";
RECIPEBOOK_CFG_CBX_DM = "Display Current Character";
RECIPEBOOK_CFG_CBX_I = "Show informational (non-error) messages";
RECIPEBOOK_CFG_MOUSEOVER_I = "Uncheck this box to eliminate informational messages such as tradeskill scan points and /rb send information.";
RECIPEBOOK_CFG_CBX_C = "Delete recipes that no character knows";
RECIPEBOOK_CFG_MOUSEOVER_C = "Uncheck this if you want RecipeBook to maintain items in the database even if no-one knows the recipe.  Check this to keep the database smaller (and possibly faster), at the expense of being able to browse only items your alts/shared alts can make.";
RECIPEBOOK_CFG_FS_OUTPUT = "Output recipe information to:";
RECIPEBOOK_CFG_CBX_OT = "Tooltip";
RECIPEBOOK_CFG_CBX_OC = "RecipeBook chat tab";
RECIPEBOOK_CFG_FS_CATEGORIES = "Show recipes that:";
RECIPEBOOK_CFG_CBX_AK = "Are already known";
RECIPEBOOK_CFG_CBX_AC = "Can be learned";
RECIPEBOOK_CFG_CBX_AW = "Will be learnable";
RECIPEBOOK_CFG_FS_CANMAKE = "Show items that can be made by:";
RECIPEBOOK_CFG_CBX_AM = "Your Alts";
RECIPEBOOK_CFG_CBX_SM = "Shared Characters";
RECIPEBOOK_CFG_FS_FACTION = "Show recipe and item data for:";
RECIPEBOOK_CFG_CBX_ASF = "Same Faction";
RECIPEBOOK_CFG_CBX_AOF = "Opposite Faction";
RECIPEBOOK_CFG_CBX_TM = "Collect RecipeBook data for this character";

RECIPEBOOK_CFG_FS_AUCTION = "Auction and Merchant Options";
RECIPEBOOK_CFG_CBX_ACS = "Color-code auctions and merchants";
RECIPEBOOK_CFG_CBX_ABS = "Blackout banked recipes";
-- Auction Frame: --
-- For future use; please do translate.
-- RECIPEBOOK_AUCCOLOR_ALTSCANLEARN = "Color for recipes that can be learned by alts (not including this character).";
-- RECIPEBOOK_AUCCOLOR_ALTSWILLLEARN = "Color for recipes that will eventually be learnable by alts (may include this character).";
-- RECIPEBOOK_AUCCOLOR_YOUWILLLEARN = "Color for recipes that will eventually be learnable by this character only.";
-- RECIPEBOOK_AUCCOLOR_NOALTSCANLEARN = "Color for recipes that no alts will be able to learn.";
-- RECIPEBOOK_AUCCOLOR_ALLALTSKNOW = "Color for recipes that are known by all tracked alts.";


RECIPEBOOK_SHARE_USAGE = RB_HEXCOLOR["red"].."Note: This has changed! "..RB_HEXCOLOR["end"].."Usage: "..RB_HEXCOLOR["yellow"].."/rb send [<alt>] to <person>"..RB_HEXCOLOR["end"]..".  You may use 'me' to send only the current character's data.";
--== RB Share User Notifications ==--
RECIPEBOOK_SHARERROR_NOCOMPLETE = "Cannot complete RecipeBook share (Initiated by %s, tradeskill %s for player %s): ";
RECIPEBOOK_SHARERROR_NOTRACKED = "Not tracking %s for %s.";
RECIPEBOOK_SHARERROR_CANCEL = "Share was cancelled."
RECIPEBOOK_SHARERROR_VERSION = "Incompatible RecipeBook version.  Requires at least version ".. table.concat(RECIPEBOOK_COMPATIBLE, ".") .. " for sharing.";
RECIPEBOOK_SHARERROR_TIMEOUT = "Failed to receive an appropriate response from %s before timeout expired.";
RECIPEBOOK_SHARERROR_AUTODECLINE = "%s is automatically declining all tradeskill shares for %s";
RECIPEBOOK_SHARERROR_NOTRACKING = "%s is not tracking tradeskill %s for %s.";
RECIPEBOOK_SHARERROR_MANUALDECLINE = "%s has declined to accept %s's data from %s";
RECIPEBOOK_UPDATERROR_MANUALDECLINE = "%s has declined to send updated data to %s";
RECIPEBOOK_SHARERROR_TIMEOUTDECLINE = "%s has let the accept window expire for %s's data from %s";
RECIPEBOOK_SHARERROR_SENDSELF = "You can't send RecipeBook data to yourself.  You already have it.";
RECIPEBOOK_SHARERROR_NOTINGUILD = "You're not in a guild.";
RECIPEBOOK_SHARERROR_NOGUILDONLINE = "No guildmembers currently online; RecipeBook will not send data.";
RECIPEBOOK_ERROR_NOREQUEST = "You have no data for %s in your RecipeBook.  No update request can be made.";
RECIPEBOOK_ERROR_AUTODECLINE = " does not currently wish to accept RecipeBook data for ";
RECIPEBOOK_ERROR_DECLINEDSESSION = "Auto-declining RecipeBook share from ";
RECIPEBOOK_ERROR_ACCEPTEDSESSION = "Auto-accepting RecipeBook share from %s for %s.";
--== Info messages ==--
RECIPEBOOK_SHAREMSG_INITIATE = "Attempting to send %s data for %s to %s.";
RECIPEBOOK_SHAREMSG_TERMINATE = "Completed sending %s data for %s to %s.";
RECIPEBOOK_SHAREMSG_RECEIVEDALL = "Data for %s's %s successfully received from %s.";
--== Popups ==--
RECIPEBOOK_POPUP_BLOCKPLAYER = "You have declined RecipeBook data for player %s.  Always decline shares from that player?";
RECIPEBOOK_POPUP_ACCEPTPLAYER = "You have accepted RecipeBook data for player %s.  Auto-accept shares for that player?";
RECIPEBOOK_POPUP_REQUESTING_SEND = "%s would like to send you RecipeBook data for character %s.  This transfer will be cancelled in %d %s.";
RECIPEBOOK_POPUP_REQUESTING_UPDATE = "%s would like to request that you send updated RecipeBook data.  Select 'Accept' to send the update.  This request will auto-decline in %d %s.";
RECIPEBOOK_POPUP_ADD_CHARACTER = "Enter the name of the character to add:";


------------------------------------------------------[[ Minimap Menu, User Menu,  and Key Bindings ]]------------------------------------
--== User Menu ==--
RECIPEBOOK_MENU_MAIN = "RecipeBook";
RECIPEBOOK_MENU_SHARE = "Send Data";
RECIPEBOOK_MENU_REQUEST = "Request Update";
RECIPEBOOK_MENU_SHARESELF = "Send this character's data";
RECIPEBOOK_MENU_SHAREALL = "Send data for all alts";
--== Key Bindings ==--
BINDING_HEADER_RECIPEBOOK = "RecipeBook Keys";
BINDING_NAME_RECIPEBOOK_SKILL = "Skill Browse Panel";
BINDING_NAME_RECIPEBOOK_CONFIG = "Config Panel";
BINDING_NAME_RECIPEBOOK_SEARCH = "Search Window";
--== Minimap Button ==--
RECIPEBOOK_MMTXT = "|cffffff00Recipe Book|r:\n|cff00ff00Left-click|r to toggle skill browse frame\n|cff00ff00Right-click|r to choose another frame";
RECIPEBOOK_MM_MENUTITLE = "Select tab:";
RECIPEBOOK_MM_HIDE = "Hide Minimap Button";


-----------------------[[ Informational Messages ]]-----------------
RECIPEBOOK_ERR_TRADESKILLNOTSCANNED = "Some items were not scanned for %s.  Data may be missing from RecipeBook. Rescanning on next update...";
RECIPEBOOK_ERR_REAGENTSNOTSCANNED = "Some reagents for %s were not yet in local cache. This will not affect known recipe data.  We will continue to watch for these items...";
RECIPEBOOK_INFO_SCANCOMPLETED = "All items and reagents have been saved for tradeskill %s.  OK to close tradeskill window.";
RECIPEBOOK_TEXT_ITEMDISCONNECTED = "RecipeBook has found a bad item ID in its database, causing a disconnect. We will not attempt to query this item ID again until it has been seen by a logged-in character.  Please select 'OKAY' to continue with the build.  If this happens repeatedly, delete your SavedVariables file and reload.";


-----------------------[[ RecipeBook DB Error Messages ]]-----------------
RECIPEBOOK_DBERROR_NOSKILLID = "No Tradeskill Found";
RECIPEBOOK_DBERROR_NODIFFID = "Bad Difficulty ID";
RECIPEBOOK_DBERROR_NOSPECID = "No specialty";

RECIPEBOOK_NEWVERSION = "This version of RecipeBook does NOT support previous data versions.  You will have to refresh your personal and shared tradeskills."
