--[[ RecipeBook Upgrade Files
This file contains functions introduced to fix compatibility issues in various versions of RecipeBook.
]]--
RBUpgrade = {};

--[[ 2.2.0 to 2.3.0 ]]--
function RBUpgrade:CleanEnchantments()
	local chant = RBDB:Skill_TextToDB(RECIPEBOOK_TRADESKILLS["Enchanting"]);
	for id, info in pairs(RecipeBook_ItemDB) do
	    if info[chant] and info[chant]["RLink"] and info[chant]["RLink"] == id then
	        if not GetItemInfo(id) or (info[chant]["Name"] and info[chant]["Name"] == GetItemInfo(id)) then
				-- This is an enchanting recipe properly cached
			else
			    -- This is an improperly cached enchanting recipe.
			    RecipeBook_ItemDB[id] = nil;
			end
		end
	end
end


function RBUpgrade:DataUpgrade(version)
	RecipeBook:Debug("Running updates for data version: "..version);
	if version < 7 then
	    -- This will force a rescan of all tradeskills.
	    for realm, factions in pairs(RecipeBook_CharacterDB) do
	        if type(realm) == "number" then
		        for faction, characters in pairs(factions) do
					if type(faction) == "number" then
			            for character, skills in pairs(characters) do
			                for skill, data in pairs(skills) do
			                    if type(skill) == "number" then
			                    	RecipeBook_CharacterDB[realm][faction][character][skill][RECIPEBOOK_TRADESKILL_DEFAULTS["numskills"][1]] = 0;
								end
			                end
			            end
					end
				end
				-- We'll also wipe out banked data and warn everyone.
				RecipeBook_CharacterDB[realm]["Banked Items"] = nil;
				RecipeBook_CharacterDB[realm]["Held Items"] = {};
			end
		end
		RBOutput:Print("RecipeBook data have been revamped.  If you were tracking banked items, these have been reset.", "help");
		RecipeBook_CharacterDB["Data Version"] = 7;
	end
	
	if version < 8 then
		RBUpgrade:CleanEnchantments();
		RecipeBook_CharacterDB["Data Version"] = 8;
	end
	
	if version < 9 then
		if RecipeBook_Options["AutoUpdate"] ~= nil then RecipeBookOptions["AutoUpdate"] = nil end;
		if RecipeBook_Defaults["AutoUpdate"] ~= nil then RecipeBookDefaults["AutoUpdate"] = nil end;
		RecipeBook_CharacterDB["Data Version"] = 9;
	end
	
	if version < 11 then
		RecipeBook_CharacterDB = {["Data Version"] = RECIPEBOOK_DATAVERSION, ["Debug"] = {}};
		RBDB:AddNewPlayer(RecipeBook.Globals.Player, RecipeBook.Globals.Faction, false);
		RecipeBook_ItemDB = {};
		RBOutput:Print("RecipeBook data have been restructured.  ALL ITEM AND CHARACTER DATA HAVE BEEN RESET.  Your options should be preserved.", "error");
	end
	
end
