--[[ RECIPE BOOK UI:
Contains most of the functions used to coordinate the GUI.

]]--

--============================== VARIABLES ==============================--
RBUI = {};
RBUI.SharingFrame = {};
RBUI.SharingFrame.WhoHeight = 16;
RBUI.SharingFrame.NumWhos = 20;
RBUI.BankingFrame = {};
RBUI.BankingFrame.ItemHeight = 16;
RBUI.BankingFrame.NumItems = 20;
RBUI.AUMenu = {};
RBUI.AUButtons = {};
local RB_ListContents = {};

--============================== FUNCTIONS ==============================--
function RBUI:Initialize()
	local fac = 10;
	if RecipeBook.Globals.Faction == FACTION_HORDE then fac = 20 end;
	for k, who in pairs(RBDB:GetAllInFaction(fac)) do
		RecipeBook:Debug("Who: "..who);
		if who ~= RecipeBook.Globals.Player then 
			local button = string.upper("RBSHARE_"..who);
	      	table.insert(RBUI.AUMenu, button);
	   		RBUI.AUButtons[button] = { text = who, dist = 0, checkable = 1, func = RBUI.SharingFrame_DDChooseAlts_OnClick };
		end
	end
   	table.insert(RBUI.AUMenu, "CANCEL");
end


function RBUI:StaticPopups()
	StaticPopupDialogs["RECIPEBOOK_ADD_CHARACTER"] = {
		text = RECIPEBOOK_POPUP_ADD_CHARACTER,
		button1 = ACCEPT,
		button2 = CANCEL,
		hasEditBox = 1,
		maxLetters = 12,
		OnAccept = function()
			local editBox = getglobal(this:GetParent():GetName().."EditBox");
			if RBUI_SharingFrame.showList == 3 then
				RBDB:SetAutoUpdateData(RBOutput:Capitalize(editBox:GetText()), 0);
			else
				RBOptions:SetShareStatus(RBOutput:Capitalize(editBox:GetText()), (RBUI_SharingFrame.showList == 1 and 1 or 0 ));
			end
			RBUI:SharingFrame_OnUpdate();
		end,
		OnShow = function()
			getglobal(this:GetName().."EditBox"):SetFocus();
		end,
		OnHide = function()
			if ( ChatFrameEditBox:IsShown() ) then
				ChatFrameEditBox:SetFocus();
			end
			getglobal(this:GetName().."EditBox"):SetText("");
			RBUI:SharingFrame_OnUpdate();
		end,
		EditBoxOnEnterPressed = function()
			local editBox = getglobal(this:GetParent():GetName().."EditBox");
			if RBUI_SharingFrame.showList == 3 then
				RBDB:SetAutoUpdateData(RBOutput:Capitalize(editBox:GetText()), 0);
			else
				RBOptions:SetShareStatus(RBOutput:Capitalize(editBox:GetText()), (RBUI_SharingFrame.showList == 1 and 1 or 0 ));
			end
			this:GetParent():Hide();
			RBUI:SharingFrame_OnUpdate();
		end,
		EditBoxOnEscapePressed = function()
			this:GetParent():Hide();
		end,
		timeout = 0,
		exclusive = 1,
		whileDead = 1,
		hideOnEscape = 1
	};
end

--============================== MAIN FRAME ==============================--
--[[ OnLoad() ]]--
function RBUI:MainFrame_OnLoad()
	UIPanelWindows["RBUI_MainFrame"] = {area = "center", pushable = 0};
	tinsert(UISpecialFrames, "RBUI_MainFrame");
	PanelTemplates_SetNumTabs(this, 5);
	PanelTemplates_SetTab(this, 1);
	PanelTemplates_SetNumTabs(RBUI_SharingFrame, 3);
	PanelTemplates_SetTab(RBUI_SharingFrame, 1);
end

--[[ OnShow() ]]--
function RBUI:MainFrame_OnShow()
	RBDB:UpdateNameList();
	PlaySound("igMainMenuOpen");
	RBUI:MainFrame_OnUpdate();
	-- Options tab is disabled for now.
	--PanelTemplates_DisableTab(this, 5);
end

--[[ OnUpdate() ]]--
function RBUI:MainFrame_OnUpdate()
	local name = RBUI_SUBFRAMES[RBUI_MainFrame.selectedTab]
	local _,_,text = string.find(name, "RBUI_(%w+)Frame");
	RBUI_MainFrame_TitleText:SetText(getglobal("RECIPEBOOK_SFTITLE_"..string.upper(text)));
	RBUI:ShowSubFrame(name);
end

--[[ OnHide() ]]--
function RBUI:MainFrame_OnHide()
	PlaySound("igMainMenuClose");
	for k, v in pairs(RBUI_SUBFRAMES) do
		if getglobal(v) then getglobal(v):Hide() end;
	end
	-- Hide chooser tooltip if shown still
end

--[[ ShowSubFrame(frame name) --> Shows the given subframe ]]--
function RBUI:ShowSubFrame(name)
	for i, v in pairs(RBUI_SUBFRAMES) do
		if ( v == name ) then
			getglobal(v):Show();
		else
			if getglobal(v) then getglobal(v):Hide() end;
		end
	end
end

--[[ ShowSearchFrame([what]) --> Opens the RecipeBook Search window.  If provided parameters then starts with that search. ]]--
function RBUI:ShowSearchFrame(what, searchItems, searchMats)
	PanelTemplates_SetTab(RBUI_MainFrame, 1);
    RBUI_MainFrame:Show();
    if what and what ~= "" then
        RBUI_SearchFrame_EDIT_SearchFor:SetText(what);
		RBUI_SearchFrame_CBX_SearchItems:SetChecked(searchItems);
		RBUI_SearchFrame_CBX_SearchMats:SetChecked(searchMats);
        RBSearch:DoSearch();
	else
		RBUI_SearchFrame_CBX_SearchItems:SetChecked(searchItems);
		RBUI_SearchFrame_CBX_SearchMats:SetChecked(searchMats);
		RBUI_SearchFrame_EDIT_SearchFor:SetFocus();
	end
end

function RBUI:ShowBrowseFrame() 
	return RBSkill:ShowBrowseFrame();
end;

function RBUI:ShowShareFrame()
	PanelTemplates_SetTab(RBUI_MainFrame, 3);
    RBUI_MainFrame:Show();
end

function RBUI:ShowBankFrame()
	PanelTemplates_SetTab(RBUI_MainFrame, 4);
    RBUI_MainFrame:Show();
end


function RBUI:ShowOptionsFrame()
	PanelTemplates_SetTab(RBUI_MainFrame, 5);
    RBUI_MainFrame:Show();
end

--============================== SUBFRAME OPTIONS ==============================--
local SubFrame = {};
SubFrame.Options = {
	["RBUI_SkillFrame"] = {
		["SU"] = {"Browse", "Unknown"};
	},
	["RBUI_SharingFrame"] = {
	    ["SSF"]	= {"Display", "SSF"}; -- Shared same
	    ["SOF"]	= {"Display", "SOF"}; -- Shared other
		["SK"]	= {"Display", "SK"}; -- Shared know
		["SC"]	= {"Display", "SC"}; -- Shared can learn
		["SW"]	= {"Display", "SW"}; -- Shared will learn
		["G"] = {"Updates", "Guild"}; -- Accept updates from guild
		["A"] = {"Updates", "Accept"}; -- Potentially accept inbound AutoUpdate requests
		["GU"] = {"Updates", "SendGuild"}; -- Potentially send updates to guild. 
	},
	["RBUI_BankingFrame"] = {
		["B"] = {"Display", "B"};
		["BT"] = {"Bank", "Tell"};
		["BK"] = {"Bank", "Bank"};
		["BG"] = {"Bank", "Bags"};
	},
	["RBUI_OptionsFrame"] = {
		["S"] = {"Status", nil};
		["MM"] = {"MM", "Show"};
		["DM"] = {"Display", "Me"};
		["TM"] = {"TrackMe", nil};
		["OT"] = {"Output", "TT"};
		["OC"] = {"Output", "CF"};
	    ["ASF"]	= {"Display", "ASF"}; -- Alts same
	    ["AOF"]	= {"Display", "AOF"}; -- Alts other
		["AK"]	= {"Display", "AK"}; -- Alts know
		["AC"]	= {"Display", "AC"}; -- Alts can learn
		["AW"]	= {"Display", "AW"}; -- Alts will learn
		["SM"]	= {"Display", "SM"};
		["AM"]	= {"Display", "AM"};
		["ACS"] = {"AucC", "Show"};
		["ABS"] = {"Bank", "Show"};
		["I"] = {"Output", "Info"};
		["C"] = {"Browse", "CleanData"};
	};
}; -- Dummy variables for subframe options on load

SubFrame.Current = {};

--[[ LoadOptions(frame) --> Loads the initial values of the given frame's displayed options ]]--
function RBUI:SubFrame_LoadOptions(frame)
	SubFrame.Current[frame] = {};
	for o,v in pairs(SubFrame.Options[frame]) do
		local x,y = unpack(v);
		SubFrame.Current[frame][o] = RBOptions:GetOption(x,y);
	end
	if frame == "RBUI_SharingFrame" then -- Special stuff for SharingFrame.
		SubFrame.Current[frame]["_Friend"] = RBOptions:GetShareStatus("_Friend");
		SubFrame.Current[frame]["_Guild"] = RBOptions:GetShareStatus("_Guild");
		SubFrame.Current[frame]["_Default"] = RBOptions:GetShareStatus("_Default");
		SubFrame.Current[frame]["Frequency"] = RBOptions:GetOption("Updates", "Freq");
	end
end

--[[ CommitOptions(frame) --> Saves the given frame's displayed options ]]--
function RBUI:SubFrame_CommitOptions(frame, default)
	for o,v in pairs(SubFrame.Options[frame]) do
		local x, y = unpack(v)
		RBOptions:SetOption(x, y, SubFrame.Current[frame][o]);
	end
	if default then -- set new defaults 
		local subset = {};
		for o,v in pairs(SubFrame.Options[frame]) do
			local x, y = unpack(v)
			table.insert(subset, {x, y, SubFrame.Current[frame][o]})
		end
		if frame == "RBUI_SharingFrame" then -- Special cases for SharingFrame
			table.insert(subset, {"ShareGroups", "_Friend", RBOptions:GetShareStatus("_Friend")});
			table.insert(subset, {"ShareGroups", "_Guild", RBOptions:GetShareStatus("_Guild")});
			table.insert(subset, {"ShareGroups", "_Default", RBOptions:GetShareStatus("_Default")});
			table.insert(subset, {"Updates", "Freq", RBOptions:GetOption("Updates", "Freq")});
		end
		RBOptions:SetDefaultOptions(subset);
	end
end

--[[ RevertOptions(frame) --> Reverts the given frame's displayed options to initial values ]]--
function RBUI:SubFrame_RevertOptions(frame)
	if frame == "RBUI_SharingFrame" then
		RBOptions:SetShareStatus("_Friend", SubFrame.Current[frame]["_Friend"]);
		RBOptions:SetShareStatus("_Guild", SubFrame.Current[frame]["_Guild"]);
		RBOptions:SetShareStatus("_Default", SubFrame.Current[frame]["_Default"]);
		RBOptions:SetOption("Updates", "Freq", SubFrame.Current[frame]["Frequency"]);
	end
	RBUI:SubFrame_LoadOptions(frame); -- Setup checkboxes correctly.
	RBUI:SubFrame_CheckBoxUpdate(frame);
end

--[[ CheckBoxUpdate(frame) --> Updates checkboxes and radio buttons on a status change. ]]--
function RBUI:SubFrame_CheckBoxUpdate(frame)
	if frame == "RBUI_SharingFrame" then
		local value = {"_Friend", "_Guild", "_Default"};
		for row = 1, 3 do -- Setup Radio buttons  correctly.
			 local x = RBOptions:GetShareStatus(value[row]);
			 if x == 1 then RBUI:SharingFrame_Radio_ADPClick(row*3 - 1, true);
			 elseif x == 0 then RBUI:SharingFrame_Radio_ADPClick(row*3 - 2, true);
			 elseif x == -1 then RBUI:SharingFrame_Radio_ADPClick(row*3, true);
			 end
		end
		RBUI:SharingFrame_Radio_AUFreqClick(RBOptions:GetOption("Updates", "Freq"), true); -- Check Frequency box.
	end
	for o,_ in pairs(SubFrame.Options[frame]) do 
		if type(SubFrame.Current[frame][o]) == "boolean" then 
			local button = getglobal(frame.."_CBX_ID"..o);
			local option = SubFrame.Current[frame][o];
			if option then button:SetChecked(1) else button:SetChecked(0) end;
			--getglobal(frame.."_CBX_ID"..o):SetChecked((SubFrame.Current[frame][o]) and 1 or 0);
		end
	end
end

-- --[[ CBXLoad(checkbox name) --> Sets the checkbox's initial value ]]--
-- function RBUI_SubFrame_CBXLoad(frame, name)
	-- name = string.match(name, "_ID(%w+)");
	-- if SubFrame.Options[frame][name] and RBOptions:GetOption(unpack(SubFrame.Options[frame][name])) then return 1 else return 0 end;
-- end

--[[ CBXClick(checkbox name, checked status) --> Sets the options's new value ]]--
function RBUI:SubFrame_CBXClick(frame, name, checked)
	name = string.match(name, "_ID(%w+)");
	SubFrame.Current[frame][name] = (checked and true or false);
end


--============================== SHARING FRAME ==============================--
--[[ Dropdown functions ]]--
function RBUI:SharingFrame_DD_ChooseAlts_OnLoad()
	UIDropDownMenu_Initialize(RBUI_SharingFrame_DD_ChooseAlts, RBUI.SharingFrame_DDChooseAlts_Initialize, "MENU");
end

function RBUI:SharingFrame_DDChooseAlts_Initialize()
	local info = UIDropDownMenu_CreateInfo();
	-- Title Menu: 
	info.text = RECIPEBOOK_CFG_DDHEADER_UPDATEFROM;
	info.isTitle = 1;
	info.notCheckable = 1;
	UIDropDownMenu_AddButton(info);
	
	-- Faction and player buttons
	for x, button in ipairs(RBUI.AUMenu) do
		local info = UIDropDownMenu_CreateInfo();
		local data = RBUI["AUButtons"][button];
		if not data then data = UnitPopupButtons[button] end;
		info.text = data.text;
		info.value = button;
		info.owner = this:GetParent();
		info.notCheckable = nil;
		info.checked = RBDB:AltUpdatesTo(info.text, RBDB:GetPlayerFaction(info.text), RBUI_SharingFrame.selectedName);
		if button ~= "CANCEL" then 
			info.func = RBUI.SharingFrame_DDChooseAlts_OnClick;
		end
		UIDropDownMenu_AddButton(info);
	end
	PlaySound("igMainMenuOpen");
end


function RBUI:SharingFrame_DDChooseAlts_OnClick()
	local alt = RBUI["AUButtons"][this.value].text;
	local fac = RBDB:GetPlayerFaction(alt);
	local who = RBUI_SharingFrame.selectedName;	
	if RBDB:AltUpdatesTo(alt, fac, who) then
		RBDB:SetAutoUpdateData(who, nil, alt)
	else
		RBDB:SetAutoUpdateData(who, 0, alt)
	end
end

--[[ OnShow() ]]--
function RBUI:SharingFrame_OnShow()
	PanelTemplates_SetNumTabs(this, 3);
	PanelTemplates_SetTab(this, 1);
	RBUI_SharingFrame.showList = 1;
	RBUI_SharingFrame.selectedID = 0;
	RBUI:SharingFrame_OnUpdate();
	RBUI:SubFrame_LoadOptions("RBUI_SharingFrame");
	RBUI:SubFrame_CheckBoxUpdate("RBUI_SharingFrame");
end

--[[ OnUpdate() ]]--
function RBUI:SharingFrame_OnUpdate()
	local id = RBUI_SharingFrame.showList;
	RB_ListContents = {};
	if not id then id = 1 end;
	if id == 3 then
	    for who, _ in pairs(RBDB:GetUpdatesFrom(RecipeBook.Globals.Player, RBDB:Faction_TextToDB(RecipeBook.Globals.Faction, false))) do
	        table.insert(RB_ListContents, who);
	    end
	else
		if id == 2 then id = 0 end;
		for who, o in pairs(RecipeBook_ShareOptions[RecipeBook.Globals.Realm]) do
		    if o == id then table.insert(RB_ListContents, string.sub(who, 4)) end;
		end
	end
	table.sort(RB_ListContents, function(a,b) return a < b end);
	if RBUI_SharingFrame.selectedID == 0 then -- First load :)
		RBUI_SharingFrame.selectedID = 1;
		RBUI_SharingFrame.selectedName = RB_ListContents[FauxScrollFrame_GetOffset(RBUI_SharingFrame_WhoScrollFrame) + 1];
	end
	RBUI:SharingFrameWhoUpdate();
end

--[[ OnClick() ]]--
function RBUI:SharingScrollFrame_OnClick(button)
	RBUI_SharingFrame.selectedID = this:GetID();
	RBUI_SharingFrame.selectedName = RB_ListContents[FauxScrollFrame_GetOffset(RBUI_SharingFrame_WhoScrollFrame) + this:GetID()];
	RBUI:SharingFrameWhoUpdate();
	if ( button == "LeftButton" ) then
		-- Nothing in particular.
	elseif ( button == "RightButton" ) and ( RBUI_SharingFrame.showList == 3 )then
		ToggleDropDownMenu(1, nil, RBUI_SharingFrame_DD_ChooseAlts, this:GetName())
	end
end

--[[ SharingFrameWhoUpdate() --> For FauxScrollFrame ]]--
function RBUI:SharingFrameWhoUpdate()
	local length = #RB_ListContents;
	local line, index, button, text;

	local offset = FauxScrollFrame_GetOffset(RBUI_SharingFrame_WhoScrollFrame);
	FauxScrollFrame_Update(RBUI_SharingFrame_WhoScrollFrame,length+1,RBUI.SharingFrame.NumWhos,RBUI.SharingFrame.WhoHeight);
	for line = 1,RBUI.SharingFrame.NumWhos,1 do
		-- RB_SearchResults[#] = {name, id, flavor text, {R-click tooltip = known data}, {Hover tooltip = blank}} - L-click is always ItemRef/Mats.
		index = offset + line;
		button = getglobal("RBUI_SharingFrame_ScrollFrameItem"..line);
		if index <= length then
			local name = RB_ListContents[index];
			getglobal("RBUI_SharingFrame_ScrollFrameItem"..line.."ButtonTextName"):SetText(name);
			button:Show()
			button:Enable()
			if name == RECIPEBOOK_ERR_NOSEARCHRESULT then button:Disable() end;
		else
			getglobal("RBUI_SharingFrame_ScrollFrameItem"..line.."ButtonTextName"):SetText("");
		    button:Hide()
		end

		if ( RBUI_SharingFrame.selectedID == line ) then
			button:LockHighlight();
		else
			button:UnlockHighlight();
		end

	end
end

--[[ SharingFrame_AddCharacter() --> Adds a character to the selected list ]]--
function RBUI:SharingFrame_AddCharacter()
	StaticPopup_Show("RECIPEBOOK_ADD_CHARACTER");
end

--[[ SharingFrame_DeleteCharacter() --> Deletes the selected character from the selected list ]]--
function RBUI:SharingFrame_DeleteCharacter()
	if RBUI_SharingFrame.showList == 3 then 
		RBDB:SetAutoUpdateData(RBUI_SharingFrame.selectedName, nil);
	else
		RBOptions:SetShareStatus(RBUI_SharingFrame.selectedName, nil);
	end
	
	local id = RBUI_SharingFrame.selectedID;
	if RBUI_SharingFrame.selectedID >= #RB_ListContents then 
		RBUI_SharingFrame.selectedID = #RB_ListContents - 1;
		RBUI_SharingFrame.selectedName = RB_ListContents[FauxScrollFrame_GetOffset(RBUI_SharingFrame_WhoScrollFrame) + RBUI_SharingFrame.selectedID];
	else
		RBUI_SharingFrame.selectedName = RB_ListContents[FauxScrollFrame_GetOffset(RBUI_SharingFrame_WhoScrollFrame) + RBUI_SharingFrame.selectedID + 1];
	end
	RBUI:SharingFrame_OnUpdate();
end


--[[ SharingFrame_RadioClick(button index) -- > lifted from SendMailRadioButton ]]--
function RBUI:SharingFrame_Radio_ADPClick(index, update)
	local row = math.ceil(index/3) -- Row 1 = 1, 2, 3; Row 2 = 4,5,6; Row 3 = 7,8,9
	local value = {"_Friend", "_Guild", "_Default"};

	index = math.fmod(index, 3) - 1; 
	if ( index == 1 ) then -- Accept
		getglobal("RBUI_SharingFrame_Radio_Row" .. row.."Accept"):SetChecked(1);
		getglobal("RBUI_SharingFrame_Radio_Row" .. row.."Decline"):SetChecked(0);
		getglobal("RBUI_SharingFrame_Radio_Row" .. row.."Prompt"):SetChecked(0);
	elseif ( index == 0 ) then -- Decline
		getglobal("RBUI_SharingFrame_Radio_Row" .. row.."Accept"):SetChecked(0);
		getglobal("RBUI_SharingFrame_Radio_Row" .. row.."Decline"):SetChecked(1);
		getglobal("RBUI_SharingFrame_Radio_Row" .. row.."Prompt"):SetChecked(0);
	elseif ( index == -1 ) then -- Prompt
		getglobal("RBUI_SharingFrame_Radio_Row" .. row.."Accept"):SetChecked(0);
		getglobal("RBUI_SharingFrame_Radio_Row" .. row.."Decline"):SetChecked(0);
		getglobal("RBUI_SharingFrame_Radio_Row" .. row.."Prompt"):SetChecked(1);
	else -- Should never execute. 
		return;
	end
	if not update then RBOptions:SetShareStatus(value[row], index) end; -- Set the share status for the share group to be the correct value.
	PlaySound("igMainMenuOptionCheckBoxOn");
end

--[[ SharingFrame_Radio_AUFreqClick(index) --> Set the frequency of AutoUpdates for this character. ]]--
function RBUI:SharingFrame_Radio_AUFreqClick(index, update)
	if index == 1 then 
		RBUI_SharingFrame_Radio_FreqDay:SetChecked(1);
		RBUI_SharingFrame_Radio_FreqWeek:SetChecked(0);
		RBUI_SharingFrame_Radio_FreqNever:SetChecked(0);
	elseif index == 2 then
		RBUI_SharingFrame_Radio_FreqDay:SetChecked(0);
		RBUI_SharingFrame_Radio_FreqWeek:SetChecked(1);
		RBUI_SharingFrame_Radio_FreqNever:SetChecked(0);
	elseif index == 0 then
		RBUI_SharingFrame_Radio_FreqDay:SetChecked(0);
		RBUI_SharingFrame_Radio_FreqWeek:SetChecked(0);
		RBUI_SharingFrame_Radio_FreqNever:SetChecked(1);
	end
	if not update then RBOptions:SetOption("Updates", "Freq", index) end;
end


--============================== BANKING FRAME ==============================--
--[[ OnShow() ]]--
function RBUI:BankingFrame_OnShow()
	RBUI_BankingFrame.selectedID = 1;
	RBUI:BankingFrame_OnUpdate();  -- List of banked items
	RBUI:SubFrame_LoadOptions("RBUI_BankingFrame");
	RBUI:SubFrame_CheckBoxUpdate("RBUI_BankingFrame");
end

--[[ OnUpdate() ]]--
function RBUI:BankingFrame_OnUpdate()
	RB_ListContents = RBBank:MakeBankList();
	RBUI:BankingFrameItemUpdate();
end

--[[ BankingFrameItemUpdatee() --> For FauxScrollFrame ]]--
function RBUI:BankingFrameItemUpdate()
	local length = #RB_ListContents;
	local line, index, button, text;

	local offset = FauxScrollFrame_GetOffset(RBUI_BankingFrame_ItemScrollFrame);
	FauxScrollFrame_Update(RBUI_BankingFrame_ItemScrollFrame,length+1,RBUI.BankingFrame.NumItems,RBUI.BankingFrame.ItemHeight);
	for line = 1,RBUI.BankingFrame.NumItems,1 do
		-- RB_ListContents[#] = {id, name, {who can make this} }
		index = offset + line;
		button = getglobal("RBUI_BankingFrame_ScrollFrameItem"..line);
		button:SetID(line);
		if index <= length then
			local name = RB_ListContents[index][2];
			getglobal("RBUI_BankingFrame_ScrollFrameItem"..line.."ButtonTextName"):SetText(name);
			getglobal("RBUI_BankingFrame_ScrollFrameItem"..line.."ButtonTextName"):SetTextColor(1,1,1);
			button.itemID = RB_ListContents[index][1];
			button.itemName = RB_ListContents[index][2];
			button.itemLink = RB_ListContents[index][3];
			button:Show()
			button:Enable()
		else
			getglobal("RBUI_BankingFrame_ScrollFrameItem"..line.."ButtonTextName"):SetText("");
		    button:Hide()
		end

		if ( RBUI_BankingFrame.selectedID == line ) then
			button:LockHighlight();
		else
			button:UnlockHighlight();
		end
	end
end

--[[ On Mouse Click ]]--
function RBUI:BankingFrame_ItemOnClick(button)
	RBUI_BankingFrame.selectedID = this:GetID();
	RBUI_BankingFrame.selectedName = RB_ListContents[FauxScrollFrame_GetOffset(RBUI_BankingFrame_ItemScrollFrame) + this:GetID()][1];
	if ( button == "LeftButton" ) then
		SetItemRef(RBOutput:MakeLink(this.itemID), this.itemLink, button)
	elseif ( button == "RightButton" ) then
		local banked = this.itemLink .. RECIPEBOOK_CHATFRAME_BANKED .. table.concat(RBDB:GetItemIsBanked(this.itemID), ", ");
		if ( ChatFrameEditBox:IsVisible() ) then
			ChatFrameEditBox:Insert(banked);
		else
			RBOutput:Print(banked, "output", nil, 0.25,0.5,1);
		end
	end
	RBUI:BankingFrameItemUpdate();
end

--[[ Manual delete of an item which persists in being banked ]]--
function RBUI:BankingFrame_DeleteItem()
	local id = RBUI_BankingFrame.selectedID;
	if id then 
		local button = getglobal("RBUI_BankingFrame_ScrollFrameItem"..RBUI_BankingFrame.selectedID);
		RBDB:RemoveHeldItem(button.itemID, RecipeBook.Globals.Player);
	end
	if id < #RB_ListContents then 
		RBUI_BankingFrame.selectedID = id;
	else
		RBUI_BankingFrame.selectedID = #RB_ListContents - 1;
	end
	RBUI:BankingFrame_OnUpdate();
end

--======================================== OPTIONS FRAME =================================--
--[[ OnShow() ]]--
function RBUI:OptionsFrame_OnShow()
	RBUI:SubFrame_LoadOptions("RBUI_OptionsFrame");
	RBUI:SubFrame_CheckBoxUpdate("RBUI_OptionsFrame");
end

--======================================== MINIMAP BUTTON =================================--
RBMM = {};
-- Minimap Menu 
	RBMM.Menu = {"RBMM_SEARCH", "RBMM_BROWSE", "RBMM_SHARE", "RBMM_BANK", "RBMM_CONFIG", "CANCEL"};
-- Minimap Buttons
	RBMM.Buttons = {};
	RBMM.Buttons["RBMM_SEARCH"] = {text = RECIPEBOOK_SFTAB_SEARCH, func = RBUI.ShowSearchFrame};
	RBMM.Buttons["RBMM_BROWSE"] = {text = RECIPEBOOK_SFTAB_BROWSE, func = RBUI.ShowBrowseFrame};
	RBMM.Buttons["RBMM_SHARE"] = {text = RECIPEBOOK_SFTAB_SHARING, func = RBUI.ShowShareFrame};
	RBMM.Buttons["RBMM_BANK"] = {text = RECIPEBOOK_SFTAB_BANKING, func = RBUI.ShowBankFrame};
	RBMM.Buttons["RBMM_CONFIG"] = {text = RECIPEBOOK_SFTAB_OPTIONS, func = RBUI.ShowOptionsFrame};

--[[ Minimap_Show() --> Creates a minimap button if it hasn't been done. ]]--
function RBMM:ShowButton()
	if not RBOptions:GetOption("MM", "Show") then return end; -- No show!
	
	if getglobal("RecipeBook_MMButton") then
		RecipeBook_MMButton:Show();
		RBMM:MoveButton();
	else -- Dynamically create the minimap button - adapted from MyMinimapButton, many thanks :)
		-- Button
		CreateFrame("Button","RecipeBook_MMButton", Minimap);
		RecipeBook_MMButton:SetWidth(31);
		RecipeBook_MMButton:SetHeight(31);
		RecipeBook_MMButton:SetFrameStrata("MEDIUM");
		RecipeBook_MMButton:SetMovable(true);
		RecipeBook_MMButton:SetHighlightTexture("Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight");
		-- Icon
		RecipeBook_MMButton:CreateTexture("RecipeBook_MMButtonIcon","BACKGROUND");
		RecipeBook_MMButtonIcon:SetTexture("Interface\\AddOns\\RecipeBook\\Icons\\Minimap");
		RecipeBook_MMButtonIcon:SetWidth(20);
		RecipeBook_MMButtonIcon:SetHeight(20);
		RecipeBook_MMButtonIcon:SetPoint("TOPLEFT",RecipeBook_MMButton,"TOPLEFT",7,-5);
		-- Border
		RecipeBook_MMButton:CreateTexture("RecipeBook_MMButtonOverlay","OVERLAY");
		RecipeBook_MMButtonOverlay:SetTexture("Interface\\Minimap\\MiniMap-TrackingBorder");
		RecipeBook_MMButtonOverlay:SetWidth(53);
		RecipeBook_MMButtonOverlay:SetHeight(53);
		RecipeBook_MMButtonOverlay:SetPoint("TOPLEFT",RecipeBook_MMButton,"TOPLEFT");
		-- Register for clicks
		RecipeBook_MMButton:RegisterForClicks("LeftButtonUp","RightButtonUp");
		RecipeBook_MMButton:RegisterForDrag("LeftButton");
		-- Scripts
		RecipeBook_MMButton:SetScript("OnClick", RBMM.ClickButton);
		RecipeBook_MMButton:SetScript("OnDragStart", function(...) RecipeBook_MMButton:StartMoving(); RecipeBookMMTimer:Show();end);
		RecipeBook_MMButton:SetScript("OnDragStop", function(...) RecipeBook_MMButton:StopMovingOrSizing(); RecipeBookMMTimer:Hide();end);
		RecipeBook_MMButton:SetScript("OnEnter", function(...) GameTooltip:SetOwner(this, "ANCHOR_BOTTOMLEFT"); GameTooltip:SetText(RECIPEBOOK_MMTXT, 1, 1, 1, 1); end);
		RecipeBook_MMButton:SetScript("OnLeave", function(...) GameTooltip:Hide(); end);
		-- Display!
		RecipeBook_MMButton:Show();
		RBMM:MoveButton();
	end
end
	
--[[ Minimap_Hide()  --> Hides the minimap frame]]--
function RBMM:HideButton()
	if RBOptions:GetOption("MM", "Show") then RBOptions:SetOption("MM", "Show", false) end;
	if getglobal("RecipeBook_MMButton") then
		RecipeBook_MMButton:Hide();
	end
end

	
--[[ MinimapUpdate(self, elapsed) --> Timer function ]]--
function RBMM:UpdateButton(self, elapsed)
	self.TimeSinceLastUpdate = self.TimeSinceLastUpdate + elapsed;
	if self.TimeSinceLastUpdate >= 0.01 then
		self.TimeSinceLastUpdate = 0;
		RBMM:DragButton();
	end
end

--[[ MinimapButtonDrag(): Drags the minimap button around. ]]--
-- run every .02 seconds only while mouse down on minimap button:
function RBMM:DragButton()
	local xpos,ypos = GetCursorPosition();
	local xmin,ymin = Minimap:GetLeft(), Minimap:GetBottom();
	xpos = xmin-xpos/Minimap:GetEffectiveScale()+70;
	ypos = ypos/Minimap:GetEffectiveScale()-ymin-70;
	RBOptions:SetOption("MM", "Pos", math.deg(math.atan2(ypos,xpos)));
	RBMM:MoveButton();    
end

--[[ MinimapButtonMove() --> Sets the position of the minimap button so it doesn't wander all over the screen. ]]--
function RBMM:MoveButton()
	local angle = RBOptions:GetOption("MM", "Pos") or 0;
	local xpos = 80*cos(angle);
	local ypos = 80*sin(angle);
	RecipeBook_MMButton:SetPoint("TOPLEFT",Minimap,"TOPLEFT",54-xpos,ypos-54);
end

--[[ MinimapButtonClick(button) --> If you click the Minimap button, here's what it does. --]]
function RBMM:ClickButton()
	if ( arg1 == "LeftButton" ) then
		if RBUI_MainFrame:IsVisible() then RBUI_MainFrame:Hide() 
		else RBUI:ShowBrowseFrame()
		end
	elseif ( arg1 == "RightButton" ) then
		ToggleDropDownMenu(1, nil, RecipeBookMM_Menu, "RecipeBook_MMButton");
	end
end

--[[OnLoad() ]]--
function RBMM:Menu_OnLoad()
	UIDropDownMenu_Initialize(this, RBMM.Menu_Initialize, "MENU");
end
--[[Initialize() --> Needed to make the initialize work correctly. ]]--
function RBMM:Menu_Initialize()
	local info = UIDropDownMenu_CreateInfo();
	-- Title Menu: 
	info.text = RECIPEBOOK_MM_MENUTITLE;
	info.isTitle = 1;
	info.notCheckable = 1;
	UIDropDownMenu_AddButton(info);
	
	-- Faction and player buttons
	for i, button in ipairs(RBMM.Menu) do
		local info = UIDropDownMenu_CreateInfo();
		local data = RBMM["Buttons"][button];
		if not data then data = UnitPopupButtons[button] end;
		info.text = data.text;
		info.value = data.text;
		info.owner = this:GetParent();
		info.func = data.func;
		info.notCheckable = 1;
		info.hasArrow = nil;
		UIDropDownMenu_AddButton(info, 1);
	end
	PlaySound("igMainMenuOpen");
end
