﻿RBParser = {};

function RBParser:BreakString(msg)
	local a = string.match(msg, "<P:([^%s>]+)>"); -- alt
	local s = tonumber(string.match(msg, "<T:(%d+)>")); -- skill
	local i = tonumber(string.match(msg, "<I:(%d+)>")); -- item
	local r = tonumber(string.match(msg, "<L:(%d+)>")); -- recipe id
	return a,s,i,r;
end

function RBParser:DistributeMessage(source, msg, dist)
	-- Verbose mode
	--RecipeBook:Debug("Message: "..msg);
	if RecipeBook.Parms.Debug.Verbose then RBOutput:Print(source.." sent: "..RB_HEXCOLOR["red"]..msg..RB_HEXCOLOR["end"].." via "..dist, "output", "RBFrame") end;
	
	if dist == "GUILD" then
		if RBOptions:GetOption("Updates", "Guild") then 
			RBParser:ParseSendFrom(msg, source, dist) -- No further validation needed.
		else
			return; -- No further parsing
		end
	end
	
	local ver = string.match(msg, "<V:(%d+.%d+.%d+%w*)>"); --version
	
	if ver then
		local function checkVer(v)
			local verT = {};
			for n in string.gmatch(v, "(%d+)") do table.insert(verT, tonumber(n)) end;
			local sver = string.match(v, "%d+.%d+.%d+(%w*)");
			if sver then table.insert(verT, sver)
			else table.insert(verT, "");
			end

			for k,v in ipairs(RECIPEBOOK_COMPATIBLE) do
				if verT[k] > v then return true -- 2 > 1
				elseif verT[k] < v then return false -- 1 < 2
				end;
			end
			return true;
		end
		
		if not checkVer(ver) then
			local alt = string.match(msg, "<P:([^%s>]+)>"); -- alt
			RBShare:SendCancel(source, alt, dist, RECIPEBOOK_SHARERROR_VERSION);
			return; -- Cancel session; there's a version mismatch.
		end
	end
	
	local trigger = string.match(msg, "^(.*):<|>"); -- Trigger for parse conditions
	-- if trigger then RecipeBook:Debug("Trigger: "..trigger) else RecipeBook:Debug("NO TRIGGER: "..msg) end;
	-- Initiate messages (initiate send, request update, sending autoupdate)
	if trigger == RECIPEBOOK_SHARETRIGGER_INITIATE or trigger == RECIPEBOOK_SHARETRIGGER_REQUEST or trigger == RECIPEBOOK_SHARETRIGGER_AUTOUPDATE or trigger == RECIPEBOOK_SHARETRIGGER_OPENSKILL then
		RBParser:ParseSendRequest(trigger, msg, source, dist);
	-- Cancel messages
	elseif trigger == RECIPEBOOK_SHARETRIGGER_CANCEL then
		RBShare:DoCancel(source, msg);
	elseif trigger == RECIPEBOOK_SHARETRIGGER_NOUPDATE then 
		local _,_,err = string.find(msg, "<E:([%w%s]*)>");
		if err then
			RBOutput:Print(err, "error");
		end
	end
	-- People we are sending tradeskills to
	if RBShare_SendQueueFrame.Outbound[source] or RBShare_SendQueueFrame.AutoSend[source] then
		RBParser:ParseSendTo(trigger, msg, source, dist);
	end
	-- People we are receiving tradeskills from
	if RB_Receiving.ReceiveQueue[source] or RB_Receiving.AutoReceiveQueue[source] then
		RBParser:ParseSendFrom(trigger, msg, source, dist);
	end
	
	return;
end

function RBParser:ParseSendRequest(trigger, msg, source, dist)
	if trigger == RECIPEBOOK_SHARETRIGGER_INITIATE then
		return RBShare:ConditionalAccept(source, msg, dist);
	elseif trigger == RECIPEBOOK_SHARETRIGGER_REQUEST then
		return RBShare:ConditionalUpdate(source, msg, dist);
	elseif trigger == RECIPEBOOK_SHARETRIGGER_AUTOUPDATE then
		return RBShare:ConditionalAutoUpdate(source, msg, dist);
	elseif trigger == RECIPEBOOK_SHARETRIGGER_OPENSKILL then
		local alt, skill = RBParser:BreakString(msg);
		return RBShare:ConditionalTradeskill(source, alt, skill, msg, dist);
	end;
end

function RBParser:ParseSendFrom(trigger, msg, source, dist)
	-- RecipeBook:Debug("Parse Send From");
	local alt, skill, item, rid = RBParser:BreakString(msg);
	local auto = false;
	-- Are we receiving data from this source, for this alt and skill?
	if RB_Receiving.AutoReceiveQueue[source] and RB_Receiving.AutoReceiveQueue[source][alt] ~= nil and RB_Receiving.AutoReceiveQueue[source][alt][skill] ~= nil then
		auto = true;
	elseif RB_Receiving.ReceiveQueue[source] and RB_Receiving.ReceiveQueue[source][alt] ~= nil and RB_Receiving.ReceiveQueue[source][alt][skill] ~= nil then
		-- OK to continue.
	elseif trigger == RECIPEBOOK_SHARETRIGGER_MATS then
		-- Don't need alt data
	else
		return;
	end
	
	-- We are being sent an item!
	if trigger == RECIPEBOOK_SHARETRIGGER_ITEM then 
		local diff =  tonumber(string.match(msg, "<D:(%d+)>"));
   		if auto then RB_Receiving.AutoReceiveQueue[source][alt][skill][rid] = {item, diff};
		else RB_Receiving.ReceiveQueue[source][alt][skill][rid] = {item, diff};
		end

		return RBShare:ProcessItemInfo(source, alt, skill, item, rid, msg, dist)
	-- We are being sent the last item.
	elseif trigger == RECIPEBOOK_SHARETRIGGER_LASTITEM then	
		local fac = RBDB:GetPlayerFaction(alt);
		if auto then 
			for rid, info in pairs(RB_Receiving.AutoReceiveQueue[source][alt][skill]) do
				RBDB:AddKnownData(info[1], rid, alt, info[2], fac);
			end
			RBShare:SendUnqueuedMessage(source, string.format(RECIPEBOOK_SHARE_OKITEMS, alt, skill, item), dist)
		else
			for rid, info in pairs(RB_Receiving.ReceiveQueue[source][alt][skill]) do
				RBDB:AddKnownData(info[1], rid, alt, info[2], fac);
			end
			RBShare:SendUnqueuedMessage(source, string.format(RECIPEBOOK_SHARE_OKITEMS, alt, skill, item), dist)
		end
	-- We are being sent materials for an item
	elseif trigger == RECIPEBOOK_SHARETRIGGER_MATS then
		local matT = {};
		for id, num in string.gmatch(msg, "<M:(%d+)#(%d+)>") do
		    matT[id] = num;
		end
		RBDB:AddMaterialsData(item, rid, matT);
		RBShare:SendUnqueuedMessage(source, string.format(RECIPEBOOK_SHARE_ACKMATS , skill, item, rid), dist);
	-- That's it, close tradeskill.
	elseif trigger == RECIPEBOOK_SHARETRIGGER_TERMINATE then
		local num = string.match(msg, "<N:(%d+)>");
		local fac = RBDB:GetPlayerFaction(alt);
		RBShare:SendUnqueuedMessage(source, string.format(RECIPEBOOK_SHARE_TENFOUR, alt, skill), dist);
		if RBDB:GetPlayerTradeskillInfo(alt, fac, skill, "show") ~= false then
			RBDB:SetPlayerTradeskillInfo(alt, fac, skill, "show", true);
		end
		if num then
			RBDB:SetPlayerTradeskillInfo(alt, fac, skill, "numitems", tonumber(num));
		end
		-- Regularly queued tradeskills
		if RB_Receiving.ReceiveQueue[source] then
			RB_Receiving.ReceiveQueue[source][alt][skill] = nil;
			if next(RB_Receiving.ReceiveQueue[source][alt]) == nil then
				RB_Receiving.ReceiveQueue[source][alt] = nil;
			end
			if next(RB_Receiving.ReceiveQueue[source]) == nil then
				RB_Receiving.ReceiveQueue[source] = nil;
			end
			RBOutput:Print(string.format(RECIPEBOOK_SHAREMSG_RECEIVEDALL, alt, RBDB:Skill_DBToText(skill), source), "info");
		-- AutoQueue
		elseif RB_Receiving.AutoReceiveQueue[source] then
			RB_Receiving.AutoReceiveQueue[source][alt][skill] = nil;
			if next(RB_Receiving.AutoReceiveQueue[source][alt]) == nil then
				RB_Receiving.AutoReceiveQueue[source][alt] = nil;
			end
			if next(RB_Receiving.AutoReceiveQueue[source]) == nil then
				RB_Receiving.AutoReceiveQueue[source] = nil;
			end
		end
	end
end

function RBParser:ParseSendTo(trigger, msg, source, dist)
	-- RecipeBook:Debug("Parse Send To");
	local alt, skill, item, rid = RBParser:BreakString(msg);
	local auto = false;
	if RBShare_SendQueueFrame.AutoSend[source] then auto = true end; -- AutoUpdate.
	
	-- Accept Share/AutoUpdate
	if trigger == RECIPEBOOK_SHARETRIGGER_ACCEPT then 
		RBShare_SendInitiateFrame.Pending[source] = nil; -- No need to timeout
		RBShare:QueueTradeskills(source, alt, auto);
	--Awaiting prompt - do not timeout
	elseif trigger == RECIPEBOOK_SHARE_PROMPTING then
		RBShare_SendInitiateFrame.Pending[source] = nil; -- No need to timeout
	-- Accept a particular skill
	elseif trigger == RECIPEBOOK_SHARETRIGGER_ACCEPTSKILL then
		RBShare:QueueItems(source, alt, skill, dist);
	-- Decline share/AutoUpdate
	elseif trigger == RECIPEBOOK_SHARETRIGGER_DECLINE then
		-- Parse error and report.
		local _,_,err = string.find(msg, "<E:([%w%s]*)>");
		if err then
			RecipeBook:Debug("Share declined by "..source..": "..err);
			RBOutput:Print(err, "error");
		else
			RecipeBook:Debug("Share declined by "..source..": "..msg);
		end
		RBShare_SendInitiateFrame.Pending[source] = nil;
		RBShare_SendQueueFrame.Outbound[source][alt] = nil;
		if next(RBShare_SendQueueFrame.Outbound[source]) == nil then RBShare_SendQueueFrame.Outbound[source] = nil end;
	elseif (RBShare_SendInitiateFrame.Pending[source] or RBShare_SendQueueFrame.AutoSend[source]) and trigger == RECIPEBOOK_SHARETRIGGER_AUDECLINE then 
		-- Silently fail.
		RecipeBook:Debug("Share declined by "..source..": "..msg);
		RBShare_SendInitiateFrame.Pending[source] = nil;
		RBShare_SendQueueFrame.AutoSend[source][alt] = nil;
		if next(RBShare_SendQueueFrame.AutoSend[source]) == nil then RBShare_SendQueueFrame.AutoSend[source] = nil end;
	-- Decline a particular skill (silent)
	elseif trigger == RECIPEBOOK_SHARETRIGGER_DECLINESKILL then
		if RBShare_SendQueueFrame.AutoSend[source] then
			RBShare_SendQueueFrame.AutoSend[source][alt][skill] = nil;
			if next(RBShare_SendQueueFrame.AutoSend[source][alt]) == nil then RBShare_SendQueueFrame.AutoSend[source][alt] = nil end;
			if next(RBShare_SendQueueFrame.AutoSend[source]) == nil then RBShare_SendQueueFrame.AutoSend[source] = nil end;
		else
			RBShare_SendQueueFrame.Outbound[source][alt][skill] = nil;
			if next(RBShare_SendQueueFrame.Outbound[source][alt]) == nil then RBShare_SendQueueFrame.Outbound[source][alt] = nil end;
			if next(RBShare_SendQueueFrame.Outbound[source]) == nil then RBShare_SendQueueFrame.Outbound[source] = nil end;
			RBOutput:Print(string.format(RECIPEBOOK_SHARERROR_NOTRACKING, source, RBDB:Skill_DBToText(skill), alt), "info");
		end
	-- Send materials for an item
	elseif trigger == RECIPEBOOK_SHARETRIGGER_SENDMATS then 
		RBShare:QueueMaterials(source, item, skill, dist);
	-- Acknowledge that item and mats are done.
	elseif trigger == RECIPEBOOK_SHARETRIGGER_OKITEMS and ( (auto and item == RBShare_SendQueueFrame.AutoSend[source][alt][skill]) or ((not auto) and (item == RBShare_SendQueueFrame.Outbound[source][alt][skill])) ) then 
		RBShare:SendQueuedMessage(source, string.format(RECIPEBOOK_SHARE_TERMINATE, alt, skill, RBDB:GetPlayerTradeskillInfo(alt, RBDB:GetPlayerFaction(alt), skill, "numskills")), dist)
	-- Close tradeskill
	elseif trigger == RECIPEBOOK_SHARETRIGGER_TENFOUR then
		if auto then
		    RBShare_SendQueueFrame.AutoSend[source][alt][skill] = nil;
			if next(RBShare_SendQueueFrame.AutoSend[source][alt]) == nil then 
				RBShare_SendQueueFrame.AutoSend[source][alt] = nil;
				RBAU:AUCompleted(source);
			end
			if next(RBShare_SendQueueFrame.AutoSend[source]) == nil then
			    RBShare_SendQueueFrame.AutoSend[source] = nil;
			end
		else
			RBOutput:Print(string.format(RECIPEBOOK_SHAREMSG_TERMINATE, RBDB:Skill_DBToText(skill), alt, source), "info");
			RBShare_SendQueueFrame.Outbound[source][alt][skill] = nil;
			if next(RBShare_SendQueueFrame.Outbound[source][alt]) == nil then
				RBShare_SendQueueFrame.Outbound[source][alt] = nil;
				RBAU:AUCompleted(source);
			end
			if next(RBShare_SendQueueFrame.Outbound[source]) == nil then
				RBShare_SendQueueFrame.Outbound[source] = nil;
			end
		end
	end
end
