--[[ RECIPE BOOK OUTPUT :
Contains most of the functions used for displaying data to the user 

]]--

--============================== VARIABLES ==============================--
RecipeBook.Parms.ChatFrameUpdated = false;
RBOutput = {};

--============================== FUNCTIONS ==============================--
function RBOutput:ModifyTooltip(tooltip, lines)
	if not RBOptions:GetOption("Output", "TT") then return false end;
	if not tooltip then return false end;
	if (type(tooltip) == "string") then tooltip = getglobal(tooltip) end;
	if #lines > 0 then
		-- tooltip:AddLine("\n",nil,nil,nil, 1);
		for _, info in ipairs(lines) do
			local r,g,b = unpack(info[2]);
		    tooltip:AddLine(info[1], r, g, b, 1);
	end 
	tooltip:Show();
	end
	return true;
end

--[[ RecipeToTooltip(tooltip, aknow, alearn, ahave, banked) --> Formats data for the tooltip
	Returns: nothing ]]--
function RBOutput:GenerateTooltip(aknow, alearn, ahave, banked, canmake)
	local textT = {};

	if next(RecipeBook_ItemNameDB) == nil then
		return {{RECIPEBOOK_ERR_DATANOTLOADED, {1, 0, 0}}};
	end

	if aknow and next(aknow) then
	    table.insert(textT, {RECIPEBOOK_KNOWNBY..table.concat(aknow, ", "), RBOptions:GetOption("TipC", "K")});
	end
	if alearn and next(alearn)  then
		table.insert(textT, {RECIPEBOOK_CANLEARN .. table.concat(alearn, ", "), RBOptions:GetOption("TipC", "C")});
	end
	if ahave and next(ahave) then
		table.insert(textT, {RECIPEBOOK_WILLLEARN .. table.concat(ahave, ", "), RBOptions:GetOption("TipC", "W")});
	end
	if banked and next(banked) then
		table.insert(textT, {RECIPEBOOK_ISBANKED .. table.concat(banked, ", "), RBOptions:GetOption("TipC", "B")});
	end
	if canmake and next(canmake) then
		table.insert(textT, {RECIPEBOOK_CANMAKE .. table.concat(canmake, ", "), RBOptions:GetOption("TipC", "M")});
	end

	return textT;
end

function RBOutput:ModifyChatframe(lines)
	if not RBOptions:GetOption("Output", "CF") or RecipeBook.Parms.ChatFrameUpdated then return end;
	local chatframe = RBOutput:GetRBFrame();
	for _, info in ipairs(lines) do
	    RBOutput:Print(info[1], "output", chatframe, unpack(info[2]))
	end
end;
	

--[[ RecipeToChatframe(tooltip, aknow, alearn, ahave, banked) --> Formats and outputs data to the chatframe
	Returns: nothing ]]--
function RBOutput:RecipeToChatFrame(iname, aknow, alearn, ahave, banked, canmake)
	local textT = {};

	if aknow then
		table.insert(textT, {iname .. RECIPEBOOK_CHATFRAME_KNOWNBY .. aknow, {0, 1,0}})
	else
		table.insert(textT, {iname .. RECIPEBOOK_CHATFRAME_NONEKNOWN, {1,0,0}});
	end
	if alearn then
		table.insert(textT, {iname .. RECIPEBOOK_CHATFRAME_CANLEARN .. alearn, {0, 1,0}});
		RecipeBook.Parms.ChatFrameUpdated = true;
	else
		table.insert(textT, {iname .. RECIPEBOOK_CHATFRAME_NONELEARN, {1,0,0}});
	end
	if ahave then
		table.insert(textT, {iname .. RECIPEBOOK_CHATFRAME_WILLLEARN .. ahave, {0, 1,0}});
		RecipeBook.Parms.ChatFrameUpdated = true;
	else
		table.insert(textT, {iname .. RECIPEBOOK_CHATFRAME_NONEWILLLEARN, {1,0,0}});
	end
	if banked then
		table.insert(textT, {iname .. RECIPEBOOK_CHATFRAME_BANKED .. banked, {0, 1,0}});
		RecipeBook.Parms.ChatFrameUpdated = true;
	else
		table.insert(textT, {iname .. RECIPEBOOK_CHATFRAME_NOTBANKED, {1,0,0}});
	end

	if canmake then
		table.insert(textT, {iname .. RECIPEBOOK_CHATFRAME_CANMAKE .. canmake, {1, 1,1}});
		RecipeBook.Parms.ChatFrameUpdated = true;
	end

	
	return textT;
end

--[[ PlayerNameColor(faction) --> Returns the color for a faction. ]]--
function RBOutput:PlayerNameColor(fac)
    local ofac = RBDB:Faction_TextToDB(RecipeBook.Globals.OFaction, false);
	if (math.fmod(fac, 10) > 0) then -- Shared data
		if fac == ofac + 1 then -- Opposite faction from player, shared
			return RBOptions:GetOption("TipC", "SOF");
		else -- Same faction as player, shared
			return RBOptions:GetOption("TipC", "SSF");
		end
	elseif fac == ofac then -- Opposite faction as player, alt
		return RBOptions:GetOption("TipC", "AOF");
	else -- Same faction as player, alt
		return RBOptions:GetOption("TipC", "ASF");
	end
end

--============================== Hooked functions ==============================--
--[[ GameTooltip_OnHide --> Resets variables when GameTooltip is hidden. ]]--
function RBOutput:HideGameTooltip()
--	RecipeBook.Parms.ChatFrameUpdated = false;
end

--[[ SetItemRef ]]--
function RBOutput:SetItemRef(link, name, button)
	RecipeBook:DoHookedFunction("ItemRefTooltip");
end

--[[ GetRBFrame() ]]--
function RBOutput:GetRBFrame()
	for i = 1, NUM_CHAT_WINDOWS do
	    name, _, _, _, _, _, shown, lock, dock = GetChatWindowInfo(i);
		if name == "Recipe Book" then
			local frame = getglobal("ChatFrame"..i)
			local tab = getglobal("ChatFrame"..i.."Tab");
			if not shown then
				tab:Show();
				SetChatWindowShown(i, 1)
			end
			return frame;
		end;
	end
	FCF_OpenNewWindow("Recipe Book");
	local frame = RBOutput:GetRBFrame();
	ChatFrame_RemoveAllMessageGroups(frame);
	return frame;
end


--[[ Print(message, error code, [chatframe], [r], [g], [b]) --> Prints a message to the default/passed chatframe. Optional codes include color
	Print modes: 
	"info" - RB informational messages, with RecipeBook prefix
	"output" - player-requested output
	"help" - help file information
	"error" - RB errors!
	"none" - No prefix, unspecified message
	Returns: Nothing ]]--
function RBOutput:Print(msg, prefix, frame, r,g,b)
	if not msg then return end;
	
	if prefix == "info" and not RBOptions:GetOption("Output", "Info") then return end; -- Suppress non-error messages
	
	if not frame then
		frame = DEFAULT_CHAT_FRAME;
	elseif frame == "RBFrame" then
	    frame = RBOutput:GetRBFrame();
	else
		-- Code goes here to select frame.
	end;
	if not r or not g or not b then
		if not r then r =1; g = 1; b = 1;
		elseif not g then g = 1; b = 1;
		elseif not b then b = 1;
		end
	end
	
	if prefix == "error" then prefix = RECIPEBOOK_ERROR_PREFIX;
	elseif prefix == "info" then prefix = RECIPEBOOK_PREFIX;
	else prefix = "";
	end

   	if type(msg) == "table" then
		for _,u in pairs(msg) do
			frame:AddMessage(prefix..u, r, g, b)
		end
	else
		frame:AddMessage(prefix..msg, r, g, b);
	end
end

--[[ Debug(message) : Prints a debug message if Debug is on. 
Accepts {message} as well as a string message]]--
function RBOutput:Debug(message)
	if(RecipeBook.Parms.Debug.Enabled) then
		if type(message) == "table" then message = table.concat(message, " ") end;
		if message then	DEFAULT_CHAT_FRAME:AddMessage("|cff00cc00<RecipeBook Debug:> |r"..message) end;
	end
end

function RecipeBook:Debug(message)
	return RBOutput:Debug(message);
end;

--============================== [ UTILITY FUNCTIONS FOR OUTPUT ] ==============================--

--[[ Words(msg) --> Splits a string into a table of words.
	Returns: table words ]]--
function RBOutput:Words(msg)
	local words = {};
	string.gsub(msg, "%S+", function(a) table.insert(words, a) end);
	if next(words) == nil then words = {msg} end;
	return words;
end

function RBOutput:Capitalize(text)
	if not text then return "" end;
	if string.match(string.sub(string.lower(text), 1, 1), "[a-z]") then
	    text = string.gsub(string.lower(text), "^%l", string.upper);
	else
	    text = string.upper(string.sub(text, 1, 2))..string.lower(string.sub(text, 3));
	end
	return text;
end

function RBOutput:MakeLink(id)
	id = "item:"..id..":0:0:0:0:0:0:0:0";
	return id;
end
