--[[ RECIPE BOOK BANKING : 
Contains most of the functions used for dealing with banking recipes and subsequently displaying them
See RecipeBookDBFunctions for:
	GetItemIsBanked(item)
	AddBankedItem(id, who, bag)
	RemoveBankedItem(id, who)

]]--

--============================== VARIABLES ==============================--
RBBank = {};
RBBank.FrameOpen = false;

--============================== FUNCTIONS ==============================--

--[[ UpdateBags() --> Scans player's bags and updates recipes in them ]]--
function RBBank:UpdateBags()
	RecipeBook:Debug("Update Bags");
	if not RBOptions:GetOption("Bank", "Bags") then return end; -- Option off.
	local bag, slot;
	local valid, skill, link;
	local recipes = {};
	-- Get all the recipes in the bags
	for bag = 0, NUM_BAG_SLOTS do
		for slot = 1, GetContainerNumSlots(bag) do
		    link = GetContainerItemLink(bag,slot); -- Get this link
		    if RecipeBook:ParseItemLink(link) then -- It's a recipe, currently in the bags.
          		link = RBDB:Link_TextToDB(link);
		        recipes[link] = true;
		        RBDB:AddHeldItem(link, RecipeBook.Globals.Player, false); -- Adds to bank if needed
			end
		end
	end

	-- Now clean up the bags.
	if not RecipeBook_CharacterDB[RecipeBook.Globals.Realm]["Held Items"] or not RecipeBook_CharacterDB[RecipeBook.Globals.Realm]["Held Items"][RecipeBook.Globals.Player] or next(RecipeBook_CharacterDB[RecipeBook.Globals.Realm]["Held Items"][RecipeBook.Globals.Player]) == nil then return end;
	
	for item, data in pairs(RecipeBook_CharacterDB[RecipeBook.Globals.Realm]["Held Items"][RecipeBook.Globals.Player]) do
	    if not data.Bank and not recipes[item] then -- Not in the bank, and not in the new baglist
            RBDB:RemoveHeldItem(item, RecipeBook.Globals.Player);
		end
	end
end

--[[ UpdateBank() --> Scans player's bank and bags and updates recipes in them ]]--
function RBBank:UpdateBank()
	RecipeBook:Debug("Update Bank");
	if not RBOptions:GetOption("Bank", "Bank") then return end;
	
	local recipes = {};
	
	local function dobank(link)
	    if RecipeBook:ParseItemLink(link) then -- It's a recipe, currently in the bank.
        	link = RBDB:Link_TextToDB(link);
		    recipes[link] = true;
		    RBDB:AddHeldItem(link, RecipeBook.Globals.Player, true); -- Adds to bank if needed
		end
	end

	-- Bank slots
	for i = 1, NUM_BANKGENERIC_SLOTS do
	  dobank(GetContainerItemLink(BANK_CONTAINER, i));
	end
	-- Bank Bags
	for b = 1 + NUM_BAG_SLOTS, NUM_BAG_SLOTS + NUM_BANKBAGSLOTS do
		for i = 1, GetContainerNumSlots(b) do
            dobank(GetContainerItemLink(b, i));
		end
	end

	if not RecipeBook_CharacterDB[RecipeBook.Globals.Realm]["Held Items"] or not RecipeBook_CharacterDB[RecipeBook.Globals.Realm]["Held Items"][RecipeBook.Globals.Player] or next(RecipeBook_CharacterDB[RecipeBook.Globals.Realm]["Held Items"][RecipeBook.Globals.Player]) == nil then
		-- Do not do bag cleanup on empty bags
	else
		-- Clean up the bags.
		for item, data in pairs(RecipeBook_CharacterDB[RecipeBook.Globals.Realm]["Held Items"][RecipeBook.Globals.Player]) do
		    if data.Bank and not recipes[item] then -- Not in the bank; move to bags for cleanup.
		    	RecipeBook_CharacterDB[RecipeBook.Globals.Realm]["Held Items"][RecipeBook.Globals.Player][item].Bank = nil;
			end
		end
	end
	RBBank:UpdateBags(); -- AFTER bank has been completely updated, run bag scan.
end


--[[ OpenBank(who) --> Executes when BankFrame opens ]]--
function RBBank:OpenBank()
	RBBank.FrameOpen = true;
end

--[[ CloseBank() --> Executes when BankFrame closes ]]--
function RBBank:CloseBank()
	if RBBank.FrameOpen then
		RBBank:UpdateBank();
		RBBank.FrameOpen = false;
	end
end

--[[ MakeBankList() --> Makes a list of all recipes banked on this faction/server. ]]--b
function RBBank:MakeBankList()
	-- No banked items.
	if not RecipeBook_CharacterDB[RecipeBook.Globals.Realm]["Held Items"] then return {} end;
	-- Banked items exist.
	local itemT = {};
	for who, items in pairs(RecipeBook_CharacterDB[RecipeBook.Globals.Realm]["Held Items"]) do
		for item, _ in pairs(items) do
			if not itemT[item] then -- Not already parsed.
				local name = GetItemInfo(item);
				if name then 
					itemT[item] = true;
				else
					itemT[item] = false;
				end; -- uncached recipes are still present but will display as number only.
			end
		end
	end
	local returnT = {};
	for id, cached in pairs(itemT) do
		if cached then 
			local name, link = GetItemInfo(id);
			table.insert(returnT, {id, name, link});
		else
			table.insert(returnT, {id, "Uncached: "..id, RBOutput:MakeLink(id)});
		end

	end
	if #returnT > 0 then 
		table.sort(returnT, function(a,b) return a[2] < b[2] end)
	end
	return returnT; -- {item number, item name, item link}
end