﻿--[[ RecipeBook AutoUpdate:
This file contains working files for the AutoUpdate function of Recipe Book. ]]--

--============================== VARIABLES ==============================--
local RB_AUQueue = {};
RBAU = {};


--============================== FUNCTIONS ==============================--
function RBAU:AutoUpdate()
	RBAU:BuildAUQueue();
	RBAU:ProcessAUQueue();
end

--[[ GuildAutoUpdate() --> After necessary checks, runs an auto-update to the queue. ]]--
function RBAU:GuildAutoUpdate()
	if not IsInGuild() then return end;
	if not RBOptions:GetOption("Updates", "SendGuild") then return end;
	RBAU:InitiateAU("GUILD");
end

--[[ DueForUpdate(who) --> Checks to see if a particular player is in the AutoUpdate queue. ]]--
function RBAU:DueForUpdate(who)
	if RB_AUQueue[who] then return true else return false end;
end

--[[ AddToQueue(who, last update) --> Adds a player to the AutoUpdate Queue, after checking their AutoUpdate data. ]]--
function RBAU:AddToQueue(who, last)
	local interval = RBOptions:GetOption("Updates", "Freq");
	if interval == 1 then interval = 86400; -- Daily
	elseif interval == 2 then interval = 604800; -- Weekly
	else -- interval = 0 or invalid data :)
		return;
	end
	if time() - last < interval then -- Do not add to queue; has been updated recently.
		return false; 
	else
		RB_AUQueue[who] = true;
		return true;
	end
end

--[[ BuildAUQueue() --> Builds the AU Queue :) ]]--
function RBAU:BuildAUQueue()
	for who, when in pairs(RBDB:GetUpdatesFrom(RecipeBook.Globals.Player, RBDB:Faction_TextToDB(RecipeBook.Globals.Faction, false))) do
		RBAU:AddToQueue(who, when);
	end
end

--[[ ProcessNextQueue() --> Starts the AutoUpdate for a particular player then iterates to the next person in the queue. ]]--
function RBAU:ProcessAUQueue()
	-- RecipeBook:Debug("Processing AutoUpdate Queue");
	for who, _ in pairs(RB_AUQueue) do
		-- RecipeBook:Debug("Processing: "..who);
		RBAU:InitiateAU(who);
	end
end

--[[ InitiateAutoUpdate(who) --> Initiates an AutoUpdate request for a player ]]--
function RBAU:InitiateAU(target)
	RecipeBook:Debug("Initiate AutoUpdate for: "..target);
	if RBShare_SendInitiateFrame.Pending[target] or RBShare_SendQueueFrame.Outbound[target] ~= nil or RBShare_SendQueueFrame.AutoSend[target] ~= nil then return end; -- Already sending to this player.
	local alt = RecipeBook.Globals.Player;
	if target == "GUILD" then
		-- Send queue for tradeskills; there is no accept.
		if RecipeBook:GuildOnline() then
			if RBShare_SendQueueFrame.AutoSend[target] == nil then RBShare_SendQueueFrame.AutoSend[target] = {} end;
			RBShare_SendQueueFrame.AutoSend[target][alt] = {};
			RBShare:QueueTradeskills(target, alt, true);
		else
			RecipeBook:Debug("No Guild Members Available.");
		end
	else
		if RBShare_SendQueueFrame.AutoSend[target] == nil then RBShare_SendQueueFrame.AutoSend[target] = {} end;
		RBShare_SendQueueFrame.AutoSend[target][alt] = {};
		RBShare:SendQueuedMessage(target, string.format(RECIPEBOOK_SHARE_AUTOUPDATE, alt));
		RBShare_SendInitiateFrame.Pending[target] = RBShare_SendInitiateFrame.timeSinceLastUpdate + RECIPEBOOK_SENDINITIATEFRAME_SENDELAY;
		if not RBShare_SendInitiateFrame:IsVisible() then RBShare_SendInitiateFrame:Show() end;
	end;
end

--[[ AUCompleted(who)--> When an AutoUpdateAccept is recieved, mark the skill as being updated. ]]--
function RBAU:AUCompleted(who)
	if RBDB:AltUpdatesTo(RecipeBook.Globals.Player, RBDB:Faction_TextToDB(RecipeBook.Globals.Faction, false), who) then 
		RBDB:SetAutoUpdateData(who, time());
		RB_AUQueue.who = nil;
	end
end

