--[[ RECIPE BOOK AUCTIONS : 
Contains most of the functions used for dealing with the auction house and merchants

]]--
--============================== VARIABLES ==============================--
RBAuction = {};
--============================== FUNCTIONS ==============================--
--[[ HookAuctionFunctions() --> AH functions are not hooked until the AH is in use; this seems to avoid some compatibility problems. ]]--
function RBAuction:HookAuctionFunctions()
	if RecipeBook.Parms.AddOnsLoaded["Auction House"] then return end; -- No duplicating.

	hooksecurefunc("AuctionFrameItem_OnEnter", RecipeBook_DefaultHook)
	hooksecurefunc("AuctionFrameBrowse_Update", RBAuction.AuctionFrameBrowse_Update);

	if IsAddOnLoaded("AuctionFilterPlus") and not RecipeBook.Parms.AddOnsLoaded["AuctionFilterPlus"] then
		-- This may need to be reworked depending on how I'm doing hooks.
		if afp_AuctionFrameBrowse_Update ~= nil then
			RBAuction_OldAFPAuctionFrameBrowse_Update = afp_AuctionFrameBrowse_Update;
			afp_AuctionFrameBrowse_Update = RBAuction.AuctionFrameBrowse_Update;
			RecipeBook.Parms.AddOnsLoaded["AuctionFilterPlus"] = true;
		end
	end

	RecipeBook.Parms.AddOnsLoaded["Auction House"] = true;
	this:UnregisterEvent("AUCTION_HOUSE_SHOW");  -- Only runs once.
end

--[[ MerchantFrame_UpdateMerchantInfo() --> When a merchant frame is opened, colors items ]]--
function RBAuction:MerchantFrame_UpdateMerchantInfo()
	if not RBOptions:GetOption("AucC", "Show") then return end;
    local total = GetMerchantNumItems() +1;
	local valid, skill, aknow, alearn, ahave, banked, rank, spec, fac, reput, makes, use, link;
	for i=1, MERCHANT_ITEMS_PER_PAGE, 1 do
	    local j = (((MerchantFrame.page - 1) * MERCHANT_ITEMS_PER_PAGE) + i);
	    if j < total then
	        link = GetMerchantItemLink(j);
	        valid, skill, id = RecipeBook:ParseItemLink(link);
			if valid then -- this is a recipe.
				local who = RBOptions:GetOption("TipC", "ASF")..UnitName("player").."|r";
				RecipeBookTooltip:SetMerchantItem(j);
	            rank, spec, rep, honor, makes = RecipeBook:GetSkillInfo(RecipeBookTooltip, skill);
				makes, rid = RBDB:Item_TextToDB(makes);
				if rank then
					banked = RBDB:GetItemIsBanked(RBDB:Link_TextToDB(link));
					if banked and RBOptions:GetOption("Bank", "Show") then -- Blackout banked recipes.
					    r,g,b = RBAuction:BankedColor(banked);
					else
						local known = RBDB:GetKnownInfo(makes, skill, rid);
						aknow, alearn, ahave = RecipeBook:MatchRecipeData(makes, skill, rank, spec, rep, honor, known);
						r,g,b = RBAuction:IconColor(aknow, alearn, ahave, who)
					end
					local but = getglobal("MerchantItem"..i.."ItemButton");
					SetItemButtonTextureVertexColor(but, r,g,b);
					SetItemButtonNormalTextureVertexColor(but, r,g,b);
				end
			end
	    end
	end
end

--[ AuctionFrameBrowse_Update : Colors Auction items. ]--
function RBAuction:AuctionFrameBrowse_Update()
	-- Exit if not coloring auctions.
 	if not RBOptions:GetOption("AucC", "Show") then return end;
	-- If Auctioneer is scanning then don't color code.
	if IsAddOnLoaded("Auctioneer") and Auctioneer.ScanManager.IsScanning() then return end;
	if RecipeBook.Parms.AddOnsLoaded["Auc-Advanced"]then
		if AucAdvanced.Settings.GetSetting("util.compactui.activated") then
			RecipeBook.Parms.AddOnsLoaded["Auctioneer CompactUI"] = true;
		else
			RecipeBook.Parms.AddOnsLoaded["Auctioneer CompactUI"] = false;
		end
		if AucAdvanced.Scan.IsScanning() then return end;
	end

	-- AuctionFilter Plus is not compatible with AucAdvanced; don't try to run them together.
	if (RecipeBook.Parms.AddOnsLoaded["AuctionFilterPlus"]) and not RecipeBook.Parms.AddOnsLoaded["Auctioneer CompactUI"] then
		RBAuction_OldAFPAuctionFrameBrowse_Update();
	end

	local offset = FauxScrollFrame_GetOffset(BrowseScrollFrame);
	local valid, skill;
	local aknow, alearn, ahave, banked, who;
	local rank, spec, rep, honor, makes, link, item;

	for i=1, NUM_BROWSE_TO_DISPLAY, 1 do

	-- AuctionFilter Plus compatibility
		if (RecipeBook.Parms.AddOnsLoaded["AuctionFilterPlus"]) and next(afp_BrowseList) ~= nil and (afp_BrowseList[i] ~= nil) then
   			offset = afp_BrowseList[i];
		end

		if RecipeBook.Parms.AddOnsLoaded["Auctioneer CompactUI"] and getglobal("BrowseButton"..i):IsVisible() then
		    trueID = getglobal("BrowseButton"..i).id;
		else
			trueID = getglobal("BrowseButton"..i):GetID() + offset;
		end
		link = GetAuctionItemLink("list", trueID);
		valid, skill, item = RecipeBook:ParseItemLink(link);
		if valid then -- this is a recipe.
			RecipeBookTooltip:SetAuctionItem("list", trueID);
			rank, spec, rep, honor, makes = RecipeBook:GetSkillInfo(RecipeBookTooltip, skill);
			makes, rid = RBDB:Item_TextToDB(makes);
			if rank then
			    if RecipeBook.Parms.AddOnsLoaded["Auctioneer CompactUI"] then
					tex = getglobal("BrowseButton"..i).Icon;
			    else
					tex = getglobal("BrowseButton"..i.."ItemIconTexture");
				end
			    if tex then
					banked = RBDB:GetItemIsBanked(RBDB:Link_TextToDB(link));
					if banked and RBOptions:GetOption("Bank", "Show") then -- Blackout banked recipes.
						tex:SetVertexColor(unpack(RBOptions:GetOption("AucC", "B")));
					else
						local known = RBDB:GetKnownInfo(makes, skill, rid);
						aknow, alearn, ahave = RecipeBook:MatchRecipeData(makes, skill, rank, spec, rep, honor, known);
						local who = RBOptions:GetOption("TipC", "ASF")..RecipeBook.Globals.Player.."|r";
						tex:SetVertexColor(RBAuction:IconColor(aknow, alearn, ahave, who));
					end
				end
			end
		elseif RecipeBook.Parms.AddOnsLoaded["Auctioneer CompactUI"] and getglobal("BrowseButton"..i):IsVisible() then
		    getglobal("BrowseButton"..i).Icon:SetVertexColor(1,1,1);
		end
	end
end

--[[ IconColor(aknow, alearn, ahave, use) --> sets up the color of an icon based on known info
	Returns: r, g, b ]]--
function RBAuction:IconColor(aknow, alearn, ahave, who)
	RecipeBook:Debug("Running IconColor for: "..who);
	local i,v;
    if alearn and next(alearn) then -- A listed alt can currently learn this recipe.
		RecipeBook:Debug("Running Can Learn.");
		for i,v in ipairs(alearn) do
		    if v == who then -- The player can learn this recipe.
				RecipeBook:Debug("Can Learn.");
	        	return 1,1,1;
			end
		end
		return unpack(RBOptions:GetOption("AucC", "AC"));
	elseif ahave and next(ahave) then -- A listed alt will be able to learn this recipe.
		for i,v in pairs(ahave) do
		    if string.gsub(v, " %(%d+%)", "") == who then -- The player will be able to learn this recipe.
				RecipeBook:Debug("Will Learn.");
		        return unpack(RBOptions:GetOption("AucC", "MW"));
			end
		end
		RecipeBook:Debug("Someone Else Will Learn.");
		return unpack(RBOptions:GetOption("AucC", "AW")); -- Another alt will be able to learn
	elseif aknow and next(aknow) then -- All listed alts know this recipe.
		RecipeBook:Debug("Everyone Knows");
		return unpack(RBOptions:GetOption("AucC", "AK"))
	else -- No alts know or can learn this recipe.
		RecipeBook:Debug("Nobody has data");
		return unpack(RBOptions:GetOption("AucC", "OC"))
	end
end

--[[ BankedColor(banked) --> banked recipes override any other preference.
	Returns: r,g,b or false ]]--
function RBAuction:BankedColor(banked)
	if banked and RBOptions:GetOption("Bank", "Show") then -- Blackout banked recipes.
	    return unpack(RBOptions:GetOption("AucC", "B"));
	else
		return false;
 	end
end
