--============================== [ VARIABLES ]==============================--
--[ Global variables ]--
	-- Data tables
	RecipeBook_Indices = {["Next Realm"] = 1};
	RecipeBook_CharacterDB = {["Data Version"] = RECIPEBOOK_DATAVERSION, ["Debug"] = {}};
	RecipeBook_ItemDB = {};
	RecipeBook_ItemNameDB = {};
	-------------- Main Object -----------
	RecipeBook = {};
	-- Debug and data parameters
	RecipeBook.Parms = {
		LastDBUpdate = 0,
		LastTSUpdate = 0,
		Debug =  {
			Enabled = false,
			Last = nil,
			Verbose = false,
		},
		Button = {
			RBData ={
				Name = "No Item",
				Modify = nil,
				Tooltip = {},
				Chatframe = {},
			},
		},
		MinimapPosition = 0;
		-- Tooltip = {
		    -- Name = "",
			-- Lines = 1000,
			-- Modified = false,
			-- LastUpdate = 0,
			-- IsUpdate = false,
			-- DoUpdate = false,
			-- Data = {
			    -- ID = nil,
				-- Who = {},
				-- },
			-- },
		AddOnsLoaded = {
		    },
		};
		
	RecipeBook.Globals ={
	    Realm = "No Realm",
	    Faction = FACTION_ALLIANCE,
	    OFaction = FACTION_HORDE,
	    Player = "Nobody",
	    };
		
	RecipeBook.SlashCommands = {
		["bad arg"] = function(msg)
			    RBOutput:Print(string.format(RECIPEBOOK_ERR_BADARG, msg), "error");
				RBOutput:Print(RECIPEBOOK_HELP, "help");
			end,
		["status"] = function(...)
				RBOutput:Print(string.format(RBOPTIONS_STATUS, (RBOptions:GetOption("Status", nil) and RBOPTIONS_ON or RBOPTIONS_OFF)), "help")
			end,
		["on"] = function (...)
				RBOptions:SetOption("Status", true);
				do RecipeBook.SlashCommands["status"]() end;
			end,
		["off"] = function (...)
				RBOptions:SetOption("Status", false);
				RecipeBook.SlashCommands["status"](args);
			end,
		["help"] = function(...) RBOutput:Print(RECIPEBOOK_HELP, "help"); end,
		["version"] = function(...) RBOutput:Print(RECIPEBOOK_VERSION_TEXT, "help"); end,
		["debug"] = function(...)
				if (RecipeBook.Parms.Debug.Enabled) then RecipeBook.Parms.Debug.Enabled = false else RecipeBook.Parms.Debug.Enabled = true end;
				RBOutput:Print("Debug: "..(RecipeBook.Parms.Debug.Enabled and RBOPTIONS_ON or RBOPTIONS_OFF), "output");
				if RecipeBook.Parms.Debug.Enabled then SetCVar("scriptErrors", 1) else SetCVar("scriptErrors", RecipeBook.Parms.Debug.Last) end;
		    end,
		["verbose"] = function(...)
				if (RecipeBook.Parms.Debug.Verbose) then RecipeBook.Parms.Debug.Verbose = false else RecipeBook.Parms.Debug.Verbose = true end;
				RBOutput:Print("Verbose Sharing : "..(RecipeBook.Parms.Debug.Verbose and RBOPTIONS_ON or RBOPTIONS_OFF), "output");
		    end,
		["search"] = function(args)
			    if args[2] then
			        RBUI:ShowSearchFrame(table.concat(args, " ", 2), true, false);
				else
					RBUI:ShowSearchFrame("", true, false)
				end
			end,
		["skill"] = function(...) RBUI:ShowBrowseFrame(); end,
		["bank"] = function (...) RBUI:ShowBankFrame(); end,
		["share"] = function (...) RBUI:ShowShareFrame(); end,
		["config"] = function(...) RBUI:ShowOptionsFrame() end,
		["options"] = function(...) RecipeBook.SlashCommands["config"](...) end,
		["send"] = function(args)
		        if not args[2] then
		        	return RBOutput:Print(RECIPEBOOK_SHARE_USAGE, "help")
				end
				local text = table.concat(args, " ", 2);
				if not string.find(text, "to ") then
		        	return RBOutput:Print(RECIPEBOOK_SHARE_USAGE, "help")
				end

		        local alt, who = string.match(text, "(.-)%s?to (.+)")
				if not who or who == alt then
				    return RBOutput:Print(RECIPEBOOK_SHARE_USAGE, "help")
				end
				if alt == "me" then
				    alt = RecipeBook.Globals.Player;
				elseif not alt or string.len(alt) < 3 or alt == "all" then
					alt = "all";
				else
					alt = RBOutput:Capitalize(alt);
				end
				who = RBOutput:Capitalize(who);

				RBShare:InitiateSession(who, alt)
			end,
		["mem"] = function(args)
		        UpdateAddOnMemoryUsage();
		        used = GetAddOnMemoryUsage("RecipeBook");
		        RBOutput:Print("Currently using: "..used.."KB", "output");
		    end,
		["test"] = function(...)
			-- Set random metaData.
			for id, data in pairs(RecipeBook_ItemDB) do 
				for rid, _ in pairs(data) do
					if type(rid) == "number" then
						local n = string.char(math.random(65, 90))..string.char(math.random(97, 122))..string.char(math.random(97, 122));
						RBDB:SetMetaData(id, rid, "iSkill", {["Skill"] = math.random(1, 375), ["Name"] = n});
					end
				end
			end
			
			RBSkill.AddData["iSkill Skill Required"] = function(info)
				local data = RBDB:GetMetaData(info.ID, info.RID, "iSkill")
				info.skillLevel = data["Skill"];
				info.iName = data["Name"];
				return info;
			end;
			
			RBSkill.AddData["iSkill New Name"] = RBSkill.AddData["iSkill Skill Required"];
			RBSkill.AddData["iSkill All Fields"] = RBSkill.AddData["iSkill Skill Required"];
			
			RBSkill.AddSort["iSkill Skill Required"] = function(itemT, sortBy)
				table.sort(itemT, function(a,b) return RBSkill:SortBy(a, b, "skillLevel", 0, false) end);
				return itemT;
			end;
			
			
			RBSkill.AddSort["iSkill New Name"] = function(itemT, sortBy)
				table.sort(itemT, function(a,b) return RBSkill:SortBy(a, b, "iName", 0, false) end);
				return itemT;
			end;
			
			RBSkill.AddSort["iSkill All Fields"] = function(itemT, sortBy)
				table.sort(itemT, function(a,b) return RBSkill:SortBy(a, b, {"skillLevel", "iName"}, {0, 0}, false) end);
				return itemT;
			end;


			RBSkill:AddExternalSort("Skill Req", "iSkill Skill Required", "skillLevel", "Skill Req");
			RBSkill:AddExternalSort("Name Req", "iSkill New Name", "iName", "new Name");
			RBSkill:AddExternalSort("iSkill Data", "iSkill All Fields", "iName", "iSkill");
		end
	}

	RecipeBook.TSTable = {RECIPEBOOK_TRADESKILLS["Alchemy"], RECIPEBOOK_TRADESKILLS["Blacksmithing"], RECIPEBOOK_TRADESKILLS["Enchanting"], RECIPEBOOK_TRADESKILLS["Engineering"], RECIPEBOOK_TRADESKILLS["Jewelcrafting"], RECIPEBOOK_TRADESKILLS["Leatherworking"], RECIPEBOOK_TRADESKILLS["Mining"], RECIPEBOOK_TRADESKILLS["Skinning"], RECIPEBOOK_TRADESKILLS["Tailoring"], RECIPEBOOK_TRADESKILLS["Cooking"], RECIPEBOOK_TRADESKILLS["First Aid"], RECIPEBOOK_TRADESKILLS["Fishing"], RECIPEBOOK_TRADESKILLS["Herbalism"] };

	RecipeBook.AddCompatibility = {-- This notes whether RB needs to do particular things for particular addons
	 	["Alternate Bag Mod"] = function(...) RecipeBook.Parms.AddOnsLoaded["Alternate Bag Mod"] = false; end,
		["Auc-Advanced"] = function(...) RecipeBook.Parms.AddOnsLoaded["Auc-Advanced"] = true; end,
		["Blizzard_CraftUI"] = function(...) RecipeBook.Parms.AddOnsLoaded["Blizzard_CraftUI"] = true; end,
		["Blizzard_GuildBankUI"] = function(...) hooksecurefunc("GuildBankItemButton_OnEnter",  RecipeBook_DefaultHook) end;
	 	["Blizzard_TradeSkillUI"] = function(...) RecipeBook.Parms.AddOnsLoaded["Blizzard_TradeSkillUI"] = true; end,
	 	["LinkWrangler"] = function(...) LINK_WRANGLER_CALLER["RecipeBook"] = "RecipeBook_DoHookedFunction"; end,
	};

--[ Local globals to this file ]--
 	-- Options
	RBUI_SUBFRAMES = { "RBUI_SearchFrame", "RBUI_SkillFrame", "RBUI_SharingFrame", "RBUI_BankingFrame", "RBUI_OptionsFrame"};
 	-- Initialization and compatibility --
	local RBOld_ChatFrame_MessageEventHandler;
	local RecipeBook_ChatFrameHandler;
--===========================================================================--
--============================== [ FUNCTIONS ] ==============================--
--===========================================================================--

--============================== INITIALIZATION AND SETUP ==============================--
--[[ OnLoad() --> Registers events, sets up basic slash commands ]]--
function RecipeBook:OnLoad()
	RecipeBook.Parms.Debug.Last = GetCVar("scriptErrors");
	if RecipeBook.Parms.Debug.Enabled then SetCVar("scriptErrors", 1) end;
	--== Configuration Frame ==--
	UIPanelWindows["RecipeBook_ConfigFrame"] = {area = "center", pushable = 0};
	tinsert(UISpecialFrames, "RecipeBook_ConfigFrame");
	--== Event Registration ==--
	this:RegisterEvent("ADDON_LOADED");
	this:RegisterEvent("PLAYER_ENTERING_WORLD"); --For loading data
	this:RegisterEvent("PLAYER_LEAVING_WORLD"); --For writing data
	this:RegisterEvent("AUCTION_HOUSE_SHOW"); -- For Auction house hooks
	this:RegisterEvent("BANKFRAME_OPENED");
	this:RegisterEvent("BANKFRAME_CLOSED");
	this:RegisterEvent("MAIL_SEND_INFO_UPDATE");
	this:RegisterEvent("CHAT_MSG_SKILL"); --Skillups for disenchants make baby enchanters happy.
 	this:RegisterEvent("CHAT_MSG_ADDON");
 	this:RegisterEvent("CHAT_MSG_SYSTEM");
	this:RegisterEvent("PLAYER_REGEN_ENABLED");
	this:RegisterEvent("PLAYER_REGEN_DISABLED"); --Turning off bag updates during combat
--  New test code
	this:RegisterEvent("AUCTION_HOUSE_CLOSED");
    this:RegisterEvent("ITEM_LOCK_CHANGED");
    this:RegisterEvent("CHAT_MSG_LOOT");
	this:RegisterEvent("MAIL_CLOSED");
--	this:RegisterAllEvents();
	--Slash Command Handlers--
	SlashCmdList["RecipeBook"] = RecipeBook_SlashHandler;
	SLASH_RecipeBook1 = "/recipebook";
	SLASH_RecipeBook2 = "/rbook";
	if IsAddOnLoaded("RatingBuster") then 
			SLASH_RecipeBook3 = "/rbk";
	else
		SLASH_RecipeBook3 = "/rb";
		SLASH_RecipeBook4 = "/rbk";
	end

	DEFAULT_CHAT_FRAME:AddMessage(RECIPEBOOK_LOADED);

end

--[[ InitializeSetup() --> Initializes data for new players, new realm, new install ]]--
function RecipeBook:InitializeSetup()
	if next(RecipeBook_ItemDB) == nil then
		DEFAULT_CHAT_FRAME:AddMessage(RECIPEBOOK_NEWVERSION);
	end
	if RecipeBook.Globals.Player == "Nobody" then
		RecipeBook:SetGlobals();
		if RecipeBook.Globals.Faction == nil then
			RBOutput:Print("No Faction data available for this character.  Defaulting to Alliance.  PLEASE contact Ayradyss (dr.nykki@gmail.com) and inform her.", "error");
			RecipeBook.Globals.Faction = FACTION_ALLIANCE;
			RecipeBook.Globals.OFaction = FACTION_HORDE;
		end
	end

	-- Setting up the data structure
	-- RecipeBook_CharacterDB : Adds this player if they don't already exist.  Accounts for new realm as well.
	RBSkill:Initialize();
	RBShare:Initialize();
	RBOptions:Initialize();
	RBUI:Initialize();
	
	RBDB:AddNewPlayer(RecipeBook.Globals.Player, RecipeBook.Globals.Faction, false);
   	RecipeBook_CharacterDB["Debug"] = {};

	RecipeBook:HookFunctions();
	RecipeBook:StaticPopups();
	RBShare:StaticPopups();
	RBUI:StaticPopups();
	
	RBDB:CleanDB();
    RBUpgrade:DataUpgrade(RecipeBook_CharacterDB["Data Version"]);

	RecipeBook.Parms.AddOnsLoaded["Recipe Book"] = true;
end

--[[ SetGlobals() --> Sets up global variables (Faction, Player, Realm, OtherFaction) ]]--
function RecipeBook:SetGlobals()
	RecipeBook.Globals.Player = UnitName("player");
	local realm = GetRealmName();
	if RecipeBook_Indices["Next Realm"] == nil then RecipeBook_Indices["Next Realm"] = 1 end;
	if RecipeBook_Indices[realm] == nil then
	    RecipeBook_Indices[realm] = RecipeBook_Indices["Next Realm"];
	    RecipeBook_Indices["Next Realm"] = RecipeBook_Indices["Next Realm"] + 1;
	end
	RecipeBook.Globals.Realm = RecipeBook_Indices[realm];
	RecipeBook.Globals.Faction = UnitFactionGroup("player");
	if RecipeBook.Globals.Faction ~= nil then
		if FACTION_ALLIANCE ~= "Alliance" then --Blizzard's UnitFactionGroup does not return localized data.
			if (RecipeBook.Globals.Faction == "Alliance" or RecipeBook.Globals.Faction == FACTION_ALLIANCE) then RecipeBook.Globals.Faction = FACTION_ALLIANCE;
			else RecipeBook.Globals.Faction = FACTION_HORDE;
			end
		end
		RecipeBook.Globals.OFaction = (RecipeBook.Globals.Faction == FACTION_HORDE and FACTION_ALLIANCE or FACTION_HORDE);
	end
end

--[[ StaticPopups() --> Adds in static popup windows for various functions ]]--
function RecipeBook:StaticPopups()
	-- Client crash on bad data.
	StaticPopupDialogs["RECIPEBOOK_ITEM_DISCONNECTED"] = {
		-- Popup explaining that you were last disconnected due to a bad item link and informing you that RecipeBook has marked it as such, and will now continue parsing data.
		text = TEXT(RECIPEBOOK_TEXT_ITEMDISCONNECTED),
		button1 = TEXT(OKAY),
		OnAccept = function ()
		    RBDB:UpdateNameList();
		end,
		whileDead = 1;
		timeout = 0;
	};
end

--============================== HOOKING AND COMPATIBILITY ==============================--

--[[ HookFunctions() --> Hooks functions that RecipeBook requires to work correctly, also introduces other addon compatibility ]]--
function RecipeBook:HookFunctions()
	--== Blizzard function hooks ==--
	hooksecurefunc("MerchantFrame_UpdateMerchantInfo", RBAuction.MerchantFrame_UpdateMerchantInfo);
 	hooksecurefunc("GameTooltip_OnHide", RBOutput.HideGameTooltip);
	--hooksecurefunc("SetItemRef", RBOutput.SetItemRef);
	hooksecurefunc("UnitPopup_OnClick", RBShare_UnitPopupOnClick);
	hooksecurefunc("UnitPopup_HideButtons", RBShare_UnitPopupHideButtons);
	hooksecurefunc("InboxFrameItem_OnEnter", RecipeBook_DefaultHook);
 	hooksecurefunc(GameTooltip, "SetLootItem", RecipeBook_DefaultHook);
 	hooksecurefunc(GameTooltip, "SetInventoryItem", RecipeBook_DefaultHook);
 	hooksecurefunc(GameTooltip, "SetMerchantItem", RecipeBook_DefaultHook);
 	hooksecurefunc(GameTooltip, "SetLootRollItem", RecipeBook_DefaultHook);
	hooksecurefunc(GameTooltip, "SetBagItem", RecipeBook_DefaultHook);
	hooksecurefunc(GameTooltip, "SetTradeSkillItem", RecipeBook_DefaultHook);
	hooksecurefunc(GameTooltip, "SetCraftItem", RecipeBook_DefaultHook);
	hooksecurefunc(GameTooltip, "SetHyperlink", RecipeBook_DefaultHook);
 	--hooksecurefunc("SendMailMailButton_OnClick", RBBank_SendMailItem);
	hooksecurefunc(ItemRefTooltip, "SetHyperlink", RBOutput.SetItemRef);


	RBOld_ChatFrame_MessageEventHandler = ChatFrame_MessageEventHandler;
	ChatFrame_MessageEventHandler = RecipeBook_ChatFrameHandler;
	
	--== Other AddOns ==--
	for addon, func in pairs(RecipeBook.AddCompatibility) do
	    if IsAddOnLoaded(addon) then func(); end;
	end
end;

--============================== EVENT HANDLERS ==============================--
-- [ OnEvent(event) : So what happens when an event fires? ] --
function RecipeBook:OnEvent(event)
--	RecipeBook:Debug(event);
	if (event == "PLAYER_ENTERING_WORLD") then
		if RecipeBook.Parms.AddOnsLoaded["Recipe Book"] then return end;
		RecipeBook:InitializeSetup();
		RecipeBook:TrackBags(true); -- Registers BAG UPDATE
		RecipeBook:TrackTradeskills(true);
		RecipeBook:ScheduleEvent(RBDB.UpdateNameList, 15);
		RBMM:ShowButton();
		this:UnregisterEvent(event);
		RecipeBook:ScheduleEvent(RBAU.AutoUpdate, 60)
		RecipeBook:ScheduleEvent(RBAU.GuildAutoUpdate, 20);
	elseif (event =="PLAYER_LEAVING_WORLD") then
		RecipeBook:TrackBags(false);
		RecipeBook:TrackTradeskills(false);
	elseif(event == "CRAFT_SHOW" or event=="TRADE_SKILL_SHOW") then
		RBTradeskill:ProfessionScan();
		RBTradeskill:SpecialtyScan();
		RBTradeskill:SkillWindowOpen(event);
	elseif(event == "CRAFT_UPDATE" or event == "TRADE_SKILL_UPDATE") then
		RBTradeskill:SkillWindowUpdate(event);
	elseif(event == "CRAFT_CLOSE" or event == "TRADE_SKILL_CLOSE") then
		RBTradeskill:SkillWindowClose(event);
   	elseif event == "AUCTION_HOUSE_SHOW" then
	   	RBAuction:HookAuctionFunctions();
	elseif event == "BANKFRAME_OPENED" then
		RBBank:OpenBank();
	elseif event == "BANKFRAME_CLOSED" then
		RBBank:CloseBank();
	elseif event == "CHAT_MSG_COMBAT_FACTION_CHANGE" then
		RBTradeskill:ReputationScan();
	elseif event == "CHAT_MSG_SKILL" then
		RBTradeskill:ParseSkillupMessage(arg1);
	elseif(event == "ADDON_LOADED") then
		if RecipeBook.AddCompatibility[arg1] then RecipeBook.AddCompatibility[arg1]() end;
	elseif event == "CHAT_MSG_ADDON" and arg1 == RECIPEBOOK_SHARETRIGGER and  arg4 ~= RecipeBook.Globals.Player then
		RBParser:DistributeMessage(arg4, arg2, arg3);
	elseif (event == "ITEM_LOCK_CHANGED" and not RBBank.FrameOpen) or (event == "MAIL_CLOSED") or (event == "AUCTION_HOUSE_CLOSED") then -- Update bags on moving items in the bag or closing mailbox frame
	    RecipeBook:ScheduleEvent(RBBank.UpdateBags, 5);
	elseif event == "CHAT_MSG_LOOT" then
		if string.match(arg1, RECIPEBOOK_REGEX_GETITEM) then
		    RBDB:AddHeldItem(RBDB:Link_TextToDB(arg1), RecipeBook.Globals.Player);
		end
	end
end

--[[ SlashHandler(msg) --> Control switch for slash commands. ]]--
function RecipeBook:SlashHandler(msg)
	if not msg or msg == "" then msg = "help" end;
	local msgT = RBOutput:Words(msg);
	if RecipeBook.SlashCommands[msgT[1]] then
		RecipeBook.SlashCommands[msgT[1]](msgT)
	else
	    RecipeBook.SlashCommands["bad arg"](msg);
	end
-- Code goes here.
end

--============================== HOOKED FUNCTIONS ==============================--
--[ You sometimes need to set default data for a button.  This must be done without pointers. ]--
function RecipeBook:SetDefaultButtonData(button)
	button.RBData = {Name = "No Item", Modify = nil, Tooltip = {}, Chatframe = {}};
end

--[[ DoHookedFunction(tooltip, button) : Takes a tooltip, extracts the item link, and ensures that the relevant data is available before parsing it
	Returns: nothing ]]--
function RecipeBook:DoHookedFunction(tooltip, button)
	if not RBOptions:GetOption("Status") then return end; -- display off

	--RecipeBook:Debug("Doing Hooked Function.")
	if not tooltip then
		tooltip = GameTooltip; -- Default tooltip
	elseif type(tooltip) == "string" then
	    tooltip = getglobal(tooltip);
	end

	if type(button) == "string" then button = getglobal(button) end;
	
	if not button or not button.RBData then 
		--RecipeBook:Debug("No button.");
		button = RecipeBook.Parms.Button;
	else
		-- RecipeBook:Debug(button.RBData.Name);
	    -- RecipeBook:Debug(button.RBData.Modify and "Modified" or "Not Modified");
	end;

	-- Buttons may have data attached to them.
  	-- This tooltip item matches the button's item and it has been parsed before.
	if tooltip:GetItem() == button.RBData.Name and button.RBData.Modify ~= nil then
	    if button.RBData.Modify then 
	        -- RecipeBook:Debug("Existing data!");
	        -- Modify this tooltip with the existing data.
			RBOutput:ModifyTooltip(tooltip, button.RBData.Tooltip);
			RBOutput:ModifyChatframe(button.RBData.Chatframe);
			return;
		else
		    -- This tooltip is not modified.
			return;
		end
    end

	--RecipeBook:Debug("Checking Tooltip");
	if not tooltip:IsVisible() then return end;

	local name, link = tooltip:GetItem();
	if not name then 
		name = tooltip:GetSpell();
		if not name then name = "No Name Found" end;
		link = nil;
	end;
	-- Set button name to tooltip item name.
	button.RBData.Name = name;

	local valid, skill, id, rid;
	if link then 
		-- Is a recipe, recipe skill;
		valid, skill, id = RecipeBook:ParseItemLink(link);
		_, rid = RBDB:Item_TextToDB(name); -- If this item can be made then we're going to get the RID's for it.
	else
		-- RecipeBook:Debug("No link");
		link = getglobal(tooltip:GetName().."TextLeft1"):GetText();
		valid = false;
		id, rid = RBDB:Item_TextToDB(name);
		skill = 0;
	end
	local known, aknow, alearn, ahave, banked, rank, spec, rep, honor, makes;
	local canmake = {};
	-- This is an item; we need to determine if it can be made.
	if id and rid then 
		-- RecipeBook:Debug("Parsing CanMake Info for: "..itemid.. " ( "..link.." )");
		known = RBDB:GetKnownInfo(id, 99, rid);
		canmake = RecipeBook:IsKnownItem(id, rid, known);
	end	
	
	-- Not a recipe.  Check to see if it has known item info.  
	if not valid and next(canmake) == nil then
		button.RBData.Modify = false;
		return;
	elseif valid then
		-- RecipeBook:Debug("Parsing Recipe Info for skill: "..skill);
		rank, spec, rep, honor, makes = RecipeBook:GetSkillInfo(tooltip, skill); --This info I can only get from the tooltip thus far.
		-- RecipeBook:Debug("Makes: "..makes);
		makes, rid = RBDB:Item_TextToDB(makes, skill);
		if next(known) == nil then known = RBDB:GetKnownInfo(makes, skill, rid);
		else -- Info has already been returned.  Add our info.
			tknown = RBDB:GetKnownInfo(makes, skill, rid);
			for fac, whos in pairs(tknown) do
				if known[fac] == nil then known[fac] = {} end;
				for who, diff in pairs(whos) do known[fac][who] = diff end;
			end
		end
	end; 

	-- Actual parsing

	-- Note: makes is the actual tooltip-extracted name of the created item, since things don't always match correctly otherwise (mechanical squirrel boxes,etc)
	if valid and rank then
	    if RBOptions:GetOption("Display", "B") then banked = RBDB:GetItemIsBanked(RBDB:Link_TextToDB(link));
		else banked = {};
		end
		aknow, alearn, ahave = RecipeBook:MatchRecipeData(id, skill, rank, spec, rep, honor, known)
		button.RBData.Modify = true;
	elseif next(canmake) ~= nil then
		aknow, alearn, ahave, banked = {}, {}, {}, {};
		button.RBData.Modify = true;		
	else
	    -- No rank data; not a made item; not valid.
		button.RBData.Tooltip = {};
		button.RBData.Chatframe = {};
		button.RBData.Modify = false;
		return;
	end

	
	button.RBData.Tooltip = RBOutput:GenerateTooltip(aknow, alearn, ahave, banked, canmake); --This will note if the tooltip was modified.
	if button.RBData and button.RBData.Tooltip and button.RBData.Tooltip[1] and button.RBData.Tooltip[1][1] == RECIPEBOOK_ERR_DATANOTLOADED then button.RBData.Name = "Needs Updated" end;

	if aknow and next(aknow) then aknow = table.concat(aknow, ", ") else aknow = false end;
	if alearn and next(alearn) then alearn = table.concat(alearn, ", ") else alearn = false end;
	if ahave and next(ahave) then ahave = table.concat(ahave, ", ") else ahave = false end;
	if banked and next(banked) then banked = table.concat(banked, ", ") else banked = false end;
	if canmake and next(canmake) then canmake = table.concat(canmake, ", ") else canmake = false end;

	button.RBData.Chatframe = RBOutput:RecipeToChatFrame(link, aknow, alearn, ahave, banked, canmake);

	RBOutput:ModifyTooltip(tooltip, button.RBData.Tooltip);
	RBOutput:ModifyChatframe(button.RBData.Chatframe);
end

--[[ ParseItemLink(link) : If the item is a recipe then returns true, skill for the recipe, item ID for the recipe.  Otherwise returns false. ]]--
function RecipeBook:ParseItemLink(link)
	if not link then return false, 0, 0 end;
	local name, link, _, _, _, valid, skill = GetItemInfo(link);
	id = RBDB:Link_TextToDB(link);
	if not name then return false, 0, id end;
	skill = RBDB:Skill_TextToDB(skill);
	if valid ~= RECIPEBOOK_RECIPEWORD or skill < 1 then
		return false, tonumber(skill), tonumber(id); -- not a recipe.
	else
	    return true, tonumber(skill), tonumber(id);
	end
end

--[[ GetSkillInfo(tooltip, [skill]) --> Extracts required ranks and specialization needs from tooltip data
	Returns : rank, specialty, faction required, reputation required, the name of the created item]]--
function RecipeBook:GetSkillInfo(tooltip, skill)
	local text;
	local rank, spec, rep, honor, makes = nil, nil, nil, nil, nil;
	if type(tooltip) == "table" then tooltip = tooltip:GetName() end;
	if not skill then
		local _, link = getglobal(tooltip):GetItem();
		valid, skill = RecipeBook:ParseItemLink(link)
		if not valid then skill = 0 end;
	end
	
	if RBDB:IsEnchant(skill) then
		text = getglobal(tooltip.."TextLeft"..1):GetText();
		if text then makes = string.match(text, "%w+%: (.+)") end
	end;

	
	for i = 2, getglobal(tooltip):NumLines() do
		text = getglobal(tooltip.."TextLeft"..i):GetText();
		if text then			
			if string.find(text, ITEM_SPELL_TRIGGER_ONUSE) then
				if makes == nil then makes = getglobal(tooltip.."TextLeft"..i+1):GetText() end;
				break; -- No data beyond this point;
			elseif string.find(text, RECIPEBOOK_REGEX_SKILL) then -- "Requires Skill (Rank)"
				string.gsub(text, RECIPEBOOK_REGEX_SKILL, function(a,b) rank = b end);
			elseif string.find(text, RECIPEBOOK_REGEX_REPUTATION) then -- "Requires Faction - Reputation"
				_,_, rep, honor = string.find(text, RECIPEBOOK_REGEX_REPUTATION);
			elseif string.find(text, RECIPEBOOK_REGEX_SPECIALTY) then -- "Requires Skill"
				string.gsub(text, RECIPEBOOK_REGEX_SPECIALTY, function(a,b) spec = a end);
			end;
		end
	end
	return tonumber(rank), spec, rep, honor, makes;
end

--[[ MatchRecipeData(item id, skill, ranks needed, specialization, faction, reputation) --> Gathers appropriate alt data on a given recipe.
	Returns: players who know, players who can learn, players who will be able to learn the recipe ]]--
function RecipeBook:MatchRecipeData(item, skill, rank, spec, rep, honor, known)
	item = tonumber(item);
	local aknow = {}; -- know recipe
	local alearn = {}; -- can learn now
	local ahave = {}; -- have tradeskill
	local skillT = RBDB:GetAllCharacters(skill);
	local me = RBOptions:GetOption("Display", "Me");
	local sk, ak = RBOptions:GetOption("Display", "SK"), RBOptions:GetOption("Display", "AK"); -- Knows
	local sw, aw = RBOptions:GetOption("Display", "SW"), RBOptions:GetOption("Display", "AW"); -- Will Learn
	local sc, ac = RBOptions:GetOption("Display", "SC"), RBOptions:GetOption("Display", "AC"); -- Can Learn

	for who, data in pairs(skillT) do
	    if (who ~= RecipeBook.Globals.Player or me) then
		    local fac = RBDB:GetPlayerFaction(who);
			local share = (math.fmod(fac, 10) > 0 and true or false);
--		    if (fac == ofac and not aof) or ((fac == ofac + 1) and not sof) then
		        -- Do not show other-faction if not tracking.
--			else
			if (known and known[fac] ~= nil and known[fac][who] ~= nil) then -- player knows.
			    -- Are we showing known?
				if (share and sk) or (not share and ak) then
				    -- RecipeBook:Debug("Known: "..who);
			    	table.insert(aknow, data[1]..who.."|r");
				end
			elseif RECIPEBOOK_BOOKS[item] and data[2][RBDB:TradeskillIndex_TextToDB("maxrank")] >= RECIPEBOOK_BOOKS[item] then
			    -- RecipeBook:Debug("Knows this book: "..who);
				table.insert(aknow, data[1]..who.."|r");
			elseif RBDB:GetSkillIsShown(who, fac, skill) then -- not a known item for this player AND player's data is not deprecated or incomplete.
			    RecipeBook:Debug("Showing skill");
				local prank = data[2][RBDB:TradeskillIndex_TextToDB("rank")];
				if not spec and not rep then  -- no specialization or faction required
					RecipeBook:Debug("No Spec/No Rep");
					if  prank < rank then
						if (share and sw) or (not share and aw) then
				   		RecipeBook:Debug("Have skill: "..who);
							table.insert(ahave, data[1]..who.." ("..prank..")|r");
						end
					elseif (share and sc) or (not share and ac) then
				    RecipeBook:Debug("Can currently learn: "..who);
						table.insert(alearn, data[1]..who.."|r");
					end
				else -- specialization or faction required
	 				local valid = false;
	 				if spec then
					RecipeBook:Debug("Spec Required: "..spec);
					 	spec, subspec = RBDB:Specialty_TextToDB(skill, spec);
					end
					if spec then
						if spec == data[2][RBDB:TradeskillIndex_TextToDB("spec")] then
							valid = true;
						elseif spec == data[2][RBDB:TradeskillIndex_TextToDB("subspec")] then
		 					valid = true;
						end
	 				end
					if rep then 
					RecipeBook:Debug("Rep Required: "..rep);
					    if RBDB:GetPlayerReputation(who, fac, rep) >= RBDB:RepValue_TextToDB(honor) then valid = true;
						else valid = false;
						end;
					end
					if valid then
						if prank < rank and ( (share and sw) or (not share and aw) ) then
						    -- RecipeBook:Debug("Special needs; have skill: "..who);
							table.insert(ahave, data[1]..who.." ("..prank..")|r");
						elseif (share and sc) or (not share and ac) then
							-- RecipeBook:Debug("Special needs; can currently learn: "..who);
							table.insert(alearn, data[1]..who.."|r");
						end
					end
				end
			end
		end
	end

	return aknow, alearn, ahave;
end

--[[ IsKnownItem(id, skill) --> If 'who can make it' option is on then parses who can make an item. ]]--
function RecipeBook:IsKnownItem(id, ridT, known)
	if not ridT or not known then return {} end;

	local sk, ak = RBOptions:GetOption("Display", "SM"), RBOptions:GetOption("Display", "AM"); -- Knows
	if type(ridT) ~= "table" then ridT = {ridT} end;
	local knowT = {};
	for x, rid in pairs(ridT) do
		local dataT = RBDB:GetItemInfo(id, rid);
		for who, data in pairs(RBDB:GetAllCharacters(dataT["Skill"])) do
		    local fac = RBDB:GetPlayerFaction(who);
			local share = (math.fmod(fac, 10) > 0 and true or false);
			if (known and known[fac] ~= nil and known[fac][who] ~= nil) then -- player knows.
			    -- Are we showing known?
				if (share and sk) or (not share and ak) then
					knowT[who] = data[1]..who.."|r"; -- Avoid repeats.
				end
			end
		end
	end
	local returnT = {};
	for who, text in pairs(knowT) do
		table.insert(returnT, text);
	end
	return returnT;
end


--[[ ParseSystemMessage(msg) --> Various and sundry things that I can parse out of system messages
	Returns : Nothing ]]--
function RecipeBook:ParseSystemMessage(msg)
	
	-- RecipeBook:Debug("System Message: "..msg);
	local txt;
	txt = string.match(msg, RECIPEBOOK_REGEX_UNLEARNSKILL); -- Checking for the unlearn message
	if txt then
	    return RBDB:DeleteTradeskill(RecipeBook.Globals.Player, RBDB:Faction_TextToDB(RecipeBook.Globals.Faction, false), RBDB:Skill_TextToDB(txt));
	end

	if string.match(msg, RECIPEBOOK_REGEX_LEARNRECIPE) then
		return RecipeBook:ScheduleEvent(RBBank.UpdateBags, 5);
	elseif string.match(msg, RECIPEBOOK_REGEX_LEARNSPELL) then
		return RecipeBook:ScheduleEvent(RBBank.UpdateBags, 5);
	end
	
	who = string.match(msg, RECIPEBOOK_REGEX_ONLINE);
	who = string.match(msg, RECIPEBOOK_REGEX_ONLINE);
	if who and RBAU:DueForUpdate(who) then
		return RecipeBook:ScheduleEvent(RBAU.ProcessAUQueue, 60); -- Run the queue if the logging-in player is due for an update.
	end
	-- Here will be hopefully parsing of learned recipes at some future point.
end

--[[ TrackBags(boolean track) --> Turns on and off bag tracking ]]--
function RecipeBook:TrackBags(track)
	if track and RBOptions:GetOption("Bank", "Bags") then RecipeBookFrame:RegisterEvent("BAG_UPDATE");
	else RecipeBookFrame:UnregisterEvent("BAG_UPDATE");
	end
end

--[[ TrackTradeskills(boolean track) --> Turns on and off tradeskill tracking ]]--
function RecipeBook:TrackTradeskills(track)
    if track then
		this:RegisterEvent("TRADE_SKILL_SHOW");
		this:RegisterEvent("TRADE_SKILL_UPDATE");
		this:RegisterEvent("TRADE_SKILL_CLOSE");
		this:RegisterEvent("CRAFT_SHOW");
		this:RegisterEvent("CRAFT_UPDATE");
		this:RegisterEvent("CRAFT_CLOSE");
	else
		this:UnregisterEvent("TRADE_SKILL_SHOW");
		this:UnregisterEvent("TRADE_SKILL_UPDATE");
		this:UnregisterEvent("TRADE_SKILL_CLOSE");
		this:UnregisterEvent("CRAFT_SHOW");
		this:UnregisterEvent("CRAFT_UPDATE");
		this:UnregisterEvent("CRAFT_CLOSE");
	end
end

function RecipeBook:ScheduleEvent(event, t, arg1, arg2)
	t = time() + t;
	for x, data in pairs(RecipeBookFrame.Schedule) do
	    -- You have this event scheduled already; don't schedule another.
	    if data[2] == event then 	    
			RecipeBook:Debug("Repeat Schedule.")
			return; 
		end;
	end
	table.insert(RecipeBookFrame.Schedule, {t, event, arg1, arg2});
	RecipeBookFrame:Show();
end

function RecipeBook:RunScheduler(frame)
	if UnitAffectingCombat("player") then return end; -- Do not run scheduled events in combat.  Defer.
	
    if ((next(frame.Schedule) ~= nil) and (frame.NextUpdate <= 0)) then
		-- RecipeBook:Debug("Scheduler running at time: " .. time());
		for x, data in pairs(frame.Schedule) do
			t, func, arg1, arg2 = unpack(data);
			-- RecipeBook:Debug("Found event at: "..t);
		    if t < time() then
				-- RecipeBook:Debug("*** Found something to do ***");
				func(arg1, arg2);
				table.remove(frame.Schedule, x);
			end
		end
		frame.NextUpdate = RECIPEBOOK_UPDATEFREQUENCY;
    end

    -- If Scheduler is empty then hide the frame
    if next(frame.Schedule) == nil then
		RecipeBook:Debug("Scheduler closing.");
		frame:Hide();
	end
end

--====================== NON-METHOD FUNCTIONS ===================--
--[[ SlashHandler doesn't know what to do with self ]]--
RecipeBook_SlashHandler = function(msg) return RecipeBook:SlashHandler(msg) end;

--[[ Most hooks will be calling the same thing no matter what, since link comes from tooltip  ]]--
RecipeBook_DefaultHook = function(button) return RecipeBook:DoHookedFunction("GameTooltip", button) end;

--[[ For outside mod compatibility and legacy support. ]]--
RecipeBook_DoHookedFunction = function(tooltip, button) return RecipeBook:DoHookedFunction(tooltip, button) end;

--[[ Hook for ChatFrame message. ]]--
function RecipeBook_ChatFrameHandler(event)
	if(event=="CHAT_MSG_SYSTEM") then
		local txt;
	    txt = string.match(arg1, RECIPEBOOK_REGEX_NOTONLINE); -- Checking for not online message
	    if txt and RBShare:DoCancel(txt, "Not online") then -- Do not return this
		else
			RecipeBook:ParseSystemMessage(arg1);
			RBOld_ChatFrame_MessageEventHandler(event);
		end
	else RBOld_ChatFrame_MessageEventHandler(event);
	end
end

function RecipeBook:GuildOnline()
	if not IsInGuild() then return false end;
	local ol = GetGuildRosterShowOffline();
	SetGuildRosterShowOffline(false);
	GuildRoster();
	local num = GetNumGuildMembers(false);
	SetGuildRosterShowOffline(ol);
	if num > 1 then return true else return false end;
end
