﻿if (GetLocale() == "zhTW") then

-- Traditional Chinese translations by Ariestk(青銅)
-- Translations updated 2007-12-26

--[[ Miscellaneous variables and localization strings for Recap ]]

recap_temp = {}; -- other global values (not saved to SavedVariables)

--[[ Tooltips, option indexes ]]

-- First field each line MUST NOT CHANGE (they are option ids)
-- the order MUST NOT CHANGE until HeaderTime.  They are in the order of GetID values
recap_temp.OptList = {
	{ "UseColor", "應用顏色", "啟用時,友方人員及傷害量以綠色顯示,承受的傷害量以紅色顯示,治療量以藍色顯示." },	-- 1
	{ "GrowUpwards", "窗口向上展開", "窗口從底部開始向上展開." },
	{ "GrowLeftwards", "窗口向左展開", "窗口從右部向左展開." },
	{ "ShowTooltips", "顯示提示", "啟用時,鼠標指向某個選項時顯示提示信息." },
	{ "AutoHide", "戰鬥時自動隱藏", "窗口沒有最小化時,進入戰鬥後,自動隱藏傷害統計窗口,戰鬥結束後再顯示." },
	{ "AutoFade", "自動漸隱窗口", "窗口沒有最小化時,當你的鼠標離開傷害統計窗口後漸隱." },
	{ "LimitFights", "進入戰鬥後統計", "當你進入戰鬥後才進行數據統計.  不推薦選擇,除非你不想統計周圍人的數據." },
	{ "HideZero", "僅顯示戰鬥中的", "不在戰鬥中的數據將不被顯示.  這個設定用來排除圖騰等的數據." },
	{ "HideOthers", "Hide Other Combatants", "When checked, hides all other combatants who are not in the group.  This will include allies, neutrals, and foes.\n\nThis option should normally be turned off." },
	{ "IdleFight", "空閑時停止記錄", "在一段時間內沒有傷害和治療動作將進入空閑狀態." }, -- 10
	{ "Time", "顯示時間", "每一位戰鬥人員的戰鬥時間將在列表中顯示." },
	{ "MaxHit", "顯示最高傷害", "每一位戰鬥人員的最高傷害將在列表中顯示." },
	{ "DmgIn", "顯示承受傷害", "在列表中顯示每位成員的傷害承受總量." },
	{ "DmgOut", "顯示傷害輸出", "在列表中顯示每位成員的傷害輸出總量." },
	{ "DPSIn", "顯示承受傷害的DPS", "在列表中顯示每位成員的傷害承受DPS." },
	{ "DPS", "顯示輸出DPS", "在列表中顯示每位成員的輸出DPS." },
	{ "MinStatus", "最小化時顯示狀態", "最小化時,保留狀態指示燈." },
	{ "MinView", "最小化時顯示最後/全部", "最小化時,在小標簽上顯示最後/全部的戰鬥數值." },
	{ "MinYourDPS", "最小化時顯示輸出DPS", "最小化時,在小標簽上顯示你的DPS數值." },
	{ "MinDPSIn", "最小化時顯示總承受DPS", "最小化時,在小標簽上顯示所有友方成員的傷害承受DPS." }, -- 20
	{ "MinDPSOut", "最小化時顯示總輸出DPS", "最小化時,在小標簽上顯示所有友方成員的總傷害輸出DPS." },
	{ "MinButtons", "最小化時顯示按鈕", "最小化時,右上部的按鈕 (關閉, 鎖定, 暫停, 選項, 最後/全部) 將顯示." },
	{ "TooltipFollow", "鼠標提示位置", "選中時,鼠標指向的提示將不在默認位置出現. 注意: 有些插件可能已改變了這個默認位置." },
	{ "SaveGroup", "僅保存友方", "選中時,只有當前被標記為友方的人員的數據會被保存.  改變友方/敵對的方法是:右鍵點擊他們的名字." },
	{ "ReplaceSet", "替換已有存檔", "選中時,保存和載入設置時將替換已有的存檔,否則將合並入舊存檔." },
	{ "Heal", "顯示治療量", "選中時,將在列表中顯示每位成員的有效治療量,過量治療將被去除." },
	{ "Kills", "顯示死亡次數", "選中時,將在列表中顯示成員的死亡次數." },
	{ "HideYardTrash", "顯示唯一的戰鬥成員", "選中時,非友方人員死亡一次數據即被隱藏.適合在Solo時隱藏怪物等的數據." },
	{ "place_holder_29", "", "" },
	{ "Faction", "顯示陣營和等級", "選中時,當一個成員的陣營和等級是已知的,將在他們的名字旁顯示." }, -- 30
	{ "Class", "顯示職業", "選中時,當成員的職業是已知的,將在他的名字旁顯示職業圖標." },
	{ "HealP", "顯示治療量所占%", "選中時,在每個治療職業旁顯示他的可見治療量占總量的百分比." },
	{ "DmgInP", "顯示傷害承受所占%", "選中時,顯示每位成員所承受傷害量占總承受量的百分比." },
	{ "DmgOutP", "顯示傷害輸出所占%", "選中時,顯示每位成員的傷害輸出占總輸出量的百分比." },
	{ "AutoPost", "自動報告結果", "選中時,在每次戰鬥結束後自動向已指定的聊天頻道發送簡明報告." },
	{ "MinBack", "最小化時顯示背景", "選中時,背景不會在最小化時變得透明." },
	{ "MergePets", "合並寵物數值", "從選中時開始,所有成員寵物的數據將合並給他們自己.從取消選擇開始,寵物的數值將單獨計算." },
	{ "AutoMinimize", "自動最小化", "選中時,當鼠標離開窗口將自動最小化.鼠標進入最小化界面將自動展開.按住shift或選中一個戰鬥成員時將無視此選項." },
	{ "ShowPanel", "顯示詳情", "選中時,當鼠標指向一個成員時,將有一個面板顯示更詳細的信息.選定此成員將鎖定面板.簡明信息模式下,僅顯示簡明信息." },
	{ "LightData", "簡明信息模式", "選中時,額外的信息,比如未命中/抵抗等將不在詳情面板裏顯示和收集.\n\n注意: 目前, 自己的詳情數據將不在簡明模式下顯示." }, -- 40
	{ "ShowGauges", "顯示柱狀條", "選中時,顯示成員傷害和治療量的柱狀圖將在名字後面出現.目前,此功能僅支持傷害承受/傷害輸出/治療量的顯示.其它數據的排序可通過點擊各自標題實現." },
	{ "AutoLeader", "自動報告新領導", "選中時,當團隊領導變更時自動在已設定的聊天頻道發送報告." },
	{ "Ranks", "列表成員編號", "選中時,將顯示列表內的成員編號." },
	{ "DPSvsAll", "顯示個人DPS與輸出總量對比", "選中時,顯示DPS價值,代表每個成員的DPS數值與其傷害總量的對比結果." },
	{ "Over", "過量治療", "選中時,顯示判斷的在全部戰鬥中每個治療者的過量治療百分比.  記住:因為每職業的治療方法不同,每個成員的治療任務也不同.所以不要以此來衡量治療者的治療效率." },
	{ "HTML", "HTML格式", "選中時,WOWchatlog.txt或剪貼板內容將為簡單的HTML格式." },
	{ "WriteGroup", "僅記錄友方人員", "選中時,報告僅記錄友方戰鬥人員的數據." },
	{ "ETotal", "記錄效果合計", "選中時,每個傷害和治療數據將被合計在個人詳情裏." },
	{ "ETotalP", "顯示貢獻", "選中時,每個技能的傷害或治療貢獻將以%顯示在個人詳情裏." },
	{ "EHits", "顯示命中", "選中時,非暴擊和反射的傷害命中數將顯示在個人詳情裏." }, -- 50
	{ "EHitsAvg", "顯示平均命中", "選中時,非暴擊和非反射的平均傷害值將顯示在個人詳情裏." },
	{ "EHitsMax", "顯示最大命中傷害", "選中時,非暴擊非反射的最大傷害值將顯示在個人詳情裏." },
	{ "ETicks", "顯示Tick作用次數", "選中時,Tick (Tick表示DOT或HOT的每一跳) 的作用次數將在個人詳情中顯示." },
	{ "ETicksAvg", "顯示Tick的平均值", "選中時,Tick的平均值將在個人詳情中顯示." },
	{ "ETicksMax", "顯示Tick的高大值", "選中時,Tick最大值將在個人詳情中顯示." },
	{ "ECrits", "顯示暴擊", "選中時,暴擊次數將在個人詳情中顯示." },
	{ "ECritsAvg", "顯示平均暴擊", "選中時,平均暴擊值將在個人詳情中顯示." },
	{ "ECritsMax", "顯示最大暴擊", "選中時,最大暴擊值將在個人詳情中顯示." },
	{ "ECritsP", "顯示暴擊率", "選中時,每個法術的暴擊率將在個人詳情中顯示." },
	{ "EMiss", "顯示攻擊失敗", "選中時,在個人詳情中顯示每個法術攻擊失敗的次數. 非近戰攻擊包括未命中/偏斜/抵抗,近戰攻擊包括招架/格擋/閃避." }, -- 60
	{ "EMissP", "顯示攻擊失敗率", "選中時,將在個人詳情裏顯示每個法術的攻擊失敗率." },
	{ "EMaxAll", "顯示最大傷害", "選中時,將在個人詳情裏顯示單次攻擊的最大傷害." },
	{ "WarnData", "當數據太大時警告", "選中時,當你累積記錄的戰鬥成員超過500時發出警告.Recap能很好的記錄超過1000人的數據,但這似乎沒什麼實際用處." },
	{ "HPS", "顯示HPS輸出", "選中時,每個戰鬥成員的有效HPS(每秒治療量)將顯示在列表中." },
	{ "place_holder_65", "", "" },
	{ "RecentData", "最近數據模式", "選中時，最近的事件將被記錄.\n\n當選項應用，可以看到一名戰鬥者的最近輸出和承受輸入, 點擊輸出和輸入詳情名字右邊的最近按鈕.\n\n看技能的相應信息也是如此.\n\nRecap不會將數據寫入硬盤.  重啟UI時數據將清空.\n\n警告: 激活時，最近數據模式將調用額外的內存." },
	{ "IgnoreGUIDs", "Ignore Global Unique Identifiers", "When checked, ignore the global unique identifiers provided for combatants with WoW patch 2.4 and later.  This will give behaviour similar to older versions of Recap, and will use significantly less memory.\n\nChanging this option forces a Reset.\n\nIf this option is checked then synchronization is not allowed." },
	{ "HideGroup", "Hide Group", "When checked, hides other combatants in the group (and their pets if any).  Group includes a party of five or a raid of forty.  Group also includes any combatant that you have added using the right-click dropdown menu.\n\nThis option should normally be turned off." },
	{ "EElement", "顯示法系", "選中時,每個法術的法系(火系/暗影等),將顯示在個人詳情裏." },
	{ "TimeIn", "傷害承受時間", "選中時,每個戰鬥成員的治療時間將顯示在列表中." }, -- 70
	{ "TimeHeal", "顯示治療時間", "選中時,每個戰鬥成員的傷害承受時間將顯示在列表中." },
	{ "EnableSync", "啟用同步數據", "選中時,Recap將准備發送和接收其他玩家的同步數據.你可以加入新的團隊並同步於其他隊友.不選擇時Recap不會理會任何同步信息,也不會回應任何同步請求.\n\nNot allowed if the Ignore Global Unique Identifiers option is checked." },
	{ "OpaqueBackground", "背景不透明", "選中時,所有面板會有一個黑色背景." },
	{ "MinimizeOnEscape", "按Esc最小化", "選中時,按下ESC後Recap主面板將最小化." },
	{ "MinSyncStatus", "最小化時顯示同步狀態", "選中時,最小化時同步狀態燈會保持在面板上." },
	{ "RemindGroupStatus", "加入或離開團隊時提醒", "選中時,當你加入或離開團隊時彈出對話通知.提醒你也許該做些什麼,比如重置設置." },
	{ "Seen", "First Seen", "When checked, the time that this combatant was first seen in the combat log will be displayed in the list." },
	{ "CollectGarbage", "回收垃圾信息", "選中時,每次戰鬥結束後自動回收本插件產生的垃圾信息." },
	{ "OtherData", "其它數據模式", "選中時,Recap將跟蹤事件,並非僅傷害和治療.它包括,施法過程,DEBUFF/損傷 BUFF/增益.所有被跟蹤的信息將在一個彈出的詳情面板中顯示.當簡明信息模式開啟時,此項無效." },
	{ "EHitsMin", "顯示最小命中", "選中時,將在個人詳情中顯示最小命中傷害,非暴擊和反射." },  -- 80
	{ "ETicksMin", "顯示最小Tick", "選中時,將在個人詳情中顯示最小Tick數值." },
	{ "ECritsMin", "顯示最小暴擊", "選中時,將在個人詳情中顯示最小暴擊數值." },
	{ "EGlances", "顯示反射", "選中時,將在個人詳情中顯示反射次數" },
	{ "EGlancesMin", "顯示最小反射", "選中時,將在個人詳情中顯示最小反射數值." },
	{ "EGlancesAvg", "顯示平均反射", "選中時,將在個人詳情中顯示平均反射數值." },
	{ "EGlancesMax", "顯示最大反射", "選中時,將在個人詳情中顯示最大反射數值." },
	{ "RemindInstanceStatus", "進入或離開區域時提醒", "選中時,當你進入或離開某區域時會彈出提示窗口,以提醒你做某些准備,比如保存數據等." },
	{ "StoreOnlyDisplayed", "只存儲友方/團隊/玩家數據", "選擇時, 非以上三類成員的戰鬥數據將不被追蹤和存儲.\n\n在此之前已經存儲的其他人員數據不會被刪除.\n\n在同步期間,此選項將被忽略.\n\n警告: 有時候,WOW和RECAP無法立即檢測出一個團隊成員是玩家還是寵物,如果檢測延遲,這之間的數據會被丟失.\n\n推薦關閉,除非你的內存很大." },
	{ "MinYourHPS", "最小化時顯示你的HPS", "選中時，在最小化窗口顯示你的每秒治療量（HPS）" },
	{ "MinHPS", "最小化時顯示團隊HPS總量 ", "選中時，在最小化窗口顯示團隊的每秒治療量（HPS）." },  -- 90
	{ "MatrixData", "矩陣數據模式", "選中時，Recap將跟蹤誰傷害誰，誰治療誰，誰受到誰的傷害，以及誰受到誰的治療。\n\n如果此項被應用, 數據將在輸出的目標上顯示 (一般在左邊)，輸入 (鼠標指針左) POP面板.\n\n簡明數據模式開啟時，將不進行數據跟蹤." },
	{ "SetScale", "設置比例", "設置Recap顯示面板的比例." },

	-- tooltips that don't change can go below in any order. Ensure future options go above these
	{ "HeaderSeen", "First Seen", "This is the time that this combatant was first seen in the combat log." },
	{ "HeaderTime", "戰鬥時間", "從戰鬥成員第一次獲得戰鬥信息到最後一次獲得戰鬥信息的持續時間." },
	{ "HeaderTimeIn", "傷害承受時間", "從第一個戰鬥成員被傷害到最後一次被傷害的持續時間." },
	{ "HeaderTimeHeal", "治療時間", "從戰鬥人員第一次治療到最後一次治療的持續時間." },
	{ "HeaderMaxHit", "最大傷害", "這是某個戰鬥成員單次攻擊或技能的最大傷害值(非暴擊)." },
	{ "HeaderDmgIn", "傷害承受", "每個成員受到的傷害(坦克選項)." },
	{ "HeaderDmgOut", "傷害輸出", "每個成員的傷害輸出." },
	{ "HeaderHPS", "個體HPS輸出", "這是個人的HPS(每秒治療)數值.持續從第一次治療到最後一次." },
	{ "HeaderDPSIn", "個體DPS承受", "這是個人的傷害承受DPS值, 持續從第一次承受傷害到最後一次." },
	{ "HeaderDPS", "個體每秒傷害", "這是個人的傷害(DPS)值, 持續從第一次輸出到最後一次輸出." },
	{ "HeaderHeal", "治療量", "這是戰鬥成員的可見治療量." },
	{ "HeaderKills", "死亡數", "這是在戰鬥記錄有效距離內發生的死亡次數." },
	{ "Options", "打開設置窗口", "打開或關閉設置窗口,用於管理設置或戰鬥數據." },
	{ "SyncStatus", "同步狀態", "當你在同步狀態時藍色燈亮,否則燈不亮.交換同步數據時藍色燈閃爍." },
	{ "TooltipMinYourDPS", "自己的DPS", "這是你自己的DPS值,包括寵物." },
	{ "TooltipMinDPSIn", "總承受傷害DPS", "所有友方戰鬥成員總傷害承受DPS." },
	{ "TooltipMinDPSOut", "總傷害輸出DPS", "所有友方戰鬥成員總DPS." },
	{ "TooltipMinYourHPS", "你的HPS", "這是你個人的每秒治療量，包含寵物。" },
	{ "TooltipMinHPS", "總量HPS", "這是友方成員的總秒治療量." },
	{ "AutoFadeSlider", "自動隱藏需時", "在你選擇了鼠標離開窗口自動隱藏時, 鼠標離開後多久窗口自動隱藏." },
	{ "SetScaleSlider", "設置比例", "設置Recap顯示面板的比例，從小(0.5)到大(2.0)。\n\n改變比例將使Recap回去屏幕中間, 然後你可以將它移動到你喜歡的位置" },
	{ "IdleFightSlider", "戰鬥空閑時間", "當選擇戰鬥後進入空閑選項時, 多久後進入空閑狀態." },
	{ "EndFightDelaySlider", "戰鬥延遲結束", "當玩家離開戰鬥後延遲一段時間結束戰鬥(這是為了防止你短時間離開戰鬥時停止記錄)." },
	{ "RecentEventCountSlider", "最近事件總計", "被記錄的最近事件的合計數.\n\n所以發布的事件報告不要超過此數,此項只能在'最近戰鬥事件'未激活時改變,數量多時需要更多的內存." },
	{ "ExitRecap", "關閉Recap", "戰鬥監視停止. 並完全關閉Recap." },
	{ "HideWindow", "隱藏窗口", "繼續監視戰鬥,但是此隱藏窗口." },
	{ "ExpandWindow", "展開窗口", "展開窗口並顯示戰鬥詳情." },
	{ "MinimizeWindow", "最小化窗口", "最小化窗口並隱藏戰鬥詳情." },
	{ "UnPinWindow", "解鎖窗口", "窗口可自由移動." },
	{ "PinWindow", "鎖定窗口", "鎖定窗口,使之不能移動." },
	{ "Resume", "重新監視", "當戰鬥監視暫停時. 重新開始監視戰鬥信息." },
	{ "PauseMonitoring", "暫停監視", "點擊暫停監視戰鬥信息.  暫停收集戰鬥數據, 直到你打開重新監視." },
	{ "ShowAllFights", "顯示所有戰鬥", "如果當前窗口顯示的是最後一次戰鬥信息.此項可以重新查看所有的戰鬥信息." },
	{ "ShowLastFight", "顯示最後戰鬥", "如果當前窗口顯示的是全部的戰鬥信息.此項可以顯示最後一次戰鬥信息." },
	{ "CombatLast", "成員戰鬥信息", "此窗口顯示成員列表裏的戰鬥信息.右鍵點擊名字變可改變友方/敵方." },
	{ "CombatAll", "成員所有戰鬥信息", "此項設定戰鬥成員列表裏顯示的全部的戰鬥信息.右鍵點擊名字可改變友方/敵方." },
	{ "ResetLastFight", "重置最後戰鬥信息", "將從全部數據中減去最後戰鬥信息.注意: 最大一擊和過量治療只能在重置全部戰鬥裏扣減." },
	{ "ResetAllTotals", "重置全部戰鬥信息", "將清空全體成員的戰鬥信息, 除了已存檔的數據及個人詳情.已存檔的戰鬥數據只能在選項裏刪除.個人詳情只能在可見情況下清空." },
	{ "SaveAllSet", "保存所有數據", "點此保存當前所有的戰鬥數據." },
	{ "SaveLastSet", "保存最後戰鬥數據", "點此保存當前最後一次戰鬥數據." },
	{ "LoadSet", "載入戰鬥數據", "點擊這裏將載入保存的戰鬥數據." },
	{ "DeleteSet", "刪除戰鬥數據", "點擊這裏將刪除保存的戰鬥數據." },
	{ "DataSetEdit", "設置存檔名稱", "選擇列表裏的一個戰鬥數據或創建一個新數據並命名." },
	{ "OptExit", "關閉Recap", "停止戰鬥監視並完全關閉Recap."},
	{ "OptOk", "完成", "完成設置並關閉選項面板."},
	{ "HeaderHealP", "治療輸出%", "這是友方戰鬥成員的有效治療量在全部有效治療量中占的百分比." },
	{ "HeaderDmgInP", "承受傷害%", "這是友方戰鬥成員承受的傷害在總承受傷害中占的百分比." },
	{ "HeaderDmgOutP", "傷害輸出%", "這是友方戰鬥成員輸出傷害在總傷害輸出中占的百分比." },
	{ "OptTab1", "界面設置", "此項可設置每個窗口的顯示樣式.\n\n注意: 顯示設置不會影響數據.你能夠關閉任何常規樣式,留下最基本的顯示框架." },
	{ "OptTab2", "普通設置", "這個設置定義窗口的行為, 數據界面及其它各種設置." },
	{ "OptTab3", "戰鬥數據設置", "這裏你能管理戰鬥數據.戰鬥數據是從所有戰鬥和最後戰鬥得來的數據." },
	{ "OptTab4", "報告設置", "此處可管理你的報告, 開始頻道記錄,以及從剪貼板發送報告." },
	{ "OptTab5", "同步數據", "此處可管理Recap同步功能.Recap在每次戰鬥結束後同步所有摘要信息,其它Recap信息不在當前同步." },
	{ "MaxRowsSlider", "最大行數", "調整窗口顯示的最大行數." },
	{ "MaxRankSlider", "最大排名", "調整從聊天窗口發送報告的戰鬥人員記錄數量." },
	{ "PanelClose", "關閉面板", "隱藏詳細面板.  信息仍然存在只是隱藏.要停止收集詳細數據,在參數設置裏選擇'簡明數據模式'." },
	{ "PanelTab1", "承受詳情: 坦克", "此面板將顯示承受的傷害,治療,以及未命中." },
	{ "PanelTab2", "輸入來源", "此標簽將顯示傷害輸入和治療輸入信息.\n\n這個跟蹤選項默認為關閉，開啟矩陣數據模式將啟用此選項 / Settings panel." },
	{ "PanelTab3", "輸出詳情: 傷害", "此面板將顯示輸出信息,傷害及治療." },
	{ "PanelTab4", "輸出目標", "此標簽將顯示傷害輸出和治療輸出信息.\n\n這個跟蹤選項默認為關閉，開啟矩陣數據模式將啟用此選項 / Settings panel." },
	{ "PanelTab5", "其它詳情: 施法 Debuff/損傷 Buff/增益", "此面板將顯示,施法(綠),Debuff/損傷(紅),Buff/增益(藍) 未知法術(白)\n\n幾乎包括了BLZ除了傷害和治療外的所有法術事件. \n\n此項默認為半閉.要開啟此功能請在'設置'中開啟'其它數據模式'."},
	{ "PanelTab6", "所有詳情: 摘要", "此面板將顯示戰鬥者的信息摘要." },
	{ "PanelTabDisabled1", "承受詳情: 坦克 (禁用)", "你當前在簡明數據模式.坦克詳情未被收集.解除簡明數據模式可收集每個戰鬥者承受的傷害和未中信息." },
	{ "PanelTabDisabled2", "輸入來源 (禁用)", "你當前處於簡明數據模式. 來源詳情未被收集.\n\n反選簡明數據模式以收集每個成員的傷害輸入和躲閃." },
	{ "PanelTabDisabled3", "輸出詳情: 傷害 (禁用)", "你當前在簡明數據模式.傷害詳情未被收集.可解除簡明數據模式." },
	{ "PanelTabDisabled4", "輸出目標 (禁用)", "你當前處於簡明數據模式. 輸出詳情未被收集.\n\n反選簡明數據模式以收集每個成員的傷害輸出" },
	{ "PanelTabDisabled5", "其它詳情: 施法 Debuff/損傷 Buff/增益 (禁用)", "你當前在簡明數據模式.其它詳情未被收集.可解除簡明數據模式." },
	{ "RecentClose", "關閉面板", "隱藏詳細面板.  信息仍然存在只是隱藏.要停止收集詳細數據,在參數設置裏選擇'簡明數據模式'." },
	{ "RecentTab1", "最近輸入事件", "此標簽將收集戰鬥成員的當前輸入事件, 也許根據效果進行過濾." },
	{ "RecentTab2", "最近輸出事件", "此標簽將收集戰鬥成員的當前輸出事件，也許根據效果進行過濾." },
	{ "PanelEntry25", "時間 (最後戰鬥)", "最後戰鬥中輸出傷害的時間." },
	{ "PanelEntry26", "最大傷害 (最後戰鬥)", "最後戰鬥的最大傷害(非暴擊)." },
	{ "PanelEntry27", "死亡(最後戰鬥)", "最後戰鬥的死亡次數." },
	{ "PanelEntry28", "治療(最後戰鬥)", "最後戰鬥所有有效治療." },
	{ "PanelEntry29", "承受傷害 (最後戰鬥)", "最後戰鬥中所有的承受傷害量." },
	{ "PanelEntry30", "承受DPS (最後戰鬥)", "最後戰鬥中承受傷害的DPS." },
	{ "PanelEntry31", "傷害輸出 (最後戰鬥)", "最後戰鬥中所有的傷害輸出." },
	{ "PanelEntry32", "輸出DPS (最後戰鬥)", "最後戰鬥中的輸出DPS." },
	{ "PanelEntry33", "輸出治療HPS (最後戰鬥)", "最後戰鬥中的有效HPS." },
	{ "PanelEntry34", "輸出治療HPS (全部戰鬥)", "HPS Out (actual) for 全部戰鬥." },
	{ "PanelEntry35", "時間 (全部戰鬥)", "全部戰鬥的傷害輸出時間." },
	{ "PanelEntry36", "最大傷害 (全部戰鬥)", "全部戰鬥的最大傷害(非暴擊)." },
	{ "PanelEntry37", "死亡 (全部戰鬥)", "全部戰鬥的死亡次數." },
	{ "PanelEntry38", "治療 (全部戰鬥)", "全部戰鬥的有效治療量." },
	{ "PanelEntry39", "承受傷害 (全部戰鬥)", "全部戰鬥所承受的傷害." },
	{ "PanelEntry40", "承受傷害DPS (全部戰鬥)", "全部戰鬥所承的\受傷害的DPS." },
	{ "PanelEntry41", "傷害輸出 (全部戰鬥)", "全部戰鬥的傷害輸出量." },
	{ "PanelEntry42", "DPS輸出 (全部戰鬥)", "全部戰鬥的輸出DPS." },
	{ "PanelEntry45", "全部傷害或治療", "此法術的全部輸出量或治療量" },
	{ "PanelEntry46", "命中次數", "此法術非暴擊反射等的命中次數." },
	{ "PanelEntry47", "暴擊次數", "此法術的暴擊次數." },
	{ "PanelEntry48", "平均命中傷害", "此法術非暴擊的平均命中傷害." },
	{ "PanelEntry49", "平均暴擊傷害", "此法術暴擊或極效治療的平均值." },
	{ "PanelEntry50", "最大命中", "此法術非暴擊等的最大傷害值." },
	{ "PanelEntry51", "最大暴擊", "此法術造成傷害暴擊或極效治療的最高值." },
	{ "PanelEntry52", "平均Tick數值", "Tick成傷害或治療的平均值." },
	{ "PanelEntry53", "最大Tick", "Tick造成傷害和治療的最大值." },
	{ "PanelEntry54", "法系", "  法術的法系(暗影,火等)." },
	{ "PanelEntry55", "受攻擊未受中", "受到攻擊未命中的." },
	{ "PanelEntry56", "受攻擊躲閃", "受到攻擊躲閃的.." },
	{ "PanelEntry57", "受攻擊閃避", "受到攻擊閃避的." },
	{ "PanelEntry58", "受攻擊格擋", "受到攻擊格擋的.." },
	{ "PanelEntry59", "受攻擊吸收", "受到攻擊吸收的." },
	{ "PanelEntry60", "受攻擊偏斜", "受到攻擊偏斜的.." },
	{ "PanelEntry61", "受攻擊逃脫", "受到攻擊逃脫的.." },
	{ "PanelEntry62", "受攻擊抵抗", "受到攻擊抵抗的.." },
	{ "PanelEntry63", "受攻擊反射", "受到攻擊反射的." },
	{ "PanelEntry64", "受攻擊免疫", "受到攻擊免疫的.." },
	{ "PanelEntry65", "暴擊率", "暴擊數與所有攻擊數的比率." },
	{ "PanelEntry66", "Tick數量", "法術於目標上實際發生的Tick數量." },
	{ "PanelEntry67", "未命中率", "所有攻擊中未命中的比率." },
	{ "PanelEntry70", "傷害輸出未受中", "你的技能或攻擊未命中." },
	{ "PanelEntry71", "傷害輸出躲閃", "你的技能或攻擊被躲閃." },
	{ "PanelEntry72", "傷害輸出閃避", "你的技能或攻擊被閃避." },
	{ "PanelEntry73", "傷害輸出格擋", "你的技能或攻擊被格擋." },
	{ "PanelEntry74", "傷害輸出吸收", "你的技能或攻擊被吸收." },
	{ "PanelEntry75", "傷害輸出偏斜", "你的技能或攻擊偏斜." },
	{ "PanelEntry76", "傷害輸出逃脫", "你的技能或攻擊被逃脫." },
	{ "PanelEntry77", "傷害輸出抵抗", "你的技能或攻擊被抵抗." },
	{ "PanelEntry78", "傷害輸出反射", "你的技能或攻擊被反射.." },
	{ "PanelEntry79", "傷害輸出免疫", "你的技能或攻擊失敗,對方免疫." },
	{ "PanelEntry80", "時間(最後戰鬥)", "最後戰鬥的傷害輸出時間." },
	{ "PanelEntry81", "時間(全部戰鬥)", "全部戰鬥的傷害輸出時間." },
	{ "PanelEntry82", "治療時間 (最後戰鬥)", "最後戰鬥的治療時間." },
	{ "PanelEntry83", "治療時間 (全部戰鬥)", "全部戰鬥的治療時間." },
	{ "PanelEntry90", "Crush 次數", "Crush效果的次數." },
	{ "PanelEntry91", "Crush 平均值", "Crush造成傷害的平均值." },
	{ "PanelEntry92", "Crush 最大值", "Crush最大傷害值." },
	{ "PanelEntry93", "Crush 比率", "在攻擊中出現Crush的比率." },
	{ "PanelEntry94", "屬性", "法術帶來的屬性增益或降低." },
	{ "PanelEntry95", "合計", "法術帶來的增益和損失總和.BUFF和DEBUFF將顯示堆疊總數." },
	{ "PanelEntry96", "命中", "法術命中總數." },
	{ "PanelEntry97", "平均", "法術造成的增益或損失的平均值.." },
	{ "PanelEntry98", "最大值", "法術造成的增益或損失的最大值." },
	{ "PanelEntry99", "驅散", "法術被驅散的次數." },
	{ "PanelEntry100", "間隔合計", "兩個法術之間的時間間隔." },
	{ "PanelEntry101", "判斷平均間隔", "判斷法術施放的平均間隔(秒). 僅是預估.\n\n注意: 超過130秒的間隔將被忽視." },
	{ "PanelEntry102", "失敗", "任何原因的法術失敗數量." },
	{ "PanelEntry103", "持續時間計數", "法術持續時間計數." },
	{ "PanelEntry104", "判斷平均持續時間", "判斷此法術的平均持續時間..\n\n注意: 超過130秒的時間將被忽視." },
	{ "PanelEntry105", "其它法術", "如果法術顯示為綠色, 則為需念唱法術; 如果顯示為紅色,則為DEBUFF或減益; 如果顯示為藍色,則為BUFF或增益; 如果顯示為白色,則為BUFF或DEBUFF,但Recap不能准確判斷." },
	{ "PanelEntry106", "反射次數", "法術的反射次數." },
	{ "PanelEntry107", "平均反射值", "法術平均的附帶反射傷害." },
	{ "PanelEntry108", "最大反射", "此法術的最大反射傷害." },
	{ "PanelEntry109", "反射率", "此法術的反射率." },
	{ "PanelEntry110", "部分吸收", "部分吸收的次數 (不是完全吸收)." },
	{ "PanelEntry111", "部分吸收平均值", "部分格擋的次數 (不是完全吸收)." },
	{ "PanelEntry112", "部分格擋", "部分格擋的次數 (不包含全部格擋的).." },
	{ "PanelEntry113", "部分格擋平均值", "所有部分吸收傷害的平均數 (不包含全部格擋的)." },
	{ "PanelEntry114", "部分抵抗25%", "抵抗25%傷害的次數 (不包含全部抵抗的)." },
	{ "PanelEntry115", "部分抵抗25%平均值", "所有抵抗25%傷害的平均值 (不包含全部抵抗的)." },
	{ "PanelEntry116", "部分抵抗50%", "抵抗50%傷害的次數 (不包含全部抵抗的)." },
	{ "PanelEntry117", "部分抵抗50%平均值", "所有抵抗25%傷害的平均值 (不包含全部抵抗的)." },
	{ "PanelEntry118", "部分抵抗75%", "抵抗75%傷害的次數 (不包含全部抵抗的)." },
	{ "PanelEntry119", "部分抵抗75%平均值", "所有抵抗25%傷害的平均值 (不包含全部抵抗的)." },
	{ "PanelEntry120", "Steals", "The number of times this effect has been stolen." },
	{ "PanelEntry122", "最小反射", "法術造成的最小傷害反射和治療值." },
	{ "PanelEntry123", "最小命中", "法術普通攻擊下造成的傷害或治療." },
	{ "PanelEntry124", "最小暴擊", "最小暴擊或極效治療值." },
	{ "PanelEntry125", "最小Crush", "此效果的最小Crush傷害和治療" },
	{ "PanelEntry126", "最小Tick", "Tick造成的最小傷害或治療值." },
	{ "PanelEntry127", "部分吸收合計", "部分吸收的數值合計 (不包含全部吸收的)." },
	{ "PanelEntry128", "部分格擋合計", " 部分格擋的數值合計不包含全部格擋的)." },
	{ "PanelEntry129", "部分抵抗25%合計", "部分抵抗25%數值合計 (不包含全部抵抗的)." },
	{ "PanelEntry130", "部分抵抗50%合計", "部分抵抗50%數值合計 (不包含全部抵抗的)." },
	{ "PanelEntry131", "部分抵抗75%合計", "部分抵抗75%數值合計 (不包含全部抵抗的)." },
	{ "PanelEntry133", "估算總抵抗值", "估算戰鬥中的總抵抗數值, 包含全部抵抗和部分抵抗. 這僅是一個估算.\n\n百分率作為抵抗的估算使用." },
	{ "PanelEntryOverheal", "過量治療", "沒有價值的治療量.治療量超出目標損失的血量" },
	{ "OpenLog", "打開記錄", "將打開WoW Logs文件夾下的WOWChatLog.txt 文件." },
	{ "ReportToLog", "報告寫進記錄", "為當前戰鬥者保存報告, 及此人的個人詳情報告, 寫入WoW Logs文件夾下的WOWChatLog.txt 文件." },
	{ "CloseLog", "關閉記錄", "關閉名為WOWChatLog.txt 的記錄." },
	{ "UseOneSettings", "使用全局設置", "默認情況下, 設置會保存在每個角色的目錄下. 選擇這項功能將使目前的設置和所有角色共用.\n\n注意: 設置中保存的戰鬥數據將刪除其他角色的數據.\n\n這個選項不會影響個人詳細數據. 它們總是每個角色獨立的." },
	{ "MenuAdd", "加為友方", "將一個戰鬥成員加入友方列表." },
	{ "MenuDrop", "刪除友方", "從友方列表裏刪除一名友方." },
	{ "MenuReset", "重置戰鬥成員", "重置選擇的戰鬥成員數據.  所有戰鬥,數據和詳細數據都將重置.  最後戰鬥,將會從全部戰鬥中移出該戰鬥數據." },
	{ "MenuIgnore", "忽略戰鬥成員", "忽律該戰鬥成員的戰鬥數據,直到重置所有數據才能重新統計該成員數據." },
	{ "RecapAnchorTopLeft", "錨點在左上", "將錨點設置在窗口位置的左上方." },
	{ "RecapAnchorTopRight", "錨點在右上", "將錨點設置在窗口位置的右上方." },
	{ "RecapAnchorBottomLeft", "錨點在左下", "將錨點設置在窗口位置的左下方." },
	{ "RecapAnchorBottomRight", "錨點在右下", "將錨點設置在窗口位置的右下方." },
	{ "Total", "效果合計", "這是最近一次重置數據後,此法術或技能全部的傷害或治療效果總計." },
	{ "Max", "最大命中", "這是此法術最大的治療或傷害值." },
	{ "Avg", "平均命中", "這是此法術平均的治療或傷害值." },
	{ "CritP", "暴擊率", "這裏是此法術暴擊的比率." },
	{ "MissPOverP", "未擊中率/過量治療", "對於傷害效果, 這裏是未擊中率.  對治療效果, 這裏是過量治療比率." },
	{ "Contribution", "貢獻", "統計每個法術對戰鬥者傷害或治療量的貢獻." },
	{ "OtherHits", "命中", "此法術的命中次數." },
	{ "OtherTotal", "合計", "此法術的所有增益或減益值合計. 對一些法術來說只是簡單的返回命中次數." },
	{ "Attribute", "屬性", "從此法術的得到的屬性增強或損失." },
	{ "HeaderDPSvsAll", "DPS對比", "每個成員的DPS與的傷害總量的對比." },
	{ "HeaderOver", "過量治療", "這是過量治療的百分比, 對應每個友方成員的全部治療量." },
	{ "ReportFightsToClipboard", "寫入剪貼板", "將拷貝目前的戰鬥成員信息到剪貼板中,方便其他寫字板程序瀏覽." },
	{ "ReportDetailsToClipboard", "詳情寫入剪貼板", "將拷貝目前的戰鬥成員詳細信息到剪貼板中,方便其他寫字板程序瀏覽." },
	{ "ShowSelfView", "顯示當前角色詳情", "顯示個人的詳細信息." },
	{ "HideSelfView", "隱藏當前角色詳情", "將隱藏個人的傷害和治療詳細信息, 並且返回到全部戰鬥成員傷害和治療顯示." },
	{ "ResetSelfView", "重置詳細信息", "重置這個窗口裏的成員詳細信息. 不過你自己的的詳細信息將不受影響." },
	{ "ResetEffect", "重置個人詳情", "重置自己的詳細信息統計." },
	{ "HeaderEName", "技能或屬性", "你的這些技能或屬性達到的效果.  綠色表示傷害效果,藍色表示治療效果." },
	{ "HeaderEElement", "效果法系", "這是法系 (暗影, 火系, 神聖, 等.) ." },
	{ "HeaderETotal", "效果合計", "傷害或治療效果的合計." },
	{ "HeaderETotalP", "效果貢獻", "這是每個效果對傷害和治療能力的貢獻(理論上)" },
	{ "HeaderEMaxAll", "最大傷害或治療", "每個效果可能造成的最大傷害和治療, Tick或暴擊中產生的最大值." },
	{ "HeaderEGlances", "反射次數", "每個法術附帶反射效果的次數." },
	{ "HeaderEGlancesAvg", "平均反射", "每個法術附帶反射的平均傷害." },
	{ "HeaderEGlancesMax", "最大反射", "法術的某次反射造成的最大值." },
	{ "HeaderEHits", "擊中數", "不包括暴擊的擊中次數." },
	{ "HeaderEHitsAvg", "平均擊中", "不包括暴擊的擊中平均治療或傷害值." },
	{ "HeaderEHitsMax", "最大一擊(非暴擊)", "這個數字表示單次最大非暴擊傷害或非暴擊治療值." },
	{ "HeaderETicks", "Tick數", "Tick產生的傷害或治療次數." },
	{ "HeaderETicksAvg", "平均Tick", "Tick產生的平均傷害或治療值." },
	{ "HeaderETicksMax", "最大Tick", "Tick的最大的傷害或治療." },
	{ "HeaderECrits", "暴擊數", "這個數字表示暴擊的次數." },
	{ "HeaderECritsAvg", "平均暴擊", "暴擊的平均傷害或治療值." },
	{ "HeaderECritsMax", "最大暴擊", "最大的暴擊傷害或治療值." },
	{ "HeaderECritsP", "暴擊率", "百分比表示暴擊比率, 暴擊數除以擊中數得到百分比.Ticks沒有暴擊." },
	{ "HeaderEMiss", "未擊中", "表示未擊中的次數.  包括非普通攻擊的未擊中, 抵抗和偏斜, 普攻的閃避, 格擋和招架." },
	{ "HeaderEMissP", "未擊中率", "未擊中百分比." },
	{ "HeaderEGlancesMin", "最小反射", "法術附帶反射效果造成的最小值." },
	{ "HeaderEHitsMin", "最小命中", "每個法術理論上的最小傷害或最小治療(非暴擊情況)." },
	{ "HeaderETicksMin", "最小Tick", "DOT類法術每一跳理論上的最小值." },
	{ "HeaderECritsMin", "最小暴擊", "法術造成暴擊理論上的最小值." },
	{ "StartSync", "開始同步", "此按鈕將在團隊發出一個同步邀請,以使你做為同步發起者.你將離開當前同步頻道,Recap將重置所有戰鬥. 你將發送和接收同步信息.\n\n團內的任何人都可以發起同步." },
	{ "ManualSync", "手動同步", "此按鈕將立即同步信息.一般情況下,同步將在每次戰鬥結束後自動進行,但有時,你需要手動進行同步.\n\n非戰鬥中不執行動作." },
	{ "BecomeLeader", "成為領導", "此按鈕使你成為同步領導者,以代替一位離線的領導,同時進行一個手動的同步廣播來發送此變化.\n\n非戰鬥中不執行動作." },
	{ "ListMembers", "成員列表", "此按鈕顯示同步成員列表..\n\n注意:這項功能不一定能將成員顯示完全.." },
	{ "ClearInactiveMembers", "移除空閑團員信息", "從列表中移除過去10秒內不活動的成員. 但同步將繼續. 如果他們再次活動將再出現在列表中. 這不會在其他人的RECAP列表中清除." },
	{ "SkipNextFight", "Skip Next Fight", "This button will skip the next fight.  Recap will automatically resume tracking following the end of the next fight.\n\nEnabled for the leader of the synchronization.\n\nIf pressed during combat, only the remainder of the current fight will be skipped.\n\nThis button could be used, for example, to skip the chess event in Karazhan.\n\nThe button is also enabled for people who are not in a synchronization." },
	{ "TargetTotal", "輸出到目標", "這是最後一次重置後，輸出到目標的傷害和治療量。" },
	{ "SourceTotal", "承受量", "這是最後一次重置後，所承受的傷害和治療量。" },
	{ "ContributionWhom", "項獻", "這是對輸出和承受傷害或治療有幫助的法術總和." },
	{ "RecentIncomingEvents", "最近輸入事件", "這是此戰鬥成員的當前發生事件,也許根據效果進行過濾..\n\nShift+左鍵 可以發送到當前聊天窗口." },
	{ "RecentOutgoingEvents", "最近輸出事件", "這是此戰鬥成員產生的當前事件，也許根據效果進行過濾..\n\nShift+左鍵 可以發送到當前聊天窗口." },
	{ "ShowRecent", "顯示最近事件", "用一個面板來顯示當前戰鬥成員的輸出和輸入事件, 或者一個戰鬥成員的法術和技能.\n\n這個特性能在當前數據模式中啟用或禁用。命今：/ Settings tab." },
	{ "ShowGroupTotal", "Show Group Total", "Show a panel with total combined details for combatants in the group." },
	{ "ShowNonGroupTotal", "Show Non-Group Total", "Show a panel with total combined details for combatants not in the group." }
};


--[[ localized strings for the xml labels ]]

-- Bindings.xml (names generated in Bindings.xml)
BINDING_HEADER_RECAP = "Recap"
BINDING_NAME_RECAP_TOGGLE_RECAP = "切換 Recap"
BINDING_NAME_RECAP_TOGGLE_FIGHTS = "切換 最後/全部戰鬥"
BINDING_NAME_RECAP_OPTIONS = "Recap選項"
BINDING_NAME_RECAP_RESET_ALL = "重置所有戰鬥"
BINDING_NAME_RECAP_RESET_LAST = "重置最後戰鬥"
BINDING_NAME_RECAP_RESET_DETAILS = "重置個人詳情"
BINDING_NAME_RECAP_RESET_FIGHTS_DETAILS = "重置戰鬥和詳情"
BINDING_NAME_RECAP_SAVE_ALL_FIGHTS = "保存所有戰鬥"
BINDING_NAME_RECAP_SAVE_LAST_FIGHT = "保存最後戰鬥"
BINDING_NAME_RECAP_SKIP_NEXT_FIGHT = "Skip Next Fight"

-- Bindings.xml
RECAP_ALL_FIGHTS_RESET = "重置所有戰鬥"
RECAP_LAST_FIGHT_RESET = "重置最後戰鬥"
RECAP_DETAILS_RESET = "重置個人詳情"
RECAP_FIGHTS_DETAILS_RESET = "重置戰鬥和詳情"
RECAP_SYNCHRONIZATION_RESET = "重置同步"
RECAP_ALL_FIGHTS_SAVED = "所有戰鬥數據已保存"
RECAP_LAST_FIGHT_SAVED = "最後戰鬥數據已保存"

-- Recap.xml
RECAP_RECAP = "Recap"
RECAP_RESET = "重置"
RECAP_COMBATANTS = "戰鬥成員"
RECAP_SEEN = "Seen"
RECAP_DIED = "死亡"
RECAP_TIME = "時間"
RECAP_TIME_IN = "In時間"
RECAP_TIME_HEAL = "治療時間"
RECAP_HEAL = "治療"
RECAP_IN = "承受"
RECAP_OUT = "輸出"
RECAP_MAX = "最大"
RECAP_HPS = "HPS"
RECAP_DPS_IN = "InDPS"
RECAP_DPS = "DPS"
RECAP_DPS_ALL = "DPS+"
RECAP_MISS = "未命中"
RECAP_RECENT = "最近"
RECAP_TOTAL_DETAILS = "合計"

-- RecapOptions.xml : Display
RECAP_SET_NAME = "輸入名稱"
RECAP_SAVED = "已保存"
RECAP_RECAP_OPTIONS = "Recap選項"
RECAP_DISPLAY = "顯示"
RECAP_SETTINGS = "設置"
RECAP_DATA_SETS = "數據設置"
RECAP_REPORTS = "報告"
RECAP_OK = "完成"
RECAP_EXIT = "退出"
RECAP_DISPLAY_IN_LIST = "顯示列表項"
RECAP_NUMBERED_LIST = "列表編號"
RECAP_FACTION_LEVEL = "陣營/等級"
RECAP_CLASS = "職業"
RECAP_FIRST_SEEN = "First Seen"
RECAP_DEATHS = "死亡"
RECAP_HEALS = "治療"
RECAP_HEALS_P = "治療%"
RECAP_DAMAGE_IN = "承受傷害"
RECAP_DAMAGE_IN_P = "承受傷害%"
RECAP_DAMAGE_OUT = "傷害輸出"
RECAP_DAMAGE_OUT_P = "傷害輸出%"
RECAP_MAX_HIT = "最大命中"
RECAP_DPS_VS_ALL = "DPS對比全部"
RECAP_OVERHEALING = "過量治療"
RECAP_DISPLAY_MINIMIZED = "最小化顯示項"
RECAP_STATUS_LIGHT = "狀態燈"
RECAP_SYNC_LIGHT = "同步燈"
RECAP_LAST_ALL = "最後/全部"
RECAP_YOUR_DPS = "你的輸出DPS"
RECAP_MIN_DPS_IN = "總承受DPS"
RECAP_MIN_DPS_OUT = "DPS輸出合計"
RECAP_YOUR_HPS = "你的HPS"
RECAP_MIN_HPS= "總量HPS"
RECAP_BUTTONS = "按鈕"
RECAP_BACKGROUND = "背景"
RECAP_MAXIMUM_ROWS = "最大行數"
RECAP_SHOW_GAUGES = "顯示柱狀條"
RECAP_ANCHOR = "錨點"
RECAP_DISPLAY_PERSONAL_DETAILS = "個人詳情"
RECAP_SELF_EELEMENT = "法系"
RECAP_SELF_ETOTAL = "合計"
RECAP_SELF_ETOTALP = "合計%"
RECAP_SELF_EGLANCES = "反射"
RECAP_SELF_EGLANCESMIN = "最小反射"
RECAP_SELF_EGLANCESAVG = "平均反射"
RECAP_SELF_EGLANCESMAX = "最大反射"
RECAP_SELF_EHITS = "命中"
RECAP_SELF_EHITSMIN = "最小命中"
RECAP_SELF_EHITSAVG = "平均命中"
RECAP_SELF_EHITSMAX = "最大命中"
RECAP_SELF_ETICKS = "Ticks"
RECAP_SELF_ETICKSMIN = "最小Tick"
RECAP_SELF_ETICKSAVG = "平均Tick"
RECAP_SELF_ETICKSMAX = "最大Tick"
RECAP_SELF_ECRITS = "暴擊"
RECAP_SELF_ECRITSMIN = "最小暴擊"
RECAP_SELF_ECRITSAVG = "平均暴擊"
RECAP_SELF_ECRITSMAX = "最大暴擊"
RECAP_SELF_ECRITSP = "暴擊%"
RECAP_SELF_EMISS = "失敗"
RECAP_SELF_EMISSP = "失敗%"
RECAP_SELF_EMAXALL = "最大傷害"
-- RecapOptions.xml : Settings
RECAP_WINDOW_OPTIONS = "窗口選項"
RECAP_USE_COLOR = "應用顏色"
RECAP_SHOW_TOOLTIPS = "顯示提示"
RECAP_TOOLTIPS_AT_POINTER = "鼠標指向提示"
RECAP_SHOW_DETAILS = "顯示詳情"
RECAP_OPAQUE_BACKGROUND = "背景不透明"
RECAP_MINIMIZE_ON_ESCAPE = "按Esc最小化"
RECAP_AUTO_HIDE_IN_COMBAT = "戰鬥中自動隱藏"
RECAP_AUTO_MINIMIZE = "自動最小化"
RECAP_AUTO_FADE_WINDOW = "自動漸隱窗口"
RECAP_SCALING = "縮放"
RECAP_FIGHT_OPTIONS = "戰鬥選項"
RECAP_LIMIT_FIGHTS_TO_COMBAT = "進入戰鬥後統計"
RECAP_ONLY_FIGHTS_WITH_DURATION = "僅顯示戰鬥中的"
RECAP_ONLY_UNIQUE_COMBATANTS = "顯示唯一的戰鬥成員"
RECAP_HIDE_GROUP = "Hide Group"
RECAP_HIDE_OTHERS = "Hide Other Combatants"
RECAP_STORE_ONLY_DISPLAYED_COMBATANTS = "只存儲 友方/團隊/玩家 數據"
RECAP_MERGE_PETS_WITH_OWNERS = "合並寵物數據給人員"
RECAP_IGNORE_GLOBAL_UNIQUE_IDENTIFIERS = "Ignore Global Unique Identifiers"
RECAP_END_FIGHT_IF_IDLE = "空閑時停止記錄"
RECAP_END_FIGHT_DELAY = "戰鬥延時結束"
RECAP_DATA_OPTIONS = "數據選 項"
RECAP_LIGHT_DATA_MODE = "簡明數據模式"
RECAP_OTHER_DATA_MODE = "其它數據模式"
RECAP_MATRIX_DATA_MODE = "矩陣數據模式"
RECAP_RECENT_DATA_MODE = "最近數據模式"
RECAP_USE_GLOBAL_SETTINGS = "使用全局設置"
RECAP_WARN_DATA = "數據太大時警告"
RECAP_OTHER_OPTIONS = "其它選項"
RECAP_REMIND_GROUP_STATUS = "加入或離開團隊時提醒"
RECAP_REMIND_INSTANCE_STATUS = "進入或離開區域時提醒"
RECAP_COLLECT_GARBAGE = "戰鬥結束後回收垃圾數據"
-- RecapOptions.xml : Data Sets
RECAP_FIGHT_DATA_SETS = "戰鬥數據設置"
RECAP_SAVE_GROUP_COMBATANTS_ONLY = "僅保存友方戰鬥人員"
RECAP_REPLACE_ANY_EXISTING_DATA = "替換所有已存在數據"
RECAP_SAVE_ALL = "全部保存"
RECAP_SAVE_LAST = "保存最後戰鬥"
RECAP_LOAD = "載入"
RECAP_DELETE = "刪除"
-- RecapOptions.xml : Reports
RECAP_FIGHT_REPORTING = "戰鬥報告"
RECAP_REPORT_RANKS_IN_MULTIPLE_ROWS = "以多行顯示報告 (Shift+左鍵點擊和自動報告)"
RECAP_AUTOMATICALLY_POST_RANKS_AFTER_EACH_FIGHT = "戰鬥結束後自動報告排行"
RECAP_AUTOMATICALLY_POST_CHANGES_IN_LEADERSHIP = "變更領導時自動報告"
RECAP_AUTOMATICALLY_POST = "自動發送"
RECAP_AUTOMATICALLY_POST_TO = "到頻道:"
RECAP_WOWCHATLOG_TXT = "寫入WOWChatLog.txt"
RECAP_OPEN_WOWCHATLOG_TXT = "打開"
RECAP_ACQUIRING_CHANNEL = "獲取頻道..."
RECAP_CHANNEL_JOINED = "已加入頻道"
RECAP_REPORT_TO_WOWCHATLOG_TXT = "報告"
RECAP_CLOSE_WOWCHATLOG_TXT = "關閉"
-- RecapOptions.xml : Clipboard
RECAP_CLIP_EXPLANATION = "按 CTRL+C 可複制已選內容到剪貼板.\nCTRL+V粘貼到其它程序編緝.  做好後按ESC或點擊完成."
RECAP_CLIPBOARD = "報告寫入剪貼板"
RECAP_REPORT_FIGHTS_TO_CLIPBOARD = "戰鬥報告"
RECAP_REPORT_DETAILS_TO_CLIPBOARD = "詳情報告"
RECAP_WRITE_ONLY_GROUP = "僅報告友方戰鬥成員"
RECAP_FORMAT_IN_HTML = "以HTML格式報告"
-- RecapOptions.xml : Synchronization
RECAP_SYNC = "同步數據"
RECAP_SYNCHRONIZATION = "同步數據"
RECAP_ENABLE_SYNC = "啟用同步"
RECAP_SYNC_STATE_IGNORE = "忽視同步"
RECAP_SYNC_STATE_READY = "同步等待中"
RECAP_SYNC_STATE_MEMBER = "同步中的成員"
RECAP_SYNC_STATE_LEADER = "同步領導者"
RECAP_START_SYNC = "開始同步"
RECAP_MERGE_PETS_OFF = "<== 合並寵物數據到人物"
RECAP_MERGE_PETS_ON = "<== 不合並寵物數據到人物"
RECAP_MANUAL_SYNC = "手動同步"
RECAP_BECOME_LEADER = "成為同步領導者"
RECAP_LIST_MEMBERS = "成員列表"
RECAP_CLEAR_INACTIVE_MEMBERS = "清除空閑成員記錄"
RECAP_SKIP_NEXT_FIGHT = "Skip Next Fight"

-- RecapPanel.xml
RECAP_DAMAGE = "傷害"
RECAP_GLANCES = "反射"
RECAP_HITS = "命中"
RECAP_CRITS = "暴擊"
RECAP_CRUSHES = "Crushes"
RECAP_AVERAGE = "平均值"
RECAP_MELEE = "近戰"
RECAP_MISSED_DETAILS = "失敗詳情"
RECAP_MISSED = "未命中"
RECAP_DODGED = "躲避"
RECAP_PARRIED = "閃避"
RECAP_BLOCKED = "格擋"
RECAP_ABSORBED = "吸收"
RECAP_DEFLECTED = "偏斜"
RECAP_EVADED = "逃脫"
RECAP_RESISTED = "抵抗"
RECAP_REFLECTED = "反射"
RECAP_IMMUNE = "免疫"
RECAP_SPELL_OR_ABILITY = "技能或屬性"
RECAP_INCOMING_SPELL_OR_ABILITY = "所承受的技能或攻擊傷害值"
RECAP_OUTGOING_SPELL_OR_ABILITY = "輸出技能或攻擊的傷害值"
RECAP_MISSES = "失敗"
RECAP_MIN = "最小"
RECAP_AVG = "均值"
RECAP_SUMMARY = "摘要"
RECAP_LAST_FIGHT = "最後戰鬥"
RECAP_ALL_FIGHTS = "全部戰鬥"
RECAP_TICKS = "Ticks"
RECAP_INCOMING = "承受"
RECAP_OUTGOING = "輸出"
RECAP_OTHER_EFFECTS = "其它法術"
RECAP_TOTAL = "合計"
RECAP_ATTRIBUTE = "屬性"
RECAP_ENVIRONMENT = "來自環境"
RECAP_DISPELS = "驅散"
RECAP_STEALS = "Steals"
RECAP_TIMINGS = "頻率"
RECAP_INTERVALS = "間隔"
RECAP_SECONDS = "秒"
RECAP_DURATIONS = "持續"
RECAP_INTERRUPT = "打斷"
RECAP_ESTIMATED_INTERVAL = "預估間隔"
RECAP_ESTIMATED_DURATION = "預估持續時間"
RECAP_PARTIALS = "部分失敗"
RECAP_ABSORBS = "吸收"
RECAP_BLOCKS = "格擋"
RECAP_RESISTS_25 = "抵抗25%"
RECAP_RESISTS_50 = "抵抗50%"
RECAP_RESISTS_75 = "抵抗75%"
RECAP_ESTIMATED_TOTAL_RESISTED = "估算總抵抗值"
RECAP_TARGET_OF_OUTGOING = "輸出目標"
RECAP_SOURCE_OF_INCOMING = "承受輸入"

-- RecapRecent.xml
RECAP_RECENT_INCOMING_EVENTS = "最近的輸入事件"
RECAP_RECENT_OUTGOING_EVENTS = "最近的輸出事件"
RECAP_RECENT_INCOMING_EFFECTS = "最近的輸入效果"
RECAP_RECENT_OUTGOING_EFFECTS = "最近的輸出效果"
RECAP_RECENT_INCOMING_DISPELS = "Recent Incoming Dispels"
RECAP_RECENT_OUTGOING_DISPELS = "Recent Outgoing Dispels"

-- more miscellaneous display strings
RECAP_TIME_FIGHTING = "傷害輸出時間"
RECAP_TIME_DAMAGED = "傷害承受時間"
RECAP_TIME_HEALING = "治療時間"
RECAP_KILLS = "擊殺"
RECAP_HPS_OUT = "HPS輸出"
RECAP_DPS_OUT = "DPS輸出"
RECAP_TOTAL_DPS_OUT = "合計DPS輸出"
RECAP_TOTAL_DPS_IN = "合計DPS承受"
RECAP_CRIT_RATE = "暴擊率"
RECAP_TEN_ROWS = "10 行"
RECAP_FIVE_SECONDS = "5 秒"
RECAP_TEN_SECONDS = "10 秒"
RECAP_FIVE_HUNDRED_EVENTS = "500 個事件"
RECAP_GROUP_FIGHT_TIME = "團隊戰鬥時間"
RECAP_GROUP_DPS = "團隊DPS"
RECAP_ONE = "1.0"


--[[ miscellaneous localized strings ]]

recap_temp.LastAll = { Last="最後戰鬥", All="所有戰鬥" }
recap_temp.LastAllShort = { Last="最後戰鬥", All="所有戰鬥" }
recap_temp.StoppedActiveIdle = { Stopped="已停止", Active="激活", Idle="空閑" }
recap_temp.Localize = {}
recap_temp.Localize.RankTop = "排行前"
recap_temp.Localize.None = "無"
recap_temp.Localize.Totals = "合計"
recap_temp.Localize.Details = "詳情"
recap_temp.Localize.Status = "狀態"
recap_temp.Localize.NewLeader = "新領導者"
recap_temp.Localize.With = "與"
recap_temp.Localize.Of = "/"
recap_temp.Localize.For = "漢化by青銅-"
recap_temp.Localize.Seconds = "秒"
recap_temp.Localize.Events = "事件"
recap_temp.Localize.Rows = "行"
recap_temp.Localize.Subtotal = "小計"
recap_temp.Localize.Group = "友好"
recap_temp.Localize.NonGroup = "不友好"
recap_temp.Localize.ElementOther = "其它" --  Damage element not specified
recap_temp.Localize.ElementHealing = "治療" --  Healing element not specified
recap_temp.Localize.OwnedBy = "自己由"
recap_temp.Localize.VerboseLinkStart = "Recap %s: %s承受%s的傷害於%s中,%sDPS承受 (%s次死亡);輸出%s傷害於%s中,%sDPS輸出(最大命中%d);進行了%s有效治療於%s中,%sHPS治療輸出"
recap_temp.Localize.VerboseGroupTotalStart = "Recap %s: 友方戰鬥成員承受%s傷害於%s中，　%.1f DPS承受 (%s 次死亡); 輸出%s傷害於%s中，　%.1f DPS輸出 (最大命中 %d); 進行了%s有效治療於%s中， %.1f 有效治療輸出"
recap_temp.Localize.VerboseNonGroupTotalStart = "Recap %s: 非友方人員承受%s傷害於%s， %.1f DPS承受 (%s 次死亡); 輸出%s傷害於%s中， %.1f DPS輸出 (最大命中 %d); 進行了%s有效治療於%s中， %.1f HPS輸出"
recap_temp.Localize.LinkRank = { Time="戰鬥時間", TimeIn="承受傷害時間", TimeHeal="治療時間", MaxHit="最大命中", DmgIn="承受傷害", DmgOut="傷害輸出", DPS="DPS輸出", DPSIn="DPS承受", Heal="治療", HPS="HPS", Kills="死亡", HealP="治療", DmgInP="傷害承受", DmgOutP="傷害輸出", DPSvsAll="DPS對比總量", Over="估計過量治療", Seen="First Seen" }
recap_temp.Localize.StatusTooltip = "紅燈亮時, 戰鬥監視停止.\n\n綠燈亮時, 監視當前戰鬥.\n\n燈不亮時, Recap空閑並等待戰鬥開始.\n"
recap_temp.Localize.RankUsage = "複制一個recap記錄到聊天窗口, shift+左鍵點擊. 例如:\n|cFFAAAAFF/p (shift+左鍵點擊 傷害)|cFFFFFFFF <- 發送一個實時傷害排名到已設定的聊天頻道.\n|cFFFF8000/ra (shift+左鍵點擊 DPS)|cFFFFFFFF <- 發送DPS排名到已設定頻道."
recap_temp.Localize.SkipChannels = { "綜合", "交易", "世界防務", "本地防務", "尋求組隊" }
recap_temp.Localize.OutgoingHealDetailLink = "Recap %s: %s: %s (%s) 治療了 %s hp (%s 於 %s全部治療)"
recap_temp.Localize.OutgoingHealDetailLinkNoElement = "Recap %s: %s: %s 治療了 %s hp (%s 於 %s全部治療)"
recap_temp.Localize.OutgoingDamageDetailLink = "Recap %s: %s: %s (%s)造成傷害 %s hp (%s 於 %s全部傷害)"
recap_temp.Localize.OutgoingDamageDetailLinkNoElement = "Recap %s: %s: %s 造成傷害 %s hp (%s 於 %s全部傷害)"
recap_temp.Localize.TargetHealDetailLink = "Recap %s: %s 治疗了 %s %s hp (%s 于 %s全部治疗)"
recap_temp.Localize.TargetDamageDetailLink = "Recap %s: %s 造成伤害 %s %s hp (%s 于 %s全部伤害)"
recap_temp.Localize.IncomingHealDetailLink = "Recap %s: %s (%s) 治療了 %s %s hp (%s 於 %s全部治療承受)"
recap_temp.Localize.IncomingHealDetailLinkNoElement = "Recap %s: %s 治療了 %s %s hp (%s 於 %s全部治療承受)"
recap_temp.Localize.IncomingDamageDetailLink = "Recap %s: %s (%s) 造成傷害 %s %s hp (%s － %s全部傷害承受)"
recap_temp.Localize.IncomingDamageDetailLinkNoElement = "Recap %s: %s 造成傷害 %s %s hp (%s － %s全部傷害承受)"
recap_temp.Localize.SourceHealDetailLink = "Recap %s: %s 造成伤害 %s %s hp (%s － %s全部伤害承受)"
recap_temp.Localize.SourceDamageDetailLink = "Recap %s: %s 造成伤害 %s %s hp (%s － %s全部伤害承受)"
recap_temp.Localize.OtherDetailLink = "Recap %s: %s: %s: %s 發生 %s 次 %s"
recap_temp.Localize.OtherDetailType = { "施放", "施放", "Debuff/損失", "Debuff/損失", "Buff/增益", "Buff/增益", "Debuff/Buff/Other", "Debuff/Buff/Other" }
recap_temp.Localize.ConfirmLightData = "你已經選擇啟用簡明信息模式.\n\n如果你同意,Recap 將清除無關信息."
recap_temp.Localize.ConfirmHeavyData = "你已經選擇禁用簡明信息模式.\n\n如果你同意,Recap 將清除無關信息."
recap_temp.Localize.ConfirmLastReset = "你選擇重置最後戰鬥信息.\n\n如果你同意, 最後戰鬥信息將被從全部戰鬥信息中清除. 請確定這是你想做的.\n\n這個重置不是一個簡單的清除命令."
recap_temp.Localize.LogHeader = "__ Recap [%.2f] (%s): 生成 %s for %s on %s in %s __"
recap_temp.Localize.LogFormat = "%35s ! %2s %3s !%9s %9s %9s !%8s %4s !%8s %4s %6s !%8s %4s !%5s !%6s"
recap_temp.Localize.Log = { "角色", "Lv", "Cls", "時間", "承受時間", "治療時間", "冶療", "%%", "坦克", "%%", "承受DPS", "傷害", "%%", "最大", "DPS" }
recap_temp.Localize.HTMLHeader = "<tr><td colspan=\"15\">Recap [%.2f] (%s): 生成 %s for %s on %s in %s</td></tr>"
recap_temp.Localize.HTMLFormat1 = "<tr align=\"right\"><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td>"
recap_temp.Localize.HTMLFormat2 = "<td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>"
recap_temp.Localize.HTMLPrefix = "<table CELLPADDING=\"2\">"
recap_temp.Localize.HTMLSuffix = "</table>"
recap_temp.Localize.DetailHeader = "__ Recap %s: 生成詳情 for %s on %s in %s __"
recap_temp.Localize.DetailFormat = "%30s %18s !%8s %5s !%8s !%7s %6s %6s %6s !%5s %6s %6s %6s !%5s %6s %6s %6s !%5s %6s %6s %6s %7s !%4s %7s"
recap_temp.Localize.Detail = { "法術", "法系", "合計", "Pct", "最大", "反射", "最小", "平均", "最大", "命中", "最小", "平均", "最大", "Ticks", "最小", "平均", "最大", "暴擊", "最小", "平均", "最大", "Pct", "失敗", "Pct" }
recap_temp.Localize.HTMLDetailHeader = "<tr><td colspan=\"24\">Recap Recap 生成 %s for %s on %s in %s</td></tr>"
recap_temp.Localize.HTMLDetailFormat1 = "<tr align=\"right\"><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td>"
recap_temp.Localize.HTMLDetailFormat2 = "<td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td>"
recap_temp.Localize.HTMLDetailFormat3 = "<td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>"
recap_temp.Localize.NoFreeChannels = "已沒有多餘的頻道來建立記錄.請離開一個頻道後再次嘗試."
recap_temp.Localize.NoChannelNumber = "無法獲得一個頻道編號."
recap_temp.Localize.LogWritten = "Recap已寫入WOWChatLog.txt"
recap_temp.Localize.ConfirmGlobalSettings = "你已經選擇啟用全局設置.\n\n如果你同意,此插件將重新載入，一些個性信息將丟失."
recap_temp.Localize.ConfirmSeparateSettings = "你已經選擇關閉全局設置.\n\n如果你同意,此插件將重新載入，每個角色將單獨保存設定."
recap_temp.Localize.LotsOfDataWarning = "Recap有%d個戰鬥成員\"活動\"數據.已經很多了.\n\n這個消息並不代表你的內存不夠.你能關閉這個警告, 關閉方法在參數設置 / 設置 / 數據設置.\n\n如果你不希望再看到它: /recap然後單擊參數設置.\n\n如果你不希望繼續累積數據, 暫停它.\n\n建議你經常重置, 以使戰鬥數據保持比較小的內存用量.\n\nIf you are in a synchronization the '重置所有戰鬥' button will be disabled."
recap_temp.Localize.VersionCheck = "Recap文件也許被損壞了.請重新下載."
recap_temp.Localize.ConfirmIgnoreGUIDs = "You've chosen to ignore global unique identifiers.\n\nIf you accept, Recap will be reset and synchronization will not be allowed."
recap_temp.Localize.ConfirmUseGUIDs = "You've chosen to use global unique identifiers.\n\nIf you accept, Recap will be reset."
recap_temp.Localize.NotAllowedDuringCombat = "Recap: 同步期間不允許"
recap_temp.Localize.InvitesYouToSynchronize = "邀請你加入同步"
recap_temp.Localize.NewSynchronization = "新同步"
recap_temp.Localize.OngoingSynchronization = "同步中的"
recap_temp.Localize.AcceptedSync = "同意你的同步邀請"
recap_temp.Localize.DeclinedSync = "謝絕你的同步邀請"
recap_temp.Localize.MergePetsOff = "關閉合並寵物"
recap_temp.Localize.MergePetsOn = "開啟合並寵物"
recap_temp.Localize.Timestamp = "時間戳"
recap_temp.Localize.Leader = "領導"
recap_temp.Localize.LastUpdateWas = "最後更新是"
recap_temp.Localize.Ago = " (hh:mm:ss) 以前"
recap_temp.Localize.FailSendInvite = "發送同步邀請時錯誤"
recap_temp.Localize.FailSendAccept = "接受同步邀請時錯誤"
recap_temp.Localize.FailSendDecline = "謝絕同步邀請時錯誤"
recap_temp.Localize.FailSendSummary = "發送同步摘要錯誤"
recap_temp.Localize.FailSendReply = "發送同步數據錯誤"
recap_temp.Localize.FailSendHeartbeat = "發送同步頻率錯誤"
recap_temp.Localize.FailSendSkipNextFight = "Failed to send skip next fight"
recap_temp.Localize.SkipNextFightBegins = "Skip Next Fight begins"
recap_temp.Localize.SkipNextFightEnds = "Skip Next Fight ends"
recap_temp.Localize.NotAllowedDuringSync = "Recap: 同步期間不允許"
recap_temp.Localize.RemindJoinGroup = "Recap: 你已經加入團隊."
recap_temp.Localize.RemindLeaveGroup = "Recap: 你已經離開團隊."
recap_temp.Localize.RemindEnterInstance = "Recap:你已進入一個區域. 提示你以便有所准備."
recap_temp.Localize.RemindLeaveInstance = "Recap:你已離開一個區域. 提示你以便有所准備"
recap_temp.Localize.OutOfDateSyncVersion = "你不能加入同步,因為你的Recap版本過老."
recap_temp.Localize.SyncMembers = "同步成員"
recap_temp.Localize.InactiveSyncMembers = "閑置的同步成員"
recap_temp.Localize.InSync = "同步中"
recap_temp.Localize.Unknown = "未知"
recap_temp.Localize.Removed = "已移除"
recap_temp.Localize.OtherDataModeNotEnabled = "其它數據模式未啟用"
recap_temp.Localize.MatrixDataModeNotEnabled = "矩陣數據模式未啟用"
recap_temp.Localize.NotAvailable = "無效的"
recap_temp.Localize.Attacks = "攻擊"
recap_temp.Localize.Dispels = "驅散"
recap_temp.Localize.Interrupts = "Interrupts"
recap_temp.Localize.Durability = "Durability"
recap_temp.Localize.Interrupted = "Interrupted"
recap_temp.Localize.Died = "died"
recap_temp.Localize.Killed = "killed"
recap_temp.Localize.TimeWindow = "Time Window"
recap_temp.Localize.AllCombatants = "All Combatants"


-- menus
recap_temp.Localize.ColumnMenu = { {Text="列表編號",Info="Ranks"}, {Text="陣營/等級",Info="Faction"}, {Text="職業",Info="Class"},
								{Text="First Seen",Info="Seen"}, {Text="死亡",Info="Kills"}, {Text="戰鬥時間",Info="Time"}, {Text="承受傷害時間",Info="TimeIn"},
								{Text="治療時間",Info="TimeHeal"}, {Text="治療",Info="Heal"}, { Text="治療%",Info="HealP"},
								{Text="過量治療",Info="Over"}, {Text="傷害承受",Info="DmgIn"}, {Text="傷害承受%",Info="DmgInP"},
								{Text="傷害輸出",Info="DmgOut"}, {Text="傷害輸出%",Info="DmgOutP"}, {Text="最大命中",Info="MaxHit"},
								{Text="HPS",Info="HPS"}, {Text="DPS承受",Info="DPSIn"},
								{Text="DPS輸出",Info="DPS"}, {Text="DPS對比全部",Info="DPSvsAll"} }
recap_temp.Localize.MinMenu = { {Text="鎖定窗口", Info="Pin"}, {Text="狀態燈",Info="MinStatus"}, {Text="同步燈",Info="MinSyncStatus"}, {Text="最後/全部",Info="MinView"},
								{Text="你的DPS",Info="MinYourDPS"}, {Text="合計DPS承受",Info="MinDPSIn"}, {Text="合計DPS輸出",Info="MinDPSOut"},
								{Text="你的HPS",Info="MinYourHPS"}, {Text="總量HPS",Info="MinHPS"},
								{Text="按鈕",Info="MinButtons"}, {Text="背景",Info="MinBack"} }
recap_temp.Localize.AddMenu = { {Text="添加友方",Info="MenuAdd"}, {Text="重置",Info="MenuReset"}, {Text="忽略",Info="MenuIgnore"} }
recap_temp.Localize.AddLockMenu = { {Text="添加友方",Info="MenuAdd"}, {Text="重置",Info="MenuReset"}, {Text="忽略",Info="MenuIgnore"}, {Text="鎖定",Info="MenuLock"} }
recap_temp.Localize.AddUnlockMenu = { {Text="添加友方",Info="MenuAdd"}, {Text="重置",Info="MenuReset"}, {Text="忽略",Info="MenuIgnore"}, {Text="解鎖",Info="MenuUnlock"} }
recap_temp.Localize.DropMenu = { {Text="刪除友方",Info="MenuDrop"}, {Text="重置",Info="MenuReset"}, {Text="忽略",Info="MenuIgnore"} }
recap_temp.Localize.DropLockMenu = { {Text="刪除友方",Info="MenuDrop"}, {Text="重置",Info="MenuReset"}, {Text="忽略",Info="MenuIgnore"}, {Text="鎖定",Info="MenuLock"} }
recap_temp.Localize.DropUnlockMenu = { {Text="刪除友方",Info="MenuDrop"}, {Text="重置",Info="MenuReset"}, {Text="忽略",Info="MenuIgnore"}, {Text="解鎖",Info="MenuUnlock"} }
recap_temp.Localize.DetailTitle = { ["Total"] = "合計", ["Avg"] = "均值", ["Max"] = "最大", ["CritP"] = "暴擊率%", ["MissPOverP"] = "失敗/過量%" }
recap_temp.Localize.DetailMenu = { {Text="合計傷害",Info="Total"}, {Text="平均命中",Info="Avg"}, {Text="最大命中",Info="Max"}, {Text="暴擊率",Info="CritP"}, {Text="失敗率/過量治療率",Info="MissPOverP"} }
recap_temp.Localize.EffectMenu = { {Text="重置詳情",Info="ResetEffect"} }
recap_temp.Localize.EffectOptMenu = { {Text="法系",Info="EElement"}, {Text="合計",Info="ETotal"}, {Text="合計%",Info="ETotalP"},
									{Text="最大傷害",Info="EMaxAll"}, {Text="反射",Info="EGlances"}, {Text="最小反射",Info="EGlancesMin"}, {Text="平均反射",Info="EGlancesAvg"},
									{Text="最大反射",Info="EGlancesMax"}, {Text="命中",Info="EHits"}, {Text="最小命中",Info="EHitsMin"}, {Text="平均命中",Info="EHitsAvg"},
									{Text="最大命中",Info="EHitsMax"}, {Text="Ticks",Info="ETicks"}, {Text="最小Tick",Info="ETicksMin"}, {Text="平均Tick",Info="ETicksAvg"},
									{Text="最大Tick",Info="ETicksMax"}, {Text="暴擊",Info="ECrits"}, {Text="最小暴擊",Info="ECritsMin"}, {Text="平均暴擊",Info="ECritsAvg"},
									{Text="最大暴擊",Info="ECritsMax"}, {Text="暴擊率",Info="ECritsP"}, {Text="失敗",Info="EMiss"},
									{Text="最小等級",Info="EMissP"} }

-- auto-post drop down choices
recap_temp.Localize.StatDropList = { "DPS", "傷害", "承受", "治療" }
recap_temp.Localize.ChannelDropList = { "自己", "隊伍", "說", "團隊", "公會" }

recap_temp.Localize.MissTypes = { ["Missed"] = "未命中", ["Dodged"] = "躲避", ["Parried"] = "閃避", ["Blocked"] = "格擋", ["Deflected"] = "偏斜",
								 ["Resisted"] = "抵抗", ["Reflected"] = "反射", ["Absorbed"] = "吸收", ["Immune"] = "免疫", ["Evaded"] = "逃脫" }

recap_temp.Localize.ClassName = { ["WARRIOR"] = "戰士", ["MAGE"] = "法師", ["ROGUE"] = "盜賊", ["DRUID"] = "德魯伊",
								 ["HUNTER"] = "獵人", ["SHAMAN"] = "薩滿", ["PRIEST"] = "牧師", ["WARLOCK"] = "術士",
								 ["PALADIN"] = "聖騎士", ["Pet"] = "寵物" }
recap_temp.Localize.ClassAbbr = { ["WARRIOR"] = "ZS", ["MAGE"] = "FS", ["ROGUE"] = "DZ", ["DRUID"] = "XD",
								 ["HUNTER"] = "LR", ["SHAMAN"] = "SM", ["PRIEST"] = "MS", ["WARLOCK"] = "SS",
								 ["PALADIN"] = "SQ", ["Pet"] = "寵" }
recap_temp.Localize.FactionName = { ["Alliance"] = "聯盟", ["Horde"] = "部落" }
recap_temp.Localize.SchoolName = { [1] = "Physical", [2] = "Holy", [4] = "Fire", [8] = "Nature", [16] = "Frost", [32] = "Shadow", [64] = "Arcane" }
recap_temp.Localize.PowerName = { [0] = "Mana", [1] = "Rage", [2] = "Focus", [3] = "Energy", [4] = "Happiness", [-2] = "Health" }


-- channels to block when posting Recent Combat Event information (lower case) (traditional Chinese)
recap_temp.Localize.BlockChannels = { "綜合", "交易", "本地防務", "世界防務", "公會招募", "大喊", "寻求组队" }

end -- of the localization

localization_tw_lua_411 = true
