﻿if not ((GetLocale() == "deDE") or (GetLocale() == "zhCN") or (GetLocale() == "zhTW")) then

--[[ Miscellaneous variables and localization strings for Recap ]]

recap_temp = {}; -- other global values (not saved to SavedVariables)

--[[ Tooltips, option indexes ]]

-- First field each line MUST NOT CHANGE (they are option ids)
-- the order MUST NOT CHANGE until HeaderTime.  They are in the order of GetID values
recap_temp.OptList = {
	{ "UseColor", "Use Color", "When checked, combatants in the group and damage dealt to others are colored green, incoming damage is colored red, and healing is colored blue." },	-- 1
	{ "GrowUpwards", "Expand Window Up", "When checked, the window's bottom edge will remain anchored while the top edge resizes." },
	{ "GrowLeftwards", "Expand Window Left", "When checked, the window's right edge will remain anchored while the left edge resizes." },
	{ "ShowTooltips", "Show Tooltips", "When checked, tooltips like the one you're reading will be shown." },
	{ "AutoHide", "Auto Hide Entering Combat", "When checked, and the window isn't minimized, it will hide when a fight begins and reappear when the fight ends." },
	{ "AutoFade", "Auto Fade Window", "When checked, and the window isn't minimized, the window will fade after your mouse leaves the window." },
	{ "LimitFights", "Limit Fights to Combat", "When checked, fight logging will not begin until you enter combat mode.  Recommended Off unless you don't want to log fights around you." },
	{ "HideZero", "Show Only Fights with Duration", "When checked, fights without a duration will not be shown.  Use this to hide damage done to totems, critters, etc." },
	{ "HideOthers", "Hide Other Combatants", "When checked, hides all other combatants who are not in the group.  This will include allies, neutrals, and foes.\n\nThis option should normally be turned off." },
	{ "IdleFight", "End Fight if Idle", "When checked, fights will end if no hits or healing happen for a length of time." }, -- 10
	{ "Time", "Display Time", "When checked, each combatants' time fighting will be displayed in the list." },
	{ "MaxHit", "Display Max Hit", "When checked, each combatants' max hit will be displayed in the list." },
	{ "DmgIn", "Display Damage In", "When checked, each combatants' total damage received will be displayed in the list." },
	{ "DmgOut", "Display Damage Out", "When checked, each combatants' total damage dealt to others will be displayed in the list." },
	{ "DPSIn", "Display DPS In", "When checked, each combatants' damage per second received will be displayed in the list." },
	{ "DPS", "Display DPS Out", "When checked, each combatants' damage per second dealt to others will be displayed in the list." },
	{ "MinStatus", "Display Status While Minimized", "When checked, the status light will remain visible while minimized." },
	{ "MinView", "Display Last/All While Minimized", "When checked, a small label indicating if you are watching the Last Fight or All Fights will be visible while minimized." },
	{ "MinYourDPS", "Display Your DPS Out While Minimized", "When checked, the damage per second that you dealt will be displayed in minimized view." },
	{ "MinDPSIn", "Display Total DPS In While Minimized", "When checked, the total damage per second combatants in the group received will be displayed in minimized view." }, -- 20
	{ "MinDPSOut", "Display Total DPS Out While Minimized", "When checked, the total damage per second combatants in the group dealt to others will be displayed in minimized view." },
	{ "MinButtons", "Display Buttons While Minimized", "When checked, the buttons along the top-right edge (Close, Pin, Pause, Options, Last/All) will remain visible in minimized view." },
	{ "TooltipFollow", "Tooltips At Pointer", "When checked, tooltips will follow the pointer instead of using the default tooltip placement. Note: Many mods override default tooltip behavior." },
	{ "SaveGroup", "Save Group Only", "When checked, only combatants currently marked as a being in the group will be saved to fight data sets.  To change the group status of a combatant, right-click their name." },
	{ "ReplaceSet", "Replace Existing Data", "When checked, sets saved and loaded will replace existing data.  Otherwise the data will merge." },
	{ "Heal", "Display Heals", "When checked, each combatants' healing done (actual) will be displayed in the list.  Overhealing has been subtracted from this value." },
	{ "Kills", "Display Deaths", "When checked, the number of deaths for each combatant will be displayed in the list." },
	{ "HideYardTrash", "Show Only Unique Combatants", "When checked, combatants not in the group that have more than one with the same name will be hidden.  Useful in single instance runs to hide yard trash or common mobs." },
	{ "place_holder_29", "", "" },
	{ "Faction", "Display Faction/Level", "When checked, if a combatant's faction and level are known they will be displayed by their name." }, -- 30
	{ "Class", "Display Class", "When checked, if a combatant's class is known its icon will be displayed by their name." },
	{ "HealP", "Display Heals %", "When checked, a percentage of total heals (actual) will be displayed for each combatant in the group." },
	{ "DmgInP", "Display Damage In %", "When checked, a percentage of total damage received will be displayed for each combatant in the group." },
	{ "DmgOutP", "Display Damage Out %", "When checked, a percentage of total damage dealt to others will be displayed for each combatant in the group." },
	{ "AutoPost", "Auto Post Results", "When checked, a summary will be reported at the end of each fight to the channel selected below." },
	{ "MinBack", "Display Back While Minimized", "When checked, the background will remain opaque in minimized view." },
	{ "MergePets", "Merge Pets with Owners", "When checked, from that point on, all pet damage will be credited to its owner.  When unchecked, from that point on, all pet damage will be credited to the pet." },
	{ "AutoMinimize", "Auto Minimize", "When checked, the window will minimize automically when the pointer leaves the window, and expand when the pointer enters the window.  Holding the Shift key or selecting a combatant will override this behavior." },
	{ "ShowPanel", "Show Details", "When checked, a side panel showing more detailed information will be shown as you move the pointer over combatants.  Select a combatant to lock the panel.  In Light Data Mode, only the Summary details will be available." },
	{ "LightData", "Light Data Mode", "When checked, extra information such as misses and damage breakdowns will not be collected or stored.\n\nWhen unchecked, misses and damage details will accumulate into the Details panel.\n\nNote: For now, Personal Details will not accumulate while in Light Data Mode." }, -- 40
	{ "ShowGauges", "Show Gauges", "When checked, gauges will appear behind combatants in the group for a visual indicator of damage or healing.\n\nCurrently gauges only work for damage in, damage out and healing.  To choose which gauges to use, sort by one of those three methods.\n\nYou can sort by left-clicking on the header above the column, ie Heal, In, Out or %." },
	{ "AutoLeader", "Auto Post New Leaders", "When checked, changes in leadership of the stat chosen below will be automatically posted to the selected channel." },
	{ "Ranks", "Numbered List", "When checked, the list will be numbered." },
	{ "DPSvsAll", "Display DPS vs All", "When checked, a DPS value will be displayed reflecting each individual's damage over the total time everyone was fighting." },
	{ "Over", "Overhealing", "When checked, an estimated overhealing percentage will be displayed for every combatant in the group for All Fights.  The overhealing is not part of the values in the Heal column.\n\nRemember: Mana-efficient healers use the slow beefy heals.  Paladins and other healers snipering small fast heals while the better heals are incoming are going to unfairly make the mana-efficient healer look worse than the mana-inefficient snipers.\n\nDo not use this as a gauge of healer capability or contribution." },
	{ "HTML", "Format in HTML", "When checked, logs written to WOWChatLog.txt or the clipboard will be formatted into a simple HTML table." },
	{ "WriteGroup", "Write Only Group", "When checked, reports will only be written for combatants in the group." },
	{ "ETotal", "Display Totals", "When checked, the total damage or healing for each effect will be shown in personal details." },
	{ "ETotalP", "Display Total Contribution", "When checked, the contribution of this effect to the whole will be shown in personal details." },
	{ "EHits", "Display Hits", "When checked, the number of non-crit non-glance hits will be shown in personal details." }, -- 50
	{ "EHitsAvg", "Display Average Hit", "When checked, the average non-crit non-glance hit will be shown in personal details." },
	{ "EHitsMax", "Display Max Hit", "When checked, the maximum non-crit non-glance hit will be shown in personal details." },
	{ "ETicks", "Display Ticks", "When checked, the number of ticks will be shown in personal details." },
	{ "ETicksAvg", "Display Average Tick", "When checked, the average tick amount will be shown in personal details." },
	{ "ETicksMax", "Display Max Tick", "When checked, the maximum tick amount will be shown in personal details." },
	{ "ECrits", "Display Crits", "When checked, the number of crits will be shown in personal details." },
	{ "ECritsAvg", "Display Average Crit", "When checked, the average crit will be shown in personal details." },
	{ "ECritsMax", "Display Max Crit", "When checked, the maximum crit will be shown in personal details." },
	{ "ECritsP", "Display Crit Rate", "When checked, the crit rate for each effect will be shown in personal details." },
	{ "EMiss", "Display Misses", "When checked, the number of misses for each effect will be shown in personal details.  For non-melee this is miss, deflects and resists.  For melee this includes block, parry and dodge." }, -- 60
	{ "EMissP", "Display Miss Rate", "When checked, the miss rate for each effect will be shown in personal details." },
	{ "EMaxAll", "Display Maximum Damage", "When checked, the maximum damage from a single hit, tick or crit for each effect will be shown in personal details." },
	{ "WarnData", "Warn When Data Grows Too Large", "When checked, a message will remind you on login when your live data contains more than 1000 combatants.\n\nRecap can function perfectly fine with over 1000 combatants, but some users may not be aware that they are accumulating a lot of data they may not be interested in." },
	{ "HPS", "Display HPS Out", "When checked, each combatants' healing (actual) per second delivered will be displayed in the list." },
	{ "place_holder_65", "", "" },
	{ "RecentData", "Recent Data Mode", "When checked, recent events are remembered.\n\nWhen this option is enabled, to see recent Outgoing and Incoming events for a combatant, click on the Recent button to the right of their name on the Outgoing Details or Incoming Details tabs.  You can also double-click on the combatant's row.  If you hold the control key down while clicking then the recent events will show dispels only.\n\nFor recent Incoming and Outgoing events for a spell or ability for a combatant, click on the Recent button to the right of the spell or ability, either in the Personal Details panel or in the Outgoing Details or Incoming Details tabs.\n\nRecap does not write the events to disk.  Recap starts with an empty buffer whenever you log in or reload the UI.\n\nWarning: When active, Recent Data Mode uses additional memory." },
	{ "IgnoreGUIDs", "Ignore Global Unique Identifiers", "When checked, ignore the global unique identifiers provided for combatants with WoW patch 2.4 and later.  This will give behaviour similar to older versions of Recap, and will use significantly less memory.\n\nChanging this option forces a Reset.\n\nIf this option is checked then synchronization is not allowed." },
	{ "HideGroup", "Hide Group", "When checked, hides other combatants in the group (and their pets if any).  Group includes a party of five or a raid of forty.  Group also includes any combatant that you have added using the right-click dropdown menu.\n\nThis option should normally be turned off." },
	{ "EElement", "Display Element", "When checked, the element (Arcane, Fire, etc.) for each effect will be shown in personal details." },
	{ "TimeIn", "Display Time Damage In", "When checked, each combatants' time taking damage will be displayed in the list." }, -- 70
	{ "TimeHeal", "Display Time Healing", "When checked, each combatants' time healing will be displayed in the list." },
	{ "EnableSync", "Enable Synchronization", "When checked, Recap will be ready to initiate or receive synchronization with other players.  You will be invited to join any new or ongoing synchronization within your group.\n\nWhen unchecked, Recap will leave any current synchronization, and will ignore any future synchronization requests.\n\nNot allowed if the Ignore Global Unique Identifiers option is checked." },
	{ "OpaqueBackground", "Opaque Background", "When checked, all panels have an opaque black background." },
	{ "MinimizeOnEscape", "Minimize on Escape", "When checked, the main Recap panel will minimize when the Escape key is pressed." },
	{ "MinSyncStatus", "Display Sync Status While Minimized", "When checked, the sync status light will remain visible while minimized." },
	{ "RemindGroupStatus", "Remind on Joining or Leaving Group", "When checked, a popup message will show whenever you join or leave a group, to remind you to do whatever it is that you wanted to be reminded to do.  Perhaps you wanted to Reset every time you join a group." },
	{ "Seen", "First Seen", "When checked, the time that this combatant was first seen in the combat log will be displayed in the list." },
	{ "CollectGarbage", "Collect Garbage at End of Fight", "When checked, Recap will trigger a garbage collection at the end of each fight.  The game will lag briefly, from less than a second to a second or two, depending on how fast your machine is and how much memory your addons are using.\n\nThe idea is that it is better to have a lag at the end of a fight when it doesn't matter much, rather than risk having that lag during a fight." },
	{ "OtherData", "Other Data Mode", "When checked, Recap will track events that neither damage nor heal.  These include spell casts, debuffs/losses, and buffs/gains.\n\nIf this option is enabled, the information can be found on the Other Details tab of the popup panel.\n\nThis information is not tracked if the Light Data Mode option is enabled." },
	{ "EHitsMin", "Display Min Hit", "When checked, the minimum non-crit non-glance hit will be shown in personal details." },  -- 80
	{ "ETicksMin", "Display Min Tick", "When checked, the minimum tick amount will be shown in personal details." },
	{ "ECritsMin", "Display Min Crit", "When checked, the minimum crit will be shown in personal details." },
	{ "EGlances", "Display Glances", "When checked, the number of glances will be shown in personal details." },
	{ "EGlancesMin", "Display Min Glance", "When checked, the minimum glance will be shown in personal details." },
	{ "EGlancesAvg", "Display Average Glance", "When checked, the average glance will be shown in personal details." },
	{ "EGlancesMax", "Display Max Glance", "When checked, the maximum glance will be shown in personal details." },
	{ "RemindInstanceStatus", "Remind on Entering or Leaving Instance", "When checked, a popup message will show whenever you enter or leave an instance, to remind you to do whatever it is that you wanted to be reminded to do.  Perhaps you wanted to Reset or Save every time you enter an instance." },
	{ "StoreOnlyDisplayed", "Store Only Displayed Combatants", "When checked, data for combatants who are hidden as a result of turning on Hide Group or Hide Other Combatants will not be tracked and stored.\n\nData already stored for a combatant who is currently hidden will not be removed.\n\nThis option is ignored during synchronization.\n\nWarning: Sometimes Blizzard and Recap will not immediately determine that a combatant is in the group, or is a player's pet.  If there is a delay the early data may be lost.\n\nRecommended Off unless you are desperate to save computer memory." },
	{ "MinYourHPS", "Display Your HPS While Minimized", "When checked, the healing per second that you do will be displayed in minimized view." },
	{ "MinHPS", "Display Total HPS While Minimized", "When checked, the total healing per second combatants in the group do will be displayed in minimized view." },  -- 90
	{ "MatrixData", "Matrix Data Mode", "When checked, Recap will track who damaged who, who healed who, who was damaged by whom, and who was healed by whom.\n\nIf this option is enabled, the information can be found on the Target of Outgoing Details (shield leaning left) and Source of Incoming Details (sword pointing left) tabs of the popup panel.\n\nThis information is not tracked if the Light Data Mode option is enabled." },
	{ "SetScale", "Set Scale", "Set the scale of the Recap panels." },

	-- tooltips that don't change can go below in any order. Ensure future options go above these
	{ "HeaderSeen", "First Seen", "This is the time that this combatant was first seen in the combat log." },
	{ "HeaderTime", "Fight Time", "This is the time each combatant fought from their first point of damage to their last." },
	{ "HeaderTimeIn", "Time Damaged", "This is the time each combatant took damage from their first point of receiving damage to their last." },
	{ "HeaderTimeHeal", "Time Healing", "This is the time each combatant healed from their first point of healing to their last." },
	{ "HeaderMaxHit", "Max Hit", "This is the maximum damage each combatant dealt to others in a single hit or spell." },
	{ "HeaderDmgIn", "Damage In", "This is the damage received (tanked) by each combatant." },
	{ "HeaderDmgOut", "Damage Out", "This is the damage dealt to others by each combatant." },
	{ "HeaderHPS", "Individual HPS Out", "This is the personal Healing Per Second (actual) delivered by each combatant, based on the duration from their first to last attempted point of healing." },
	{ "HeaderDPSIn", "Individual DPS In", "This is the personal Damage Per Second received by each combatant, based on the duration from their first to last attempted point of damage received." },
	{ "HeaderDPS", "Individual DPS Out", "This is the personal Damage Per Second dealt to others by each combatant, based on the duration from their first to last attempted point of damage dealt." },
	{ "HeaderHeal", "Heals Out", "This is the hit points healed (actual) by this combatant (actual heal is the spell amount minus the overheal amount)." },
	{ "HeaderKills", "Death Count", "This is the number of times this combatant died within logging distance." },
	{ "Options", "Open Options", "Summon or dismiss the options window to change settings or manage fight data sets." },
	{ "SyncStatus", "Synchronization Status", "This light is blue if you are in a synchronization, and is grey otherwise.  The blue light will blink while synchronization data is being exchanged." },
	{ "TooltipMinYourDPS", "Your DPS Out", "This is your personal DPS dealt, including pet." },
	{ "TooltipMinDPSIn", "Total DPS In", "This is the total damage per second received by combatants in the group." },
	{ "TooltipMinDPSOut", "Total DPS Out", "This is the total damage per second dealt to others from combatants in the group." },
	{ "TooltipMinYourHPS", "Your HPS", "This is your personal healing per second done, including pet." },
	{ "TooltipMinHPS", "Total HPS", "This is the total healing per second done by combatants in the group." },
	{ "AutoFadeSlider", "Auto Fade Timer", "This is the time before the window fades after you leave it if Auto Fade Window is checked." },
	{ "SetScaleSlider", "Set Scale", "This is the scale of the Recap panels, from small (0.5) to large (2.0).\n\nChanging the scale will move the Recap panels into the centre of the screen, and you will need to move them back to where you want them." },
	{ "IdleFightSlider", "Fight Idle Timer", "This is the idle time before a fight will end if End Fight if Idle is checked." },
	{ "EndFightDelaySlider", "End of Fight Delay", "A fight will not be ended until this time has elapsed after the player left combat.  This prevents short 'out of combat' gaps from ending a fight prematurely.\n\nIf combats are going on around you then your 'current fight' may not end even if you enter and leave combat multiple times.  If this causes you problems, reduce this delay.  If the delay is set to zero than the behaviour is the same as in earlier versions of Recap." },
	{ "RecentEventCountSlider", "Recent Event Count", "This is the number of recent events that can be remembered.\n\n slider can only be changed when Recent Data Mode is not active.\n\nWarning: The larger this number, the more memory that Recap will need." },
	{ "ExitRecap", "Exit Recap", "Fight monitoring is suspended. Click here to shut down Recap completely." },
	{ "HideWindow", "Hide Window", "Continue monitoring fights, but hide this window." },
	{ "ExpandWindow", "Expand Window", "Expand window to show fight details." },
	{ "MinimizeWindow", "Minimize Window", "Minimize window and hide fight details." },
	{ "UnPinWindow", "Unpin Window", "Allow window to be moved." },
	{ "PinWindow", "Pin Window", "Prevent window from being moved." },
	{ "Resume", "Resume Monitoring", "Fight logging is currently suspended.  Click here to start watching fights." },
	{ "PauseMonitoring", "Pause Monitoring", "Click here to stop watching fights.  If you dismiss Recap while paused, it will not attempt to log any fights until you summon it." },
	{ "ShowAllFights", "Show All Fights", "Currently the window is displaying the result of the last fight.  Click here to show all fights since last reset." },
	{ "ShowLastFight", "Show Last Fight", "Currently the window is displaying all fights since the last reset.  Click here to show only the last fight." },
	{ "CombatLast", "Combatants for Last Fight", "This is a list of all combatants that did damage, took damage, or healed in the last fight.  To change group status, right-click the name." },
	{ "CombatAll", "Combatants for All Fights", "This is a list of all combatants that did damage, took damage, or healed since your last reset.  To change group status, right-click the name." },
	{ "ResetLastFight", "Reset Last Fight", "This will SUBTRACT the fight data for the last fight.  Note: Max hits and Overheals can only be reset by resetting All Fights." },
	{ "ResetAllTotals", "Reset All Totals", "This will wipe all active fight data for all combatants, except for those stored in Fight Data Sets and Personal Details.  Fight Data Sets can only be deleted from within options.  Personal Details can only be reset while they are visible." },
	{ "SaveAllSet", "Save All Fights Data Set", "Click here to save the current fight data for All Fights." },
	{ "SaveLastSet", "Save Last Fight Data Set", "Click here to save the current fight data for Last Fight." },
	{ "LoadSet", "Load Fight Data Set", "Click here to load the selected fight data.\n\nWarning: Loading a data set will overwrite your current data." },
	{ "DeleteSet", "Delete Fight Data Set", "Click here to delete the selected fight data set." },
	{ "DataSetEdit", "Fight Data Set Name", "Select a data set listed above or enter a new name here to create a new data set." },
	{ "OptExit", "Exit Recap", "Suspend fight monitoring and exit Recap completely."},
	{ "OptOk", "Close", "Close the options panel."},
	{ "HeaderHealP", "% Heals", "This is the percent of total heals (actual) for each combatant in the group." },
	{ "HeaderDmgInP", "% Damage In", "This is the percent of total for each combatants' damage received." },
	{ "HeaderDmgOutP", "% Damage Out", "This is the percent of total for each combatants' damage dealt to others." },
	{ "OptTab1", "Display Options", "These options define what elements of the window to display in its various forms.\n\nNote: None of the display settings affect data.  You can turn off everything for normal use, and later reveal elements you want to see." },
	{ "OptTab2", "General Settings", "These options define window behavior, limits to data and miscellaneous options." },
	{ "OptTab3", "Fight Data Sets", "Here you can manage Fight Data Sets.  Fight Data Sets are compact archives of the 'All Fights' view or of the 'Last Fight' view." },
	{ "OptTab4", "Reporting Options", "Here you can set options for reporting, initiate chat logging, and send reports to a clipboard." },
	{ "OptTab5", "Synchronization", "Here you can manage synchronization for Recap.  Recap synchronizes the All Fights summary information at the end of each fight.  Other Recap information is not currently synchronized." },
	{ "MaxRowsSlider", "Maximum Rows", "Adjust this to change the maximum rows the window can grow." },
	{ "MaxRankSlider", "Maximum Lines", "This adjusts a limit on how many lines to report to chat." },
	{ "PanelClose", "Close Panel", "Hide this details panel.  Information will still be accumulated while this is hidden.  To stop accumulating detailed information, check 'Light Data Mode' in options." },
	{ "PanelTab1", "Incoming Details: Tanking", "This tab will show information on incoming damage, healing, and misses to this combatant." },
	{ "PanelTab2", "Source of Incoming", "This tab will show information on the sources of incoming damage and healing to this combatant.\n\nThe option to track this information is off by default.  To track this information enable the Matrix Data Mode on the Options / Settings panel." },
	{ "PanelTab3", "Outgoing Details: Damage", "This tab will show information on outgoing damage and heals from this combatant." },
	{ "PanelTab4", "Target of Outgoing", "This tab will show information on the targets of outgoing damage and healing from this combatant.\n\nThe option to track this information is off by default.  To track this information enable the Matrix Data Mode on the Options / Settings panel." },
	{ "PanelTab5", "Other Details: Casts Debuffs/Losses Buffs/Gains", "This tab will show information on casts (in green), debuffs and losses (in red), buffs and gains (in blue), and effects whose exact type is unknown (in white).\n\nThese include almost all Blizzard effects that neither damage nor heal.\n\nThe option to track this information is off by default.  To track this information enable the Other Data Mode on the Options / Settings panel." },
	{ "PanelTab6", "All Details: Summary", "This tab will show a summary of information about this combatant." },
	{ "PanelTabDisabled1", "Incoming Details: Tanking (Disabled)", "You are currently in Light Data Mode.  Tanking details are not collected.\n\nUncheck Light Data Mode in options to collect incoming damage and misses to each combatant." },
	{ "PanelTabDisabled2", "Source of Incoming (Disabled)", "You are currently in Light Data Mode.  Source details are not collected.\n\nUncheck Light Data Mode in options to collect incoming damage and misses to each combatant." },
	{ "PanelTabDisabled3", "Outgoing Details: Damage (Disabled)", "You are currently in Light Data Mode.  Damage details are not collected.\n\nUncheck Light Data Mode in options to collect outgoing damage details for each combatant." },
	{ "PanelTabDisabled4", "Target of Outgoing (Disabled)", "You are currently in Light Data Mode.  Target details are not collected.\n\nUncheck Light Data Mode in options to collect outgoing damage details for each combatant." },
	{ "PanelTabDisabled5", "Other Details: Casts Debuffs/Losses Buffs/Gains (Disabled)", "You are currently in Light Data Mode.  Other details are not collected.\n\nUncheck Light Data Mode in options to collect other details for each combatant." },
	{ "RecentClose", "Close Panel", "Hide this details panel.  Information will still be accumulated while this is hidden." },
	{ "RecentTab1", "Recent Incoming Events", "This tab will show recent events that happened to this combatant, perhaps filtered by effect." },
	{ "RecentTab2", "Recent Outgoing Events", "This tab will show recent events generated by this combatant, perhaps filtered by effect." },
	{ "PanelEntry25", "Time (Last Fight)", "Time doing damage in last fight." },
	{ "PanelEntry26", "Max Hit (Last Fight)", "Maximum hit dealt in last fight." },
	{ "PanelEntry27", "Deaths (Last Fight)", "Number of times died in last fight." },
	{ "PanelEntry28", "Heals (Last Fight)", "Total healed (actual) in last fight." },
	{ "PanelEntry29", "Damage In (Last Fight)", "Total damage received in last fight." },
	{ "PanelEntry30", "DPS In (Last Fight)", "DPS In for last fight." },
	{ "PanelEntry31", "Damage Out (Last Fight)", "Total damage dealt to others in last fight." },
	{ "PanelEntry32", "DPS Out (Last Fight)", "DPS Out for last fight." },
	{ "PanelEntry33", "HPS Out (Last Fight)", "HPS Out (actual) for last fight." },
	{ "PanelEntry34", "HPS Out (All Fights)", "HPS Out (actual) for all fights." },
	{ "PanelEntry35", "Time (All Fights)", "Time doing damage in all fights." },
	{ "PanelEntry36", "Max Hit (All Fights)", "Maximum hit dealt in all fights." },
	{ "PanelEntry37", "Deaths (All Fights)", "Number of times died in all fights." },
	{ "PanelEntry38", "Heals (All Fights)", "Total healed (actual) in all fights." },
	{ "PanelEntry39", "Damage In (All Fights)", "Total damage received in all fights." },
	{ "PanelEntry40", "DPS In (All Fights)", "DPS In for all fights." },
	{ "PanelEntry41", "Damage Out (All Fights)", "Total damage dealt to others in all fights." },
	{ "PanelEntry42", "DPS Out (All Fights)", "DPS Out for all fights." },
	{ "PanelEntry45", "Total Damage or Healing", "Total damage dealt or healing done by this effect." },
	{ "PanelEntry46", "Number of Hits", "Number of times this effect landed without a crit, glance, or crush." },
	{ "PanelEntry47", "Number of Crits", "Number of times this effect landed with a crit." },
	{ "PanelEntry48", "Average Hit", "The average non-crit, non-glance, non-crush damage or healing from this effect." },
	{ "PanelEntry49", "Average Crit", "The average crit damage or healing from this effect." },
	{ "PanelEntry50", "Max Hit", "The maximum non-crit, non-glance, non-crush damage or healing from this effect." },
	{ "PanelEntry51", "Max Crit", "The maximum crit damage or healing from this effect." },
	{ "PanelEntry52", "Average Tick", "The average damage or healing this effect applied per tick." },
	{ "PanelEntry53", "Max Tick", "The maximum damage or healing this effect applied per tick." },
	{ "PanelEntry54", "Element", "The element (Arcane, Fire, etc.) for this effect." },
	{ "PanelEntry55", "Incoming Missed", "These are the misses from others' attacks." },
	{ "PanelEntry56", "Incoming Dodged", "These are the dodges from others' attacks." },
	{ "PanelEntry57", "Incoming Parried", "These are the parries from others' attacks." },
	{ "PanelEntry58", "Incoming Blocked", "These are the blocks from others' attacks." },
	{ "PanelEntry59", "Incoming Absorbed", "This is a combatant absorbing another's attack." },
	{ "PanelEntry60", "Incoming Evaded", "This is a combatant evading another's attack." },
	{ "PanelEntry61", "Incoming Deflected", "This is a combatant deflecting another's attack." },
	{ "PanelEntry62", "Incoming Resisted", "This is a combatant resisting another's attack." },
	{ "PanelEntry63", "Incoming Reflected", "This is a combatant reflecting another's attack." },
	{ "PanelEntry64", "Incoming Immune", "This is a combatant being immune to another's attack." },
	{ "PanelEntry65", "Crit Rate", "The relative amount of crits per hits attempted." },
	{ "PanelEntry66", "Number of Ticks", "Number of times someone suffered damage or gained health as a result of this effect." },
	{ "PanelEntry67", "Total Miss Rate", "The relative amount of misses per hits attempted.  This is the total of all of the kinds of miss detailed below." },
	{ "PanelEntry70", "Outgoing Missed", "This is a combatant's spell or ability missing." },
	{ "PanelEntry71", "Outgoing Dodged", "This is a combatant's spell or ability being dodged." },
	{ "PanelEntry72", "Outgoing Parried", "This is a combatant's spell or ability being parried." },
	{ "PanelEntry73", "Outgoing Blocked", "This is a combatant's spell or ability being blocked." },
	{ "PanelEntry74", "Outgoing Absorbed", "This is a combatant's spell or ability being absorbed." },
	{ "PanelEntry75", "Outgoing Evaded", "This is a combatant's spell or ability being evaded." },
	{ "PanelEntry76", "Outgoing Deflected", "This is a combatant's spell or ability being deflected." },
	{ "PanelEntry77", "Outgoing Resisted", "This is a combatant's spell or ability being resisted." },
	{ "PanelEntry78", "Outgoing Reflected", "This is a combatant's spell or ability being reflected." },
	{ "PanelEntry79", "Outgoing Immune", "This is a combatant's spell or ability missing because the target is immune." },
	{ "PanelEntry80", "Time In (Last Fight)", "Time taking damage in last fight." },
	{ "PanelEntry81", "Time In (All Fights)", "Time taking damage in all fights." },
	{ "PanelEntry82", "Time Heal (Last Fight)", "Time healing in last fight." },
	{ "PanelEntry83", "Time Heal (All Fights)", "Time healing in all fights." },
	{ "PanelEntry90", "Number of Crushes", "Number of times this effect landed as a crushing blow." },
	{ "PanelEntry91", "Average Crush", "The average crushing damage from this effect." },
	{ "PanelEntry92", "Max Crush", "The maximum crushing damage from this effect." },
	{ "PanelEntry93", "Crush Rate", "The relative amount of crushes per hits attempted." },
	{ "PanelEntry94", "Attribute", "The attribute gained or lost for this effect." },
	{ "PanelEntry95", "Total", "The total amount gained or lost for this effect.  For a debuff or buff that stacks, the total number of stack levels of the debuff or buff." },
	{ "PanelEntry96", "Hits", "The number of times that this effect occurred." },
	{ "PanelEntry97", "Average", "The average gain or loss for this effect.  For a debuff or buff that stacks, the average stack height reached by the debuff or buff." },
	{ "PanelEntry98", "Maximum", "The maximum gain or loss for this effect.  For a debuff or buff that stacks, the maximum stack height reached by the debuff or buff." },
	{ "PanelEntry99", "Dispels", "The number of times this effect has been dispelled." },
	{ "PanelEntry100", "Interval Count", "The number of time intervals sampled between occurrences of this effect." },
	{ "PanelEntry101", "Estimated Average Interval", "The estimated average time interval (in seconds) between occurrences of this effect.  This is an estimate only.\n\nNote: In an attempt to avoid problems from bad data points, Recap will ignore any interval over 130 seconds." },
	{ "PanelEntry102", "Misses", "The number of times this effect missed for any reason.  Recap does not currently track the reason." },
	{ "PanelEntry103", "Duration Count", "The number of time durations sampled for this effect." },
	{ "PanelEntry104", "Estimated Average Duration", "The estimated average time duration (in seconds) for this effect.  This is an estimate only.\n\nNote: In an attempt to avoid problems from bad data points, Recap will ignore any duration over 130 seconds." },
	{ "PanelEntry105", "Other Effect", "If this effect is shown in green, it is a cast; if shown in red, it is a debuff or a loss; if shown in blue it is a buff or a gain; and if shown in white it is either a debuff or a buff, but Recap can't tell which." },
	{ "PanelEntry106", "Number of Glances", "Number of times this effect landed as a glancing blow." },
	{ "PanelEntry107", "Average Glance", "The average glancing damage from this effect." },
	{ "PanelEntry108", "Max Glance", "The maximum glancing damage from this effect." },
	{ "PanelEntry109", "Glance Rate", "The relative amount of glancing blows per hits attempted." },
	{ "PanelEntry110", "Partial Absorbs", "The number of partial absorbs (does not include complete absorbs)." },
	{ "PanelEntry111", "Partial Absorbs Average", "The average amount of damage absorbed by partial absorbs (does not include complete absorbs)." },
	{ "PanelEntry112", "Partial Blocks", "The number of partial blocks (does not include complete blocks)." },
	{ "PanelEntry113", "Partial Blocks Average", "The average amount of damage blocked by partial blocks (does not include complete blocks)." },
	{ "PanelEntry114", "Partial Resists 25%", "The number of partial resists of 25% of damage (does not include complete resists)." },
	{ "PanelEntry115", "Partial Resists 25% Average", "The average amount of damage resisted by partial resists of 25% of damage (does not include complete resists)." },
	{ "PanelEntry116", "Partial Resists 50%", "The number of partial resists of 50% of damage (does not include complete resists)." },
	{ "PanelEntry117", "Partial Resists 50% Average", "The average amount of damage resisted by partial resists of 50% of damage (does not include complete resists)." },
	{ "PanelEntry118", "Partial Resists 75%", "The number of partial resists of 75% of damage (does not include complete resists)." },
	{ "PanelEntry119", "Partial Resists 75% Average", "The average amount of damage resisted by partial resists of 75% of damage (does not include complete resists)." },
	{ "PanelEntry120", "Steals", "The number of times this effect has been stolen." },
	{ "PanelEntry122", "Min Glance", "The minimum glancing damage or healing from this effect." },
	{ "PanelEntry123", "Min Hit", "The minimum non-crit, non-glance, non-crush damage or healing from this effect." },
	{ "PanelEntry124", "Min Crit", "The minimum crit damage or healing from this effect." },
	{ "PanelEntry125", "Min Crush", "The minimum crushing damage or healing from this effect." },
	{ "PanelEntry126", "Min Tick", "The minimum damage or healing this effect applied per tick." },
	{ "PanelEntry127", "Partial Absorbs Total", "The total amount of damage absorbed by partial absorbs (does not include complete absorbs)." },
	{ "PanelEntry128", "Partial Blocks Total", "The total amount of damage blocked by partial blocks (does not include complete blocks)." },
	{ "PanelEntry129", "Partial Resists 25% Total", "The total amount of damage resisted by partial resists of 25% of damage (does not include complete resists)." },
	{ "PanelEntry130", "Partial Resists 50% Total", "The total amount of damage resisted by partial resists of 50% of damage (does not include complete resists)." },
	{ "PanelEntry131", "Partial Resists 75% Total", "The total amount of damage resisted by partial resists of 75% of damage (does not include complete resists)." },
	{ "PanelEntry133", "Estimated Total Resisted", "This is an estimate of the total amount of damage resisted, including both complete resists and partial resists.  This is an estimate only.\n\nThe percentage can be used as an estimate of the overall effectiveness of resistance." },
	{ "PanelEntryOverheal", "Overhealing", "This is an estimated total of healing points that landed but didn't heal.  For example, a warrior at 4750/5000 life receives a heal for 1000, bringing them to 5000/5000.  750 were overhealed: 1000 spell heal minus 250 actual heal." },
	{ "OpenLog", "Open Log", "This will open the file named WOWChatLog.txt in WoW's Logs folder." },
	{ "ReportToLog", "Report to Log", "This will save a report on the current combatants, and a report on the player's personal details, to a file named WOWChatLog.txt in WoW's Logs folder.  It has some limitations imposed by the game:\n-The results will only be available at the end of a session when you log out. UI Reloads won't force a write.\n- You can report several times and they will append to the end.\n\nFor raid results or large lists, use Report to Clipboard instead." },
	{ "CloseLog", "Close Log", "This will close the file named WOWChatLog.txt." },
	{ "UseOneSettings", "Use Global Settings", "By default, settings and combatants are saved per character.  Checking this will use the current settings and combatants across all characters.\n\nNote: Settings and combatants currently stored on other characters will be deleted.\n\nThis option has no effect on the personal effect details.  Those are always player-specific." },
	{ "MenuAdd", "Add to Group", "Add this combatant to the list of group combatants." },
	{ "MenuDrop", "Drop from Group", "Remove this combatant from the list of group combatants." },
	{ "MenuReset", "Reset Combatant", "Reset this combatant.  In All Fights view this will reset their totals and details.  In Last Fight view it will just remove the last fight from totals." },
	{ "MenuIgnore", "Ignore Combatant", "Remove this combatant and ignore future occurances until reset." },
	{ "RecapAnchorTopLeft", "Anchor Top Left", "Anchor the window to grow from the top left." },
	{ "RecapAnchorTopRight", "Anchor Top Right", "Anchor the window to grow from the top right." },
	{ "RecapAnchorBottomLeft", "Anchor Bottom Left", "Anchor the window to grow from the bottom left." },
	{ "RecapAnchorBottomRight", "Anchor Bottom Right", "Anchor the window to grow from the bottom right." },
	{ "Total", "Effects", "This is the total damage or healing this effect accumulated since last reset." },
	{ "Max", "Max Hit", "This is the maximum damage or healing this effect dealt in one attack since last reset." },
	{ "Avg", "Average Hit", "This is the average damage or healing this effect dealt in one attack since last reset." },
	{ "CritP", "Crit Rate", "This is the average crit rate of this effect since last reset." },
	{ "MissPOverP", "Miss Rate/Overhealing Rate", "For damage effects, this is the miss rate of the effect.  For heals, this is the overheal rate of the effect." },
	{ "Contribution", "Contribution", "This is the relative amount each effect contributed to the combatant's damage or healing." },
	{ "OtherHits", "Hits", "The number of times this effect occurred." },
	{ "OtherTotal", "Total", "The total amount gained or lost for this effect.  For some effects this simply echoes the number of hits." },
	{ "Attribute", "Attribute", "The attribute gained or lost for this effect." },
	{ "HeaderDPSvsAll", "DPS vs All", "This is the Damage Per Second each combatant dealt over the total duration of everyone fighting." },
	{ "HeaderOver", "Overhealing", "This is an estimated overhealing percentage per combatant in the group for All Fights.\n\nRemember: Mana-efficient healers use the slow beefy heals.  Other healers snipering small fast heals while the better heals are incoming are going to unfairly make the mana-efficient healer look worse than the mana-inefficient snipers.\n\nDo not use this as a gauge of healer capability or contribution." },
	{ "ReportFightsToClipboard", "Report Fights to Clipboard", "This will report on the current combatants to a window from which you can copy to other programs like Notepad, TextEdit, or web forums." },
	{ "ReportDetailsToClipboard", "Report Details to Clipboard", "This will report on the player's personal details to a window from which you can copy to other programs like Notepad, TextEdit, or web forums." },
	{ "ShowSelfView", "Show Personal Details", "This will display your damage and healing details in the main window." },
	{ "HideSelfView", "Hide Personal Details", "This will dismiss your personal damage and healing details and return to all combatants in the main window." },
	{ "ResetSelfView", "Reset Personal Details", "This will wipe all personal damage and healing details accumulated in this window.  Your information in the detail panel will not be affected." },
	{ "ResetEffect", "Reset Effect", "This will reset this effect only from personal details." },
	{ "HeaderEName", "Spell or Ability", "These are the effects you've used since you last reset.  Damaging effects are green, heals are blue." },
	{ "HeaderEElement", "Effect Element", "This is the element (Arcane, Fire, Holy, etc.) of this effect." },
	{ "HeaderETotal", "Effect Totals", "This is the total amount of each effects' damage or heals (theoretical) since you last reset." },
	{ "HeaderETotalP", "Effect Contributions", "This is the contribution of each effect to the total damage or heals (theoretical) since you last reset." },
	{ "HeaderEMaxAll", "Max Damage or Heal", "This is the maximum damage or healing (theoretical) done by each effect in one hit, tick or crit." },
	{ "HeaderEGlances", "Number of Glances", "This is the number of times each effect hit as a glancing blow." },
	{ "HeaderEGlancesAvg", "Average Glance", "This is the average damage per glancing blow." },
	{ "HeaderEGlancesMax", "Max Glance", "This is the maximum damage in a single glancing blow." },
	{ "HeaderEHits", "Number of Hits", "This is the number of times each effect hit without a crit." },
	{ "HeaderEHitsAvg", "Average Hit", "This is the average damage or healing (theoretical) per non-crit hit of each effect." },
	{ "HeaderEHitsMax", "Max Hit", "This is the maximum damage or healing (theoretical) in a single non-crit hit of each effect." },
	{ "HeaderETicks", "Number of Ticks", "This is the number of times each effect ticked for damage or healing (theoretical)." },
	{ "HeaderETicksAvg", "Average Tick", "This is the average damage or healing (theoretical) per tick of each effect." },
	{ "HeaderETicksMax", "Max Tick", "This is the maximum damage or healing (theoretical) from a single tick of each effect." },
	{ "HeaderECrits", "Number of Crits", "This is the number of times each effect crit." },
	{ "HeaderECritsAvg", "Average Crit", "This is the average damage or healing (theoretical) per crit of each effect." },
	{ "HeaderECritsMax", "Max Crit", "This is the maximum damage or healing (theoretical) from a single crit of each effect." },
	{ "HeaderECritsP", "Crit Rate", "This is the crit rate of each effect, a percentage of hits attempted.  Ticks cannot crit and are not included." },
	{ "HeaderEMiss", "Misses", "This is the number of times each effect missed.  This includes miss, resist and deflect for non-melee, and also dodge, parry and block for melee." },
	{ "HeaderEMissP", "Miss Rate", "This is the percentage of attempted hits that missed for each effect." },
	{ "HeaderEGlancesMin", "Min Glance", "This is the minimum damage in a single glancing blow." },
	{ "HeaderEHitsMin", "Min Hit", "This is the minimum damage or healing (theoretical) in a single non-crit hit of each effect." },
	{ "HeaderETicksMin", "Min Tick", "This is the minimum damage or healing (theoretical) from a single tick of each effect." },
	{ "HeaderECritsMin", "Min Crit", "This is the minimum damage or healing (theoretical) from a single crit of each effect." },
	{ "StartSync", "Start Synchronization", "This button will broadcast an invitation to synchronize to the group, with you as synchronization leader.  You will leave your current synchronization, and Recap will Reset All Fights.  You will receive notification of players accepting or declining your invitation.\n\nAnyone in a group may start a synchronization." },
	{ "ManualSync", "Manual Synchronization", "This button will synchronize immediately.  Normally Recap synchronizes automatically at the end of each fight, but sometimes you may wish to synchronize manually.\n\nDoes nothing if Recap is in combat." },
	{ "BecomeLeader", "Become Leader", "This button will make you leader of the synchronization, to replace a missing leader, and will do a manual synchronization to broadcast the fact.\n\nDoes nothing if Recap is in combat." },
	{ "ListMembers", "List Members", "This button will display a list of the members of the synchronization on your console.  Those who are active will be listed first, followed by those who are inactive (that is, not heard from within the past ten seconds)." },
	{ "ClearInactiveMembers", "Clear Inactive Members", "Remove from the list those who have not been heard from within the past ten seconds.  Removing them from your list does not exclude them from the synchronization.  If they become active again they will reappear on the list.  Removing them from your list does not remove them from any other player's list." },
	{ "SkipNextFight", "Skip Next Fight", "This button will skip the next fight.  Recap will automatically resume tracking following the end of the next fight.\n\nEnabled for the leader of the synchronization.\n\nIf pressed during combat, only the remainder of the current fight will be skipped.\n\nThis button could be used, for example, to skip the chess event in Karazhan.\n\nThe button is also enabled for people who are not in a synchronization." },
	{ "TargetTotal", "Target of Outgoing", "This is the damage or healing done to this target since last reset." },
	{ "SourceTotal", "Source of Incoming", "This is the damage or healing received from this source since last reset." },
	{ "ContributionWhom", "Contribution", "This is the relative amount contributed to the target's or source's damage or healing." },
	{ "RecentIncomingEvents", "Recent Incoming Events", "These are recent events that happened to this combatant, perhaps filtered by effect.\n\nShift+click to post to an open chat edit box." },
	{ "RecentOutgoingEvents", "Recent Outgoing Events", "These are recent events generated by this combatant, perhaps filtered by effect.\n\nShift+click to post to an open chat edit box." },
	{ "ShowRecent", "Show Recent Events", "Show a panel with recent incoming and outgoing events for a combatant, or for a spell or ability for a combatant.\n\nIf you hold down the control key while clicking for a combatant then Recap will show recent dispels only.\n\nThis feature can be enabled or disabled using the Recent Data Mode check box on the Options / Settings tab." },
	{ "ShowGroupTotal", "Show Group Total", "Show a panel with total combined details for combatants in the group." },
	{ "ShowNonGroupTotal", "Show Non-Group Total", "Show a panel with total combined details for combatants not in the group." }
};


--[[ localized strings for the xml labels ]]

-- Bindings.xml (names generated in Bindings.xml)
BINDING_HEADER_RECAP = "Recap"
BINDING_NAME_RECAP_TOGGLE_RECAP = "Toggle Recap"
BINDING_NAME_RECAP_TOGGLE_FIGHTS = "Toggle Last/All Fights"
BINDING_NAME_RECAP_OPTIONS = "Recap Options"
BINDING_NAME_RECAP_RESET_ALL = "Reset All Fights"
BINDING_NAME_RECAP_RESET_LAST = "Reset Last Fight"
BINDING_NAME_RECAP_RESET_DETAILS = "Reset Personal Details"
BINDING_NAME_RECAP_RESET_FIGHTS_DETAILS = "Reset Fights and Details"
BINDING_NAME_RECAP_SAVE_ALL_FIGHTS = "Save All Fights"
BINDING_NAME_RECAP_SAVE_LAST_FIGHT = "Save Last Fight"
BINDING_NAME_RECAP_SKIP_NEXT_FIGHT = "Skip Next Fight"

-- Bindings.xml
RECAP_ALL_FIGHTS_RESET = "All Fights reset"
RECAP_LAST_FIGHT_RESET = "Last Fight reset"
RECAP_DETAILS_RESET = "Personal Details reset"
RECAP_FIGHTS_DETAILS_RESET = "Fights and Details reset"
RECAP_SYNCHRONIZATION_RESET = "Sychronization reset"
RECAP_ALL_FIGHTS_SAVED = "All Fights saved"
RECAP_LAST_FIGHT_SAVED = "Last Fight saved"

-- Recap.xml
RECAP_RECAP = "Recap"
RECAP_RESET = "Reset"
RECAP_COMBATANTS = "Combatants"
RECAP_SEEN = "Seen"
RECAP_DIED = "Died"
RECAP_TIME = "Time"
RECAP_TIME_IN = "Time In"
RECAP_TIME_HEAL = "Time Heal"
RECAP_HEAL = "Heal"
RECAP_IN = "In"
RECAP_OUT = "Out"
RECAP_MAX = "Max"
RECAP_HPS = "HPS"
RECAP_DPS_IN = "DPS In"
RECAP_DPS = "DPS"
RECAP_DPS_ALL = "DPS+"
RECAP_MISS = "Miss"
RECAP_RECENT = "Recent"
RECAP_TOTAL_DETAILS = "Total"

-- RecapOptions.xml : Display
RECAP_SET_NAME = "Set Name"
RECAP_SAVED = "Saved"
RECAP_RECAP_OPTIONS = "Recap Options"
RECAP_DISPLAY = "Display"
RECAP_SETTINGS = "Settings"
RECAP_DATA_SETS = "Data Sets"
RECAP_REPORTS = "Reports"
RECAP_OK = "Ok"
RECAP_EXIT = "Exit"
RECAP_DISPLAY_IN_LIST = "Display In List"
RECAP_NUMBERED_LIST = "Numbered List"
RECAP_FACTION_LEVEL = "Faction/Level"
RECAP_CLASS = "Class"
RECAP_FIRST_SEEN = "First Seen"
RECAP_DEATHS = "Deaths"
RECAP_HEALS = "Heals"
RECAP_HEALS_P = "Heals %"
RECAP_DAMAGE_IN = "Damage In"
RECAP_DAMAGE_IN_P = "Damage In %"
RECAP_DAMAGE_OUT = "Damage Out"
RECAP_DAMAGE_OUT_P = "Damage Out %"
RECAP_MAX_HIT = "Max Hit"
RECAP_DPS_VS_ALL = "DPS vs All"
RECAP_OVERHEALING = "Overhealing"
RECAP_DISPLAY_MINIMIZED = "Display Minimized"
RECAP_STATUS_LIGHT = "Status Light"
RECAP_SYNC_LIGHT = "Sync Light"
RECAP_LAST_ALL = "Last/All"
RECAP_YOUR_DPS = "Your DPS Out"
RECAP_MIN_DPS_IN = "Total DPS In"
RECAP_MIN_DPS_OUT = "Total DPS Out"
RECAP_YOUR_HPS = "Your HPS"
RECAP_MIN_HPS = "Total HPS"
RECAP_BUTTONS = "Buttons"
RECAP_BACKGROUND = "Background"
RECAP_MAXIMUM_ROWS = "Maximum Rows"
RECAP_SHOW_GAUGES = "Show Gauges"
RECAP_ANCHOR = "Anchor"
RECAP_DISPLAY_PERSONAL_DETAILS = "Personal Details"
RECAP_SELF_EELEMENT = "Element"
RECAP_SELF_ETOTAL = "Total"
RECAP_SELF_ETOTALP = "Total %"
RECAP_SELF_EGLANCES = "Glances"
RECAP_SELF_EGLANCESMIN = "Min Glance"
RECAP_SELF_EGLANCESAVG = "Avg Glance"
RECAP_SELF_EGLANCESMAX = "Max Glance"
RECAP_SELF_EHITS = "Hits"
RECAP_SELF_EHITSMIN = "Min Hit"
RECAP_SELF_EHITSAVG = "Avg Hit"
RECAP_SELF_EHITSMAX = "Max Hit"
RECAP_SELF_ETICKS = "Ticks"
RECAP_SELF_ETICKSMIN = "Min Tick"
RECAP_SELF_ETICKSAVG = "Avg Tick"
RECAP_SELF_ETICKSMAX = "Max Tick"
RECAP_SELF_ECRITS = "Crits"
RECAP_SELF_ECRITSMIN = "Min Crit"
RECAP_SELF_ECRITSAVG = "Avg Crit"
RECAP_SELF_ECRITSMAX = "Max Crit"
RECAP_SELF_ECRITSP = "Crit %"
RECAP_SELF_EMISS = "Misses"
RECAP_SELF_EMISSP = "Miss %"
RECAP_SELF_EMAXALL = "Max Damage"
-- RecapOptions.xml : Settings
RECAP_WINDOW_OPTIONS = "Window Options"
RECAP_USE_COLOR = "Use Color"
RECAP_SHOW_TOOLTIPS = "Show Tooltips"
RECAP_TOOLTIPS_AT_POINTER = "Tooltips at Pointer"
RECAP_SHOW_DETAILS = "Show Details"
RECAP_OPAQUE_BACKGROUND = "Opaque Background"
RECAP_MINIMIZE_ON_ESCAPE = "Minimize on Escape"
RECAP_AUTO_HIDE_IN_COMBAT = "Auto Hide in Combat"
RECAP_AUTO_MINIMIZE = "Auto Minimize"
RECAP_AUTO_FADE_WINDOW = "Auto Fade Window"
RECAP_SCALING = "Scaling"
RECAP_FIGHT_OPTIONS = "Fight Options"
RECAP_LIMIT_FIGHTS_TO_COMBAT = "Limit Fights to Combat"
RECAP_ONLY_FIGHTS_WITH_DURATION = "Only Fights with Duration"
RECAP_ONLY_UNIQUE_COMBATANTS = "Only Unique Combatants"
RECAP_HIDE_GROUP = "Hide Group"
RECAP_HIDE_OTHERS = "Hide Other Combatants"
RECAP_STORE_ONLY_DISPLAYED_COMBATANTS = "Store Only Displayed Combatants"
RECAP_MERGE_PETS_WITH_OWNERS = "Merge Pets with Owners"
RECAP_IGNORE_GLOBAL_UNIQUE_IDENTIFIERS = "Ignore Global Unique Identifiers"
RECAP_END_FIGHT_IF_IDLE = "End Fight if Idle"
RECAP_END_FIGHT_DELAY = "End Fight Delay"
RECAP_DATA_OPTIONS = "Data Options"
RECAP_LIGHT_DATA_MODE = "Light Data Mode"
RECAP_OTHER_DATA_MODE = "Other Data Mode"
RECAP_MATRIX_DATA_MODE = "Matrix Data Mode"
RECAP_RECENT_DATA_MODE = "Recent Data Mode"
RECAP_USE_GLOBAL_SETTINGS = "Use Global Settings"
RECAP_WARN_DATA = "Warn on Data Growing Too Large"
RECAP_OTHER_OPTIONS = "Other Options"
RECAP_REMIND_GROUP_STATUS = "Remind on Joining or Leaving Group"
RECAP_REMIND_INSTANCE_STATUS = "Remind on Entering or Leaving Instance"
RECAP_COLLECT_GARBAGE = "Collect Garbage at End of Fight"
-- RecapOptions.xml : Data Sets
RECAP_FIGHT_DATA_SETS = "Fight Data Sets"
RECAP_SAVE_GROUP_COMBATANTS_ONLY = "Save Group Combatants Only"
RECAP_REPLACE_ANY_EXISTING_DATA = "Replace Any Existing Data"
RECAP_SAVE_ALL = "Save All"
RECAP_SAVE_LAST = "Save Last"
RECAP_LOAD = "Load"
RECAP_DELETE = "Delete"
-- RecapOptions.xml : Reports
RECAP_FIGHT_REPORTING = "Fight Reporting"
RECAP_REPORT_RANKS_IN_MULTIPLE_ROWS = "Report in Multiple Rows (Shift+Click and Autopost)"
RECAP_AUTOMATICALLY_POST_RANKS_AFTER_EACH_FIGHT = "Automatically Post Ranks After Each Fight"
RECAP_AUTOMATICALLY_POST_CHANGES_IN_LEADERSHIP = "Automatically Post Changes in Leadership"
RECAP_AUTOMATICALLY_POST = "Automatically Post:"
RECAP_AUTOMATICALLY_POST_TO = "To Channel:"
RECAP_WOWCHATLOG_TXT = "Report to WOWChatLog.txt"
RECAP_OPEN_WOWCHATLOG_TXT = "Open"
RECAP_ACQUIRING_CHANNEL = "Acquiring channel..."
RECAP_CHANNEL_JOINED = "Channel joined"
RECAP_REPORT_TO_WOWCHATLOG_TXT = "Report"
RECAP_CLOSE_WOWCHATLOG_TXT = "Close"
-- RecapOptions.xml : Clipboard
RECAP_CLIP_EXPLANATION = "Press CTRL+C to copy the selected text to the clipboard.\nThen go to another text window and CTRL+V to paste it there.  Press ESC or click Ok when done."
RECAP_CLIPBOARD = "Report to Clipboard"
RECAP_REPORT_FIGHTS_TO_CLIPBOARD = "Report Fights"
RECAP_REPORT_DETAILS_TO_CLIPBOARD = "Report Details"
RECAP_WRITE_ONLY_GROUP = "Report Only Combatants in Group"
RECAP_FORMAT_IN_HTML = "Report Format in HTML"
-- RecapOptions.xml : Synchronization
RECAP_SYNC = "Sync"
RECAP_SYNCHRONIZATION = "Synchronization"
RECAP_ENABLE_SYNC = "Enable Synchronization"
RECAP_SYNC_STATE_IGNORE = "Ignoring synchronization"
RECAP_SYNC_STATE_READY = "Waiting for synchronization"
RECAP_SYNC_STATE_MEMBER = "Member of a synchronization"
RECAP_SYNC_STATE_LEADER = "Leader of a synchronization"
RECAP_START_SYNC = "Start Synchronization"
RECAP_MERGE_PETS_OFF = "<== with Merge Pets off"
RECAP_MERGE_PETS_ON = "<== with Merge Pets on"
RECAP_MANUAL_SYNC = "Manual Synchronization"
RECAP_BECOME_LEADER = "Become Leader"
RECAP_LIST_MEMBERS = "List Members"
RECAP_CLEAR_INACTIVE_MEMBERS = "Clear Inactive Members"
RECAP_SKIP_NEXT_FIGHT = "Skip Next Fight"

-- RecapPanel.xml
RECAP_DAMAGE = "Damage"
RECAP_GLANCES = "Glances"
RECAP_HITS = "Hits"
RECAP_CRITS = "Crits"
RECAP_CRUSHES = "Crushes"
RECAP_AVERAGE = "Average"
RECAP_MELEE = "Melee"
RECAP_MISSED_DETAILS = "Missed Details"
RECAP_MISSED = "Missed"
RECAP_DODGED = "Dodged"
RECAP_PARRIED = "Parried"
RECAP_BLOCKED = "Blocked"
RECAP_ABSORBED = "Absorbed"
RECAP_DEFLECTED = "Deflected"
RECAP_EVADED = "Evaded"
RECAP_RESISTED = "Resisted"
RECAP_REFLECTED = "Reflected"
RECAP_IMMUNE = "Immune"
RECAP_SPELL_OR_ABILITY = "Spell or Ability"
RECAP_INCOMING_SPELL_OR_ABILITY = "Incoming Spell or Ability"
RECAP_OUTGOING_SPELL_OR_ABILITY = "Outgoing Spell or Ability"
RECAP_MISSES = "Misses"
RECAP_MIN = "Min"
RECAP_AVG = "Avg"
RECAP_SUMMARY = "Summary"
RECAP_LAST_FIGHT = "Last Fight"
RECAP_ALL_FIGHTS = "All Fights"
RECAP_TICKS = "Ticks"
RECAP_INCOMING = "Incoming"
RECAP_OUTGOING = "Outgoing"
RECAP_OTHER_EFFECTS = "Other Effects"
RECAP_TOTAL = "Total"
RECAP_ATTRIBUTE = "Attribute"
RECAP_ENVIRONMENT = "Environment"
RECAP_DISPELS = "Dispels"
RECAP_STEALS = "Steals"
RECAP_TIMINGS = "Timings"
RECAP_INTERVALS = "Intervals"
RECAP_SECONDS = "seconds"
RECAP_DURATIONS = "Durations"
RECAP_INTERRUPT = "Interrupt"
RECAP_ESTIMATED_INTERVAL = "estimated interval"
RECAP_ESTIMATED_DURATION = "estimated duration"
RECAP_PARTIALS = "Partials"
RECAP_ABSORBS = "Absorbs"
RECAP_BLOCKS = "Blocks"
RECAP_RESISTS_25 = "Resists 25%"
RECAP_RESISTS_50 = "Resists 50%"
RECAP_RESISTS_75 = "Resists 75%"
RECAP_ESTIMATED_TOTAL_RESISTED = "Estimated Total Resisted"
RECAP_TARGET_OF_OUTGOING = "Target of Outgoing"
RECAP_SOURCE_OF_INCOMING = "Source of Incoming"

-- RecapRecent.xml
RECAP_RECENT_INCOMING_EVENTS = "Recent Incoming Events"
RECAP_RECENT_OUTGOING_EVENTS = "Recent Outgoing Events"
RECAP_RECENT_INCOMING_EFFECTS = "Recent Incoming Effects"
RECAP_RECENT_OUTGOING_EFFECTS = "Recent Outgoing Effects"
RECAP_RECENT_INCOMING_DISPELS = "Recent Incoming Dispels"
RECAP_RECENT_OUTGOING_DISPELS = "Recent Outgoing Dispels"

-- more miscellaneous display strings
RECAP_TIME_FIGHTING = "Time Dealing Damage"
RECAP_TIME_DAMAGED = "Time Taking Damage"
RECAP_TIME_HEALING = "Time Healing"
RECAP_KILLS = "Kills"
RECAP_HPS_OUT = "HPS Out"
RECAP_DPS_OUT = "DPS Out"
RECAP_TOTAL_DPS_OUT = "Total DPS Out"
RECAP_TOTAL_DPS_IN = "Total DPS In"
RECAP_CRIT_RATE = "Crit Rate"
RECAP_TEN_ROWS = "10 rows"
RECAP_FIVE_SECONDS = "5 seconds"
RECAP_TEN_SECONDS = "10 seconds"
RECAP_FIVE_HUNDRED_EVENTS = "500 events"
RECAP_GROUP_FIGHT_TIME = "Group Fight Time"
RECAP_GROUP_DPS = "Group DPS"
RECAP_ONE = "1.0"


--[[ miscellaneous localized strings ]]

recap_temp.LastAll = { Last="Last Fight", All="All Fights" }
recap_temp.LastAllShort = { Last="Last", All="All" }
recap_temp.StoppedActiveIdle = { Stopped="Stopped", Active="Active", Idle="Idle" }
recap_temp.Localize = {}
recap_temp.Localize.RankTop = "Rank Top"
recap_temp.Localize.None = "none"
recap_temp.Localize.Totals = "Totals"
recap_temp.Localize.Details = "Details"
recap_temp.Localize.Status = "Status"
recap_temp.Localize.NewLeader = "New leader"
recap_temp.Localize.With = "with"
recap_temp.Localize.Of = "of"
recap_temp.Localize.For = "for"
recap_temp.Localize.Seconds = "seconds"
recap_temp.Localize.Events = "events"
recap_temp.Localize.Rows = "rows"
recap_temp.Localize.Subtotal = "Subtotal"
recap_temp.Localize.Group = "Group"
recap_temp.Localize.NonGroup = "Non-Group"
recap_temp.Localize.ElementOther = "Other" --  Damage element not specified
recap_temp.Localize.ElementHealing = "Healing" --  Healing element not specified
recap_temp.Localize.OwnedBy = "owned by"
recap_temp.Localize.VerboseLinkStart = "Recap %s: %s took %s damage over %s for %s DPS In (%s deaths); dealt %s damage over %s for %s DPS Out (max hit %d); did %s actual healing over %s for %s actual HPS Out"
recap_temp.Localize.VerboseGroupTotalStart = "Recap %s: Combatants in group took %s damage over %s for %s DPS In (%s deaths); dealt %s damage over %s for %s DPS Out (max hit %d); did %s actual healing over %s for %s actual HPS Out"
recap_temp.Localize.VerboseNonGroupTotalStart = "Recap %s: Combatants not in group took %s damage over %s for %s DPS In (%s deaths); dealt %s damage over %s for %s DPS Out (max hit %d); did %s healing over %s for %s HPS Out"
recap_temp.Localize.LinkRank = { Time="Time Fighting", TimeIn="Time Taking Damage", TimeHeal="Time Healing", MaxHit="Max Hit", DmgIn="Damage Tanked", DmgOut="Damage Dealt", DPS="DPS Out", DPSIn="DPS In", Heal="Healing", HPS="Healing Per Second", Kills="Deaths", HealP="Healing", DmgInP="Damage Tanked", DmgOutP="Damage Dealt", DPSvsAll="DPS vs All", Over="Estimated Overhealing", Seen="First Seen" }
recap_temp.Localize.StatusTooltip = "When this light is red, fight monitoring is suspended.\n\nWhen this light is green, a fight is currently being monitored.\n\nWhen this light is off, Recap is idle and waiting for a fight to begin.\n"
recap_temp.Localize.RankUsage = "To post a recap to chat, begin a chat and then shift+click. ie:\n|cFFAAAAFF/p (shift+click on Time)|cFFFFFFFF <- sends a ranking of times to /p\n|cFFFF8000/ra (shift+click on DPS)|cFFFFFFFF <- sends a ranking of DPS Out to /ra"
recap_temp.Localize.SkipChannels = { "General", "Trade", "WorldDefense", "LocalDefense", "LookingForGroup" }
recap_temp.Localize.OutgoingHealDetailLink = "Recap %s: %s: %s (%s) healed %s hp (%s of %s heals)"
recap_temp.Localize.OutgoingHealDetailLinkNoElement = "Recap %s: %s: %s healed %s hp (%s of %s damage)"
recap_temp.Localize.OutgoingDamageDetailLink = "Recap %s: %s: %s (%s) damaged %s hp (%s of %s damage)"
recap_temp.Localize.OutgoingDamageDetailLinkNoElement = "Recap %s: %s: %s damaged %s hp (%s of %s damage)"
recap_temp.Localize.TargetHealDetailLink = "Recap %s: %s healed %s %s hp (%s of %s heals)"
recap_temp.Localize.TargetDamageDetailLink = "Recap %s: %s damaged %s %s hp (%s of %s damage)"
recap_temp.Localize.IncomingHealDetailLink = "Recap %s: %s (%s) healed %s %s hp (%s of %s heals)"
recap_temp.Localize.IncomingHealDetailLinkNoElement = "Recap %s: %s healed %s %s hp (%s of %s damage)"
recap_temp.Localize.IncomingDamageDetailLink = "Recap %s: %s (%s) damaged %s %s hp (%s of %s damage)"
recap_temp.Localize.IncomingDamageDetailLinkNoElement = "Recap %s: %s damaged %s %s hp (%s of %s damage)"
recap_temp.Localize.SourceHealDetailLink = "Recap %s: %s healed %s %s hp (%s of %s heals)"
recap_temp.Localize.SourceDamageDetailLink = "Recap %s: %s damaged %s %s hp (%s of %s damage)"
recap_temp.Localize.OtherDetailLink = "Recap %s: %s: %s: %s occurred %s times %s"
recap_temp.Localize.OtherDetailType = { "Cast", "Cast", "Debuff/Loss", "Debuff/Loss", "Buff/Gain", "Buff/Gain", "Debuff/Buff/Other", "Debuff/Buff/Other" }
recap_temp.Localize.ConfirmLightData = "You've chosen to enable Light Data Mode.\n\nIf you accept, the UI will be reloaded to purge extraneous detail."
recap_temp.Localize.ConfirmHeavyData = "You've chosen to disable Light Data Mode.\n\nIf you accept, the UI will be reloaded to initialize detail logging."
recap_temp.Localize.ConfirmLastReset = "You've chosen to reset the Last Fight.\n\nIf you accept, the information for the Last Fight will be SUBTRACTED from the All Fights data.  Be certain this is what you want.\n\nThis reset is not simply a clear command."
recap_temp.Localize.LogHeader = "__ Recap [%.2f] (%s): generated by %s for %s on %s in %s __"
recap_temp.Localize.LogFormat = "%35s ! %2s %3s !%9s %9s %9s !%8s %4s !%8s %4s %6s !%8s %4s !%5s !%6s"
recap_temp.Localize.Log = { "Name", "Lv", "Cls", "Time", "Time In", "Time Heal", "Healing", "%%", "Tanking", "%%", "DPS In", "Damage", "%%", "Max", "DPS" }
recap_temp.Localize.HTMLHeader = "<tr><td colspan=\"15\">Recap [%.2f] (%s): generated by %s for %s on %s in %s</td></tr>"
recap_temp.Localize.HTMLFormat1 = "<tr align=\"right\"><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td>"
recap_temp.Localize.HTMLFormat2 = "<td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>"
recap_temp.Localize.HTMLPrefix = "<table CELLPADDING=\"2\">"
recap_temp.Localize.HTMLSuffix = "</table>"
recap_temp.Localize.DetailHeader = "__ Recap %s generated with details for %s on %s in %s __"
recap_temp.Localize.DetailFormat = "%30s %18s !%8s %5s !%8s !%7s %6s %6s %6s !%5s %6s %6s %6s !%5s %6s %6s %6s !%5s %6s %6s %6s %7s !%4s %7s"
recap_temp.Localize.Detail = { "Effect", "Element", "Total", "Pct", "Max", "Glances", "Min", "Avg", "Max", "Hits", "Min", "Avg", "Max", "Ticks", "Min", "Avg", "Max", "Crits", "Min", "Avg", "Max", "Pct", "Miss", "Pct" }
recap_temp.Localize.HTMLDetailHeader = "<tr><td colspan=\"24\">Recap %s generated by %s on %s in %s</td></tr>"
recap_temp.Localize.HTMLDetailFormat1 = "<tr align=\"right\"><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td>"
recap_temp.Localize.HTMLDetailFormat2 = "<td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td>"
recap_temp.Localize.HTMLDetailFormat3 = "<td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>"
recap_temp.Localize.NoFreeChannels = "There are no channels free to create a log.  Leave a channel and try again."
recap_temp.Localize.NoChannelNumber = "Unable to acquire a channel number."
recap_temp.Localize.LogWritten = "Recap written to WOWChatLog.txt"
recap_temp.Localize.ConfirmGlobalSettings = "You've chosen to enable global settings.\n\nIf you accept, the UI will be reloaded and information specific to other characters will be lost."
recap_temp.Localize.ConfirmSeparateSettings = "You've chosen to disable global settings.\n\nIf you accept, the UI will be reloaded and other characters will store data separately."
recap_temp.Localize.LotsOfDataWarning = "Recap has %d combatants in the \"live\" data.  This is a lot.\n\nThis message doesn't mean you are out of memory.  It's just for your information.  You can turn this warning off in Options / Settings / Data Options in Recap.\n\nTo summon Recap if you don't see it: /recap then click the Options button along the top.\n\nIf you don't want Recap to always be on and accumulate data, Pause it when not in use.\n\nFrequent use of the Reset button, Fight Data Sets and Pause will keep memory use to a minimum.\n\nIf you are in a synchronization the 'Reset All Fights' button will be disabled."
recap_temp.Localize.VersionCheck = "Recap program files may be damaged.  Try removing the Recap folder, then re-installing from a freshly downloaded copy of Recap."
recap_temp.Localize.ConfirmIgnoreGUIDs = "You've chosen to ignore global unique identifiers.\n\nIf you accept, Recap will be reset and synchronization will not be allowed."
recap_temp.Localize.ConfirmUseGUIDs = "You've chosen to use global unique identifiers.\n\nIf you accept, Recap will be reset."
recap_temp.Localize.NotAllowedDuringCombat = "Recap: Not allowed during combat"
recap_temp.Localize.InvitesYouToSynchronize = "invites you to synchronize"
recap_temp.Localize.NewSynchronization = "new synchronization"
recap_temp.Localize.OngoingSynchronization = "ongoing synchronization"
recap_temp.Localize.AcceptedSync = "accepted your invitation to synchronize"
recap_temp.Localize.DeclinedSync = "declined your invitation to synchronize"
recap_temp.Localize.MergePetsOff = "Merge Pets off"
recap_temp.Localize.MergePetsOn = "Merge Pets on"
recap_temp.Localize.Timestamp = "Timestamp"
recap_temp.Localize.Leader = "Leader"
recap_temp.Localize.LastUpdateWas = "Last update was"
recap_temp.Localize.Ago = "(hh:mm:ss) ago"
recap_temp.Localize.FailSendInvite = "Failed to send synchronization invitation"
recap_temp.Localize.FailSendAccept = "Failed to send synchronization accept"
recap_temp.Localize.FailSendDecline = "Failed to send synchronization decline"
recap_temp.Localize.FailSendSummary = "Failed to send synchronization summary data"
recap_temp.Localize.FailSendReply = "Failed to send synchronization reply data"
recap_temp.Localize.FailSendHeartbeat = "Failed to send synchronization heartbeat"
recap_temp.Localize.FailSendSkipNextFight = "Failed to send skip next fight"
recap_temp.Localize.SkipNextFightBegins = "Skip Next Fight begins"
recap_temp.Localize.SkipNextFightEnds = "Skip Next Fight ends"
recap_temp.Localize.NotAllowedDuringSync = "Recap: Not allowed during synchronization"
recap_temp.Localize.RemindJoinGroup = "Recap: You have just joined a group.  This is your reminder to do whatever it is that you wanted to be reminded to do."
recap_temp.Localize.RemindLeaveGroup = "Recap: You have just left a group.  This is your reminder to do whatever it is that you wanted to be reminded to do."
recap_temp.Localize.RemindEnterInstance = "Recap: You have just entered an instance.  This is your reminder to do whatever it is that you wanted to be reminded to do."
recap_temp.Localize.RemindLeaveInstance = "Recap: You have just left an instance.  This is your reminder to do whatever it is that you wanted to be reminded to do."
recap_temp.Localize.OutOfDateSyncVersion = "You are unable to join a synchronization because you have an older and incompatible version of Recap."
recap_temp.Localize.SyncMembers = "Synchronization members"
recap_temp.Localize.InactiveSyncMembers = "Inactive synchronization members"
recap_temp.Localize.InSync = "in sync"
recap_temp.Localize.Unknown = "Unknown"
recap_temp.Localize.Removed = "removed"
recap_temp.Localize.OtherDataModeNotEnabled = "Other Data Mode is not enabled"
recap_temp.Localize.MatrixDataModeNotEnabled = "Matrix Data Mode is not enabled"
recap_temp.Localize.NotAvailable = "Not available"
recap_temp.Localize.Attacks = "Attacks"
recap_temp.Localize.Dispels = "Dispels"
recap_temp.Localize.Interrupts = "Interrupts"
recap_temp.Localize.Durability = "Durability"
recap_temp.Localize.Interrupted = "Interrupted"
recap_temp.Localize.Died = "died"
recap_temp.Localize.Killed = "killed"
recap_temp.Localize.TimeWindow = "Time Window"
recap_temp.Localize.AllCombatants = "All Combatants"


-- menus
recap_temp.Localize.ColumnMenu = { {Text="Numbered List",Info="Ranks"}, {Text="Faction/Level",Info="Faction"}, {Text="Class",Info="Class"},
								{Text="First Seen",Info="Seen"}, {Text="Deaths",Info="Kills"}, {Text="Time",Info="Time"}, {Text="Time In",Info="TimeIn"},
								{Text="Time Heal",Info="TimeHeal"}, {Text="Heal",Info="Heal"}, { Text="Heal %",Info="HealP"},
								{Text="Overheal",Info="Over"}, {Text="Damage In",Info="DmgIn"}, {Text="Damage In %",Info="DmgInP"},
								{Text="Damage Out",Info="DmgOut"}, {Text="Damage Out %",Info="DmgOutP"}, {Text="Max Hit",Info="MaxHit"},
								{Text="HPS",Info="HPS"}, {Text="DPS In",Info="DPSIn"},
								{Text="DPS Out",Info="DPS"}, {Text="DPS vs All",Info="DPSvsAll"} }
recap_temp.Localize.MinMenu = { {Text="Lock Window", Info="Pin"}, {Text="Status Light",Info="MinStatus"}, {Text="Sync Light",Info="MinSyncStatus"}, {Text="Last/All",Info="MinView"},
								{Text="Your DPS",Info="MinYourDPS"}, {Text="Total DPS In",Info="MinDPSIn"}, {Text="Total DPS Out",Info="MinDPSOut"},
								{Text="Your HPS",Info="MinYourHPS"}, {Text="Total HPS",Info="MinHPS"},
								{Text="Buttons",Info="MinButtons"}, {Text="Background",Info="MinBack"} }
recap_temp.Localize.AddMenu = { {Text="Add to Group",Info="MenuAdd"}, {Text="Reset",Info="MenuReset"}, {Text="Ignore",Info="MenuIgnore"} }
recap_temp.Localize.AddLockMenu = { {Text="Add to Group",Info="MenuAdd"}, {Text="Reset",Info="MenuReset"}, {Text="Ignore",Info="MenuIgnore"}, {Text="Lock",Info="MenuLock"} }
recap_temp.Localize.AddUnlockMenu = { {Text="Add to Group",Info="MenuAdd"}, {Text="Reset",Info="MenuReset"}, {Text="Ignore",Info="MenuIgnore"}, {Text="Unlock",Info="MenuUnlock"} }
recap_temp.Localize.DropMenu = { {Text="Drop from Group",Info="MenuDrop"}, {Text="Reset",Info="MenuReset"}, {Text="Ignore",Info="MenuIgnore"} }
recap_temp.Localize.DropLockMenu = { {Text="Drop from Group",Info="MenuDrop"}, {Text="Reset",Info="MenuReset"}, {Text="Ignore",Info="MenuIgnore"}, {Text="Lock",Info="MenuLock"} }
recap_temp.Localize.DropUnlockMenu = { {Text="Drop from Group",Info="MenuDrop"}, {Text="Reset",Info="MenuReset"}, {Text="Ignore",Info="MenuIgnore"}, {Text="Unlock",Info="MenuUnlock"} }
recap_temp.Localize.DetailTitle = { ["Total"] = "Total", ["Avg"] = "Avg", ["Max"] = "Max", ["CritP"] = "Crit %", ["MissPOverP"] = "Miss / Over %" }
recap_temp.Localize.DetailMenu = { {Text="Total Damage",Info="Total"}, {Text="Average Hit",Info="Avg"}, {Text="Max Hit",Info="Max"}, {Text="Crit Rate",Info="CritP"}, {Text="Miss Rate/Overheal Rate",Info="MissPOverP"} }
recap_temp.Localize.EffectMenu = { {Text="Reset Effect",Info="ResetEffect"} }
recap_temp.Localize.EffectOptMenu = { {Text="Element",Info="EElement"}, {Text="Total",Info="ETotal"}, {Text="Total %",Info="ETotalP"},
									{Text="Max Dmg",Info="EMaxAll"}, {Text="Glances",Info="EGlances"}, {Text="Min Glance",Info="EGlancesMin"}, {Text="Avg Glance",Info="EGlancesAvg"},
									{Text="Max Glance",Info="EGlancesMax"}, {Text="Hits",Info="EHits"}, {Text="Min Hit",Info="EHitsMin"}, {Text="Avg Hit",Info="EHitsAvg"},
									{Text="Max Hit",Info="EHitsMax"}, {Text="Ticks",Info="ETicks"}, {Text="Min Tick",Info="ETicksMin"}, {Text="Avg Tick",Info="ETicksAvg"},
									{Text="Max Tick",Info="ETicksMax"}, {Text="Crits",Info="ECrits"}, {Text="Min Crit",Info="ECritsMin"}, {Text="Avg Crit",Info="ECritsAvg"},
									{Text="Max Crit",Info="ECritsMax"}, {Text="Crit Rate",Info="ECritsP"}, {Text="Misses",Info="EMiss"},
									{Text="Miss Rate",Info="EMissP"} }

-- auto-post drop down choices
recap_temp.Localize.StatDropList = { "DPS", "Damage", "Tanking", "Healing" }
recap_temp.Localize.ChannelDropList = { "Self", "Party", "Say", "Raid", "Guild" }

recap_temp.Localize.MissTypes = { ["Missed"] = "Missed", ["Dodged"] = "Dodged", ["Parried"] = "Parried", ["Blocked"] = "Blocked", ["Deflected"] = "Deflected",
								 ["Resisted"] = "Resisted", ["Reflected"] = "Reflected", ["Absorbed"] = "Absorbed", ["Immune"] = "Immune", ["Evaded"] = "Evaded" }

recap_temp.Localize.ClassName = { ["WARRIOR"] = "Warrior", ["MAGE"] = "Mage", ["ROGUE"] = "Rogue", ["DRUID"] = "Druid",
								 ["HUNTER"] = "Hunter", ["SHAMAN"] = "Shaman", ["PRIEST"] = "Priest", ["WARLOCK"] = "Warlock",
								 ["PALADIN"] = "Paladin", ["Pet"] = "Pet" }
recap_temp.Localize.ClassAbbr = { ["WARRIOR"] = "War", ["MAGE"] = "Mag", ["ROGUE"] = "Rog", ["DRUID"] = "Dru",
								 ["HUNTER"] = "Hnt", ["SHAMAN"] = "Shm", ["PRIEST"] = "Pri", ["WARLOCK"] = "Wlk",
								 ["PALADIN"] = "Pal", ["Pet"] = "Pet" }
recap_temp.Localize.FactionName = { ["Alliance"] = "Alliance", ["Horde"] = "Horde" }
recap_temp.Localize.SchoolName = { [1] = "Physical", [2] = "Holy", [4] = "Fire", [8] = "Nature", [16] = "Frost", [32] = "Shadow", [64] = "Arcane" }
recap_temp.Localize.PowerName = { [0] = "Mana", [1] = "Rage", [2] = "Focus", [3] = "Energy", [4] = "Happiness", [-2] = "Health" }


-- channels to block when posting Recent Combat Event information (lower case) (English, French)
recap_temp.Localize.BlockChannels = { "general", "général",
									"trade", "commerce",
									"localdefense", "défenselocale",
									"worlddefense", "défenseuniverselle",
									"guildrecruitment", "recrutementdeguilde",
									"yell", "crier",
									"lookingforgroup", "recherchegroupe" }

end -- of the localization



--[[ -------- DO NOT LOCALIZE THE FOLLOWING SECTION --------- ]]

--[[ Defaults ]]

recap_temp.DefaultOpt = {
		-- window state settings
		["View"] =				{ type="Button", value="All" },
		["SelfView"] =			{ type="Flag", value=false },
		["SortBy"] =			{ type="Flag", value="Name" },
		["SortDir"] =			{ type="Flag", value=true },
		["ESortBy"] =			{ type="Flag", value="ETotal" },
		["ESortDir"] =			{ type="Flag", value=true },
		["State"] =				{ type="Flag", value="Idle" },
		["SkipNextFight"] =		{ type="Flag", value=false },
		["Visible"] =			{ type="Flag", value=true },
		["Minimized"] =			{ type="Button", value=false },
		["Pinned"] =			{ type="Button", value=false },
		["Paused"] =			{ type="Button", value=false },
		["PanelView"] =			{ type="Flag", value=1 }, -- current panel tab
		["OutgoingPanelDetail"] =	{ type="Flag", value="Total" }, -- chosen outgoing detail stat column
		["IncomingPanelDetail"] =	{ type="Flag", value="Total" }, -- chosen incoming detail stat column
		["PanelAnchor"] =		{ type="Flag", value=false, Main="TOPLEFT", Panel="TOPRIGHT" },
		["RecentAnchor"] =		{ type="Flag", value=false, Main="TOPLEFT", Recent="TOPRIGHT" },
		["RecentView"] =		{ type="Flag", value=1 }, -- current recent tab
		["GrowUpwards"] =		{ type="Flag", value=false },
		["GrowLeftwards"] =		{ type="Flag", value=true },
		["NumPartyMembers"] =	{ type="Flag", value=1 }, -- for figuring out when we join a party (transition from 1 to 2+)
		["InsideInstance"] =	{ type="Flag", value=false }, -- for figuring out when we enter an instance (transition from false to true)
		-- user settings options
		["UseColor"] =			{ type="Check", value=true },
		["ShowTooltips"]=		{ type="Check", value=true },
		["TooltipFollow"] =		{ type="Check", value=false },
		["AutoHide"] =			{ type="Check", value=false },
		["AutoFade"] =			{ type="Check", value=false },
		["AutoFadeTimer"] =		{ type="Slider", value=5 },
		["SetScale"] =			{ type="Slider", value=100 },
		["LimitFights"] =		{ type="Check", value=false },
		["HideZero"] =			{ type="Check", value=false },
		["HideYardTrash"] =		{ type="Check", value=false },
		["HideGroup"] =			{ type="Check", value=false },
		["HideOthers"] =		{ type="Check", value=false },
		["StoreOnlyDisplayed"] =	{ type="Check", value=false },
		["MergePets"] =			{ type="Check", value=true },
		["IgnoreGUIDs"] =		{ type="Check", value=false },
		["IdleFight"] =			{ type="Check", value=true },
		["IdleFightTimer"] =	{ type="Slider", value=10 },
		["EndFightDelay"] =		{ type="Slider", value=5 },
		["MaxRows"] =			{ type="Slider", value=10 },
		["AutoMinimize"] =		{ type="Check", value=false },
		["ShowPanel"] =			{ type="Check", value=true },
		["OpaqueBackground"] =	{ type="Check", value=false },
		["MinimizeOnEscape"] =	{ type="Check", value=false },
		["ShowGauges"] =		{ type="Check", value=false }, -- Hawksy: default changed to false
		["LightData"] =			{ type="Check", value=false },
		["RecentData"] =		{ type="Check", value=false },
		["OtherData"] =			{ type="Check", value=false },
		["MatrixData"] =		{ type="Check", value=false },
		["RecentEventCount"] =	{ type="Slider", value=500 },
		["AutoLeader"] =		{ type="Check", value=false },
		["HTML"] =				{ type="Check", value=false },
		["WriteGroup"] =		{ type="Check", value=false },
		["WarnData"] =			{ type="Check", value=true },
		["RemindGroupStatus"] =	{ type="Check", value=false },
		["RemindInstanceStatus"] =	{ type="Check", value=false },
		["CollectGarbage"] =	{ type="Check", value=true },

		-- fight reporting
		["MaxRank"] =			{ type="Slider", value=10 },
		["AutoPost"] =			{ type="Check", value=false, Channel="Self", Stat="DPS" },
		-- fight data sets
		["SaveGroup"] =			{ type="Check", value=false },
		["ReplaceSet"] =		{ type="Check", value=true },
		-- synchronization
		["EnableSync"] =		{ type="Check", value=false }, -- default is to ignore synchronization
		["SyncState"] =			{ type="Flag", value="Ignore" }, -- Ignore, Ready, Member, Leader
		["SyncTimestamp"] =		{ type="Flag", value=false }, -- only belong to a synchronization with this timestamp (integer thousandths)
		["SyncLeader"] =		{ type="Flag", value=false }, -- the leader of the synchronization (Name_GUID_Server)
		["SyncLeaderName"] =	{ type="Flag", value=false }, -- the name of the leader of the synchronization
		["SyncLeaderServer"] =	{ type="Flag", value=false }, -- the server of the leader of the synchronization
		["SyncMergePets"] =		{ type="Flag", value=false }, -- whether the synchronization runs with Merge Pets: 'off' or 'on'
		["SyncUpdateWhen"] =	{ type="Flag", value=false }, -- local time of latest update (integer thousandths)
		-- list elements
		["Ranks"] =				{ type="Check", value=false, width=32 },
		["Faction"] =			{ type="Check", value=false, width=32 },
		["Class"] =				{ type="Check", value=true, width=14 },
		["Seen"] =				{ type="Check", value=false, width=62 },
		["Kills"] =				{ type="Check", value=false, width=31 },
		["Time"] =				{ type="Check", value=true, width=62 },
		["TimeIn"] =			{ type="Check", value=false, width=62 },
		["TimeHeal"] =			{ type="Check", value=false, width=62 },
		["Heal"] =				{ type="Check", value=false, width=62 },
		["HealP"] =				{ type="Check", value=false, width=32 },
		["Over"] =				{ type="Check", value=false, width=32 },
		["DmgIn"] =				{ type="Check", value=true, width=62 },
		["DmgInP"] =			{ type="Check", value=false, width=32 },
		["DmgOut"] =			{ type="Check", value=true, width=62 },
		["DmgOutP"] =			{ type="Check", value=false, width=40 },
		["MaxHit"] =			{ type="Check", value=true, width=45 },
		["HPS"] =				{ type="Check", value=false, width=45 },
		["DPSIn"] =				{ type="Check", value=false, width=45 },
		["DPS"] =				{ type="Check", value=true, width=45 },
		["DPSvsAll"] =			{ type="Check", value=false, width=45 },
		-- minimized elements
		["MinStatus"] =			{ type="Check", value=true, minwidth=16 }, -- width of status light
		["MinSyncStatus"] =		{ type="Check", value=true, minwidth=18 }, -- width of sync status light
		["MinView"] =			{ type="Check", value=false, minwidth=35 },
		["MinYourDPS"] =		{ type="Check", value=true, minwidth=45 },
		["MinDPSIn"] =			{ type="Check", value=false, minwidth=45 },
		["MinDPSOut"] =			{ type="Check", value=false, minwidth=45 },
		["MinYourHPS"] =		{ type="Check", value=false, minwidth=45 },
		["MinHPS"] =			{ type="Check", value=false, minwidth=45 },
		["MinButtons"] =		{ type="Check", value=false },
		["MinBack"] =			{ type="Check", value=true },
		-- personal details elements
		["EElement"] =			{ type="Check", value=true, ewidth=84 },
		["ETotal"] =			{ type="Check", value=true, ewidth=62 },
		["ETotalP"] =			{ type="Check", value=true, ewidth=32 },
		["EMaxAll"] =			{ type="Check", value=true, ewidth=45 },
		["EGlances"] =			{ type="Check", value=false, ewidth=55 },
		["EGlancesMin"] =		{ type="Check", value=false, ewidth=35 },
		["EGlancesAvg"] =		{ type="Check", value=false, ewidth=35 },
		["EGlancesMax"] =		{ type="Check", value=false, ewidth=45 },
		["EHits"] =				{ type="Check", value=false, ewidth=45 },
		["EHitsMin"] =			{ type="Check", value=false, ewidth=35 },
		["EHitsAvg"] =			{ type="Check", value=false, ewidth=35 },
		["EHitsMax"] =			{ type="Check", value=false, ewidth=45 },
		["ETicks"] =			{ type="Check", value=false, ewidth=45 },
		["ETicksMin"] =			{ type="Check", value=false, ewidth=35 },
		["ETicksAvg"] =			{ type="Check", value=false, ewidth=35 },
		["ETicksMax"] =			{ type="Check", value=false, ewidth=45 },
		["ECrits"] =			{ type="Check", value=false, ewidth=45 },
		["ECritsMin"] =			{ type="Check", value=false, ewidth=35 },
		["ECritsAvg"] =			{ type="Check", value=false, ewidth=35 },
		["ECritsMax"] =			{ type="Check", value=false, ewidth=45 },
		["ECritsP"] =			{ type="Check", value=true, ewidth=40 },
		["EMiss"] =				{ type="Check", value=false, ewidth=50 },
		["EMissP"] =			{ type="Check", value=true, ewidth=55 }
};

recap_temp.ClassIcons = {
	["WARRIOR"] = { left=0.025, right=0.225, top=0.025, bottom=0.225 },
	["MAGE"] = { left=0.275, right=0.475, top=0.025, bottom=0.225 },
	["ROGUE"] = { left=0.525, right=0.725, top=0.025, bottom=0.225 },
	["DRUID"] = { left=0.775, right=0.975, top=0.025, bottom=0.225 },
	["HUNTER"] = { left=0.025, right=0.225, top=0.275, bottom=0.475 },
	["SHAMAN"] = { left=0.275, right=0.475, top=0.275, bottom=0.475 },
	["PRIEST"] = { left=0.525, right=0.725, top=0.275, bottom=0.475 },
	["WARLOCK"] = { left=0.775, right=0.975, top=0.275, bottom=0.475 },
	["PALADIN"] = { left=0.025, right=0.225, top=0.525, bottom=0.725 },
	["Pet"] = { left=0.275, right=0.475, top=0.525, bottom=0.725 }
}

recap_temp.FactionIcons = {
	["Alliance"] = "Interface\\TargetingFrame\\UI-PVP-Alliance",
	["Horde"] = "Interface\\TargetingFrame\\UI-PVP-Horde"
}

-- to help keep saved sets from bloat, commonly used strings will be replaced
-- with indexes to this table.  The indexes need to remain in this order.  Add
-- new keys to the end.
recap_temp.Keys = {
	"Alliance", "Horde",
	"WARRIOR", "MAGE", "ROGUE", "DRUID", "HUNTER",
	"SHAMAN", "PRIEST", "WARLOCK", "PALADIN", "Pet"
}

-- healing spells that need to be tracked with special code (e.g. Prayer of Mending)

-- priest Prayer of Mending
-- five charges, migrate within 20 yards, only one at a time on any target, 30 second duration for each
-- there is not a 'cast' of PoM from first holder to subsequent holder, so we have to go by transference of aura (which, just to complicate matters, may not always have events in the combat log)
recap_temp.PoMCastID = 33076 -- priest spell Prayer of Mending (we ignore NPC spell of same name) (duration per target max 30 seconds)
recap_temp.PoMAuraID = 41635 -- aura of same name
recap_temp.PoMHealID = 33110 -- heal of same name attributed in combat log to the target (usually not the priest)
recap_temp.PoMRegistration = {}
recap_temp.PoMMigration = {}
recap_temp.PoMCasts = {}
recap_temp.PoMTotalCastsGroup = 0
recap_temp.PoMTotalCastsNonGroup = 0

-- druid Lifebloom
-- seven ticks of a second each, stacks up to three times per druid, more than one druid's Lifeblooms on a target, can be refreshed so that the final bloom might be delayed indefinitely
-- we don't appear to need to pay any attention to the aura
recap_temp.LBCastID = 33763 -- druid spell Lifebloom (duration per target unless refreshed max 7 seconds)
recap_temp.LBTickID = 33763 -- the healing ticks, already attributed to the druid
recap_temp.LBHealID = 33778 -- final heal (aka the bloom) of same name attributed in combat log to the target (usually not the druid)
recap_temp.LBRegistration = {} -- outer index is target, inner index is source since we can have Lifeblooms from multiple druids on one target
recap_temp.LBCasts = {}
recap_temp.LBTotalCastsGroup = 0
recap_temp.LBTotalCastsNonGroup = 0

-- shaman Earth Shield
-- six charges, only one at a time on a target, ten minute duration
recap_temp.ESCastID = { [974] = true, [32593] = true, [32594] = true } -- shaman spell Earth Shield (three ranks)
recap_temp.ESHealID = 379 -- heal of same name attributed in combat log to the target (usually not the shaman)
recap_temp.ESRegistration = {}
recap_temp.ESCasts = {}
recap_temp.ESTotalCastsGroup = 0
recap_temp.ESTotalCastsNonGroup = 0

-- paladin Judgement of Light
-- paladin casts Seal of Light on self, casts Judgement on target, target acquires Judgement of Light debuff (min 20 second duration), melee hits on the target have a chance to heal the hitter
-- paladin Crusader Strike and paladin melee hits extend the duration of the Judgement of Light on the target
-- we are not currently using the timestamp, nor are we refreshing the aura (we will normally see the aura go away, and can remove it when the mob dies)
recap_temp.JoLCastID = 20271 -- paladin spell Judgement (which can trigger any Seal)
recap_temp.JoLAuraID = 20185 -- aura Judgement of Light
recap_temp.JoLHealID = 20267 -- heal Judgement of Light in combat log to the melee (usually not the paladin)
recap_temp.JoLRegistration = {} -- register Judgement of Light on a target
recap_temp.JoLRegistrationHitter = {} -- register hitter hitting a target that has Judgement of Light
recap_temp.JoLCasts = {}
recap_temp.JoLTotalCastsGroup = 0
recap_temp.JoLTotalCastsNonGroup = 0

-- druid Improved Leader of the Pack
-- druid casts Cat Form (768) or Dire Bear Form (9634), party members get Leader of the Pack aura (24932), they get healed (Improved Leader of the Pack (34299)) when they deal critical melee hits
recap_temp.ILotPCastID = { [768] = true, [9634] = true } -- druid feral forms (Cat Form and Dire Bear Form)
recap_temp.ILotPAuraID = 24932 -- aura Leader of the Pack (no 'Improved')
recap_temp.ILotPHealID = 34299 -- heal Improved Leader of the Pack in combat log to the melee (usually not the druid)
recap_temp.ILotPRegistrationFeral = {} -- register switch to feral form
recap_temp.ILotPRegistration = {} -- register combatant with the Leader of the Pack buff
recap_temp.ILotPCasts = {} -- going to have to count the casts after the fact, when and if an ILotP heal happens
recap_temp.ILotPTotalCastsGroup = 0
recap_temp.ILotPTotalCastsNonGroup = 0


-- druid Improved Leader of the Pack moderately tricky
-- aura, indefinite duration for party while druid in feral form
-- aura IDs probably 34297 and 34300 (two ranks)
-- hitters get healed when they crit with a melee or ranged attack

-- TODO: research
-- what kinds of events accompany a druid with Imp LotP going into feral form? cast, gain aura, lose aura, heal ?




-- table used when logging recent events
-- the table has a fixed length array (a circular buffer) of sub-tables, and two numerical indexes for the first and last events
--   each sub-table represents an event, and has a timestamp, source combatant, destination combatant, effect, amount (or missType or 'miss'), and whether it is a crit
recap_temp.Recent = {}


--[[ Misc variables ]]

recap_temp.Recap = "Recap"
recap_temp.Loaded = false
recap_temp.Player = false
recap_temp.PlayerGUID = false
recap_temp.Server = false
recap_temp.p = false -- for use with recap[] -- without GUID
recap_temp.s = false -- for use with recap.Self[] -- without GUID
recap_temp.InGroup = {} -- records whether combatant is part of the strict group (the Group set can be smaller than the Friend set)
recap_temp.InFriend = {} -- records whether combatant is a Friend (optimization) (the Friend set can be larger than the Group set if members have been added by hand)
recap_temp.Last = {} -- active last fight indexed by name
recap_temp.LastPlayerPets = {} -- pets of the player who are in the last fight
recap_temp.List = {} -- constructed display list, numerically indexed
recap_temp.ListSize = 0 -- number of .List values
recap_temp.SelfList = {} -- list for damage breakdown
recap_temp.SelfListSize = 0
recap_temp.ActiveLastFight = "1" -- alternates between 1 and 2
recap_temp.DisplayLastFight = "2" -- alternates between 2 and 1
recap_temp.FightStart = 0 -- group time fight started
recap_temp.FightEnd = 0 -- group time fight ended
recap_temp.FightStartIn = 0 -- group time fight started (for damage taken)
recap_temp.FightEndIn = 0 -- group time fight ended (for damage taken)
recap_temp.FightStartHeal = 0 -- group time fight started (for healing)
recap_temp.FightEndHeal = 0 -- group time fight ended (for healing)
recap_temp.IdleTimer = -1 -- 0+ = time since last hit or heal happened (user can set to trigger after seconds)
recap_temp.HiddenIdleTimer = -1 -- 0+ = time since last hit or heal happened (hard coded to trigger after 10 minutes)
recap_temp.FadeTimer = -1 -- 0+ = time since left window
recap_temp.EndFightDelayTimer = -1 -- 0+ = time since end-of-fight was triggered
recap_temp.EndSyncDelayTimer = -1 -- 0+ = time since end-of-sync was triggered
recap_temp.UpdateTimer = 0 -- 0+ = time since last window update (generic, runs except when "Stopped", fires every half second)
recap_temp.SyncStatusLightBlink = 0 -- 0 to 3, used to blink the sync light on data transmission
recap_temp.SyncHeartbeat = 0 -- 0 to 9, used to send our name and server to everyone in the sync once every five seconds
recap_temp.LiveUpdateTimer = 0 -- time since last calculation of live update numbers (so we can make it less often than every half second)
recap_temp.PetCombatantMask = bit.bor(COMBATLOG_OBJECT_TYPE_PET, COMBATLOG_OBJECT_TYPE_GUARDIAN, COMBATLOG_OBJECT_TYPE_OBJECT)
recap_temp.ColorRed =	 { r=1.00, g=0.30, b=0.30 }
recap_temp.ColorRedPale =  { r=1.00, g=0.55, b=0.55 }
recap_temp.ColorGreen =  { r=0.25, g=0.85, b=0.25 }
recap_temp.ColorGreenPale = { r=0.50, g=0.85, b=0.50 }
recap_temp.ColorBlue =	 { r=0.30, g=0.55, b=0.85 }
recap_temp.ColorBluePale =	 { r=0.55, g=0.75, b=0.85 }
recap_temp.ColorWhite =  { r=0.85, g=0.85, b=0.85 }
recap_temp.ColorNone =   { r=1.00, g=0.82, b=0.00 }
recap_temp.ColorCyan =   { r=0.25, g=0.70, b=0.85 }
recap_temp.ColorLightCyan =   { r=0.50, g=0.85, b=0.90 }
recap_temp.ColorYellow = { r=1.00, g=1.00, b=0.55 }
recap_temp.ColorLime =   { r=0.60, g=1.00, b=0.60 }
recap_temp.ColorPink =   { r=1.00, g=0.65, b=1.00 }
recap_temp.FightSets = {} -- list of fight data sets
recap_temp.FightSetsSize = 1 -- size of fight list
recap_temp.FightSetSelected = 0
recap_temp.MinTime = 3.0 -- threshhold to calculate DPS, DPSIn, or HPS (time still accumulates)
recap_temp.DeemedTime = 1.5 -- any damage or healing in a fight will have an associated duration of at least this
recap_temp.PlayerInCombat = false -- records whether the player is personally in combat (for deciding whether to calculate live numbers)
recap_temp.PlayerDPSLast = 0 -- live player dps for last fight
recap_temp.PlayerDPSAll = 0 -- live player dps for last fight
recap_temp.PlayerHPSLast = 0 -- live player hps for all fights
recap_temp.PlayerHPSAll = 0 -- live player hps for all fights
recap_temp.TotalGroupDmgIn = 0 -- pre-calculated group damage in for all fights (for calculating live numbers)
recap_temp.TotalGroupDmgOut = 0 -- pre-calculated group damage out for all fights (for calculating live numbers)
recap_temp.TotalGroupHeal = 0 -- pre-calculated group healing out for all fights (for calculating live numbers)
recap_temp.GroupDPSOutLast = 0 -- live group dps out for last fight
recap_temp.GroupDPSInLast = 0 -- live group dps in for last fight
recap_temp.GroupHPSLast = 0 -- live group hps out for last fight
recap_temp.GroupDPSOutAll = 0 -- live group dps out for all fights
recap_temp.GroupDPSInAll = 0 -- live group dps in for all fights
recap_temp.GroupHPSAll = 0 -- live group hps out for all fights
recap_temp.Selected = 0 -- index in .List of currently selected combatant, 0 for none, special values (GroupIndex and NonGroupIndex) for grand totals
recap_temp.RecentSelected = 0 -- index of currently selected Recent button matching .List of combatants (or of effects)
recap_temp.PanelRecentSelected = 0 -- index of currently selected Recent button matching .List of details
recap_temp.OutgoingDetailSelected = 0 -- index in .OutgoingDetail of currently selected detail, 0 for none
recap_temp.TargetDetailSelected = 0 -- index in .TargetDetail of currently selected detail, 0 for none
recap_temp.IncomingDetailSelected = 0 -- index in .IncomingDetail of currently selected detail, 0 for none
recap_temp.SourceDetailSelected = 0 -- index in .SourceDetail of currently selected detail, 0 for none
recap_temp.OtherDetailSelected = 0 -- index in .OtherDetail of currently selected detail, 0 for none
recap_temp.RecentIncomingSelected = 0 -- index in .RecentIncoming of currently selected detail, 0 for none
recap_temp.RecentOutgoingSelected = 0 -- index in .RecentOutgoing of currently selected detail, 0 for none
recap_temp.OutgoingDetailsListSize = 0 -- number of Outgoing detail entries
recap_temp.TargetDetailsListSize = 0 -- number of Target detail entries
recap_temp.IncomingDetailsListSize = 0 -- number of Incoming detail entries
recap_temp.SourceDetailsListSize = 0 -- number of Source detail entries
recap_temp.OtherDetailsListSize = 0 -- number of Other detail entries
recap_temp.RecentIncomingListSize = 0 -- number of Recent Incoming detail entries
recap_temp.RecentOutgoingListSize = 0 -- number of Recent Outgoing detail entries
recap_temp.GaugeWidth = 100 -- max width of gauges
recap_temp.GaugeMax = 0 -- highest value from which gauges are adjusted
recap_temp.GaugeBy = false -- "DmgInP" "DmgOutP" or "HealP"
recap_temp.StatLeader = false -- name of current stat leader
recap_temp.MaxLogLines = 100 -- maximum number of lines to write to log
recap_temp.MaxRecentEventLinesClipboard = 500 -- maximum number of Recent Event lines to write to the clipboard
recap_temp.OnEnterOnLeave = false -- whether we are already processing an OnEnter-OnLeave event (poor man's spinlock)
recap_temp.OnCommReceived = false -- whether we are already processing an OnCommReceived event (poor man's spinlock)
recap_temp.ScrollAndEdgeWidth = 48 -- now a global -- 8(edge)+32(scroll)+8(edge)
recap_temp.NameWidth = 144 -- now a global and increased from 120 to 144
recap_temp.LogChatnum = false -- set to the channel number if we have a channel to log to
recap_temp.ResetWasInCurrent = false -- so that we set WasInCurrent only once in a fight
recap_temp.LastFightSignificant = false -- to note whether the Last Fight was significant enough to update the existing Last Fight data
recap_temp.LastFightSignificantTime = 5.0 -- a fight in which no combatant deals or receives damage for longer than this number will not be deemed significant
recap_temp.Menu = false -- current dropdown menu
recap_temp.MaxMenuLines = 25 -- context menus, used by Recap_CreateMenu(), currently 23 in use
recap_temp.GroupTotal = "Group Total" -- name of a hidden combatant
recap_temp.NonGroupTotal = "Non-Group Total" -- name of a hidden combatant
recap_temp.GroupIndex = 665 -- special value to indicate selection of group hidden combatant
recap_temp.NonGroupIndex = 666 -- special value to indicate selection of non-group hidden combatant
-- The following needed to translate channel names back into canonical names for use by WoW
recap_temp.CanonicalChannelDropList = { "Self", "Party", "Say", "Raid", "Guild" }
recap_temp.RecentButtonWidth = 55 -- amount needed for the 'Recent' button
recap_temp.RecentIndex = 0 -- offset of Recent event selected for display ByIndex (0 if none)
recap_temp.OutgoingPriorRecentIndex = 0 -- the previous Recent index clicked (used for detecting double clicks)
recap_temp.OutgoingPriorClickTime = 0 -- the previous time that a Recent index was clicked (used for detecting double clicks)
recap_temp.IncomingPriorRecentIndex = 0 -- the previous Recent index clicked (used for detecting double clicks)
recap_temp.IncomingPriorClickTime = 0 -- the previous time that a Recent index was clicked (used for detecting double clicks)
recap_temp.CombatantPriorCombatant = "" -- the previous Combatant (All Fights or Last Fight) clicked (used for detecting double clicks)
recap_temp.CombatantPriorClickTime = 0 -- the previous time that a Combatant (All Fights or Last Fight) was clicked (used for detecting double clicks)
recap_temp.SelfPriorEffect = "" -- the previous Effect (Self) clicked (used for detecting double clicks)
recap_temp.SelfPriorClickTime = 0 -- the previous time that an Effect (Self) was clicked (used for detecting double clicks)
recap_temp.OutgoingEffectPriorEffect = "" -- the previous Effect (OutgoingDetail) clicked (used for detecting double clicks)
recap_temp.OutgoingEffectPriorClickTime = 0 -- the previous time that an Effect (OutgoingDetail) was clicked (used for detecting double clicks)
recap_temp.IncomingEffectPriorEffect = "" -- the previous Effect (IncomingDetail) clicked (used for detecting double clicks)
recap_temp.IncomingEffectPriorClickTime = 0 -- the previous time that an Effect (IncomingDetail) was clicked (used for detecting double clicks)
recap_temp.UnexpectedErrorMessageCount = 0 -- count of number of unexpected event error messages emitted, stopping after some number such as 10

-- variables to support remembering sync requests until after combat
recap_temp.SyncInviteTimestamp = false -- timestamp of the sync
recap_temp.SyncInviteLeader = false -- leader of the sync
recap_temp.SyncInviteMergePets = false -- whether Merge Pets is: 'off' or 'on'
recap_temp.SyncInviteWhen = false -- local time we received the invitation (for ignoring stale invitations)
recap_temp.SyncInviteNewOngoing = false -- whether the invitation was for a new sync, or an ongoing sync
recap_temp.AskingJoinSync = false -- spinlock so we don't ask the question multiple times
recap_temp.SyncData = {} -- synchronization Summary data indexed by name
recap_temp.SyncMembers = {} -- people we have noticed in our synchronization, the sync version they are running, and when we last heard from them
recap_temp.Invite = "I"
recap_temp.Accept = "A"
recap_temp.Decline = "D"
recap_temp.Summary = "S"
recap_temp.Reply = "R"
recap_temp.Heartbeat = "H"
recap_temp.SkipNextFight = "X"

-- global to store the original Error Handler
recap_Original_ErrorHandler = nil

localization_lua_411 = true
