﻿if (GetLocale() == "zhCN") then

-- Simplified Chinese translations by Ariestk(虐杀)
-- Translations updated 2007-12-26

--[[ Miscellaneous variables and localization strings for Recap ]]

recap_temp = {}; -- other global values (not saved to SavedVariables)

--[[ Tooltips, option indexes ]]

-- First field each line MUST NOT CHANGE (they are option ids)
-- the order MUST NOT CHANGE until HeaderTime.  They are in the order of GetID values
recap_temp.OptList = {
	{ "UseColor", "应用颜色", "启用时,友方人员及伤害量以绿色显示,承受的伤害量以红色显示,治疗量以蓝色显示." },	-- 1
	{ "GrowUpwards", "窗口向上展开", "窗口从底部开始向上展开." },
	{ "GrowLeftwards", "窗口向左展开", "窗口从右部向左展开." },
	{ "ShowTooltips", "显示提示", "启用时,鼠标指向某个选项时显示提示信息." },
	{ "AutoHide", "战斗时自动隐藏", "窗口没有最小化时,进入战斗后,自动隐藏伤害统计窗口,战斗结束后再显示." },
	{ "AutoFade", "自动渐隐窗口", "窗口没有最小化时,当你的鼠标离开伤害统计窗口后渐隐." },
	{ "LimitFights", "进入战斗后统计", "当你进入战斗后才进行数据统计.  不推荐选择,除非你不想统计周围人的数据." },
	{ "HideZero", "仅显示战斗中的", "不在战斗中的数据将不被显示.  这个设定用来排除图腾等的数据." },
	{ "HideOthers", "Hide Other Combatants", "When checked, hides all other combatants who are not in the group.  This will include allies, neutrals, and foes.\n\nThis option should normally be turned off." },
	{ "IdleFight", "空闲时停止记录", "在一段时间内没有伤害和治疗动作将进入空闲状态." }, -- 10
	{ "Time", "显示时间", "每一位战斗人员的战斗时间将在列表中显示." },
	{ "MaxHit", "显示最高伤害", "每一位战斗人员的最高伤害将在列表中显示." },
	{ "DmgIn", "显示承受伤害", "在列表中显示每位成员的伤害承受总量." },
	{ "DmgOut", "显示伤害输出", "在列表中显示每位成员的伤害输出总量." },
	{ "DPSIn", "显示承受伤害的DPS", "在列表中显示每位成员的伤害承受DPS." },
	{ "DPS", "显示输出DPS", "在列表中显示每位成员的输出DPS." },
	{ "MinStatus", "最小化时显示状态", "最小化时,保留状态指示灯." },
	{ "MinView", "最小化时显示最后/全部", "最小化时,在小标签上显示最后/全部的战斗数值." },
	{ "MinYourDPS", "最小化时显示输出DPS", "最小化时,在小标签上显示你的DPS数值." },
	{ "MinDPSIn", "最小化时显示总承受DPS", "最小化时,在小标签上显示所有友方成员的伤害承受DPS." }, -- 20
	{ "MinDPSOut", "最小化时显示总输出DPS", "最小化时,在小标签上显示所有友方成员的总伤害输出DPS." },
	{ "MinButtons", "最小化时显示按钮", "最小化时,右上部的按钮 (关闭, 锁定, 暂停, 选项, 最后/全部) 将显示." },
	{ "TooltipFollow", "鼠标提示位置", "选中时,鼠标指向的提示将不在默认位置出现. 注意: 有些插件可能已改变了这个默认位置." },
	{ "SaveGroup", "仅保存友方", "选中时,只有当前被标记为友方的人员的数据会被保存.  改变友方/敌对的方法是:右键点击他们的名字." },
	{ "ReplaceSet", "替换已有存档", "选中时,保存和载入设置时将替换已有的存档,否则将合并入旧存档." },
	{ "Heal", "显示治疗量", "选中时,将在列表中显示每位成员的有效治疗量,过量治疗将被去除." },
	{ "Kills", "显示死亡次数", "选中时,将在列表中显示成员的死亡次数." },
	{ "HideYardTrash", "显示唯一的战斗成员", "选中时,非友方人员死亡一次数据即被隐藏.适合在Solo时隐藏怪物等的数据." },
	{ "place_holder_29", "", "" },
	{ "Faction", "显示阵营和等级", "选中时,当一个成员的阵营和等级是已知的,将在他们的名字旁显示." }, -- 30
	{ "Class", "显示职业", "选中时,当成员的职业是已知的,将在他的名字旁显示职业图标." },
	{ "HealP", "显示治疗量所占%", "选中时,在每个治疗职业旁显示他的可见治疗量占总量的百分比." },
	{ "DmgInP", "显示伤害承受所占%", "选中时,显示每位成员所承受伤害量占总承受量的百分比." },
	{ "DmgOutP", "显示伤害输出所占%", "选中时,显示每位成员的伤害输出占总输出量的百分比." },
	{ "AutoPost", "自动报告结果", "选中时,在每次战斗结束后自动向已指定的聊天频道发送简明报告." },
	{ "MinBack", "最小化时显示背景", "选中时,背景不会在最小化时变得透明." },
	{ "MergePets", "合并宠物数值", "从选中时开始,所有成员宠物的数据将合并给他们自己.从取消选择开始,宠物的数值将单独计算." },
	{ "AutoMinimize", "自动最小化", "选中时,当鼠标离开窗口将自动最小化.鼠标进入最小化界面将自动展开.按住shift或选中一个战斗成员时将无视此选项." },
	{ "ShowPanel", "显示详情", "选中时,当鼠标指向一个成员时,将有一个面板显示更详细的信息.选定此成员将锁定面板.简明信息模式下,仅显示简明信息." },
	{ "LightData", "简明信息模式", "选中时,额外的信息,比如未命中/抵抗等将不在详情面板里显示和收集.\n\n注意: 目前, 自己的详情数据将不在简明模式下显示." }, -- 40
	{ "ShowGauges", "显示柱状条", "选中时,显示成员伤害和治疗量的柱状图将在名字后面出现.目前,此功能仅支持伤害承受/伤害输出/治疗量的显示.其它数据的排序可通过点击各自标题实现." },
	{ "AutoLeader", "自动报告新领导", "选中时,当团队领导变更时自动在已设定的聊天频道发送报告." },
	{ "Ranks", "列表成员编号", "选中时,将显示列表内的成员编号." },
	{ "DPSvsAll", "显示个人DPS与输出总量对比", "选中时,显示DPS价值,代表每个成员的DPS数值与其伤害总量的对比结果." },
	{ "Over", "过量治疗", "选中时,显示判断的在全部战斗中每个治疗者的过量治疗百分比.  记住:因为每职业的治疗方法不同,每个成员的治疗任务也不同.所以不要以此来衡量治疗者的治疗效率." },
	{ "HTML", "HTML格式", "选中时,WOWchatlog.txt或剪贴板内容将为简单的HTML格式." },
	{ "WriteGroup", "仅记录友方人员", "选中时,报告仅记录友方战斗人员的数据." },
	{ "ETotal", "记录效果合计", "选中时,每个伤害和治疗数据将被合计在个人详情里." },
	{ "ETotalP", "显示贡献", "选中时,每个技能的伤害或治疗贡献将以%显示在个人详情里." },
	{ "EHits", "显示命中", "选中时,非暴击和反射的伤害命中数将显示在个人详情里." }, -- 50
	{ "EHitsAvg", "显示平均命中", "选中时,非暴击和非反射的平均伤害值将显示在个人详情里." },
	{ "EHitsMax", "显示最大命中伤害", "选中时,非暴击非反射的最大伤害值将显示在个人详情里." },
	{ "ETicks", "显示Tick作用次数", "选中时,Tick (Tick表示DOT或HOT的每一跳) 的作用次数将在个人详情中显示." },
	{ "ETicksAvg", "显示Tick的平均值", "选中时,Tick的平均值将在个人详情中显示." },
	{ "ETicksMax", "显示Tick的高大值", "选中时,Tick最大值将在个人详情中显示." },
	{ "ECrits", "显示暴击", "选中时,暴击次数将在个人详情中显示." },
	{ "ECritsAvg", "显示平均暴击", "选中时,平均暴击值将在个人详情中显示." },
	{ "ECritsMax", "显示最大暴击", "选中时,最大暴击值将在个人详情中显示." },
	{ "ECritsP", "显示暴击率", "选中时,每个法术的暴击率将在个人详情中显示." },
	{ "EMiss", "显示攻击失败", "选中时,在个人详情中显示每个法术攻击失败的次数. 非近战攻击包括未命中/偏斜/抵抗,近战攻击包括招架/格挡/闪避." }, -- 60
	{ "EMissP", "显示攻击失败率", "选中时,将在个人详情里显示每个法术的攻击失败率." },
	{ "EMaxAll", "显示最大伤害", "选中时,将在个人详情里显示单次攻击的最大伤害." },
	{ "WarnData", "当数据太大时警告", "选中时,当你累积记录的战斗成员超过500时发出警告.Recap能很好的记录超过1000人的数据,但这似乎没什么实际用处." },
	{ "HPS", "显示HPS输出", "选中时,每个战斗成员的有效HPS(每秒治疗量)将显示在列表中." },
	{ "place_holder_65", "", "" },
	{ "RecentData", "最近数据模式", "选中时，最近的事件将被记录.\n\n当选项应用，可以看到一名战斗者的最近输出和承受输入, 点击输出和输入详情名字右边的最近按钮.\n\n看技能的相应信息也是如此.\n\nRecap不会将数据写入硬盘.  重启UI时数据将清空.\n\n警告: 激活时，最近数据模式将调用额外的内存." },
	{ "IgnoreGUIDs", "Ignore Global Unique Identifiers", "When checked, ignore the global unique identifiers provided for combatants with WoW patch 2.4 and later.  This will give behaviour similar to older versions of Recap, and will use significantly less memory.\n\nChanging this option forces a Reset.\n\nIf this option is checked then synchronization is not allowed." },
	{ "HideGroup", "Hide Group", "When checked, hides other combatants in the group (and their pets if any).  Group includes a party of five or a raid of forty.  Group also includes any combatant that you have added using the right-click dropdown menu.\n\nThis option should normally be turned off." },
	{ "EElement", "显示法系", "选中时,每个法术的法系(火系/暗影等),将显示在个人详情里." },
	{ "TimeIn", "伤害承受时间", "选中时,每个战斗成员的治疗时间将显示在列表中." }, -- 70
	{ "TimeHeal", "显示治疗时间", "选中时,每个战斗成员的伤害承受时间将显示在列表中." },
	{ "EnableSync", "启用同步数据", "选中时,Recap将准备发送和接收其他玩家的同步数据.你可以加入新的团队并同步于其他队友.不选择时Recap不会理会任何同步信息,也不会回应任何同步请求.\n\nNot allowed if the Ignore Global Unique Identifiers option is checked." },
	{ "OpaqueBackground", "背景不透明", "选中时,所有面板会有一个黑色背景." },
	{ "MinimizeOnEscape", "按Esc最小化", "选中时,按下ESC后Recap主面板将最小化." },
	{ "MinSyncStatus", "最小化时显示同步状态", "选中时,最小化时同步状态灯会保持在面板上." },
	{ "RemindGroupStatus", "加入或离开团队时提醒", "选中时,当你加入或离开团队时弹出对话通知.提醒你也许该做些什么,比如重置设置." },
	{ "Seen", "First Seen", "When checked, the time that this combatant was first seen in the combat log will be displayed in the list." },
	{ "CollectGarbage", "回收垃圾信息", "选中时,每次战斗结束后自动回收本插件产生的垃圾信息." },
	{ "OtherData", "其它数据模式", "选中时,Recap将跟踪事件,并非仅伤害和治疗.它包括,施法过程,DEBUFF/损伤 BUFF/增益.\n\n所有被跟踪的信息将在一个弹出的详情面板中显示.\n\n当简明信息模式开启时,此项无效." },
	{ "EHitsMin", "显示最小命中", "选中时,将在个人详情中显示最小命中伤害,非暴击和反射." },  -- 80
	{ "ETicksMin", "显示最小Tick", "选中时,将在个人详情中显示最小Tick数值." },
	{ "ECritsMin", "显示最小暴击", "选中时,将在个人详情中显示最小暴击数值." },
	{ "EGlances", "显示反射", "选中时,将在个人详情中显示反射次数" },
	{ "EGlancesMin", "显示最小反射", "选中时,将在个人详情中显示最小反射数值." },
	{ "EGlancesAvg", "显示平均反射", "选中时,将在个人详情中显示平均反射数值." },
	{ "EGlancesMax", "显示最大反射", "选中时,将在个人详情中显示最大反射数值." },
	{ "RemindInstanceStatus", "进入或离开区域时提醒", "选中时,当你进入或离开某区域时会弹出提示窗口,以提醒你做某些准备,比如保存数据等." },
	{ "StoreOnlyDisplayed", "只存储友方/团队/玩家数据", "选择时, 非以上三类成员的战斗数据将不被追踪和存储.\n\n在此之前已经存储的其他人员数据不会被删除.\n\n在同步期间,此选项将被忽略.\n\n警告: 有时候,WOW和RECAP无法立即检测出一个团队成员是玩家还是宠物,如果检测延迟,这之间的数据会被丢失.\n\n推荐关闭,除非你的内存很大." },
	{ "MinYourHPS", "最小化时显示你的HPS", "选中时，在最小化窗口显示你的每秒治疗量（HPS）" },
	{ "MinHPS", "最小化时显示团队HPS总量 ", "选中时，在最小化窗口显示团队的每秒治疗量（HPS）." },  -- 90
	{ "MatrixData", "矩阵数据模式", "选中时，Recap将跟踪谁伤害谁，谁治疗谁，谁受到谁的伤害，以及谁受到谁的治疗。\n\n如果此项被应用, 数据将在输出的目标上显示 (一般在左边)，输入 (鼠标指针左) POP面板.\n\n简明数据模式开启时，将不进行数据跟踪." },
	{ "SetScale", "设置比例", "设置Recap显示面板的比例." },

	-- tooltips that don't change can go below in any order. Ensure future options go above these
	{ "HeaderSeen", "First Seen", "This is the time that this combatant was first seen in the combat log." },
	{ "HeaderTime", "战斗时间", "从战斗成员第一次获得战斗信息到最后一次获得战斗信息的持续时间." },
	{ "HeaderTimeIn", "伤害承受时间", "从第一个战斗成员被伤害到最后一次被伤害的持续时间." },
	{ "HeaderTimeHeal", "治疗时间", "从战斗人员第一次治疗到最后一次治疗的持续时间." },
	{ "HeaderMaxHit", "最大伤害", "这是某个战斗成员单次攻击或技能的最大伤害值(非暴击)." },
	{ "HeaderDmgIn", "伤害承受", "每个成员受到的伤害(坦克选项)." },
	{ "HeaderDmgOut", "伤害输出", "每个成员的伤害输出." },
	{ "HeaderHPS", "个体HPS输出", "这是个人的HPS(每秒治疗)数值.持续从第一次治疗到最后一次." },
	{ "HeaderDPSIn", "个体DPS承受", "这是个人的伤害承受DPS值, 持续从第一次承受伤害到最后一次." },
	{ "HeaderDPS", "个体每秒伤害", "这是个人的伤害(DPS)值, 持续从第一次输出到最后一次输出." },
	{ "HeaderHeal", "治疗量", "这是战斗成员的可见治疗量." },
	{ "HeaderKills", "死亡数", "这是在战斗记录有效距离内发生的死亡次数." },
	{ "Options", "打开设置窗口", "打开或关闭设置窗口,用于管理设置或战斗数据." },
	{ "SyncStatus", "同步状态", "当你在同步状态时蓝色灯亮,否则灯不亮.交换同步数据时蓝色灯闪烁." },
	{ "TooltipMinYourDPS", "自己的DPS", "这是你自己的DPS值,包括宠物." },
	{ "TooltipMinDPSIn", "总承受伤害DPS", "所有友方战斗成员总伤害承受DPS." },
	{ "TooltipMinDPSOut", "总伤害输出DPS", "所有友方战斗成员总DPS." },
	{ "TooltipMinYourHPS", "你的HPS", "这是你个人的每秒治疗量，包含宠物。" },
	{ "TooltipMinHPS", "总量HPS", "这是友方成员的总秒治疗量." },
	{ "AutoFadeSlider", "自动隐藏需时", "在你选择了鼠标离开窗口自动隐藏时, 鼠标离开后多久窗口自动隐藏." },
	{ "SetScaleSlider", "设置比例", "设置Recap显示面板的比例，从小(0.5)到大(2.0)。\n\n改变比例将使Recap回去屏幕中间, 然后你可以将它移动到你喜欢的位置" },
	{ "IdleFightSlider", "战斗空闲时间", "当选择战斗后进入空闲选项时, 多久后进入空闲状态." },
	{ "EndFightDelaySlider", "战斗延迟结束", "当玩家离开战斗后延迟一段时间结束战斗(这是为了防止你短时间离开战斗时停止记录)." },
	{ "RecentEventCountSlider", "最近事件总计", "被记录的最近事件的合计数.\n\n所以发布的事件报告不要超过此数,此项只能在'最近战斗事件'未激活时改变,数量多时需要更多的内存." },
	{ "ExitRecap", "关闭Recap", "战斗监视停止. 并完全关闭Recap." },
	{ "HideWindow", "隐藏窗口", "继续监视战斗,但是此隐藏窗口." },
	{ "ExpandWindow", "展开窗口", "展开窗口并显示战斗详情." },
	{ "MinimizeWindow", "最小化窗口", "最小化窗口并隐藏战斗详情." },
	{ "UnPinWindow", "解锁窗口", "窗口可自由移动." },
	{ "PinWindow", "锁定窗口", "锁定窗口,使之不能移动." },
	{ "Resume", "重新监视", "当战斗监视暂停时. 重新开始监视战斗信息." },
	{ "PauseMonitoring", "暂停监视", "点击暂停监视战斗信息.  暂停收集战斗数据, 直到你打开重新监视." },
	{ "ShowAllFights", "显示所有战斗", "如果当前窗口显示的是最后一次战斗信息.此项可以重新查看所有的战斗信息." },
	{ "ShowLastFight", "显示最后战斗", "如果当前窗口显示的是全部的战斗信息.此项可以显示最后一次战斗信息." },
	{ "CombatLast", "成员战斗信息", "此窗口显示成员列表里的战斗信息.右键点击名字变可改变友方/敌方." },
	{ "CombatAll", "成员所有战斗信息", "此项设定战斗成员列表里显示的全部的战斗信息.右键点击名字可改变友方/敌方." },
	{ "ResetLastFight", "重置最后战斗信息", "将从全部数据中减去最后战斗信息.注意: 最大一击和过量治疗只能在重置全部战斗里扣减." },
	{ "ResetAllTotals", "重置全部战斗信息", "将清空全体成员的战斗信息, 除了已存档的数据及个人详情.已存档的战斗数据只能在选项里删除.个人详情只能在可见情况下清空." },
	{ "SaveAllSet", "保存所有数据", "点此保存当前所有的战斗数据." },
	{ "SaveLastSet", "保存最后战斗数据", "点此保存当前最后一次战斗数据." },
	{ "LoadSet", "载入战斗数据", "点击这里将载入保存的战斗数据." },
	{ "DeleteSet", "删除战斗数据", "点击这里将删除保存的战斗数据." },
	{ "DataSetEdit", "设置存档名称", "选择列表里的一个战斗数据或创建一个新数据并命名." },
	{ "OptExit", "关闭Recap", "停止战斗监视并完全关闭Recap."},
	{ "OptOk", "完成", "完成设置并关闭选项面板."},
	{ "HeaderHealP", "治疗输出%", "这是友方战斗成员的有效治疗量在全部有效治疗量中占的百分比." },
	{ "HeaderDmgInP", "承受伤害%", "这是友方战斗成员承受的伤害在总承受伤害中占的百分比." },
	{ "HeaderDmgOutP", "伤害输出%", "这是友方战斗成员输出伤害在总伤害输出中占的百分比." },
	{ "OptTab1", "界面设置", "此项可设置每个窗口的显示样式.\n\n注意: 显示设置不会影响数据.你能够关闭任何常规样式,留下最基本的显示框架." },
	{ "OptTab2", "普通设置", "这个设置定义窗口的行为, 数据界面及其它各种设置." },
	{ "OptTab3", "战斗数据设置", "这里你能管理战斗数据.战斗数据是从所有战斗和最后战斗得来的数据." },
	{ "OptTab4", "报告设置", "此处可管理你的报告, 开始频道记录,以及从剪贴板发送报告." },
	{ "OptTab5", "同步数据", "此处可管理Recap同步功能.Recap在每次战斗结束后同步所有摘要信息,其它Recap信息不在当前同步." },
	{ "MaxRowsSlider", "最大行数", "调整窗口显示的最大行数." },
	{ "MaxRankSlider", "最大排名", "调整从聊天窗口发送报告的战斗人员记录数量." },
	{ "PanelClose", "关闭面板", "隐藏详细面板.  信息仍然存在只是隐藏.要停止收集详细数据,在参数设置里选择'简明数据模式'." },
	{ "PanelTab1", "承受详情: 坦克", "此面板将显示承受的伤害,治疗,以及未命中." },
	{ "PanelTab2", "输入来源", "此标签将显示伤害输入和治疗输入信息.\n\n这个跟踪选项默认为关闭，开启矩阵数据模式将启用此选项 / Settings panel." },
	{ "PanelTab3", "输出详情: 伤害", "此面板将显示输出信息,伤害及治疗." },
	{ "PanelTab4", "输出目标", "此标签将显示伤害输出和治疗输出信息.\n\n这个跟踪选项默认为关闭，开启矩阵数据模式将启用此选项 / Settings panel." },
	{ "PanelTab5", "其它详情: 施法 Debuff/损伤 Buff/增益", "此面板将显示,施法(绿),Debuff/损伤(红),Buff/增益(蓝) 未知法术(白)\n\n几乎包括了BLZ除了伤害和治疗外的所有法术事件. \n\n此项默认为半闭.要开启此功能请在'设置'中开启'其它数据模式'."},
	{ "PanelTab6", "所有详情: 摘要", "此面板将显示战斗者的信息摘要." },
	{ "PanelTabDisabled1", "承受详情: 坦克 (禁用)", "你当前在简明数据模式.坦克详情未被收集.解除简明数据模式可收集每个战斗者承受的伤害和未中信息." },
	{ "PanelTabDisabled2", "输入来源 (禁用)", "你当前处于简明数据模式. 来源详情未被收集.\n\n反选简明数据模式以收集每个成员的伤害输入和躲闪." },
	{ "PanelTabDisabled3", "输出详情: 伤害 (禁用)", "你当前在简明数据模式.伤害详情未被收集.可解除简明数据模式." },
	{ "PanelTabDisabled4", "输出目标 (禁用)", "你当前处于简明数据模式. 输出详情未被收集.\n\n反选简明数据模式以收集每个成员的伤害输出" },
	{ "PanelTabDisabled5", "其它详情: 施法 Debuff/损伤 Buff/增益 (禁用)", "你当前在简明数据模式.其它详情未被收集.可解除简明数据模式." },
	{ "RecentClose", "关闭面板", "隐藏详细面板. 信息仍然存在只是隐藏." },
	{ "RecentTab1", "最近输入事件", "此标签将收集战斗成员的当前输入事件, 也许根据效果进行过滤." },
	{ "RecentTab2", "最近输出事件", "此标签将收集战斗成员的当前输出事件，也许根据效果进行过滤." },
	{ "PanelEntry25", "时间 (最后战斗)", "最后战斗中输出伤害的时间." },
	{ "PanelEntry26", "最大伤害 (最后战斗)", "最后战斗的最大伤害(非暴击)." },
	{ "PanelEntry27", "死亡(最后战斗)", "最后战斗的死亡次数." },
	{ "PanelEntry28", "治疗(最后战斗)", "最后战斗所有有效治疗." },
	{ "PanelEntry29", "承受伤害 (最后战斗)", "最后战斗中所有的承受伤害量." },
	{ "PanelEntry30", "承受DPS (最后战斗)", "最后战斗中承受伤害的DPS." },
	{ "PanelEntry31", "伤害输出 (最后战斗)", "最后战斗中所有的伤害输出." },
	{ "PanelEntry32", "输出DPS (最后战斗)", "最后战斗中的输出DPS." },
	{ "PanelEntry33", "输出治疗HPS (最后战斗)", "最后战斗中的有效HPS." },
	{ "PanelEntry34", "输出治疗HPS (全部战斗)", "HPS Out (actual) for 全部战斗." },
	{ "PanelEntry35", "时间 (全部战斗)", "全部战斗的伤害输出时间." },
	{ "PanelEntry36", "最大伤害 (全部战斗)", "全部战斗的最大伤害(非暴击)." },
	{ "PanelEntry37", "死亡 (全部战斗)", "全部战斗的死亡次数." },
	{ "PanelEntry38", "治疗 (全部战斗)", "全部战斗的有效治疗量." },
	{ "PanelEntry39", "承受伤害 (全部战斗)", "全部战斗所承受的伤害." },
	{ "PanelEntry40", "承受伤害DPS (全部战斗)", "全部战斗所承的\受伤害的DPS." },
	{ "PanelEntry41", "伤害输出 (全部战斗)", "全部战斗的伤害输出量." },
	{ "PanelEntry42", "DPS输出 (全部战斗)", "全部战斗的输出DPS." },
	{ "PanelEntry45", "全部伤害或治疗", "此法术的全部输出量或治疗量" },
	{ "PanelEntry46", "命中次数", "此法术非暴击反射等的命中次数." },
	{ "PanelEntry47", "暴击次数", "此法术的暴击次数." },
	{ "PanelEntry48", "平均命中伤害", "此法术非暴击的平均命中伤害." },
	{ "PanelEntry49", "平均暴击伤害", "此法术暴击或极效治疗的平均值." },
	{ "PanelEntry50", "最大命中", "此法术非暴击等的最大伤害值." },
	{ "PanelEntry51", "最大暴击", "此法术造成伤害暴击或极效治疗的最高值." },
	{ "PanelEntry52", "平均Tick数值", "Tick成伤害或治疗的平均值." },
	{ "PanelEntry53", "最大Tick", "Tick造成伤害和治疗的最大值." },
	{ "PanelEntry54", "法系", "  法术的法系(暗影,火等)." },
	{ "PanelEntry55", "受攻击未受中", "受到攻击未命中的." },
	{ "PanelEntry56", "受攻击躲闪", "受到攻击躲闪的.." },
	{ "PanelEntry57", "受攻击闪避", "受到攻击闪避的." },
	{ "PanelEntry58", "受攻击格挡", "受到攻击格挡的.." },
	{ "PanelEntry59", "受攻击吸收", "受到攻击吸收的." },
	{ "PanelEntry60", "受攻击偏斜", "受到攻击偏斜的.." },
	{ "PanelEntry61", "受攻击逃脱", "受到攻击逃脱的.." },
	{ "PanelEntry62", "受攻击抵抗", "受到攻击抵抗的.." },
	{ "PanelEntry63", "受攻击反射", "受到攻击反射的." },
	{ "PanelEntry64", "受攻击免疫", "受到攻击免疫的.." },
	{ "PanelEntry65", "暴击率", "暴击数与所有攻击数的比率." },
	{ "PanelEntry66", "Tick数量", "法术于目标上实际发生的Tick数量." },
	{ "PanelEntry67", "未命中率", "所有攻击中未命中的比率." },
	{ "PanelEntry70", "伤害输出未受中", "你的技能或攻击未命中." },
	{ "PanelEntry71", "伤害输出躲闪", "你的技能或攻击被躲闪." },
	{ "PanelEntry72", "伤害输出闪避", "你的技能或攻击被闪避." },
	{ "PanelEntry73", "伤害输出格挡", "你的技能或攻击被格挡." },
	{ "PanelEntry74", "伤害输出吸收", "你的技能或攻击被吸收." },
	{ "PanelEntry75", "伤害输出偏斜", "你的技能或攻击偏斜." },
	{ "PanelEntry76", "伤害输出逃脱", "你的技能或攻击被逃脱." },
	{ "PanelEntry77", "伤害输出抵抗", "你的技能或攻击被抵抗." },
	{ "PanelEntry78", "伤害输出反射", "你的技能或攻击被反射.." },
	{ "PanelEntry79", "伤害输出免疫", "你的技能或攻击失败,对方免疫." },
	{ "PanelEntry80", "时间(最后战斗)", "最后战斗的伤害输出时间." },
	{ "PanelEntry81", "时间(全部战斗)", "全部战斗的伤害输出时间." },
	{ "PanelEntry82", "治疗时间 (最后战斗)", "最后战斗的治疗时间." },
	{ "PanelEntry83", "治疗时间 (全部战斗)", "全部战斗的治疗时间." },
	{ "PanelEntry90", "Crush 次数", "Crush效果的次数." },
	{ "PanelEntry91", "Crush 平均值", "Crush造成伤害的平均值." },
	{ "PanelEntry92", "Crush 最大值", "Crush最大伤害值." },
	{ "PanelEntry93", "Crush 比率", "在攻击中出现Crush的比率." },
	{ "PanelEntry94", "属性", "法术带来的属性增益或降低." },
	{ "PanelEntry95", "合计", "法术带来的增益和损失总和.BUFF和DEBUFF将显示堆叠总数." },
	{ "PanelEntry96", "命中", "法术命中总数." },
	{ "PanelEntry97", "平均", "法术造成的增益或损失的平均值.." },
	{ "PanelEntry98", "最大值", "法术造成的增益或损失的最大值." },
	{ "PanelEntry99", "驱散", "法术被驱散的次数." },
	{ "PanelEntry100", "间隔合计", "两个法术之间的时间间隔." },
	{ "PanelEntry101", "判断平均间隔", "判断法术施放的平均间隔(秒). 仅是预估.\n\n注意: 超过130秒的间隔将被忽视." },
	{ "PanelEntry102", "失败", "任何原因的法术失败数量." },
	{ "PanelEntry103", "持续时间计数", "法术持续时间计数." },
	{ "PanelEntry104", "判断平均持续时间", "判断此法术的平均持续时间..\n\n注意: 超过130秒的时间将被忽视." },
	{ "PanelEntry105", "其它法术", "如果法术显示为绿色, 则为需念唱法术; 如果显示为红色,则为DEBUFF或減益; 如果显示为蓝色,则为BUFF或增益; 如果显示为白色,则为BUFF或DEBUFF,但Recap不能准确判断." },
	{ "PanelEntry106", "反射次数", "法术的反射次数." },
	{ "PanelEntry107", "平均反射值", "法术平均的附带反射伤害." },
	{ "PanelEntry108", "最大反射", "此法术的最大反射伤害." },
	{ "PanelEntry109", "反射率", "此法术的反射率." },
	{ "PanelEntry110", "部分吸收", "部分吸收的次数 (不是完全吸收)." },
	{ "PanelEntry111", "部分吸收平均值", "部分格挡的次数 (不是完全吸收)." },
	{ "PanelEntry112", "部分格挡", "部分格挡的次数 (不包含全部格挡的).." },
	{ "PanelEntry113", "部分格挡平均值", "所有部分吸收伤害的平均数 (不包含全部格挡的)." },
	{ "PanelEntry114", "部分抵抗25%", "抵抗25%伤害的次数 (不包含全部抵抗的)." },
	{ "PanelEntry115", "部分抵抗25%平均值", "所有抵抗25%伤害的平均值 (不包含全部抵抗的)." },
	{ "PanelEntry116", "部分抵抗50%", "抵抗50%伤害的次数 (不包含全部抵抗的)." },
	{ "PanelEntry117", "部分抵抗50%平均值", "所有抵抗25%伤害的平均值 (不包含全部抵抗的)." },
	{ "PanelEntry118", "部分抵抗75%", "抵抗75%伤害的次数 (不包含全部抵抗的)." },
	{ "PanelEntry119", "部分抵抗75%平均值", "所有抵抗25%伤害的平均值 (不包含全部抵抗的)." },
	{ "PanelEntry120", "Steals", "The number of times this effect has been stolen." },
	{ "PanelEntry122", "最小反射", "法术造成的最小伤害反射和治疗值." },
	{ "PanelEntry123", "最小命中", "法术普通攻击下造成的伤害或治疗." },
	{ "PanelEntry124", "最小暴击", "最小暴击或极效治疗值." },
	{ "PanelEntry125", "最小Crush", "此效果的最小Crush伤害和治疗" },
	{ "PanelEntry126", "最小Tick", "Tick造成的最小伤害或治疗值." },
	{ "PanelEntry127", "部分吸收合计", "部分吸收的数值合计 (不包含全部吸收的)." },
	{ "PanelEntry128", "部分格挡合计", " 部分格挡的数值合计不包含全部格挡的)." },
	{ "PanelEntry129", "部分抵抗25%合计", "部分抵抗25%数值合计 (不包含全部抵抗的)." },
	{ "PanelEntry130", "部分抵抗50%合计", "部分抵抗50%数值合计 (不包含全部抵抗的)." },
	{ "PanelEntry131", "部分抵抗75%合计", "部分抵抗75%数值合计 (不包含全部抵抗的)." },
	{ "PanelEntry133", "估算总抵抗值", "估算战斗中的总抵抗数值, 包含全部抵抗和部分抵抗. 这仅是一个估算.\n\n百分率作为抵抗的估算使用." },
	{ "PanelEntryOverheal", "过量治疗", "没有价值的治疗量.治疗量超出目标损失的血量" },
	{ "OpenLog", "打开记录", "将打开WoW Logs文件夹下的WOWChatLog.txt 文件." },
	{ "ReportToLog", "报告写进记录", "为当前战斗者保存报告, 及此人的个人详情报告, 写入WoW Logs文件夹下的WOWChatLog.txt 文件." },
	{ "CloseLog", "关闭记录", "关闭名为WOWChatLog.txt 的记录." },
	{ "UseOneSettings", "使用全局设置", "默认情况下, 设置会保存在每个角色的目录下. 选择这项功能将使目前的设置和所有角色共用.\n\n注意: 设置中保存的战斗数据将删除其他角色的数据.\n\n这个选项不会影响个人详细数据. 它们总是每个角色独立的." },
	{ "MenuAdd", "加为友方", "将一个战斗成员加入友方列表." },
	{ "MenuDrop", "删除友方", "从友方列表里删除一名友方." },
	{ "MenuReset", "重置战斗成员", "重置选择的战斗成员数据.  所有战斗,数据和详细数据都将重置.  最后战斗,将会从全部战斗中移出该战斗数据." },
	{ "MenuIgnore", "忽略战斗成员", "忽律该战斗成员的战斗数据,直到重置所有数据才能重新统计该成员数据." },
	{ "RecapAnchorTopLeft", "锚点在左上", "将锚点设置在窗口位置的左上方." },
	{ "RecapAnchorTopRight", "锚点在右上", "将锚点设置在窗口位置的右上方." },
	{ "RecapAnchorBottomLeft", "锚点在左下", "将锚点设置在窗口位置的左下方." },
	{ "RecapAnchorBottomRight", "锚点在右下", "将锚点设置在窗口位置的右下方." },
	{ "Total", "效果合计", "这是最近一次重置数据后,此法术或技能全部的伤害或治疗效果总计." },
	{ "Max", "最大命中", "这是此法术最大的治疗或伤害值." },
	{ "Avg", "平均命中", "这是此法术平均的治疗或伤害值." },
	{ "CritP", "暴击率", "这里是此法术暴击的比率." },
	{ "MissPOverP", "未击中率/过量治疗", "对于伤害效果, 这里是未击中率.  对治疗效果, 这里是过量治疗比率." },
	{ "Contribution", "贡献", "统计每个法术对战斗者伤害或治疗量的贡献." },
	{ "OtherHits", "命中", "此法术的命中次数." },
	{ "OtherTotal", "合计", "此法术的所有增益或减益值合计. 对一些法术来说只是简单的返回命中次数." },
	{ "Attribute", "属性", "从此法术的得到的属性增强或损失." },
	{ "HeaderDPSvsAll", "DPS对比", "每个成员的DPS与的伤害总量的对比." },
	{ "HeaderOver", "过量治疗", "这是过量治疗的百分比, 对应每个友方成员的全部治疗量." },
	{ "ReportFightsToClipboard", "写入剪贴板", "将拷贝目前的战斗成员信息到剪贴板中,方便其他写字板程序浏览." },
	{ "ReportDetailsToClipboard", "详情写入剪贴板", "将拷贝目前的战斗成员详细信息到剪贴板中,方便其他写字板程序浏览." },
	{ "ShowSelfView", "显示当前角色详情", "显示个人的详细信息." },
	{ "HideSelfView", "隐藏当前角色详情", "将隐藏个人的伤害和治疗详细信息, 并且返回到全部战斗成员伤害和治疗显示." },
	{ "ResetSelfView", "重置详细信息", "重置这个窗口里的成员详细信息. 不过你自己的的详细信息将不受影响." },
	{ "ResetEffect", "重置个人详情", "重置自己的详细信息统计." },
	{ "HeaderEName", "技能或属性", "你的这些技能或属性达到的效果.  绿色表示伤害效果,蓝色表示治疗效果." },
	{ "HeaderEElement", "效果法系", "这是法系 (暗影, 火系, 神圣, 等.) ." },
	{ "HeaderETotal", "效果合计", "伤害或治疗效果的合计." },
	{ "HeaderETotalP", "效果贡献", "这是每个效果对伤害和治疗能力的贡献(理论上)" },
	{ "HeaderEMaxAll", "最大伤害或治疗", "每个效果可能造成的最大伤害和治疗, Tick或暴击中产生的最大值." },
	{ "HeaderEGlances", "反射次数", "每个法术附带反射效果的次数." },
	{ "HeaderEGlancesAvg", "平均反射", "每个法术附带反射的平均伤害." },
	{ "HeaderEGlancesMax", "最大反射", "法术的某次反射造成的最大值." },
	{ "HeaderEHits", "击中数", "不包括暴击的击中次数." },
	{ "HeaderEHitsAvg", "平均击中", "不包括暴击的击中平均治疗或伤害值." },
	{ "HeaderEHitsMax", "最大一击(非暴击)", "这个数字表示单次最大非暴击伤害或非暴击治疗值." },
	{ "HeaderETicks", "Tick数", "Tick产生的伤害或治疗次数." },
	{ "HeaderETicksAvg", "平均Tick", "Tick产生的平均伤害或治疗值." },
	{ "HeaderETicksMax", "最大Tick", "Tick的最大的伤害或治疗." },
	{ "HeaderECrits", "暴击数", "这个数字表示暴击的次数." },
	{ "HeaderECritsAvg", "平均暴击", "暴击的平均伤害或治疗值." },
	{ "HeaderECritsMax", "最大暴击", "最大的暴击伤害或治疗值." },
	{ "HeaderECritsP", "暴击率", "百分比表示暴击比率, 暴击数除以击中数得到百分比.Ticks没有暴击." },
	{ "HeaderEMiss", "未击中", "表示未击中的次数.  包括非普通攻击的未击中, 抵抗和偏斜, 普攻的闪避, 格挡和招架." },
	{ "HeaderEMissP", "未击中率", "未击中百分比." },
	{ "HeaderEGlancesMin", "最小反射", "法术附带反射效果造成的最小值." },
	{ "HeaderEHitsMin", "最小命中", "每个法术理论上的最小伤害或最小治疗(非暴击情况)." },
	{ "HeaderETicksMin", "最小Tick", "DOT类法术每一跳理论上的最小值." },
	{ "HeaderECritsMin", "最小暴击", "法术造成暴击理论上的最小值." },
	{ "StartSync", "开始同步", "此按钮将在团队发出一个同步邀请,以使你做为同步发起者.你将离开当前同步频道,Recap将重置所有战斗. 你将发送和接收同步信息.\n\n团内的任何人都可以发起同步." },
	{ "ManualSync", "手动同步", "此按钮将立即同步信息.一般情况下,同步将在每次战斗结束后自动进行,但有时,你需要手动进行同步.\n\n非战斗中不执行动作." },
	{ "BecomeLeader", "成为领导", "此按钮使你成为同步领导者,以代替一位离线的领导,同时进行一个手动的同步广播来发送此变化.\n\n非战斗中不执行动作." },
	{ "ListMembers", "成员列表", "此按钮显示同步成员列表..\n\n注意:这项功能不一定能将成员显示完全.." },
	{ "ClearInactiveMembers", "移除空闲团员信息", "从列表中移除过去10秒内不活动的成员. 但同步将继续. 如果他们再次活动将再出现在列表中. 这不会在其他人的RECAP列表中清除." },
	{ "SkipNextFight", "Skip Next Fight", "This button will skip the next fight.  Recap will automatically resume tracking following the end of the next fight.\n\nEnabled for the leader of the synchronization.\n\nIf pressed during combat, only the remainder of the current fight will be skipped.\n\nThis button could be used, for example, to skip the chess event in Karazhan.\n\nThe button is also enabled for people who are not in a synchronization." },
	{ "TargetTotal", "输出到目标", "这是最后一次重置后，输出到目标的伤害和治疗量。" },
	{ "SourceTotal", "承受量", "这是最后一次重置后，所承受的伤害和治疗量。" },
	{ "ContributionWhom", "项献", "这是对输出和承受伤害或治疗有帮助的法术总和." },
	{ "RecentIncomingEvents", "最近输入事件", "这是此战斗成员的当前发生事件,也许根据效果进行过滤..\n\nShift+左键 可以发送到当前聊天窗口." },
	{ "RecentOutgoingEvents", "最近输出事件", "这是此战斗成员产生的当前事件，也许根据效果进行过滤..\n\nShift+左键 可以发送到当前聊天窗口." },
	{ "ShowRecent", "显示最近事件", "用一个面板来显示当前战斗成员的输出和输入事件, 或者一个战斗成员的法术和技能.\n\n这个特性能在当前数据模式中启用或禁用。命今：/ Settings tab." },
	{ "ShowGroupTotal", "Show Group Total", "Show a panel with total combined details for combatants in the group." },
	{ "ShowNonGroupTotal", "Show Non-Group Total", "Show a panel with total combined details for combatants not in the group." }
};


--[[ localized strings for the xml labels ]]

-- Bindings.xml (names generated in Bindings.xml)
BINDING_HEADER_RECAP = "Recap"
BINDING_NAME_RECAP_TOGGLE_RECAP = "切换 Recap"
BINDING_NAME_RECAP_TOGGLE_FIGHTS = "切换 最后/全部战斗"
BINDING_NAME_RECAP_OPTIONS = "Recap选项"
BINDING_NAME_RECAP_RESET_ALL = "重置所有战斗"
BINDING_NAME_RECAP_RESET_LAST = "重置最后战斗"
BINDING_NAME_RECAP_RESET_DETAILS = "重置个人详情"
BINDING_NAME_RECAP_RESET_FIGHTS_DETAILS = "重置战斗和详情"
BINDING_NAME_RECAP_SAVE_ALL_FIGHTS = "保存所有战斗"
BINDING_NAME_RECAP_SAVE_LAST_FIGHT = "保存最后战斗"
BINDING_NAME_RECAP_SKIP_NEXT_FIGHT = "Skip Next Fight"

-- Bindings.xml
RECAP_ALL_FIGHTS_RESET = "重置所有战斗"
RECAP_LAST_FIGHT_RESET = "重置最后战斗"
RECAP_DETAILS_RESET = "重置个人详情"
RECAP_FIGHTS_DETAILS_RESET = "重置战斗和详情"
RECAP_SYNCHRONIZATION_RESET = "重置同步"
RECAP_ALL_FIGHTS_SAVED = "所有战斗数据已保存"
RECAP_LAST_FIGHT_SAVED = "最后战斗数据已保存"

-- Recap.xml
RECAP_RECAP = "Recap"
RECAP_RESET = "重置"
RECAP_COMBATANTS = "战斗成员"
RECAP_SEEN = "Seen"
RECAP_DIED = "死亡"
RECAP_TIME = "时间"
RECAP_TIME_IN = "In时间"
RECAP_TIME_HEAL = "治疗时间"
RECAP_HEAL = "治疗"
RECAP_IN = "承受"
RECAP_OUT = "输出"
RECAP_MAX = "最大"
RECAP_HPS = "HPS"
RECAP_DPS_IN = "InDPS"
RECAP_DPS = "DPS"
RECAP_DPS_ALL = "DPS+"
RECAP_MISS = "未命中"
RECAP_RECENT = "最近"
RECAP_TOTAL_DETAILS = "合计"

-- RecapOptions.xml : Display
RECAP_SET_NAME = "输入名称"
RECAP_SAVED = "已保存"
RECAP_RECAP_OPTIONS = "Recap选项"
RECAP_DISPLAY = "显示"
RECAP_SETTINGS = "设置"
RECAP_DATA_SETS = "数据设置"
RECAP_REPORTS = "报告"
RECAP_OK = "完成"
RECAP_EXIT = "退出"
RECAP_DISPLAY_IN_LIST = "显示列表项"
RECAP_NUMBERED_LIST = "列表编号"
RECAP_FACTION_LEVEL = "阵营/等级"
RECAP_CLASS = "职业"
RECAP_FIRST_SEEN = "First Seen"
RECAP_DEATHS = "死亡"
RECAP_HEALS = "治疗"
RECAP_HEALS_P = "治疗%"
RECAP_DAMAGE_IN = "承受伤害"
RECAP_DAMAGE_IN_P = "承受伤害%"
RECAP_DAMAGE_OUT = "伤害输出"
RECAP_DAMAGE_OUT_P = "伤害输出%"
RECAP_MAX_HIT = "最大命中"
RECAP_DPS_VS_ALL = "DPS对比全部"
RECAP_OVERHEALING = "过量治疗"
RECAP_DISPLAY_MINIMIZED = "最小化显示项"
RECAP_STATUS_LIGHT = "状态灯"
RECAP_SYNC_LIGHT = "同步灯"
RECAP_LAST_ALL = "最后/全部"
RECAP_YOUR_DPS = "你的输出DPS"
RECAP_MIN_DPS_IN = "总承受DPS"
RECAP_MIN_DPS_OUT = "DPS输出合计"
RECAP_YOUR_HPS = "你的HPS"
RECAP_MIN_HPS= "总量HPS"
RECAP_BUTTONS = "按钮"
RECAP_BACKGROUND = "背景"
RECAP_MAXIMUM_ROWS = "最大行数"
RECAP_SHOW_GAUGES = "显示柱状条"
RECAP_ANCHOR = "锚点"
RECAP_DISPLAY_PERSONAL_DETAILS = "个人详情"
RECAP_SELF_EELEMENT = "法系"
RECAP_SELF_ETOTAL = "合计"
RECAP_SELF_ETOTALP = "合计%"
RECAP_SELF_EGLANCES = "反射"
RECAP_SELF_EGLANCESMIN = "最小反射"
RECAP_SELF_EGLANCESAVG = "平均反射"
RECAP_SELF_EGLANCESMAX = "最大反射"
RECAP_SELF_EHITS = "命中"
RECAP_SELF_EHITSMIN = "最小命中"
RECAP_SELF_EHITSAVG = "平均命中"
RECAP_SELF_EHITSMAX = "最大命中"
RECAP_SELF_ETICKS = "Ticks"
RECAP_SELF_ETICKSMIN = "最小Tick"
RECAP_SELF_ETICKSAVG = "平均Tick"
RECAP_SELF_ETICKSMAX = "最大Tick"
RECAP_SELF_ECRITS = "暴击"
RECAP_SELF_ECRITSMIN = "最小暴击"
RECAP_SELF_ECRITSAVG = "平均暴击"
RECAP_SELF_ECRITSMAX = "最大暴击"
RECAP_SELF_ECRITSP = "暴击%"
RECAP_SELF_EMISS = "失败"
RECAP_SELF_EMISSP = "失败%"
RECAP_SELF_EMAXALL = "最大伤害"
-- RecapOptions.xml : Settings
RECAP_WINDOW_OPTIONS = "窗口选项"
RECAP_USE_COLOR = "应用颜色"
RECAP_SHOW_TOOLTIPS = "显示提示"
RECAP_TOOLTIPS_AT_POINTER = "鼠标指向提示"
RECAP_SHOW_DETAILS = "显示详情"
RECAP_OPAQUE_BACKGROUND = "背景不透明"
RECAP_MINIMIZE_ON_ESCAPE = "按Esc最小化"
RECAP_AUTO_HIDE_IN_COMBAT = "战斗中自动隐藏"
RECAP_AUTO_MINIMIZE = "自动最小化"
RECAP_AUTO_FADE_WINDOW = "自动渐隐窗口"
RECAP_SCALING = "缩放"
RECAP_FIGHT_OPTIONS = "战斗选项"
RECAP_LIMIT_FIGHTS_TO_COMBAT = "进入战斗后统计"
RECAP_ONLY_FIGHTS_WITH_DURATION = "仅显示战斗中的"
RECAP_ONLY_UNIQUE_COMBATANTS = "显示唯一的战斗成员"
RECAP_HIDE_GROUP = "Hide Group"
RECAP_HIDE_OTHERS = "Hide Other Combatants"
RECAP_STORE_ONLY_DISPLAYED_COMBATANTS = "只存储 友方/团队/玩家 数据"
RECAP_MERGE_PETS_WITH_OWNERS = "合并宠物数据给人员"
RECAP_IGNORE_GLOBAL_UNIQUE_IDENTIFIERS = "Ignore Global Unique Identifiers"
RECAP_END_FIGHT_IF_IDLE = "空闲时停止记录"
RECAP_END_FIGHT_DELAY = "战斗延时结束"
RECAP_DATA_OPTIONS = "数据选 项"
RECAP_LIGHT_DATA_MODE = "简明数据模式"
RECAP_OTHER_DATA_MODE = "其它数据模式"
RECAP_MATRIX_DATA_MODE = "矩阵数据模式"
RECAP_RECENT_DATA_MODE = "最近数据模式"
RECAP_USE_GLOBAL_SETTINGS = "使用全局设置"
RECAP_WARN_DATA = "数据太大时警告"
RECAP_OTHER_OPTIONS = "其它选项"
RECAP_REMIND_GROUP_STATUS = "加入或离开团队时提醒"
RECAP_REMIND_INSTANCE_STATUS = "进入或离开区域时提醒"
RECAP_COLLECT_GARBAGE = "战斗结束后回收垃圾数据"
-- RecapOptions.xml : Data Sets
RECAP_FIGHT_DATA_SETS = "战斗数据设置"
RECAP_SAVE_GROUP_COMBATANTS_ONLY = "仅保存友方战斗人员"
RECAP_REPLACE_ANY_EXISTING_DATA = "替换所有已存在数据"
RECAP_SAVE_ALL = "全部保存"
RECAP_SAVE_LAST = "保存最后战斗"
RECAP_LOAD = "载入"
RECAP_DELETE = "删除"
-- RecapOptions.xml : Reports
RECAP_FIGHT_REPORTING = "战斗报告"
RECAP_REPORT_RANKS_IN_MULTIPLE_ROWS = "以多行显示报告 (Shift+左键点击和自动报告)"
RECAP_AUTOMATICALLY_POST_RANKS_AFTER_EACH_FIGHT = "战斗结束后自动报告排行"
RECAP_AUTOMATICALLY_POST_CHANGES_IN_LEADERSHIP = "变更领导时自动报告"
RECAP_AUTOMATICALLY_POST = "自动发送"
RECAP_AUTOMATICALLY_POST_TO = "到频道:"
RECAP_WOWCHATLOG_TXT = "写入WOWChatLog.txt"
RECAP_OPEN_WOWCHATLOG_TXT = "打开"
RECAP_ACQUIRING_CHANNEL = "获取频道..."
RECAP_CHANNEL_JOINED = "已加入频道"
RECAP_REPORT_TO_WOWCHATLOG_TXT = "报告"
RECAP_CLOSE_WOWCHATLOG_TXT = "关闭"
-- RecapOptions.xml : Clipboard
RECAP_CLIP_EXPLANATION = "按 CTRL+C 可复制已选内容到剪贴板.\nCTRL+V粘贴到其它程序编缉.  做好后按ESC或点击完成."
RECAP_CLIPBOARD = "报告写入剪贴板"
RECAP_REPORT_FIGHTS_TO_CLIPBOARD = "战斗报告"
RECAP_REPORT_DETAILS_TO_CLIPBOARD = "详情报告"
RECAP_WRITE_ONLY_GROUP = "仅报告友方战斗成员"
RECAP_FORMAT_IN_HTML = "以HTML格式报告"
-- RecapOptions.xml : Synchronization
RECAP_SYNC = "同步数据"
RECAP_SYNCHRONIZATION = "同步数据"
RECAP_ENABLE_SYNC = "启用同步"
RECAP_SYNC_STATE_IGNORE = "忽视同步"
RECAP_SYNC_STATE_READY = "同步等待中"
RECAP_SYNC_STATE_MEMBER = "同步中的成员"
RECAP_SYNC_STATE_LEADER = "同步领导者"
RECAP_START_SYNC = "开始同步"
RECAP_MERGE_PETS_OFF = "<== 合并宠物数据到人物"
RECAP_MERGE_PETS_ON = "<== 不合并宠物数据到人物"
RECAP_MANUAL_SYNC = "手动同步"
RECAP_BECOME_LEADER = "成为同步领导者"
RECAP_LIST_MEMBERS = "成员列表"
RECAP_CLEAR_INACTIVE_MEMBERS = "清除空闲成员记录"
RECAP_SKIP_NEXT_FIGHT = "Skip Next Fight"

-- RecapPanel.xml
RECAP_DAMAGE = "伤害"
RECAP_GLANCES = "反射"
RECAP_HITS = "命中"
RECAP_CRITS = "暴击"
RECAP_CRUSHES = "Crushes"
RECAP_AVERAGE = "平均值"
RECAP_MELEE = "近战"
RECAP_MISSED_DETAILS = "失败详情"
RECAP_MISSED = "未命中"
RECAP_DODGED = "躲避"
RECAP_PARRIED = "闪避"
RECAP_BLOCKED = "格挡"
RECAP_ABSORBED = "吸收"
RECAP_DEFLECTED = "偏斜"
RECAP_EVADED = "逃脱"
RECAP_RESISTED = "抵抗"
RECAP_REFLECTED = "反射"
RECAP_IMMUNE = "免疫"
RECAP_SPELL_OR_ABILITY = "技能或属性"
RECAP_INCOMING_SPELL_OR_ABILITY = "所承受的技能或攻击伤害值"
RECAP_OUTGOING_SPELL_OR_ABILITY = "输出技能或攻击的伤害值"
RECAP_MISSES = "失败"
RECAP_MIN = "最小"
RECAP_AVG = "均值"
RECAP_SUMMARY = "摘要"
RECAP_LAST_FIGHT = "最后战斗"
RECAP_ALL_FIGHTS = "全部战斗"
RECAP_TICKS = "Ticks"
RECAP_INCOMING = "承受"
RECAP_OUTGOING = "输出"
RECAP_OTHER_EFFECTS = "其它法术"
RECAP_TOTAL = "合计"
RECAP_ATTRIBUTE = "属性"
RECAP_ENVIRONMENT = "来自环境"
RECAP_DISPELS = "驱散"
RECAP_STEALS = "Steals"
RECAP_TIMINGS = "频率"
RECAP_INTERVALS = "间隔"
RECAP_SECONDS = "秒"
RECAP_DURATIONS = "持续"
RECAP_INTERRUPT = "打断"
RECAP_ESTIMATED_INTERVAL = "预估间隔"
RECAP_ESTIMATED_DURATION = "预估持续时间"
RECAP_PARTIALS = "部分失败"
RECAP_ABSORBS = "吸收"
RECAP_BLOCKS = "格挡"
RECAP_RESISTS_25 = "抵抗25%"
RECAP_RESISTS_50 = "抵抗50%"
RECAP_RESISTS_75 = "抵抗75%"
RECAP_ESTIMATED_TOTAL_RESISTED = "估算总抵抗值"
RECAP_TARGET_OF_OUTGOING = "输出目标"
RECAP_SOURCE_OF_INCOMING = "承受输入"

-- RecapRecent.xml
RECAP_RECENT_INCOMING_EVENTS = "最近的输入事件"
RECAP_RECENT_OUTGOING_EVENTS = "最近的输出事件"
RECAP_RECENT_INCOMING_EFFECTS = "最近的输入效果"
RECAP_RECENT_OUTGOING_EFFECTS = "最近的输出效果"
RECAP_RECENT_INCOMING_DISPELS = "Recent Incoming Dispels"
RECAP_RECENT_OUTGOING_DISPELS = "Recent Outgoing Dispels"

-- more miscellaneous display strings
RECAP_TIME_FIGHTING = "伤害输出时间"
RECAP_TIME_DAMAGED = "伤害承受时间"
RECAP_TIME_HEALING = "治疗时间"
RECAP_KILLS = "击杀"
RECAP_HPS_OUT = "HPS输出"
RECAP_DPS_OUT = "DPS输出"
RECAP_TOTAL_DPS_OUT = "合计DPS输出"
RECAP_TOTAL_DPS_IN = "合计DPS承受"
RECAP_CRIT_RATE = "暴击率"
RECAP_TEN_ROWS = "10 行"
RECAP_FIVE_SECONDS = "5 秒"
RECAP_TEN_SECONDS = "10 秒"
RECAP_FIVE_HUNDRED_EVENTS = "500 个事件"
RECAP_GROUP_FIGHT_TIME = "团队战斗时间"
RECAP_GROUP_DPS = "团队DPS"
RECAP_ONE = "1.0"


--[[ miscellaneous localized strings ]]

recap_temp.LastAll = { Last="最后战斗", All="所有战斗" }
recap_temp.LastAllShort = { Last="最后战斗", All="所有战斗" }
recap_temp.StoppedActiveIdle = { Stopped="已停止", Active="激活", Idle="空闲" }
recap_temp.Localize = {}
recap_temp.Localize.RankTop = "排行前"
recap_temp.Localize.None = "无"
recap_temp.Localize.Totals = "合计"
recap_temp.Localize.Details = "详情"
recap_temp.Localize.Status = "状态"
recap_temp.Localize.NewLeader = "新领导者"
recap_temp.Localize.With = "与"
recap_temp.Localize.Of = "/"
recap_temp.Localize.For = "汉化by虐杀-"
recap_temp.Localize.Seconds = "秒"
recap_temp.Localize.Events = "事件"
recap_temp.Localize.Rows = "行"
recap_temp.Localize.Subtotal = "小计"
recap_temp.Localize.Group = "友好"
recap_temp.Localize.NonGroup = "不友好"
recap_temp.Localize.ElementOther = "其它" --  Damage element not specified
recap_temp.Localize.ElementHealing = "治疗" --  Healing element not specified
recap_temp.Localize.OwnedBy = "自己由"
recap_temp.Localize.VerboseLinkStart = "Recap %s: %s承受%s的伤害于%s中,%sDPS承受 (%s次死亡);输出%s伤害于%s中,%sDPS输出(最大命中%d);进行了%s有效治疗于%s中,%sHPS治疗输出"
recap_temp.Localize.VerboseGroupTotalStart = "Recap %s: 友方战斗成员承受%s伤害于%s中，　%.1f DPS承受 (%s 次死亡); 输出%s伤害于%s中，　%.1f DPS输出 (最大命中 %d); 进行了%s有效治疗于%s中， %.1f 有效治疗输出"
recap_temp.Localize.VerboseNonGroupTotalStart = "Recap %s: 非友方人员承受%s伤害于%s， %.1f DPS承受 (%s 次死亡); 输出%s伤害于%s中， %.1f DPS输出 (最大命中 %d); 进行了%s有效治疗于%s中， %.1f HPS输出"
recap_temp.Localize.LinkRank = { Time="战斗时间", TimeIn="承受伤害时间", TimeHeal="治疗时间", MaxHit="最大命中", DmgIn="承受伤害", DmgOut="伤害输出", DPS="DPS输出", DPSIn="DPS承受", Heal="治疗", HPS="HPS", Kills="死亡", HealP="治疗", DmgInP="伤害承受", DmgOutP="伤害输出", DPSvsAll="DPS对比总量", Over="估计过量治疗", Seen="First Seen" }
recap_temp.Localize.StatusTooltip = "红灯亮时, 战斗监视停止.\n\n绿灯亮时, 监视当前战斗.\n\n灯不亮时, Recap空闲并等待战斗开始.\n"
recap_temp.Localize.RankUsage = "复制一个recap记录到聊天窗口, shift+左键点击. 例如:\n|cFFAAAAFF/p (shift+左键点击 伤害)|cFFFFFFFF <- 发送一个实时伤害排名到已设定的聊天频道.\n|cFFFF8000/ra (shift+左键点击 DPS)|cFFFFFFFF <- 发送DPS排名到已设定频道."
recap_temp.Localize.SkipChannels = { "综合", "交易", "世界防务", "本地防务", "寻求组队" }
recap_temp.Localize.OutgoingHealDetailLink = "Recap %s: %s: %s (%s) 治疗了 %s hp (%s 于 %s全部治疗)"
recap_temp.Localize.OutgoingHealDetailLinkNoElement = "Recap %s: %s: %s 治疗了 %s hp (%s 于 %s全部治疗)"
recap_temp.Localize.OutgoingDamageDetailLink = "Recap %s: %s: %s (%s)造成伤害 %s hp (%s 于 %s全部伤害)"
recap_temp.Localize.OutgoingDamageDetailLinkNoElement = "Recap %s: %s: %s 造成伤害 %s hp (%s 于 %s全部伤害)"
recap_temp.Localize.TargetHealDetailLink = "Recap %s: %s 治疗了 %s %s hp (%s 于 %s全部治疗)"
recap_temp.Localize.TargetDamageDetailLink = "Recap %s: %s 造成伤害 %s %s hp (%s 于 %s全部伤害)"
recap_temp.Localize.IncomingHealDetailLink = "Recap %s: %s (%s) 治疗了 %s %s hp (%s 于 %s全部治疗承受)"
recap_temp.Localize.IncomingHealDetailLinkNoElement = "Recap %s: %s 治疗了 %s %s hp (%s 于 %s全部治疗承受)"
recap_temp.Localize.IncomingDamageDetailLink = "Recap %s: %s (%s) 造成伤害 %s %s hp (%s － %s全部伤害承受)"
recap_temp.Localize.IncomingDamageDetailLinkNoElement = "Recap %s: %s 造成伤害 %s %s hp (%s － %s全部伤害承受)"
recap_temp.Localize.SourceHealDetailLink = "Recap %s: %s 造成伤害 %s %s hp (%s － %s全部伤害承受)"
recap_temp.Localize.SourceDamageDetailLink = "Recap %s: %s 造成伤害 %s %s hp (%s － %s全部伤害承受)"
recap_temp.Localize.OtherDetailLink = "Recap %s: %s: %s: %s 发生 %s 次 %s"
recap_temp.Localize.OtherDetailType = { "施放", "施放", "Debuff/损失", "Debuff/损失", "Buff/增益", "Buff/增益", "Debuff/Buff/Other", "Debuff/Buff/Other" }
recap_temp.Localize.ConfirmLightData = "你已经选择启用简明信息模式.\n\n如果你同意,Recap 将清除无关信息."
recap_temp.Localize.ConfirmHeavyData = "你已经选择禁用简明信息模式.\n\n如果你同意,Recap 将清除无关信息."
recap_temp.Localize.ConfirmLastReset = "你选择重置最后战斗信息.\n\n如果你同意, 最后战斗信息将被从全部战斗信息中清除. 请确定这是你想做的.\n\n这个重置不是一个简单的清除命令."
recap_temp.Localize.LogHeader = "__ Recap [%.2f] (%s): 生成 %s for %s on %s in %s __"
recap_temp.Localize.LogFormat = "%35s ! %2s %3s !%9s %9s %9s !%8s %4s !%8s %4s %6s !%8s %4s !%5s !%6s"
recap_temp.Localize.Log = { "角色", "Lv", "Cls", "时间", "承受时间", "治疗时间", "冶疗", "%%", "坦克", "%%", "承受DPS", "伤害", "%%", "最大", "DPS" }
recap_temp.Localize.HTMLHeader = "<tr><td colspan=\"15\">Recap [%.2f] (%s): 生成 %s for %s on %s in %s</td></tr>"
recap_temp.Localize.HTMLFormat1 = "<tr align=\"right\"><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td>"
recap_temp.Localize.HTMLFormat2 = "<td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>"
recap_temp.Localize.HTMLPrefix = "<table CELLPADDING=\"2\">"
recap_temp.Localize.HTMLSuffix = "</table>"
recap_temp.Localize.DetailHeader = "__ Recap %s: 生成详情 for %s on %s in %s __"
recap_temp.Localize.DetailFormat = "%30s %18s !%8s %5s !%8s !%7s %6s %6s %6s !%5s %6s %6s %6s !%5s %6s %6s %6s !%5s %6s %6s %6s %7s !%4s %7s"
recap_temp.Localize.Detail = { "法术", "法系", "合计", "Pct", "最大", "反射", "最小", "平均", "最大", "命中", "最小", "平均", "最大", "Ticks", "最小", "平均", "最大", "暴击", "最小", "平均", "最大", "Pct", "失败", "Pct" }
recap_temp.Localize.HTMLDetailHeader = "<tr><td colspan=\"24\">Recap Recap 生成 %s for %s on %s in %s</td></tr>"
recap_temp.Localize.HTMLDetailFormat1 = "<tr align=\"right\"><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td>"
recap_temp.Localize.HTMLDetailFormat2 = "<td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td>"
recap_temp.Localize.HTMLDetailFormat3 = "<td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>"
recap_temp.Localize.NoFreeChannels = "已没有多余的频道来建立记录.请离开一个频道后再次尝试."
recap_temp.Localize.NoChannelNumber = "无法获得一个频道编号."
recap_temp.Localize.LogWritten = "Recap已写入WOWChatLog.txt"
recap_temp.Localize.ConfirmGlobalSettings = "你已经选择启用全局设置.\n\n如果你同意,此插件将重新载入，一些个性信息将丢失."
recap_temp.Localize.ConfirmSeparateSettings = "你已经选择关闭全局设置.\n\n如果你同意,此插件将重新载入，每个角色将单独保存设定."
recap_temp.Localize.LotsOfDataWarning = "Recap有%d个战斗成员\"活动\"数据.已经很多了.\n\n这个消息并不代表你的内存不够.你能关闭这个警告, 关闭方法在参数设置 / 设置 / 数据设置.\n\n如果你不希望再看到它: /recap然后单击参数设置.\n\n如果你不希望继续累积数据, 暂停它.\n\n建议你经常重置, 以使战斗数据保持比较小的内存用量.\n\nIf you are in a synchronization the '重置所有战斗' button will be disabled."
recap_temp.Localize.VersionCheck = "Recap文件也许被损坏了.请重新下载."
recap_temp.Localize.ConfirmIgnoreGUIDs = "You've chosen to ignore global unique identifiers.\n\nIf you accept, Recap will be reset and synchronization will not be allowed."
recap_temp.Localize.ConfirmUseGUIDs = "You've chosen to use global unique identifiers.\n\nIf you accept, Recap will be reset."
recap_temp.Localize.NotAllowedDuringCombat = "Recap: 同步期间不允许"
recap_temp.Localize.InvitesYouToSynchronize = "邀请你加入同步"
recap_temp.Localize.NewSynchronization = "新同步"
recap_temp.Localize.OngoingSynchronization = "同步中的"
recap_temp.Localize.AcceptedSync = "同意你的同步邀请"
recap_temp.Localize.DeclinedSync = "谢绝你的同步邀请"
recap_temp.Localize.MergePetsOff = "关闭合并宠物"
recap_temp.Localize.MergePetsOn = "开启合并宠物"
recap_temp.Localize.Timestamp = "时间戳"
recap_temp.Localize.Leader = "领导"
recap_temp.Localize.LastUpdateWas = "最后更新是"
recap_temp.Localize.Ago = "(hh:mm:ss) 以前"
recap_temp.Localize.FailSendInvite = "发送同步邀请时错误"
recap_temp.Localize.FailSendAccept = "接受同步邀请时错误"
recap_temp.Localize.FailSendDecline = "谢绝同步邀请时错误"
recap_temp.Localize.FailSendSummary = "发送同步摘要错误"
recap_temp.Localize.FailSendReply = "发送同步数据错误"
recap_temp.Localize.FailSendHeartbeat = "发送同步频率错误"
recap_temp.Localize.FailSendSkipNextFight = "Failed to send skip next fight"
recap_temp.Localize.SkipNextFightBegins = "Skip Next Fight begins"
recap_temp.Localize.SkipNextFightEnds = "Skip Next Fight ends"
recap_temp.Localize.NotAllowedDuringSync = "Recap: 同步期间不允许"
recap_temp.Localize.RemindJoinGroup = "Recap: 你已经加入团队."
recap_temp.Localize.RemindLeaveGroup = "Recap: 你已经离开团队."
recap_temp.Localize.RemindEnterInstance = "Recap:你已进入一个区域. 提示你以便有所准备."
recap_temp.Localize.RemindLeaveInstance = "Recap:你已离开一个区域. 提示你以便有所准备"
recap_temp.Localize.OutOfDateSyncVersion = "你不能加入同步,因为你的Recap版本过老."
recap_temp.Localize.SyncMembers = "同步成员"
recap_temp.Localize.InactiveSyncMembers = "闲置的同步成员"
recap_temp.Localize.InSync = "同步中"
recap_temp.Localize.Unknown = "未知"
recap_temp.Localize.Removed = "已移除"
recap_temp.Localize.OtherDataModeNotEnabled = "其它数据模式未启用"
recap_temp.Localize.MatrixDataModeNotEnabled = "矩阵数据模式未启用"
recap_temp.Localize.NotAvailable = "无效的"
recap_temp.Localize.Attacks = "攻击"
recap_temp.Localize.Dispels = "驱散"
recap_temp.Localize.Interrupts = "Interrupts"
recap_temp.Localize.Durability = "Durability"
recap_temp.Localize.Interrupted = "Interrupted"
recap_temp.Localize.Died = "died"
recap_temp.Localize.Killed = "killed"
recap_temp.Localize.TimeWindow = "Time Window"
recap_temp.Localize.AllCombatants = "All Combatants"


-- menus
recap_temp.Localize.ColumnMenu = { {Text="列表编号",Info="Ranks"}, {Text="阵营/等级",Info="Faction"}, {Text="职业",Info="Class"},
								{Text="First Seen",Info="Seen"}, {Text="死亡",Info="Kills"}, {Text="战斗时间",Info="Time"}, {Text="承受伤害时间",Info="TimeIn"},
								{Text="治疗时间",Info="TimeHeal"}, {Text="治疗",Info="Heal"}, { Text="治疗%",Info="HealP"},
								{Text="过量治疗",Info="Over"}, {Text="伤害承受",Info="DmgIn"}, {Text="伤害承受%",Info="DmgInP"},
								{Text="伤害输出",Info="DmgOut"}, {Text="伤害输出%",Info="DmgOutP"}, {Text="最大命中",Info="MaxHit"},
								{Text="HPS",Info="HPS"}, {Text="DPS承受",Info="DPSIn"},
								{Text="DPS输出",Info="DPS"}, {Text="DPS对比全部",Info="DPSvsAll"} }
recap_temp.Localize.MinMenu = { {Text="锁定窗口", Info="Pin"}, {Text="状态灯",Info="MinStatus"}, {Text="同步灯",Info="MinSyncStatus"}, {Text="最后/全部",Info="MinView"},
								{Text="你的DPS",Info="MinYourDPS"}, {Text="合计DPS承受",Info="MinDPSIn"}, {Text="合计DPS输出",Info="MinDPSOut"},
								{Text="你的HPS",Info="MinYourHPS"}, {Text="总量HPS",Info="MinHPS"},
								{Text="按钮",Info="MinButtons"}, {Text="背景",Info="MinBack"} }
recap_temp.Localize.AddMenu = { {Text="添加友方",Info="MenuAdd"}, {Text="重置",Info="MenuReset"}, {Text="忽略",Info="MenuIgnore"} }
recap_temp.Localize.AddLockMenu = { {Text="添加友方",Info="MenuAdd"}, {Text="重置",Info="MenuReset"}, {Text="忽略",Info="MenuIgnore"}, {Text="锁定",Info="MenuLock"} }
recap_temp.Localize.AddUnlockMenu = { {Text="添加友方",Info="MenuAdd"}, {Text="重置",Info="MenuReset"}, {Text="忽略",Info="MenuIgnore"}, {Text="解锁",Info="MenuUnlock"} }
recap_temp.Localize.DropMenu = { {Text="删除友方",Info="MenuDrop"}, {Text="重置",Info="MenuReset"}, {Text="忽略",Info="MenuIgnore"} }
recap_temp.Localize.DropLockMenu = { {Text="删除友方",Info="MenuDrop"}, {Text="重置",Info="MenuReset"}, {Text="忽略",Info="MenuIgnore"}, {Text="锁定",Info="MenuLock"} }
recap_temp.Localize.DropUnlockMenu = { {Text="删除友方",Info="MenuDrop"}, {Text="重置",Info="MenuReset"}, {Text="忽略",Info="MenuIgnore"}, {Text="解锁",Info="MenuUnlock"} }
recap_temp.Localize.DetailTitle = { ["Total"] = "合计", ["Avg"] = "均值", ["Max"] = "最大", ["CritP"] = "暴击率%", ["MissPOverP"] = "失败/过量%" }
recap_temp.Localize.DetailMenu = { {Text="合计伤害",Info="Total"}, {Text="平均命中",Info="Avg"}, {Text="最大命中",Info="Max"}, {Text="暴击率",Info="CritP"}, {Text="失败率/过量治疗率",Info="MissPOverP"} }
recap_temp.Localize.EffectMenu = { {Text="重置详情",Info="ResetEffect"} }
recap_temp.Localize.EffectOptMenu = { {Text="法系",Info="EElement"}, {Text="合计",Info="ETotal"}, {Text="合计%",Info="ETotalP"},
									{Text="最大伤害",Info="EMaxAll"}, {Text="反射",Info="EGlances"}, {Text="最小反射",Info="EGlancesMin"}, {Text="平均反射",Info="EGlancesAvg"},
									{Text="最大反射",Info="EGlancesMax"}, {Text="命中",Info="EHits"}, {Text="最小命中",Info="EHitsMin"}, {Text="平均命中",Info="EHitsAvg"},
									{Text="最大命中",Info="EHitsMax"}, {Text="Ticks",Info="ETicks"}, {Text="最小Tick",Info="ETicksMin"}, {Text="平均Tick",Info="ETicksAvg"},
									{Text="最大Tick",Info="ETicksMax"}, {Text="暴击",Info="ECrits"}, {Text="最小暴击",Info="ECritsMin"}, {Text="平均暴击",Info="ECritsAvg"},
									{Text="最大暴击",Info="ECritsMax"}, {Text="暴击率",Info="ECritsP"}, {Text="失败",Info="EMiss"},
									{Text="最小等级",Info="EMissP"} }

-- auto-post drop down choices
recap_temp.Localize.StatDropList = { "DPS", "伤害", "承受", "治疗" }
recap_temp.Localize.ChannelDropList = { "自己", "队伍", "说", "团队", "公会" }

recap_temp.Localize.MissTypes = { ["Missed"] = "未命中", ["Dodged"] = "躲避", ["Parried"] = "闪避", ["Blocked"] = "格挡", ["Deflected"] = "偏斜",
								 ["Resisted"] = "抵抗", ["Reflected"] = "反射", ["Absorbed"] = "吸收", ["Immune"] = "免疫", ["Evaded"] = "逃脱" }

recap_temp.Localize.ClassName = { ["WARRIOR"] = "战士", ["MAGE"] = "法师", ["ROGUE"] = "潜行者", ["DRUID"] = "德鲁伊",
								 ["HUNTER"] = "猎人", ["SHAMAN"] = "萨满", ["PRIEST"] = "牧师", ["WARLOCK"] = "术士",
								 ["PALADIN"] = "圣骑士", ["Pet"] = "宠物" }
recap_temp.Localize.ClassAbbr = { ["WARRIOR"] = "ZS", ["MAGE"] = "FS", ["ROGUE"] = "QX", ["DRUID"] = "XD",
								 ["HUNTER"] = "LR", ["SHAMAN"] = "SM", ["PRIEST"] = "MS", ["WARLOCK"] = "SS",
								 ["PALADIN"] = "SQ", ["Pet"] = "宠" }
recap_temp.Localize.FactionName = { ["Alliance"] = "联盟", ["Horde"] = "部落" }
recap_temp.Localize.SchoolName = { [1] = "Physical", [2] = "Holy", [4] = "Fire", [8] = "Nature", [16] = "Frost", [32] = "Shadow", [64] = "Arcane" }
recap_temp.Localize.PowerName = { [0] = "Mana", [1] = "Rage", [2] = "Focus", [3] = "Energy", [4] = "Happiness", [-2] = "Health" }


-- channels to block when posting Recent Combat Event information (simplified Chinese)
recap_temp.Localize.BlockChannels = { "综合", "交易", "本地防务", "世界防务", "公会招募", "大喊", "寻求组队" }

end -- of the localization

localization_cn_lua_411 = true
