﻿--[[ RecapRecent.lua ]]

local _G = getfenv(0)
local math_max = _G.math.max
local math_min = _G.math.min
local string_find = _G.string.find
local string_format = _G.string.format
local string_lower = _G.string.lower
local string_sub = _G.string.sub

--[[ local tables ]]

local dockoffset = { ["TOPRIGHTTOPLEFT"] = { x=-4,y=0 },
					 ["BOTTOMRIGHTBOTTOMLEFT"] = { x=-4,y=0 },
					 ["TOPLEFTTOPRIGHT"] = { x=4,y=0 },
					 ["BOTTOMLEFTBOTTOMRIGHT"] = { x=4,y=0 },
					 ["TOPRIGHTBOTTOMRIGHT"] = { x=0,y=-4 },
					 ["BOTTOMRIGHTTOPRIGHT"] = { x=0,y=4 },
					 ["TOPLEFTBOTTOMLEFT"] = { x=0,y=-4 },
					 ["BOTTOMLEFTTOPLEFT"] = { x=0,y=4 } }


--[[ Functions for the popup panel for Recent Events ]]

function RecapRecent_Populate(filterCombatant, filterDispels)

	local iCombatant = recap.Combatant[filterCombatant]
	local sbOffset

	-- normal title bar contents
	if iCombatant.Faction and recap_temp.FactionIcons[iCombatant.Faction] then
		RecapRecentFaction:SetTexture(recap_temp.FactionIcons[iCombatant.Faction])
	else
		RecapRecentFaction:SetTexture("")
	end
	if iCombatant.Level and tonumber(iCombatant.Level)>0 then
		RecapRecentLevel:SetText(iCombatant.Level)
	elseif iCombatant.Level and tonumber(iCombatant.Level)==-1 then
		RecapRecentLevel:SetText("??")
	else
		RecapRecentLevel:SetText(" ")
	end
	if iCombatant.Class and recap_temp.ClassIcons[iCombatant.Class] then
		RecapRecentClass:SetTexCoord(recap_temp.ClassIcons[iCombatant.Class].left,recap_temp.ClassIcons[iCombatant.Class].right,recap_temp.ClassIcons[iCombatant.Class].top,recap_temp.ClassIcons[iCombatant.Class].bottom)
	else
		RecapRecentClass:SetTexCoord(.9,1,.9,1)
	end
	if iCombatant.Friend then
		RecapRecentName:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
	else
		RecapRecentName:SetTextColor(1,1,1)
	end
	RecapRecentName:SetText(Recap_StripGUIDsFromCombatant(filterCombatant))

	recap_temp.RecentIncomingSelected = 0
	recap_temp.RecentOutgoingSelected = 0
	if filterDispels then
		RecapRecentIncomingLabel:SetText(RECAP_RECENT_INCOMING_DISPELS)
		RecapRecentOutgoingLabel:SetText(RECAP_RECENT_OUTGOING_DISPELS)
	else
		RecapRecentIncomingLabel:SetText(RECAP_RECENT_INCOMING_EVENTS)
		RecapRecentOutgoingLabel:SetText(RECAP_RECENT_OUTGOING_EVENTS)
	end

	-- not ByIndex, so make sure that's off
	recap_temp.RecentIndex = 0

	RecapRecent_ConstructRecentIncoming(filterCombatant, nil, nil, filterDispels)
	-- force initial scroll to bottom of list (showing most recent events)
	sbOffset = math_max(recap_temp.RecentIncomingListSize - 1 - 20, 0)
	FauxScrollFrame_SetOffset(RecapRecentIncomingScrollBar, sbOffset)
	RecapRecentIncomingScrollBar_Update()
	RecapRecentIncomingScrollBarScrollBar:SetValue(sbOffset*14)

	RecapRecent_ConstructRecentOutgoing(filterCombatant, nil, nil, filterDispels)
	-- force initial scroll to bottom of list (showing most recent events)
	sbOffset = math_max(recap_temp.RecentOutgoingListSize - 1 - 20, 0)
	FauxScrollFrame_SetOffset(RecapRecentOutgoingScrollBar, sbOffset)
	RecapRecentOutgoingScrollBar_Update()
	RecapRecentOutgoingScrollBarScrollBar:SetValue(sbOffset*14)
end

function RecapRecent_PopulateAll(filterDispels)

	local sbOffset

	-- normal title bar contents
	RecapRecentFaction:SetTexture("")
	RecapRecentLevel:SetText("")
	RecapRecentClass:SetTexCoord(.9,1,.9,1)
	RecapRecentName:SetTextColor(1.0, 0.82, 0.0) -- had to synthesize this, couldn't figure out how to get the 'default' colour
	RecapRecentName:SetText(recap_temp.Localize.AllCombatants)

	recap_temp.RecentIncomingSelected = 0
	recap_temp.RecentOutgoingSelected = 0
	if filterDispels then
		RecapRecentIncomingLabel:SetText(RECAP_RECENT_INCOMING_DISPELS)
		RecapRecentOutgoingLabel:SetText(RECAP_RECENT_OUTGOING_DISPELS)
	else
		RecapRecentIncomingLabel:SetText(RECAP_RECENT_INCOMING_EVENTS)
		RecapRecentOutgoingLabel:SetText(RECAP_RECENT_OUTGOING_EVENTS)
	end

	-- always begin by showing outgoing
	recap.Opt.RecentView.value = 2

	-- not ByIndex, so make sure that's off
	recap_temp.RecentIndex = 0

	RecapRecent_ConstructRecentIncoming(nil, nil, nil, filterDispels)
	-- force initial scroll to bottom of list (showing most recent events)
	sbOffset = math_max(recap_temp.RecentIncomingListSize - 1 - 20, 0)
	FauxScrollFrame_SetOffset(RecapRecentIncomingScrollBar, sbOffset)
	RecapRecentIncomingScrollBar_Update()
	RecapRecentIncomingScrollBarScrollBar:SetValue(sbOffset*14)

	RecapRecent_ConstructRecentOutgoing(nil, nil, nil, filterDispels)
	-- force initial scroll to bottom of list (showing most recent events)
	sbOffset = math_max(recap_temp.RecentOutgoingListSize - 1 - 20, 0)
	FauxScrollFrame_SetOffset(RecapRecentOutgoingScrollBar, sbOffset)
	RecapRecentOutgoingScrollBar_Update()
	RecapRecentOutgoingScrollBarScrollBar:SetValue(sbOffset*14)
end

function RecapRecent_PopulateByEffect(outgoing, filterCombatant, filterEffect)

	local filterType, iCombatant
	local sbOffset

	-- normal title bar contents
	if filterCombatant==recap_temp.Localize.Group.." "..RECAP_COMBATANTS then
		-- all group
		filterType = "Group"
		RecapRecentFaction:SetTexture("")
		RecapRecentLevel:SetText(" ")
		RecapRecentClass:SetTexCoord(.9,1,.9,1)
		RecapRecentName:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
	elseif filterCombatant==recap_temp.Localize.NonGroup.." "..RECAP_COMBATANTS then
		-- all non-group
		filterType = "NonGroup"
		RecapRecentFaction:SetTexture("")
		RecapRecentLevel:SetText(" ")
		RecapRecentClass:SetTexCoord(.9,1,.9,1)
		RecapRecentName:SetTextColor(recap_temp.ColorWhite.r,recap_temp.ColorWhite.g,recap_temp.ColorWhite.b)
	else
		filterType = nil
		local iCombatant = recap.Combatant[filterCombatant]
		if iCombatant.Faction and recap_temp.FactionIcons[iCombatant.Faction] then
			RecapRecentFaction:SetTexture(recap_temp.FactionIcons[iCombatant.Faction])
		else
			RecapRecentFaction:SetTexture("")
		end
		if iCombatant.Level and tonumber(iCombatant.Level)>0 then
			RecapRecentLevel:SetText(iCombatant.Level)
		elseif iCombatant.Level and tonumber(iCombatant.Level)==-1 then
			RecapRecentLevel:SetText("??")
		else
			RecapRecentLevel:SetText(" ")
		end
		if iCombatant.Class and recap_temp.ClassIcons[iCombatant.Class] then
			RecapRecentClass:SetTexCoord(recap_temp.ClassIcons[iCombatant.Class].left,recap_temp.ClassIcons[iCombatant.Class].right,recap_temp.ClassIcons[iCombatant.Class].top,recap_temp.ClassIcons[iCombatant.Class].bottom)
		else
			RecapRecentClass:SetTexCoord(.9,1,.9,1)
		end
		if iCombatant.Friend then
			RecapRecentName:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
		else
			RecapRecentName:SetTextColor(1,1,1)
		end
	end
	RecapRecentName:SetText(Recap_StripGUIDsFromCombatant(filterCombatant))
	RecapRecentIncomingLabel:SetText(RECAP_RECENT_INCOMING_EFFECTS..": "..(filterEffect or ""))
	RecapRecentOutgoingLabel:SetText(RECAP_RECENT_OUTGOING_EFFECTS..": "..(filterEffect or ""))

	if outgoing then
		recap.Opt.RecentView.value = 2
	else
		recap.Opt.RecentView.value = 1
	end

	-- not ByIndex, so make sure that's off
	recap_temp.RecentIndex = 0

	RecapRecent_ConstructRecentIncoming(filterCombatant, filterEffect, filterType, nil)
	-- force initial scroll to bottom of list (showing most recent events)
	sbOffset = math_max(recap_temp.RecentIncomingListSize - 1 - 20, 0)
	FauxScrollFrame_SetOffset(RecapRecentIncomingScrollBar, sbOffset)
	RecapRecentIncomingScrollBar_Update()
	RecapRecentIncomingScrollBarScrollBar:SetValue(sbOffset*14)

	RecapRecent_ConstructRecentOutgoing(filterCombatant, filterEffect, filterType, nil)
	-- force initial scroll to bottom of list (showing most recent events)
	sbOffset = math_max(recap_temp.RecentOutgoingListSize - 1 - 20, 0)
	FauxScrollFrame_SetOffset(RecapRecentOutgoingScrollBar, sbOffset)
	RecapRecentOutgoingScrollBar_Update()
	RecapRecentOutgoingScrollBarScrollBar:SetValue(sbOffset*14)

	RecapRecent_SwitchRecents()
end

function RecapRecent_PopulateByIndex()

	local sbOffset

	-- title bar contents
	RecapRecentFaction:SetTexture("")
	RecapRecentLevel:SetText("")
	RecapRecentClass:SetTexCoord(.9,1,.9,1)
	RecapRecentName:SetTextColor(1.0, 0.82, 0.0) -- had to synthesize this, couldn't figure out how to get the 'default' colour
	RecapRecentName:SetText(recap_temp.Localize.TimeWindow..": "..Recap_FormatTimeRecent(recap_temp.Recent[recap_temp.RecentIndex].T))

	recap_temp.RecentIncomingSelected = 0
	recap_temp.RecentOutgoingSelected = 0
	RecapRecentIncomingLabel:SetText(RECAP_RECENT_INCOMING_EVENTS)
	RecapRecentOutgoingLabel:SetText(RECAP_RECENT_OUTGOING_EVENTS)

	sbOffset = RecapRecent_ConstructRecentIncomingByIndex()
	-- put indexed event near the centre of the window
	sbOffset = math_max(sbOffset - 9, 0)
	FauxScrollFrame_SetOffset(RecapRecentIncomingScrollBar, sbOffset)
	RecapRecentIncomingScrollBar_Update()
	RecapRecentIncomingScrollBarScrollBar:SetValue(sbOffset*14)

	sbOffset = RecapRecent_ConstructRecentOutgoingByIndex()
	-- put indexed event near the centre of the window
	sbOffset = math_max(sbOffset - 9, 0)
	FauxScrollFrame_SetOffset(RecapRecentOutgoingScrollBar, sbOffset)
	RecapRecentOutgoingScrollBar_Update()
	RecapRecentOutgoingScrollBarScrollBar:SetValue(sbOffset*14)
end

function RecapRecent_Hide(clear)

	if clear then
		recap_temp.RecentIncomingSelected = 0
		recap_temp.RecentOutgoingSelected = 0
		if RecapPanel:IsVisible() then
			-- other popup is visible, so simply hide
			RecapRecent:Hide()
		else
			recap_temp.Selected = 0
			recap_temp.RecentSelected = 0
			if not recap.Opt.Minimized.value then
				RecapScrollBar_Update()
			end
		end
	end

	if recap_temp.Selected==0 then
		RecapRecent:Hide()
	end
end

function RecapRecentTab_OnEnter()

	-- lock OnEnter-OnLeave events
	if recap_temp.OnEnterOnLeave == true then return end
	recap_temp.OnEnterOnLeave = true

	local id = this:GetID()

	if id and id>0 then
		Recap_Tooltip("RecentTab"..id)
	end

	-- unlock OnEnter-OnLeave events
	recap_temp.OnEnterOnLeave = false
end

function RecapRecentTab_OnClick(frame, button, down)

	local id = this:GetID()
	recap.Opt.RecentView.value = id
	RecapRecent_SwitchRecents()
end

function RecapRecent_SwitchRecents()

	local i
	local _G = getfenv(0)

	for i=1,2 do
		_G["RecapRecentTab"..i]:UnlockHighlight()
		_G["RecapSubRecent"..i]:Hide()
	end
	_G["RecapRecentTab"..recap.Opt.RecentView.value]:LockHighlight()
	_G["RecapSubRecent"..recap.Opt.RecentView.value]:Show()
end

function RecapRecent_ConstructRecentIncoming(filterCombatant, filterEffect, filterType, filterDispels)

	-- clear the list
	recap_temp.RecentIncomingListSize = 1
	recap_temp.RecentIncomingList = {} -- breaks table.sort if we try to re-use the table by setting individual values to nil

	local i, last, sentEOF, index, iList, message

	-- list forwards from the first, no need to limit
	if recap_temp.Recent then
		i = recap_temp.Recent.First
		last = recap_temp.Recent.Last
		if (i == last) and not (recap_temp.Recent[i] and recap_temp.Recent[i].T) then
			-- no data at all
		else
			-- data exists, list the rows (there may be none due to filtering)
			sentEOF = true -- set to skip any initial 'end of fight' markers
			for index=1, recap.Opt.RecentEventCount.value do
				if not recap_temp.RecentIncomingList[recap_temp.RecentIncomingListSize] then
					recap_temp.RecentIncomingList[recap_temp.RecentIncomingListSize] = {}
				end
				iList = recap_temp.RecentIncomingList[recap_temp.RecentIncomingListSize]
				if recap_temp.Recent[i].S == "**EOF**" then
					-- maybe post an 'end of fight' marker
					if sentEOF == true then
						-- avoid sending two in a row, and avoid leading 'end of fight' indicators
					else
						-- special 'end of fight' line
						message = "00:00:00.0 --------------------------------------------------"
						iList.Event = message
						iList.Index = i		-- hidden field storing the index of the event in the Recent buffer
						recap_temp.RecentIncomingListSize = recap_temp.RecentIncomingListSize + 1
						sentEOF = true
					end
				else
					-- not an 'end of fight'
					if filterDispels then
						-- if posting dispels, then type 6 events only
						if string_sub(recap_temp.Recent[i].E,1,1) == "6" then
							message = Recap_FormatRecentEvent(i, false, filterCombatant, filterEffect, filterType)
							-- if filterCombatant or filterEffect fails, the message gets returned as nil
							if message then
								iList.Event = message
								iList.Index = i		-- hidden field storing the index of the event in the Recent buffer
								recap_temp.RecentIncomingListSize = recap_temp.RecentIncomingListSize + 1
								sentEOF = false
							end
						end
					else
						-- all events, including dispels
						message = Recap_FormatRecentEvent(i, false, filterCombatant, filterEffect, filterType)
						-- if filterCombatant or filterEffect fails, the message gets returned as nil
						if message then
							iList.Event = message
							iList.Index = i		-- hidden field storing the index of the event in the Recent buffer
							recap_temp.RecentIncomingListSize = recap_temp.RecentIncomingListSize + 1
							sentEOF = false
						end
					end
				end
				if (i == last) then
					-- just posted the most recent one, leave the loop
					break
				end
				-- increment circular pointer
				if i >= recap.Opt.RecentEventCount.value then
					i = 1
				else
					i = i + 1
				end
			end
		end
	end
	recap_temp.RecentIncomingList[recap_temp.RecentIncomingListSize] = nil -- keep as nil
end

function RecapRecent_ConstructRecentOutgoing(filterCombatant, filterEffect, filterType, filterDispels)

	-- clear the details
	recap_temp.RecentOutgoingListSize = 1
	recap_temp.RecentOutgoingList = {} -- breaks table.sort if we try to re-use the table by setting individual values to nil

	local i, last, sentEOF, index, iList, message

	-- list forwards from the first, no need to limit
	if recap_temp.Recent then
		i = recap_temp.Recent.First
		last = recap_temp.Recent.Last
		if (i == last) and not (recap_temp.Recent[i] and recap_temp.Recent[i].T) then
			-- no data at all
		else
			-- data exists, list the rows (there may be none due to filtering)
			sentEOF = true -- set to skip any initial 'end of fight' markers
			for index=1, recap.Opt.RecentEventCount.value do
				if not recap_temp.RecentOutgoingList[recap_temp.RecentOutgoingListSize] then
					recap_temp.RecentOutgoingList[recap_temp.RecentOutgoingListSize] = {}
				end
				iList = recap_temp.RecentOutgoingList[recap_temp.RecentOutgoingListSize]
				if recap_temp.Recent[i].S == "**EOF**" then
					-- maybe post an 'end of fight' marker
					if sentEOF == true then
						-- avoid sending two in a row, and avoid leading 'end of fight' indicators
					else
						-- special 'end of fight' line
						message = "00:00:00.0 --------------------------------------------------"
						iList.Event = message
						iList.Index = i		-- hidden field storing the index of the event in the Recent buffer
						recap_temp.RecentOutgoingListSize = recap_temp.RecentOutgoingListSize + 1
						sentEOF = true
					end
				else
					-- not an 'end of fight'
					if filterDispels then
						-- if posting dispels, then type 6 events only
						if string_sub(recap_temp.Recent[i].E,1,1) == "6" then
							message = Recap_FormatRecentEvent(i, true, filterCombatant, filterEffect, filterType)
							-- if filterCombatant or filterEffect fails, the message gets returned as nil
							if message then
								iList.Event = message
								iList.Index = i		-- hidden field storing the index of the event in the Recent buffer
								recap_temp.RecentOutgoingListSize = recap_temp.RecentOutgoingListSize + 1
								sentEOF = false
							end
						end
					else
						-- all events, including dispels
						message = Recap_FormatRecentEvent(i, true, filterCombatant, filterEffect, filterType)
						-- if filterCombatant or filterEffect fails, the message gets returned as nil
						if message then
							iList.Event = message
							iList.Index = i		-- hidden field storing the index of the event in the Recent buffer
							recap_temp.RecentOutgoingListSize = recap_temp.RecentOutgoingListSize + 1
							sentEOF = false
						end
					end
				end
				if (i == last) then
					-- just posted the most recent one, leave the loop
					break
				end
				-- increment circular pointer
				if i >= recap.Opt.RecentEventCount.value then
					i = 1
				else
					i = i + 1
				end
			end
		end
	end
	recap_temp.RecentOutgoingList[recap_temp.RecentOutgoingListSize] = nil -- keep as nil
end

function RecapRecent_ConstructRecentIncomingByIndex()

	-- clear the list
	recap_temp.RecentIncomingListSize = 1
	recap_temp.RecentIncomingList = {} -- breaks table.sort if we try to re-use the table by setting individual values to nil

	local i, first, last, sentEOF, index, offset, iList, message

	if recap_temp.Recent then

		first = recap_temp.Recent.First
		last = recap_temp.Recent.Last
		i = recap_temp.RecentIndex

		-- figure out a starting position up to 50 events earlier than RecentIndex, then go forward up to 50 events later than RecentIndex
		for index=1, 50 do
			offset = index
			if (i == first) then
				-- found the earliest event, leave the loop
				break
			end
			-- increment circular pointer
			if i <= 1 then
				i = recap.Opt.RecentEventCount.value
			else
				i = i - 1
			end
		end

		if (i == last) and not (recap_temp.Recent[i] and recap_temp.Recent[i].T) then
			-- no data at all
		else
			-- data exists, list the rows (there may be none due to filtering)
			sentEOF = true -- set to skip any initial 'end of fight' markers
			for index=1, 101 do
				if not recap_temp.RecentIncomingList[recap_temp.RecentIncomingListSize] then
					recap_temp.RecentIncomingList[recap_temp.RecentIncomingListSize] = {}
				end
				iList = recap_temp.RecentIncomingList[recap_temp.RecentIncomingListSize]
				if recap_temp.Recent[i].S == "**EOF**" then
					-- maybe post an 'end of fight' marker
					if sentEOF == true then
						-- avoid sending two in a row, and avoid leading 'end of fight' indicators
					else
						-- special 'end of fight' line
						message = "00:00:00.0 --------------------------------------------------"
						iList.Event = message
						iList.Index = i		-- hidden field storing the index of the event in the Recent buffer
						recap_temp.RecentIncomingListSize = recap_temp.RecentIncomingListSize + 1
						sentEOF = true
					end
				else
					-- not an 'end of fight'
					message = Recap_FormatRecentEvent(i, false, nil, nil, nil)
					if message then
						iList.Event = message
						iList.Index = i		-- hidden field storing the index of the event in the Recent buffer
						recap_temp.RecentIncomingListSize = recap_temp.RecentIncomingListSize + 1
						sentEOF = false
					end
				end
				if (i == last) then
					-- just posted the most recent one, leave the loop
					break
				end
				-- increment circular pointer
				if i >= recap.Opt.RecentEventCount.value then
					i = 1
				else
					i = i + 1
				end
			end
		end
	end
	recap_temp.RecentIncomingList[recap_temp.RecentIncomingListSize] = nil -- keep as nil

	return offset
end

function RecapRecent_ConstructRecentOutgoingByIndex()

	-- clear the list
	recap_temp.RecentOutgoingListSize = 1
	recap_temp.RecentOutgoingList = {} -- breaks table.sort if we try to re-use the table by setting individual values to nil

	local i, first, last, sentEOF, index, offset, iList, message

	if recap_temp.Recent then

		first = recap_temp.Recent.First
		last = recap_temp.Recent.Last
		i = recap_temp.RecentIndex

		-- figure out a starting position up to 50 events earlier than RecentIndex, then go forward up to 50 events later than RecentIndex
		for index=1, 50 do
			offset = index
			if (i == first) then
				-- found the earliest event, leave the loop
				break
			end
			-- increment circular pointer
			if i <= 1 then
				i = recap.Opt.RecentEventCount.value
			else
				i = i - 1
			end
		end

		if (i == last) and not (recap_temp.Recent[i] and recap_temp.Recent[i].T) then
			-- no data at all
		else
			-- data exists, list the rows (there may be none due to filtering)
			sentEOF = true -- set to skip any initial 'end of fight' markers
			for index=1, 101 do
				if not recap_temp.RecentOutgoingList[recap_temp.RecentOutgoingListSize] then
					recap_temp.RecentOutgoingList[recap_temp.RecentOutgoingListSize] = {}
				end
				iList = recap_temp.RecentOutgoingList[recap_temp.RecentOutgoingListSize]
				if recap_temp.Recent[i].S == "**EOF**" then
					-- maybe post an 'end of fight' marker
					if sentEOF == true then
						-- avoid sending two in a row, and avoid leading 'end of fight' indicators
					else
						-- special 'end of fight' line
						message = "00:00:00.0 --------------------------------------------------"
						iList.Event = message
						iList.Index = i		-- hidden field storing the index of the event in the Recent buffer
						recap_temp.RecentOutgoingListSize = recap_temp.RecentOutgoingListSize + 1
						sentEOF = true
					end
				else
					-- not an 'end of fight'
					message = Recap_FormatRecentEvent(i, true, nil, nil, nil)
					if message then
						iList.Event = message
						iList.Index = i		-- hidden field storing the index of the event in the Recent buffer
						recap_temp.RecentOutgoingListSize = recap_temp.RecentOutgoingListSize + 1
						sentEOF = false
					end
				end
				if (i == last) then
					-- just posted the most recent one, leave the loop
					break
				end
				-- increment circular pointer
				if i >= recap.Opt.RecentEventCount.value then
					i = 1
				else
					i = i + 1
				end
			end
		end
	end
	recap_temp.RecentOutgoingList[recap_temp.RecentOutgoingListSize] = nil -- keep as nil

	return offset
end

function RecapRecentIncomingScrollBar_Update()

	local i, index, iList, item
	local _G = getfenv(0)

	if recap_temp.Loaded and recap_temp.RecentIncomingListSize then

		FauxScrollFrame_Update(RecapRecentIncomingScrollBar,recap_temp.RecentIncomingListSize-1,20,14)

		for i=1,20 do
			index = i + FauxScrollFrame_GetOffset(RecapRecentIncomingScrollBar)
			if index < recap_temp.RecentIncomingListSize then
				iList = recap_temp.RecentIncomingList[index]
				_G["RecapRecentIncoming"..i.."_Event"]:SetText(iList.Event)
				_G["RecapRecentIncoming"..i.."_Event"]:SetTextColor(RecapRecent_DetermineColour(iList.Event, false))
				_G["RecapRecentIncoming"..i.."_Index"]:SetText(iList.Index)
				if iList.Index == recap_temp.RecentIndex then
					-- special text prefix for the RecentIndex item, and select the row
					_G["RecapRecentIncoming"..i.."_Event"]:SetText(">>>>>   "..iList.Event)
					recap_temp.RecentIncomingSelected = index
				end
				item = _G["RecapRecentIncoming"..i]
				item:Show()
				if recap_temp.RecentIncomingSelected == index then
					item:LockHighlight()
				else
					item:UnlockHighlight()
				end
			else
				item = _G["RecapRecentIncoming"..i]
				item:Hide()
				item:UnlockHighlight()
			end
		end
	end

end

function RecapRecentOutgoingScrollBar_Update()

	local i, index, iList, item
	local _G = getfenv(0)

	if recap_temp.Loaded and recap_temp.RecentOutgoingListSize then

		FauxScrollFrame_Update(RecapRecentOutgoingScrollBar,recap_temp.RecentOutgoingListSize-1,20,14)

		for i=1,20 do
			index = i + FauxScrollFrame_GetOffset(RecapRecentOutgoingScrollBar)
			if index < recap_temp.RecentOutgoingListSize then
				iList = recap_temp.RecentOutgoingList[index]
				_G["RecapRecentOutgoing"..i.."_Event"]:SetText(iList.Event)
				_G["RecapRecentOutgoing"..i.."_Event"]:SetTextColor(RecapRecent_DetermineColour(iList.Event, true))
				_G["RecapRecentOutgoing"..i.."_Index"]:SetText(iList.Index)
				if iList.Index == recap_temp.RecentIndex then
					-- special text prefix for the RecentIndex item, and select the row
					_G["RecapRecentOutgoing"..i.."_Event"]:SetText(">>>>>   "..iList.Event)
					recap_temp.RecentOutgoingSelected = index
				end
				item = _G["RecapRecentOutgoing"..i]
				item:Show()
				if recap_temp.RecentOutgoingSelected == index then
					item:LockHighlight()
				else
					item:UnlockHighlight()
				end
			else
				item = _G["RecapRecentOutgoing"..i]
				item:Hide()
				item:UnlockHighlight()
			end
		end
	end

end

-- clicks on individual effect lines
function RecapRecent_Incoming_OnClick(frame, button, down)

	local id = this:GetID()
	local index = id + FauxScrollFrame_GetOffset(RecapRecentIncomingScrollBar)
	local _G = getfenv(0)

	if (index < recap_temp.RecentIncomingListSize) then

		-- detect double-click
		local isDoubleClick = false
		local thisRecentIndex = _G["RecapRecentIncoming"..id.."_Index"]:GetText()
		local thisClickTime = GetTime()
		if thisRecentIndex == recap_temp.IncomingPriorRecentIndex then
			-- another click on the same index
			if (thisClickTime - recap_temp.IncomingPriorClickTime) < 0.3 then
				-- two clicks on the same index within less than 0.3 seconds, call it a double-click
				isDoubleClick = true
			end
		end
		recap_temp.IncomingPriorRecentIndex = thisRecentIndex
		recap_temp.IncomingPriorClickTime = thisClickTime

		if IsShiftKeyDown() and not isDoubleClick then
			Recap_InsertChat("Recap: ".._G["RecapRecentIncoming"..id.."_Event"]:GetText(), nil, RecapRecent_EscapeColour(_G["RecapRecentIncoming"..id.."_Event"]))

		elseif not IsShiftKeyDown() and isDoubleClick then
			-- bring up a Recent events box centred on the event and holding a number of events in each direction
			-- get the index into the Recent buffer for use by the scrollbar code
			recap_temp.RecentIndex = tonumber(thisRecentIndex)
			RecapRecent_PopulateByIndex()

		elseif (recap_temp.RecentIncomingSelected == index) then
			recap_temp.RecentIncomingSelected = 0
			RecapRecentIncomingScrollBar_Update()

		else
			recap_temp.RecentIncomingSelected = index
			RecapRecentIncomingScrollBar_Update()
		end
	end
end

-- clicks on individual effect lines
function RecapRecent_Outgoing_OnClick(frame, button, down)

	local id = this:GetID()
	local index = id + FauxScrollFrame_GetOffset(RecapRecentOutgoingScrollBar)
	local _G = getfenv(0)

	if (index < recap_temp.RecentOutgoingListSize) then

		-- detect double-click
		local isDoubleClick = false
		local thisRecentIndex = _G["RecapRecentOutgoing"..id.."_Index"]:GetText()
		local thisClickTime = GetTime()
		if thisRecentIndex == recap_temp.OutgoingPriorRecentIndex then
			-- another click on the same index
			if (thisClickTime - recap_temp.OutgoingPriorClickTime) < 0.3 then
				-- two clicks on the same index within less than 0.3 seconds, call it a double-click
				isDoubleClick = true
			end
		end
		recap_temp.OutgoingPriorRecentIndex = thisRecentIndex
		recap_temp.OutgoingPriorClickTime = thisClickTime

		if IsShiftKeyDown() and not isDoubleClick then
			Recap_InsertChat("Recap: ".._G["RecapRecentOutgoing"..id.."_Event"]:GetText(), nil, RecapRecent_EscapeColour(_G["RecapRecentOutgoing"..id.."_Event"]))

		elseif not IsShiftKeyDown() and isDoubleClick then
			-- bring up a Recent events box centred on the event and holding a number of events in each direction
			-- get the index into the Recent buffer for use by the scrollbar code
			recap_temp.RecentIndex = tonumber(thisRecentIndex)
			RecapRecent_PopulateByIndex()

		elseif (recap_temp.RecentOutgoingSelected==index) then
			recap_temp.RecentOutgoingSelected = 0
			RecapRecentOutgoingScrollBar_Update()

		else
			recap_temp.RecentOutgoingSelected = index
			RecapRecentOutgoingScrollBar_Update()
		end
	end
end

function RecapRecent_OnMouseDown(frame, button)

	if recap_temp.Loaded and (button == "LeftButton") then
		RecapRecent:StartMoving()
	end
end

function RecapRecent_OnMouseUp(frame, button)

	if recap_temp.Loaded and (button == "LeftButton") then
		RecapRecent:StopMovingOrSizing()

		-- check for docking
		recap.Opt.RecentAnchor.value = false

		if Recap_Near(RecapFrame:GetRight(),RecapRecent:GetLeft()) then
			if Recap_Near(RecapFrame:GetTop(),RecapRecent:GetTop()) then
				recap.Opt.RecentAnchor = { type="Flag", value=true, Main="TOPRIGHT", Recent="TOPLEFT" }
			elseif Recap_Near(RecapFrame:GetBottom(),RecapRecent:GetBottom()) then
				recap.Opt.RecentAnchor = { type="Flag", value=true, Main="BOTTOMRIGHT", Recent="BOTTOMLEFT"}
			end
		elseif Recap_Near(RecapFrame:GetLeft(),RecapRecent:GetRight()) then
			if Recap_Near(RecapFrame:GetTop(),RecapRecent:GetTop()) then
				recap.Opt.RecentAnchor = { type="Flag", value=true, Main="TOPLEFT", Recent="TOPRIGHT" }
			elseif Recap_Near(RecapFrame:GetBottom(),RecapRecent:GetBottom()) then
				recap.Opt.RecentAnchor = { type="Flag", value=true, Main="BOTTOMLEFT", Recent="BOTTOMRIGHT" }
			end
		elseif Recap_Near(RecapFrame:GetRight(),RecapRecent:GetRight()) then
			if Recap_Near(RecapFrame:GetTop(),RecapRecent:GetBottom()) then
				recap.Opt.RecentAnchor = { type="Flag", value=true, Main="TOPRIGHT", Recent="BOTTOMRIGHT" }
			elseif Recap_Near(RecapFrame:GetBottom(),RecapRecent:GetTop()) then
				recap.Opt.RecentAnchor = { type="Flag", value=true, Main="BOTTOMRIGHT", Recent="TOPRIGHT" }
			end
		elseif Recap_Near(RecapFrame:GetLeft(),RecapRecent:GetLeft()) then
			if Recap_Near(RecapFrame:GetTop(),RecapRecent:GetBottom()) then
				recap.Opt.RecentAnchor = { type="Flag", value=true, Main="TOPLEFT", Recent="BOTTOMLEFT" }
			elseif Recap_Near(RecapFrame:GetBottom(),RecapRecent:GetTop()) then
				recap.Opt.RecentAnchor = { type="Flag", value=true, Main="BOTTOMLEFT", Recent="TOPLEFT" }
			end
		end

		if recap.Opt.RecentAnchor.value then
			RecapRecent:ClearAllPoints()
			RecapRecent:SetPoint(recap.Opt.RecentAnchor.Recent,"RecapFrame",recap.Opt.RecentAnchor.Main,Recap_RecentOffset("x"),Recap_RecentOffset("y"))
		end

	end
end

function Recap_RecentOffset(axis)

	local anchor

	anchor = recap.Opt.RecentAnchor.Main..recap.Opt.RecentAnchor.Recent
	if dockoffset[anchor] and axis then
		return dockoffset[anchor][axis]
	else
		return 0
	end
end

-- click on header on detail panel, dump that header info for all combatants
function RecapRecentIncomingHeader_OnClick(frame, button, down)

	if IsShiftKeyDown() and (recap_temp.RecentIncomingListSize>1) then
		RecapRecent_PostEvents("RecentIncomingEvents", recap_temp.RecentIncomingList, recap_temp.RecentIncomingListSize-1, false)
	end
end

-- click on header on detail panel, dump that header info for all effects
function RecapRecentOutgoingHeader_OnClick(frame, button, down)

	if IsShiftKeyDown() and (recap_temp.RecentOutgoingListSize>1) then
		RecapRecent_PostEvents("RecentOutgoingEvents", recap_temp.RecentOutgoingList, recap_temp.RecentOutgoingListSize-1, true)
	end
end

function RecapRecent_PostEvents(tooltipText, eventList, listLength, outgoing)

	local i, lineno, iList, limit, omit, start
	local text, alltext = "",""
	local print_chat = SendChatMessage
	local chatchan, chatnum
	local escapeColour, r, g, b
	local maxLines = recap.Opt.MaxRank.value

	chatchan, chatnum = Recap_GetChannelInfo(nil, nil)
	-- block posting to channels that would be excessively annoying to others
	--   (also blocks other channels that happen to have BlockChannels as substrings -- tough)
	if chatchan then
		for i=1,#recap_temp.Localize.BlockChannels do
			if string_find(string_lower(chatchan), recap_temp.Localize.BlockChannels[i], 1, true) then
				PlaySound("igQuestFailed")
				return
			end
		end
	end
	if chatchan=="Self" then
		print_chat = Recap_Print
	end

	-- if the focus is on a WIM (WoW Instant Messenger) edit box, post there
	if WIM_EditBoxInFocus then
		print_chat = Recap_WIM_Print
	end

	-- If the Clip box on the Options : Reports panel is open, post there instead of to chat or console
	-- Writing to the Clipboard seems to be slow, and it has a maximum size of 32000 letters
	-- It takes about 10 seconds to post 400 lines (on my older slow iMac)
	if RecapClipEditBox:IsVisible() then
		print_chat = Recap_LineToClipboard
		maxLines = recap_temp.MaxRecentEventLinesClipboard
	end

	-- calculate the number of lines to post (taking into account the maximum allowed)
	limit = math_min(listLength, maxLines)
	omit = listLength - limit
	start = 1 + omit

	-- start generating output
	alltext = "__ Recap ("..Recap_PetsMergedText().."): "..Recap_GetTooltip(tooltipText).." __"
	lineno = 0
	print_chat(alltext, chatchan, nil, chatnum)
	for i=start,listLength do
		iList = eventList[i]
		text = iList.Event
		lineno = lineno + 1
		if chatchan=="Self" then
			-- colour to our own console
			r,g,b = RecapRecent_DetermineColour(iList.Event, outgoing)
			escapeColour = string_format("|cff%02x%02x%02x", Recap_Round0(255*r), Recap_Round0(255*g), Recap_Round0(255*b))
			text = escapeColour..text
		end
		print_chat(text, chatchan, nil, chatnum)
	end
end

-- scrape the colour from the text and convert to a chat escape sequence
function RecapRecent_EscapeColour(fld)
	local r, g, b, a
	r,g,b,a = fld:GetTextColor()
	return string_format("|c%02x%02x%02x%02x", Recap_Round0(255*a), Recap_Round0(255*r), Recap_Round0(255*g), Recap_Round0(255*b))
end

function RecapRecent_DetermineColour(text, outgoing)

	local r, g, b

	if string_find(text, "%(% %-%d") then
		-- damage
		if string_find(text, "%*") then
			-- crit or crush
			if outgoing then
				r,g,b = recap_temp.ColorDmgOut.r, recap_temp.ColorDmgOut.g, recap_temp.ColorDmgOut.b
			else
				r,g,b = recap_temp.ColorDmgIn.r, recap_temp.ColorDmgIn.g, recap_temp.ColorDmgIn.b
			end
		else
			if outgoing then
				r,g,b = recap_temp.ColorDmgOutPale.r, recap_temp.ColorDmgOutPale.g, recap_temp.ColorDmgOutPale.b
			else
				r,g,b = recap_temp.ColorDmgInPale.r, recap_temp.ColorDmgInPale.g, recap_temp.ColorDmgInPale.b
			end
		end
	elseif string_find(text, "%(% %+%d") then
		-- heal
		if string_find(text, "%*") then
			-- crit
			r,g,b = recap_temp.ColorHeal.r, recap_temp.ColorHeal.g, recap_temp.ColorHeal.b
		else
			r,g,b = recap_temp.ColorHealPale.r, recap_temp.ColorHealPale.g, recap_temp.ColorHealPale.b
		end
	else
		-- miss or cast or death
		r,g,b = recap_temp.ColorWhite.r, recap_temp.ColorWhite.g, recap_temp.ColorWhite.b
	end
	return r, g, b
end

RecapRecent_lua_411 = true
