﻿--[[ RecapPanel.lua ]]

local _G = getfenv(0)
local math_max = _G.math.max
local math_min = _G.math.min
local string_find = _G.string.find
local string_format = _G.string.format
local string_len = _G.string.len
local string_lower = _G.string.lower
local string_sub = _G.string.sub
local table_sort = _G.table.sort

--[[ local tables ]]

local dockoffset = { ["TOPRIGHTTOPLEFT"] = { x=-4,y=0 },
					 ["BOTTOMRIGHTBOTTOMLEFT"] = { x=-4,y=0 },
					 ["TOPLEFTTOPRIGHT"] = { x=4,y=0 },
					 ["BOTTOMLEFTBOTTOMRIGHT"] = { x=4,y=0 },
					 ["TOPRIGHTBOTTOMRIGHT"] = { x=0,y=-4 },
					 ["BOTTOMRIGHTTOPRIGHT"] = { x=0,y=4 },
					 ["TOPLEFTBOTTOMLEFT"] = { x=0,y=-4 },
					 ["BOTTOMLEFTTOPLEFT"] = { x=0,y=4 } }


--[[ Functions for the popup panel ]]

function RecapPanel_Populate(thisCombatant)
	-- recap.Opt.IncomingPanelDetail.value and recap.Opt.OutgoingPanelDetail.value contain the do-not-translate titles
	--   We need to convert them when creating header lines

	local i, totalmiss, text, found, iCombatant

	iCombatant = recap.Combatant[thisCombatant]
	if iCombatant and not recap.Opt.LightData.value then

		local AllLastOutgoingDetail = "OutgoingDetail"
		local AllLastIncomingDetail = "IncomingDetail"
		local AllLastOtherDetail = "OtherDetail"
		local AllLastTargetDetail = "TargetDetail"
		local AllLastSourceDetail = "SourceDetail"
		if recap.Opt.View.value=="Last" then
			-- from the display set of Last Fight details
			AllLastOutgoingDetail = "LastOutgoingDetail_"..recap_temp.DisplayLastFight
			AllLastIncomingDetail = "LastIncomingDetail_"..recap_temp.DisplayLastFight
			AllLastOtherDetail = "LastOtherDetail_"..recap_temp.DisplayLastFight
			AllLastTargetDetail = "LastTargetDetail_"..recap_temp.DisplayLastFight
			AllLastSourceDetail = "LastSourceDetail_"..recap_temp.DisplayLastFight
		end

		--[[ Populate Panel 1: Incoming details ]]

		recap_temp.IncomingDetailSelected = 0
		RecapPanel_AmalgamateIncomingTotals(thisCombatant, AllLastIncomingDetail)
		RecapPanel_ConstructIncomingDetails(thisCombatant, AllLastIncomingDetail)
		if recap_temp.IncomingDetailsListSize>1 then
			RecapPanel_PopulateIncomingDetails(thisCombatant, 1)
		else
			RecapPanel_PopulateIncomingDetails(thisCombatant, 0)
		end
		RecapPanelIncomingTotalLabel:SetText(recap_temp.Localize.DetailTitle[recap.Opt.IncomingPanelDetail.value])
		RecapPanelIncomingDetailsScrollBar_Update()

		--[[ Populate Panel 2: Source details ]]

		recap_temp.SourceDetailSelected = 0
		RecapPanel_ConstructSourceDetails(thisCombatant, AllLastSourceDetail)
		RecapPanelSourceTotalLabel:SetText(RECAP_TOTAL)
		RecapPanelSourceDetailsScrollBar_Update()

		--[[ Populate Panel 3: Outgoing details ]]

		recap_temp.OutgoingDetailSelected = 0
		RecapPanel_AmalgamateOutgoingTotals(thisCombatant, AllLastOutgoingDetail)
		RecapPanel_ConstructOutgoingDetails(thisCombatant, AllLastOutgoingDetail)
		if recap_temp.OutgoingDetailsListSize>1 then
			RecapPanel_PopulateOutgoingDetails(thisCombatant, 1)
		else
			RecapPanel_PopulateOutgoingDetails(thisCombatant, 0)
		end
		RecapPanelOutgoingTotalLabel:SetText(recap_temp.Localize.DetailTitle[recap.Opt.OutgoingPanelDetail.value])
		RecapPanelOutgoingDetailsScrollBar_Update()

		--[[ Populate Panel 4: Target details ]]

		recap_temp.TargetDetailSelected = 0
		RecapPanel_ConstructTargetDetails(thisCombatant, AllLastTargetDetail)
		RecapPanelTargetTotalLabel:SetText(RECAP_TOTAL)
		RecapPanelTargetDetailsScrollBar_Update()

		--[[ Populate Panel 5: Other details (buffs, debuffs, procs, and so on) ]]

		recap_temp.OtherDetailSelected = 0
		RecapPanel_ConstructOtherDetails(thisCombatant, AllLastOtherDetail)
		if recap_temp.OtherDetailsListSize>1 then
			RecapPanel_PopulateOtherDetails(thisCombatant, 1)
		else
			RecapPanel_PopulateOtherDetails(thisCombatant, 0)
		end
		RecapPanelOtherDetailsScrollBar_Update()

	end

	-- populate elements that work in and out of light data mode
	-- do none of these, at the moment, for the hidden combatants "Group Total" and "Non-Group Total"

	if iCombatant then

		--[[ Populate common elements ]]

		if (thisCombatant == recap_temp.GroupTotal) then
			-- special title bar contents
			RecapPanelFaction:SetTexture("")
			RecapPanelLevel:SetText(" ")
			RecapPanelClass:SetTexCoord(.9,1,.9,1)
			RecapPanelTitle:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
			RecapPanelTitle:SetText(recap_temp.Localize.Group.." "..RECAP_COMBATANTS)
			RecapPanelName:SetText(recap_temp.Localize.Group.." "..RECAP_COMBATANTS)
			RecapPanelFullyQualifiedName:SetText(recap_temp.Localize.Group.." "..RECAP_COMBATANTS)
		elseif (thisCombatant == recap_temp.NonGroupTotal) then
			-- special title bar contents
			RecapPanelFaction:SetTexture("")
			RecapPanelLevel:SetText(" ")
			RecapPanelClass:SetTexCoord(.9,1,.9,1)
			RecapPanelTitle:SetTextColor(recap_temp.ColorWhite.r,recap_temp.ColorWhite.g,recap_temp.ColorWhite.b)
			RecapPanelTitle:SetText(recap_temp.Localize.NonGroup.." "..RECAP_COMBATANTS)
			RecapPanelName:SetText(recap_temp.Localize.NonGroup.." "..RECAP_COMBATANTS)
			RecapPanelFullyQualifiedName:SetText(recap_temp.Localize.NonGroup.." "..RECAP_COMBATANTS)
		else
			-- normal title bar contents
			if iCombatant.Faction and recap_temp.FactionIcons[iCombatant.Faction] then
				RecapPanelFaction:SetTexture(recap_temp.FactionIcons[iCombatant.Faction])
			else
				RecapPanelFaction:SetTexture("")
			end
			if iCombatant.Level and tonumber(iCombatant.Level)>0 then
				RecapPanelLevel:SetText(iCombatant.Level)
			elseif iCombatant.Level and tonumber(iCombatant.Level)==-1 then
				RecapPanelLevel:SetText("??")
			else
				RecapPanelLevel:SetText(" ")
			end
			if iCombatant.Class and recap_temp.ClassIcons[iCombatant.Class] then
				RecapPanelClass:SetTexCoord(recap_temp.ClassIcons[iCombatant.Class].left,recap_temp.ClassIcons[iCombatant.Class].right,recap_temp.ClassIcons[iCombatant.Class].top,recap_temp.ClassIcons[iCombatant.Class].bottom)
			else
				RecapPanelClass:SetTexCoord(.9,1,.9,1)
			end
			if iCombatant.Friend then
				RecapPanelTitle:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
			else
				RecapPanelTitle:SetTextColor(1,1,1)
			end
			RecapPanelTitle:SetText(recap_temp.LastAll[recap.Opt.View.value]..": "..Recap_StripGUIDsFromCombatant(thisCombatant))
			RecapPanelName:SetText(Recap_StripGUIDsFromCombatant(thisCombatant))
			RecapPanelFullyQualifiedName:SetText(thisCombatant)
		end

		--[[ Populate Panel 4: Summary ]]

		RecapPanelLastTimeText:SetText(Recap_FormatTime(iCombatant["LastTime_"..recap_temp.DisplayLastFight] or 0))
		RecapPanelLastTimeInText:SetText(Recap_FormatTime(iCombatant["LastTimeIn_"..recap_temp.DisplayLastFight] or 0))
		RecapPanelLastTimeHealText:SetText(Recap_FormatTime(iCombatant["LastTimeHeal_"..recap_temp.DisplayLastFight] or 0))
		RecapPanelLastMaxText:SetText(iCombatant["LastMaxHit_"..recap_temp.DisplayLastFight] or 0)
		RecapPanelLastDeathsText:SetText(iCombatant["LastKills_"..recap_temp.DisplayLastFight] or 0)
		RecapPanelLastHealsText:SetText((iCombatant["LastRawHeal_"..recap_temp.DisplayLastFight] or 0) - (iCombatant["LastOverHeal_"..recap_temp.DisplayLastFight] or 0))
		RecapPanelLastHPSText:SetFormattedText("%.1f", (iCombatant["LastHPS_"..recap_temp.DisplayLastFight] or 0))
		RecapPanelLastDmgInText:SetText(iCombatant["LastDmgIn_"..recap_temp.DisplayLastFight] or 0)
		RecapPanelLastDPSInText:SetFormattedText("%.1f", (iCombatant["LastDPSIn_"..recap_temp.DisplayLastFight] or 0))
		RecapPanelLastDmgOutText:SetText(iCombatant["LastDmgOut_"..recap_temp.DisplayLastFight] or 0)
		RecapPanelLastDPSText:SetFormattedText("%.1f", (iCombatant["LastDPS_"..recap_temp.DisplayLastFight] or 0))

		RecapPanelAllTimeText:SetText(Recap_FormatTime(iCombatant.TotalTime or 0))
		RecapPanelAllTimeInText:SetText(Recap_FormatTime(iCombatant.TotalTimeIn or 0))
		RecapPanelAllTimeHealText:SetText(Recap_FormatTime(iCombatant.TotalTimeHeal or 0))
		RecapPanelAllMaxText:SetText(iCombatant.TotalMaxHit or 0)
		RecapPanelAllDeathsText:SetText(iCombatant.TotalKills or 0)
		RecapPanelAllHealsText:SetText((iCombatant.TotalRawHeal or 0) - (iCombatant.TotalOverHeal or 0))
		RecapPanelAllHPSText:SetFormattedText("%.1f", (iCombatant.TotalHPS or 0))
		RecapPanelAllDmgInText:SetText(iCombatant.TotalDmgIn or 0)
		RecapPanelAllDPSInText:SetFormattedText("%.1f", (iCombatant.TotalDPSIn or 0))
		RecapPanelAllDmgOutText:SetText(iCombatant.TotalDmgOut or 0)
		RecapPanelAllDPSText:SetFormattedText("%.1f", (iCombatant.TotalDPS or 0))

		if iCombatant.Friend then
			RecapPanelLastTimeText:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
			RecapPanelAllTimeText:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
			RecapPanelLastTimeInText:SetTextColor(recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b)
			RecapPanelAllTimeInText:SetTextColor(recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b)
			RecapPanelLastTimeHealText:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
			RecapPanelAllTimeHealText:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
			RecapPanelLastHealsText:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
			RecapPanelAllHealsText:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
			RecapPanelLastHPSText:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
			RecapPanelAllHPSText:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
			RecapPanelLastDmgInText:SetTextColor(recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b)
			RecapPanelAllDmgInText:SetTextColor(recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b)
			RecapPanelLastDPSInText:SetTextColor(recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b)
			RecapPanelAllDPSInText:SetTextColor(recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b)
			RecapPanelLastDmgOutText:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
			RecapPanelAllDmgOutText:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
			RecapPanelLastDPSText:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
			RecapPanelAllDPSText:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
		else
			RecapPanelLastTimeText:SetTextColor(1,1,1)
			RecapPanelAllTimeText:SetTextColor(1,1,1)
			RecapPanelLastTimeInText:SetTextColor(1,1,1)
			RecapPanelAllTimeInText:SetTextColor(1,1,1)
			RecapPanelLastTimeHealText:SetTextColor(1,1,1)
			RecapPanelAllTimeHealText:SetTextColor(1,1,1)
			RecapPanelLastHealsText:SetTextColor(1,1,1)
			RecapPanelAllHealsText:SetTextColor(1,1,1)
			RecapPanelLastHPSText:SetTextColor(1,1,1)
			RecapPanelAllHPSText:SetTextColor(1,1,1)
			RecapPanelLastDmgInText:SetTextColor(1,1,1)
			RecapPanelAllDmgInText:SetTextColor(1,1,1)
			RecapPanelLastDPSInText:SetTextColor(1,1,1)
			RecapPanelAllDPSInText:SetTextColor(1,1,1)
			RecapPanelLastDmgOutText:SetTextColor(1,1,1)
			RecapPanelAllDmgOutText:SetTextColor(1,1,1)
			RecapPanelLastDPSText:SetTextColor(1,1,1)
			RecapPanelAllDPSText:SetTextColor(1,1,1)
		end
	end
end

-- tooltips for individual entries
function RecapPanel_Entry_OnEnter()

	-- lock OnEnter-OnLeave events
	if recap_temp.OnEnterOnLeave == true then return end
	recap_temp.OnEnterOnLeave = true

	local id = this:GetID()
	local _G = getfenv(0)

	if id and id>0 then
		if this:GetName()=="RecapPanelOutgoingMissP" and RecapPanelOutgoingMissPLabel:GetText()==RECAP_OVERHEALING then
			Recap_Tooltip("PanelEntryOverheal", _G[this:GetName().."Text"]:GetText())
		else
			Recap_Tooltip("PanelEntry"..id, _G[this:GetName().."Text"]:GetText())
		end
	end

	-- unlock OnEnter-OnLeave events
	recap_temp.OnEnterOnLeave = false
end

-- clicks on individual fields (the 'magic numbers' here are messy)
function RecapPanel_Entry_OnClick(frame, button, down)

	local id, header, text, combatantName
	local i, j, k
	local _G = getfenv(0)

	if recap_temp.Selected == 0 then
		return
	end

	if recap_temp.Selected == recap_temp.GroupIndex then
		combatantName = recap_temp.Localize.Group.." "..RECAP_COMBATANTS
	elseif recap_temp.Selected == recap_temp.NonGroupIndex then
		combatantName = recap_temp.Localize.NonGroup.." "..RECAP_COMBATANTS
	else
		combatantName = Recap_StripGUIDsFromCombatant(recap_temp.List[recap_temp.Selected].Name)
	end

	id = this:GetID()
	if id and id>0 and _G[this:GetName().."Text"]:GetText()~=" " and _G[this:GetName().."Text"]:GetText()~="--" and _G[this:GetName().."Text"]:GetText()~="?" then
		header = Recap_GetTooltip("PanelEntry"..id)
		if header and IsShiftKeyDown() then
			if (id>=70 and id<=79) then
				-- an Outgoing miss, post all miss entries
				local noData = true
				text = "Recap ("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value].."): "..combatantName..": "..RECAP_MISSES
				text = text.." "..recap_temp.Localize.For.." "..RecapPanelOutgoingEffectText:GetText()..":"
				for j in pairs(recap_temp.Localize.MissTypes) do
					k = _G["RecapPanelOutgoingMiss"..j.."Text"]:GetText()
					if (k ~= "--") and (k ~= "0 (0.0%)") then
						text = text.." "..recap_temp.Localize.MissTypes[j].." "..k
						noData = false
					end
				end
				if noData then
					text = text.." 0"
				end
			elseif (id>=55 and id<=64) then
				-- an Incoming miss, post all miss entries not just one
				local noData = true
				text = "Recap ("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value].."): "..combatantName..": "..RECAP_INCOMING.." "..RECAP_MISSES
				text = text.." "..recap_temp.Localize.For.." "..RecapPanelIncomingEffectText:GetText()..":"
				for j in pairs(recap_temp.Localize.MissTypes) do
					k = _G["RecapPanelIncomingMiss"..j.."Text"]:GetText()
					if (k ~= "--") and (k ~= "0 (0.0%)") then
						text = text.." "..recap_temp.Localize.MissTypes[j].." "..k
						noData = false
					end
				end
				if noData then
					text = text.." 0"
				end
			elseif ((id>=25 and id<=42) or (id>=80 and id<=83)) then
				text = "Recap ("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value].."): "..combatantName..": "..header
				text = text..": ".._G[this:GetName().."Text"]:GetText()
			else
				if ((this:GetName()=="RecapPanelOutgoingMissP" and RecapPanelOutgoingMissPLabel:GetText()==RECAP_OVERHEALING) or
					(this:GetName()=="RecapPanelIncomingMissP" and RecapPanelIncomingMissPLabel:GetText()==RECAP_OVERHEALING)) then
					header = RECAP_OVERHEALING
				end
				text = ""
				-- the magic numbers are for PanelEntry..id
				if ((id>=45 and id<=54) or (id>=65 and id<=67) or (id>=90 and id<=104) or (id>=106 and id<=133)) then
					-- I think the 'Outgoing' and 'Incoming' trigger off the xml names, so don't need localization
					if string_find(this:GetName(), "Outgoing", 1, true) and recap_temp.OutgoingDetailsListSize>1 then
						text = "Recap ("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value].."): "..combatantName..": "..RECAP_OUTGOING.." "..header
						text = text.." "..recap_temp.Localize.For.." "..RecapPanelOutgoingEffectText:GetText()
					elseif string_find(this:GetName(), "Incoming", 1, true) and recap_temp.IncomingDetailsListSize>1 then
						text = "Recap ("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value].."): "..combatantName..": "..RECAP_INCOMING.." "..header
						text = text.." "..recap_temp.Localize.For.." "..RecapPanelIncomingEffectText:GetText()
					elseif string_find(this:GetName(), "Other", 1, true) and recap_temp.OtherDetailsListSize>1 then
						text = "Recap ("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value].."): "..combatantName..": "..RECAP_OTHER_EFFECTS..": "..header
						text = text.." "..recap_temp.Localize.For.." "..RecapPanelOtherEffectText:GetText()
					end
				elseif (id == 105) then
					text = "Recap ("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value].."): "..combatantName
				end
				if _G[this:GetName().."Text"]:GetText() then
					text = text..": ".._G[this:GetName().."Text"]:GetText()
				end
			end
			Recap_InsertChat(text)
		end
	end
end

function RecapPanel_Show(name)

	if recap.Opt.ShowPanel.value then

		if recap_temp.Selected~=0 then
			if recap_temp.Selected == recap_temp.GroupIndex then
				name = recap_temp.GroupTotal
			elseif recap_temp.Selected == recap_temp.NonGroupIndex then
				name = recap_temp.NonGroupTotal
			else
				name = recap_temp.List[recap_temp.Selected].Name
			end
		end

		RecapPanel_Populate(name)
		RecapPanel:Show()
	end
end

function RecapPanel_Hide(clear)

	if clear then
		recap_temp.OutgoingDetailSelected = 0
		recap_temp.TargetDetailSelected = 0
		recap_temp.IncomingDetailSelected = 0
		recap_temp.SourceDetailSelected = 0
		recap_temp.OtherDetailSelected = 0
		recap_temp.PanelRecentSelected = 0
		if RecapRecent:IsVisible() then
			-- other popup is visible, so simply hide
			RecapPanel:Hide()
		else
			recap_temp.Selected = 0
			recap_temp.RecentSelected = 0
			if not recap.Opt.Minimized.value then
				RecapScrollBar_Update()
			end
		end
	end

	if recap_temp.Selected==0 then
		RecapPanel:Hide()
	end
end

function RecapPanelTab_OnEnter()

	-- lock OnEnter-OnLeave events
	if recap_temp.OnEnterOnLeave == true then return end
	recap_temp.OnEnterOnLeave = true

	local id = this:GetID()

	if id and id>0 then
		if recap.Opt.LightData.value and id<6 then
			Recap_Tooltip("PanelTabDisabled"..id)
		else
			Recap_Tooltip("PanelTab"..id)
		end
	end

	-- unlock OnEnter-OnLeave events
	recap_temp.OnEnterOnLeave = false
end

function RecapPanelTab_OnClick(frame, button, down)

	local id = this:GetID()
	if recap.Opt.LightData.value then
		id = 6
	end
	recap.Opt.PanelView.value = id
	RecapPanel_SwitchPanels(id)
end

function RecapPanel_SwitchPanels(panel)

	local i
	local _G = getfenv(0)

	for i=1,6 do
		_G["RecapPanelTab"..i]:UnlockHighlight()
		_G["RecapSubPanel"..i]:Hide()
	end
	_G["RecapPanelTab"..recap.Opt.PanelView.value]:LockHighlight()
	_G["RecapSubPanel"..recap.Opt.PanelView.value]:Show()
end

function RecapPanel_AmalgamateOutgoingTotals(name, AllLastOutgoingDetail)

	local i, iDetail, iEffect, iType, effectName, iTotal

	-- clear the totals
	recap_temp.OutgoingTotals = {}

	-- create new table (OutgoingTotals) for amalgamated subtotals and totals
	--   this code is not strictly necessary if we are not merging pets, but is done for merge pets both on and off for consistency
	--   this costs some time and memory
	if recap.Combatant[name][AllLastOutgoingDetail] then
		for i in pairs(recap.Combatant[name][AllLastOutgoingDetail]) do
			iDetail = recap.Combatant[name][AllLastOutgoingDetail][i]
			iEffect = i
			iType = tonumber(string_sub(iEffect,1,1))
			if (iType == 5) or (iType == 6) or (iType == 7) or (iType == 8) then
				if (iType == 5) or (iType == 7) then
					-- owner total, iEffect is already correct
				elseif (iType == 6) or (iType == 8) then
					-- pet total, calculate owner effect
					iType = tostring(iType - 1)
					_, _, effectName = string_find(iEffect, "^.-: (.+)$")
					iEffect = tostring(iType)..effectName
				end
				-- initialize if necessary
				if not recap_temp.OutgoingTotals[iEffect] then
					recap_temp.OutgoingTotals[iEffect] = {}
				end
				iTotal = recap_temp.OutgoingTotals[iEffect]
				Recap_AmalgamateTotal(iTotal, iDetail)
			end
		end
	end
end

function Recap_AmalgamateTotal(iTotal, iDetail)

	-- subtotal and total Element is always blank
	iTotal.Element = ""

	-- start accumulating details into the total
	if iDetail.CritsEvents and iDetail.CritsEvents>0 then
		iTotal.CritsEvents = (iTotal.CritsEvents or 0) + iDetail.CritsEvents
	end
	if iDetail.Hits and iDetail.Hits>0 then
		iTotal.Hits = (iTotal.Hits or 0) + iDetail.Hits
	end
	if iDetail.HitsDmg and iDetail.HitsDmg>0 then
		iTotal.HitsDmg = (iTotal.HitsDmg or 0) + iDetail.HitsDmg
	end
	if iDetail.HitsMax and iDetail.HitsMax>0 then
		iTotal.HitsMax = math_max((iTotal.HitsMax or 0), iDetail.HitsMax)
	end
	if iDetail.HitsMin and iDetail.HitsMin>0 then
		iTotal.HitsMin = Recap_Min(iTotal.HitsMin, iDetail.HitsMin)
	end
	if iDetail.Crits and iDetail.Crits>0 then
		iTotal.Crits = (iTotal.Crits or 0) + iDetail.Crits
	end
	if iDetail.CritsDmg and iDetail.CritsDmg>0 then
		iTotal.CritsDmg = (iTotal.CritsDmg or 0) + iDetail.CritsDmg
	end
	if iDetail.CritsMax and iDetail.CritsMax>0 then
		iTotal.CritsMax = math_max((iTotal.CritsMax or 0), iDetail.CritsMax)
	end
	if iDetail.CritsMin and iDetail.CritsMin>0 then
		iTotal.CritsMin = Recap_Min(iTotal.CritsMin, iDetail.CritsMin)
	end
	if iDetail.Ticks and iDetail.Ticks>0 then
		iTotal.Ticks = (iTotal.Ticks or 0) + iDetail.Ticks
	end
	if iDetail.TicksDmg and iDetail.TicksDmg>0 then
		iTotal.TicksDmg = (iTotal.TicksDmg or 0) + iDetail.TicksDmg
	end
	if iDetail.TicksMax and iDetail.TicksMax>0 then
		iTotal.TicksMax = math_max((iTotal.TicksMax or 0), iDetail.TicksMax)
	end
	if iDetail.TicksMin and iDetail.TicksMin>0 then
		iTotal.TicksMin = Recap_Min(iTotal.TicksMin, iDetail.TicksMin)
	end
	if iDetail.Glances and iDetail.Glances>0 then
		iTotal.Glances = (iTotal.Glances or 0) + iDetail.Glances
	end
	if iDetail.GlancesDmg and iDetail.GlancesDmg>0 then
		iTotal.GlancesDmg = (iTotal.GlancesDmg or 0) + iDetail.GlancesDmg
	end
	if iDetail.GlancesMax and iDetail.GlancesMax>0 then
		iTotal.GlancesMax = math_max((iTotal.GlancesMax or 0), iDetail.GlancesMax)
	end
	if iDetail.GlancesMin and iDetail.GlancesMin>0 then
		iTotal.GlancesMin = Recap_Min(iTotal.GlancesMin, iDetail.GlancesMin)
	end
	if iDetail.Crushes and iDetail.Crushes>0 then
		iTotal.Crushes = (iTotal.Crushes or 0) + iDetail.Crushes
	end
	if iDetail.CrushDmg and iDetail.CrushDmg>0 then
		iTotal.CrushDmg = (iTotal.CrushDmg or 0) + iDetail.CrushDmg
	end
	if iDetail.CrushMax and iDetail.CrushMax>0 then
		iTotal.CrushMax = math_max((iTotal.CrushMax or 0), iDetail.CrushMax)
	end
	if iDetail.CrushMin and iDetail.CrushMin>0 then
		iTotal.CrushMin = Recap_Min(iTotal.CrushMin, iDetail.CrushMin)
	end

	if iDetail.Missed and iDetail.Missed>0 then
		iTotal.Missed = (iTotal.Missed or 0) + iDetail.Missed
	end
	if iDetail.Dodged and iDetail.Dodged>0 then
		iTotal.Dodged = (iTotal.Dodged or 0) + iDetail.Dodged
	end
	if iDetail.Parried and iDetail.Parried>0 then
		iTotal.Parried = (iTotal.Parried or 0) + iDetail.Parried
	end
	if iDetail.Blocked and iDetail.Blocked>0 then
		iTotal.Blocked = (iTotal.Blocked or 0) + iDetail.Blocked
	end
	if iDetail.Absorbed and iDetail.Absorbed>0 then
		iTotal.Absorbed = (iTotal.Absorbed or 0) + iDetail.Absorbed
	end
	if iDetail.Deflected and iDetail.Deflected>0 then
		iTotal.Deflected = (iTotal.Deflected or 0) + iDetail.Deflected
	end
	if iDetail.Evaded and iDetail.Evaded>0 then
		iTotal.Evaded = (iTotal.Evaded or 0) + iDetail.Evaded
	end
	if iDetail.Resisted and iDetail.Resisted>0 then
		iTotal.Resisted = (iTotal.Resisted or 0) + iDetail.Resisted
	end
	if iDetail.Reflected and iDetail.Reflected>0 then
		iTotal.Reflected = (iTotal.Reflected or 0) + iDetail.Reflected
	end
	if iDetail.Immune and iDetail.Immune>0 then
		iTotal.Immune = (iTotal.Immune or 0) + iDetail.Immune
	end

	if iDetail.PAbsorbs and iDetail.PAbsorbs>0 then
		iTotal.PAbsorbs = (iTotal.PAbsorbs or 0) + iDetail.PAbsorbs
	end
	if iDetail.PAbsorbsDmg and iDetail.PAbsorbsDmg>0 then
		iTotal.PAbsorbsDmg = (iTotal.PAbsorbsDmg or 0) + iDetail.PAbsorbsDmg
	end
	if iDetail.PBlocks and iDetail.PBlocks>0 then
		iTotal.PBlocks = (iTotal.PBlocks or 0) + iDetail.PBlocks
	end
	if iDetail.PBlocksDmg and iDetail.PBlocksDmg>0 then
		iTotal.PBlocksDmg = (iTotal.PBlocksDmg or 0) + iDetail.PBlocksDmg
	end
	if iDetail.PResists25 and iDetail.PResists25>0 then
		iTotal.PResists25 = (iTotal.PResists25 or 0) + iDetail.PResists25
	end
	if iDetail.PResists25Dmg and iDetail.PResists25Dmg>0 then
		iTotal.PResists25Dmg = (iTotal.PResists25Dmg or 0) + iDetail.PResists25Dmg
	end
	if iDetail.PResists50 and iDetail.PResists50>0 then
		iTotal.PResists50 = (iTotal.PResists50 or 0) + iDetail.PResists50
	end
	if iDetail.PResists50Dmg and iDetail.PResists50Dmg>0 then
		iTotal.PResists50Dmg = (iTotal.PResists50Dmg or 0) + iDetail.PResists50Dmg
	end
	if iDetail.PResists75 and iDetail.PResists75>0 then
		iTotal.PResists75 = (iTotal.PResists75 or 0) + iDetail.PResists75
	end
	if iDetail.PResists75Dmg and iDetail.PResists75Dmg>0 then
		iTotal.PResists75Dmg = (iTotal.PResists75Dmg or 0) + iDetail.PResists75Dmg
	end

	if iDetail.EstResistedDmg and iDetail.EstResistedDmg>0 then
		iTotal.EstResistedDmg = (iTotal.EstResistedDmg or 0) + iDetail.EstResistedDmg
	end
	if iDetail.EstResistableDmg and iDetail.EstResistableDmg>0 then
		iTotal.EstResistableDmg = (iTotal.EstResistableDmg or 0) + iDetail.EstResistableDmg
	end

	if iDetail.ICount and iDetail.ICount>0 then
		iTotal.ICount = (iTotal.ICount or 0) + iDetail.ICount
	end
	if iDetail.ITotal and iDetail.ITotal>0 then
		iTotal.ITotal = (iTotal.ITotal or 0) + iDetail.ITotal
	end

	-- PrevTime is not used by subtotals or totals
end

function RecapPanel_ConstructOutgoingDetails(name, AllLastOutgoingDetail)

	local dmgtotal, healtotal, subtotaldmgtotal = 0,0,0
	local i, iList, iEffect, iType
	local amount, landed, attempted, overheal, rawheal, missed, critted, count

	-- clear the details
	recap_temp.OutgoingDetailsListSize = 1
	recap_temp.OutgoingDetailsList = {} -- breaks table.sort if we try to re-use the table by setting individual values to nil

	-- first the non-totals
	if recap.Combatant[name][AllLastOutgoingDetail] then
		for i in pairs(recap.Combatant[name][AllLastOutgoingDetail]) do
			if not recap_temp.OutgoingDetailsList[recap_temp.OutgoingDetailsListSize] then
				recap_temp.OutgoingDetailsList[recap_temp.OutgoingDetailsListSize] = {}
			end
			iList = recap_temp.OutgoingDetailsList[recap_temp.OutgoingDetailsListSize]
			iType = tonumber(string_sub(i,1,1))
			if (iType == 1) or (iType == 2) or (iType == 3) or (iType == 4) then
				-- ignore types 5, 6, 7, and 8 -- they have already been amalgamated into a separate table
				iEffect = recap.Combatant[name][AllLastOutgoingDetail][i]
				iList.Effect = i
				amount = (iEffect.GlancesDmg or 0) + (iEffect.HitsDmg or 0) + (iEffect.CritsDmg or 0) + (iEffect.CrushDmg or 0) + (iEffect.TicksDmg or 0)
				iList.Total = amount
				iList.Max = math_max(iEffect.TicksMax or 0,math_max(iEffect.HitsMax or 0,math_max(iEffect.CritsMax or 0,math_max(iEffect.CrushMax or 0,iEffect.GlancesMax or 0))))
				landed = (iEffect.Glances or 0) + (iEffect.Hits or 0) + (iEffect.Crits or 0) + (iEffect.Crushes or 0) + (iEffect.Ticks or 0)
				critted = (iEffect.Crits or 0)
				iList.Avg = string_format("%d",(landed>0 and Recap_Div0(amount, landed) or 0))

				-- misses or overhealing
				attempted = 0
				if (iType == 1) or (iType == 2) then
					missed = (iEffect.Missed or 0) + (iEffect.Blocked or 0) + (iEffect.Dodged or 0) + (iEffect.Parried or 0) +
							(iEffect.Deflected or 0) + (iEffect.Resisted or 0) + (iEffect.Reflected or 0) + (iEffect.Absorbed or 0) +
							(iEffect.Immune or 0) + (iEffect.Evaded or 0)
					attempted = missed + (iEffect.CritsEvents or 0)
					if (attempted > 0) then
						iList.MissPOverP = string_format("%.1f%%",Recap_Div1(100*missed, attempted))
					else
						iList.MissPOverP = " "
					end
				elseif (iType == 3) or (iType == 4) then
					attempted = (iEffect.CritsEvents or 0)
					-- overhealing (stored in the miss slot) calcs
					overheal = (iEffect.Missed or 0)
					rawheal = amount + overheal
					if (rawheal > 0) then
						iList.MissPOverP = string_format("%.1f%%",Recap_Div1(100*overheal, rawheal))
					else
						iList.MissPOverP = " "
					end
				end

				-- crit %
				if attempted>0 then
					iList.CritP = string_format("%.1f%%",Recap_Div1(100*critted, attempted))
				else
					iList.CritP = "--"
				end

				-- subtotals for percentage calcs
				if (iType == 1) or (iType == 2) then
					dmgtotal = dmgtotal + amount
				elseif (iType == 3) or (iType == 4) then
					healtotal = healtotal + amount
				end

				-- add element to the list (hide question mark values)
				if iEffect.Element and (iEffect.Element ~= "?") then
					iList.Element = iEffect.Element
				else
					iList.Element = ""
				end

				-- one hidden column for Interval (parallel code populates the fine details)
				count = (iEffect.ICount or 0)
				if count>0 then
					iList.Interval = string_format("%.1f",Recap_Div1((iEffect.ITotal or 0), 1000*count))
				else
					iList.Interval = "--"
				end

				recap_temp.OutgoingDetailsListSize = recap_temp.OutgoingDetailsListSize + 1
			end
		end
	end

	-- second the subtotals and totals (will only be iType 5 or 7)
	for i in pairs(recap_temp.OutgoingTotals) do
		if not recap_temp.OutgoingDetailsList[recap_temp.OutgoingDetailsListSize] then
			recap_temp.OutgoingDetailsList[recap_temp.OutgoingDetailsListSize] = {}
		end
		iList = recap_temp.OutgoingDetailsList[recap_temp.OutgoingDetailsListSize]
		iType = tonumber(string_sub(i,1,1))
		iEffect = recap_temp.OutgoingTotals[i]
		iList.Effect = i
		amount = (iEffect.GlancesDmg or 0) + (iEffect.HitsDmg or 0) + (iEffect.CritsDmg or 0) + (iEffect.CrushDmg or 0) + (iEffect.TicksDmg or 0)
		iList.Total = amount
		iList.Max = math_max(iEffect.TicksMax or 0,math_max(iEffect.HitsMax or 0,math_max(iEffect.CritsMax or 0,math_max(iEffect.CrushMax or 0,iEffect.GlancesMax or 0))))
		landed = (iEffect.Glances or 0) + (iEffect.Hits or 0) + (iEffect.Crits or 0) + (iEffect.Crushes or 0) + (iEffect.Ticks or 0)
		critted = (iEffect.Crits or 0)
		iList.Avg = string_format("%d",(landed>0 and Recap_Div0(amount, landed) or 0))

		-- misses or overhealing
		attempted = 0
		if (iType == 5) or ((iType == 7) and (string_find(i, RECAP_DAMAGE, 1, true))) then
			missed = (iEffect.Missed or 0) + (iEffect.Blocked or 0) + (iEffect.Dodged or 0) + (iEffect.Parried or 0) +
					(iEffect.Deflected or 0) + (iEffect.Resisted or 0) + (iEffect.Reflected or 0) + (iEffect.Absorbed or 0) +
					(iEffect.Immune or 0) + (iEffect.Evaded or 0)
			attempted = missed + (iEffect.CritsEvents or 0)
			if (attempted > 0) then
				iList.MissPOverP = string_format("%.1f%%",Recap_Div1(100*missed, attempted))
			else
				iList.MissPOverP = " "
			end
		elseif ((iType == 7) and (string_find(i, recap_temp.Localize.ElementHealing, 1, true))) then
			attempted = (iEffect.CritsEvents or 0)
			-- overhealing (stored in the miss slot) calcs
			overheal = (iEffect.Missed or 0)
			rawheal = amount + overheal
			if (rawheal > 0) then
				iList.MissPOverP = string_format("%.1f%%",Recap_Div1(100*overheal, rawheal))
			else
				iList.MissPOverP = " "
			end
		end

		-- crit %
		if attempted>0 then
			iList.CritP = string_format("%.1f%%",Recap_Div1(100*critted, attempted))
		else
			iList.CritP = "--"
		end

		-- subtotals for percentage calcs
		if (iType == 5) then
			subtotaldmgtotal = subtotaldmgtotal + amount
		elseif (iType == 7) then
			-- do nothing, answer is always 100%
		end

		-- Subtotal and Total element always blank
		iList.Element = ""

		-- one hidden column for Interval (parallel code populates the fine details)
		count = (iEffect.ICount or 0)
		if count>0 then
			iList.Interval = string_format("%.1f",Recap_Div1((iEffect.ITotal or 0), 1000*count))
		else
			iList.Interval = "--"
		end

		recap_temp.OutgoingDetailsListSize = recap_temp.OutgoingDetailsListSize + 1
	end
	recap_temp.OutgoingDetailsList[recap_temp.OutgoingDetailsListSize] = nil -- keep as nil

	for i=1, recap_temp.OutgoingDetailsListSize-1 do
		iList = recap_temp.OutgoingDetailsList[i]
		iType = tonumber(string_sub(iList.Effect,1,1))
		if (iType == 1) or (iType == 2) then
			subtotal = dmgtotal
		elseif (iType == 3) or (iType == 4) then
			subtotal = healtotal
		elseif (iType == 5) or (iType == 6) then
			subtotal = subtotaldmgtotal
		elseif (iType == 7) or (iType == 8) then
			-- answer is always 100%
			subtotal = iList.Total
		end
		if subtotal>0 then
			iList.TotalP = Recap_Div0(100*iList.Total, subtotal)
		else
			iList.TotalP = 0
		end
	end

	table_sort(recap_temp.OutgoingDetailsList,RecapPanel_DetailsDamageSort)

end

function RecapPanel_ConstructTargetDetails(name, AllLastTargetDetail)

	local dmgtotal, healtotal = 0,0
	local i, j, iList, iWhom, iType, sourceName, targetName, amount

	-- clear the details
	recap_temp.TargetDetailsListSize = 1
	recap_temp.TargetDetailsList = {} -- breaks table.sort if we try to re-use the table by setting individual values to nil

	-- placebo when data not available
	if not recap.Opt.MatrixData.value then
		if not recap_temp.TargetDetailsList[recap_temp.TargetDetailsListSize] then
			recap_temp.TargetDetailsList[recap_temp.TargetDetailsListSize] = {}
		end
		iList = recap_temp.TargetDetailsList[recap_temp.TargetDetailsListSize]
		iList.Whom = "0"..recap_temp.Localize.MatrixDataModeNotEnabled
		recap_temp.TargetDetailsListSize = recap_temp.TargetDetailsListSize + 1
	elseif (name == recap_temp.GroupTotal) or (name == recap_temp.NonGroupTotal) then
		if not recap_temp.TargetDetailsList[recap_temp.TargetDetailsListSize] then
			recap_temp.TargetDetailsList[recap_temp.TargetDetailsListSize] = {}
		end
		iList = recap_temp.TargetDetailsList[recap_temp.TargetDetailsListSize]
		iList.Whom = "0"..recap_temp.Localize.NotAvailable
		recap_temp.TargetDetailsListSize = recap_temp.TargetDetailsListSize + 1
	else
		if recap.Combatant[name][AllLastTargetDetail] then
			for i in pairs(recap.Combatant[name][AllLastTargetDetail]) do
				iWhom = recap.Combatant[name][AllLastTargetDetail][i]
				if iWhom then -- TODO: seem to get nil values occasionally
					iType = tonumber(string_sub(i,1,1))
					if iType then -- TODO: seem to get nil values occasionally
						targetName = Recap_StripGUIDsFromCombatant(string_sub(i,2))
						for j in pairs(iWhom) do
							if (iWhom[j] > 0) then
								if not recap_temp.TargetDetailsList[recap_temp.TargetDetailsListSize] then
									recap_temp.TargetDetailsList[recap_temp.TargetDetailsListSize] = {}
								end
								iList = recap_temp.TargetDetailsList[recap_temp.TargetDetailsListSize]
								if (j == "Total") then
									-- owner
									sourceName = Recap_StripGUIDsFromCombatant(name)
								else
									-- pet
									sourceName = Recap_StripGUIDsFromCombatant(j)
								end
								iList.Whom = tostring(iType)..sourceName.." ==> "..targetName
								amount = (iWhom[j] or 0)
								iList.Total = amount
								-- subtotals for percentage calcs
								if (iType == 1) or (iType == 2) then
									dmgtotal = dmgtotal + amount
								elseif (iType == 3) or (iType == 4) then
									healtotal = healtotal + amount
								end
								recap_temp.TargetDetailsListSize = recap_temp.TargetDetailsListSize + 1
							end
						end
					end
				end
			end
		end
	end
	recap_temp.TargetDetailsList[recap_temp.TargetDetailsListSize] = nil -- keep as nil

	for i=1, recap_temp.TargetDetailsListSize-1 do
		iList = recap_temp.TargetDetailsList[i]
		if iList then
			iType = tonumber(string_sub(iList.Whom,1,1))
			if (iType == 1) or (iType == 2) then
				subtotal = dmgtotal
			elseif (iType == 3) or (iType == 4) then
				subtotal = healtotal
			end
			if iList.Total then
				if subtotal>0 then
					iList.TotalP = Recap_Div1(100*iList.Total, subtotal)
				else
					iList.TotalP = 0
				end
			else
				iList.Total = nil
				iList.TotalP = nil
			end
		end
	end

	table_sort(recap_temp.TargetDetailsList,RecapPanel_DetailsToFromSort)

end

function RecapPanel_AmalgamateIncomingTotals(name, AllLastIncomingDetail)

	local i, iDetail, iEffect, iType, effectName, iTotal

	-- clear the totals
	recap_temp.IncomingTotals = {}

	-- create new table (IncomingTotals) for amalgamated subtotals and totals
	--   this code is not strictly necessary if we are not merging pets, but is done for merge pets both on and off for consistency
	--   this costs some time and memory
	if recap.Combatant[name][AllLastIncomingDetail] then
		for i in pairs(recap.Combatant[name][AllLastIncomingDetail]) do
			iDetail = recap.Combatant[name][AllLastIncomingDetail][i]
			iEffect = i
			iType = tonumber(string_sub(iEffect,1,1))
			if (iType == 5) or (iType == 6) or (iType == 7) or (iType == 8) then
				if (iType == 5) or (iType == 7) then
					-- owner total, iEffect is already correct
				elseif (iType == 6) or (iType == 8) then
					-- pet total, calculate owner effect
					iType = tostring(iType - 1)
					_, _, effectName = string_find(iEffect, "^.-: (.+)$")
					iEffect = tostring(iType)..effectName
				end
				-- initialize if necessary
				if not recap_temp.IncomingTotals[iEffect] then
					recap_temp.IncomingTotals[iEffect] = {}
				end
				iTotal = recap_temp.IncomingTotals[iEffect]
				Recap_AmalgamateTotal(iTotal, iDetail)
			end
		end
	end
end

function RecapPanel_ConstructIncomingDetails(name, AllLastIncomingDetail)

	local dmgtotal, healtotal, subtotaldmgtotal = 0,0,0
	local i, iList, iEffect, iType
	local amount, landed, attempted, overheal, rawheal, missed, critted, count

	-- clear the details
	recap_temp.IncomingDetailsListSize = 1
	recap_temp.IncomingDetailsList = {} -- breaks table.sort if we try to re-use the table by setting individual values to nil

	-- first the non-totals
	if recap.Combatant[name][AllLastIncomingDetail] then
		for i in pairs(recap.Combatant[name][AllLastIncomingDetail]) do
			if not recap_temp.IncomingDetailsList[recap_temp.IncomingDetailsListSize] then
				recap_temp.IncomingDetailsList[recap_temp.IncomingDetailsListSize] = {}
			end
			iList = recap_temp.IncomingDetailsList[recap_temp.IncomingDetailsListSize]
			iType = tonumber(string_sub(i,1,1))
			if (iType == 1) or (iType == 2) or (iType == 3) or (iType == 4) then
				-- ignore types 5, 6, 7, and 8 -- they have already been amalgamated into a separate table
				iEffect = recap.Combatant[name][AllLastIncomingDetail][i]
				iList.Effect = i
				amount = (iEffect.GlancesDmg or 0) + (iEffect.HitsDmg or 0) + (iEffect.CritsDmg or 0) + (iEffect.CrushDmg or 0) + (iEffect.TicksDmg or 0)
				iList.Total = amount
				iList.Max = math_max(iEffect.TicksMax or 0,math_max(iEffect.HitsMax or 0,math_max(iEffect.CritsMax or 0,math_max(iEffect.CrushMax or 0,iEffect.GlancesMax or 0))))
				landed = (iEffect.Glances or 0) + (iEffect.Hits or 0) + (iEffect.Crits or 0) + (iEffect.Crushes or 0) + (iEffect.Ticks or 0)
				critted = (iEffect.Crits or 0)
				iList.Avg = string_format("%d",(landed>0 and Recap_Div0(amount, landed) or 0))

				-- misses or overhealing
				attempted = 0
				if (iType == 1) or (iType == 2) then
					missed = (iEffect.Missed or 0) + (iEffect.Blocked or 0) + (iEffect.Dodged or 0) + (iEffect.Parried or 0) +
							(iEffect.Deflected or 0) + (iEffect.Resisted or 0) + (iEffect.Reflected or 0) + (iEffect.Absorbed or 0) +
							(iEffect.Immune or 0) + (iEffect.Evaded or 0)
					attempted = missed + (iEffect.CritsEvents or 0)
					if (attempted > 0) then
						iList.MissPOverP = string_format("%.1f%%",Recap_Div1(100*missed, attempted))
					else
						iList.MissPOverP = " "
					end
				elseif (iType == 3) or (iType == 4) then
					attempted = (iEffect.CritsEvents or 0)
					-- overhealing (stored in the miss slot) calcs
					overheal = (iEffect.Missed or 0)
					rawheal = amount + overheal
					if (rawheal > 0) then
						iList.MissPOverP = string_format("%.1f%%",Recap_Div1(100*overheal, rawheal))
					else
						iList.MissPOverP = " "
					end
				end

				-- crit %
				if attempted>0 then
					iList.CritP = string_format("%.1f%%",Recap_Div1(100*critted, attempted))
				else
					iList.CritP = "--"
				end

				-- subtotals for percentage calcs
				if (iType == 1) or (iType == 2) then
					dmgtotal = dmgtotal + amount
				elseif (iType == 3) or (iType == 4) then
					healtotal = healtotal + amount
				end

				-- add element to the list (hide question mark values)
				if iEffect.Element and (iEffect.Element ~= "?") then
					iList.Element = iEffect.Element
				else
					iList.Element = ""
				end

				-- one hidden column for Interval (parallel code populates the fine details)
				count = (iEffect.ICount or 0)
				if count>0 then
					iList.Interval = string_format("%.1f",Recap_Div1((iEffect.ITotal or 0), 1000*count))
				else
					iList.Interval = "--"
				end

				recap_temp.IncomingDetailsListSize = recap_temp.IncomingDetailsListSize + 1
			end
		end
	end

	-- second the subtotals and totals (will only be iType 5 or 7)
	for i in pairs(recap_temp.IncomingTotals) do
		if not recap_temp.IncomingDetailsList[recap_temp.IncomingDetailsListSize] then
			recap_temp.IncomingDetailsList[recap_temp.IncomingDetailsListSize] = {}
		end
		iList = recap_temp.IncomingDetailsList[recap_temp.IncomingDetailsListSize]
		iType = tonumber(string_sub(i,1,1))
		iEffect = recap_temp.IncomingTotals[i]
		iList.Effect = i
		amount = (iEffect.GlancesDmg or 0) + (iEffect.HitsDmg or 0) + (iEffect.CritsDmg or 0) + (iEffect.CrushDmg or 0) + (iEffect.TicksDmg or 0)
		iList.Total = amount
		iList.Max = math_max(iEffect.TicksMax or 0,math_max(iEffect.HitsMax or 0,math_max(iEffect.CritsMax or 0,math_max(iEffect.CrushMax or 0,iEffect.GlancesMax or 0))))
		landed = (iEffect.Glances or 0) + (iEffect.Hits or 0) + (iEffect.Crits or 0) + (iEffect.Crushes or 0) + (iEffect.Ticks or 0)
		critted = (iEffect.Crits or 0)
		iList.Avg = string_format("%d",(landed>0 and Recap_Div0(amount, landed) or 0))

		-- misses or overhealing
		attempted = 0
		if (iType == 5) or ((iType == 7) and (string_find(i, RECAP_DAMAGE, 1, true))) then
			missed = (iEffect.Missed or 0) + (iEffect.Blocked or 0) + (iEffect.Dodged or 0) + (iEffect.Parried or 0) +
					(iEffect.Deflected or 0) + (iEffect.Resisted or 0) + (iEffect.Reflected or 0) + (iEffect.Absorbed or 0) +
					(iEffect.Immune or 0) + (iEffect.Evaded or 0)
			attempted = missed + (iEffect.CritsEvents or 0)
			if (attempted > 0) then
				iList.MissPOverP = string_format("%.1f%%",Recap_Div1(100*missed, attempted))
			else
				iList.MissPOverP = " "
			end
		elseif ((iType == 7) and (string_find(i, recap_temp.Localize.ElementHealing, 1, true))) then
			attempted = (iEffect.CritsEvents or 0)
			-- overhealing (stored in the miss slot) calcs
			overheal = (iEffect.Missed or 0)
			rawheal = amount + overheal
			if (rawheal > 0) then
				iList.MissPOverP = string_format("%.1f%%",Recap_Div1(100*overheal, rawheal))
			else
				iList.MissPOverP = " "
			end
		end

		-- crit %
		if attempted>0 then
			iList.CritP = string_format("%.1f%%",Recap_Div1(100*critted, attempted))
		else
			iList.CritP = "--"
		end

		-- subtotals for percentage calcs
		if (iType == 5) then
			subtotaldmgtotal = subtotaldmgtotal + amount
		elseif (iType == 7) then
			-- do nothing, answer is always 100%
		end

		-- Subtotal and Total element always blank
		iList.Element = ""

		-- one hidden column for Interval (parallel code populates the fine details)
		count = (iEffect.ICount or 0)
		if count>0 then
			iList.Interval = string_format("%.1f",Recap_Div1((iEffect.ITotal or 0), 1000*count))
		else
			iList.Interval = "--"
		end

		recap_temp.IncomingDetailsListSize = recap_temp.IncomingDetailsListSize + 1
	end
	recap_temp.IncomingDetailsList[recap_temp.IncomingDetailsListSize] = nil -- keep as nil

	for i=1, recap_temp.IncomingDetailsListSize-1 do
		iList = recap_temp.IncomingDetailsList[i]
		iType = tonumber(string_sub(iList.Effect,1,1))
		if (iType == 1) or (iType == 2) then
			subtotal = dmgtotal
		elseif (iType == 3) or (iType == 4) then
			subtotal = healtotal
		elseif (iType == 5) or (iType == 6) then
			subtotal = subtotaldmgtotal
		elseif (iType == 7) or (iType == 8) then
			-- answer is always 100%
			subtotal = iList.Total
		end
		if subtotal>0 then
			iList.TotalP = Recap_Div0(100*iList.Total, subtotal)
		else
			iList.TotalP = 0
		end
	end

	table_sort(recap_temp.IncomingDetailsList,RecapPanel_DetailsDamageSort)

end

function RecapPanel_ConstructSourceDetails(name, AllLastSourceDetail)

	local dmgtotal, healtotal = 0,0
	local i, j, iList, iWhom, iType, sourceName, targetName, amount

	-- clear the details
	recap_temp.SourceDetailsListSize = 1
	recap_temp.SourceDetailsList = {} -- breaks table.sort if we try to re-use the table by setting individual values to nil

	-- placebo when data not available
	if not recap.Opt.MatrixData.value then
		if not recap_temp.SourceDetailsList[recap_temp.SourceDetailsListSize] then
			recap_temp.SourceDetailsList[recap_temp.SourceDetailsListSize] = {}
		end
		iList = recap_temp.SourceDetailsList[recap_temp.SourceDetailsListSize]
		iList.Whom = "0"..recap_temp.Localize.MatrixDataModeNotEnabled
		recap_temp.SourceDetailsListSize = recap_temp.SourceDetailsListSize + 1
	elseif (name == recap_temp.GroupTotal) or (name == recap_temp.NonGroupTotal) then
		if not recap_temp.SourceDetailsList[recap_temp.SourceDetailsListSize] then
			recap_temp.SourceDetailsList[recap_temp.SourceDetailsListSize] = {}
		end
		iList = recap_temp.SourceDetailsList[recap_temp.SourceDetailsListSize]
		iList.Whom = "0"..recap_temp.Localize.NotAvailable
		recap_temp.SourceDetailsListSize = recap_temp.SourceDetailsListSize + 1
	else
		if recap.Combatant[name][AllLastSourceDetail] then
			for i in pairs(recap.Combatant[name][AllLastSourceDetail]) do
				iWhom = recap.Combatant[name][AllLastSourceDetail][i]
				if iWhom then -- TODO: seem to get nil values occasionally
					iType = tonumber(string_sub(i,1,1))
					if iType then -- TODO: seem to get nil values occasionally
						sourceName = Recap_StripGUIDsFromCombatant(string_sub(i,2))
						for j in pairs(iWhom) do
							if (iWhom[j] > 0) then
								if not recap_temp.SourceDetailsList[recap_temp.SourceDetailsListSize] then
									recap_temp.SourceDetailsList[recap_temp.SourceDetailsListSize] = {}
								end
								iList = recap_temp.SourceDetailsList[recap_temp.SourceDetailsListSize]
								if (j == "Total") then
									-- owner
									targetName = Recap_StripGUIDsFromCombatant(name)
								else
									-- pet
									targetName = Recap_StripGUIDsFromCombatant(j)
								end
								iList.Whom = tostring(iType)..sourceName.." ==> "..targetName
								amount = (iWhom[j] or 0)
								iList.Total = amount
								-- subtotals for percentage calcs
								if (iType == 1) or (iType == 2) then
									dmgtotal = dmgtotal + amount
								elseif (iType == 3) or (iType == 4) then
									healtotal = healtotal + amount
								end
								recap_temp.SourceDetailsListSize = recap_temp.SourceDetailsListSize + 1
							end
						end
					end
				end
			end
		end
	end
	recap_temp.SourceDetailsList[recap_temp.SourceDetailsListSize] = nil -- keep as nil

	for i=1, recap_temp.SourceDetailsListSize-1 do
		iList = recap_temp.SourceDetailsList[i]
		if iList then
			iType = tonumber(string_sub(iList.Whom,1,1))
			if (iType == 1) or (iType == 2) then
				subtotal = dmgtotal
			elseif (iType == 3) or (iType == 4) then
				subtotal = healtotal
			end
			if iList.Total then
				if subtotal>0 then
					iList.TotalP = Recap_Div1(100*iList.Total, subtotal)
				else
					iList.TotalP = 0
				end
			else
				iList.Total = nil
				iList.TotalP = nil
			end
		end
	end

	table_sort(recap_temp.SourceDetailsList,RecapPanel_DetailsToFromSort)

end

function RecapPanel_ConstructOtherDetails(name, AllLastOtherDetail)

	local i, count, iList, iEffect, iType

	-- clear the details
	recap_temp.OtherDetailsListSize = 1
	recap_temp.OtherDetailsList = {} -- breaks table.sort if we try to re-use the table by setting individual values to nil

	-- placebo when data not available
	if (not recap.Opt.OtherData.value) then
		if not recap_temp.OtherDetailsList[recap_temp.OtherDetailsListSize] then
			recap_temp.OtherDetailsList[recap_temp.OtherDetailsListSize] = {}
		end
		iList = recap_temp.OtherDetailsList[recap_temp.OtherDetailsListSize]
		iList.Effect = "0"..recap_temp.Localize.OtherDataModeNotEnabled
		recap_temp.OtherDetailsListSize = recap_temp.OtherDetailsListSize + 1
	else
		if recap.Combatant[name][AllLastOtherDetail] then
			for i in pairs(recap.Combatant[name][AllLastOtherDetail]) do
				if not recap_temp.OtherDetailsList[recap_temp.OtherDetailsListSize] then
					recap_temp.OtherDetailsList[recap_temp.OtherDetailsListSize] = {}
				end
				iList = recap_temp.OtherDetailsList[recap_temp.OtherDetailsListSize]
				iEffect = recap.Combatant[name][AllLastOtherDetail][i]
				iType = string_sub(i,1,1)
				iList.Effect = tostring(iType)..Recap_StripOwnerAndGUIDsFromEffect(string_sub(i,2))
				iList.FullyQualifiedEffect = i -- hidden field
				iList.Hits = (iEffect.Hits or 0)
				iList.Total = (iEffect.Total or "--")
				iList.Attribute = (iEffect.Attribute or "--")
				-- two hidden columns for Interval and Duration (parallel code populates the fine details)
				count = (iEffect.ICount or 0)
				if count>0 then
					iList.Interval = string_format("%.1f",Recap_Div1((iEffect.ITotal or 0),1000*count))
				else
					iList.Interval = "--"
				end
				count = (iEffect.DCount or 0)
				if count>0 then
					iList.Duration = string_format("%.1f",Recap_Div1((iEffect.DTotal or 0),1000*count))
				else
					iList.Duration = "--"
				end

				recap_temp.OtherDetailsListSize = recap_temp.OtherDetailsListSize + 1
			end
		end
	end
	recap_temp.OtherDetailsList[recap_temp.OtherDetailsListSize] = nil -- keep as nil

	table_sort(recap_temp.OtherDetailsList,RecapPanel_DetailsHitsSort)

end

function RecapPanel_DetailsDamageSort(e1,e2)

	local effect1,effect2

	if e1.Effect then
		effect1 = string_sub(e1.Effect,1,1)
	else
		effect1 = "0"
	end
	if e2.Effect then
		effect2 = string_sub(e2.Effect,1,1)
	else
		effect2 = "0"
	end
	if not e1.Total then
		e1.Total = 0
	end
	if not e2.Total then
		e2.Total = 0
	end

	if ((e1.Total>e2.Total) and (effect1==effect2)) or (effect1<effect2) then
		return true
	else
		return false
	end
end

function RecapPanel_DetailsHitsSort(e1,e2)

	local effect1,effect2

	if e1.Effect then
		effect1 = string_sub(e1.Effect,1,1)
	else
		effect1 = "0"
	end
	if e2.Effect then
		effect2 = string_sub(e2.Effect,1,1)
	else
		effect2 = "0"
	end
	if not e1.Hits then
		e1.Hits = 0
	end
	if not e2.Hits then
		e2.Hits = 0
	end

	if ((e1.Hits>e2.Hits) and (effect1==effect2)) or (effect1<effect2) then
		return true
	else
		return false
	end
end

function RecapPanel_DetailsToFromSort(e1,e2)

	local whom1,whom2

	if e1.Whom then
		whom1 = string_sub(e1.Whom,1,1)
	else
		whom1 = "0"
	end
	if e2.Whom then
		whom2 = string_sub(e2.Whom,1,1)
	else
		whom2 = "0"
	end
	if not e1.Total then
		e1.Total = 0
	end
	if not e2.Total then
		e2.Total = 0
	end

	if ((e1.Total>e2.Total) and (whom1==whom2)) or (whom1<whom2) then
		return true
	else
		return false
	end
end

function RecapPanelOutgoingDetailsScrollBar_Update()

	local i, iType, index, item, r, g, b
	local _G = getfenv(0)

	if recap_temp.Loaded and recap_temp.OutgoingDetailsListSize then

		FauxScrollFrame_Update(RecapPanelOutgoingDetailsScrollBar,recap_temp.OutgoingDetailsListSize-1,7,14)

		for i=1,7 do
			index = i + FauxScrollFrame_GetOffset(RecapPanelOutgoingDetailsScrollBar)
			if index < recap_temp.OutgoingDetailsListSize then
				iType = string_sub(recap_temp.OutgoingDetailsList[index].Effect,1,1)
				if (iType=="0") then
					r,g,b = recap_temp.ColorWhite.r, recap_temp.ColorWhite.g, recap_temp.ColorWhite.b
				elseif (iType=="1") or (iType=="2") then
					r,g,b = recap_temp.ColorDmgOut.r, recap_temp.ColorDmgOut.g, recap_temp.ColorDmgOut.b
				elseif (iType=="3") or (iType=="4") then
					r,g,b = recap_temp.ColorHeal.r, recap_temp.ColorHeal.g, recap_temp.ColorHeal.b
				elseif (iType=="5") or (iType=="6") then
					r,g,b = recap_temp.ColorDmgOutPale.r, recap_temp.ColorDmgOutPale.g, recap_temp.ColorDmgOutPale.b
				elseif (iType=="7") or (iType=="8") then
					if string_find(recap_temp.OutgoingDetailsList[index].Effect, recap_temp.Localize.ElementHealing, 1, true) then
						r,g,b = recap_temp.ColorHealPale.r, recap_temp.ColorHealPale.g, recap_temp.ColorHealPale.b
					else
						r,g,b = recap_temp.ColorDmgOutPale.r, recap_temp.ColorDmgOutPale.g, recap_temp.ColorDmgOutPale.b
					end
				end
				_G["RecapPanelOutgoingDetail"..i.."_Name"]:SetText(Recap_StripOwnerAndGUIDsFromEffect(string_sub(recap_temp.OutgoingDetailsList[index].Effect,2)))
				_G["RecapPanelOutgoingDetail"..i.."_Name"]:SetTextColor(r, g, b)
				_G["RecapPanelOutgoingDetail"..i.."_FullyQualifiedName"]:SetText(string_sub(recap_temp.OutgoingDetailsList[index].Effect,2)) -- hidden field
				_G["RecapPanelOutgoingDetail"..i.."_Total"]:SetText(recap_temp.OutgoingDetailsList[index][recap.Opt.OutgoingPanelDetail.value])
				if recap.Opt.OutgoingPanelDetail.value=="Total" then
					_G["RecapPanelOutgoingDetail"..i.."_Total"]:SetTextColor(r, g, b)
				else
					_G["RecapPanelOutgoingDetail"..i.."_Total"]:SetTextColor(recap_temp.ColorWhite.r,recap_temp.ColorWhite.g,recap_temp.ColorWhite.b)
				end
				_G["RecapPanelOutgoingDetail"..i.."_TotalP"]:SetText(recap_temp.OutgoingDetailsList[index].TotalP.."%")
				_G["RecapPanelOutgoingDetail"..i.."_TotalP"]:SetTextColor(r, g, b)
				item = _G["RecapPanelOutgoingDetail"..i]
				item:Show()
				if recap_temp.OutgoingDetailSelected == index then
					item:LockHighlight()
				else
					item:UnlockHighlight()
				end

				item = _G["RecapPanelOutgoingRecent"..i]
				if (iType=="5") or (iType=="6") or (iType=="7") or (iType=="8") then
					-- subtotal or total, no recent events
					item:Hide()
				else
					_G["RecapPanelOutgoingRecent"..i.."_Text"]:SetTextColor(r, g, b)
					_G["RecapPanelOutgoingRecent"..i.."_SaveColor"]:SetTextColor(r, g, b) -- saves chosen colour
					item:Show()
				end
			else
				item = _G["RecapPanelOutgoingDetail"..i]
				item:Hide()
				item:UnlockHighlight()
				item = _G["RecapPanelOutgoingRecent"..i]
				item:Hide()
			end
		end
	end

end

function RecapPanelTargetDetailsScrollBar_Update()

	local i, iType, index, item, r, g, b, iList, iWhom
	local _G = getfenv(0)

	if recap_temp.Loaded and recap_temp.TargetDetailsListSize then

		FauxScrollFrame_Update(RecapPanelTargetDetailsScrollBar,recap_temp.TargetDetailsListSize-1,15,14)

		for i=1,15 do
			index = i + FauxScrollFrame_GetOffset(RecapPanelTargetDetailsScrollBar)
			if index < recap_temp.TargetDetailsListSize then
				iList = recap_temp.TargetDetailsList[index]
				iType = string_sub(iList.Whom,1,1)
				if (iType=="0") then
					r,g,b = recap_temp.ColorWhite.r, recap_temp.ColorWhite.g, recap_temp.ColorWhite.b
				elseif (iType=="1") or (iType=="2") then
					r,g,b = recap_temp.ColorDmgOut.r, recap_temp.ColorDmgOut.g, recap_temp.ColorDmgOut.b
				elseif (iType=="3") or (iType=="4") then
					r,g,b = recap_temp.ColorHeal.r, recap_temp.ColorHeal.g, recap_temp.ColorHeal.b
				end
				iWhom = string_sub(iList.Whom,2)
				_G["RecapPanelTargetDetail"..i.."_Name"]:SetText(iWhom) -- should have GUIDs already stripped
				_G["RecapPanelTargetDetail"..i.."_Name"]:SetTextColor(r, g, b)
				_G["RecapPanelTargetDetail"..i.."_Total"]:SetText(iList.Total)
				_G["RecapPanelTargetDetail"..i.."_Total"]:SetTextColor(r, g, b)
				if iList.TotalP then
					_G["RecapPanelTargetDetail"..i.."_TotalP"]:SetText(iList.TotalP.."%")
				else
					_G["RecapPanelTargetDetail"..i.."_TotalP"]:SetText("")
				end
				_G["RecapPanelTargetDetail"..i.."_TotalP"]:SetTextColor(r, g, b)
				item = _G["RecapPanelTargetDetail"..i]
				item:Show()
				if recap_temp.TargetDetailSelected == index then
					item:LockHighlight()
				else
					item:UnlockHighlight()
				end
			else
				item = _G["RecapPanelTargetDetail"..i]
				item:Hide()
				item:UnlockHighlight()
			end
		end
	end

end

function RecapPanelIncomingDetailsScrollBar_Update()

	local i, iType, index, item, r, g, b, iList
	local _G = getfenv(0)

	if recap_temp.Loaded and recap_temp.IncomingDetailsListSize then

		FauxScrollFrame_Update(RecapPanelIncomingDetailsScrollBar,recap_temp.IncomingDetailsListSize-1,7,14)

		for i=1,7 do
			index = i + FauxScrollFrame_GetOffset(RecapPanelIncomingDetailsScrollBar)
			if index < recap_temp.IncomingDetailsListSize then
				iList = recap_temp.IncomingDetailsList[index]
				iType = string_sub(iList.Effect,1,1)
				if (iType=="0") then
					r,g,b = recap_temp.ColorWhite.r, recap_temp.ColorWhite.g, recap_temp.ColorWhite.b
				elseif (iType=="1") or (iType=="2") then
					r,g,b = recap_temp.ColorDmgIn.r, recap_temp.ColorDmgIn.g, recap_temp.ColorDmgIn.b
				elseif (iType=="3") or (iType=="4") then
					r,g,b = recap_temp.ColorHeal.r, recap_temp.ColorHeal.g, recap_temp.ColorHeal.b
				elseif (iType=="5") or (iType=="6") then
					r,g,b = recap_temp.ColorDmgInPale.r, recap_temp.ColorDmgInPale.g, recap_temp.ColorDmgInPale.b
				elseif (iType=="7") or (iType=="8") then
					if string_find(iList.Effect, recap_temp.Localize.ElementHealing, 1, true) then
						r,g,b = recap_temp.ColorHealPale.r, recap_temp.ColorHealPale.g, recap_temp.ColorHealPale.b
					else
						r,g,b = recap_temp.ColorDmgInPale.r, recap_temp.ColorDmgInPale.g, recap_temp.ColorDmgInPale.b
					end
				end
				_G["RecapPanelIncomingDetail"..i.."_Name"]:SetText(Recap_StripOwnerAndGUIDsFromEffect(string_sub(iList.Effect,2)))
				_G["RecapPanelIncomingDetail"..i.."_Name"]:SetTextColor(r, g, b)
				_G["RecapPanelIncomingDetail"..i.."_FullyQualifiedName"]:SetText(string_sub(recap_temp.IncomingDetailsList[index].Effect,2)) -- hidden field
				_G["RecapPanelIncomingDetail"..i.."_Total"]:SetText(iList[recap.Opt.IncomingPanelDetail.value])
				if recap.Opt.IncomingPanelDetail.value=="Total" then
					_G["RecapPanelIncomingDetail"..i.."_Total"]:SetTextColor(r, g, b)
				else
					_G["RecapPanelIncomingDetail"..i.."_Total"]:SetTextColor(recap_temp.ColorWhite.r,recap_temp.ColorWhite.g,recap_temp.ColorWhite.b)
				end
				_G["RecapPanelIncomingDetail"..i.."_TotalP"]:SetText(iList.TotalP.."%")
				_G["RecapPanelIncomingDetail"..i.."_TotalP"]:SetTextColor(r, g, b)
				item = _G["RecapPanelIncomingDetail"..i]
				item:Show()
				if recap_temp.IncomingDetailSelected == index then
					item:LockHighlight()
				else
					item:UnlockHighlight()
				end

				item = _G["RecapPanelIncomingRecent"..i]
				if (iType=="5") or (iType=="6") or (iType=="7") or (iType=="8") then
					-- subtotal or total, no recent events
					item:Hide()
				else
					_G["RecapPanelIncomingRecent"..i.."_Text"]:SetTextColor(r, g, b)
					_G["RecapPanelIncomingRecent"..i.."_SaveColor"]:SetTextColor(r, g, b) -- saves chosen colour
					item:Show()
				end
			else
				item = _G["RecapPanelIncomingDetail"..i]
				item:Hide()
				item:UnlockHighlight()
				item = _G["RecapPanelIncomingRecent"..i]
				item:Hide()
			end
		end
	end
end

function RecapPanelSourceDetailsScrollBar_Update()

	local i, iType, index, item, r, g, b, iList, iWhom
	local _G = getfenv(0)

	if recap_temp.Loaded and recap_temp.SourceDetailsListSize then

		FauxScrollFrame_Update(RecapPanelSourceDetailsScrollBar,recap_temp.SourceDetailsListSize-1,15,14)

		for i=1,15 do
			index = i + FauxScrollFrame_GetOffset(RecapPanelSourceDetailsScrollBar)
			if index < recap_temp.SourceDetailsListSize then
				iList = recap_temp.SourceDetailsList[index]
				iType = string_sub(iList.Whom,1,1)
				if (iType=="0") then
					r,g,b = recap_temp.ColorWhite.r, recap_temp.ColorWhite.g, recap_temp.ColorWhite.b
				elseif (iType=="1") or (iType=="2") then
					r,g,b = recap_temp.ColorDmgIn.r, recap_temp.ColorDmgIn.g, recap_temp.ColorDmgIn.b
				elseif (iType=="3") or (iType=="4") then
					r,g,b = recap_temp.ColorHeal.r, recap_temp.ColorHeal.g, recap_temp.ColorHeal.b
				end
				iWhom = string_sub(iList.Whom,2)
				_G["RecapPanelSourceDetail"..i.."_Name"]:SetText(iWhom) -- should have GUIDs already stripped
				_G["RecapPanelSourceDetail"..i.."_Name"]:SetTextColor(r, g, b)
				_G["RecapPanelSourceDetail"..i.."_Total"]:SetText(iList.Total)
				_G["RecapPanelSourceDetail"..i.."_Total"]:SetTextColor(r, g, b)
				if iList.TotalP then
					_G["RecapPanelSourceDetail"..i.."_TotalP"]:SetText(iList.TotalP.."%")
				else
					_G["RecapPanelSourceDetail"..i.."_TotalP"]:SetText("")
				end
				_G["RecapPanelSourceDetail"..i.."_TotalP"]:SetTextColor(r, g, b)
				item = _G["RecapPanelSourceDetail"..i]
				item:Show()
				if recap_temp.SourceDetailSelected == index then
					item:LockHighlight()
				else
					item:UnlockHighlight()
				end
			else
				item = _G["RecapPanelSourceDetail"..i]
				item:Hide()
				item:UnlockHighlight()
			end
		end
	end

end

function RecapPanelOtherDetailsScrollBar_Update()

	local i, index, item, r, g, b, iType, iList
	local _G = getfenv(0)

	if recap_temp.Loaded and recap_temp.OtherDetailsListSize then

		FauxScrollFrame_Update(RecapPanelOtherDetailsScrollBar,recap_temp.OtherDetailsListSize-1,7,14)

		for i=1,7 do
			index = i + FauxScrollFrame_GetOffset(RecapPanelOtherDetailsScrollBar)
			if index < recap_temp.OtherDetailsListSize then
				iList = recap_temp.OtherDetailsList[index]
				iType = string_sub(iList.Effect,1,1)
				-- 1 is outgoing spells, usually non-damaging, being cast
				-- 3 is debuffs or losses (e.g. mana)
				-- 5 is buffs or gains (e.g. mana, extra attacks, happiness)
				-- 7 is debuff or buff, but we don't know which
				if (iType=="0") then
					r,g,b = recap_temp.ColorWhite.r, recap_temp.ColorWhite.g, recap_temp.ColorWhite.b
				elseif (iType=="1") or (iType=="2") then
					r,g,b = recap_temp.ColorDmgOut.r, recap_temp.ColorDmgOut.g, recap_temp.ColorDmgOut.b
				elseif  (iType=="3") or (iType=="4") then
					r,g,b = recap_temp.ColorDmgIn.r, recap_temp.ColorDmgIn.g, recap_temp.ColorDmgIn.b
				elseif (iType=="5") or (iType=="6") then
					r,g,b = recap_temp.ColorHeal.r, recap_temp.ColorHeal.g, recap_temp.ColorHeal.b
				elseif (iType=="7") or (iType=="8") then
					r,g,b = recap_temp.ColorWhite.r, recap_temp.ColorWhite.g, recap_temp.ColorWhite.b
				end
				_G["RecapPanelOtherDetail"..i.."_Name"]:SetText(Recap_StripOwnerAndGUIDsFromEffect(string_sub(iList.Effect,2)))
				_G["RecapPanelOtherDetail"..i.."_Name"]:SetTextColor(r, g, b)
				_G["RecapPanelOtherDetail"..i.."_Hits"]:SetText(iList.Hits)
				_G["RecapPanelOtherDetail"..i.."_Hits"]:SetTextColor(r, g, b)
				_G["RecapPanelOtherDetail"..i.."_Total"]:SetText(iList.Total)
				_G["RecapPanelOtherDetail"..i.."_Total"]:SetTextColor(r, g, b)
				_G["RecapPanelOtherDetail"..i.."_Attribute"]:SetText(iList.Attribute)
				_G["RecapPanelOtherDetail"..i.."_Attribute"]:SetTextColor(r, g, b)
				item = _G["RecapPanelOtherDetail"..i]
				item:Show()
				if recap_temp.OtherDetailSelected == index then
					item:LockHighlight()
				else
					item:UnlockHighlight()
				end
			else
				item = _G["RecapPanelOtherDetail"..i]
				item:Hide()
				item:UnlockHighlight()
			end
		end
	end

end

function RecapPanel_PopulateOutgoingDetails(thisCombatant, sel)

	local effect, i, totalmiss, iEffect, iType

	if not thisCombatant then
		return
	end
	if (not sel) or (sel < 0) then
		return
	end
	if not recap_temp.OutgoingDetailsList then
		return
	end

	RecapPanelOutgoingEffectText:SetText("--")
	RecapPanelOutgoingElementText:SetText("--")
	RecapPanelOutgoingDamageText:SetText("--")
	RecapPanelOutgoingGlancesText:SetText("--")
	RecapPanelOutgoingHitsText:SetText("--")
	RecapPanelOutgoingCritsText:SetText("--")
	RecapPanelOutgoingCrushesText:SetText("--")
	RecapPanelOutgoingTicksText:SetText("--")
	RecapPanelOutgoingGlancesMinText:SetText("--")
	RecapPanelOutgoingHitsMinText:SetText("--")
	RecapPanelOutgoingCritsMinText:SetText("--")
	RecapPanelOutgoingCrushMinText:SetText("--")
	RecapPanelOutgoingTicksMinText:SetText("--")
	RecapPanelOutgoingGlancesAvgText:SetText("--")
	RecapPanelOutgoingHitsAvgText:SetText("--")
	RecapPanelOutgoingCritsAvgText:SetText("--")
	RecapPanelOutgoingCrushAvgText:SetText("--")
	RecapPanelOutgoingTicksAvgText:SetText("--")
	RecapPanelOutgoingGlancesMaxText:SetText("--")
	RecapPanelOutgoingHitsMaxText:SetText("--")
	RecapPanelOutgoingCritsMaxText:SetText("--")
	RecapPanelOutgoingCrushMaxText:SetText("--")
	RecapPanelOutgoingTicksMaxText:SetText("--")
	RecapPanelOutgoingMissMissedText:SetText("--")
	RecapPanelOutgoingMissDodgedText:SetText("--")
	RecapPanelOutgoingMissParriedText:SetText("--")
	RecapPanelOutgoingMissBlockedText:SetText("--")
	RecapPanelOutgoingMissAbsorbedText:SetText("--")
	RecapPanelOutgoingMissEvadedText:SetText("--")
	RecapPanelOutgoingMissDeflectedText:SetText("--")
	RecapPanelOutgoingMissResistedText:SetText("--")
	RecapPanelOutgoingMissReflectedText:SetText("--")
	RecapPanelOutgoingMissImmuneText:SetText("--")
	RecapPanelOutgoingMissPText:SetText("--")
	RecapPanelOutgoingGlancePText:SetText("--")
	RecapPanelOutgoingCritPText:SetText("--")
	RecapPanelOutgoingCrushPText:SetText("--")
	RecapPanelOutgoingPartAbsorbsText:SetText("--")
	RecapPanelOutgoingPartAbsorbsTotalText:SetText("--")
	RecapPanelOutgoingPartAbsorbsAvgText:SetText("--")
	RecapPanelOutgoingPartBlocksText:SetText("--")
	RecapPanelOutgoingPartBlocksTotalText:SetText("--")
	RecapPanelOutgoingPartBlocksAvgText:SetText("--")
	RecapPanelOutgoingPartResists25Text:SetText("--")
	RecapPanelOutgoingPartResists25TotalText:SetText("--")
	RecapPanelOutgoingPartResists25AvgText:SetText("--")
	RecapPanelOutgoingPartResists50Text:SetText("--")
	RecapPanelOutgoingPartResists50TotalText:SetText("--")
	RecapPanelOutgoingPartResists50AvgText:SetText("--")
	RecapPanelOutgoingPartResists75Text:SetText("--")
	RecapPanelOutgoingPartResists75TotalText:SetText("--")
	RecapPanelOutgoingPartResists75AvgText:SetText("--")
	RecapPanelOutgoingEstimatedTotalResistedText:SetText("--")
	RecapPanelOutgoingIntervalCountText:SetText("--")
	RecapPanelOutgoingIntervalAvgText:SetText("--")

	if sel == 0 then
		return
	end

	if not recap_temp.OutgoingDetailsList[sel] then
		return
	end

	effect = recap_temp.OutgoingDetailsList[sel].Effect

	if not effect then
		return
	end

	iType = string_sub(effect,1,1)

	-- details come from different places depending on whether we are dealing with a non-total, or with a subtotal or total
	if (iType=="1") or (iType=="2") or (iType=="3") or (iType=="4") then
		if recap.Opt.View.value=="All" then
			if recap.Combatant and recap.Combatant[thisCombatant] and recap.Combatant[thisCombatant].OutgoingDetail and recap.Combatant[thisCombatant].OutgoingDetail[effect] then
				iEffect = recap.Combatant[thisCombatant].OutgoingDetail[effect]
			else
				return
			end
		else
			local theDetail = "LastOutgoingDetail_"..recap_temp.DisplayLastFight
			if recap.Combatant and recap.Combatant[thisCombatant] and recap.Combatant[thisCombatant][theDetail] and recap.Combatant[thisCombatant][theDetail][effect] then
				iEffect = recap.Combatant[thisCombatant][theDetail][effect]
			else
				return
			end
		end
	else
		if recap_temp.OutgoingTotals and recap_temp.OutgoingTotals[effect] then
			iEffect = recap_temp.OutgoingTotals[effect]
		else
			return
		end
	end

	if (iType=="1") or (iType=="2") or (iType=="5") or (iType=="6") or (((iType=="7") or (iType=="8")) and (string_find(effect, RECAP_DAMAGE, 1, true))) then
		RecapPanelOutgoingDamageLabel:SetText(RECAP_DAMAGE)
		RecapPanelOutgoingMissPLabel:SetText(RECAP_MISSES)
	else
		RecapPanelOutgoingDamageLabel:SetText(RECAP_HEAL)
		RecapPanelOutgoingMissPLabel:SetText(RECAP_OVERHEALING)
	end

	-- effect (repeated so we know which effect we are viewing)
	RecapPanelOutgoingEffectText:SetText(Recap_StripOwnerAndGUIDsFromEffect(string_sub(effect,2)))
	if (iType=="1") or (iType=="2") then
		RecapPanelOutgoingEffectText:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
	elseif (iType=="3") or (iType=="4") then
		RecapPanelOutgoingEffectText:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
	elseif (iType=="5") or (iType=="6") then
		RecapPanelOutgoingEffectText:SetTextColor(recap_temp.ColorDmgOutPale.r,recap_temp.ColorDmgOutPale.g,recap_temp.ColorDmgOutPale.b)
	elseif (iType=="7") or (iType=="8") then
		if string_find(effect, recap_temp.Localize.ElementHealing, 1, true) then
			RecapPanelOutgoingEffectText:SetTextColor(recap_temp.ColorHealPale.r,recap_temp.ColorHealPale.g,recap_temp.ColorHealPale.b)
		else
			RecapPanelOutgoingEffectText:SetTextColor(recap_temp.ColorDmgOutPale.r,recap_temp.ColorDmgOutPale.g,recap_temp.ColorDmgOutPale.b)
		end
	end

	-- element (hide question mark values)
	if iEffect.Element and (iEffect.Element ~= "?") then
		RecapPanelOutgoingElementText:SetText(iEffect.Element)
	else
		RecapPanelOutgoingElementText:SetText("")
	end

	-- damage
	RecapPanelOutgoingDamageText:SetText((iEffect.GlancesDmg or 0)+(iEffect.HitsDmg or 0)+(iEffect.CritsDmg or 0)+(iEffect.CrushDmg or 0)+(iEffect.TicksDmg or 0))

	-- glances
	i = (iEffect.Glances or 0)
	if i>0 then
		RecapPanelOutgoingGlancesText:SetText(i)
		RecapPanelOutgoingGlancesMinText:SetText(iEffect.GlancesMin or "--")
		RecapPanelOutgoingGlancesAvgText:SetFormattedText("%d",Recap_Div0((iEffect.GlancesDmg or 0),i))
		RecapPanelOutgoingGlancesMaxText:SetText(iEffect.GlancesMax or 0)
	elseif iEffect.CritsEvents then
		RecapPanelOutgoingGlancesText:SetText(0)
	end

	-- hits
	i = (iEffect.Hits or 0)
	if i>0 then
		RecapPanelOutgoingHitsText:SetText(i)
		RecapPanelOutgoingHitsMinText:SetText(iEffect.HitsMin or "--")
		RecapPanelOutgoingHitsAvgText:SetFormattedText("%d",Recap_Div0((iEffect.HitsDmg or 0),i))
		RecapPanelOutgoingHitsMaxText:SetText(iEffect.HitsMax or 0)
	elseif iEffect.CritsEvents then
		RecapPanelOutgoingHitsText:SetText(0)
	end

	-- crits
	i = (iEffect.Crits or 0)
	if i>0 then
		RecapPanelOutgoingCritsText:SetText(i)
		RecapPanelOutgoingCritsMinText:SetText(iEffect.CritsMin or "--")
		RecapPanelOutgoingCritsAvgText:SetFormattedText("%d",Recap_Div0((iEffect.CritsDmg or 0),i))
		RecapPanelOutgoingCritsMaxText:SetText(iEffect.CritsMax or 0)
	elseif iEffect.CritsEvents then
		RecapPanelOutgoingCritsText:SetText(0)
	end

	-- crushes
	i = (iEffect.Crushes or 0)
	if i>0 then
		RecapPanelOutgoingCrushesText:SetText(i)
		RecapPanelOutgoingCrushMinText:SetText(iEffect.CrushMin or "--")
		RecapPanelOutgoingCrushAvgText:SetFormattedText("%d",Recap_Div0((iEffect.CrushDmg or 0),i))
		RecapPanelOutgoingCrushMaxText:SetText(iEffect.CrushMax or 0)
	elseif iEffect.CritsEvents then
		RecapPanelOutgoingCrushesText:SetText(0)
	end

	-- ticks
	i = (iEffect.Ticks or 0)
	if i>0 then
		RecapPanelOutgoingTicksText:SetText(i)
		RecapPanelOutgoingTicksMinText:SetText(iEffect.TicksMin or "--")
		RecapPanelOutgoingTicksAvgText:SetFormattedText("%d",Recap_Div0((iEffect.TicksDmg or 0),i))
		RecapPanelOutgoingTicksMaxText:SetText(iEffect.TicksMax or 0)
	elseif iEffect.TicksMax then
		RecapPanelOutgoingTicksText:SetText(0)
	end

	-- miss or overheal % (and crit % and crush % and glance % calcs)
	if (iType=="1") or (iType=="2") or (iType=="5") or (iType=="6") or (((iType=="7") or (iType=="8")) and (string_find(effect, RECAP_DAMAGE, 1, true))) then
		-- miss
		miss = (iEffect.Missed or 0) + (iEffect.Dodged or 0) + (iEffect.Parried or 0) + (iEffect.Blocked or 0) +
				(iEffect.Deflected or 0) + (iEffect.Resisted or 0) + (iEffect.Reflected or 0) + (iEffect.Absorbed or 0) +
				(iEffect.Immune or 0) + (iEffect.Evaded or 0)
		i = miss + (iEffect.CritsEvents or 0)
		if i>0 then
			RecapPanelOutgoingGlancePText:SetText(((i==iEffect.Glances) and "100%") or string_format("%.1f%%",Recap_Div1(100*(iEffect.Glances or 0),i)))
			RecapPanelOutgoingCritPText:SetText(((i==iEffect.Crits) and "100%") or string_format("%.1f%%",Recap_Div1(100*(iEffect.Crits or 0),i)))
			RecapPanelOutgoingCrushPText:SetText(((i==iEffect.Crushes) and "100%") or string_format("%.1f%%",Recap_Div1(100*(iEffect.Crushes or 0),i)))
			if (miss==i) then
				RecapPanelOutgoingMissPText:SetText(i.." (100%)")
			else
				RecapPanelOutgoingMissPText:SetFormattedText("%d (%.1f%%)",miss,Recap_Div1(100*miss,i))
			end
		end
	else
		-- crits for heals
		i = (iEffect.CritsEvents or 0)
		if i>0 then
			RecapPanelOutgoingCritPText:SetText(((i==iEffect.Crits) and "100%") or string_format("%.1f%%",Recap_Div1(100*(iEffect.Crits or 0),i)))
		end
		-- effect numbers are full heals, not actual heals
		local heal, overheal
		heal = (iEffect.GlancesDmg or 0)+(iEffect.HitsDmg or 0)+(iEffect.CritsDmg or 0)+(iEffect.CrushDmg or 0)+(iEffect.TicksDmg or 0)
		overheal = (iEffect.Missed or 0)
		if heal>0 then
			RecapPanelOutgoingMissPText:SetFormattedText("%d (%d%%)",iEffect.Missed or 0,Recap_Div0(100*overheal,heal))
		end
	end

	if (iType=="1") or (iType=="2") or (iType=="5") or (iType=="6") or (((iType=="7") or (iType=="8")) and (string_find(effect, RECAP_DAMAGE, 1, true))) then
		-- non-healing misses
		totalmiss = (iEffect.Missed or 0) + (iEffect.Dodged or 0) + (iEffect.Parried or 0) + (iEffect.Blocked or 0) +
					(iEffect.Deflected or 0) + (iEffect.Resisted or 0) + (iEffect.Reflected or 0) + (iEffect.Absorbed or 0) +
					(iEffect.Immune or 0) + (iEffect.Evaded or 0)
		i = totalmiss + (iEffect.Glances or 0) + (iEffect.Hits or 0) + (iEffect.Crits or 0) + (iEffect.Crushes or 0)
		if i>0 then
			if iEffect.Missed and (iEffect.Missed > 0) then
				RecapPanelOutgoingMissMissedText:SetFormattedText("%d (%.1f%%)", iEffect.Missed, Recap_Div1(100*iEffect.Missed,i))
			end
			if iEffect.Dodged and (iEffect.Dodged > 0) then
				RecapPanelOutgoingMissDodgedText:SetFormattedText("%d (%.1f%%)", iEffect.Dodged, Recap_Div1(100*iEffect.Dodged,i))
			end
			if iEffect.Parried and (iEffect.Parried > 0) then
				RecapPanelOutgoingMissParriedText:SetFormattedText("%d (%.1f%%)", iEffect.Parried, Recap_Div1(100*iEffect.Parried,i))
			end
			if iEffect.Blocked and (iEffect.Blocked > 0) then
				RecapPanelOutgoingMissBlockedText:SetFormattedText("%d (%.1f%%)", iEffect.Blocked, Recap_Div1(100*iEffect.Blocked,i))
			end
			if iEffect.Deflected and (iEffect.Deflected > 0) then
				RecapPanelOutgoingMissDeflectedText:SetFormattedText("%d (%.1f%%)", iEffect.Deflected, Recap_Div1(100*iEffect.Deflected,i))
			end
			if iEffect.Resisted and (iEffect.Resisted > 0) then
				RecapPanelOutgoingMissResistedText:SetFormattedText("%d (%.1f%%)", iEffect.Resisted, Recap_Div1(100*iEffect.Resisted,i))
			end
			if iEffect.Reflected and (iEffect.Reflected > 0) then
				RecapPanelOutgoingMissReflectedText:SetFormattedText("%d (%.1f%%)", iEffect.Reflected, Recap_Div1(100*iEffect.Reflected,i))
			end
			if iEffect.Absorbed and (iEffect.Absorbed > 0) then
				RecapPanelOutgoingMissAbsorbedText:SetFormattedText("%d (%.1f%%)", iEffect.Absorbed, Recap_Div1(100*iEffect.Absorbed,i))
			end
			if iEffect.Immune and (iEffect.Immune > 0) then
				RecapPanelOutgoingMissImmuneText:SetFormattedText("%d (%.1f%%)", iEffect.Immune, Recap_Div1(100*iEffect.Immune,i))
			end
			if iEffect.Evaded and (iEffect.Evaded > 0) then
				RecapPanelOutgoingMissEvadedText:SetFormattedText("%d (%.1f%%)", iEffect.Evaded, Recap_Div1(100*iEffect.Evaded,i))
			end
		end
	end

	-- partials
	i = (iEffect.PAbsorbs or 0)
	if i>0 then
		RecapPanelOutgoingPartAbsorbsText:SetText(i)
		RecapPanelOutgoingPartAbsorbsTotalText:SetText(iEffect.PAbsorbsDmg or 0)
		RecapPanelOutgoingPartAbsorbsAvgText:SetFormattedText("%d",Recap_Div0((iEffect.PAbsorbsDmg or 0),i))
	end
	i = (iEffect.PBlocks or 0)
	if i>0 then
		RecapPanelOutgoingPartBlocksText:SetText(i)
		RecapPanelOutgoingPartBlocksTotalText:SetText(iEffect.PBlocksDmg or 0)
		RecapPanelOutgoingPartBlocksAvgText:SetFormattedText("%d",Recap_Div0((iEffect.PBlocksDmg or 0),i))
	end
	i = (iEffect.PResists25 or 0)
	if i>0 then
		RecapPanelOutgoingPartResists25Text:SetText(i)
		RecapPanelOutgoingPartResists25TotalText:SetText(iEffect.PResists25Dmg or 0)
		RecapPanelOutgoingPartResists25AvgText:SetFormattedText("%d",Recap_Div0((iEffect.PResists25Dmg or 0),i))
	end
	i = (iEffect.PResists50 or 0)
	if i>0 then
		RecapPanelOutgoingPartResists50Text:SetText(i)
		RecapPanelOutgoingPartResists50TotalText:SetText(iEffect.PResists50Dmg or 0)
		RecapPanelOutgoingPartResists50AvgText:SetFormattedText("%d",Recap_Div0((iEffect.PResists50Dmg or 0),i))
	end
	i = (iEffect.PResists75 or 0)
	if i>0 then
		RecapPanelOutgoingPartResists75Text:SetText(i)
		RecapPanelOutgoingPartResists75TotalText:SetText(iEffect.PResists75Dmg or 0)
		RecapPanelOutgoingPartResists75AvgText:SetFormattedText("%d",Recap_Div0((iEffect.PResists75Dmg or 0),i))
	end

	-- estimated total resistance and percentage
	i = (iEffect.EstResistedDmg or 0)
	j = (iEffect.EstResistableDmg or 0)
	if (i>0) and (j>0) then
		RecapPanelOutgoingEstimatedTotalResistedText:SetFormattedText("%d (%.1f%%)", Recap_Round0(i), Recap_Div1(100*i,j))
	end

	-- interval count and average (parallel code populates the list)
	count = (iEffect.ICount or 0)
	if count>0 then
		RecapPanelOutgoingIntervalCountText:SetText(count)
		RecapPanelOutgoingIntervalAvgText:SetFormattedText("%.1f",Recap_Div1((iEffect.ITotal or 0),1000*count))
	end
end

function RecapPanel_PopulateIncomingDetails(thisCombatant, sel)

	local effect, i, totalmiss, iCombatant, iEffect, iType

	if not thisCombatant then
		return
	end
	if (not sel) or (sel < 0) then
		return
	end
	if not recap_temp.IncomingDetailsList then
		return
	end

	RecapPanelIncomingEffectText:SetText("--")
	RecapPanelIncomingElementText:SetText("--")
	RecapPanelIncomingDamageText:SetText("--")
	RecapPanelIncomingGlancesText:SetText("--")
	RecapPanelIncomingHitsText:SetText("--")
	RecapPanelIncomingCritsText:SetText("--")
	RecapPanelIncomingCrushesText:SetText("--")
	RecapPanelIncomingTicksText:SetText("--")
	RecapPanelIncomingGlancesMinText:SetText("--")
	RecapPanelIncomingHitsMinText:SetText("--")
	RecapPanelIncomingCritsMinText:SetText("--")
	RecapPanelIncomingCrushMinText:SetText("--")
	RecapPanelIncomingTicksMinText:SetText("--")
	RecapPanelIncomingGlancesAvgText:SetText("--")
	RecapPanelIncomingHitsAvgText:SetText("--")
	RecapPanelIncomingCritsAvgText:SetText("--")
	RecapPanelIncomingCrushAvgText:SetText("--")
	RecapPanelIncomingTicksAvgText:SetText("--")
	RecapPanelIncomingGlancesMaxText:SetText("--")
	RecapPanelIncomingHitsMaxText:SetText("--")
	RecapPanelIncomingCritsMaxText:SetText("--")
	RecapPanelIncomingCrushMaxText:SetText("--")
	RecapPanelIncomingTicksMaxText:SetText("--")
	RecapPanelIncomingMissMissedText:SetText("--")
	RecapPanelIncomingMissDodgedText:SetText("--")
	RecapPanelIncomingMissParriedText:SetText("--")
	RecapPanelIncomingMissBlockedText:SetText("--")
	RecapPanelIncomingMissAbsorbedText:SetText("--")
	RecapPanelIncomingMissEvadedText:SetText("--")
	RecapPanelIncomingMissDeflectedText:SetText("--")
	RecapPanelIncomingMissResistedText:SetText("--")
	RecapPanelIncomingMissReflectedText:SetText("--")
	RecapPanelIncomingMissImmuneText:SetText("--")
	RecapPanelIncomingMissPText:SetText("--")
	RecapPanelIncomingGlancePText:SetText("--")
	RecapPanelIncomingCritPText:SetText("--")
	RecapPanelIncomingCrushPText:SetText("--")
	RecapPanelIncomingPartAbsorbsText:SetText("--")
	RecapPanelIncomingPartAbsorbsTotalText:SetText("--")
	RecapPanelIncomingPartAbsorbsAvgText:SetText("--")
	RecapPanelIncomingPartBlocksText:SetText("--")
	RecapPanelIncomingPartBlocksTotalText:SetText("--")
	RecapPanelIncomingPartBlocksAvgText:SetText("--")
	RecapPanelIncomingPartResists25Text:SetText("--")
	RecapPanelIncomingPartResists25TotalText:SetText("--")
	RecapPanelIncomingPartResists25AvgText:SetText("--")
	RecapPanelIncomingPartResists50Text:SetText("--")
	RecapPanelIncomingPartResists50TotalText:SetText("--")
	RecapPanelIncomingPartResists50AvgText:SetText("--")
	RecapPanelIncomingPartResists75Text:SetText("--")
	RecapPanelIncomingPartResists75TotalText:SetText("--")
	RecapPanelIncomingPartResists75AvgText:SetText("--")
	RecapPanelIncomingEstimatedTotalResistedText:SetText("--")
	RecapPanelIncomingIntervalCountText:SetText("--")
	RecapPanelIncomingIntervalAvgText:SetText("--")

	if sel == 0 then
		return
	end

	if not recap_temp.IncomingDetailsList[sel] then
		return
	end

	effect = recap_temp.IncomingDetailsList[sel].Effect

	if not effect then
		return
	end

	iType = string_sub(effect,1,1)

	-- details come from different places depending on whether we are dealing with a non-total, or with a subtotal or total
	if (iType=="1") or (iType=="2") or (iType=="3") or (iType=="4") then
		if recap.Opt.View.value=="All" then
			if recap.Combatant and recap.Combatant[thisCombatant] and recap.Combatant[thisCombatant].IncomingDetail and recap.Combatant[thisCombatant].IncomingDetail[effect] then
				iEffect = recap.Combatant[thisCombatant].IncomingDetail[effect]
			else
				return
			end
		else
			local theDetail = "LastIncomingDetail_"..recap_temp.DisplayLastFight
			if recap.Combatant and recap.Combatant[thisCombatant] and recap.Combatant[thisCombatant][theDetail] and recap.Combatant[thisCombatant][theDetail][effect] then
				iEffect = recap.Combatant[thisCombatant][theDetail][effect]
			else
				return
			end
		end
	else
		if recap_temp.IncomingTotals and recap_temp.IncomingTotals[effect] then
			iEffect = recap_temp.IncomingTotals[effect]
		else
			return
		end
	end

	if (iType=="1") or (iType=="2") or (iType=="5") or (iType=="6") or (((iType=="7") or (iType=="8")) and (string_find(effect, RECAP_DAMAGE, 1, true))) then
		RecapPanelIncomingDamageLabel:SetText(RECAP_DAMAGE)
		RecapPanelIncomingMissPLabel:SetText(RECAP_MISSES)
	else
		RecapPanelIncomingDamageLabel:SetText(RECAP_HEAL)
		RecapPanelIncomingMissPLabel:SetText(RECAP_OVERHEALING)
	end

	-- effect (repeated so we know which effect we are viewing)
	RecapPanelIncomingEffectText:SetText(Recap_StripOwnerAndGUIDsFromEffect(string_sub(effect,2)))
	if (iType=="1") or (iType=="2") then
		RecapPanelIncomingEffectText:SetTextColor(recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b)
	elseif (iType=="3") or (iType=="4") then
		RecapPanelIncomingEffectText:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
	elseif (iType=="5") or (iType=="6") then
		RecapPanelIncomingEffectText:SetTextColor(recap_temp.ColorDmgInPale.r,recap_temp.ColorDmgInPale.g,recap_temp.ColorDmgInPale.b)
	elseif (iType=="7") or (iType=="8") then
		if string_find(effect, recap_temp.Localize.ElementHealing, 1, true) then
			RecapPanelIncomingEffectText:SetTextColor(recap_temp.ColorHealPale.r,recap_temp.ColorHealPale.g,recap_temp.ColorHealPale.b)
		else
			RecapPanelIncomingEffectText:SetTextColor(recap_temp.ColorDmgInPale.r,recap_temp.ColorDmgInPale.g,recap_temp.ColorDmgInPale.b)
		end
	end

	-- element (hide question mark values)
	if iEffect.Element and (iEffect.Element ~= "?") then
		RecapPanelIncomingElementText:SetText(iEffect.Element)
	else
		RecapPanelIncomingElementText:SetText("")
	end

	-- damage
	RecapPanelIncomingDamageText:SetText((iEffect.GlancesDmg or 0)+(iEffect.HitsDmg or 0)+(iEffect.CritsDmg or 0)+(iEffect.CrushDmg or 0)+(iEffect.TicksDmg or 0))

	-- glances
	i = (iEffect.Glances or 0)
	if i>0 then
		RecapPanelIncomingGlancesText:SetText(i)
		RecapPanelIncomingGlancesMinText:SetText(iEffect.GlancesMin or "--")
		RecapPanelIncomingGlancesAvgText:SetFormattedText("%d",Recap_Div0((iEffect.GlancesDmg or 0),i))
		RecapPanelIncomingGlancesMaxText:SetText(iEffect.GlancesMax or 0)
	elseif iEffect.CritsEvents then
		RecapPanelIncomingGlancesText:SetText(0)
	end

	-- hits
	i = (iEffect.Hits or 0)
	if i>0 then
		RecapPanelIncomingHitsText:SetText(i)
		RecapPanelIncomingHitsMinText:SetText(iEffect.HitsMin or "--")
		RecapPanelIncomingHitsAvgText:SetFormattedText("%d",Recap_Div0((iEffect.HitsDmg or 0),i))
		RecapPanelIncomingHitsMaxText:SetText(iEffect.HitsMax or 0)
	elseif iEffect.CritsEvents then
		RecapPanelIncomingHitsText:SetText(0)
	end

	-- crits
	i = (iEffect.Crits or 0)
	if i>0 then
		RecapPanelIncomingCritsText:SetText(i)
		RecapPanelIncomingCritsMinText:SetText(iEffect.CritsMin or "--")
		RecapPanelIncomingCritsAvgText:SetFormattedText("%d",Recap_Div0((iEffect.CritsDmg or 0),i))
		RecapPanelIncomingCritsMaxText:SetText(iEffect.CritsMax or 0)
	elseif iEffect.CritsEvents then
		RecapPanelIncomingCritsText:SetText(0)
	end

	-- crushes
	i = (iEffect.Crushes or 0)
	if i>0 then
		RecapPanelIncomingCrushesText:SetText(i)
		RecapPanelIncomingCrushMinText:SetText(iEffect.CrushMin or "--")
		RecapPanelIncomingCrushAvgText:SetFormattedText("%d",Recap_Div0((iEffect.CrushDmg or 0),i))
		RecapPanelIncomingCrushMaxText:SetText(iEffect.CrushMax or 0)
	elseif iEffect.CritsEvents then
		RecapPanelIncomingCrushesText:SetText(0)
	end

	-- ticks
	i = (iEffect.Ticks or 0)
	if i>0 then
		RecapPanelIncomingTicksText:SetText(i)
		RecapPanelIncomingTicksMinText:SetText(iEffect.TicksMin or "--")
		RecapPanelIncomingTicksAvgText:SetFormattedText("%d",Recap_Div0((iEffect.TicksDmg or 0),i))
		RecapPanelIncomingTicksMaxText:SetText(iEffect.TicksMax or 0)
	elseif iEffect.TicksMax then
		RecapPanelIncomingTicksText:SetText(0)
	end

	-- miss or overheal % (and crit % and crush % and glance % calcs)
	if (iType=="1") or (iType=="2") or (iType=="5") or (iType=="6") or (((iType=="7") or (iType=="8")) and (string_find(effect, RECAP_DAMAGE, 1, true))) then
		-- miss
		miss = (iEffect.Missed or 0) + (iEffect.Dodged or 0) + (iEffect.Parried or 0) + (iEffect.Blocked or 0) +
				(iEffect.Deflected or 0) + (iEffect.Resisted or 0) + (iEffect.Reflected or 0) + (iEffect.Absorbed or 0) +
				(iEffect.Immune or 0) + (iEffect.Evaded or 0)
		i = miss + (iEffect.CritsEvents or 0)
		if i>0 then
			RecapPanelIncomingGlancePText:SetText(((i==iEffect.Glances) and "100%") or string_format("%.1f%%",Recap_Div1(100*(iEffect.Glances or 0),i)))
			RecapPanelIncomingCritPText:SetText(((i==iEffect.Crits) and "100%") or string_format("%.1f%%",Recap_Div1(100*(iEffect.Crits or 0),i)))
			RecapPanelIncomingCrushPText:SetText(((i==iEffect.Crushes) and "100%") or string_format("%.1f%%",Recap_Div1(100*(iEffect.Crushes or 0),i)))
			if (miss==i) then
				RecapPanelIncomingMissPText:SetText(i.." (100%)")
			else
				RecapPanelIncomingMissPText:SetFormattedText("%d (%.1f%%)",miss,Recap_Div1(100*miss,i))
			end
		end
	else
		-- crits for heals
		i = (iEffect.CritsEvents or 0)
		if i>0 then
			RecapPanelIncomingCritPText:SetText(((i==iEffect.Crits) and "100%") or string_format("%.1f%%",Recap_Div1(100*(iEffect.Crits or 0),i)))
		end
		-- effect numbers are full heals, not actual heals
		local heal, overheal
		heal = (iEffect.GlancesDmg or 0)+(iEffect.HitsDmg or 0)+(iEffect.CritsDmg or 0)+(iEffect.CrushDmg or 0)+(iEffect.TicksDmg or 0)
		overheal = (iEffect.Missed or 0)
		if heal>0 then
			RecapPanelIncomingMissPText:SetFormattedText("%d (%d%%)",iEffect.Missed or 0,Recap_Div0(100*overheal,heal))
		end
	end

	if (iType=="1") or (iType=="2") or (iType=="5") or (iType=="6") or (((iType=="7") or (iType=="8")) and (string_find(effect, RECAP_DAMAGE, 1, true))) then
		-- non-healing misses
		totalmiss = (iEffect.Missed or 0) + (iEffect.Dodged or 0) + (iEffect.Parried or 0) + (iEffect.Blocked or 0) +
					(iEffect.Deflected or 0) + (iEffect.Resisted or 0) + (iEffect.Reflected or 0) + (iEffect.Absorbed or 0) +
					(iEffect.Immune or 0) + (iEffect.Evaded or 0)
		i = totalmiss + (iEffect.Glances or 0) + (iEffect.Hits or 0) + (iEffect.Crits or 0) + (iEffect.Crushes or 0)
		if i>0 then
			if iEffect.Missed and (iEffect.Missed > 0) then
				RecapPanelIncomingMissMissedText:SetFormattedText("%d (%.1f%%)", iEffect.Missed, Recap_Div1(100*iEffect.Missed,i))
			end
			if iEffect.Dodged and (iEffect.Dodged > 0) then
				RecapPanelIncomingMissDodgedText:SetFormattedText("%d (%.1f%%)", iEffect.Dodged, Recap_Div1(100*iEffect.Dodged,i))
			end
			if iEffect.Parried and (iEffect.Parried > 0) then
				RecapPanelIncomingMissParriedText:SetFormattedText("%d (%.1f%%)", iEffect.Parried, Recap_Div1(100*iEffect.Parried,i))
			end
			if iEffect.Blocked and (iEffect.Blocked > 0) then
				RecapPanelIncomingMissBlockedText:SetFormattedText("%d (%.1f%%)", iEffect.Blocked, Recap_Div1(100*iEffect.Blocked,i))
			end
			if iEffect.Deflected and (iEffect.Deflected > 0) then
				RecapPanelIncomingMissDeflectedText:SetFormattedText("%d (%.1f%%)", iEffect.Deflected, Recap_Div1(100*iEffect.Deflected,i))
			end
			if iEffect.Resisted and (iEffect.Resisted > 0) then
				RecapPanelIncomingMissResistedText:SetFormattedText("%d (%.1f%%)", iEffect.Resisted, Recap_Div1(100*iEffect.Resisted,i))
			end
			if iEffect.Reflected and (iEffect.Reflected > 0) then
				RecapPanelIncomingMissReflectedText:SetFormattedText("%d (%.1f%%)", iEffect.Reflected, Recap_Div1(100*iEffect.Reflected,i))
			end
			if iEffect.Absorbed and (iEffect.Absorbed > 0) then
				RecapPanelIncomingMissAbsorbedText:SetFormattedText("%d (%.1f%%)", iEffect.Absorbed, Recap_Div1(100*iEffect.Absorbed,i))
			end
			if iEffect.Immune and (iEffect.Immune > 0) then
				RecapPanelIncomingMissImmuneText:SetFormattedText("%d (%.1f%%)", iEffect.Immune, Recap_Div1(100*iEffect.Immune,i))
			end
			if iEffect.Evaded and (iEffect.Evaded > 0) then
				RecapPanelIncomingMissEvadedText:SetFormattedText("%d (%.1f%%)", iEffect.Evaded, Recap_Div1(100*iEffect.Evaded,i))
			end
		end
	end

	-- partials
	i = (iEffect.PAbsorbs or 0)
	if i>0 then
		RecapPanelIncomingPartAbsorbsText:SetText(i)
		RecapPanelIncomingPartAbsorbsTotalText:SetText(iEffect.PAbsorbsDmg or 0)
		RecapPanelIncomingPartAbsorbsAvgText:SetFormattedText("%d",Recap_Div0((iEffect.PAbsorbsDmg or 0),i))
	end
	i = (iEffect.PBlocks or 0)
	if i>0 then
		RecapPanelIncomingPartBlocksText:SetText(i)
		RecapPanelIncomingPartBlocksTotalText:SetText(iEffect.PBlocksDmg or 0)
		RecapPanelIncomingPartBlocksAvgText:SetFormattedText("%d",Recap_Div0((iEffect.PBlocksDmg or 0),i))
	end
	i = (iEffect.PResists25 or 0)
	if i>0 then
		RecapPanelIncomingPartResists25Text:SetText(i)
		RecapPanelIncomingPartResists25TotalText:SetText(iEffect.PResists25Dmg or 0)
		RecapPanelIncomingPartResists25AvgText:SetFormattedText("%d",Recap_Div0((iEffect.PResists25Dmg or 0),i))
	end
	i = (iEffect.PResists50 or 0)
	if i>0 then
		RecapPanelIncomingPartResists50Text:SetText(i)
		RecapPanelIncomingPartResists50TotalText:SetText(iEffect.PResists50Dmg or 0)
		RecapPanelIncomingPartResists50AvgText:SetFormattedText("%d",Recap_Div0((iEffect.PResists50Dmg or 0),i))
	end
	i = (iEffect.PResists75 or 0)
	if i>0 then
		RecapPanelIncomingPartResists75Text:SetText(i)
		RecapPanelIncomingPartResists75TotalText:SetText(iEffect.PResists75Dmg or 0)
		RecapPanelIncomingPartResists75AvgText:SetFormattedText("%d",Recap_Div0((iEffect.PResists75Dmg or 0),i))
	end

	-- estimated total resistance and percentage
	i = (iEffect.EstResistedDmg or 0)
	j = (iEffect.EstResistableDmg or 0)
	if (i>0) and (j>0) then
		RecapPanelIncomingEstimatedTotalResistedText:SetFormattedText("%d (%.1f%%)", Recap_Round0(i), Recap_Div1(100*i,j))
	end

	-- interval count and average (parallel code populates the list)
	count = (iEffect.ICount or 0)
	if count>0 then
		RecapPanelIncomingIntervalCountText:SetText(count)
		RecapPanelIncomingIntervalAvgText:SetFormattedText("%.1f",Recap_Div1((iEffect.ITotal or 0),1000*count))
	end

end

function RecapPanel_PopulateOtherDetails(thisCombatant, sel)

	local effect, count, iEffect, iType

	if not thisCombatant then
		return
	end
	if (not sel) or (sel < 0) then
		return
	end
	if not recap_temp.OtherDetailsList then
		return
	end
	if not recap.Combatant then
		return
	end
	if not recap.Combatant[thisCombatant] then
		return
	end

	RecapPanelOtherEffectText:SetText("--")
	RecapPanelOtherAttributeText:SetText("--")
	RecapPanelOtherTotalText:SetText("--")
	RecapPanelOtherHitsText:SetText("--")
	RecapPanelOtherAvgText:SetText("--")
	RecapPanelOtherMaxText:SetText("--")
	RecapPanelOtherMissesText:SetText("--")
	RecapPanelOtherDispelsText:SetText("--")
	RecapPanelOtherStealsText:SetText("--")
	RecapPanelOtherIntervalCountText:SetText("--")
	RecapPanelOtherIntervalAvgText:SetText("--")
	RecapPanelOtherDurationCountText:SetText("--")
	RecapPanelOtherDurationAvgText:SetText("--")

	if sel == 0 then
		return
	end

	if not recap_temp.OtherDetailsList[sel] then
		return
	end

	effect = recap_temp.OtherDetailsList[sel].Effect

	if not effect then
		return
	end

	iType = string_sub(effect,1,1)

	if (iType=="0") then
		return
	end

	if recap.Opt.View.value=="All" then
		if recap.Combatant[thisCombatant].OtherDetail and recap.Combatant[thisCombatant].OtherDetail[recap_temp.OtherDetailsList[sel].FullyQualifiedEffect] then
			iEffect = recap.Combatant[thisCombatant].OtherDetail[recap_temp.OtherDetailsList[sel].FullyQualifiedEffect]
		else
			return
		end
	else
		local theDetail = "LastOtherDetail_"..recap_temp.DisplayLastFight
		if recap.Combatant[thisCombatant][theDetail] and recap.Combatant[thisCombatant][theDetail][recap_temp.OtherDetailsList[sel].FullyQualifiedEffect] then
			iEffect = recap.Combatant[thisCombatant][theDetail][recap_temp.OtherDetailsList[sel].FullyQualifiedEffect]
		else
			return
		end
	end

	-- effect (repeated so we know which effect we are viewing)
	RecapPanelOtherEffectText:SetText(Recap_StripOwnerAndGUIDsFromEffect(string_sub(effect,2)))
	if (iType=="1") or (iType=="2") then
		RecapPanelOtherEffectText:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
	elseif  (iType=="3") or (iType=="4") then
		RecapPanelOtherEffectText:SetTextColor(recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b)
	elseif (iType=="5") or (iType=="6") then
		RecapPanelOtherEffectText:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
	elseif (iType=="7") or (iType=="8") then
		RecapPanelOtherEffectText:SetTextColor(recap_temp.ColorWhite.r,recap_temp.ColorWhite.g,recap_temp.ColorWhite.b)
	end

	-- attribute
	if iEffect.Attribute then
		RecapPanelOtherAttributeText:SetText(iEffect.Attribute)
	end

	-- total, hits, misses, average, max
	count = (iEffect.Hits or 0)
	if count>0 then
		RecapPanelOtherHitsText:SetText(count)
		RecapPanelOtherMissesText:SetText((iEffect.Missed or 0))
		RecapPanelOtherTotalText:SetText(iEffect.Total or 0)
		RecapPanelOtherAvgText:SetFormattedText("%d",Recap_Div0((iEffect.Total or 0),count))
		RecapPanelOtherMaxText:SetText(iEffect.Max or 0)
	else
		RecapPanelOtherHitsText:SetText(0)
	end

	-- dispels
	if iEffect.Dispels and (iEffect.Dispels>0) then
		RecapPanelOtherDispelsText:SetText(iEffect.Dispels)
	end

	-- steals
	if iEffect.Steals and (iEffect.Steals>0) then
		RecapPanelOtherStealsText:SetText(iEffect.Steals)
	end

	-- interval count and average (parallel code populates the list)
	count = (iEffect.ICount or 0)
	if count>0 then
		RecapPanelOtherIntervalCountText:SetText(count)
		RecapPanelOtherIntervalAvgText:SetFormattedText("%.1f",Recap_Div1((iEffect.ITotal or 0),1000*count))
	end

	-- duration count and average (parallel code populates the list)
	count = (iEffect.DCount or 0)
	if count>0 then
		RecapPanelOtherDurationCountText:SetText(count)
		RecapPanelOtherDurationAvgText:SetFormattedText("%.1f",Recap_Div1((iEffect.DTotal or 0),1000*count))
	end

end

function RecapPanel_OutgoingDetail_OnEnter()

	-- lock OnEnter-OnLeave events
	if recap_temp.OnEnterOnLeave == true then return end
	recap_temp.OnEnterOnLeave = true

	local id = this:GetID()
	local index = id + FauxScrollFrame_GetOffset(RecapPanelOutgoingDetailsScrollBar)

	if (index<recap_temp.OutgoingDetailsListSize) and recap_temp.OutgoingDetailSelected==0 then
		if recap_temp.Selected == recap_temp.GroupIndex then
			RecapPanel_PopulateOutgoingDetails(recap_temp.GroupTotal, index)
		elseif recap_temp.Selected == recap_temp.NonGroupIndex then
			RecapPanel_PopulateOutgoingDetails(recap_temp.NonGroupTotal, index)
		else
			RecapPanel_PopulateOutgoingDetails(RecapPanelFullyQualifiedName:GetText(), index)
		end
	end

	-- unlock OnEnter-OnLeave events
	recap_temp.OnEnterOnLeave = false
end

function RecapPanel_OutgoingDetail_OnLeave()

	-- lock OnEnter-OnLeave events
	if recap_temp.OnEnterOnLeave == true then return end
	recap_temp.OnEnterOnLeave = true

	if recap_temp.OutgoingDetailSelected==0 then
		RecapPanel_PopulateOutgoingDetails(nil, 0)
	end

	-- unlock OnEnter-OnLeave events
	recap_temp.OnEnterOnLeave = false
end

-- clicks on individual effect lines
function RecapPanel_OutgoingDetail_OnClick(frame, button, down)

	local id = this:GetID()
	local index = id + FauxScrollFrame_GetOffset(RecapPanelOutgoingDetailsScrollBar)
	local _G = getfenv(0)

	if index<recap_temp.OutgoingDetailsListSize then

		local iType = string_sub(recap_temp.OutgoingDetailsList[index].Effect,1,1)

		-- detect double-click
		local isDoubleClick = false
		local thisEffect = _G["RecapPanelOutgoingDetail"..id.."_FullyQualifiedName"]:GetText()
		local thisClickTime = GetTime()
		if thisEffect == recap_temp.OutgoingEffectPriorEffect then
			-- another click on the same Effect
			if (thisClickTime - recap_temp.OutgoingEffectPriorClickTime) < 0.3 then
				-- two clicks on the same Effect within less than 0.3 seconds, call it a double-click
				isDoubleClick = true
			end
		end
		recap_temp.OutgoingEffectPriorEffect = thisEffect
		recap_temp.OutgoingEffectPriorClickTime = thisClickTime

		if IsShiftKeyDown() and not isDoubleClick then
			if (iType=="3") then
				-- healing, ordinary, owner
				Recap_InsertChat(string_format(recap_temp.Localize.OutgoingHealDetailLink,
									"("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value]..")",
									RecapPanelName:GetText(),
									_G["RecapPanelOutgoingDetail"..id.."_Name"]:GetText(),
									recap_temp.OutgoingDetailsList[index].Element,
									recap_temp.OutgoingDetailsList[index].Total,
									_G["RecapPanelOutgoingDetail"..id.."_TotalP"]:GetText(),
									RecapPanelName:GetText() ))

			elseif (iType=="4") then
				-- healing, ordinary, pet
				Recap_InsertChat(string_format(recap_temp.Localize.OutgoingHealDetailLink,
									"("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value]..")",
									Recap_StripGUIDsFromCombatant(Recap_PetFromFromPetEffect(_G["RecapPanelOutgoingDetail"..id.."_Name"]:GetText())),
									Recap_EffectFromFromPetEffect(_G["RecapPanelOutgoingDetail"..id.."_Name"]:GetText()),
									recap_temp.OutgoingDetailsList[index].Element,
									recap_temp.OutgoingDetailsList[index].Total,
									_G["RecapPanelOutgoingDetail"..id.."_TotalP"]:GetText(),
									RecapPanelName:GetText() ))

			elseif (iType=="5") or (iType=="6") or (((iType=="7") or (iType=="8")) and (string_find(recap_temp.OutgoingDetailsList[index].Effect, RECAP_DAMAGE, 1, true))) then
				-- damage, subtotal or total
				Recap_InsertChat(string_format(recap_temp.Localize.OutgoingDamageDetailLinkNoElement,
									"("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value]..")",
									RecapPanelName:GetText(),
									_G["RecapPanelOutgoingDetail"..id.."_Name"]:GetText(),
									recap_temp.OutgoingDetailsList[index].Total,
									_G["RecapPanelOutgoingDetail"..id.."_TotalP"]:GetText(),
									RecapPanelName:GetText() ))

			elseif (((iType=="7") or (iType=="8")) and (string_find(recap_temp.OutgoingDetailsList[index].Effect, recap_temp.Localize.ElementHealing, 1, true))) then
				-- healing, subtotal or total
				Recap_InsertChat(string_format(recap_temp.Localize.OutgoingHealDetailLinkNoElement,
									"("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value]..")",
									RecapPanelName:GetText(),
									_G["RecapPanelOutgoingDetail"..id.."_Name"]:GetText(),
									recap_temp.OutgoingDetailsList[index].Total,
									_G["RecapPanelOutgoingDetail"..id.."_TotalP"]:GetText(),
									RecapPanelName:GetText() ))

			elseif (iType=="1") then
				-- damage, ordinary, owner
				Recap_InsertChat(string_format(recap_temp.Localize.OutgoingDamageDetailLink,
									"("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value]..")",
									RecapPanelName:GetText(),
									_G["RecapPanelOutgoingDetail"..id.."_Name"]:GetText(),
									recap_temp.OutgoingDetailsList[index].Element,
									recap_temp.OutgoingDetailsList[index].Total,
									_G["RecapPanelOutgoingDetail"..id.."_TotalP"]:GetText(),
									RecapPanelName:GetText() ))

			elseif (iType=="2") then
				-- damage, ordinary, pet
				Recap_InsertChat(string_format(recap_temp.Localize.OutgoingDamageDetailLink,
									"("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value]..")",
									Recap_StripGUIDsFromCombatant(Recap_PetFromFromPetEffect(_G["RecapPanelOutgoingDetail"..id.."_Name"]:GetText())),
									Recap_EffectFromFromPetEffect(_G["RecapPanelOutgoingDetail"..id.."_Name"]:GetText()),
									recap_temp.OutgoingDetailsList[index].Element,
									recap_temp.OutgoingDetailsList[index].Total,
									_G["RecapPanelOutgoingDetail"..id.."_TotalP"]:GetText(),
									RecapPanelName:GetText() ))

			else
				-- shouldn't be anything else
			end

		elseif not IsShiftKeyDown() and isDoubleClick then
			if (iType=="1") or (iType=="2") or (iType=="3") or (iType=="4") then
				-- only for non-total lines
				local sourceName, effectName
				sourceName = RecapPanelFullyQualifiedName:GetText()
				effectName = Recap_StripOwnerAndPetFromEffect(_G["RecapPanelOutgoingDetail"..id.."_FullyQualifiedName"]:GetText())
				RecapRecent_PopulateByEffect(true, sourceName, effectName)
				RecapRecent:Show()
			else
				PlaySound("igQuestFailed")
			end

		elseif (recap_temp.OutgoingDetailSelected == index) then
			recap_temp.OutgoingDetailSelected = 0
			RecapPanel_PopulateOutgoingDetails(nil, 0)
			RecapPanelOutgoingDetailsScrollBar_Update()

		else
			recap_temp.OutgoingDetailSelected = index
			if recap_temp.Selected == recap_temp.GroupIndex then
				RecapPanel_PopulateOutgoingDetails(recap_temp.GroupTotal, index)
			elseif recap_temp.Selected == recap_temp.NonGroupIndex then
				RecapPanel_PopulateOutgoingDetails(recap_temp.NonGroupTotal, index)
			else
				RecapPanel_PopulateOutgoingDetails(RecapPanelFullyQualifiedName:GetText(), index)
			end
			RecapPanelOutgoingDetailsScrollBar_Update()
		end
	end
end

-- clicks on individual effect lines
function RecapPanel_TargetDetail_OnClick(frame, button, down)

	local id = this:GetID()
	local index = id + FauxScrollFrame_GetOffset(RecapPanelTargetDetailsScrollBar)
	local _G = getfenv(0)

	if IsShiftKeyDown() and index<recap_temp.TargetDetailsListSize then
		local iType = string_sub(recap_temp.TargetDetailsList[index].Whom,1,1)
		local found, iSource, iTarget
		found,_,iSource,iTarget = string_find(_G["RecapPanelTargetDetail"..id.."_Name"]:GetText(), "^(.+) ==> (.+)$")
		if (iType=="0") then
			-- do nothing
		elseif (iType=="3") or (iType=="4") then
			-- healing
			Recap_InsertChat(string_format(recap_temp.Localize.TargetHealDetailLink,
								"("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value]..")",
								iSource,
								iTarget,
								recap_temp.TargetDetailsList[index].Total,
								_G["RecapPanelTargetDetail"..id.."_TotalP"]:GetText(),
								RecapPanelName:GetText() ))
		else
			-- damage
			Recap_InsertChat(string_format(recap_temp.Localize.TargetDamageDetailLink,
								"("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value]..")",
								iSource,
								iTarget,
								recap_temp.TargetDetailsList[index].Total,
								_G["RecapPanelTargetDetail"..id.."_TotalP"]:GetText(),
								RecapPanelName:GetText() ))
		end

	elseif recap_temp.TargetDetailSelected==index then
		recap_temp.TargetDetailSelected = 0
		RecapPanelTargetDetailsScrollBar_Update()

	else
		recap_temp.TargetDetailSelected = index
		RecapPanelTargetDetailsScrollBar_Update()
	end
end

function RecapPanel_IncomingDetail_OnEnter()

	-- lock OnEnter-OnLeave events
	if recap_temp.OnEnterOnLeave == true then return end
	recap_temp.OnEnterOnLeave = true

	local id = this:GetID()
	local index = id + FauxScrollFrame_GetOffset(RecapPanelIncomingDetailsScrollBar)

	if (index<recap_temp.IncomingDetailsListSize) and recap_temp.IncomingDetailSelected==0 then
		if recap_temp.Selected == recap_temp.GroupIndex then
			RecapPanel_PopulateIncomingDetails(recap_temp.GroupTotal, index)
		elseif recap_temp.Selected == recap_temp.NonGroupIndex then
			RecapPanel_PopulateIncomingDetails(recap_temp.NonGroupTotal, index)
		else
			RecapPanel_PopulateIncomingDetails(RecapPanelFullyQualifiedName:GetText(), index)
		end
	end

	-- unlock OnEnter-OnLeave events
	recap_temp.OnEnterOnLeave = false
end

function RecapPanel_IncomingDetail_OnLeave()

	-- lock OnEnter-OnLeave events
	if recap_temp.OnEnterOnLeave == true then return end
	recap_temp.OnEnterOnLeave = true

	if recap_temp.IncomingDetailSelected==0 then
		RecapPanel_PopulateIncomingDetails(nil, 0)
	end

	-- unlock OnEnter-OnLeave events
	recap_temp.OnEnterOnLeave = false
end

-- clicks on individual effect lines
function RecapPanel_IncomingDetail_OnClick(frame, button, down)

	local id = this:GetID()
	local index = id + FauxScrollFrame_GetOffset(RecapPanelIncomingDetailsScrollBar)
	local _G = getfenv(0)

	if index<recap_temp.IncomingDetailsListSize then
		local iType = string_sub(recap_temp.IncomingDetailsList[index].Effect,1,1)

		-- detect double-click
		local isDoubleClick = false
		local thisEffect = _G["RecapPanelIncomingDetail"..id.."_FullyQualifiedName"]:GetText()
		local thisClickTime = GetTime()
		if thisEffect == recap_temp.IncomingEffectPriorEffect then
			-- another click on the same Effect
			if (thisClickTime - recap_temp.IncomingEffectPriorClickTime) < 0.3 then
				-- two clicks on the same Effect within less than 0.3 seconds, call it a double-click
				isDoubleClick = true
			end
		end
		recap_temp.IncomingEffectPriorEffect = thisEffect
		recap_temp.IncomingEffectPriorClickTime = thisClickTime

		if IsShiftKeyDown() and not isDoubleClick then
			if (iType=="3") then
				-- healing, ordinary, owner
				Recap_InsertChat(string_format(recap_temp.Localize.IncomingHealDetailLink,
									"("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value]..")",
									_G["RecapPanelIncomingDetail"..id.."_Name"]:GetText(),
									recap_temp.IncomingDetailsList[index].Element,
									RecapPanelName:GetText(),
									recap_temp.IncomingDetailsList[index].Total,
									_G["RecapPanelIncomingDetail"..id.."_TotalP"]:GetText(),
									RecapPanelName:GetText() ))

			elseif (iType=="4") then
				-- healing, ordinary, pet
				Recap_InsertChat(string_format(recap_temp.Localize.IncomingHealDetailLink,
									"("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value]..")",
									Recap_EffectFromFromPetEffect(_G["RecapPanelIncomingDetail"..id.."_Name"]:GetText()),
									recap_temp.IncomingDetailsList[index].Element,
									Recap_StripGUIDsFromCombatant(Recap_PetFromFromPetEffect(_G["RecapPanelIncomingDetail"..id.."_Name"]:GetText())),
									recap_temp.IncomingDetailsList[index].Total,
									_G["RecapPanelIncomingDetail"..id.."_TotalP"]:GetText(),
									RecapPanelName:GetText() ))

			elseif (iType=="5") or (iType=="6") or (((iType=="7") or (iType=="8")) and (string_find(recap_temp.IncomingDetailsList[index].Effect, RECAP_DAMAGE, 1, true))) then
				-- damage, subtotal or total
				Recap_InsertChat(string_format(recap_temp.Localize.IncomingDamageDetailLinkNoElement,
									"("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value]..")",
									_G["RecapPanelIncomingDetail"..id.."_Name"]:GetText(),
									RecapPanelName:GetText(),
									recap_temp.IncomingDetailsList[index].Total,
									_G["RecapPanelIncomingDetail"..id.."_TotalP"]:GetText(),
									RecapPanelName:GetText() ))

			elseif (((iType=="7") or (iType=="8")) and (string_find(recap_temp.IncomingDetailsList[index].Effect, recap_temp.Localize.ElementHealing, 1, true))) then
				-- healing, subtotal or total
				Recap_InsertChat(string_format(recap_temp.Localize.IncomingHealDetailLinkNoElement,
									"("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value]..")",
									_G["RecapPanelIncomingDetail"..id.."_Name"]:GetText(),
									RecapPanelName:GetText(),
									recap_temp.IncomingDetailsList[index].Total,
									_G["RecapPanelIncomingDetail"..id.."_TotalP"]:GetText(),
									RecapPanelName:GetText() ))

			elseif (iType=="1") then
				-- damage, ordinary, owner
				Recap_InsertChat(string_format(recap_temp.Localize.IncomingDamageDetailLink,
									"("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value]..")",
									_G["RecapPanelIncomingDetail"..id.."_Name"]:GetText(),
									recap_temp.IncomingDetailsList[index].Element,
									RecapPanelName:GetText(),
									recap_temp.IncomingDetailsList[index].Total,
									_G["RecapPanelIncomingDetail"..id.."_TotalP"]:GetText(),
									RecapPanelName:GetText() ))

			elseif (iType=="2") then
				-- damage, ordinary, pet
				Recap_InsertChat(string_format(recap_temp.Localize.IncomingDamageDetailLink,
									"("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value]..")",
									Recap_EffectFromFromPetEffect(_G["RecapPanelIncomingDetail"..id.."_Name"]:GetText()),
									recap_temp.IncomingDetailsList[index].Element,
									Recap_StripGUIDsFromCombatant(Recap_PetFromFromPetEffect(_G["RecapPanelIncomingDetail"..id.."_Name"]:GetText())),
									recap_temp.IncomingDetailsList[index].Total,
									_G["RecapPanelIncomingDetail"..id.."_TotalP"]:GetText(),
									RecapPanelName:GetText() ))

			else
				-- shouldn't be anything else
			end

		elseif not IsShiftKeyDown() and isDoubleClick then
			if (iType=="1") or (iType=="2") or (iType=="3") or (iType=="4") then
				-- only for non-total lines
				local sourceName, effectName
				sourceName = RecapPanelFullyQualifiedName:GetText()
				effectName = Recap_StripOwnerAndPetFromEffect(_G["RecapPanelIncomingDetail"..id.."_FullyQualifiedName"]:GetText())
				RecapRecent_PopulateByEffect(false, sourceName, effectName)
				RecapRecent:Show()
			else
				PlaySound("igQuestFailed")
			end

		elseif (recap_temp.IncomingDetailSelected == index) then
			recap_temp.IncomingDetailSelected = 0
			RecapPanel_PopulateIncomingDetails(nil, 0)
			RecapPanelIncomingDetailsScrollBar_Update()

		else
			recap_temp.IncomingDetailSelected = index
			if recap_temp.Selected == recap_temp.GroupIndex then
				RecapPanel_PopulateIncomingDetails(recap_temp.GroupTotal, index)
			elseif recap_temp.Selected == recap_temp.NonGroupIndex then
				RecapPanel_PopulateIncomingDetails(recap_temp.NonGroupTotal, index)
			else
				RecapPanel_PopulateIncomingDetails(RecapPanelFullyQualifiedName:GetText(), index)
			end
			RecapPanelIncomingDetailsScrollBar_Update()
		end
	end
end

-- clicks on individual effect lines
function RecapPanel_SourceDetail_OnClick(frame, button, down)

	local id = this:GetID()
	local index = id + FauxScrollFrame_GetOffset(RecapPanelSourceDetailsScrollBar)
	local _G = getfenv(0)

	if IsShiftKeyDown() and index<recap_temp.SourceDetailsListSize then
		local iType = string_sub(recap_temp.SourceDetailsList[index].Whom,1,1)
		local found, iSource, iTarget
		found,_,iSource,iTarget = string_find(_G["RecapPanelSourceDetail"..id.."_Name"]:GetText(), "^(.+) ==> (.+)$")
		if (iType=="0") then
			-- do nothing
		elseif (iType=="3") or (iType=="4") then
			-- healing
			Recap_InsertChat(string_format(recap_temp.Localize.SourceHealDetailLink,
								"("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value]..")",
								iSource,
								iTarget,
								recap_temp.SourceDetailsList[index].Total,
								_G["RecapPanelSourceDetail"..id.."_TotalP"]:GetText(),
								RecapPanelName:GetText() ))
		else
			-- damage
			Recap_InsertChat(string_format(recap_temp.Localize.SourceDamageDetailLink,
								"("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value]..")",
								iSource,
								iTarget,
								recap_temp.SourceDetailsList[index].Total,
								_G["RecapPanelSourceDetail"..id.."_TotalP"]:GetText(),
								RecapPanelName:GetText() ))
		end

	elseif recap_temp.SourceDetailSelected==index then
		recap_temp.SourceDetailSelected = 0
		RecapPanelSourceDetailsScrollBar_Update()

	else
		recap_temp.SourceDetailSelected = index
		RecapPanelSourceDetailsScrollBar_Update()
	end
end

function RecapPanel_OtherDetail_OnEnter()

	-- lock OnEnter-OnLeave events
	if recap_temp.OnEnterOnLeave == true then return end
	recap_temp.OnEnterOnLeave = true

	local id = this:GetID()
	local index = id + FauxScrollFrame_GetOffset(RecapPanelOtherDetailsScrollBar)

	if (index<recap_temp.OtherDetailsListSize) and recap_temp.OtherDetailSelected==0 then
		if recap_temp.Selected == recap_temp.GroupIndex then
			RecapPanel_PopulateOtherDetails(recap_temp.GroupTotal, index)
		elseif recap_temp.Selected == recap_temp.NonGroupIndex then
			RecapPanel_PopulateOtherDetails(recap_temp.NonGroupTotal, index)
		else
			RecapPanel_PopulateOtherDetails(RecapPanelFullyQualifiedName:GetText(), index)
		end
	end

	-- unlock OnEnter-OnLeave events
	recap_temp.OnEnterOnLeave = false
end

function RecapPanel_OtherDetail_OnLeave()

	-- lock OnEnter-OnLeave events
	if recap_temp.OnEnterOnLeave == true then return end
	recap_temp.OnEnterOnLeave = true

	if recap_temp.OtherDetailSelected==0 then
		RecapPanel_PopulateOtherDetails(nil, 0)
	end

	-- unlock OnEnter-OnLeave events
	recap_temp.OnEnterOnLeave = false
end

-- clicks on individual effect lines
function RecapPanel_OtherDetail_OnClick(frame, button, down)

	local id = this:GetID()
	local index = id + FauxScrollFrame_GetOffset(RecapPanelOtherDetailsScrollBar)
	local linkformat = recap_temp.Localize.OtherDetailLink
	local _G = getfenv(0)

	if IsShiftKeyDown() and index<recap_temp.OtherDetailsListSize then
		local iList, iType, typeText
		iList = recap_temp.OtherDetailsList[index]
		iType = string_sub(iList.Effect,1,1)
		if (iType=="0") then
			-- do nothing
		else
			typeText = recap_temp.Localize.OtherDetailType[tonumber(iType)]
			-- Note: considerable variability in the message output
			local variableBit = ""
			if iList.Total and (iList.Total ~= "--") then
				variableBit = "("..string_lower(RECAP_TOTAL).." "..iList.Total
				if iList.Attribute ~= "--" then
					variableBit = variableBit.." "..iList.Attribute
				end
			end
			if iList.Interval and (iList.Interval ~= "--") then
				if (variableBit == "") then
					variableBit = "("
				else
					variableBit = variableBit..", "
				end
				variableBit = variableBit..RECAP_ESTIMATED_INTERVAL.." "..iList.Interval.." s"
			end
			if iList.Duration and (iList.Duration ~= "--") then
				if (variableBit == "") then
					variableBit = "("
				else
					variableBit = variableBit..", "
				end
				variableBit = variableBit..RECAP_ESTIMATED_DURATION.." "..iList.Duration.." s"
			end
			if (variableBit ~= "") then
				variableBit = variableBit..")"
			end
			Recap_InsertChat(string_format(linkformat,
											"("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value]..")",
											RecapPanelName:GetText(),
											typeText,
											_G["RecapPanelOtherDetail"..id.."_Name"]:GetText(),
											iList.Hits,
											variableBit ))

			-- currently Other details are not included in Recent Data

		end

	elseif recap_temp.OtherDetailSelected==index then
		recap_temp.OtherDetailSelected = 0
		RecapPanelOtherDetailsScrollBar_Update()
		RecapPanel_PopulateOtherDetails(nil, 0)

	else
		recap_temp.OtherDetailSelected = index
		if recap_temp.Selected == recap_temp.GroupIndex then
			RecapPanel_PopulateOtherDetails(recap_temp.GroupTotal, index)
		elseif recap_temp.Selected == recap_temp.NonGroupIndex then
			RecapPanel_PopulateOtherDetails(recap_temp.NonGroupTotal, index)
		else
			RecapPanel_PopulateOtherDetails(RecapPanelFullyQualifiedName:GetText(), index)
		end
		RecapPanelOtherDetailsScrollBar_Update()
	end
end

function RecapPanel_Recent_OnClick(frame, button, down)

	local id, index, thisCombatant
	local _G = getfenv(0)
	local sourceName, effectName

	id = this:GetID()

	if recap.Opt.RecentData.value then
		if recap.Opt.PanelView.value==1 then
			-- incoming
			index = id + FauxScrollFrame_GetOffset(RecapPanelIncomingDetailsScrollBar)
			if index<recap_temp.IncomingDetailsListSize then
				if recap_temp.PanelRecentSelected==index then
					recap_temp.PanelRecentSelected = 0
					RecapRecent:Hide()
				else
					recap_temp.PanelRecentSelected = index
					sourceName = RecapPanelFullyQualifiedName:GetText()
					effectName = Recap_StripOwnerAndPetFromEffect(_G["RecapPanelIncomingDetail"..id.."_FullyQualifiedName"]:GetText())
					RecapRecent_PopulateByEffect(false, sourceName, effectName)
					RecapRecent:Show()
				end
			end
		else
			index = id + FauxScrollFrame_GetOffset(RecapPanelOutgoingDetailsScrollBar)
			if index<recap_temp.OutgoingDetailsListSize then
				if recap_temp.PanelRecentSelected==index then
					recap_temp.PanelRecentSelected = 0
					RecapRecent:Hide()
				else
					recap_temp.PanelRecentSelected = index
					sourceName = RecapPanelFullyQualifiedName:GetText()
					effectName = Recap_StripOwnerAndPetFromEffect(_G["RecapPanelOutgoingDetail"..id.."_FullyQualifiedName"]:GetText())
					effectName = _G["RecapPanelOutgoingDetail"..id.."_FullyQualifiedName"]:GetText()
					RecapRecent_PopulateByEffect(true, sourceName, effectName)
					RecapRecent:Show()
				end
			end
		end
	else
		PlaySound("igQuestFailed")
	end
end

function RecapPanel_OnMouseDown(frame, button)

	if recap_temp.Loaded and (button == "LeftButton") then
		RecapPanel:StartMoving()
	end
end

function RecapPanel_OnMouseUp(frame, button)

	if recap_temp.Loaded and (button == "LeftButton") then
		RecapPanel:StopMovingOrSizing()

		-- check for docking
		recap.Opt.PanelAnchor.value = false

		if Recap_Near(RecapFrame:GetRight(),RecapPanel:GetLeft()) then
			if Recap_Near(RecapFrame:GetTop(),RecapPanel:GetTop()) then
				recap.Opt.PanelAnchor = { type="Flag", value=true, Main="TOPRIGHT", Panel="TOPLEFT" }
			elseif Recap_Near(RecapFrame:GetBottom(),RecapPanel:GetBottom()) then
				recap.Opt.PanelAnchor = { type="Flag", value=true, Main="BOTTOMRIGHT", Panel="BOTTOMLEFT"}
			end
		elseif Recap_Near(RecapFrame:GetLeft(),RecapPanel:GetRight()) then
			if Recap_Near(RecapFrame:GetTop(),RecapPanel:GetTop()) then
				recap.Opt.PanelAnchor = { type="Flag", value=true, Main="TOPLEFT", Panel="TOPRIGHT" }
			elseif Recap_Near(RecapFrame:GetBottom(),RecapPanel:GetBottom()) then
				recap.Opt.PanelAnchor = { type="Flag", value=true, Main="BOTTOMLEFT", Panel="BOTTOMRIGHT" }
			end
		elseif Recap_Near(RecapFrame:GetRight(),RecapPanel:GetRight()) then
			if Recap_Near(RecapFrame:GetTop(),RecapPanel:GetBottom()) then
				recap.Opt.PanelAnchor = { type="Flag", value=true, Main="TOPRIGHT", Panel="BOTTOMRIGHT" }
			elseif Recap_Near(RecapFrame:GetBottom(),RecapPanel:GetTop()) then
				recap.Opt.PanelAnchor = { type="Flag", value=true, Main="BOTTOMRIGHT", Panel="TOPRIGHT" }
			end
		elseif Recap_Near(RecapFrame:GetLeft(),RecapPanel:GetLeft()) then
			if Recap_Near(RecapFrame:GetTop(),RecapPanel:GetBottom()) then
				recap.Opt.PanelAnchor = { type="Flag", value=true, Main="TOPLEFT", Panel="BOTTOMLEFT" }
			elseif Recap_Near(RecapFrame:GetBottom(),RecapPanel:GetTop()) then
				recap.Opt.PanelAnchor = { type="Flag", value=true, Main="BOTTOMLEFT", Panel="TOPLEFT" }
			end
		end

		if recap.Opt.PanelAnchor.value then
			RecapPanel:ClearAllPoints()
			RecapPanel:SetPoint(recap.Opt.PanelAnchor.Panel,"RecapFrame",recap.Opt.PanelAnchor.Main,Recap_PanelOffset("x"),Recap_PanelOffset("y"))
		end

	end
end

function Recap_PanelOffset(axis)

	local anchor

	anchor = recap.Opt.PanelAnchor.Main..recap.Opt.PanelAnchor.Panel
	if dockoffset[anchor] and axis then
		return dockoffset[anchor][axis]
	else
		return 0
	end
end

-- returns true if the two values are close to each other
function Recap_Near(point1, point2)

	local isnear = false

	if (math_max(point1,point2)-math_min(point1,point2)) < 15 then
	isnear = true
	end

	return isnear
end

function RecapOutgoingDetailHeader_OnMouseUp(frame, button)

	if (button == "RightButton") and not IsShiftKeyDown() then
		Recap_CreateMenu(recap_temp.Localize.DetailMenu, nil)
	end
end

function RecapIncomingDetailHeader_OnMouseUp(frame, button)

	if (button == "RightButton") and not IsShiftKeyDown() then
		Recap_CreateMenu(recap_temp.Localize.DetailMenu, nil)
	end
end

-- this substitutes ChatFrameEditBox:Insert.  Sends the 'msg' over the current chatType
-- using as many lines as needed, breaking lines by 'delimiter', a single-character
-- string.  (if no delimiter is given it will use "]").  If a delim1ter isn't found, it
-- will hard-break every 255 characters (changed to 245 to leave room for colour escape).
function Recap_InsertChat(msg, delimiter, escapeColour)

	local cx, i, m_start, m_end, done, newMsg
	local print_chat = SendChatMessage
	local chatchan, chatnum

	delimiter = string_sub(delimiter or "]",1,1)

	chatchan, chatnum = Recap_GetChannelInfo(nil, nil)
	if chatchan=="Self" then
		print_chat = Recap_Print
	end

	-- if the focus is on a WIM (WoW Instant Messenger) edit box, post there
	if WIM_EditBoxInFocus then
		print_chat = Recap_WIM_Print
	end

	-- If the Clip box on the Options : Reports panel is open, post there instead of to chat or console
	if RecapClipEditBox:IsVisible() then
		print_chat = Recap_LineToClipboard
	end

	-- this will presumably usually return zero
	cx = string_len(ChatFrameEditBox:GetText())

	if cx+string_len(msg)<245 then
		newMsg = msg
		if (chatchan=="Self") and escapeColour then
			-- colour to our console
			newMsg = escapeColour..newMsg
		end
		print_chat(newMsg, chatchan, nil, chatnum)
	else
		if cx>0 then
			print_chat(ChatFrameEditBox:GetText(), chatchan, nil, chatnum)
			ChatFrameEditBox:SetText("")
		end

		cx = string_len(msg)
		m_start = 1

		while not done do
			m_end = false
			for i=m_start,cx do
				if ((string_sub(msg,i,i)==delimiter and (i-m_start)<245)) or ((i-m_start<245) and i==cx) then
					m_end = i
				end
				if (i-m_start)>244 and not m_end then
					m_end = i
				end
			end
			newMsg = string_sub(msg,m_start,m_end)
			if (chatchan=="Self") and escapeColour then
				-- colour to our console
				newMsg = escapeColour..newMsg
			end
			print_chat(newMsg, chatchan, nil, chatnum)
			m_start = m_end+1
			if m_start>cx then
				done = true
			end
		end
	end

end

-- click on header on detail panel, dump that header info for all effects
function RecapOutgoingDetailHeader_OnClick(frame, button, down)

	local i, lineno, combatantName, iList
	local text, alltext = "",""
	local print_chat = SendChatMessage
	local chatchan, chatnum
	local maxLines = recap.Opt.MaxRank.value

	if IsShiftKeyDown() and (recap_temp.Selected ~= 0) and (recap_temp.OutgoingDetailsListSize>1) then

		if recap_temp.Selected == recap_temp.GroupIndex then
			combatantName = recap_temp.Localize.Group.." "..RECAP_COMBATANTS
		elseif recap_temp.Selected == recap_temp.NonGroupIndex then
			combatantName = recap_temp.Localize.NonGroup.." "..RECAP_COMBATANTS
		else
			combatantName = Recap_StripGUIDsFromCombatant(recap_temp.List[recap_temp.Selected].Name)
		end

		chatchan, chatnum = Recap_GetChannelInfo(nil, nil)
		if chatchan=="Self" then
			print_chat = Recap_Print
		end

		-- if the focus is on a WIM (WoW Instant Messenger) edit box, post there
		if WIM_EditBoxInFocus then
			print_chat = Recap_WIM_Print
		end

		-- If the Clip box on the Options : Reports panel is open, post there instead of to chat or console
		if RecapClipEditBox:IsVisible() then
			print_chat = Recap_LineToClipboard
			maxLines = recap_temp.MaxRecentEventLinesClipboard
		end

		alltext = "__ Recap ("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value].."): "..combatantName..": "..Recap_GetTooltip(recap.Opt.OutgoingPanelDetail.value).." __"
		lineno = 0
		print_chat(alltext, chatchan, nil, chatnum)
		for i=1, math_min(recap_temp.OutgoingDetailsListSize-1, maxLines) do
			iList = recap_temp.OutgoingDetailsList[i]
			if iList[recap.Opt.OutgoingPanelDetail.value]~="0.0%" and iList[recap.Opt.OutgoingPanelDetail.value]~="--" then
				local iType = string_sub(iList.Effect,1,1)
				text = Recap_StripOwnerAndGUIDsFromEffect(string_sub(iList.Effect,2))..": "..(((iType=="3") or (iType=="4")) and "+" or "")..iList[recap.Opt.OutgoingPanelDetail.value]..(recap.Opt.OutgoingPanelDetail.value=="Total" and (" ("..iList.TotalP.."%)") or "")
				lineno = lineno + 1
				text = tostring(lineno)..". "..text
				print_chat(text, chatchan, nil, chatnum)
			end
		end
	end
end

-- click on header on detail panel, dump that header info for all combatants
function RecapTargetDetailHeader_OnClick(frame, button, down)

	local i, lineno, combatantName, iList
	local text, alltext = "",""
	local print_chat = SendChatMessage
	local chatchan, chatnum
	local maxLines = recap.Opt.MaxRank.value

	if IsShiftKeyDown() and (recap_temp.Selected ~= 0) and (recap_temp.Selected ~= recap_temp.GroupIndex) and (recap_temp.Selected ~= recap_temp.NonGroupIndex) and (recap_temp.TargetDetailsListSize>1) and (recap.Opt.MatrixData.value) then

		combatantName = Recap_StripGUIDsFromCombatant(recap_temp.List[recap_temp.Selected].Name)

		chatchan, chatnum = Recap_GetChannelInfo(nil, nil)
		if chatchan=="Self" then
			print_chat = Recap_Print
		end

		-- if the focus is on a WIM (WoW Instant Messenger) edit box, post there
		if WIM_EditBoxInFocus then
			print_chat = Recap_WIM_Print
		end

		-- If the Clip box on the Options : Reports panel is open, post there instead of to chat or console
		if RecapClipEditBox:IsVisible() then
			print_chat = Recap_LineToClipboard
			maxLines = recap_temp.MaxRecentEventLinesClipboard
		end

		alltext = "__ Recap ("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value].."): "..combatantName..": "..Recap_GetTooltip("TargetTotal").." __"
		lineno = 0
		print_chat(alltext, chatchan, nil, chatnum)
		local transition = 0
		for i=1, math_min(recap_temp.TargetDetailsListSize-1, maxLines) do
			iList = recap_temp.TargetDetailsList[i]
			if iList.Total and iList.Total~="0.0%" and iList.Total~="--" then
				local iType = string_sub(iList.Whom,1,1)
				if (transition==0) and ((iType=="1") or (iType=="2")) then
					-- remember if we saw damage
					transition = 1
				end
				if (transition==1) and ((iType=="3") or (iType=="4")) then
					-- extra line between damage and healing
					print_chat("+", chatchan, nil, chatnum)
					transition = 2
				end
				text = string_sub(iList.Whom,2)..": "..(((iType=="3") or (iType=="4")) and "+" or "")..iList.Total.." ("..iList.TotalP.."%)"
				lineno = lineno + 1
				text = tostring(lineno)..". "..text
				print_chat(text, chatchan, nil, chatnum)
			end
		end
	end
end

-- click on header on detail panel, dump that header info for all effects
function RecapIncomingDetailHeader_OnClick(frame, button, down)

	local i, lineno, combatantName, iList
	local text, alltext = "",""
	local print_chat = SendChatMessage
	local chatchan, chatnum
	local maxLines = recap.Opt.MaxRank.value

	if IsShiftKeyDown() and (recap_temp.Selected ~= 0) and (recap_temp.IncomingDetailsListSize>1) then

		if recap_temp.Selected == recap_temp.GroupIndex then
			combatantName = recap_temp.Localize.Group.." "..RECAP_COMBATANTS
		elseif recap_temp.Selected == recap_temp.NonGroupIndex then
			combatantName = recap_temp.Localize.NonGroup.." "..RECAP_COMBATANTS
		else
			combatantName = Recap_StripGUIDsFromCombatant(recap_temp.List[recap_temp.Selected].Name)
		end

		chatchan, chatnum = Recap_GetChannelInfo(nil, nil)
		if chatchan=="Self" then
			print_chat = Recap_Print
		end

		-- if the focus is on a WIM (WoW Instant Messenger) edit box, post there
		if WIM_EditBoxInFocus then
			print_chat = Recap_WIM_Print
		end

		-- If the Clip box on the Options : Reports panel is open, post there instead of to chat or console
		if RecapClipEditBox:IsVisible() then
			print_chat = Recap_LineToClipboard
			maxLines = recap_temp.MaxRecentEventLinesClipboard
		end

		alltext = "__ Recap ("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value].."): "..combatantName..": "..RECAP_INCOMING.." "..Recap_GetTooltip(recap.Opt.IncomingPanelDetail.value).." __"
		lineno = 0
		print_chat(alltext, chatchan, nil, chatnum)
		for i=1, math_min(recap_temp.IncomingDetailsListSize-1, maxLines) do
			iList = recap_temp.IncomingDetailsList[i]
			if iList[recap.Opt.IncomingPanelDetail.value]~="0.0%" and iList[recap.Opt.IncomingPanelDetail.value]~="--" then
				local iType = string_sub(iList.Effect,1,1)
				text = Recap_StripOwnerAndGUIDsFromEffect(string_sub(iList.Effect,2))..": "..(((iType=="3") or (iType=="4")) and "+" or "")..iList[recap.Opt.IncomingPanelDetail.value]..(recap.Opt.IncomingPanelDetail.value=="Total" and (" ("..iList.TotalP.."%)") or "")
				lineno = lineno + 1
				text = tostring(lineno)..". "..text
				print_chat(text, chatchan, nil, chatnum)
			end
		end
	end
end

-- click on header on detail panel, dump that header info for all effects
function RecapSourceDetailHeader_OnClick(frame, button, down)

	local i, lineno, combatantName, iList
	local text, alltext = "",""
	local print_chat = SendChatMessage
	local chatchan, chatnum
	local maxLines = recap.Opt.MaxRank.value

	if IsShiftKeyDown() and (recap_temp.Selected ~= 0) and (recap_temp.Selected ~= recap_temp.GroupIndex) and (recap_temp.Selected ~= recap_temp.NonGroupIndex) and (recap_temp.SourceDetailsListSize>1) and (recap.Opt.MatrixData.value) then

		combatantName = Recap_StripGUIDsFromCombatant(recap_temp.List[recap_temp.Selected].Name)

		chatchan, chatnum = Recap_GetChannelInfo(nil, nil)
		if chatchan=="Self" then
			print_chat = Recap_Print
		end

		-- if the focus is on a WIM (WoW Instant Messenger) edit box, post there
		if WIM_EditBoxInFocus then
			print_chat = Recap_WIM_Print
		end

		-- If the Clip box on the Options : Reports panel is open, post there instead of to chat or console
		if RecapClipEditBox:IsVisible() then
			print_chat = Recap_LineToClipboard
			maxLines = recap_temp.MaxRecentEventLinesClipboard
		end

		alltext = "__ Recap ("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value].."): "..combatantName..": "..Recap_GetTooltip("SourceTotal").." __"
		lineno = 0
		print_chat(alltext, chatchan, nil, chatnum)
		local transition = 0
		for i=1, math_min(recap_temp.SourceDetailsListSize-1, maxLines) do
			iList = recap_temp.SourceDetailsList[i]
			if iList.Total and iList.Total~="0.0%" and iList.Total~="--" then
				local iType = string_sub(iList.Whom,1,1)
				if (transition==0) and ((iType=="1") or (iType=="2")) then
					-- remember if we saw damage
					transition = 1
				end
				if (transition==1) and ((iType=="3") or (iType=="4")) then
					-- extra line between damage and healing
					print_chat("+", chatchan, nil, chatnum)
					transition = 2
				end
				text = string_sub(iList.Whom,2)..": "..(((iType=="3") or (iType=="4")) and "+" or "")..iList.Total.." ("..iList.TotalP.."%)"
				lineno = lineno + 1
				text = tostring(lineno)..". "..text
				print_chat(text, chatchan, nil, chatnum)
			end
		end
	end
end

-- click on header on detail panel, dump that header info for all effects
function RecapOtherDetailHeader_Click(colName)

	local i, lineno, combatantName, iList
	local text, alltext = "",""
	local print_chat = SendChatMessage
	local chatchan, chatnum, iType, typeText
	local maxLines = recap.Opt.MaxRank.value

	if IsShiftKeyDown() and (recap_temp.Selected ~= 0) and (recap_temp.OtherDetailsListSize>1) and (recap.Opt.OtherData.value) then

		if recap_temp.Selected == recap_temp.GroupIndex then
			combatantName = recap_temp.Localize.Group.." "..RECAP_COMBATANTS
		elseif recap_temp.Selected == recap_temp.NonGroupIndex then
			combatantName = recap_temp.Localize.NonGroup.." "..RECAP_COMBATANTS
		else
			combatantName = Recap_StripGUIDsFromCombatant(recap_temp.List[recap_temp.Selected].Name)
		end

		chatchan, chatnum = Recap_GetChannelInfo(nil, nil)
		if chatchan=="Self" then
			print_chat = Recap_Print
		end

		-- if the focus is on a WIM (WoW Instant Messenger) edit box, post there
		if WIM_EditBoxInFocus then
			print_chat = Recap_WIM_Print
		end

		-- If the Clip box on the Options : Reports panel is open, post there instead of to chat or console
		if RecapClipEditBox:IsVisible() then
			print_chat = Recap_LineToClipboard
			maxLines = recap_temp.MaxRecentEventLinesClipboard
		end

		alltext = "__ Recap ("..Recap_PetsMergedText()..") ("..recap_temp.LastAll[recap.Opt.View.value].."): "..combatantName..": "..RECAP_OTHER_EFFECTS..": "..(((colName == "Hits") and RECAP_HITS) or ((colName == "Total") and RECAP_TOTAL)).." __"
		lineno = 0
		print_chat(alltext, chatchan, nil, chatnum)
		for i=1, math_min(recap_temp.OtherDetailsListSize-1, maxLines) do
			iList = recap_temp.OtherDetailsList[i]
			iType = string_sub(iList.Effect,1,1)
			typeText = recap_temp.Localize.OtherDetailType[tonumber(iType)]
			if (colName == "Hits") then
				text = typeText..": "..Recap_StripOwnerAndGUIDsFromEffect(string_sub(iList.Effect,2))..": "..iList.Hits
			elseif (colName == "Total") then
				text = typeText..": "..Recap_StripOwnerAndGUIDsFromEffect(string_sub(iList.Effect,2))..": "..iList.Total
				if iList.Attribute ~= "--" then
					text = text.." "..iList.Attribute
				end
			end
			lineno = lineno + 1
			text = tostring(lineno)..". "..text
			print_chat(text, chatchan, nil, chatnum)
		end
	end
end

RecapPanel_lua_411 = true
