﻿--[[ RecapOptions.lua ]]

local _G = getfenv(0)
local math_min = _G.math.min
local string_find = _G.string.find
local string_format = _G.string.format
local string_gsub = _G.string.gsub
local string_lower = _G.string.lower
local string_sub = _G.string.sub
local table_insert = _G.table.insert
local table_sort = _G.table.sort

-- knob=nil to use current values
local function set_anchor_buttons(knob)

	local _G = getfenv(0)

	RecapAnchorTopLeft:SetNormalTexture("Interface\\AddOns\\Recap\\Images\\Recap-Buttons-Down")
	RecapAnchorTopLeft:UnlockHighlight()
	RecapAnchorTopRight:SetNormalTexture("Interface\\AddOns\\Recap\\Images\\Recap-Buttons-Down")
	RecapAnchorTopRight:UnlockHighlight()
	RecapAnchorBottomLeft:SetNormalTexture("Interface\\AddOns\\Recap\\Images\\Recap-Buttons-Down")
	RecapAnchorBottomLeft:UnlockHighlight()
	RecapAnchorBottomRight:SetNormalTexture("Interface\\AddOns\\Recap\\Images\\Recap-Buttons-Down")
	RecapAnchorBottomRight:UnlockHighlight()

	if knob=="RecapAnchorTopLeft" then
		recap.Opt.GrowUpwards.value = false
		recap.Opt.GrowLeftwards.value = false
	elseif knob=="RecapAnchorTopRight" then
		recap.Opt.GrowUpwards.value = false
		recap.Opt.GrowLeftwards.value = true
	elseif knob=="RecapAnchorBottomLeft" then
		recap.Opt.GrowUpwards.value = true
		recap.Opt.GrowLeftwards.value = false
	elseif knob=="RecapAnchorBottomRight" then
		recap.Opt.GrowUpwards.value = true
		recap.Opt.GrowLeftwards.value = true
	else
		knob = "RecapAnchor"..(recap.Opt.GrowUpwards.value and "Bottom" or "Top")..(recap.Opt.GrowLeftwards.value and "Right" or "Left")
	end
	_G[knob]:SetNormalTexture("Interface\\AddOns\\Recap\\Images\\Recap-Buttons-Up")
	_G[knob]:LockHighlight()

	Recap_MoveMinimize()
	if recap.Opt.Minimized.value then
		Recap_Minimize()
	end
end

function Recap_InitializeOptions()

	local i, chatname, chatid, newScale
	local _G = getfenv(0)

	if not recap.Opt.AutoPost.Channel then
		recap.Opt.AutoPost.Channel = recap_temp.Localize.ChannelDropList[1] -- "Self" or equivalent
	end

	RecapAutoFadeSlider:SetValue(recap.Opt.AutoFadeTimer.value)
	RecapSetScaleSlider:SetValue(recap.Opt.SetScale.value)
	RecapIdleFightSlider:SetValue(recap.Opt.IdleFightTimer.value)
	RecapEndFightDelaySlider:SetValue(recap.Opt.EndFightDelay.value)
	-- slider, disabled if Recent Data Mode is active
	RecapRecentEventCountSlider:SetValue(recap.Opt.RecentEventCount.value)
	if recap.Opt.RecentData.value then
		RecapRecentEventCountSlider:EnableMouse(false)
	else
		RecapRecentEventCountSlider:EnableMouse(true)
	end
	RecapMaxRowsSlider:SetValue(recap.Opt.MaxRows.value)
	RecapMaxRankSlider:SetValue(recap.Opt.MaxRank.value)
	RecapOptTab1:LockHighlight()
	RecapOptSubFrame1:Show()

	RecapOpt_StatDropDownText:SetText(recap.Opt.AutoPost.Stat)

	-- the following, intended to pre-select the memorised channel, might fail with non-English clients since what is memorised is not canonical, and WoW goes with canonical
	_,_,chatid,chatname = string_find(recap.Opt.AutoPost.Channel, "(%d+)-(%w+)")
	if chatid and chatid~=GetChannelName(chatid) then
		recap.Opt.AutoPost.Channel = recap_temp.Localize.ChannelDropList[1] -- "Self" or equivalent
	end
	RecapOpt_ChannelDropDownText:SetText(recap.Opt.AutoPost.Channel)

	if recap.UseOneSettings then
		RecapOptCheck_UseOneSettings:SetChecked(1)
	else
		RecapOptCheck_UseOneSettings:SetChecked(0)
	end

	-- set check state for all checked options
	for i in pairs(recap.Opt) do
		if RecapOptFrame and recap.Opt[i] and recap.Opt[i].type=="Check" then
			if recap.Opt[i].value==true then
				_G["RecapOptCheck_"..i]:SetChecked(1)
			else
				_G["RecapOptCheck_"..i]:SetChecked(0)
			end
		end
	end

	-- set options for sync
	Recap_SetSyncDisplay()

	set_anchor_buttons()
end

function RecapOpt_OnMouseDown(frame, button)

	if recap_temp.Loaded and (button == "LeftButton") then
		RecapOptFrame:StartMoving()
	end
end

function RecapOpt_OnMouseUp(frame, button)

	if recap_temp.Loaded and (button == "LeftButton") then
		RecapOptFrame:StopMovingOrSizing()
	end
end

function Recap_AutoFadeSlider_OnValueChanged(frame, value)

	if recap_temp.Loaded and value then
		RecapAutoFadeSlider_Text:SetText(value.." "..recap_temp.Localize.Seconds)
		recap.Opt.AutoFadeTimer.value = value
	end
end

function Recap_SetScaleSlider_OnValueChanged(frame, value)

	local newValue, newScale

	if recap_temp.Loaded then
		newScale = Recap_Div2(value, 100)
		-- feedback on value, though underlying value will not change until mouseup
		RecapSetScaleSlider_Text:SetText(newScale)
	end
end

function Recap_SetScaleSlider_OnMouseUp(frame, button)

	local newValue, newScale

	if recap_temp.Loaded then

		newValue = RecapSetScaleSlider:GetValue()
		newScale = Recap_Div2(newValue,100)

		if (newValue ~= recap.Opt.SetScale.value) then
			-- only do all the update stuff if there is a scale change

			-- scale everything
			recap.Opt.SetScale.value = newValue
			RecapSetScaleSlider_Text:SetText(newScale)
			RecapFrame:SetScale(newScale)
			RecapOptFrame:SetScale(newScale)
			RecapPanel:SetScale(newScale)
			RecapRecent:SetScale(newScale)
			RecapMenu:SetScale(newScale)
			recap_temp.RecapTooltip:SetScale(newScale)

			-- because I haven't been able to figure out how to keep panels in a sensible position, move them to the centre of the screen
			RecapFrame:ClearAllPoints()
			RecapFrame:SetPoint("CENTER","UIParent","CENTER")
			RecapOptFrame:ClearAllPoints()
			RecapOptFrame:SetPoint("CENTER","UIParent","CENTER")
			RecapPanel:ClearAllPoints()
			if recap.Opt.PanelAnchor.value then
				RecapPanel:SetPoint(recap.Opt.PanelAnchor.Panel,"RecapFrame",recap.Opt.PanelAnchor.Main,Recap_PanelOffset("x"),Recap_PanelOffset("y"))
			else
				RecapPanel:SetPoint("CENTER","UIParent","CENTER")
			end
			RecapRecent:ClearAllPoints()
			if recap.Opt.RecentAnchor.value then
				RecapRecent:SetPoint(recap.Opt.RecentAnchor.Recent,"RecapFrame",recap.Opt.RecentAnchor.Main,Recap_RecentOffset("x"),Recap_RecentOffset("y"))
			else
				RecapRecent:SetPoint("CENTER","UIParent","CENTER")
			end

			-- other redisplay goodness
			recap.Opt.Pinned.value = false
			Recap_SetView()
			RecapFrame_Show()
			Recap_Maximize()
			RecapFrame:SetAlpha(1)
			recap_temp.FadeTimer = -1
		end
	end
end

function Recap_IdleFightSlider_OnValueChanged(frame, value)

	if recap_temp.Loaded and value then
		RecapIdleFightSlider_Text:SetText(value.." "..recap_temp.Localize.Seconds)
		recap.Opt.IdleFightTimer.value = value
	end
end

function Recap_EndFightDelaySlider_OnValueChanged(frame, value)

	if recap_temp.Loaded and value then
		RecapEndFightDelaySlider_Text:SetText(value.." "..recap_temp.Localize.Seconds)
		recap.Opt.EndFightDelay.value = value
	end
end

function Recap_RecentEventCountSlider_OnValueChanged(frame, value)

	if recap_temp.Loaded and value then
		RecapRecentEventCountSlider_Text:SetText(value.." "..recap_temp.Localize.Events)
		recap.Opt.RecentEventCount.value = value
	end
end

function Recap_MaxRowsSlider_OnValueChanged(frame, value)

	if recap_temp.Loaded and value then
		RecapMaxRowsSlider_Text:SetText(value.." "..recap_temp.Localize.Rows)
		recap.Opt.MaxRows.value = value
		if not recap.Opt.Minimized.value then
			RecapScrollBar_Update()
		end
	end
end

function Recap_MaxRankSlider_OnValueChanged(frame, value)

	if recap_temp.Loaded and value then
		RecapMaxRankSlider_Text:SetText(value)
		recap.Opt.MaxRank.value = value
	end
end


function RecapOptCheck_OnEnter()

	-- lock OnEnter-OnLeave events
	if recap_temp.OnEnterOnLeave == true then return end
	recap_temp.OnEnterOnLeave = true

	local id = this:GetID()
	Recap_MultilineTooltip(recap_temp.OptList[id][2], recap_temp.OptList[id][3])

	-- unlock OnEnter-OnLeave events
	recap_temp.OnEnterOnLeave = false
end

function RecapOptCheck_OnClick(frame, button, down)

	local i
	local id = this:GetID()
	local _G = getfenv(0)

	RecapSetEditBox:ClearFocus()

	if id>0 and recap_temp.OptList[id][1] then
		i = _G["RecapOptCheck_"..recap_temp.OptList[id][1]]:GetChecked()
		if i==1 then
			recap.Opt[recap_temp.OptList[id][1]].value = true
			PlaySound("igMainMenuOptionCheckBoxOn")
		else
			recap.Opt[recap_temp.OptList[id][1]].value = false
			PlaySound("igMainMenuOptionCheckBoxOff")
		end
		-- if display list or self checks
		if ((id>=11 and id<=16) or (id>=26 and id<=27) or (id>=30 and id<=34) or (id>=43 and id<=45) or (id==64) or (id>=70 and id<=71)) and not recap.Opt.SelfView.value and not recap.Opt.Minimized.value then
			Recap_Maximize()
		elseif ((id>=48 and id<=62) or (id==69) or (id>=80 and id<=86)) and recap.Opt.SelfView.value and not recap.Opt.Minimized.value then
			Recap_Maximize()
		-- if display minimized checks
		elseif ((id>=17 and id<=22) or id==36 or id==75 or id==89 or id==90) and recap.Opt.Minimized.value then
			Recap_Minimize()
		elseif recap_temp.OptList[id][1]=="UseColor" then
			Recap_SetColors()
			if not recap.Opt.Minimized.value then
				Recap_SetView()
			end
		elseif recap_temp.OptList[id][1]=="ShowTooltips" then
			recap_temp.RecapTooltip:Hide()
			Recap_Tooltip("ShowTooltips")
		elseif recap_temp.OptList[id][1]=="HideGroup" then
			Recap_SetView()
		elseif recap_temp.OptList[id][1]=="HideOthers" then
			Recap_SetView()
		elseif recap_temp.OptList[id][1]=="HideZero" then
			Recap_SetView()
		elseif recap_temp.OptList[id][1]=="HideYardTrash" then
			Recap_SetView()
		elseif recap_temp.OptList[id][1]=="StoreOnlyDisplayed" then
			-- not sure this is even necessary since it affects only future storage, and not immediate display
			Recap_SetView()
		elseif recap_temp.OptList[id][1]=="IdleFight" then
			if recap.Opt.State.value=="Active" then
				if recap.Opt.IdleFight.value then
					recap_temp.IdleTimer = 0
				else
					recap_temp.IdleTimer = -1
				end
			end
		elseif recap_temp.OptList[id][1]=="TooltipFollow" then
			Recap_Tooltip("TooltipFollow")
		elseif recap_temp.OptList[id][1]=="AutoHide" then
			if not recap.Opt.AutoHide.value then
				-- if we just turned the feature off, show the main frame regardless of combat status
				RecapFrame_Show()
			end
		elseif recap_temp.OptList[id][1]=="AutoFade" then
			recap_temp.FadeTimer = -1
		elseif recap_temp.OptList[id][1]=="MergePets" then
			if recap.Opt.MergePets.value then
				-- merging, nothing special to do
			else
				-- end of merge, remove any existing merged effects (but not if in synchronization)
				if not ((recap.Opt.SyncState.value == "Member") or (recap.Opt.SyncState.value == "Leader")) then
					Recap_RemovePetEffects()
					Recap_SetView()
				end
			end

		elseif recap_temp.OptList[id][1]=="IgnoreGUIDs" then
			if ((recap.Opt.SyncState.value == "Member") or (recap.Opt.SyncState.value == "Leader")) then
				-- ignore if in synchronization
				-- as with MergePets, there will be anomalies if a Saved Data Set is loaded from a different GUID choice
				recap.Opt.IgnoreGUIDs.value = not recap.Opt.IgnoreGUIDs.value
				if recap.Opt.IgnoreGUIDs.value then
					RecapOptCheck_IgnoreGUIDs:SetChecked(1)
				else
					RecapOptCheck_IgnoreGUIDs:SetChecked(0)
				end
				PlaySound("igQuestFailed")
				Recap_WarnNotAllowedDuringSync()
			else
				-- this option forces a Reset, so ask for confirmation
				if recap.Opt.IgnoreGUIDs.value then
					msg = recap_temp.Localize.ConfirmIgnoreGUIDs
				else
					msg = recap_temp.Localize.ConfirmUseGUIDs
				end
				StaticPopupDialogs["recap_temp.CONFIRMDATAMODE"] = {
					text = TEXT(msg),
					button1 = TEXT(ACCEPT),
					button2 = TEXT(CANCEL),
					OnAccept = function(self)
						if recap.Opt.IgnoreGUIDs.value then
							-- disallow sync
							recap.Opt.EnableSync.value = false
							recap.Opt.SyncState.value = "Ignore"
							recap.Opt.SyncTimestamp.value = false
							recap.Opt.SyncLeader.value = false
							recap.Opt.SyncMergePets.value = false
							recap.Opt.SyncUpdateWhen.value = false
							recap_temp.SyncInviteTimestamp = false
							recap_temp.SyncInviteLeader = false
							recap_temp.SyncInviteWhen = false
							recap_temp.SyncInviteNewOngoing = false
							recap_temp.AskingJoinSync = false
							recap_temp.SyncData = {}
							recap_temp.SyncMembers = {}
							recap_temp.OnCommReceived = false
							Recap_SetSyncDisplay()
							-- shortened player name
							recap_temp.PlayerGUID = recap_temp.Player
						else
							-- player name with GUID
							recap_temp.PlayerGUID = recap_temp.Player.."_"..Recap_TrimGUID((UnitGUID("player")))
						end
						-- force a Reset
						RecapPanel_Hide(1)
						RecapRecent_Hide(1)
						Recap_ResetAllCombatants(false)
						Recap_SetView()
						Recap_MakeFriends()
					end,
					OnHide = function(self)
						RecapOptCheck_IgnoreGUIDs:Enable()
					end,
					OnCancel = function(self)
						recap.Opt.IgnoreGUIDs.value = not recap.Opt.IgnoreGUIDs.value
						if recap.Opt.IgnoreGUIDs.value then
							RecapOptCheck_IgnoreGUIDs:SetChecked(1)
						else
							RecapOptCheck_IgnoreGUIDs:SetChecked(0)
						end
					end,
					timeout = 0,
					showAlert = 1,
					whileDead = 1
				}

				RecapOptCheck_IgnoreGUIDs:Disable()
				StaticPopup_Show("recap_temp.CONFIRMDATAMODE")
			end
			collectgarbage("collect")

		elseif recap_temp.OptList[id][1]=="GrowLeftwards" or recap_temp.OptList[id][1]=="GrowUpwards" or recap_temp.OptList[id][1]=="AutoMinimize" then
			Recap_MoveMinimize()
			if recap.Opt.Minimized.value then
				Recap_Minimize()
			end
		elseif recap_temp.OptList[id][1]=="ShowPanel" then
			if RecapPanel:IsVisible() then
				RecapPanel_Hide(1)
			end
		elseif recap_temp.OptList[id][1]=="OpaqueBackground" then
			Recap_SetRecapFrameBackdrop()
		elseif recap_temp.OptList[id][1]=="MinimizeOnEscape" then
			local k, m
			for k,m in ipairs(UISpecialFrames) do
				if recap.Opt.Minimized.value or not recap.Opt.MinimizeOnEscape.value then
					-- a dummy if we are minimized or have Minimize on Escape turned off, so that we don't capture Escape when minimized
					if m == "RecapFrame" then
						UISpecialFrames[k] = "RecapFrameDummy"
					end
				else
					if m == "RecapFrameDummy" then
						UISpecialFrames[k] = "RecapFrame"
					end
				end
			end

		elseif recap_temp.OptList[id][1]=="EnableSync" then
			if recap.Opt.IgnoreGUIDs.value then
				-- paranoia check, should in theory not get here
				recap.Opt.EnableSync.value = not recap.Opt.EnableSync.value
				if recap.Opt.EnableSync.value then
					RecapOptCheck_EnableSync:SetChecked(1)
				else
					RecapOptCheck_EnableSync:SetChecked(0)
				end
				PlaySound("igQuestFailed")
			else
				if recap.Opt.EnableSync.value then
					recap.Opt.SyncState.value = "Ready"
				else
					recap.Opt.SyncState.value = "Ignore"
				end
				-- clear all sync values (including the spinlocks)
				recap.Opt.SyncTimestamp.value = false
				recap.Opt.SyncLeader.value = false
				recap.Opt.SyncMergePets.value = false
				recap.Opt.SyncUpdateWhen.value = false
				recap_temp.SyncInviteTimestamp = false
				recap_temp.SyncInviteLeader = false
				recap_temp.SyncInviteWhen = false
				recap_temp.SyncInviteNewOngoing = false
				recap_temp.AskingJoinSync = false
				recap_temp.SyncData = {}
				recap_temp.SyncMembers = {}
				recap_temp.OnCommReceived = false
				Recap_SetSyncDisplay()
				Recap_SetState(false)
			end

		elseif recap_temp.OptList[id][1]=="LightData" then
			if recap.Opt.LightData.value then
				msg = recap_temp.Localize.ConfirmLightData
			else
				msg = recap_temp.Localize.ConfirmHeavyData
			end
			StaticPopupDialogs["recap_temp.CONFIRMDATAMODE"] = {
				text = TEXT(msg),
				button1 = TEXT(ACCEPT),
				button2 = TEXT(CANCEL),
				OnAccept = function(self)
					recap.DataVersion = recap.DataVersion - 0.01 -- force rebuild of data
					ReloadUI()
				end,
				OnHide = function(self)
					RecapOptCheck_LightData:Enable()
				end,
				OnCancel = function(self)
					recap.Opt.LightData.value = not recap.Opt.LightData.value
					if recap.Opt.LightData.value then
						RecapOptCheck_LightData:SetChecked(1)
					else
						RecapOptCheck_LightData:SetChecked(0)
					end
				end,
				timeout = 0,
				showAlert = 1,
				whileDead = 1
			}

			RecapOptCheck_LightData:Disable()
			StaticPopup_Show("recap_temp.CONFIRMDATAMODE")

		elseif recap_temp.OptList[id][1]=="RecentData" then
			if recap.Opt.State.value=="Active" then
				-- not permitted during combat
				recap.Opt.RecentData.value = not recap.Opt.RecentData.value
				if recap.Opt.RecentData.value then
					RecapOptCheck_RecentData:SetChecked(1)
				else
					RecapOptCheck_RecentData:SetChecked(0)
				end
				PlaySound("igQuestFailed")
				StaticPopupDialogs["recap_temp.CONFIRMDATAMODE"] = {
					text = TEXT(recap_temp.Localize.NotAllowedDuringCombat),
					button1 = TEXT(OKAY),
					OnAccept = function(self)
					end,
					timeout = 0,
					showAlert = 1,
					whileDead = 1
				}
				StaticPopup_Show("recap_temp.CONFIRMDATAMODE")
			else
				-- put into Stopped state for additional protection
				RecapUpdateFrame:Hide() -- disable OnUpdate
				local current_state = recap.Opt.State.value
				recap.Opt.State.value = "Stopped"

				if recap.Opt.RecentData.value then
					-- slider disabled while Recent Data Mode active (too messy to change circular buffer size dynamically)
					RecapRecentEventCountSlider:EnableMouse(false)
					Recap_CreateRecent()
					-- immediately enable all the recent event buttons
					for i=1,15 do
						_G["RecapRecentSelf"..i]:Enable()
						_G["RecapRecentList"..i]:Enable()
					end
					for i=1,7 do
						_G["RecapPanelIncomingRecent"..i]:Enable()
						_G["RecapPanelOutgoingRecent"..i]:Enable()
					end
				else
					RecapRecentEventCountSlider:EnableMouse(true)
					recap_temp.Recent = {}
				end

				-- go back to whatever we were doing
				recap.Opt.State.value = current_state
				RecapUpdateFrame:Show() -- enable OnUpdate
			end
			collectgarbage("collect")

		elseif recap_temp.OptList[id][1]=="ShowGauges" then
			if not recap.Opt.Minimized.value then
				RecapScrollBar_Update()
			end
		end
	end
end

function Recap_UseOneSettings_OnClick(frame, button, down)

	local i

	i = RecapOptCheck_UseOneSettings:GetChecked()
	if i==1 then
		recap.UseOneSettings = true
		PlaySound("igMainMenuOptionCheckBoxOn")
		msg = recap_temp.Localize.ConfirmGlobalSettings
	else
		recap.UseOneSettings = false
		PlaySound("igMainMenuOptionCheckBoxOff")
		msg = recap_temp.Localize.ConfirmSeparateSettings
	end

	StaticPopupDialogs["recap_temp.CONFIRMDATAMODE"] = {
		text = TEXT(msg),
		button1 = TEXT(ACCEPT),
		button2 = TEXT(CANCEL),
		OnAccept = function(self)

			if recap.UseOneSettings then
				local j,user

				for j in pairs(recap_set) do
					_,_,user = string_find(j, "^UserData:(.+)")
					if user and user~=recap_temp.p then
						recap_set["UserData:"..user] = nil -- keep as nil
						recap[user] = nil -- keep as nil
					end
				end
			end

			ReloadUI()
		end,
		OnHide = function(self)
			RecapOptCheck_UseOneSettings:Enable()
		end,
		OnCancel = function(self)
			recap.UseOneSettings = not recap.UseOneSettings
			if recap.UseOneSettings then
				RecapOptCheck_UseOneSettings:SetChecked(1)
			else
				RecapOptCheck_UseOneSettings:SetChecked(0)
			end
		end,
		timeout = 0,
		showAlert = 1,
		whileDead = 1
	}

	RecapOptCheck_UseOneSettings:Disable()
	StaticPopup_Show("recap_temp.CONFIRMDATAMODE")

end

--[[ Fight Data Set functions ]]

function Recap_InitDataSets()

	if RecapOptTitle then

		RecapFightDataSetHeader_Name:SetTextColor(recap_temp.ColorNone.r,recap_temp.ColorNone.g,recap_temp.ColorNone.b)
		RecapFightDataSetHeader_Date:SetTextColor(recap_temp.ColorNone.r,recap_temp.ColorNone.g,recap_temp.ColorNone.b)
		RecapFightDataSetHeader_Combatants:SetTextColor(recap_temp.ColorNone.r,recap_temp.ColorNone.g,recap_temp.ColorNone.b)

		RecapSaveAllButton:Disable()
		RecapSaveLastButton:Disable()
		RecapLoadButton:Disable()
		RecapDeleteButton:Disable()

		Recap_BuildFightSets()

		RecapOptTitle:SetFormattedText("%s v%.2f %s %s %s %s", recap_temp.Recap, Recap_Version, recap_temp.Localize.For, recap_temp.Player, recap_temp.Localize.Of, recap_temp.Server)
	end
end

function Recap_SetEditValidateButtons()

	local text

	if recap_temp.Loaded then

		text = RecapSetEditBox:GetText()

		if text and text~="" then
			RecapSaveAllButton:Enable()
			RecapSaveLastButton:Enable()
		else
			RecapSaveAllButton:Disable()
			RecapSaveLastButton:Disable()
			RecapLoadButton:Disable()
			RecapDeleteButton:Disable()
		end

		recap_temp.FightSetSelected = Recap_SetExists(text)
		RecapFightSetsScrollBar_Update()

		if recap_temp.FightSetSelected~=0 then
			RecapLoadButton:Enable()
			RecapDeleteButton:Enable()
		else
			RecapLoadButton:Disable()
			RecapDeleteButton:Disable()
		end
	end
end

-- populates recap_temp.FightSets with a list of existing fight sets
function Recap_BuildFightSets()

	local i, j, friendly

	-- make sure recap_temp.FightSets begins empty for 'table.sort'
	recap_temp.FightSetsSize = 1
	recap_temp.FightSets = {}

	if not recap_set then
		recap_set = {}
	end
	for i in pairs(recap_set) do
		if recap_set[i] and not string_find(i, "^UserData:") then
			if not recap_temp.FightSets[recap_temp.FightSetsSize] then
				recap_temp.FightSets[recap_temp.FightSetsSize] = {}
			end
			recap_temp.FightSets[recap_temp.FightSetsSize].Name = i
			recap_temp.FightSets[recap_temp.FightSetsSize].Date = recap_set[i].TimeStamp
			friendly = 0
			-- guard code
			if not recap_set[i].Combatant then
				recap_set[i].Combatant = {}
			end
			for j in pairs(recap_set[i].Combatant) do
				if string_find(recap_set[i].Combatant[j], "^true") then
					friendly = friendly + 1
				end
			end
			recap_temp.FightSets[recap_temp.FightSetsSize].Combatants = recap_set[i].ListSize .. " ("..friendly..")"
			recap_temp.FightSetsSize = recap_temp.FightSetsSize + 1
		end
	end

	table_sort(recap_temp.FightSets,Recap_SetSort)
end

function RecapFightSetsScrollBar_Update()

	local i, index, item
	local _G = getfenv(0)

	if recap_temp.Loaded then

		FauxScrollFrame_Update(RecapFightSetsScrollBar,recap_temp.FightSetsSize-1,10,12)

		for i=1,10 do
			index = i + FauxScrollFrame_GetOffset(RecapFightSetsScrollBar)
			if index < recap_temp.FightSetsSize then
				_G["RecapList"..i.."Back"]:Hide()
				_G["RecapFightDataList"..i.."_Name"]:SetText(recap_temp.FightSets[index].Name)
				_G["RecapFightDataList"..i.."_Date"]:SetText(recap_temp.FightSets[index].Date)
				_G["RecapFightDataList"..i.."_Combatants"]:SetText(recap_temp.FightSets[index].Combatants)
				item = _G["RecapFightDataList"..i]
				item:Show()
				if recap_temp.FightSetSelected == index then
					item:LockHighlight()
				else
					item:UnlockHighlight()
				end
			else
				item = _G["RecapFightDataList"..i]
				item:Hide()
				item:UnlockHighlight()
				_G["RecapList"..i.."Back"]:Show()
			end
		end
	end
end

function RecapFightData_OnClick(frame, button, down)

	local id = this:GetID()

	RecapSetEditBox:ClearFocus()

	index = id + FauxScrollFrame_GetOffset(RecapFightSetsScrollBar)

	if index < recap_temp.FightSetsSize then
		recap_temp.FightSetSelected = index
		RecapSetEditBox:SetText(recap_temp.FightSets[index].Name)
		RecapSaveAllButton:Enable()
		RecapSaveLastButton:Enable()
		RecapLoadButton:Enable()
		RecapDeleteButton:Enable()
		RecapFightSetsScrollBar_Update()
	end
end

function Recap_SetExists(text)

	local i
	local result = 0

	for i in pairs(recap_temp.FightSets) do
		if recap_temp.FightSets[i].Name == text then
			result = i
		end
	end

	return result
end

-- fight data set sort (by date)
function Recap_SetSort(e1,e2)

	if not e1.Date then
		return false
	end
	if not e2.Date then
		return false
	end

	if ( e1.Date > e2.Date ) then
		return true
	else
		return false
	end
end

--[[ Options tabs ]]

function RecapOptTab_OnEnter()

	-- lock OnEnter-OnLeave events
	if recap_temp.OnEnterOnLeave == true then return end
	recap_temp.OnEnterOnLeave = true

	id = this:GetID()

	if id and id>0 then
		Recap_Tooltip("OptTab"..id)
	end

	-- unlock OnEnter-OnLeave events
	recap_temp.OnEnterOnLeave = false
end

function RecapOptTab_OnClick(frame, button, down)

	local id, i = this:GetID()
	local _G = getfenv(0)

	PlaySound("GAMEGENERICBUTTONPRESS")
	if id and id>0 then
		for i=1,5 do
			_G["RecapOptTab"..i]:UnlockHighlight()
			_G["RecapOptSubFrame"..i]:Hide()
		end
		RecapOptClipFrame:Hide()
		_G["RecapOptTab"..id]:LockHighlight()
		_G["RecapOptSubFrame"..id]:Show()
		Recap_SetSyncDisplay()
	end
end

--[[ drop down lists ]]

function RecapDropMenu_OnClick(frame, button, down)

	local id = this:GetID()
	local _G = getfenv(0)

	if recap_temp.CurrentDrop==RecapOpt_StatDropDownButton then
		recap.Opt.AutoPost.Stat = _G["RecapDropMenu"..id.."_Text"]:GetText()
		RecapOpt_StatDropDownText:SetText(recap.Opt.AutoPost.Stat)
	else
		recap.Opt.AutoPost.Channel = _G["RecapDropMenu"..id.."_Text"]:GetText()
		RecapOpt_ChannelDropDownText:SetText(recap.Opt.AutoPost.Channel)
	end
	Recap_DropMenu:Hide()
	recap_temp.CurrentDrop = false

end

function RecapDropMenu_OnEnter()

end

function Recap_ToggleDropDown()

	if Recap_DropMenu:IsVisible() and recap_temp.CurrentDrop==this then
		Recap_DropMenu:Hide()
		recap_temp.CurrentDrop = nil
	elseif recap_temp.CurrentDrop~=this and this==RecapOpt_StatDropDownButton then
		Recap_ShowStatDrop()
		recap_temp.CurrentDrop = this
	elseif recap_temp.CurrentDrop~=this then
		Recap_ShowChannelDrop()
		recap_temp.CurrentDrop = this
	end

end

function Recap_ShowStatDrop()

	Recap_DropMenu:ClearAllPoints()
	Recap_DropMenu:SetPoint("TOPLEFT","RecapOpt_StatDropDown","BOTTOMLEFT",16,8)
	-- governs the width of the box within which the text will appear when dropped down
	Recap_DropMenu:SetWidth(130)
	Recap_PopulateDrop(recap_temp.Localize.StatDropList)
end

function Recap_ShowChannelDrop()

	local i, j
	local new_list = {}

	Recap_DropMenu:ClearAllPoints()
	Recap_DropMenu:SetPoint("TOPLEFT","RecapOpt_ChannelDropDown","BOTTOMLEFT",16,8)
	-- governs the width of the box within which the text will appear when dropped down
	Recap_DropMenu:SetWidth(130)

	for i=1,#recap_temp.Localize.ChannelDropList do
		table_insert(new_list,recap_temp.Localize.ChannelDropList[i])
	end
	for i=1,10 do
		c,name = GetChannelName(i)
		if name then
			for j=1,#recap_temp.Localize.SkipChannels do
				if string_find(name, recap_temp.Localize.SkipChannels[j], 1, true) then
					name = false
					break
				end
			end
		end
		if name then
			table_insert(new_list,c.."-"..name)
		end
	end
	Recap_PopulateDrop(new_list)
end

function Recap_PopulateDrop(thisList)

	local i
	local height = 0
	local _G = getfenv(0)

	for i=1,math_min(8,#thisList) do
		-- see also Recap_DropMenuTemplate in RecapOptions.xml
		_G["RecapDropMenu"..i.."_Text"]:SetText(tostring(thisList[i]))
		-- governs how wide the text is, and whether the text gets truncated
		_G["RecapDropMenu"..i.."_Text"]:SetWidth(120)
		_G["RecapDropMenu"..i]:Show()
		height = height + 16
	end
	for i=#thisList+1,8 do
		_G["RecapDropMenu"..i]:Hide()
	end

	Recap_DropMenu:SetHeight(height+4)
	Recap_DropMenu:Show()
end

function RecapDropMenu_OnUpdate(frame, elapsed)

	if not recap_temp.MenuTimer or MouseIsOver(Recap_DropMenu) or
		(recap_temp.CurrentDrop and MouseIsOver(recap_temp.CurrentDrop)) then
		recap_temp.MenuTimer = 0
	end

	recap_temp.MenuTimer = recap_temp.MenuTimer + elapsed
	if recap_temp.MenuTimer > 0.5 then
		recap_temp.MenuTimer = 0
		Recap_DropMenu:Hide()
		recap_temp.CurrentDrop = false
	end
end

local function logLine(thisIndex, clip)

	local lineformat = recap_temp.Localize.LogFormat
	local str, iIndex

	if thisIndex=="FirstLine" then
		str = string_format(lineformat,recap_temp.Localize.Log[1],
							  recap_temp.Localize.Log[2],
							  recap_temp.Localize.Log[3],
							  recap_temp.Localize.Log[4],
							  recap_temp.Localize.Log[5],
							  recap_temp.Localize.Log[6],
							  recap_temp.Localize.Log[7],
							  recap_temp.Localize.Log[8],
							  recap_temp.Localize.Log[9],
							  recap_temp.Localize.Log[10],
							  recap_temp.Localize.Log[11],
							  recap_temp.Localize.Log[12],
							  recap_temp.Localize.Log[13],
							  recap_temp.Localize.Log[14],
							  recap_temp.Localize.Log[15])
	elseif thisIndex=="Spacer" then
		str = " "
	else
		iIndex = recap_temp.List[thisIndex]
		str = string_format(lineformat,
							Recap_StripGUIDsFromCombatant(iIndex.Name),
							Recap_FormatLevel(recap.Combatant[iIndex.Name].Level),
							Recap_FormatClass(recap.Combatant[iIndex.Name].Class),
							Recap_FormatTime(iIndex.Time),
							Recap_FormatTime(iIndex.TimeIn),
							Recap_FormatTime(iIndex.TimeHeal),
							iIndex.Heal,
							iIndex.HealP.."%%",
							iIndex.DmgIn,
							iIndex.DmgInP.."%%",
							string_format("%.1f",iIndex.DPSIn),
							iIndex.DmgOut,
							iIndex.DmgOutP.."%%",
							iIndex.MaxHit,
							string_format("%.1f",iIndex.DPS))
	end

	if str then
		if clip then
			str = str.."\n"
			str = string_gsub(str,"%%%%","%%")
		end
		return str
	end
end

-- HTML logLine split into two functions to send a single table row as two lines (due to ChatThrottleLib max limit 255 bytes)
local function loglineHTML1(thisIndex, clip)

	local lineformat = recap_temp.Localize.HTMLFormat1
	local str, iIndex
	local prefix = "<b>"
	local suffix = "</b>"

	if thisIndex=="FirstLine" then
		str = string_format(lineformat,prefix..recap_temp.Localize.Log[1]..suffix,
							  prefix..recap_temp.Localize.Log[2]..suffix,
							  prefix..recap_temp.Localize.Log[3]..suffix,
							  prefix..recap_temp.Localize.Log[4]..suffix,
							  prefix..recap_temp.Localize.Log[5]..suffix,
							  prefix..recap_temp.Localize.Log[6]..suffix,
							  prefix..recap_temp.Localize.Log[7]..suffix)
	elseif thisIndex=="Spacer" then
		str = string_format(lineformat," "," "," "," "," "," "," ")
	else
		iIndex = recap_temp.List[thisIndex]
		str = string_format(lineformat,
							Recap_StripGUIDsFromCombatant(iIndex.Name),
							Recap_FormatLevel(recap.Combatant[iIndex.Name].Level),
							Recap_FormatClass(recap.Combatant[iIndex.Name].Class),
							Recap_FormatTime(iIndex.Time),
							Recap_FormatTime(iIndex.TimeIn),
							Recap_FormatTime(iIndex.TimeHeal),
							iIndex.Heal)
	end

	if str then
		if clip then
			str = string_gsub(str,"%%%%","%%")
		end
		return str
	end
end
local function loglineHTML2(thisIndex, clip)

	local lineformat = recap_temp.Localize.HTMLFormat2
	local str, iIndex
	local prefix = "<b>"
	local suffix = "</b>"

	if thisIndex=="FirstLine" then
		str = string_format(lineformat,prefix..recap_temp.Localize.Log[8]..suffix,
							  prefix..recap_temp.Localize.Log[9]..suffix,
							  prefix..recap_temp.Localize.Log[10]..suffix,
							  prefix..recap_temp.Localize.Log[11]..suffix,
							  prefix..recap_temp.Localize.Log[12]..suffix,
							  prefix..recap_temp.Localize.Log[13]..suffix,
							  prefix..recap_temp.Localize.Log[14]..suffix,
							  prefix..recap_temp.Localize.Log[15]..suffix)
	elseif thisIndex=="Spacer" then
		str = string_format(lineformat," "," "," "," "," "," "," "," ")
	else
		iIndex = recap_temp.List[thisIndex]
		str = string_format(lineformat,
							iIndex.HealP.."%%",
							iIndex.DmgIn,
							iIndex.DmgInP.."%%",
							string_format("%.1f",iIndex.DPSIn),
							iIndex.DmgOut,
							iIndex.DmgOutP.."%%",
							iIndex.MaxHit,
							string_format("%.1f",iIndex.DPS))
	end

	if str then
		if clip then
			str = str.."\n"
			str = string_gsub(str,"%%%%","%%")
		end
		return str
	end
end

function Recap_ReportFightsToClipboard()

	local i, donegroup, thisCombatant
	local headerformat = recap_temp.Localize.LogHeader

	RecapClipEditBox:SetText("")
	RecapOptSubFrame4:Hide()
	RecapOptClipFrame:Show()
	RecapClipEditBox:SetFocus()

	if recap.Opt.HTML.value then
		headerformat = recap_temp.Localize.HTMLHeader
		RecapClipEditBox:Insert(recap_temp.Localize.HTMLPrefix)
	end

	RecapClipEditBox:Insert(string_format(headerformat,Recap_Version,Recap_PetsMergedText(),recap_temp.Player,recap_temp.LastAll[recap.Opt.View.value],date("%Y-%b-%d %H:%M"),GetRealZoneText()).."\n")
	if recap.Opt.HTML.value then
		-- for HTML send as two lines to get around ChatThrottleLib 255 byte limit
		RecapClipEditBox:Insert(loglineHTML1("FirstLine","clip"))
		RecapClipEditBox:Insert(loglineHTML2("FirstLine","clip"))
	else
		RecapClipEditBox:Insert(logLine("FirstLine","clip"))
	end

	for i=1,recap_temp.ListSize-1 do

		thisCombatant = recap_temp.List[i].Name
		if (not donegroup) and thisCombatant and recap.Combatant[thisCombatant] and (not recap.Combatant[thisCombatant].Friend) then
			if not recap.Opt.WriteGroup.value then
				if recap.Opt.HTML.value then
					-- for HTML send as two lines to get around ChatThrottleLib 255 byte limit
					RecapClipEditBox:Insert(loglineHTML1("Spacer","clip"))
					RecapClipEditBox:Insert(loglineHTML2("Spacer","clip"))
				else
					RecapClipEditBox:Insert(logLine("Spacer","clip"))
				end
			end
			donegroup = true
		end

		if not donegroup or not recap.Opt.WriteGroup.value then
			if recap.Opt.HTML.value then
				-- for HTML send as two lines to get around ChatThrottleLib 255 byte limit
				RecapClipEditBox:Insert(loglineHTML1(i,"clip"))
				RecapClipEditBox:Insert(loglineHTML2(i,"clip"))
			else
				RecapClipEditBox:Insert(logLine(i,"clip"))
			end
		end
	end

	if recap.Opt.HTML.value then
		RecapClipEditBox:Insert(recap_temp.Localize.HTMLSuffix)
	end

	RecapExitButton:Hide()
	RecapClipEditBox:HighlightText()

end

local function outgoingeffectline(i,clip)

	local lineformat = recap_temp.Localize.DetailFormat
	local str, iIndex

	if i=="FirstLine" then
		str = string_format(lineformat,recap_temp.Localize.Detail[1],
							  recap_temp.Localize.Detail[2],
							  recap_temp.Localize.Detail[3],
							  recap_temp.Localize.Detail[4],
							  recap_temp.Localize.Detail[5],
							  recap_temp.Localize.Detail[6],
							  recap_temp.Localize.Detail[7],
							  recap_temp.Localize.Detail[8],
							  recap_temp.Localize.Detail[9],
							  recap_temp.Localize.Detail[10],
							  recap_temp.Localize.Detail[11],
							  recap_temp.Localize.Detail[12],
							  recap_temp.Localize.Detail[13],
							  recap_temp.Localize.Detail[14],
							  recap_temp.Localize.Detail[15],
							  recap_temp.Localize.Detail[16],
							  recap_temp.Localize.Detail[17],
							  recap_temp.Localize.Detail[18],
							  recap_temp.Localize.Detail[19],
							  recap_temp.Localize.Detail[20],
							  recap_temp.Localize.Detail[21],
							  recap_temp.Localize.Detail[22],
							  recap_temp.Localize.Detail[23],
							  recap_temp.Localize.Detail[24])
	else
		iIndex = recap_temp.SelfList[i]
		str = string_format(lineformat,
							string_sub(iIndex.EName,2)..(((string_sub(iIndex.EName,1,1)>="3") and "+") or ""),
							iIndex.EElement,
							iIndex.ETotal,
							iIndex.ETotalP,
							iIndex.EMaxAll,
							iIndex.EGlances,
							iIndex.EGlancesMin,
							iIndex.EGlancesAvg,
							iIndex.EGlancesMax,
							iIndex.EHits,
							iIndex.EHitsMin,
							iIndex.EHitsAvg,
							iIndex.EHitsMax,
							iIndex.ETicks,
							iIndex.ETicksMin,
							iIndex.ETicksAvg,
							iIndex.ETicksMax,
							iIndex.ECrits,
							iIndex.ECritsMin,
							iIndex.ECritsAvg,
							iIndex.ECritsMax,
							iIndex.ECritsP,
							iIndex.EMiss,
							iIndex.EMissP)
	end

	if str then
		if clip then
			str = str.."\n"
			str = string_gsub(str,"%%%%","%%")
		end
		return str
	end
end

-- HTML logLine split into three functions to send a single table row as three lines (due to ChatThrottleLib max limit 255 bytes)
local function outgoingeffectlineHTML1(i, clip)

	local lineformat = recap_temp.Localize.HTMLDetailFormat1
	local str, iIndex
	local prefix = "<b>"
	local suffix = "</b>"

	if i=="FirstLine" then
		str = string_format(lineformat,prefix..recap_temp.Localize.Detail[1]..suffix,
							  prefix..recap_temp.Localize.Detail[2]..suffix,
							  prefix..recap_temp.Localize.Detail[3]..suffix,
							  prefix..recap_temp.Localize.Detail[4]..suffix,
							  prefix..recap_temp.Localize.Detail[5]..suffix,
							  prefix..recap_temp.Localize.Detail[6]..suffix,
							  prefix..recap_temp.Localize.Detail[7]..suffix,
							  prefix..recap_temp.Localize.Detail[8]..suffix)
	else
		iIndex = recap_temp.SelfList[i]
		str = string_format(lineformat,
							string_sub(iIndex.EName,2)..(((string_sub(iIndex.EName,1,1)>="3") and "+") or ""),
							iIndex.EElement,
							iIndex.ETotal,
							iIndex.ETotalP,
							iIndex.EMaxAll,
							iIndex.EGlances,
							iIndex.EGlancesMin,
							iIndex.EGlancesAvg)
	end

	if str then
		if clip then
			str = string_gsub(str,"%%%%","%%")
		end
		return str
	end
end
local function outgoingeffectlineHTML2(i, clip)

	local lineformat = recap_temp.Localize.HTMLDetailFormat2
	local str, iIndex
	local prefix = "<b>"
	local suffix = "</b>"

	if i=="FirstLine" then
		str = string_format(lineformat,
							  prefix..recap_temp.Localize.Detail[9]..suffix,
							  prefix..recap_temp.Localize.Detail[10]..suffix,
							  prefix..recap_temp.Localize.Detail[11]..suffix,
							  prefix..recap_temp.Localize.Detail[12]..suffix,
							  prefix..recap_temp.Localize.Detail[13]..suffix,
							  prefix..recap_temp.Localize.Detail[14]..suffix,
							  prefix..recap_temp.Localize.Detail[15]..suffix,
							  prefix..recap_temp.Localize.Detail[16]..suffix)
	else
		iIndex = recap_temp.SelfList[i]
		str = string_format(lineformat,
							iIndex.EGlancesMax,
							iIndex.EHits,
							iIndex.EHitsMin,
							iIndex.EHitsAvg,
							iIndex.EHitsMax,
							iIndex.ETicks,
							iIndex.ETicksMin,
							iIndex.ETicksAvg)
	end

	if str then
		if clip then
			str = string_gsub(str,"%%%%","%%")
		end
		return str
	end
end
local function outgoingeffectlineHTML3(i, clip)

	local lineformat = recap_temp.Localize.HTMLDetailFormat3
	local str, iIndex
	local prefix = "<b>"
	local suffix = "</b>"

	if i=="FirstLine" then
		str = string_format(lineformat,
							  prefix..recap_temp.Localize.Detail[17]..suffix,
							  prefix..recap_temp.Localize.Detail[18]..suffix,
							  prefix..recap_temp.Localize.Detail[19]..suffix,
							  prefix..recap_temp.Localize.Detail[20]..suffix,
							  prefix..recap_temp.Localize.Detail[21]..suffix,
							  prefix..recap_temp.Localize.Detail[22]..suffix,
							  prefix..recap_temp.Localize.Detail[23]..suffix,
							  prefix..recap_temp.Localize.Detail[24]..suffix)
	else
		iIndex = recap_temp.SelfList[i]
		str = string_format(lineformat,
							iIndex.ETicksMax,
							iIndex.ECrits,
							iIndex.ECritsMin,
							iIndex.ECritsAvg,
							iIndex.ECritsMax,
							iIndex.ECritsP,
							iIndex.EMiss,
							iIndex.EMissP)
	end

	if str then
		if clip then
			str = str.."\n"
			str = string_gsub(str,"%%%%","%%")
		end
		return str
	end
end

function Recap_ReportDetailsToClipboard()

	local i
	local headerformat = recap_temp.Localize.DetailHeader

	RecapClipEditBox:SetText("")
	RecapOptSubFrame4:Hide()
	RecapOptClipFrame:Show()
	RecapClipEditBox:SetFocus()

	if recap.Opt.HTML.value then
		headerformat = recap_temp.Localize.HTMLDetailHeader
		RecapClipEditBox:Insert(recap_temp.Localize.HTMLPrefix)
	end

	RecapClipEditBox:Insert(string_format(headerformat,"("..Recap_PetsMergedText()..")",recap_temp.Player,date("%Y-%b-%d %H:%M"),GetRealZoneText()).."\n")
	if recap.Opt.HTML.value then
		-- for HTML send as three lines to get around ChatThrottleLib 255 byte limit
		RecapClipEditBox:Insert(outgoingeffectlineHTML1("FirstLine","clip"))
		RecapClipEditBox:Insert(outgoingeffectlineHTML2("FirstLine","clip"))
		RecapClipEditBox:Insert(outgoingeffectlineHTML3("FirstLine","clip"))
	else
		RecapClipEditBox:Insert(outgoingeffectline("FirstLine","clip"))
	end

	for i=1,recap_temp.SelfListSize-1 do
		if recap.Opt.HTML.value then
			-- for HTML send as three lines to get around ChatThrottleLib 255 byte limit
			RecapClipEditBox:Insert(outgoingeffectlineHTML1(i,"clip"))
			RecapClipEditBox:Insert(outgoingeffectlineHTML2(i,"clip"))
			RecapClipEditBox:Insert(outgoingeffectlineHTML3(i,"clip"))
		else
			RecapClipEditBox:Insert(outgoingeffectline(i,"clip"))
		end
	end

	if recap.Opt.HTML.value then
		RecapClipEditBox:Insert(recap_temp.Localize.HTMLSuffix)
	end

	RecapExitButton:Hide()
	RecapClipEditBox:HighlightText()

end

function Recap_LineToClipboard(msg)
	RecapClipEditBox:Insert(msg.."\n")
end

-- a single WriteLog function has been split into Open, ReportToLog, and Close
function Recap_OpenLog()

	local i, chatnum, chatname, freeslot, alreadyin
	local logchat = "recaplog"..string_lower(recap_temp.Player)

	freeslot = false
	alreadyin = false
	recap_temp.LogChatnum = false
	for i=1,10 do
		_,chatname = GetChannelName(i)
		if not chatname then
			freeslot = true
		elseif string_lower(chatname)==logchat then
			alreadyin = true
		end
	end
	if alreadyin then
		chatnum = false
		for i=1,10 do
			j,chatname = GetChannelName(i)
			if chatname and string_lower(chatname)==logchat then
				chatnum=j
				break
			end
		end
		if chatnum then
			recap_temp.LogChatnum = chatnum
			-- begin logging to WOWChatLog.txt
			if LoggingChat() then
				-- already on
			else
				-- toggle on
				LoggingChat(true)
			end
			-- allow Report and Close buttons
			RecapOpenLogButton:SetText(RECAP_CHANNEL_JOINED)
			RecapOpenLogButton:Disable()
			RecapReportToLogButton:Enable()
			RecapCloseLogButton:Enable()
		else
			-- something wrong
			DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.NoChannelNumber)
			RecapOpenLogButton:Enable()
		end
	else
		if freeslot then
			RecapFrame:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE")
			JoinChannelByName(logchat)
			RecapOpenLogButton:SetText(RECAP_ACQUIRING_CHANNEL)
		else
			DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.NoFreeChannels)
			RecapOpenLogButton:Enable()
		end
	end

end

function Recap_ReportToLog()

	local i, donegroup, thisCombatant
	local lines = 0
	local headerformat = recap_temp.Localize.LogHeader
	local prefix, suffix = "", ""

	if recap_temp.LogChatnum then

		if recap.Opt.HTML.value then
			headerformat = recap_temp.Localize.HTMLHeader
			prefix = "-->"
			suffix = "<!--"
			ChatThrottleLib:SendChatMessage("BULK", "Recap", recap_temp.Localize.HTMLPrefix..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
		end

		-- we're in a channel
		ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..string_format(headerformat,Recap_Version,Recap_PetsMergedText(),recap_temp.Player,recap_temp.LastAll[recap.Opt.View.value],date("%Y-%b-%d %H:%M"),GetRealZoneText())..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
		if recap.Opt.HTML.value then
			-- for HTML send as two lines to get around ChatThrottleLib 255 byte limit
			ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..loglineHTML1("FirstLine")..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
			ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..loglineHTML2("FirstLine")..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
		else
			ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..logLine("FirstLine")..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
		end

		for i=1,recap_temp.ListSize-1 do

			if lines < recap_temp.MaxLogLines then
				thisCombatant = recap_temp.List[i].Name
				if (not donegroup) and thisCombatant and recap.Combatant[thisCombatant] and (not recap.Combatant[thisCombatant].Friend) then
					if not recap.Opt.WriteGroup.value then
						if recap.Opt.HTML.value then
							-- for HTML send as two lines to get around ChatThrottleLib 255 byte limit
							ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..loglineHTML1("Spacer")..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
							ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..loglineHTML2("Spacer")..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
						else
							ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..logLine("Spacer")..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
						end
					end
					donegroup = true
				end

				if not donegroup or not recap.Opt.WriteGroup.value then
					if recap.Opt.HTML.value then
						-- for HTML send as two lines to get around ChatThrottleLib 255 byte limit
						ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..loglineHTML1(i)..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
						ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..loglineHTML2(i)..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
					else
						ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..logLine(i)..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
					end
				end

				lines = lines + 1
			end
		end

		if recap.Opt.HTML.value then
			ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..recap_temp.Localize.HTMLSuffix, "CHANNEL", nil, recap_temp.LogChatnum)
		end

		-- and again for the details
		headerformat = recap_temp.Localize.DetailHeader

		if recap.Opt.HTML.value then
			headerformat = recap_temp.Localize.HTMLDetailHeader
			prefix = "-->"
			suffix = "<!--"
			ChatThrottleLib:SendChatMessage("BULK", "Recap", recap_temp.Localize.HTMLPrefix..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
		end

		-- we're in a channel
		ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..string_format(headerformat,"("..Recap_PetsMergedText()..")",recap_temp.Player,date("%Y-%b-%d %H:%M"),GetRealZoneText())..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
		if recap.Opt.HTML.value then
			-- for HTML send as three lines to get around ChatThrottleLib 255 byte limit
			ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..outgoingeffectlineHTML1("FirstLine")..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
			ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..outgoingeffectlineHTML2("FirstLine")..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
			ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..outgoingeffectlineHTML3("FirstLine")..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
		else
			ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..outgoingeffectline("FirstLine")..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
		end

		for i=1,recap_temp.SelfListSize-1 do
			if recap.Opt.HTML.value then
				-- for HTML send as three lines to get around ChatThrottleLib 255 byte limit
				ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..outgoingeffectlineHTML1(i)..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
				ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..outgoingeffectlineHTML2(i)..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
				ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..outgoingeffectlineHTML3(i)..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
			else
				ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..outgoingeffectline(i)..suffix, "CHANNEL", nil, recap_temp.LogChatnum)
			end
		end

		if recap.Opt.HTML.value then
			ChatThrottleLib:SendChatMessage("BULK", "Recap", prefix..recap_temp.Localize.HTMLSuffix, "CHANNEL", nil, recap_temp.LogChatnum)
		end

		DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.LogWritten)
	end

end

function Recap_CloseLog()

	if not LoggingChat() then
		-- already off
	else
		-- toggle off
		LoggingChat(true)
	end
	LeaveChannelByName("recaplog"..recap_temp.Player)
	RecapOpenLogButton:SetText(RECAP_OPEN_WOWCHATLOG_TXT)
	RecapOpenLogButton:Enable()
	RecapReportToLogButton:Disable()
	RecapCloseLogButton:Disable()

end

function Recap_FormatLevel(level)

	if level and tonumber(level)>0 then
		return level
	elseif level and tonumber(level)==-1 then
		return "??"
	else
		return ""
	end
end

function Recap_FormatClass(class)

	if class and recap_temp.Localize.ClassAbbr[class] then
		return recap_temp.Localize.ClassAbbr[class]
	else
		return ""
	end
end

-- removes character-specific
function Recap_UseOneSettings()

	local i

	for i in pairs(recap_set) do
		_,_,user = string_find(i, "^UserData:(.+)")
		if user and user~=recap_temp.p then
			recap_set["UserData:"..user] = nil -- keep as nil
			recap[user] = nil -- keep as nil
		end
	end
	recap.UseOneSettings = true

end

function RecapAnchor_OnEnter()

	-- lock OnEnter-OnLeave events
	if recap_temp.OnEnterOnLeave == true then return end
	recap_temp.OnEnterOnLeave = true

	Recap_Tooltip(this:GetName())

	-- unlock OnEnter-OnLeave events
	recap_temp.OnEnterOnLeave = false
end


function RecapAnchor_OnClick(frame, button, down)

	set_anchor_buttons(this:GetName())

end

RecapOptions_lua_411 = true
