﻿--[[
		Recap - Hawksy (on Elune) (modified for WoW 2)
			  - original development by Gello (versions 3.32 and earlier)

		An AddOn for WoW to track and summarize all damage and healing done around the user.
]]

Recap_Version = 4.11
Recap_Sync_Version = 400 -- used to determine compatible versions of synchronization (integer for compact transmission) (only update if Recap sync format changes so as to be incompatible)

local _G = getfenv(0)
local math_floor = _G.math.floor
local math_max = _G.math.max
local math_min = _G.math.min
local string_find = _G.string.find
local string_format = _G.string.format
local string_gmatch = _G.string.gmatch
local string_gsub = _G.string.gsub
local string_len = _G.string.len
local string_lower = _G.string.lower
local string_sub = _G.string.sub
local table_insert = _G.table.insert
local table_remove = _G.table.remove
local table_sort = _G.table.sort


--[[ Saved Variables ]]

recap = {} -- options and current data (saved to SavedVariables)
recap_set = {} -- fight data sets (saved to SavedVariables)


--[[ Ace2 setup ]]

-- mixin AceComm for sync purposes
Recap = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceComm-2.0")

-- some debuggers look for these variables
Recap.version = string_format("%.2f", Recap_Version)
Recap.revision = ""

-- other Ace2 setup
Recap:SetCommPrefix("Recap")


--[[ local tables ]]

-- colors for the gauges
local gaugecolor = { ["DmgIn"] = { r=.66,g=.25,b=.25 }, ["DmgOut"] = { r=.25,g=.66,b=.35 }, ["Heal"] = { r=.25,g=.5,b=.85 },
					 ["Time"] = { r=.75, g=.75, b=.75 }, ["Kills"] = { r=.75, g=.75, b=.75 }, ["MaxHit"] = { r=.75, g=.75, b=.75 },
					 ["DPS"] = { r=.25, g=.66, b=.35 }, ["Over"] = { r=.25, g=.5, b=.85 } }

-- .Opt.x and its buttons
local recapbuttons = { ["Minimized"] = "RecapMinimizeButton", ["Pinned"] = "RecapPinButton",
					   ["Paused"] = "RecapPauseButton", ["SelfView"] = "RecapSelfViewButton" }


--[[ Callback functions ]]

function Recap:OnInitialize()
	-- slash commands
	SLASH_RecapCOMMAND1 = "/Recap"
	SlashCmdList["RecapCOMMAND"] = Recap_SlashHandler
end


function Recap:OnEnable()

	-- called on login and on reloadui
	-- recap_temp cleared, so Recap_Initialize will be called and its interior code will be executed

	if not recap_temp.Loaded then
		if not Recap_Initialize() then
			return false
		end
	end

	-- register all of our general events (so that we can turn them on and off)
	Recap_Register_GeneralEvents()
end

function Recap:OnDisable()
	-- nothing right now
end

function Recap_General_OnEvent(frame, event, ...)

	if event=="PLAYER_REGEN_DISABLED" then
		if recap_temp.Loaded then -- protect from premature execution
			if recap.Opt.State.value~="Stopped" then
				recap_temp.PlayerInCombat = true
			end
			if recap.Opt.State.value=="Idle" then
				Recap_StartFight()
			end
		end

	elseif event=="PLAYER_REGEN_ENABLED" then
		if recap_temp.Loaded then -- protect from premature execution
			-- player leaving combat, start the end of fight delay timer
			-- fight will not end until at least this amount of time has elapsed, longer if combat continues
			-- we leave the idle timer on, if it is on (and may the best timer win)
			recap_temp.EndFightDelayTimer = 0
			if recap.Opt.State.value~="Active" then
				recap_temp.PlayerInCombat = true
			end
		end

	elseif event=="PARTY_MEMBERS_CHANGED" or event=="RAID_ROSTER_UPDATE" then
		if recap_temp.Loaded then -- protect from premature execution
			Recap_MakeFriends()
		end

	elseif event=="UNIT_NAME_UPDATE" then
		if not recap_temp.Loaded then
			if not Recap_Initialize() then
				return false
			end
		end

	elseif event=="PLAYER_ENTERING_WORLD" then
		-- called on login, on reloadui, on entering or leaving an instance, on respawning at a graveyard
		if not recap_temp.Loaded then
			if not Recap_Initialize() then
				return false
			end
		end

	end
end

function Recap_Register_GeneralEvents()

	if not recap_temp.GeneralEventsRegistered then

		RecapGeneralEvents:RegisterEvent("PLAYER_REGEN_DISABLED")
		RecapGeneralEvents:RegisterEvent("PLAYER_REGEN_ENABLED")
		RecapGeneralEvents:RegisterEvent("PARTY_MEMBERS_CHANGED")
		RecapGeneralEvents:RegisterEvent("RAID_ROSTER_UPDATE")
		RecapGeneralEvents:RegisterEvent("UNIT_NAME_UPDATE")
		RecapGeneralEvents:RegisterEvent("PLAYER_ENTERING_WORLD")

		recap_temp.GeneralEventsRegistered = true
	end
end

function Recap_Unregister_GeneralEvents()
	if recap_temp.GeneralEventsRegistered then
		RecapGeneralEvents:UnregisterAllEvents()
		recap_temp.GeneralEventsRegistered = false
	end
end

function Recap:CHAT_MSG_CHANNEL_NOTICE()

	if arg4 and string_find(arg4, "recaplog"..string_lower(recap_temp.Player), 1, true) and arg1=="YOU_JOINED" then
		-- we have successfully joined our private log channel

		local i, chatnum, chatname
		local logchat = "recaplog"..string_lower(recap_temp.Player)

		chatnum = false
		for i=1,10 do
			j,chatname = GetChannelName(i)
			if chatname and string_lower(chatname)==logchat then
				chatnum=j
				break
			end
		end
		if chatnum then
			recap_temp.LogChatnum = chatnum
			-- begin logging to WOWChatLog.txt
			if LoggingChat() then
				-- already on
			else
				-- toggle on
				LoggingChat(true)
			end
			-- allow Report and Close buttons
			RecapOpenLogButton:SetText(RECAP_CHANNEL_JOINED)
			RecapOpenLogButton:Disable()
			RecapReportToLogButton:Enable()
			RecapCloseLogButton:Enable()
		else
			-- oops, didn't work after all
			DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.NoChannelNumber)
			RecapOpenLogButton:SetText(RECAP_OPEN_WOWCHATLOG_TXT)
			RecapOpenLogButton:Enable()
		end
		RecapFrame:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE")
	end
end

function Recap_OnUpdate(frame, elapsed)

	-- this function is called continually except when Recap is "Stopped"

	-- set lock (some of this update processing contains indefinite delays)
	frame:Hide() -- disable OnUpdate

	if not recap_temp.Loaded then
		return
	end

	-- paranoia
	if recap.Opt.State.value == "Stopped" then
		return
	end

	-- we're using OnUpdate for instant response to mouse-over, so we might as well use it for all other timed events
	-- as far as I can see there would be no benefit from using AceEvent

	-- generic half-second timer
	recap_temp.UpdateTimer = recap_temp.UpdateTimer + elapsed
	if recap_temp.UpdateTimer > 0.5 then
		recap_temp.UpdateTimer = 0

		-- if fighting, check for friends and get their maximum hit points and current hit points (all three can change during combat)
		-- has the side benefit of better tracking of ownership of shadowfiend, mage water elemental, hunter trap, etc.
		-- there is a gap of up to a half-second here where ownership information might be wrong, and effects might not be tracked to the right combatant
		-- with 2.4 some of this will be handled immediately by code in RecapCombat
		if recap.Opt.State.value=="Active" then
			Recap_MakeFriends()
		end

		-- if Recap is tracking and if we are in combat, and either have a plugin or are minimized, then update the live dps and hps numbers
		if (recap.Opt.State.value=="Active") and recap_temp.PlayerInCombat and ((IB_Recap_Update or TitanPanelRecap_Update) or (RecapFrame:IsShown() and recap.Opt.Minimized.value)) then
			recap_temp.LiveUpdateTimer = recap_temp.LiveUpdateTimer + 1
			if recap_temp.LiveUpdateTimer >= 2 then
				recap_temp.LiveUpdateTimer = 0
				-- update once a second
				Recap_UpdateMinimizedDPS()
				Recap_DisplayMinimizedDPS() -- also sends to plugins
			end
		end

		-- possibly blink the sync status light (0 set to default value, 1 turn off, 2 turn on)
		if RecapFrame:IsVisible() then
			if recap_temp.SyncStatusLightBlink == 0 then
				if (recap.Opt.SyncState.value == "Member") or (recap.Opt.SyncState.value == "Leader") then
					RecapMinSyncStatusTexture:SetVertexColor(0,0,1)
				else
					RecapMinSyncStatusTexture:SetVertexColor(.5,.5,.5)
				end
			elseif recap_temp.SyncStatusLightBlink == 1 then
				recap_temp.SyncStatusLightBlink = 2
				RecapMinSyncStatusTexture:SetVertexColor(.5,.5,.5)
			elseif recap_temp.SyncStatusLightBlink == 2 then
				recap_temp.SyncStatusLightBlink = 0
				RecapMinSyncStatusTexture:SetVertexColor(0,0,1)
			end

			-- update main panel title bar (for the sync member count)
			if not recap.Opt.Minimized.value then
				Recap_TitleBar()
				Recap_SetTitleBackground()
			end
		end

		-- if sync tab is visible and we're in a synchronization, update details
		if RecapOptSubFrame5:IsVisible() and ((recap.Opt.SyncState.value == "Member") or (recap.Opt.SyncState.value == "Leader")) then
			Recap_SetSyncStateDetail()
		end

		-- if in sync then send a heartbeat message every five seconds
		if (recap.Opt.SyncState.value == "Member") or (recap.Opt.SyncState.value == "Leader") then
			if recap_temp.SyncHeartbeat == 0 then
				Recap_SendSyncHeartbeat()
				Recap_UpdateSyncMember(recap_temp.PlayerGUID, recap_temp.Server, Recap_Version) -- make sure we get into our own list
			end
			recap_temp.SyncHeartbeat = recap_temp.SyncHeartbeat + 1
			if recap_temp.SyncHeartbeat >= 10 then
				recap_temp.SyncHeartbeat = 0
			end
		end

		-- timer to end idle fights if option checked
		if recap_temp.IdleTimer~=-1 and recap.Opt.IdleFight.value then
			recap_temp.IdleTimer = recap_temp.IdleTimer + 0.5
			if recap_temp.IdleTimer > recap.Opt.IdleFightTimer.value then
				recap_temp.IdleTimer = -1
				Recap_EndFight(false)
				Recap_CheckJoinSync() -- could contain an indefinite pause
				Recap_CheckSendSummary()
				Recap_CheckProcessSyncData()
				-- fight has ended, turn off the flag that skips fights
				if recap.Opt.SkipNextFight.value == true then
					recap.Opt.SkipNextFight.value = false
					DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Recap..":  "..recap_temp.Localize.SkipNextFightEnds)
				end
			end
		end

		-- hidden timer to end idle fights after 10 minutes
		if recap_temp.HiddenIdleTimer~=-1 then
			recap_temp.HiddenIdleTimer = recap_temp.HiddenIdleTimer + 0.5
			if recap_temp.HiddenIdleTimer > 600 then
				recap_temp.HiddenIdleTimer = -1
				Recap_EndFight(false)
				Recap_CheckJoinSync() -- could contain an indefinite pause
				Recap_CheckSendSummary()
				Recap_CheckProcessSyncData()
				-- fight has ended, turn off the flag that skips fights
				if recap.Opt.SkipNextFight.value == true then
					recap.Opt.SkipNextFight.value = false
					DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Recap..":  "..recap_temp.Localize.SkipNextFightEnds)
				end
			end
		end

		-- timer to wait after an end-of-fight is triggered before actually ending the fight
		-- prevents a fight being ended prematurely when it's just a short gap
		if recap_temp.EndFightDelayTimer~=-1 then
			recap_temp.EndFightDelayTimer = recap_temp.EndFightDelayTimer + 0.5
			if recap_temp.EndFightDelayTimer > recap.Opt.EndFightDelay.value then
				recap_temp.EndFightDelayTimer = -1
				Recap_EndFight(false)
				Recap_CheckJoinSync() -- could contain an indefinite pause
				Recap_CheckSendSummary()
				Recap_CheckProcessSyncData()
				-- fight has ended, turn off the flag that skips fights
				if recap.Opt.SkipNextFight.value == true then
					recap.Opt.SkipNextFight.value = false
					DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Recap..":  "..recap_temp.Localize.SkipNextFightEnds)
				end
			end
		end

		-- timer to wait for some time after the last synchronization data has been exchanged before updating the All Fights panel and sending out auto-post data
		--   (uses the existing EndFightDelay value)
		if recap_temp.EndSyncDelayTimer~=-1 then
			recap_temp.EndSyncDelayTimer = recap_temp.EndSyncDelayTimer + 0.5
			if recap_temp.EndSyncDelayTimer > math_max(recap.Opt.EndFightDelay.value, 1) then -- at least one second
				recap_temp.EndSyncDelayTimer = -1
				-- do nothing if we are in combat again
				if not (recap.Opt.State.value=="Active") then
					-- update the All Fights panel
					if recap.Opt.AutoPost.value then
						recap.Opt.SortBy.value = Recap_AutoPostGetStatID(recap.Opt.AutoPost.Stat)
						recap.Opt.SortDir.value = false
					end
					if (not recap.Opt.Minimized.value) or recap.Opt.AutoPost.value or recap.Opt.AutoLeader.value then
						-- don't construct a list if minimized, unless we are doing one of the auto things which needs the list
						Recap_ConstructList()
					end
					Recap_TitleBar()
					RecapHeader_Name:SetText((recap_temp.ListSize-1).." "..RECAP_COMBATANTS)
					Recap_SetTitleBackground()
					if recap_temp.LastFightSignificant then
						-- send out the auto-post data
						if recap.Opt.AutoPost.value then
							Recap_PostFight()
						end
						if recap.Opt.AutoLeader.value then
							Recap_PostLeader()
						end
					end
				end
			end
		end

		-- check group status
		Recap_JoinLeaveGroup() -- could contain an indefinite pause

		-- check instance status
		Recap_EnterLeaveInstance() -- could contain an indefinite pause

	end

	-- update fade timer if option checked
	if RecapFrame:IsShown() and recap.Opt.AutoFade.value and not recap.Opt.Minimized.value and MouseIsOver(RecapFrame) and recap_temp.FadeTimer<recap.Opt.AutoFadeTimer.value then
		recap_temp.FadeTimer = 0
	elseif recap_temp.FadeTimer~=-1 and recap.Opt.AutoFade.value and not recap.Opt.Minimized.value then
		recap_temp.FadeTimer = recap_temp.FadeTimer + elapsed
		if recap_temp.FadeTimer > recap.Opt.AutoFadeTimer.value then
			RecapFrame:SetAlpha(math_max(1-math_min(2*(recap_temp.FadeTimer-recap.Opt.AutoFadeTimer.value),1),.1))
			if recap_temp.FadeTimer > (recap.Opt.AutoFadeTimer.value+.5) then
				RecapFrame_Hide()
			end
		end
	end

	-- check every update since we want quick response to the mouse-over
	if RecapFrame:IsShown() and recap.Opt.AutoMinimize.value and recap_temp.Selected==0 then
		if not recap.Opt.Minimized.value and not MouseIsOver(RecapFrame) and not IsShiftKeyDown() then
			Recap_Minimize()
		elseif recap.Opt.Minimized.value and MouseIsOver(RecapFrame) and not IsShiftKeyDown() then
			Recap_Maximize()
		end
	end

	-- free lock (some of the above update processing contains indefinite delays)
	frame:Show() -- enable OnUpdate

end

function Recap_JoinLeaveGroup()
	-- If option is on, remind player on joining and leaving a group
	-- GetNumPartyMembers returns number of *other* people, not counting you
	-- GetNumRaidMembers returns number of people, including you
	local count = math_max(1+GetNumPartyMembers(),GetNumRaidMembers())
	if (recap.Opt.NumPartyMembers.value == 1) and (count > 1) and recap.Opt.RemindGroupStatus.value then
		StaticPopupDialogs["recap_temp.REMINDGROUP"] = {
			text = TEXT(recap_temp.Localize.RemindJoinGroup),
			button1 = TEXT(OKAY),
			OnAccept = function()
			end,
			timeout = 0,
			showAlert = 1,
			whileDead = 1
		}
		StaticPopup_Show("recap_temp.REMINDGROUP")
	elseif (recap.Opt.NumPartyMembers.value > 1) and (count == 1) and recap.Opt.RemindGroupStatus.value then
		StaticPopupDialogs["recap_temp.REMINDGROUP"] = {
			text = TEXT(recap_temp.Localize.RemindLeaveGroup),
			button1 = TEXT(OKAY),
			OnAccept = function()
			end,
			timeout = 0,
			showAlert = 1,
			whileDead = 1
		}
		StaticPopup_Show("recap_temp.REMINDGROUP")
	end
	recap.Opt.NumPartyMembers.value = count
end

function Recap_EnterLeaveInstance()
	local nowInside
	if IsInInstance() then
		nowInside = true
	else
		nowInside = false
	end
	-- If option is on, remind player on entering and leaving an instance
	if (recap.Opt.InsideInstance.value == false) and (nowInside == true) and recap.Opt.RemindInstanceStatus.value then
		StaticPopupDialogs["recap_temp.REMINDINSTANCE"] = {
			text = TEXT(recap_temp.Localize.RemindEnterInstance),
			button1 = TEXT(OKAY),
			OnAccept = function()
			end,
			timeout = 0,
			showAlert = 1,
			whileDead = 1
		}
		StaticPopup_Show("recap_temp.REMINDINSTANCE")
	elseif (recap.Opt.InsideInstance.value == true) and (nowInside == false) and recap.Opt.RemindInstanceStatus.value then
		StaticPopupDialogs["recap_temp.REMINDINSTANCE"] = {
			text = TEXT(recap_temp.Localize.RemindLeaveInstance),
			button1 = TEXT(OKAY),
			OnAccept = function()
			end,
			timeout = 0,
			showAlert = 1,
			whileDead = 1
		}
		StaticPopup_Show("recap_temp.REMINDINSTANCE")
	end
	recap.Opt.InsideInstance.value = nowInside
end

function Recap_SlashHandler(slashText, ...)

	local i, newScale

	-- any Recap slash command will turn Recap on if it had been turned off (such as by hitting the Exit button on the Options panel)
	if not Recap_Initialize() then
		-- TODO: these puppies aren't localized
		DEFAULT_CHAT_FRAME:AddMessage("Recap is not initialized, try re-installing.", 1.0, 0.2, 0.2)
		return false
	end


	-- "/recap centre" or "/recap center" or "/recap cent"
	-- make the main Recap panel visible and put it in the middle of the screen
	-- also set the scale to 1.0
	if slashText and string_find(slashText, "cent", 1, true) then
		recap.Opt.SetScale.value = 100
		RecapSetScaleSlider:SetValue(recap.Opt.SetScale.value)
		newScale = Recap_Div2(recap.Opt.SetScale.value,100)
		RecapSetScaleSlider_Text:SetText(newScale)
		RecapFrame:SetScale(newScale)
		RecapOptFrame:SetScale(newScale)
		RecapPanel:SetScale(newScale)
		RecapRecent:SetScale(newScale)
		RecapMenu:SetScale(newScale)
		recap_temp.RecapTooltip:SetScale(newScale)
		RecapFrame:ClearAllPoints()
		RecapFrame:SetPoint("CENTER","UIParent","CENTER")
		RecapOptFrame:ClearAllPoints()
		RecapOptFrame:SetPoint("CENTER","UIParent","CENTER")
		recap.Opt.Pinned.value = false
		Recap_SetView()
		RecapFrame_Show()
		Recap_Maximize()
		RecapFrame:SetAlpha(1)
		recap_temp.FadeTimer = -1
		-- TODO: these puppies aren't localized
		DEFAULT_CHAT_FRAME:AddMessage("Recap has been centred, and the scaling has been reset to 1.0.")


	-- "/recap options" or "/recap opt"
	-- show or hide the Options panel
	elseif slashText and string_find(slashText, "opt", 1, true) then
		if RecapOptFrame:IsShown() then
			RecapOptFrame:Hide()
		else
			RecapOptFrame:Show()
			Recap_SetSyncDisplay()
		end


	-- "/recap reset"
	-- does a Reset All Fights (for the leader of a synchronization it starts a new synchronization)
	elseif slashText and string_find(slashText, "reset", 1, true) then
		if ((recap.Opt.SyncState.value == "Member") or (recap.Opt.SyncState.value == "Leader")) then
			if recap.Opt.SyncState.value == "Leader" then
				-- for a leader, treat this as a restart sync (with existing value for merge pets)
				Recap_StartSync(recap.Opt.SyncMergePets.value)
				DEFAULT_CHAT_FRAME:AddMessage(RECAP_RECAP.." "..RECAP_SYNCHRONIZATION_RESET)
			else
				-- for a member, ignore if in synchronization
				PlaySound("igQuestFailed")
				Recap_WarnNotAllowedDuringSync()
			end
		else
			PlaySound("GnomeExploration")
			RecapPanel_Hide(1)
			RecapRecent_Hide(1)
			Recap_ResetAllCombatants(false)
			Recap_SetView()
			Recap_MakeFriends()
			DEFAULT_CHAT_FRAME:AddMessage(RECAP_RECAP.." "..RECAP_ALL_FIGHTS_RESET)
		end
		collectgarbage("collect")


	-- "/recap gmin on" or "/recap gmin off"
	-- always begins "off" at login or after reloadui
	-- a lightly documented setting, to always calculate gross minima for Self ("gmin on"), rather than net minima ("gmin off")
	-- affects only the minima on the Personal Details panel, and does not affect the Outgoing Details or Incoming Details minima
	-- if you hit someone for 50 and they partially block 10, the gross minimum would be 50 and the net minimum would be 40
	-- the gross minimum measures the smallest effect that you generate (corresponding for example to the low end of a spell damage range)
	-- the gross minimum is useful when you are measuring your spells and need to track the actual low end of your spells as cast, such
	--   as when trying to measure the actual coefficient used by Blizzard for the spell damage or spell healing bonus
	-- the net minimum is after the target has resisted or blocked or otherwise reduced the effect, and could be as low as 1 or perhaps even 0
	elseif slashText=="gmin" then
		if recap.gmin then
			DEFAULT_CHAT_FRAME:AddMessage("recap.gmin is ON. To turn it off: /recap gmin off")
		else
			DEFAULT_CHAT_FRAME:AddMessage("recap.gmin is OFF. To turn it on: /recap gmin on")
		end
	elseif slashText=="gmin on" then
		if recap.gmin then
			DEFAULT_CHAT_FRAME:AddMessage("recap.gmin was on, and is still ON.")
		else
			DEFAULT_CHAT_FRAME:AddMessage("recap.gmin was off, and is now ON.")
		end
		recap.gmin = true
	elseif slashText=="gmin off" then
		if recap.gmin then
			DEFAULT_CHAT_FRAME:AddMessage("recap.gmin was on, and is now OFF.")
		else
			DEFAULT_CHAT_FRAME:AddMessage("recap.gmin was off, and is still OFF.")
		end
		recap.gmin = false


	-- "/recap debug on" or "/recap debug off"
	-- always begins "off" at login or after reloadui
	-- debug setting, sends some additional debug information to your console
	-- relatively harmless
	elseif slashText=="debug" then
		if recap.debug then
			-- TODO: these puppies aren't localized
			DEFAULT_CHAT_FRAME:AddMessage("recap.debug is ON. To turn it off: /recap debug off")
		else
			DEFAULT_CHAT_FRAME:AddMessage("recap.debug is OFF. To turn it on: /recap debug on")
		end
	elseif slashText=="debug on" then
		if recap.debug then
			DEFAULT_CHAT_FRAME:AddMessage("recap.debug was on, and is still ON.")
		else
			DEFAULT_CHAT_FRAME:AddMessage("recap.debug was off, and is now ON.")
		end
		recap.debug = true
	elseif slashText=="debug off" then
		if recap.debug then
			DEFAULT_CHAT_FRAME:AddMessage("recap.debug was on, and is now OFF.")
		else
			DEFAULT_CHAT_FRAME:AddMessage("recap.debug was off, and is still OFF.")
		end
		recap.debug = false


	-- "/recap snap on" or "/recap snap off"
	-- always begins "off" at login or after reloadui
	-- debug setting, automatically takes a screenshot whenever there is an error popup
	-- mostly harmless, but if there are a lot of errors there will be a lot of screenshots filling up your "World of Warcraft/Screenshots" folder
	-- each screenshot will momentarily pause your game
	elseif slashText=="snap" then
		if recap_temp.snap then
			DEFAULT_CHAT_FRAME:AddMessage("recap_temp.snap is ON. To turn it off: /recap snap off")
		else
			DEFAULT_CHAT_FRAME:AddMessage("recap_temp.snap is OFF. To turn it on: /recap snap on")
		end
	elseif slashText=="snap on" then
		if recap_temp.snap then
			DEFAULT_CHAT_FRAME:AddMessage("recap_temp.snap was on, and is still ON.")
		else
			DEFAULT_CHAT_FRAME:AddMessage("recap_temp.snap was off, and is now ON.")
		end
		recap_temp.snap = true
	elseif slashText=="snap off" then
		if recap_temp.snap then
			DEFAULT_CHAT_FRAME:AddMessage("recap_temp.snap was on, and is now OFF.")
		else
			DEFAULT_CHAT_FRAME:AddMessage("recap_temp.snap was off, and is still OFF.")
		end
		recap_temp.snap = false


	-- "/recap dump on" or "/recap dump off"
	-- always begins "off" at login or after reloadui
	-- debug setting, to dump combat events (as seen by Recap) to WOWChatLog.txt (file will show up in "World of Warcraft/Logs")
	-- potentially harmful, use with caution, as it can slow Recap down a lot and if you are unlucky it might even disconnect you
	-- if you want to see all of the raw combat events then use the Blizzard slash command "/combatlog" (file will show up in "World of Warcraft/Logs")
	elseif slashText=="dump" then
		if recap.dump then
			DEFAULT_CHAT_FRAME:AddMessage("recap.dump is ON. To turn it off: /recap dump off")
		else
			DEFAULT_CHAT_FRAME:AddMessage("recap.dump is OFF. To turn it on: /recap dump on")
		end
	elseif slashText=="dump on" then
		if recap_temp.LogChatnum then
			-- have a log channel, WOWChatLog should be open with logging turned on
			if recap.dump then
				DEFAULT_CHAT_FRAME:AddMessage("recap.dump was on, and is still ON.")
			else
				DEFAULT_CHAT_FRAME:AddMessage("recap.dump was off, and is now ON.")
			end

			ChatThrottleLib:SendChatMessage("BULK", "Recap", string_format(recap_temp.Localize.LogHeader,Recap_Version,Recap_PetsMergedText(),recap_temp.Player,recap_temp.LastAll[recap.Opt.View.value],date("%Y-%b-%d %H:%M"),GetRealZoneText()), "CHANNEL", nil, recap_temp.LogChatnum)
			recap.dump = true
			recap.dumplines = 0
		else
			DEFAULT_CHAT_FRAME:AddMessage("recap.dump logging not on, please go to Options / Reports and Open the WOWChatLog.txt file.")
		end
	elseif slashText=="dump off" then
		if recap.dump then
			DEFAULT_CHAT_FRAME:AddMessage("recap.dump was on, and is now OFF.")
		else
			DEFAULT_CHAT_FRAME:AddMessage("recap.dump was off, and is still OFF.")
		end
		recap.dump = false


	-- "/recap eof"
	-- force an End of Fight (use with extreme caution, it could really bork a synchronization)
	elseif slashText and string_find(slashText, "eof", 1, true) then
		-- too dangerous, restrict to me only
		if (recap_temp.p == "Hawksy_Elune") or (recap_temp.p == "Galassa_Elune") or (recap_temp.p == "Metrognome_Elune") then
			if recap.Opt.State.value=="Active" then
				Recap_EndFight(true)
				Recap_SetButtons()
			end
		end

	-- when the main panel is visible, "/recap" hides it
	elseif RecapFrame:IsShown() then
		RecapFrame_Hide()
		RecapOptFrame:Hide()
		-- TODO: these puppies aren't localized
		DEFAULT_CHAT_FRAME:AddMessage("Recap has been hidden.")


	-- when the main panel is not visible "/recap" makes it visible
	-- if Recap was paused this slash command also un-pauses it
	else
		RecapFrame_Show()
		Recap_CheckWindowBounds()
		if recap.Opt.State.value == "Stopped" then
			Recap_ClearAsIfEndOfFight()
			Recap_SetState("Idle")
			recap.Opt.Paused.value = false
			Recap_SetButtons()
		end
		-- TODO: these puppies aren't localized
		DEFAULT_CHAT_FRAME:AddMessage("Recap has been shown.  If Recap is still not visible, try '/recap centre'.")
	end
end


--[[ Window appearance functions ]]

function Recap_SetState(state)
	if state then
		recap.Opt.State.value = state
	end
	RecapUpdateFrame:Hide() -- disable OnUpdate
	if recap.Opt.State.value=="Stopped" then
		recap.Opt.SkipNextFight.value = false
		RecapStatusTexture:SetVertexColor(1,0,0)
		Recap_Unregister_CombatEvents()
		Recap_Unregister_GeneralEvents()
	elseif recap.Opt.State.value=="Active" then
		RecapStatusTexture:SetVertexColor(0,1,0)
		Recap_Register_CombatEvents()
		Recap_Register_GeneralEvents()
	elseif recap.Opt.State.value=="Idle" then
		RecapStatusTexture:SetVertexColor(.5,.5,.5)
		Recap_Register_CombatEvents()
		Recap_Register_GeneralEvents()
	end
	if (recap.Opt.SyncState.value == "Member") or (recap.Opt.SyncState.value == "Leader") then
		RecapMinSyncStatusTexture:SetVertexColor(0,0,1)
	else
		RecapMinSyncStatusTexture:SetVertexColor(.5,.5,.5)
	end
	Recap_SetButtons()
	-- display live dps and hps numbers
	Recap_DisplayMinimizedDPS() -- also sends to plugins
	if recap.Opt.State.value~="Stopped" then
		RecapUpdateFrame:Show() -- enable OnUpdate
	end
end

function RecapFrame_Hide()

	if not recap_temp.Loaded then
		if not Recap_Initialize() then
			return false
		end
	end
	recap_temp.FadeTimer = -1
	RecapFrame:SetAlpha(1)
	recap.Opt.Visible.value = false
	RecapFrame:Hide()
end

function RecapFrame_Show()

	if not recap_temp.Loaded then
		if not Recap_Initialize() then
			return false
		end
	end
	recap.Opt.Visible.value = true
	RecapFrame:Show()

end

-- catch Escape when maximized, and do a minimize instead; and genuinely hide otherwise
function RecapFrame_HideOrMinimize()

	if not recap_temp.Loaded then
		if not Recap_Initialize() then
			return false
		end
	end
	if recap.Opt.Visible.value then
		-- other code wants it visible, so this must be an Escape, so minimize and show
		-- Minimize will disable the special status of RecapFrame so that it lets the Escape through
		-- Maximize will enable the special status of RecapFrame so that it captures the Escape
		if recap.Opt.MinimizeOnEscape.value then
			-- but only minimize if the option is set
			Recap_Minimize()
		end
		RecapFrame:Show()
	else
		-- other code wants it hidden, so let it happen (called from OnHide, so don't recurse)
	end
end

function RecapOptFrame_Hide()
	RecapOptFrame:Hide()
end

function RecapFrame_Toggle()
	if RecapFrame:IsShown() then
		RecapFrame_Hide()
		RecapOptFrame:Hide()
	else
		RecapFrame_Show()
	end
end

function Recap_Shutdown()

	recap.Opt.Paused.value = true
	Recap_EndFight(true)
	Recap_SetState("Stopped")
	Recap_ClearAsIfEndOfFight()
	Recap_SetButtons()
	RecapOptFrame:Hide()
	RecapFrame_Hide()

	-- cleanup for 3.59 and later
	local i, iCombatant
	if not recap.Combatant then
		recap.Combatant = {}
	end
	for i in pairs(recap.Combatant) do
		if (i ~= recap_temp.GroupTotal) and (i ~= recap_temp.NonGroupTotal) then
			iCombatant = recap.Combatant[i]
			if iCombatant.Incoming then
				iCombatant.Incoming = nil -- keep as nil
			end
			if iCombatant.Detail then
				iCombatant.Detail = nil -- keep as nil
			end
		end
	end
end

function Recap_ToggleView()
	if recap.Opt.View.value=="All" then
		recap.Opt.View.value = "Last"
	else
		recap.Opt.View.value = "All"
	end
	Recap_SetView() -- this calls ConstructList
end

-- changes button textures depending on their state
function Recap_SetButtons()

	local i, iButton
	local _G = getfenv(0)

	for i in pairs(recapbuttons) do
		iButton = _G[recapbuttons[i]]
		if recap.Opt[i].value then
			iButton:SetNormalTexture("Interface\\AddOns\\Recap\\Images\\Recap-Buttons-Down")
			iButton:SetPushedTexture("Interface\\AddOns\\Recap\\Images\\Recap-Buttons-Up")
		else
			iButton:SetNormalTexture("Interface\\AddOns\\Recap\\Images\\Recap-Buttons-Up")
			iButton:SetPushedTexture("Interface\\AddOns\\Recap\\Images\\Recap-Buttons-Down")
		end
	end

	if recap.Opt.View.value=="Last" then
		RecapShowAllButton:SetNormalTexture("Interface\\AddOns\\Recap\\Images\\Recap-Buttons-Up")
		RecapShowAllButton:SetPushedTexture("Interface\\AddOns\\Recap\\Images\\Recap-Buttons-Down")
	else
		RecapShowAllButton:SetNormalTexture("Interface\\AddOns\\Recap\\Images\\Recap-Buttons-Down")
		RecapShowAllButton:SetPushedTexture("Interface\\AddOns\\Recap\\Images\\Recap-Buttons-Up")
	end

end

-- this resizes the window width to the columns defined in options
-- this calls SetView which in turn calls ConstructList
function Recap_SetColumns()

	local i, j, cx, item, subitem, iOpt
	local _G = getfenv(0)
	local recentWidth = 55

	-- name width was 120 changed to 144 to allow for longer names, especially
	--   under Spells and Abilities on the "Personal Details" panel.
	-- Matching changes made in Recap.xml for parent_EName, parent_Name, RecapHeader_Name, and
	--   RecapHeader_EName.
	cx = recap_temp.ScrollAndEdgeWidth + recap_temp.NameWidth

	if recap.Opt.SelfView.value then
		-- personal view
		for i in pairs(recap.Opt) do
			iOpt = recap_temp.DefaultOpt[i]
			if iOpt and iOpt.ewidth then
				if recap.Opt[i].value then
					_G["RecapHeader_"..i]:SetWidth(iOpt.ewidth)
					_G["RecapHeader_"..i]:Show()
					for j=1,15 do
						_G["RecapSelf"..j.."_"..i]:SetWidth(iOpt.ewidth)
						_G["RecapSelf"..j.."_"..i]:Show()
					end
					cx = cx + iOpt.ewidth
				else
					_G["RecapHeader_"..i]:SetWidth(1)
					_G["RecapHeader_"..i]:Hide()
					for j=1,15 do
						_G["RecapSelf"..j.."_"..i]:SetWidth(1)
						_G["RecapSelf"..j.."_"..i]:Hide()
					end
					cx = cx + 1
				end
			elseif iOpt and iOpt.width then
				_G["RecapHeader_"..i]:Hide()
			end
		end

		RecapTotals:Hide()
		RecapGroupTotalButton:Hide()
		RecapNonGroupTotalButton:Hide()
		RecapHeader_Name:Hide()
		RecapHeader_EName:Show()

		for i=1,15 do
			_G["RecapList"..i]:Hide()
			_G["RecapRecentList"..i]:Hide()
			_G["RecapSelf"..i]:Show()
			_G["RecapSelf"..i]:SetWidth(cx - recap_temp.ScrollAndEdgeWidth + 6) -- extra 6 since it doesn't seem quite wide enough
			_G["RecapRecentSelf"..i.."_Text"]:SetTextColor(recap_temp.ColorGreen.r, recap_temp.ColorGreen.g, recap_temp.ColorGreen.b)
			_G["RecapRecentSelf"..i.."_SaveColor"]:SetTextColor(recap_temp.ColorGreen.r, recap_temp.ColorGreen.g, recap_temp.ColorGreen.b) -- saves chosen colour
			_G["RecapRecentSelf"..i]:Show()
		end

	else
		-- general view
		for i in pairs(recap.Opt) do
			iOpt = recap_temp.DefaultOpt[i]
			if iOpt and iOpt.width then
				if recap.Opt[i].value then
					-- column will appear
					item = _G["RecapHeader_"..i]
					item:SetWidth(iOpt.width)
					item:Show()
					item = _G["RecapTotals_"..i]
					item:SetWidth(iOpt.width)
					item:Show()
					-- Faction and Level always show and hide together
					if i == "Faction" then
						-- split the width (hardcoded numbers)
						item:SetWidth(14)
						subitem = _G["RecapTotals_Level"]
						subitem:SetWidth(18)
						subitem:Show()
					end
					for j=1,15 do
						item = _G["RecapList"..j.."_"..i]
						item:SetWidth(iOpt.width)
						item:Show()
						-- Faction and Level always show and hide together
						if i == "Faction" then
							-- split the width (hardcoded numbers)
							item:SetWidth(14)
							subitem = _G["RecapList"..j.."_Level"]
							subitem:SetWidth(18)
							subitem:Show()
						end
					end
					cx = cx + iOpt.width
				else
					-- column will not appear
					item = _G["RecapHeader_"..i]
					item:SetWidth(1)
					item:Hide()
					-- Ranks, Faction, Class, and Level column fix (see below)
					if (i == "Ranks") or (i == "Faction") or (i == "Class") then
						item:Show()
					end
					-- there is no header for Level
					item = _G["RecapTotals_"..i]
					item:SetWidth(1)
					item:Hide()
					-- Ranks, Faction, Class, and Level column fix (see below)
					if (i == "Ranks") or (i == "Faction") or (i == "Class") then
						item:Show()
					end
					-- Faction and Level always show together
					if i == "Faction" then
						subitem = _G["RecapTotals_Level"]
						subitem:SetWidth(1)
						subitem:Show()
						cx = cx + 1 -- two columns here, not just one
					end
					for j=1,15 do
						item = _G["RecapList"..j.."_"..i]
						item:SetWidth(1)
						item:Hide()
						-- Ranks, Faction, Class, and Level column fix
						--   To fix a display bug these columns always appear, even if
						--   only blank (or transparent black) and one column wide.
						--   See also RecapScrollBar_Update and Recap_ConstructList.
						if (i == "Ranks") or (i == "Faction") or (i == "Class") then
							item:Show()
						end
						-- Faction and Level always show together
						if i == "Faction" then
							subitem = _G["RecapList"..j.."_Level"]
							subitem:SetWidth(1)
							subitem:Show()
						end
					end
					cx = cx + 1
				end
			elseif iOpt and iOpt.ewidth then
				_G["RecapHeader_"..i]:Hide()
			end
		end

		for i=1,15 do
			_G["RecapSelf"..i]:Hide()
			_G["RecapRecentSelf"..i]:Hide()
			_G["RecapList"..i]:Show()
			_G["RecapList"..i]:SetWidth(cx - recap_temp.ScrollAndEdgeWidth + 6) -- extra 6 since it doesn't seem quite wide enough
			local r,g,b = _G["RecapList"..i.."_Name"]:GetTextColor()
			_G["RecapRecentList"..i.."_Text"]:SetTextColor(r, g, b)
			_G["RecapRecentList"..i.."_SaveColor"]:SetTextColor(r, g, b) -- saves chosen colour
			_G["RecapRecentList"..i]:Show()
		end

		RecapTotals:Show()
		if not recap.Opt.LightData.value then
			RecapGroupTotalButton_Text:SetTextColor(recap_temp.ColorGreen.r, recap_temp.ColorGreen.g, recap_temp.ColorGreen.b)
			RecapGroupTotalButton:Show()
			RecapNonGroupTotalButton_Text:SetTextColor(recap_temp.ColorWhite.r, recap_temp.ColorWhite.g, recap_temp.ColorWhite.b)
			RecapNonGroupTotalButton:Show()
		else
			RecapGroupTotalButton:Hide()
			RecapNonGroupTotalButton:Hide()
		end
		RecapHeader_Name:Show()
		RecapHeader_EName:Hide()

	end

	-- the name slot on the Total line is much narrower
	-- see also the offset in Recap.xml
	RecapTotals_Name:SetWidth(recap_temp.NameWidth-102)
	RecapTotals:SetWidth(cx-142)

	if recap.Opt.GrowLeftwards.value and RecapFrame then
		i = RecapFrame:GetRight()
		j = RecapFrame:GetTop()
		if i and j then
			RecapFrame:ClearAllPoints()
			RecapFrame:SetPoint("TOPLEFT","UIParent","BOTTOMLEFT",math_max(i-cx-recap_temp.RecentButtonWidth,0),math_max(j,0)) -- *** i not defined sometimes :( **  [ if frame has not been dragged since reloadui ]
		else
			-- default behaviour if any undefined
			RecapFrame:ClearAllPoints()
			RecapFrame:SetPoint("CENTER","UIParent","CENTER")
		end
	end

	RecapTopBar:SetWidth(cx-8+recap_temp.RecentButtonWidth)
	RecapBottomBar:SetWidth(cx-16+recap_temp.RecentButtonWidth)
	RecapFrame:SetWidth(cx+recap_temp.RecentButtonWidth)
	RecapScrollBar:SetWidth(cx-16+recap_temp.RecentButtonWidth)

	recap_temp.GaugeWidth = cx - recap_temp.ScrollAndEdgeWidth - 12 -
							( (not recap.Opt.SelfView.value) and
							   ((((recap.Opt.Faction.value and recap.Opt.Faction.width) or 1) +
								 ((recap.Opt.Class.value and recap.Opt.Class.width) or 1) +
								 ((recap.Opt.Ranks.value and recap.Opt.Ranks.width) or 1)) or 0) or 0)

	Recap_CheckWindowBounds()
	Recap_SetView()
	if not recap.Opt.Minimized.value then
		RecapScrollBar_Update()
	end

end

-- changes view mode
function Recap_SetView()
	Recap_SetButtons()
	Recap_ConstructList()
	Recap_TitleBar()
	RecapHeader_Name:SetText((recap_temp.ListSize-1).." "..RECAP_COMBATANTS)
	Recap_SetTitleBackground()
	-- display live dps and hps numbers
	Recap_DisplayMinimizedDPS() -- also sends to plugins
end

function Recap_TitleBar()

	local cx, text

	if recap.Opt.Minimized.value then
		if recap.Opt.MinView.value then
			text = recap_temp.LastAllShort[recap.Opt.View.value]
		else
			text = " "
		end
	else
		cx = RecapFrame:GetWidth()
		if cx then
			if recap.Opt.SelfView.value then
				if cx>300 then
					text = recap_temp.Player..": "..recap_temp.Localize.Details
				else
					text = recap_temp.Player
				end
			else
				if cx>260 then
					text = recap_temp.Recap.." "..recap_temp.Localize.Of.." "..recap_temp.LastAll[recap.Opt.View.value]
				else
					text = recap_temp.LastAll[recap.Opt.View.value]
				end
			end
		else
			if recap.Opt.SelfView.value then
				text = recap_temp.Player
			else
				text = recap_temp.LastAll[recap.Opt.View.value]
			end
		end

		-- add sync member count
		if ((recap.Opt.SyncState.value == "Member") or (recap.Opt.SyncState.value == "Leader")) and not recap.Opt.SelfView.value then
			local list_time, active, stale
			list_time = GetTime()
			active = 0
			stale = 0
			for i in pairs(recap_temp.SyncMembers) do
				if (list_time-(recap_temp.SyncMembers[i].When/1000)) <= 10 then
					active = active + 1
				else
					stale = stale + 1
				end
			end
			if stale > 0 then
				text = text.."   ("..tostring(active).."+"..tostring(stale).." "..recap_temp.Localize.InSync..")"
			else
				text = text.."   ("..tostring(active).." "..recap_temp.Localize.InSync..")"
			end
		end
	end

	-- bizarre: it looks as though 'RecapTitle' is the text string for RecapMinView
	RecapTitle:SetText(text)
	RecapMinView:Show()
end

function Recap_SetColors()

	local i
	local _G = getfenv(0)

	if recap.Opt.UseColor.value then
		recap_temp.ColorDmgIn = recap_temp.ColorRed
		recap_temp.ColorDmgOut = recap_temp.ColorGreen
		recap_temp.ColorHeal = recap_temp.ColorBlue
		recap_temp.ColorDmgInPale = recap_temp.ColorRedPale
		recap_temp.ColorDmgOutPale = recap_temp.ColorGreenPale
		recap_temp.ColorHealPale = recap_temp.ColorBluePale
		recap_temp.ColorGlances = recap_temp.ColorLightCyan
		recap_temp.ColorHits = recap_temp.ColorCyan
		recap_temp.ColorTicks = recap_temp.ColorYellow
		recap_temp.ColorCrits = recap_temp.ColorLime
		recap_temp.ColorMiss = recap_temp.ColorPink
	else
		recap_temp.ColorDmgIn = recap_temp.ColorWhite
		recap_temp.ColorDmgOut = recap_temp.ColorWhite
		recap_temp.ColorHeal = recap_temp.ColorWhite
		recap_temp.ColorDmgInPale = recap_temp.ColorWhite
		recap_temp.ColorDmgOutPale = recap_temp.ColorWhite
		recap_temp.ColorHealPale = recap_temp.ColorWhite
		recap_temp.ColorGlances = recap_temp.ColorWhite
		recap_temp.ColorHits = recap_temp.ColorWhite
		recap_temp.ColorTicks = recap_temp.ColorWhite
		recap_temp.ColorCrits = recap_temp.ColorWhite
		recap_temp.ColorMiss = recap_temp.ColorWhite
	end

	RecapTotals_DmgIn:SetTextColor(recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b)
	RecapTotals_DmgOut:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
	RecapTotals_HPS:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
	RecapTotals_DPSIn:SetTextColor(recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b)
	RecapTotals_DPS:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
	RecapTotals_DPSvsAll:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
	RecapTotals_Heal:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
	RecapTotals_Over:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
	RecapMinYourDPS_Text:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
	RecapMinDPSIn_Text:SetTextColor(recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b)
	RecapMinDPSOut_Text:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
	RecapMinYourHPS_Text:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
	RecapMinHPS_Text:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
	for i=1,15 do
		_G["RecapList"..i.."_HealP"]:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
		_G["RecapList"..i.."_Over"]:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
		_G["RecapList"..i.."_DmgInP"]:SetTextColor(recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b)
		_G["RecapList"..i.."_DmgOutP"]:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
		_G["RecapSelf"..i.."_EGlances"]:SetTextColor(recap_temp.ColorGlances.r,recap_temp.ColorGlances.g,recap_temp.ColorGlances.b)
		_G["RecapSelf"..i.."_EGlancesMin"]:SetTextColor(recap_temp.ColorGlances.r,recap_temp.ColorGlances.g,recap_temp.ColorGlances.b)
		_G["RecapSelf"..i.."_EGlancesAvg"]:SetTextColor(recap_temp.ColorGlances.r,recap_temp.ColorGlances.g,recap_temp.ColorGlances.b)
		_G["RecapSelf"..i.."_EGlancesMax"]:SetTextColor(recap_temp.ColorGlances.r,recap_temp.ColorGlances.g,recap_temp.ColorGlances.b)
		_G["RecapSelf"..i.."_EHits"]:SetTextColor(recap_temp.ColorHits.r,recap_temp.ColorHits.g,recap_temp.ColorHits.b)
		_G["RecapSelf"..i.."_EHitsMin"]:SetTextColor(recap_temp.ColorHits.r,recap_temp.ColorHits.g,recap_temp.ColorHits.b)
		_G["RecapSelf"..i.."_EHitsAvg"]:SetTextColor(recap_temp.ColorHits.r,recap_temp.ColorHits.g,recap_temp.ColorHits.b)
		_G["RecapSelf"..i.."_EHitsMax"]:SetTextColor(recap_temp.ColorHits.r,recap_temp.ColorHits.g,recap_temp.ColorHits.b)
		_G["RecapSelf"..i.."_ETicks"]:SetTextColor(recap_temp.ColorTicks.r,recap_temp.ColorTicks.g,recap_temp.ColorTicks.b)
		_G["RecapSelf"..i.."_ETicksMin"]:SetTextColor(recap_temp.ColorTicks.r,recap_temp.ColorTicks.g,recap_temp.ColorTicks.b)
		_G["RecapSelf"..i.."_ETicksAvg"]:SetTextColor(recap_temp.ColorTicks.r,recap_temp.ColorTicks.g,recap_temp.ColorTicks.b)
		_G["RecapSelf"..i.."_ETicksMax"]:SetTextColor(recap_temp.ColorTicks.r,recap_temp.ColorTicks.g,recap_temp.ColorTicks.b)
		_G["RecapSelf"..i.."_ECrits"]:SetTextColor(recap_temp.ColorCrits.r,recap_temp.ColorCrits.g,recap_temp.ColorCrits.b)
		_G["RecapSelf"..i.."_ECritsMin"]:SetTextColor(recap_temp.ColorCrits.r,recap_temp.ColorCrits.g,recap_temp.ColorCrits.b)
		_G["RecapSelf"..i.."_ECritsAvg"]:SetTextColor(recap_temp.ColorCrits.r,recap_temp.ColorCrits.g,recap_temp.ColorCrits.b)
		_G["RecapSelf"..i.."_ECritsMax"]:SetTextColor(recap_temp.ColorCrits.r,recap_temp.ColorCrits.g,recap_temp.ColorCrits.b)
		_G["RecapSelf"..i.."_ECritsP"]:SetTextColor(recap_temp.ColorCrits.r,recap_temp.ColorCrits.g,recap_temp.ColorCrits.b)
		_G["RecapSelf"..i.."_EMiss"]:SetTextColor(recap_temp.ColorMiss.r,recap_temp.ColorMiss.g,recap_temp.ColorMiss.b)
		_G["RecapSelf"..i.."_EMissP"]:SetTextColor(recap_temp.ColorMiss.r,recap_temp.ColorMiss.g,recap_temp.ColorMiss.b)
	end
	Recap_SetTitleBackground()
end

function Recap_SetTitleBackground()

	if recap.Opt.UseColor.value and (recap.Opt.MinBack.value or not recap.Opt.Minimized.value) then
		if recap.Opt.SelfView.value and not recap.Opt.Minimized.value then
			RecapTitleBack:SetVertexColor(0,0,.8)
		elseif recap.Opt.View.value=="Last" then
			RecapTitleBack:SetVertexColor(0,.66,0)
		else
			RecapTitleBack:SetVertexColor(.66,0,0)
		end
		RecapTitleBack:Show()
	else
		RecapTitleBack:Hide()
	end
end


--[[ Initialization ]]

-- Can be called often, will immediately dump out if it ran through successfully
function Recap_Initialize()

	local i, x, iCombatant, newScale
	local init_time

	if not recap_temp.Loaded then

		if not Recap_IntegrityCheck() then
			return false
		end

		if (UnitName("player")) and (UnitName("player"))~=UNKNOWNOBJECT and RecapFrame and RecapOptFrame then

			init_time = GetTime()

			-- take control of lua error messages (WoW 2.1 defaults off)
			recap_Original_ErrorHandler = geterrorhandler()
			seterrorhandler(Recap_TrapError)

			recap_temp.Player = (UnitName("player"))
			recap_temp.Server = GetCVar("realmName")

			-- recap index for this player
			recap_temp.p = recap_temp.Player.."_"..recap_temp.Server -- use for stuff that can be made global -- never has GUID
			recap_temp.s = recap_temp.Player.."_"..recap_temp.Server -- use for stuff that should never be global -- never has GUID

			-- fix with 4.00 for change from NameServer to Name_Server
			if recap and recap.User then
				local found, name, server
				found, _, name, server = string_find(recap.User, "^(%u%l+)(%u[^_]+)$")
				if found and name and server then
					-- old style NameServer, change
					recap.User = name.."_"..server
				end
			end

			if recap and recap.UseOneSettings and recap.User then
				recap_temp.p = recap.User
			end

			-- force the dump flags to false, otherwise we could wake up spamming a channel other than our proper log channel
			recap.dump = false
			recap_temp.LogChatnum = false
			recap.debug = false

			-- Hawksy: force snap on for me every time
			-- if someone else takes over development, you might want to remove this paragraph, or update it for your own toons
			if (recap_temp.p == "Hawksy_Elune") or (recap_temp.p == "Galassa_Elune") or (recap_temp.p == "Metrognome_Elune") then
				recap_temp.snap = true
			end

			Recap_InitializeData()

			-- version of player name with GUID appended
			recap_temp.PlayerGUID = recap_temp.Player
			if not recap.Opt.IgnoreGUIDs.value then
				-- using GUIDs (the normal case)
				local g = (UnitGUID("player"))
				if g then
					recap_temp.PlayerGUID = recap_temp.PlayerGUID.."_"..Recap_TrimGUID(g)
				end
			end

			if recap.Opt.RecentData.value then
				Recap_CreateRecent()
			else
				recap_temp.Recent = {}
			end

			-- ignoring GUIDs disallows synchronization
			if recap.Opt.IgnoreGUIDs.value then
				recap.Opt.EnableSync.value = false
				recap.Opt.SyncState.value = "Ignore"
			end

			-- create our own private tooltip
			recap_temp.RecapTooltip = CreateFrame("GameTooltip", "RecapTooltip", UIParent, "GameTooltipTemplate")

			-- scale
			RecapSetScaleSlider:SetValue(recap.Opt.SetScale.value)
			newScale = Recap_Div2(recap.Opt.SetScale.value,100)
			RecapSetScaleSlider_Text:SetText(newScale)
			RecapFrame:SetScale(newScale)
			RecapOptFrame:SetScale(newScale)
			RecapPanel:SetScale(newScale)
			RecapRecent:SetScale(newScale)
			RecapMenu:SetScale(newScale)
			recap_temp.RecapTooltip:SetScale(newScale)

			if RecapFrame and not recap[recap_temp.p].WindowTop then
				RecapFrame:ClearAllPoints()
				RecapFrame:SetPoint("CENTER","UIParent","CENTER")
				RecapOptFrame:ClearAllPoints()
				RecapOptFrame:SetPoint("CENTER", "UIParent", "CENTER")
			elseif RecapFrame and recap[recap_temp.p].WindowTop then
				RecapFrame:ClearAllPoints()
				RecapFrame:SetPoint("TOPLEFT","UIParent","BOTTOMLEFT",math_max(recap[recap_temp.p].WindowLeft,0),math_max(recap[recap_temp.p].WindowTop,0))
				RecapFrame:SetWidth(recap[recap_temp.p].WindowWidth)
				RecapFrame:SetHeight(recap[recap_temp.p].WindowHeight)
			end

			-- silent repair
			if not recap.Combatant then
				recap.Combatant = {}
			end
			for i in pairs(recap.Combatant) do
				iCombatant = recap.Combatant[i]
				iCombatant.WasInCurrent = false
				iCombatant.WasInLast = false
				-- clear both of the Last Fight detail data structures before we start
				iCombatant.LastTime_1 = nil
				iCombatant.LastTimeIn_1 = nil
				iCombatant.LastTimeHeal_1 = nil
				iCombatant.LastMaxHit_1 = nil
				iCombatant.LastDmgIn_1 = nil
				iCombatant.LastDmgOut_1 = nil
				iCombatant.LastHPS_1 = nil
				iCombatant.LastDPSIn_1 = nil
				iCombatant.LastDPS_1 = nil
				iCombatant.LastKills_1 = nil
				iCombatant.LastRawHeal_1 = nil
				iCombatant.LastOverHeal_1 = nil
				iCombatant.LastOutgoingDetail_1 = nil
				iCombatant.LastTargetDetail_1 = nil
				iCombatant.LastIncomingDetail_1 = nil
				iCombatant.LastSourceDetail_1 = nil
				iCombatant.LastOtherDetail_1 = nil
				iCombatant.LastTime_2 = nil
				iCombatant.LastTimeIn_2 = nil
				iCombatant.LastTimeHeal_2 = nil
				iCombatant.LastMaxHit_2 = nil
				iCombatant.LastDmgIn_2 = nil
				iCombatant.LastDmgOut_2 = nil
				iCombatant.LastHPS_2 = nil
				iCombatant.LastDPSIn_2 = nil
				iCombatant.LastDPS_2 = nil
				iCombatant.LastKills_2 = nil
				iCombatant.LastRawHeal_2 = nil
				iCombatant.LastOverHeal_2 = nil
				iCombatant.LastOutgoingDetail_2 = nil
				iCombatant.LastTargetDetail_2 = nil
				iCombatant.LastIncomingDetail_2 = nil
				iCombatant.LastSourceDetail_2 = nil
				iCombatant.LastOtherDetail_2 = nil
			end
			recap_temp.ActiveLastFight = "1" -- set the Last Fight variables that we will begin storing into
			recap_temp.DisplayLastFight = "2" -- set the Last Fight variables that we will begin displaying from
			-- Note that I think LastDuration (etc.) should refer only to a displayed Last Fight
			recap[recap_temp.p].LastDuration = 0
			recap[recap_temp.p].LastDurationIn = 0
			recap[recap_temp.p].LastDurationHeal = 0
			recap[recap_temp.p].LastFightStart = 0
			recap[recap_temp.p].LastFightEnd = 0
			-- guard code for upgrade for 3.59 and later
			if not recap[recap_temp.p].TotalDurationIn then
				recap[recap_temp.p].TotalDurationIn = recap[recap_temp.p].TotalDuration
			end
			if not recap[recap_temp.p].TotalDurationHeal then
				recap[recap_temp.p].TotalDurationHeal = recap[recap_temp.p].TotalDuration
			end
			-- silent repair
			if not recap.Self[recap_temp.s] then
				recap.Self[recap_temp.s] = {}
			end
			-- not at the moment being done for the player's pets

			Recap_SetColors()

			-- if we loaded in any state except 'Stopped' (i.e. perhaps logged out in mid-fight), force into idle state
			if recap.Opt.State.value ~= "Stopped" then
				recap.Opt.State.value = "Idle"
			end
			Recap_ClearAsIfEndOfFight()
			Recap_SetState(false)

			-- was 82 now 144
			RecapTotals_Name:SetWidth(recap_temp.NameWidth)

			Recap_InitDataSets()

			if recap.Opt.LightData.value then
				recap.Opt.SelfView.value = false
				RecapSelfViewButton:Hide()
			end

			if recap.Opt.Minimized.value then
				Recap_SetButtons()
				Recap_ConstructList()
				Recap_Minimize()
			else
				Recap_Maximize()
			end

			Recap_Register_CombatEvents()

			recap_temp.Loaded = true

			Recap_InitializeOptions()
			Recap_MoveMinimize()
			Recap_SetRecapFrameBackdrop()

			-- initialize panel
			recap_temp.Selected = 0
			recap_temp.RecentSelected = 0
			if recap.Opt.LightData.value then
				recap.Opt.PanelView.value = 6
				RecapPanelTab1:SetAlpha(.5)
				RecapPanelTab2:SetAlpha(.5)
				RecapPanelTab3:SetAlpha(.5)
				RecapPanelTab4:SetAlpha(.5)
				RecapPanelTab5:SetAlpha(.5)
			end
			RecapPanel_SwitchPanels(recap.Opt.PanelView.value)
			if recap.Opt.PanelAnchor.value then
				RecapPanel:ClearAllPoints()
				RecapPanel:SetPoint(recap.Opt.PanelAnchor.Panel,"RecapFrame",recap.Opt.PanelAnchor.Main,Recap_PanelOffset("x"),Recap_PanelOffset("y"))
			end

			-- initialize recent
			RecapRecent_SwitchRecents()
			if recap.Opt.RecentAnchor.value then
				RecapRecent:ClearAllPoints()
				RecapRecent:SetPoint(recap.Opt.RecentAnchor.Recent,"RecapFrame",recap.Opt.RecentAnchor.Main,Recap_RecentOffset("x"),Recap_RecentOffset("y"))
			end

			-- clear any Sync values dependent on time, since we can't get times that are good across reboots
			if (recap.Opt.SyncState.value == "Member") or (recap.Opt.SyncState.value == "Leader") then
				recap.Opt.SyncUpdateWhen.value = math_floor(1000*GetTime()) -- integer thousandths
				recap_temp.SyncData = {}
				recap_temp.SyncInviteTimestamp = false
				recap_temp.SyncInviteLeader = false
				recap_temp.SyncInviteMergePets = false
				recap_temp.SyncInviteWhen = false
				recap_temp.SyncInviteNewOngoing = false
				recap_temp.AskingJoinSync = false
				recap_temp.OnCommReceived = false
			end

			if recap.Opt.Visible.value then
				RecapFrame_Show()
			else
				RecapFrame_Hide()
			end

			-- set frames that need to see the Escape key
			table_insert(UISpecialFrames,"RecapOptFrame")
			table_insert(UISpecialFrames,"RecapPanel")
			table_insert(UISpecialFrames,"RecapRecent")
			-- added main frame so that we can trap Escape and minimize instead
			if recap.Opt.Minimized.value or not recap.Opt.MinimizeOnEscape.value then
				-- a dummy if we are minimized or have Minimize on Escape turned off, so that we don't capture Escape when minimized
				table_insert(UISpecialFrames,"RecapFrameDummy")
			else
				table_insert(UISpecialFrames,"RecapFrame")
			end

			if recap.debug then
				DEFAULT_CHAT_FRAME:AddMessage("(recap.debug) Time to initialize: "..string_format("%.4f",GetTime()-init_time).." seconds.")
				if (recap_temp.p == "Hawksy_Elune") or (recap_temp.p == "Galassa_Elune") or (recap_temp.p == "Metrognome_Elune") then
					-- for me only, reset CPU profiling numbers
					ResetCPUUsage()
				end
			end

			-- warn if user has a lot of data (over 1000 combatants)
			x = 0
			for i in pairs(recap.Combatant) do
				if (i ~= recap_temp.GroupTotal) and (i ~= recap_temp.NonGroupTotal) then
					x = x + 1
				end
			end
			if x>1000 and recap.Opt.WarnData.value then
				StaticPopupDialogs["recap_temp.LOTSOFDATAWARNING"] = {
					text = TEXT(string_format(recap_temp.Localize.LotsOfDataWarning,x)),
					button1 = BINDING_NAME_RECAP_RESET_ALL,
					button2 = CANCEL,
					OnShow = function()
						if ((recap.Opt.SyncState.value == "Member") or (recap.Opt.SyncState.value == "Leader")) then
							-- No reset if in synchronization
							StaticPopup1Button1:Disable()
						end
					end,
					OnAccept = function()
						-- Reset if applicable
						if ((recap.Opt.SyncState.value == "Member") or (recap.Opt.SyncState.value == "Leader")) then
							-- No reset if in synchronization (button was disabled anyway)
						else
							PlaySound("GnomeExploration")
							RecapPanel_Hide(1)
							RecapRecent_Hide(1)
							Recap_ResetAllCombatants(false)
							Recap_SetView()
							Recap_MakeFriends()
							DEFAULT_CHAT_FRAME:AddMessage(RECAP_RECAP.." "..RECAP_ALL_FIGHTS_RESET)
						end
						collectgarbage("collect")
					end,
					OnHide = function()
					end,
					OnCancel = function()
					end,
					timeout = 0,
					showAlert = 1,
					whileDead = 1
				}
				StaticPopup_Show("recap_temp.LOTSOFDATAWARNING")
			end
		end
	end

	return true
end

function Recap_IntegrityCheck()
	-- this statement, and the corresponding declarations, need to be updated for every version
	if not Recap_lua_411 then
		DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.VersionCheck.." (Recap.lua)", 1.0, 0.2, 0.2)
		Recap_Shutdown()
		return false
	end
	if not RecapCombat_lua_411 then
		DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.VersionCheck.." (RecapCombat.lua)", 1.0, 0.2, 0.2)
		Recap_Shutdown()
		return false
	end
	if not RecapSync_lua_411 then
		DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.VersionCheck.." (RecapSync.lua)", 1.0, 0.2, 0.2)
		Recap_Shutdown()
		return false
	end
	if not RecapAux_lua_411 then
		DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.VersionCheck.." (RecapAux.lua)", 1.0, 0.2, 0.2)
		Recap_Shutdown()
		return false
	end
	if not RecapOptions_lua_411 then
		DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.VersionCheck.." (RecapOptions.lua)", 1.0, 0.2, 0.2)
		Recap_Shutdown()
		return false
	end
	if not RecapPanel_lua_411 then
		DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.VersionCheck.." (RecapPanel.lua)", 1.0, 0.2, 0.2)
		Recap_Shutdown()
		return false
	end
	if not RecapRecent_lua_411 then
		DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.VersionCheck.." (RecapRecent.lua)", 1.0, 0.2, 0.2)
		Recap_Shutdown()
		return false
	end
	if not Recap_xml_411 then
		DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.VersionCheck.." (Recap.xml)", 1.0, 0.2, 0.2)
		Recap_Shutdown()
		return false
	end
	if not RecapOptions_xml_411 then
		DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.VersionCheck.." (RecapOptions.xml)", 1.0, 0.2, 0.2)
		Recap_Shutdown()
		return false
	end
	if not RecapPanel_xml_411 then
		DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.VersionCheck.." (RecapPanel.xml)", 1.0, 0.2, 0.2)
		Recap_Shutdown()
		return false
	end
	if not RecapRecent_xml_411 then
		DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.VersionCheck.." (RecapRecent.xml)", 1.0, 0.2, 0.2)
		Recap_Shutdown()
		return false
	end
	if not localization_lua_411 then
		DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.VersionCheck.." (localization.lua)", 1.0, 0.2, 0.2)
		Recap_Shutdown()
		return false
	end
	if not localization_de_lua_411 then
		DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.VersionCheck.." (localization.de.lua)", 1.0, 0.2, 0.2)
		Recap_Shutdown()
		return false
	end
	if not localization_cn_lua_411 then
		DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.VersionCheck.." (localization.cn.lua)", 1.0, 0.2, 0.2)
		Recap_Shutdown()
		return false
	end
	if not localization_tw_lua_411 then
		DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.VersionCheck.." (localization.tw.lua)", 1.0, 0.2, 0.2)
		Recap_Shutdown()
		return false
	end
	return true
end

-- action==1 to hide buttons, 16 to show
function Recap_ShowButtons(action)

	RecapCloseButton:SetWidth(action)
	RecapPinButton:SetWidth(action)
	RecapPauseButton:SetWidth(action)
	RecapOptionsButton:SetWidth(action)
	RecapShowAllButton:SetWidth(action)

	if action==16 then
		RecapCloseButton:Show()
		RecapPinButton:Show()
		RecapPauseButton:Show()
		RecapOptionsButton:Show()
		RecapShowAllButton:Show()
	else
		RecapCloseButton:Hide()
		RecapPinButton:Hide()
		RecapPauseButton:Hide()
		RecapOptionsButton:Hide()
		RecapShowAllButton:Hide()
	end
end

function Recap_Minimize()

	local i, j, iOpt
	local _G = getfenv(0)
	local cx = 20 -- 8(edge)+4(space right of status)+8

	recap.Opt.Minimized.value = true

	-- to support the desired Escape behaviour, obscure the special status of RecapFrame so that it doesn't capture Escape when minimized
	local k, m
	for k,m in ipairs(UISpecialFrames) do
		if m == "RecapFrame" then
			UISpecialFrames[k] = "RecapFrameDummy"
		end
	end

	for i in pairs(recap.Opt) do
		iOpt = recap_temp.DefaultOpt[i]
		if iOpt and iOpt.minwidth then
			if recap.Opt[i].value then
				item = _G["Recap"..i]
				item:SetWidth(iOpt.minwidth)
				item:Show()
				cx = cx + iOpt.minwidth
			else
				item = _G["Recap"..i]
				item:SetWidth(1)
				item:Hide()
				cx = cx + 1
			end
		elseif iOpt and (iOpt.width or iOpt.ewidth) then
			_G["RecapHeader_"..i]:Hide()
		end
	end

	if recap.Opt.MinButtons.value then
		cx = cx + 108
		Recap_ShowButtons(16)
	else
		Recap_ShowButtons(1)
		cx = cx + 23 -- 5 + 18
	end

	RecapTopBar:Hide()
	RecapBottomBar:Hide()
	RecapResetButton:Hide()

	for i=1,15 do
		_G["RecapList"..i]:Hide()
		_G["RecapRecentList"..i]:Hide()
		_G["RecapSelf"..i]:Hide()
		_G["RecapRecentSelf"..i]:Hide()
	end
	RecapTotals:Hide()
	RecapGroupTotalButton:Hide()
	RecapNonGroupTotalButton:Hide()
	RecapHeader_Name:Hide()
	RecapHeader_EName:Hide()
	RecapScrollBar:Hide()

	if recap.Opt.AutoMinimize.value then
		cx = cx-15
	end

	if recap.Opt.GrowLeftwards.value and RecapFrame then
		i = RecapFrame:GetRight()
		j = RecapFrame:GetTop()
		if i and j then
			RecapFrame:ClearAllPoints()
			RecapFrame:SetPoint("TOPLEFT","UIParent","BOTTOMLEFT",math_max(i-cx,0),math_max(j,0))
		else
			-- default behaviour if any undefined
			RecapFrame:ClearAllPoints()
			RecapFrame:SetPoint("CENTER","UIParent","CENTER")
		end
	end
	RecapFrame:SetWidth(cx)
	Recap_SetHeight(28)

	if recap.Opt.MinBack.value then
		RecapFrame:SetBackdropColor(1,1,1,1)
		RecapFrame:SetBackdropBorderColor(.5,.5,.5,1)
	else
		RecapFrame:SetBackdropColor(0,0,0,0)
		RecapFrame:SetBackdropBorderColor(0,0,0,0)
	end

	RecapSelfViewButton:Hide()
	RecapPanel_Hide(1)
	RecapRecent_Hide(1)
	Recap_MoveMinimize()
	Recap_TitleBar()
	Recap_SetTitleBackground()
	Recap_DisplayMinimizedDPS()
end

function Recap_Maximize()

	local i, iOpt
	local _G = getfenv(0)

	recap.Opt.Minimized.value = false

	Recap_SetColumns() -- this calls SetView which in turn calls ConstructList

	for i in pairs(recap.Opt) do
		iOpt = recap_temp.DefaultOpt[i]
		if iOpt and iOpt.minwidth then
			item = _G["Recap"..i]
			item:SetWidth(iOpt.minwidth)
			item:Hide()
		end
	end
	RecapMinStatus:Show()
	RecapMinSyncStatus:Show()
	RecapMinView:Show()
	Recap_ShowButtons(16)

	RecapTopBar:Show()
	RecapBottomBar:Show()
	RecapResetButton:Show()

	RecapScrollBar:Show()

	if recap.Opt.SelfView.value then
		RecapTotals:Hide()
		RecapGroupTotalButton:Hide()
		RecapNonGroupTotalButton:Hide()
		RecapHeader_Name:Hide()
		RecapHeader_EName:Show()
	else
		RecapTotals:Show()
		RecapGroupTotalButton:Show()
		RecapNonGroupTotalButton:Show()
		RecapHeader_Name:Show()
		RecapHeader_EName:Hide()
	end

	RecapFrame:SetBackdropColor(1,1,1,1)
	RecapFrame:SetBackdropBorderColor(.5,.5,.5,1)
	if not recap.Opt.LightData.value then
		RecapSelfViewButton:Show()
	end
	Recap_MoveMinimize()

	-- to support the desired Escape behaviour, make RecapFrame special so that it captures Escape when maximized (but only when we have Minimize on Escape turned on)
	if recap.Opt.MinimizeOnEscape.value then
		local k, m
		for k,m in ipairs(UISpecialFrames) do
			if m == "RecapFrameDummy" then
				UISpecialFrames[k] = "RecapFrame"
			end
		end
	end

end

function Recap_MoveMinimize()

	RecapCloseButton:ClearAllPoints()
	RecapCloseButton:SetPoint("TOPRIGHT", "RecapFrame", "TOPRIGHT", -6, -6)
	RecapMinStatus:ClearAllPoints()
	RecapMinStatus:SetPoint("TOPLEFT", "RecapFrame", "TOPLEFT", 6, -7)
	RecapResetButton:ClearAllPoints()
	RecapResetButton:SetPoint("BOTTOMLEFT", "RecapFrame", "BOTTOMLEFT", 5, 4)
	RecapMinimizeButton:ClearAllPoints()

	if recap.Opt.GrowLeftwards.value and not recap.Opt.GrowUpwards.value then -- topright
		RecapMinimizeButton:SetPoint("TOPRIGHT", "RecapFrame", "TOPRIGHT", -6, -6)
		RecapCloseButton:SetPoint("TOPRIGHT", "RecapMinimizeButton", "TOPLEFT", -2, 0)
	elseif recap.Opt.GrowLeftwards.value and recap.Opt.GrowUpwards.value then -- bottomright
		RecapMinimizeButton:SetPoint("BOTTOMRIGHT", "RecapFrame", "BOTTOMRIGHT", -6, 6)
		if recap.Opt.Minimized.value then
			RecapCloseButton:SetPoint("TOPRIGHT", "RecapMinimizeButton", "TOPLEFT", -2, 0)
		end
	elseif not recap.Opt.GrowLeftwards.value and not recap.Opt.GrowUpwards.value then -- topleft
		RecapMinimizeButton:SetPoint("TOPLEFT", "RecapFrame", "TOPLEFT", 6, -6)
		RecapMinStatus:SetPoint("TOPLEFT", "RecapMinimizeButton", "TOPRIGHT", 2, -1)
	else -- bottomleft
		RecapMinimizeButton:SetPoint("BOTTOMLEFT", "RecapFrame", "BOTTOMLEFT", 6, 6)
		RecapResetButton:SetPoint("BOTTOMLEFT", "RecapFrame", "BOTTOMLEFT", 28, 4)
	end

	if recap.Opt.Minimized.value and not recap.Opt.GrowLeftwards.value then
		RecapMinStatus:SetPoint("TOPLEFT", "RecapMinimizeButton", "TOPRIGHT", 2, -1)
	end

	if recap.Opt.AutoMinimize.value then
		RecapMinimizeButton:SetWidth(1)
		RecapMinimizeButton:Hide()
	else
		RecapMinimizeButton:SetWidth(16)
		RecapMinimizeButton:Show()
	end

end

function Recap_SetHeight(newcy)

	local i,j

	if recap.Opt.GrowUpwards.value and RecapFrame then
		i = RecapFrame:GetBottom()
		j = RecapFrame:GetLeft()
		if i and j then
			RecapFrame:ClearAllPoints()
			RecapFrame:SetPoint("TOPLEFT","UIParent","BOTTOMLEFT",math_max(j,0),math_max(i+newcy,0))
		else
			-- default behaviour if any undefined
			RecapFrame:ClearAllPoints()
			RecapFrame:SetPoint("CENTER","UIParent","CENTER")
		end
	end

	RecapFrame:SetHeight(newcy)
	Recap_CheckWindowBounds()

end

function RecapScrollBar_Update()

	-- only called when not minimized

	local i, j, index, item
	local listsize = recap.Opt.SelfView.value and recap_temp.SelfListSize or recap_temp.ListSize
	local thisCombatant, iCombatant, iList
	local _G = getfenv(0)

	i = 72 + (math_max(math_min(listsize-1,recap.Opt.MaxRows.value),1 )*14 )
	Recap_SetHeight(i)
	RecapScrollBar:SetHeight(i-63)
	FauxScrollFrame_Update(RecapScrollBar,listsize-1,recap.Opt.MaxRows.value,14)

	for i=1,recap.Opt.MaxRows.value do
		index = i + FauxScrollFrame_GetOffset(RecapScrollBar)

		if not recap.Opt.SelfView.value then
			-- general view

			if index < listsize then
				iList = recap_temp.List[index]
				thisCombatant = iList.Name
				if thisCombatant then
					iCombatant = recap.Combatant[thisCombatant]
					if iCombatant then

						-- there is a display problem when switching from Personal Details
						--   to All Fights or Last Fight if the fights display begins with hidden
						--   columns.  The workaround appears to be to force the first four columns
						--   (Ranks, Faction, Class, and Level) to always appear (though perhaps
						--   with blank content).
						--   See more code in Recap_SetColumns and Recap_ConstructList,
						--   and a texture addition to RecapHeader_Faction.
						if recap.Opt.Ranks.value then
							-- Ranks will appear
							_G["RecapList"..i.."_Ranks"]:SetText(index)
						else
							-- Ranks needs to be set to blank
							_G["RecapList"..i.."_Ranks"]:SetText("")
						end
						if recap.Opt.Faction.value then
							-- Faction and Level will appear
							Recap_SetFactionIcon(i, iCombatant.Faction)
							if iCombatant.Level and tonumber(iCombatant.Level)>0 then
								_G["RecapList"..i.."_Level"]:SetText(iCombatant.Level)
							elseif iCombatant.Level and tonumber(iCombatant.Level)==-1 then
								_G["RecapList"..i.."_Level"]:SetText("??")
							else
								_G["RecapList"..i.."_Level"]:SetText("")
							end
						else
							-- Faction icon needs to be set to black, and Level to blank
							Recap_SetFactionIcon(i, nil)
							_G["RecapList"..i.."_Level"]:SetText("")
						end
						if recap.Opt.Class.value then
							-- Class will appear
							Recap_SetClassIcon(i, iCombatant.Class)
						else
							-- Class icon needs to be set to black
							Recap_SetClassIcon(i, nil)
						end

						item = _G["RecapList"..i.."_Name"]
						item:SetText(Recap_StripGUIDsFromCombatant(thisCombatant))
						if iCombatant.Friend then
							item:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
						else
							item:SetTextColor(recap_temp.ColorWhite.r,recap_temp.ColorWhite.g,recap_temp.ColorWhite.b)
						end

						item = _G["RecapList"..i.."_Gauge"]
						if recap.Opt.ShowGauges.value and recap_temp.GaugeMax>0 and recap_temp.GaugeBy and iCombatant.Friend then
							item:SetWidth(1+recap_temp.GaugeWidth*iList[recap_temp.GaugeBy]/recap_temp.GaugeMax)
							item:Show()
						else
							item:Hide()
						end

						_G["RecapList"..i.."_Seen"]:SetText(Recap_FormatTimeSeen((iList.Seen or 0)/1000))

						_G["RecapList"..i.."_Kills"]:SetText(iList.Kills)

						_G["RecapList"..i.."_Time"]:SetText(Recap_FormatTime(iList.Time))
						_G["RecapList"..i.."_TimeIn"]:SetText(Recap_FormatTime(iList.TimeIn))
						_G["RecapList"..i.."_TimeHeal"]:SetText(Recap_FormatTime(iList.TimeHeal))

						item = _G["RecapList"..i.."_Heal"]
						item:SetText(iList.RawHeal - iList.OverHeal)
						if iCombatant.Friend then
							item:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
							_G["RecapList"..i.."_HealP"]:SetText(iList.HealP.."%")
							_G["RecapList"..i.."_Over"]:SetText(iList.Over.."%")
						else
							item:SetTextColor(recap_temp.ColorWhite.r,recap_temp.ColorWhite.g,recap_temp.ColorWhite.b)
							_G["RecapList"..i.."_HealP"]:SetText("")
							_G["RecapList"..i.."_Over"]:SetText("")
						end

						_G["RecapList"..i.."_MaxHit"]:SetText(iList.MaxHit)

						item = _G["RecapList"..i.."_DmgIn"]
						item:SetText(iList.DmgIn)
						if iCombatant.Friend then
							item:SetTextColor(recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b)
							_G["RecapList"..i.."_DmgInP"]:SetText(iList.DmgInP.."%")
						else
							item:SetTextColor(recap_temp.ColorWhite.r,recap_temp.ColorWhite.g,recap_temp.ColorWhite.b)
							_G["RecapList"..i.."_DmgInP"]:SetText("")
						end

						item = _G["RecapList"..i.."_DmgOut"]
						item:SetText(iList.DmgOut)
						if iCombatant.Friend then
							item:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
							_G["RecapList"..i.."_DmgOutP"]:SetText(iList.DmgOutP.."%")
						else
							item:SetTextColor(recap_temp.ColorWhite.r,recap_temp.ColorWhite.g,recap_temp.ColorWhite.b)
							_G["RecapList"..i.."_DmgOutP"]:SetText("")
						end

						item = _G["RecapList"..i.."_HPS"]
						if iList.HPS<1000 then
							item:SetFormattedText("%.1f",iList.HPS)
						else
							item:SetFormattedText("%d",Recap_Round1(iList.HPS))
						end
						if iCombatant.Friend then
							item:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
						else
							item:SetTextColor(recap_temp.ColorWhite.r,recap_temp.ColorWhite.g,recap_temp.ColorWhite.b)
						end
						item = _G["RecapList"..i.."_DPSIn"]
						if iList.DPSIn<1000 then
							item:SetFormattedText("%.1f",iList.DPSIn)
						else
							item:SetFormattedText("%d",Recap_Round1(iList.DPSIn))
						end
						if iCombatant.Friend then
							item:SetTextColor(recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b)
						else
							item:SetTextColor(recap_temp.ColorWhite.r,recap_temp.ColorWhite.g,recap_temp.ColorWhite.b)
						end
						item = _G["RecapList"..i.."_DPS"]
						if iList.DPS<1000 then
							item:SetFormattedText("%.1f",iList.DPS)
						else
							item:SetFormattedText("%d",Recap_Round1(iList.DPS))
						end
						if iCombatant.Friend then
							item:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
						else
							item:SetTextColor(recap_temp.ColorWhite.r,recap_temp.ColorWhite.g,recap_temp.ColorWhite.b)
						end

						item = _G["RecapList"..i.."_DPSvsAll"]
						if iList.DPSvsAll<1000 then
							item:SetFormattedText("%.1f",iList.DPSvsAll)
						else
							item:SetFormattedText("%d",Recap_Round1(iList.DPSvsAll))
						end
						if iCombatant.Friend then
							item:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
						else
							item:SetTextColor(recap_temp.ColorWhite.r,recap_temp.ColorWhite.g,recap_temp.ColorWhite.b)
						end

						item = _G["RecapList"..i]
						item:Show()
						if recap_temp.Selected == index then
							item:LockHighlight()
						else
							item:UnlockHighlight()
						end

						local r,g,b = _G["RecapList"..i.."_Name"]:GetTextColor()
						_G["RecapRecentList"..i.."_Text"]:SetTextColor(r, g, b)
						_G["RecapRecentList"..i.."_SaveColor"]:SetTextColor(r, g, b)
						_G["RecapRecentList"..i]:Show()
					end
				end
			else
				_G["RecapList"..i]:Hide()
				_G["RecapList"..i]:UnlockHighlight()
				_G["RecapRecentList"..i]:Hide()
			end

			for i=recap.Opt.MaxRows.value+1,15 do
				_G["RecapList"..i]:Hide()
				_G["RecapRecentList"..i]:Hide()
			end

		elseif recap.Opt.SelfView.value then
			-- personal view

			if index < listsize then
				iList = recap_temp.SelfList[index]

				_G["RecapSelf"..i.."_EName"]:SetText(string_sub(iList.EName,2))
				_G["RecapSelf"..i.."_EElement"]:SetText(iList.EElement)
				_G["RecapSelf"..i.."_ETotal"]:SetText(iList.ETotal)
				_G["RecapSelf"..i.."_EGlances"]:SetText(iList.EGlances)
				_G["RecapSelf"..i.."_EGlancesMin"]:SetText(iList.EGlancesMin)
				_G["RecapSelf"..i.."_EGlancesAvg"]:SetText(iList.EGlancesAvg)
				_G["RecapSelf"..i.."_EGlancesMax"]:SetText(iList.EGlancesMax)
				_G["RecapSelf"..i.."_EHits"]:SetText(iList.EHits)
				_G["RecapSelf"..i.."_EHitsMin"]:SetText(iList.EHitsMin)
				_G["RecapSelf"..i.."_EHitsAvg"]:SetText(iList.EHitsAvg)
				_G["RecapSelf"..i.."_EHitsMax"]:SetText(iList.EHitsMax)
				_G["RecapSelf"..i.."_ETicks"]:SetText(iList.ETicks)
				_G["RecapSelf"..i.."_ETicksMin"]:SetText(iList.ETicksMin)
				_G["RecapSelf"..i.."_ETicksAvg"]:SetText(iList.ETicksAvg)
				_G["RecapSelf"..i.."_ETicksMax"]:SetText(iList.ETicksMax)
				_G["RecapSelf"..i.."_ECrits"]:SetText(iList.ECrits)
				_G["RecapSelf"..i.."_ECritsMin"]:SetText(iList.ECritsMin)
				_G["RecapSelf"..i.."_ECritsAvg"]:SetText(iList.ECritsAvg)
				_G["RecapSelf"..i.."_ECritsMax"]:SetText(iList.ECritsMax)
				_G["RecapSelf"..i.."_ECritsP"]:SetText(iList.ECritsP)
				_G["RecapSelf"..i.."_EMiss"]:SetText(iList.EMiss)
				_G["RecapSelf"..i.."_EMissP"]:SetText(iList.EMissP)
				_G["RecapSelf"..i.."_EMaxAll"]:SetText(iList.EMaxAll)
				_G["RecapSelf"..i.."_ETotalP"]:SetText(iList.ETotalP)
				if (string_sub(iList.EName,1,1) == "1") or (string_sub(iList.EName,1,1) == "2") then
					_G["RecapSelf"..i.."_EName"]:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
					_G["RecapSelf"..i.."_EElement"]:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
					_G["RecapSelf"..i.."_ETotal"]:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
					_G["RecapSelf"..i.."_ETotalP"]:SetTextColor(recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
				else
					_G["RecapSelf"..i.."_EName"]:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
					_G["RecapSelf"..i.."_EElement"]:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
					_G["RecapSelf"..i.."_ETotal"]:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
					_G["RecapSelf"..i.."_ETotalP"]:SetTextColor(recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
				end
				_G["RecapSelf"..i]:Show()

				item = _G["RecapRecentSelf"..i]
				_G["RecapRecentSelf"..i.."_Text"]:SetTextColor(recap_temp.ColorGreen.r, recap_temp.ColorGreen.g, recap_temp.ColorGreen.b)
				_G["RecapRecentSelf"..i.."_SaveColor"]:SetTextColor(recap_temp.ColorGreen.r, recap_temp.ColorGreen.g, recap_temp.ColorGreen.b)
				item:Show()
			else
				_G["RecapSelf"..i]:Hide()
				_G["RecapRecentSelf"..i]:Hide()
			end

			for i=recap.Opt.MaxRows.value+1,15 do
				_G["RecapSelf"..i]:Hide()
				_G["RecapRecentSelf"..i]:Hide()
			end
		end
	end
end


-- the following does both DPS and HPS
function Recap_UpdateMinimizedDPS()

	local i, playerDPSLast, playerHPSLast, playerDPSAll, playerHPSAll, petDPSLast, petHPSLast, petDPSAll, petHPSAll, iLastOwner, iLastPet, iTotal
	local groupDurationLast, groupDurationInLast, groupDurationHealLast, groupDmgOutLast, groupDmgInLast, groupHealLast, overhealing
	local groupDurationAll, groupDurationInAll, groupDurationHealAll, groupDmgOutAll, groupDmgInAll, groupHealAll

	-- player live DPS and HPS
	playerDPSLast = 0
	playerHPSLast = 0
	playerDPSAll = 0
	playerHPSAll = 0
	iLastOwner = recap_temp.Last[recap_temp.PlayerGUID]
	if Recap_PetsMerged() then
		-- merge pet DPS and HPS
		playerDPSLast, playerDPSAll = Recap_GetCurrentDPSMergePets(recap_temp.PlayerGUID, iLastOwner)
		playerHPSLast, playerHPSAll = Recap_GetCurrentHPSMergePets(recap_temp.PlayerGUID, iLastOwner)
	else
		-- add pet DPS and HPS (subtly different)
		playerDPSLast, playerDPSAll = Recap_GetCurrentDPS(recap_temp.PlayerGUID, iLastOwner)
		playerHPSLast, playerHPSAll = Recap_GetCurrentHPS(recap_temp.PlayerGUID, iLastOwner)
		-- optimization for a scan of Last looking for player's pets
		for i in pairs(recap_temp.LastPlayerPets) do
			local iLastPet = recap_temp.Last[i]
			if iLastPet then
				if iLastPet.DmgOut>0 then
					-- this pet did damage
					petDPSLast, petDPSAll = Recap_GetCurrentDPS(pet, iLastPet)
					playerDPSLast = playerDPSLast + petDPSLast
					playerDPSAll = playerDPSAll + petDPSAll
				end
				if iLastPet.RawHeal>0 then
					-- this pet did healing
					petHPSLast, petHPSAll = Recap_GetCurrentHPS(pet, iLastPet)
					playerHPSLast = playerHPSLast + petHPSLast
					playerHPSAll = playerHPSAll + petHPSAll
				end
			end
		end
	end
	recap_temp.PlayerDPSLast = playerDPSLast
	recap_temp.PlayerDPSAll = playerDPSAll
	recap_temp.PlayerHPSLast = playerHPSLast
	recap_temp.PlayerHPSAll = playerHPSAll

	-- group live DPS and HPS
	groupDurationLast = 0
	groupDurationInLast = 0
	groupDurationHealLast = 0
	groupDmgOutLast = 0
	groupDmgInLast = 0
	groupHealLast = 0
	groupDurationAll = 0
	groupDurationInAll = 0
	groupDurationHealAll = 0
	if (recap_temp.FightStart > 0) and (recap_temp.FightEnd > recap_temp.FightStart) then
		groupDurationLast = recap_temp.FightEnd - recap_temp.FightStart
	end
	if (recap_temp.FightStartIn > 0) and (recap_temp.FightEndIn > recap_temp.FightStartIn) then
		groupDurationInLast = recap_temp.FightEndIn - recap_temp.FightStartIn
	end
	if (recap_temp.FightStartHeal > 0) and (recap_temp.FightEndHeal > recap_temp.FightStartHeal) then
		groupDurationHealLast = recap_temp.FightEndHeal - recap_temp.FightStartHeal
	end
	-- optimization for a scan of Last looking for Friend combatants
	for i in pairs(recap_temp.InFriend) do
		local iLast = recap_temp.Last[i]
		if iLast then
			groupDmgOutLast = groupDmgOutLast + (iLast.DmgOut or 0)
			groupDmgInLast = groupDmgInLast + (iLast.DmgIn or 0)
			overhealing = math_min((iLast.OverHeal or 0), (iLast.RawHeal or 0))
			groupHealLast = groupHealLast + (iLast.RawHeal or 0) - overhealing
		end
	end
	recap_temp.GroupDPSOutLast = 0
	recap_temp.GroupDPSInLast = 0
	recap_temp.GroupHPSLast = 0
	if groupDurationLast > recap_temp.MinTime then
		recap_temp.GroupDPSOutLast = Recap_Div1(groupDmgOutLast, groupDurationLast)
	end
	if groupDurationInLast > recap_temp.MinTime then
		recap_temp.GroupDPSInLast = Recap_Div1(groupDmgInLast, groupDurationInLast)
	end
	if groupDurationHealLast > recap_temp.MinTime then
		recap_temp.GroupHPSLast = Recap_Div1(groupHealLast, groupDurationHealLast)
	end
	iTotal = recap[recap_temp.p]
	if iTotal then
		groupDurationAll = groupDurationLast + iTotal.TotalDuration
		groupDurationInAll = groupDurationInLast + iTotal.TotalDurationIn
		groupDurationHealAll = groupDurationHealLast + iTotal.TotalDurationHeal
	end
	groupDmgOutAll = groupDmgOutLast + (recap_temp.TotalGroupDmgOut or 0)
	groupDmgInAll = groupDmgInLast + (recap_temp.TotalGroupDmgIn or 0)
	groupHealAll = groupHealLast + (recap_temp.TotalGroupHeal or 0)
	recap_temp.GroupDPSOutAll = 0
	recap_temp.GroupDPSInAll = 0
	recap_temp.GroupHPSAll = 0
	if groupDurationAll > recap_temp.MinTime then
		recap_temp.GroupDPSOutAll = Recap_Div1(groupDmgOutAll, groupDurationAll)
	end
	if groupDurationInAll > recap_temp.MinTime then
		recap_temp.GroupDPSInAll = Recap_Div1(groupDmgInAll, groupDurationInAll)
	end
	if groupDurationHealAll > recap_temp.MinTime then
		recap_temp.GroupHPSAll = Recap_Div1(groupHealAll, groupDurationHealAll)
	end
end
-- returns the current DPS of combatant
function Recap_GetCurrentDPS(combatant, iLast)
	local durationLast, damageLast, DPSLast, iTotal, durationAll, damageAll, DPSAll
	durationLast = 0
	damageLast = 0
	DPSLast = 0
	durationAll = 0
	damageAll = 0
	DPSAll = 0
	if iLast and (iLast.DmgOut > 0) then
		if iLast.StartOut > 0 and (iLast.EndOut > iLast.StartOut) then
			durationLast = iLast.EndOut - iLast.StartOut
		end
		damageLast = iLast.DmgOut
	end
	if durationLast > recap_temp.MinTime then
		DPSLast = Recap_Div1(damageLast, durationLast)
	end
	iTotal = recap.Combatant[combatant]
	if iTotal then
		durationAll = durationLast + (iTotal.TotalTime or 0)
		damageAll = damageLast + (iTotal.TotalDmgOut or 0)
	end
	if durationAll > recap_temp.MinTime then
		DPSAll = Recap_Div1(damageAll, durationAll)
	end
	return DPSLast, DPSAll
end
-- returns the current HPS of combatant
function Recap_GetCurrentHPS(combatant, iLast)
	local durationLast, overhealing, healingLast, HPSLast, iTotal, durationAll, healingAll, HPSAll
	durationLast = 0
	healingLast = 0
	HPSLast = 0
	durationAll = 0
	healingAll = 0
	HPSAll = 0
	if iLast and (iLast.RawHeal > 0) then
		if iLast.StartHeal > 0 and (iLast.EndHeal > iLast.StartHeal) then
			durationLast = iLast.EndHeal - iLast.StartHeal
		end
		overhealing = math_min(iLast.OverHeal, iLast.RawHeal)
		healingLast = iLast.RawHeal - overhealing
	end
	if durationLast > recap_temp.MinTime then
		HPSLast = Recap_Div1(healingLast, durationLast)
	end
	iTotal = recap.Combatant[combatant]
	if iTotal then
		durationAll = durationLast + (iTotal.TotalTimeHeal or 0)
		overhealing = math_min((iTotal.TotalOverHeal or 0), (iTotal.TotalRawHeal or 0))
		healingAll = healingLast + (iTotal.TotalRawHeal or 0) - overhealing
	end
	if durationAll > recap_temp.MinTime then
		HPSAll = Recap_Div1(healingAll, durationAll)
	end
	return HPSLast, HPSAll
end
function Recap_GetCurrentDPSMergePets(owner, iLastOwner)
	local i, iLastPet, startTime, endTime, durationLast, damageLast, DPSLast, iTotal, durationAll, damageAll, DPSAll
	startTime = 0
	endTime = 0
	durationLast = 0
	damageLast = 0
	DPSLast = 0
	durationAll = 0
	damageAll = 0
	DPSAll = 0
	if iLastOwner and (iLastOwner.DmgOut > 0) then
		-- owner did damage
		startTime = iLastOwner.StartOut
		endTime = iLastOwner.EndOut
		damageLast = iLastOwner.DmgOut
	end
	-- optimization for a scan of Last looking for player's pets
	for i in pairs(recap_temp.LastPlayerPets) do
		iLastPet = recap_temp.Last[i]
		if iLastPet and (iLastPet.DmgOut > 0) then
			-- player owns or controls this one
			-- this pet did damage, merge times and add damages
			if startTime > 0 then
				startTime = math_min(startTime,iLastPet.StartOut)
			else
				startTime = iLastPet.StartOut
			end
			if endTime > 0 then
				endTime = math_max(endTime,iLastPet.EndOut)
			else
				endTime = iLastPet.EndOut
			end
			damageLast = damageLast + iLastPet.DmgOut
		end
	end
	if startTime > 0 and (endTime > startTime) then
		durationLast = endTime - startTime
	end
	if durationLast > recap_temp.MinTime then
		DPSLast = Recap_Div1(damageLast, durationLast)
	end
	iTotal = recap.Combatant[owner]
	if iTotal then
		durationAll = durationLast + (iTotal.TotalTime or 0)
		damageAll = damageLast + (iTotal.TotalDmgOut or 0)
	end
	if durationAll > recap_temp.MinTime then
		DPSAll = Recap_Div1(damageAll, durationAll)
	end
	return DPSLast, DPSAll
end
function Recap_GetCurrentHPSMergePets(owner, iLastOwner)
	local i, iLastPet, startTime, endTime, durationLast, overhealing, healingLast, HPSLast, iTotal, durationAll, healingAll, HPSAll
	startTime = 0
	endTime = 0
	durationLast = 0
	healingLast = 0
	HPSLast = 0
	durationAll = 0
	healingAll = 0
	HPSAll = 0
	if iLastOwner and (iLastOwner.RawHeal>0) then
		-- owner did healing
		startTime = iLastOwner.StartHeal
		endTime = iLastOwner.EndHeal
		overhealing = math_min(iLastOwner.OverHeal, iLastOwner.RawHeal)
		healingLast = iLastOwner.RawHeal - overhealing
	end
	-- optimization for a scan of Last looking for player's pets
	for i in pairs(recap_temp.LastPlayerPets) do
		iLastPet = recap_temp.Last[i]
		if iLastPet and (iLastPet.RawHeal > 0) then
			-- player owns or controls this one
			-- this pet did healing, merge times and add healing
			if startTime > 0 then
				startTime = math_min(startTime,iLastPet.StartHeal)
			else
				startTime = iLastPet.StartHeal
			end
			if endTime > 0 then
				endTime = math_max(endTime,iLastPet.EndHeal)
			else
				endTime = iLastPet.EndHeal
			end
			overhealing = math_min(iLastPet.OverHeal,iLastPet.RawHeal)
			healingLast = healingLast + iLastPet.RawHeal - overhealing
		end
	end
	if startTime > 0 and (endTime > startTime) then
		durationLast = endTime - startTime
	end
	if durationLast > recap_temp.MinTime then
		HPSLast = Recap_Div1(healingLast, durationLast)
	end
	iTotal = recap.Combatant[owner]
	if iTotal then
		durationAll = durationLast + (iTotal.TotalTimeHeal or 0)
		overhealing = math_min((iTotal.TotalOverHeal or 0), (iTotal.TotalRawHeal or 0))
		healingAll = healingLast + (iTotal.TotalRawHeal or 0) - overhealing
	end
	if durationAll > recap_temp.MinTime then
		HPSAll = Recap_Div1(healingAll, durationAll)
	end
	return HPSLast, HPSAll
end
-- we have calculated live numbers, now display them appropriately and send them to any plugins
function Recap_DisplayMinimizedDPS()
	if recap.Opt.View.value=="Last" then
		RecapMinYourDPS_Text:SetFormattedText("%.1f", recap_temp.PlayerDPSLast)
		RecapMinYourHPS_Text:SetFormattedText("%.1f", recap_temp.PlayerHPSLast)
		RecapMinDPSOut_Text:SetFormattedText("%.1f", recap_temp.GroupDPSOutLast)
		RecapMinDPSIn_Text:SetFormattedText("%.1f", recap_temp.GroupDPSInLast)
		RecapMinHPS_Text:SetFormattedText("%.1f", recap_temp.GroupHPSLast)
	else
		RecapMinYourDPS_Text:SetFormattedText("%.1f", recap_temp.PlayerDPSAll)
		RecapMinYourHPS_Text:SetFormattedText("%.1f", recap_temp.PlayerHPSAll)
		RecapMinDPSOut_Text:SetFormattedText("%.1f", recap_temp.GroupDPSOutAll)
		RecapMinDPSIn_Text:SetFormattedText("%.1f", recap_temp.GroupDPSInAll)
		RecapMinHPS_Text:SetFormattedText("%.1f", recap_temp.GroupHPSAll)
	end

	if IB_Recap_Update then
		IB_Recap_Update("DPS: "..RecapMinYourDPS_Text:GetText())
	end

	if TitanPanelRecap_Update then
		TitanPanelRecap_Update(recap.Opt.State.value,RecapMinYourDPS_Text:GetText(),RecapMinDPSIn_Text:GetText(),RecapMinDPSOut_Text:GetText())
	end
end
function Recap_GetIB_Tooltip()
	local yourdps
	if recap.Opt.View.value=="Last" then
		yourdps = string_format("%.1f", recap_temp.PlayerDPSLast)
	else
		yourdps = string_format("%.1f", recap_temp.PlayerDPSAll)
	end
	-- note, the following displays one live number and several non-live numbers
	return recap_temp.LastAll[recap.Opt.View.value]..":\n"..RECAP_YOUR_DPS..": "..yourdps.."\n"..RECAP_MAX_HIT..": "..RecapTotals_MaxHit:GetText().."\n"..RECAP_TOTAL_DPS_OUT..": "..RecapTotals_DPS:GetText().."\n"..RECAP_TOTAL_DPS_IN..": "..RecapTotals_TotDPSIn:GetText()
end


function Recap_ConstructSelf()

	local damage, heal, miss, i, j, iSelf, iType

	-- clear the 'SelfList' table entirely
	recap_temp.SelfListSize = 1
	recap_temp.SelfList = {} -- breaks table.sort if we try to re-use the table by setting individual values to nil

	-- Add player, and all of player's pets
	recap_temp.SelfListSize, damage, heal, miss = Recap_AddSelfListPlayerAndPets()

	if recap_temp.SelfListSize>1 then
		for i=1,recap_temp.SelfListSize-1 do
			iSelf = recap_temp.SelfList[i]
			iType = string_sub(iSelf.EName,1,1)
			if ((iType == "1") or (iType == "2")) and damage>0 then
				iSelf.ETotalP = string_format("%d%%",Recap_Div0(100*iSelf.ETotal,damage))
			elseif ((iType == "3") or (iType == "4")) and heal>0 then
				iSelf.ETotalP = string_format("%d%%",Recap_Div0(100*iSelf.ETotal,heal))
			else
				iSelf.ETotalP = "--"
			end
		end
	end

	-- now sort the personal details by any column
	Recap_SortSelfList()
end

function Recap_AddSelfListPlayerAndPets()

	local i, j, k, iSelf, iEffect, iList
	local found, petName
	local idx, damage, heal, miss
	idx = 1
	damage = 0
	heal = 0
	miss = 0

	-- preliminary cleanup scan, remove any entries that are empty tables
	-- one pass only, this will not remove them all due to the nature of lua tables, but if we do it every visit we will eventually get most or all of them
	for i in pairs(recap.Self) do
		local foundOuterEntry = false
		for j in pairs(recap.Self[i]) do
			local foundInnerEntry = false
			for k in pairs(recap.Self[i][j]) do
				foundInnerEntry = true
				break
			end
			if foundInnerEntry == false then
				-- no data, remove entry
				recap.Self[i][j] = nil
			end
			foundOuterEntry = true
			break
		end
		if foundOuterEntry == false then
			-- no data, remove entry
			recap.Self[i] = nil
		end
	end
	-- end of preliminary cleanup scan

	-- main event
	for i in pairs(recap.Self) do
		if string_find(i, recap_temp.s, 1, true) then
			-- this is the player or one of the player's pets
			iSelf = recap.Self[i]
			for j in pairs(iSelf) do
				iEffect = iSelf[j]
				if not recap_temp.SelfList[idx] then
					recap_temp.SelfList[idx] = {}
				end
				iList = recap_temp.SelfList[idx]
				-- skip effects that have zero damage
				local total
				total = (iEffect.GlancesDmg or 0) + (iEffect.HitsDmg or 0) + (iEffect.CritsDmg or 0) + (iEffect.TicksDmg or 0)
				if total == 0 then
					iEffect = nil -- keep as nil
				else
					found,_,petName = string_find(i, "^.+:(.+)$")
					if found then
						-- one of the pets
						if string_sub(j,1,1)=="1" then
							iList.EName = "2"..petName..": "..string_sub(j,2)
						else
							iList.EName = "4"..petName..": "..string_sub(j,2)
						end
					else
						-- the player
						iList.EName = j
					end
					iList.EElement = iEffect.Element or "?"
					iList.ETotal = total
					iList.EGlances = iEffect.Glances or 0
					iList.EHits = iEffect.Hits or 0
					iList.ECrits = iEffect.Crits or 0
					iList.ETicks = iEffect.Ticks or 0
					iList.EGlancesMin = iEffect.GlancesMin or 0
					iList.EHitsMin = iEffect.HitsMin or 0
					iList.ETicksMin = iEffect.TicksMin or 0
					iList.ECritsMin = iEffect.CritsMin or 0
					iList.EGlancesMax = iEffect.GlancesMax or 0
					iList.EHitsMax = iEffect.HitsMax or 0
					iList.ETicksMax = iEffect.TicksMax or 0
					iList.ECritsMax = iEffect.CritsMax or 0
					-- make the averages into numbers (not strings) to allow for sorting
					iList.EGlancesAvg = tonumber(string_format("%d",((iList.EGlances>0) and Recap_Div0((iEffect.GlancesDmg or 0),iList.EGlances) or 0)))
					iList.EHitsAvg = tonumber(string_format("%d",((iList.EHits>0) and Recap_Div0((iEffect.HitsDmg or 0),iList.EHits) or 0)))
					iList.ETicksAvg = tonumber(string_format("%d",((iList.ETicks>0) and Recap_Div0((iEffect.TicksDmg or 0),iList.ETicks) or 0)))
					iList.ECritsAvg = tonumber(string_format("%d",((iList.ECrits>0) and Recap_Div0((iEffect.CritsDmg or 0),iList.ECrits) or 0)))
					iList.EMaxAll = math_max( iList.EHitsMax, math_max(iList.ETicksMax,iList.ECritsMax) )
					if (tonumber(string_sub(j,1,1)) == 1) or (tonumber(string_sub(j,1,1)) == 2) then -- damage event
						miss = (iEffect.Missed or 0) + (iEffect.Dodged or 0) + (iEffect.Parried or 0) + (iEffect.Blocked or 0) +
								(iEffect.Deflected or 0) + (iEffect.Resisted or 0) + (iEffect.Reflected or 0) + (iEffect.Absorbed or 0) +
								(iEffect.Immune or 0) + (iEffect.Evaded or 0)
						iList.EMiss = miss
						k = miss + iList.EGlances + iList.EHits + iList.ECrits
						iList.ECritsP = string_format("%.1f%%",(k>0) and Recap_Div1(100*iList.ECrits,k) or 0)
						iList.EMissP = string_format("%.1f%%",(k>0) and Recap_Div1(100*iList.EMiss,k) or 0)
						damage = damage + iList.ETotal
					else
						k = iList.EGlances + iList.EHits + iList.ECrits -- yeah I know, heals probably don't glance, but it doesn't hurt, and if they ever do Recap will be ready
						iList.ECritsP = string_format("%.1f%%",(k>0) and Recap_Div1(100*iList.ECrits,k) or 0)
						iList.EMiss = "--"
						iList.EMissP = "--"
						heal = heal + iList.ETotal
					end

					if iList.ETicks==0 then
						iList.ETicks = "--"
						iList.ETicksMin = "--"
						iList.ETicksAvg = "--"
						iList.ETicksMax = "--"
					end
					if not iEffect.CritsEvents then
						iList.ECrits = "--"
						iList.ECritsMin = "--"
						iList.ECritsAvg = "--"
						iList.ECritsMax = "--"
						iList.ECritsP = "--"
						iList.EHits = "--"
						iList.EHitsMin = "--"
						iList.EHitsAvg = "--"
						iList.EHitsMax = "--"
						iList.EGlances = "--"
						iList.EGlancesMin = "--"
						iList.EGlancesAvg = "--"
						iList.EGlancesMax = "--"
					end

					idx = idx + 1
				end
			end
		end
	end

	return idx, damage, heal, miss
end

function Recap_ResetSelfPlayerAndPets()

	local i

	-- reset owner and pets
	for i in pairs(recap.Self) do
		if string_find(i, recap_temp.s, 1, true) then
			recap.Self[i] = {}
		end
	end
end


function Recap_ConstructList()

	local i, entry, overallDuration, tempname, thisCombatant, iCombatant, iList, iTotal
	local maxhit = 0
	local dmgin = 0
	local dmgout = 0
	local kills = 0
	local rawheal = 0
	local overheal = 0
	local duration = 0
	local durationIn = 0
	local durationHeal = 0
	local overallDPS = 0

	if recap.Opt.SelfView.value then
		Recap_ConstructSelf()
	end

	if (recap_temp.Selected ~= 0) and (recap_temp.Selected ~= recap_temp.GroupIndex) and (recap_temp.Selected ~= recap_temp.NonGroupIndex) then
		tempname = recap_temp.List[recap_temp.Selected].Name
	else
		tempname = nil
	end

	if recap.Opt.View.value=="Last" then
		overallDuration = recap[recap_temp.p].LastDuration
	else
		overallDuration = recap[recap_temp.p].TotalDuration
	end

	-- clear the 'List' table entirely
	recap_temp.ListSize = 1
	recap_temp.List = {} -- breaks table.sort if we try to re-use the table by setting individual values to nil

	if not recap.Combatant then
		recap.Combatant = {}
	end
	for i in pairs(recap.Combatant) do
		if (i ~= recap_temp.GroupTotal) and (i ~= recap_temp.NonGroupTotal) then
			if not recap_temp.List[recap_temp.ListSize] then
				recap_temp.List[recap_temp.ListSize] = {}
			end
			entry = false

			iCombatant = recap.Combatant[i]
			iList = recap_temp.List[recap_temp.ListSize]

			-- added heals, so that healers show up from the beginning, rather than only after they have received or given damage
			if ((iCombatant["LastDmgIn_"..recap_temp.DisplayLastFight]==nil or iCombatant["LastDmgIn_"..recap_temp.DisplayLastFight]==0) and
				(iCombatant["LastDmgOut_"..recap_temp.DisplayLastFight]==nil or iCombatant["LastDmgOut_"..recap_temp.DisplayLastFight]==0) and
				(iCombatant.TotalDmgOut==nil or iCombatant.TotalDmgOut==0) and
				(iCombatant.TotalDmgIn==nil or iCombatant.TotalDmgIn==0) and
				(iCombatant["LastRawHeal_"..recap_temp.DisplayLastFight]==nil or iCombatant["LastRawHeal_"..recap_temp.DisplayLastFight]==0) and
				(iCombatant.TotalRawHeal==nil or iCombatant.TotalRawHeal==0)) or
			   (recap.Opt.HideOthers.value and (not iCombatant.Friend)) or
			   (recap.Opt.HideGroup.value and (not Recap_CheckForSelf(i)) and iCombatant.Friend) or
			   (recap.Opt.HideYardTrash.value and not iCombatant.Friend and Recap_CombatantIsTrash(i)) or
			   (iCombatant.Ignore) then
				entry = false -- strip out unwanted combatants

			elseif recap.Opt.View.value=="Last" and iCombatant.WasInLast then
				if ((iCombatant["LastTime_"..recap_temp.DisplayLastFight] and (iCombatant["LastTime_"..recap_temp.DisplayLastFight] > recap_temp.MinTime)) or
					(iCombatant["LastTimeIn_"..recap_temp.DisplayLastFight] and (iCombatant["LastTimeIn_"..recap_temp.DisplayLastFight] > recap_temp.MinTime)) or
					(iCombatant["LastTimeHeal_"..recap_temp.DisplayLastFight] and (iCombatant["LastTimeHeal_"..recap_temp.DisplayLastFight] > recap_temp.MinTime))) then
					iList.Name = i
					iList.Seen = (iCombatant.Seen or 0)
					iList.Time = (iCombatant["LastTime_"..recap_temp.DisplayLastFight] or 0)
					iList.TimeIn = (iCombatant["LastTimeIn_"..recap_temp.DisplayLastFight] or 0)
					iList.TimeHeal = (iCombatant["LastTimeHeal_"..recap_temp.DisplayLastFight] or 0)
					iList.MaxHit = (iCombatant["LastMaxHit_"..recap_temp.DisplayLastFight] or 0)
					iList.DmgIn = (iCombatant["LastDmgIn_"..recap_temp.DisplayLastFight] or 0)
					iList.DmgOut = (iCombatant["LastDmgOut_"..recap_temp.DisplayLastFight] or 0)
					iList.HPS = (iCombatant["LastHPS_"..recap_temp.DisplayLastFight] or 0)
					iList.DPSIn = (iCombatant["LastDPSIn_"..recap_temp.DisplayLastFight] or 0)
					iList.DPS = (iCombatant["LastDPS_"..recap_temp.DisplayLastFight] or 0)
					iList.DPSvsAll = (overallDuration>recap_temp.MinTime and Recap_Div1((iCombatant["LastDmgOut_"..recap_temp.DisplayLastFight] or 0), overallDuration)) or 0
					iList.Kills = (iCombatant["LastKills_"..recap_temp.DisplayLastFight] or 0)
					-- two hidden variables
					iList.RawHeal = (iCombatant["LastRawHeal_"..recap_temp.DisplayLastFight] or 0)
					iList.OverHeal = (iCombatant["LastOverHeal_"..recap_temp.DisplayLastFight] or 0)
					-- calculated rather than assigned
					iList.Heal = (iCombatant["LastRawHeal_"..recap_temp.DisplayLastFight] or 0) - (iCombatant["LastOverHeal_"..recap_temp.DisplayLastFight] or 0)
					if iList.RawHeal > 0 then
						iList.Over = Recap_Div0(100*iList.OverHeal,iList.RawHeal)
					else
						iList.Over = 0
					end
					entry = true
				end

			elseif recap.Opt.View.value=="All" then
				if not recap.Opt.HideZero.value or ((iCombatant.TotalTime and (iCombatant.TotalTime > recap_temp.MinTime)) or
													(iCombatant.TotalTimeIn and (iCombatant.TotalTimeIn > recap_temp.MinTime)) or
													(iCombatant.TotalTimeHeal and (iCombatant.TotalTimeHeal > recap_temp.MinTime))) then
					iList.Name = i
					iList.Seen = (iCombatant.Seen or 0)
					iList.Time = (iCombatant.TotalTime or 0)
					iList.TimeIn = (iCombatant.TotalTimeIn or 0)
					iList.TimeHeal = (iCombatant.TotalTimeHeal or 0)
					iList.MaxHit = (iCombatant.TotalMaxHit or 0)
					iList.DmgIn = (iCombatant.TotalDmgIn or 0)
					iList.DmgOut = (iCombatant.TotalDmgOut or 0)
					iList.HPS = (iCombatant.TotalHPS or 0)
					iList.DPSIn = (iCombatant.TotalDPSIn or 0)
					iList.DPS = (iCombatant.TotalDPS or 0)
					iList.DPSvsAll = (overallDuration>recap_temp.MinTime and Recap_Div1((iCombatant.TotalDmgOut or 0), overallDuration)) or 0
					iList.Kills = (iCombatant.TotalKills or 0)
					-- two hidden variables
					iList.RawHeal = (iCombatant.TotalRawHeal or 0)
					iList.OverHeal = (iCombatant.TotalOverHeal or 0)
					-- calculated rather than assigned
					iList.Heal = (iCombatant.TotalRawHeal or 0) - (iCombatant.TotalOverHeal or 0)
					if iList.RawHeal > 0 then
						iList.Over = Recap_Div0(100*iList.OverHeal, iList.RawHeal)
					else
						iList.Over = 0
					end
					entry = true
				end
			end

			if entry then
				thisCombatant = iList.Name
				if thisCombatant and recap.Combatant[thisCombatant] and recap.Combatant[thisCombatant].Friend then
					duration = duration + iList.Time
					durationIn = durationIn + iList.TimeIn
					durationHeal = durationHeal + iList.TimeHeal
					if iList.MaxHit > maxhit then
						maxhit = iList.MaxHit
					end
					dmgin = dmgin + iList.DmgIn
					dmgout = dmgout + iList.DmgOut
					kills = kills + iList.Kills
					-- two hidden variables
					rawheal = rawheal + iList.RawHeal
					overheal = overheal + iList.OverHeal
					overallDPS = overallDPS + iList.DPS
				end
				recap_temp.ListSize = recap_temp.ListSize + 1
			end
		end
	end

	if not recap_temp.List[recap_temp.ListSize] then
		recap_temp.List[recap_temp.ListSize] = {}
	end

	-- the final entry is the totals
	iTotal = recap_temp.List[recap_temp.ListSize]
	iTotal.Name = recap_temp.Localize.Totals
	iTotal.Time = duration
	RecapTotals_Time:SetText(Recap_FormatTime(duration))
	iTotal.TimeIn = durationIn
	RecapTotals_TimeIn:SetText(Recap_FormatTime(durationIn))
	iTotal.TimeHeal = durationHeal
	RecapTotals_TimeHeal:SetText(Recap_FormatTime(durationHeal))
	iTotal.MaxHit = maxhit
	RecapTotals_MaxHit:SetText(maxhit)
	iTotal.DmgIn = dmgin
	RecapTotals_DmgIn:SetText(dmgin)
	iTotal.DmgOut = dmgout
	RecapTotals_DmgOut:SetText(dmgout)
	iTotal.Kills = kills
	RecapTotals_Kills:SetText(kills)
	-- two hidden variables
	iTotal.RawHeal = rawheal
	iTotal.OverHeal = overheal
	-- calculated rather than assigned
	iTotal.Heal = rawheal - overheal
	RecapTotals_Heal:SetText(rawheal - overheal)
	if (iTotal.RawHeal > 0) then
		iTotal.Over = Recap_Div0(100*iTotal.OverHeal,iTotal.RawHeal)
	else
		iTotal.Over = 0
	end
	RecapTotals_Over:SetFormattedText("%d%%",Recap_Round0(iTotal.Over))

	-- three calculations of total group DPS, DPS In, and HPS
	if duration > recap_temp.MinTime then
		iTotal.TotDPSOut = Recap_Div1(dmgout,duration)
	else
		iTotal.TotDPSOut = 0
	end
	if durationIn > recap_temp.MinTime then
		iTotal.TotDPSIn = Recap_Div1(dmgin,durationIn)
	else
		iTotal.TotDPSIn = 0
	end
	if durationHeal > recap_temp.MinTime then
		iTotal.TotHPS = Recap_Div1((rawheal - overheal),durationHeal)
	else
		iTotal.TotHPS = 0
	end

	if iTotal.TotHPS<1000 then
		RecapTotals_HPS:SetFormattedText("%.1f",iTotal.TotHPS)
	else
		RecapTotals_HPS:SetFormattedText("%d",Recap_Round0(iTotal.TotHPS))
	end
	if iTotal.TotDPSIn<1000 then
		RecapTotals_DPSIn:SetFormattedText("%.1f",iTotal.TotDPSIn)
	else
		RecapTotals_DPSIn:SetFormattedText("%d",Recap_Round0(iTotal.TotDPSIn))
	end
	if iTotal.TotDPSOut<1000 then
		RecapTotals_DPS:SetFormattedText("%.1f",iTotal.TotDPSOut)
	else
		RecapTotals_DPS:SetFormattedText("%d",Recap_Round0(iTotal.TotDPSOut))
	end
	if iTotal.TotDPSOut<1000 then
		RecapTotals_DPSvsAll:SetFormattedText("%.1f",iTotal.TotDPSOut)
	else
		RecapTotals_DPSvsAll:SetFormattedText("%d",Recap_Round0(iTotal.TotDPSOut))
	end

	-- Class column fix set to black, see also RecapScrollBar_Update and Recap_SetColumns.
	RecapTotals_Class:SetTexCoord(.9,1,.9,1)

	-- calculate percentages
	for i=1,recap_temp.ListSize-1 do
		iList = recap_temp.List[i]
		iList.HealP = 0
		iList.DmgInP = 0
		iList.DmgOutP = 0
		thisCombatant = iList.Name
		if thisCombatant and recap.Combatant[thisCombatant] and recap.Combatant[thisCombatant].Friend then
			if iTotal.Heal>0 then
				iList.HealP = Recap_Div0(100*iList.Heal,iTotal.Heal)
			end
			if iTotal.DmgIn>0 then
				iList.DmgInP = Recap_Div0(100*iList.DmgIn,iTotal.DmgIn)
			end
			if iTotal.DmgOut>0 then
				-- give this column an extra digit of significance
				iList.DmgOutP = Recap_Div1(100*iList.DmgOut,iTotal.DmgOut)
			end
		end
	end

	-- two hidden variables for total line only
	iTotal.OverallDuration = overallDuration
	iTotal.OverallDPS = overallDPS

	-- restore a valid value for Selected if possible
	if tempname then -- follow name to pre-sort selected
		recap_temp.Selected = Recap_GetSelectedByName(tempname)
		if recap_temp.Selected~=0 then
			RecapPanel_Show(tempname)
		else
			RecapPanel_Hide()
		end
	end

	Recap_SortList()
	if not recap.Opt.Minimized.value then
		RecapScrollBar_Update()
	end

	-- TODO: took out an "update plugins" here, should be okay but monitor it

end

function Recap_DefineGauges()

	local i, thisCombatant
	local _G = getfenv(0)

	recap_temp.GaugeMax = 0

	if recap_temp.ListSize>1 then
		recap_temp.GaugeBy = string_gsub(recap.Opt.SortBy.value,"P$","")
		recap_temp.GaugeBy = recap_temp.GaugeBy=="DPSvsAll" and "DmgOut" or recap_temp.GaugeBy
		if not gaugecolor[recap_temp.GaugeBy] then
			recap_temp.GaugeBy = false
		else
			for i=1,recap_temp.ListSize-1 do
				thisCombatant = recap_temp.List[i].Name
				if thisCombatant and recap.Combatant[thisCombatant] and recap.Combatant[thisCombatant].Friend and recap_temp.GaugeBy then
					recap_temp.GaugeMax = math_max(recap_temp.List[i][recap_temp.GaugeBy],recap_temp.GaugeMax)
				end
			end
			for i=1,15 do
				_G["RecapList"..i.."_Gauge"]:SetVertexColor(gaugecolor[recap_temp.GaugeBy].r,gaugecolor[recap_temp.GaugeBy].g,gaugecolor[recap_temp.GaugeBy].b)
			end
		end
	end
end


function Recap_GetSelectedByName(name)

	local sel, i = 0
	local thisCombatant

	if name and recap_temp.ListSize>1 then
		for i=1,recap_temp.ListSize-1 do
			thisCombatant = recap_temp.List[i].Name
			if thisCombatant and (thisCombatant==name) then
				sel = i
			end
		end
	end

	return sel
end


--[[ Sorting functions ]]

-- initial sort by field done with table.sort for speed, then
-- friends shifted to top with an insertion sort for "stable" list
function Recap_SortList()

	local temp, tempname

	if (recap_temp.Selected ~= 0) and (recap_temp.Selected ~= recap_temp.GroupIndex) and (recap_temp.Selected ~= recap_temp.NonGroupIndex) then
		tempname = recap_temp.List[recap_temp.Selected].Name
	else
		tempname = nil
	end

	-- remember the last ('Total') element
	temp = recap_temp.List[recap_temp.ListSize]

	-- remove the last element from the 'List' table in case it could confuse 'table.sort'
	table_remove(recap_temp.List) -- without second parameter this defaults to last element

	if recap.Opt.SortBy.value then
		if recap.Opt.SortDir.value then
			table_sort(recap_temp.List,Recap_SortDown)
		else
			table_sort(recap_temp.List,Recap_SortUp)
		end
		Recap_SortFriends()
	end

	-- restore the last ('Total') element
	recap_temp.List[recap_temp.ListSize] = temp

	Recap_DefineGauges()
	recap_temp.Selected = Recap_GetSelectedByName(tempname)

end

function Recap_SortDown(e1,e2)

	if recap.Opt.SortBy.value=="Class" then
		-- special case for Class, which is an icon ('texture')
		local c1 = recap.Combatant[e1.Name]
		local c2 = recap.Combatant[e2.Name]
		if not (c1 and c1.Class) and (c2 and c2.Class) then
			-- so that classless combatants sort to end
			return false
		end
		if (c1 and c1.Class) and not (c2 and c2.Class) then
			-- so that classless combatants sort to end
			return true
		end
		if c1 and c2 and c1.Class and c2.Class then
			if ( c1.Class < c2.Class ) then
				return true
			else
				return false
			end
		else
			return false
		end
	elseif recap.Opt.SortBy.value=="Name" then
		-- special case for Name, which we need without GUIDs, and for which we sort identical names in "First Seen" order
		if e1.Name and e2.Name then
			local e1Name = Recap_StripGUIDsFromCombatant(e1.Name)
			local e2Name = Recap_StripGUIDsFromCombatant(e2.Name)
			if ( e1Name < e2Name ) then
				return true
			elseif ( e1Name == e2Name ) then
				if e1.Seen and e2.Seen then
					if ( e1.Seen < e2.Seen ) then
						return true
					else
						return false
					end
				else
					return false
				end
			else
				return false
			end
		else
			return false
		end
	else
		if e1[recap.Opt.SortBy.value] and e2[recap.Opt.SortBy.value] then
			-- bypass a problem with mixed strings and numbers
			if type(e1[recap.Opt.SortBy.value]) == type(e2[recap.Opt.SortBy.value]) then
				-- types match, normal compare
				if ( e1[recap.Opt.SortBy.value] < e2[recap.Opt.SortBy.value] ) then
					return true
				else
					return false
				end
			else
				-- types don't match, force string compare
				-- this may be due to a damaged saved variables file, but bypass it anyway
				if ( tostring(e1[recap.Opt.SortBy.value]) < tostring(e2[recap.Opt.SortBy.value]) ) then
					return true
				else
					return false
				end
			end
		else
			return false
		end
	end

end

function Recap_SortUp(e1,e2)

	if recap.Opt.SortBy.value=="Class" then
		-- special case for Class, which is an icon ('texture')
		local c1 = recap.Combatant[e1.Name]
		local c2 = recap.Combatant[e2.Name]
		if not (c1 and c1.Class) and (c2 and c2.Class) then
			-- so that classless combatants sort to end
			return false
		end
		if (c1 and c1.Class) and not (c2 and c2.Class) then
			-- so that classless combatants sort to end
			return true
		end
		if c1 and c2 and c1.Class and c2.Class then
			if ( c1.Class > c2.Class ) then
				return true
			else
				return false
			end
		else
			return false
		end
	elseif recap.Opt.SortBy.value=="Name" then
		-- special case for Name, which we need without GUIDs, and for which we sort identical names in "First Seen" order
		if e1.Name and e2.Name then
			local e1Name = Recap_StripGUIDsFromCombatant(e1.Name)
			local e2Name = Recap_StripGUIDsFromCombatant(e2.Name)
			if ( e1Name > e2Name ) then
				return true
			elseif ( e1Name == e2Name ) then
				if e1.Seen and e2.Seen then
					if ( e1.Seen > e2.Seen ) then
						return true
					else
						return false
					end
				else
					return false
				end
			else
				return false
			end
		else
			return false
		end
	else
		if e1[recap.Opt.SortBy.value] and e2[recap.Opt.SortBy.value] then
			-- bypass a problem with mixed strings and numbers
			if type(e1[recap.Opt.SortBy.value]) == type(e2[recap.Opt.SortBy.value]) then
				-- types match, normal compare
				if ( e1[recap.Opt.SortBy.value] > e2[recap.Opt.SortBy.value] ) then
					return true
				else
					return false
				end
			else
				-- types don't match, force string compare
				-- this may be due to a damaged saved variables file, but bypass it anyway
				if ( tostring(e1[recap.Opt.SortBy.value]) > tostring(e2[recap.Opt.SortBy.value]) ) then
					return true
				else
					return false
				end
			end
		else
			return false
		end
	end

end

-- perform stable insertion sort on the list
function Recap_SortFriends()

	local i, j, iList, other
	local changed = true

	if recap_temp.ListSize>2 then
		for i=2,(recap_temp.ListSize-1) do
			iList = recap_temp.List[i]
			if (iList) and (iList.Name) and (recap.Combatant[iList.Name]) and (recap.Combatant[iList.Name].Friend) then
				j=i
				while (j>1) do
					other = recap_temp.List[j-1]
					if (other) and (other.Name) and (recap.Combatant[other.Name]) and (not recap.Combatant[other.Name].Friend) then
						recap_temp.List[j] = other
						j = j - 1
					else
						break
					end
				end
				recap_temp.List[j] = iList
			end
		end
	end

end

-- three functions allowing the Personal Details panel to be sorted
--   by column (damage effects always appear first, healing effects second) (function
--   Recap_SelfDamageSort, which was a fixed sort, has been removed)
function Recap_SortSelfList()

	if recap.Opt.ESortBy.value then
		if recap.Opt.ESortDir.value then
			table_sort(recap_temp.SelfList,Recap_SortSelfDown)
		else
			table_sort(recap_temp.SelfList,Recap_SortSelfUp)
		end
	end

end

function Recap_SortSelfDown(e1,e2)

	local effect1, effect2, value1, value2

	if e1.EName and e2.EName then
		effect1 = string_sub(e1.EName,1,1)
		effect2 = string_sub(e2.EName,1,1)
		if e1[recap.Opt.ESortBy.value] and e2[recap.Opt.ESortBy.value] then
			value1 = e1[recap.Opt.ESortBy.value]
			if value1 == "--" then
				value1 = -1
			end
			-- turn a percentage string into a number
			if (type(value1) == "string") and (string_sub(value1, -1) == "%") then
				value1 = tonumber(string_sub(value1, 1, string_len(value1)-1))
			end
			value2 = e2[recap.Opt.ESortBy.value]
			if value2 == "--" then
				value2 = -1
			end
			-- turn a percentage string into a number
			if (type(value2) == "string") and (string_sub(value2, -1) == "%") then
				value2 = tonumber(string_sub(value2, 1, string_len(value2)-1))
			end
			if (((value1 < value2) and (effect1==effect2)) or (effect1<effect2)) then
				return true
			else
				return false
			end
		else
			return false
		end
	else
		return false
	end

end

function Recap_SortSelfUp(e1,e2)

	local effect1, effect2, value1, value2

	if e1.EName and e2.EName then
		effect1 = string_sub(e1.EName,1,1)
		effect2 = string_sub(e2.EName,1,1)
		if e1[recap.Opt.ESortBy.value] and e2[recap.Opt.ESortBy.value] then
			value1 = e1[recap.Opt.ESortBy.value]
			if value1 == "--" then
				value1 = -1
			end
			-- turn a percentage string into a number
			if (type(value1) == "string") and (string_sub(value1, -1) == "%") then
				value1 = tonumber(string_sub(value1, 1, string_len(value1)-1))
			end
			value2 = e2[recap.Opt.ESortBy.value]
			if value2 == "--" then
				value2 = -1
			end
			-- turn a percentage string into a number
			if (type(value2) == "string") and (string_sub(value2, -1) == "%") then
				value2 = tonumber(string_sub(value2, 1, string_len(value2)-1))
			end
			if (((value1 > value2) and (effect1==effect2)) or (effect1<effect2)) then
				return true
			else
				return false
			end
		else
			return false
		end
	else
		return false
	end

end

--[[ Window movement functions ]]

function Recap_OnMouseDown(frame, button)

	if recap_temp.Loaded and (button == "LeftButton") and not recap.Opt.Pinned.value then
		RecapFrame:StartMoving()
	end
end

function Recap_OnMouseUp(frame, button)

	if recap_temp.Loaded then
		if (button == "LeftButton") and not recap.Opt.Pinned.value then
			RecapFrame:StopMovingOrSizing()
			Recap_CheckWindowBounds()

		elseif (button == "RightButton") and not IsShiftKeyDown() and recap.Opt.Minimized.value then
			Recap_CreateMenu(recap_temp.Localize.MinMenu, nil)
		end
	end
end

-- repositions RecapFrame if any part of it goes off the screen
function Recap_CheckWindowBounds()

	local frameLeft, frameTop, frameRight, frameBottom, newScale
	local parentRight, parentLeft, parentTop, parentBottom
	local needs_moved = false

	if recap_temp.Loaded and RecapFrame then
		frameLeft = RecapFrame:GetLeft()
		frameTop = RecapFrame:GetTop()
		if frameLeft and frameTop then
			frameRight = RecapFrame:GetRight()
			frameBottom = RecapFrame:GetBottom()
			newScale = Recap_Div2(recap.Opt.SetScale.value,100)
			parentRight = UIParent:GetRight()/newScale
			parentLeft = UIParent:GetLeft()/newScale
			parentTop = UIParent:GetTop()/newScale
			parentBottom = UIParent:GetBottom()/newScale

			if frameRight and parentRight and frameRight > parentRight then
				frameLeft = frameLeft + parentRight - frameRight
				needs_moved = true
			elseif parentLeft and parentLeft > frameLeft then
				frameLeft = frameLeft + parentLeft - frameLeft
				needs_moved = true
			end

			if frameTop and frameTop > parentTop then
				frameTop = frameTop + parentTop - frameTop
				needs_moved = true
			elseif parentBottom and parentBottom > frameBottom then
				frameTop = frameTop + parentBottom - frameBottom
				needs_moved = true
			end

			if needs_moved then
				RecapFrame:ClearAllPoints()
				RecapFrame:SetPoint("TOPLEFT","UIParent","BOTTOMLEFT",math_max(frameLeft,0),math_max(frameTop,0))
			end

			recap[recap_temp.p].WindowTop = RecapFrame:GetTop()
			recap[recap_temp.p].WindowLeft = RecapFrame:GetLeft()
			recap[recap_temp.p].WindowHeight = RecapFrame:GetHeight()
			recap[recap_temp.p].WindowWidth = RecapFrame:GetWidth()

		else
			-- default behaviour if any undefined
			RecapFrame:ClearAllPoints()
			RecapFrame:SetPoint("CENTER","UIParent","CENTER")
		end
	end

end

--[[ Dialog control functions ]]

function Recap_OnClick(myType) -- clicks on buttons -- DO NOT change the name of this, some plugins call this function -- also do not change the values of the myType parameter

	local i

	if not recap_temp.Loaded then
		return
	end

	local fight_count = 0
	local total_fight_count = 0
	local filen = RecapSetEditBox:GetText()
	local set_friend, set_dmgin, set_dmgout, set_maxhit, set_kills, set_heal, set_time

	PlaySound("GAMEGENERICBUTTONPRESS")

	if myType=="Close" then
		RecapFrame_Hide()

	elseif myType=="Minimize" then

		if recap.Opt.Minimized.value then
			Recap_Maximize()
		else
			Recap_Minimize()
		end
		RecapFrame:SetAlpha(1)
		recap_temp.FadeTimer = -1
		Recap_SetButtons()
		Recap_Tooltip("Minimize")

	elseif myType=="Pin" then
		recap.Opt.Pinned.value = not recap.Opt.Pinned.value
		Recap_SetButtons()
		Recap_Tooltip("Pin")

	elseif myType=="Pause" then
		if recap.Opt.Paused.value then
			-- resuming
			recap.Opt.Paused.value = false
			Recap_ClearAsIfEndOfFight()
			Recap_SetState("Idle")
		else
			-- pausing
			if ((recap.Opt.SyncState.value == "Member") or (recap.Opt.SyncState.value == "Leader")) then
				-- for a member, ignore if in synchronization
				PlaySound("igQuestFailed")
				Recap_WarnNotAllowedDuringSync()
			else
				recap.Opt.Paused.value = true
				Recap_EndFight(true)
				Recap_SetState("Stopped")
				Recap_ClearAsIfEndOfFight()
			end
		end
		Recap_SetButtons()
		Recap_Tooltip("Pause")

	elseif myType=="ShowAll" then
		recap.Opt.SelfView.value = false
		if recap.Opt.View.value=="All" then
			recap.Opt.View.value = "Last"
		else
			recap.Opt.View.value = "All"
		end
		Recap_SetColumns() -- this calls SetView which in turn calls ConstructList
		-- display live dps and hps numbers
		Recap_DisplayMinimizedDPS() -- also sends to plugins
		Recap_Tooltip("ShowAll")

	elseif myType=="Options" then
		if RecapOptFrame:IsShown() then
			RecapOptFrame:Hide()
		else
			RecapOptFrame:Show()
			Recap_SetSyncDisplay()
		end

	elseif myType=="Reset" then

		if recap.Opt.SelfView.value then
			Recap_ResetSelfPlayerAndPets()
			Recap_SetView()

		elseif recap.Opt.View.value=="All" then
			if ((recap.Opt.SyncState.value == "Member") or (recap.Opt.SyncState.value == "Leader")) then
				if recap.Opt.SyncState.value == "Leader" then
					-- for a leader, treat this as a restart sync (with existing value for merge pets)
					Recap_StartSync(recap.Opt.SyncMergePets.value)
					DEFAULT_CHAT_FRAME:AddMessage(RECAP_RECAP.." "..RECAP_SYNCHRONIZATION_RESET)
				else
					-- for a member, ignore if in synchronization
					PlaySound("igQuestFailed")
					Recap_WarnNotAllowedDuringSync()
				end
			else
				-- wipe everything --
				RecapPanel_Hide(1)
				RecapRecent_Hide(1)
				Recap_ResetAllCombatants(false)
				Recap_MakeFriends()
				Recap_SetView()
			end

		elseif recap.Opt.View.value=="Last" then
			if ((recap.Opt.SyncState.value == "Member") or (recap.Opt.SyncState.value == "Leader")) then
				-- ignore if in synchronization
				PlaySound("igQuestFailed")
				Recap_WarnNotAllowedDuringSync()
			else
				StaticPopupDialogs["recap_temp.CONFIRMLASTRESET"] = {
					text = TEXT(recap_temp.Localize.ConfirmLastReset),
					button1 = TEXT(ACCEPT),
					button2 = TEXT(CANCEL),
					OnAccept = function()
						-- SUBTRACT the last fight --
						if not recap.Combatant then
							recap.Combatant = {}
						end
						for i in pairs(recap.Combatant) do
							if (i ~= recap_temp.GroupTotal) and (i ~= recap_temp.NonGroupTotal) then
								if recap.Combatant[i].WasInLast then
									Recap_ResetLastFight(i)
								end
							end
						end
						recap[recap_temp.p].TotalDuration = recap[recap_temp.p].TotalDuration - recap[recap_temp.p].LastDuration
						recap[recap_temp.p].LastDuration = 0
						recap[recap_temp.p].TotalDurationIn = recap[recap_temp.p].TotalDurationIn - recap[recap_temp.p].LastDurationIn
						recap[recap_temp.p].LastDurationIn = 0
						recap[recap_temp.p].TotalDurationHeal = recap[recap_temp.p].TotalDurationHeal - recap[recap_temp.p].LastDurationHeal
						recap[recap_temp.p].LastDurationHeal = 0
						recap[recap_temp.p].LastFightStart = 0
						recap[recap_temp.p].LastFightEnd = 0
						Recap_SetView()
					end,
					OnHide = function()
					end,
					OnCancel = function()
					end,
					timeout = 0,
					showAlert = 1,
					whileDead = 1
				}
				StaticPopup_Show("recap_temp.CONFIRMLASTRESET")
			end
		end
		collectgarbage("collect")

	elseif myType=="SaveAllSet" then
		RecapSetEditBox:ClearFocus()
		if filen and filen~="" then
			filen = string_gsub(filen,"\"","'") -- convert " to '
			filen = string_gsub(filen,"%[","(") -- convert [ to (
			filen = string_gsub(filen,"%]",")") -- convert ] to )
		end
		RecapSetEditBox:SetText("")
		Recap_SaveCombatants(filen, false, false)
		Recap_BuildFightSets()
		recap_temp.FightSetSelected = 0
		RecapFightSetsScrollBar_Update()

	-- function to save only the Last Fight data set
	elseif myType=="SaveLastSet" then
		RecapSetEditBox:ClearFocus()
		if filen and filen~="" then
			filen = string_gsub(filen,"\"","'") -- convert " to '
			filen = string_gsub(filen,"%[","(") -- convert [ to (
			filen = string_gsub(filen,"%]",")") -- convert ] to )
		end
		RecapSetEditBox:SetText("")
		Recap_SaveCombatants(filen, true, false)
		Recap_BuildFightSets()
		recap_temp.FightSetSelected = 0
		RecapFightSetsScrollBar_Update()

	elseif myType=="QuickSaveAllSet" then
		filen = RECAP_ALL_FIGHTS.." "..date("%Y-%b-%d %H:%M:%S")
		Recap_SaveCombatants(filen, false, false)
		RecapSetEditBox:SetText("")
		Recap_BuildFightSets()
		recap_temp.FightSetSelected = 0
		RecapFightSetsScrollBar_Update()

	elseif myType=="QuickSaveLastSet" then
		filen = RECAP_LAST_FIGHT.." "..date("%Y-%b-%d %H:%M:%S")
		Recap_SaveCombatants(filen, true, false)
		RecapSetEditBox:SetText("")
		Recap_BuildFightSets()
		recap_temp.FightSetSelected = 0
		RecapFightSetsScrollBar_Update()

	elseif myType=="LoadSet" then
		if ((recap.Opt.SyncState.value == "Member") or (recap.Opt.SyncState.value == "Leader")) then
			-- ignore if in synchronization
			PlaySound("igQuestFailed")
			Recap_WarnNotAllowedDuringSync()
		else
			RecapSetEditBox:SetText("")
			RecapSetEditBox:ClearFocus()
			recap_temp.OutgoingDetailSelected = 0
			recap_temp.IncomingDetailSelected = 0
			recap_temp.OtherDetailSelected = 0
			recap_temp.Selected = 0
			recap_temp.RecentSelected = 0
			recap_temp.PanelRecentSelected = 0
			Recap_LoadCombatants(filen)
			Recap_MakeFriends()
			recap.Opt.View.value = "All"
			Recap_SetView()
			RecapPanel_Hide(1)
			RecapRecent_Hide(1)
			-- following not localized
			DEFAULT_CHAT_FRAME:AddMessage("Recap loaded Data Set: '"..filen.."'"..((recap_set[filen].MergePets and " ("..recap_temp.Localize.MergePetsOn..")") or "")..((recap_set[filen].IgnoreGUIDs and " ("..recap_temp.OptList.IgnoreGUIDs[2]..")") or ""))
		end

	elseif myType=="DeleteSet" then
		RecapSetEditBox:SetText("")
		RecapSetEditBox:ClearFocus()
		recap_set[filen] = nil -- keep as nil
		Recap_BuildFightSets()
		collectgarbage("collect")

	elseif myType=="SelfView" then
		recap.Opt.SelfView.value = not recap.Opt.SelfView.value
		if recap.Opt.SelfView.value then
		else
			if recap.Opt.View.value=="All" then
				recap.Opt.View.value = "All"
			else
				recap.Opt.View.value = "Last"
			end
		end
		RecapPanel_Hide(1)
		RecapRecent_Hide(1)
		Recap_SetColumns() -- this calls SetView which in turn calls ConstructList
		-- display live dps and hps numbers
		Recap_DisplayMinimizedDPS() -- also sends to plugins
		Recap_Tooltip("SelfView")
	end
end

function RecapHeader_OnEnter()

	-- lock OnEnter-OnLeave events
	if recap_temp.OnEnterOnLeave == true then return end
	recap_temp.OnEnterOnLeave = true

	local header=string_gsub(this:GetName(),"RecapHeader_","Header")
	Recap_Tooltip(header)

	-- unlock OnEnter-OnLeave events
	recap_temp.OnEnterOnLeave = false
end

function RecapHeader_OnMouseUp(frame, button)

	if (button == "RightButton") and not IsShiftKeyDown() then
		Recap_CreateMenu(recap_temp.Localize.ColumnMenu, nil)
	end
end

-- sort column, toggle dir for new headers, name=ascending, rest=descending
function RecapHeader_OnClick(frame, button, down)

	local text = ""
	local header = string_gsub(this:GetName(),"RecapHeader_","")

	if not IsShiftKeyDown() then
		if recap.Opt.SortBy.value==string_gsub(header,"P$","") then
			recap.Opt.SortDir.value = not recap.Opt.SortDir.value
		else
			recap.Opt.SortBy.value = string_gsub(header,"P$","")
			if header=="Name" then
				recap.Opt.SortDir.value = true
			else
				recap.Opt.SortDir.value = false
			end
		end
		Recap_SortList()
		RecapScrollBar_Update()

	elseif IsShiftKeyDown() and recap_temp.ListSize>1 and header~="Name" then

		recap.Opt.SortBy.value = header
		recap.Opt.SortDir.value = false
		Recap_SortList()
		RecapScrollBar_Update()
		Recap_PostSpamRows(header, nil)

	elseif IsShiftKeyDown() and not ChatFrameEditBox:IsVisible() then
		-- will happen seldom
		DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.RankUsage)
	end

end

function Recap_List_OnClick(frame, button, down)

	local id, index, thisCombatant
	local _G = getfenv(0)

	id = this:GetID()
	index = id + FauxScrollFrame_GetOffset(RecapScrollBar)

	if (index < recap_temp.ListSize) then
		thisCombatant = recap_temp.List[index].Name
		recap_temp.OutgoingDetailSelected = 0
		recap_temp.IncomingDetailSelected = 0
		recap_temp.OtherDetailSelected = 0
		recap_temp.PanelRecentSelected = 0

		if (recap_temp.Selected == index) then
			recap_temp.Selected = 0
			recap_temp.RecentSelected = 0
			_G["RecapList"..id]:UnlockHighlight()
			RecapPanel_Hide()
		else
			recap_temp.Selected = index
			RecapScrollBar_Update()
			RecapPanel_Show(thisCombatant)
		end

		-- detect double-click
		local isDoubleClick = false
		local thisClickTime = GetTime()
		if thisCombatant == recap_temp.CombatantPriorCombatant then
			-- another click on the same Combatant
			if (thisClickTime - recap_temp.CombatantPriorClickTime) < 0.3 then
				-- two clicks on the same Combatant within less than 0.3 seconds, call it a double-click
				isDoubleClick = true
			end
		end
		recap_temp.CombatantPriorCombatant = thisCombatant
		recap_temp.CombatantPriorClickTime = thisClickTime

		if IsShiftKeyDown() and not isDoubleClick then
			Recap_InsertChat(string_format(recap_temp.Localize.VerboseLinkStart,
								"("..Recap_PetsMergedText()..")",
								Recap_StripGUIDsFromCombatant(thisCombatant),
								_G["RecapList"..id.."_DmgIn"]:GetText(),
								_G["RecapList"..id.."_TimeIn"]:GetText(),
								_G["RecapList"..id.."_DPSIn"]:GetText(),
								_G["RecapList"..id.."_Kills"]:GetText(),
								_G["RecapList"..id.."_DmgOut"]:GetText(),
								_G["RecapList"..id.."_Time"]:GetText(),
								_G["RecapList"..id.."_DPS"]:GetText(),
								_G["RecapList"..id.."_MaxHit"]:GetText(),
								_G["RecapList"..id.."_Heal"]:GetText(),
								_G["RecapList"..id.."_TimeHeal"]:GetText(),
								_G["RecapList"..id.."_HPS"]:GetText() ).." "..recap_temp.Localize.For.." "..
								recap_temp.LastAll[recap.Opt.View.value])

		elseif (button == "LeftButton") and not IsShiftKeyDown() and isDoubleClick then
			if IsControlKeyDown() then
				-- with control down for the double-click, show dispels (which includes breaking crowd control)
				RecapRecent_Populate(thisCombatant, true)
			else
				-- ordinary double-click, show all recent events including dispels
				RecapRecent_Populate(thisCombatant, nil)
			end
			RecapRecent:Show()
			-- on a double-click leave the combatant selected and the panel showing
			recap_temp.Selected = index
			RecapScrollBar_Update()
			RecapPanel_Show(thisCombatant)

		elseif (button == "RightButton") and not IsShiftKeyDown() and not isDoubleClick then
			if thisCombatant and recap.Combatant[thisCombatant] and recap.Combatant[thisCombatant].Friend then
				recap_temp.Selected = index
				RecapScrollBar_Update()
				if recap.Opt.View.value == "Last" then
					Recap_CreateMenu(recap_temp.Localize.DropMenu, 1)
				elseif recap.Combatant[thisCombatant].Locked then
					Recap_CreateMenu(recap_temp.Localize.DropUnlockMenu, 1)
				else
					Recap_CreateMenu(recap_temp.Localize.DropLockMenu, 1)
				end
			else
				recap_temp.Selected = index
				RecapScrollBar_Update()
				if recap.Opt.View.value == "Last" then
					Recap_CreateMenu(recap_temp.Localize.AddMenu, 1)
				elseif recap.Combatant[thisCombatant].Locked then
					Recap_CreateMenu(recap_temp.Localize.AddUnlockMenu, 1)
				else
					Recap_CreateMenu(recap_temp.Localize.AddLockMenu, 1)
				end
			end
		end
	end
end

-- allow click reporting off the totals line
function Recap_List_Totals_OnClick(frame, button, down)

	local i, thisCombatant
	local _G = getfenv(0)

	recap_temp.OutgoingDetailSelected = 0
	recap_temp.IncomingDetailSelected = 0
	recap_temp.OtherDetailSelected = 0
	recap_temp.PanelRecentSelected = 0
	for i=1,15 do
		_G["RecapList"..i]:UnlockHighlight()
	end

	-- detect double-click
	local isDoubleClick = false
	local thisClickTime = GetTime()
	if (recap_temp.CombatantPriorCombatant == "Recap_List_Totals_OnClick") then
		-- another click on the total line
		if (thisClickTime - recap_temp.CombatantPriorClickTime) < 0.3 then
			-- two clicks on the total line within less than 0.3 seconds, call it a double-click
			isDoubleClick = true
		end
	end
	recap_temp.CombatantPriorCombatant = "Recap_List_Totals_OnClick"
	recap_temp.CombatantPriorClickTime = thisClickTime

	if IsShiftKeyDown() and not isDoubleClick then
		recap_temp.Selected = 0
		RecapPanel_Hide()
		Recap_InsertChat(string_format(recap_temp.Localize.VerboseGroupTotalStart,
							"("..Recap_PetsMergedText()..")",
							_G["RecapTotals_DmgIn"]:GetText(),
							_G["RecapTotals_TimeIn"]:GetText(),
							_G["RecapTotals_DPSIn"]:GetText(),
							_G["RecapTotals_Kills"]:GetText(),
							_G["RecapTotals_DmgOut"]:GetText(),
							_G["RecapTotals_Time"]:GetText(),
							_G["RecapTotals_DPS"]:GetText(),
							_G["RecapTotals_MaxHit"]:GetText(),
							_G["RecapTotals_Heal"]:GetText(),
							_G["RecapTotals_TimeHeal"]:GetText(),
							_G["RecapTotals_HPS"]:GetText() ).." "..recap_temp.Localize.For.." "..
							recap_temp.LastAll[recap.Opt.View.value])
		-- create totals for the other (non-group) combatants
		local dmgin, kills, dmgout, heal, maxhit, duration, durationIn, DurationHeal
		dmgin = 0
		kills = 0
		dmgout = 0
		heal = 0
		maxhit = 0
		if recap.Opt.View.value=="Last" then
			duration = recap[recap_temp.p].LastDuration
			durationIn = recap[recap_temp.p].LastDurationIn
			durationHeal = recap[recap_temp.p].LastDurationHeal
		else
			duration = recap[recap_temp.p].TotalDuration
			durationIn = recap[recap_temp.p].TotalDurationIn
			durationHeal = recap[recap_temp.p].TotalDurationHeal
		end
		if duration>0 or durationIn>0 or durationHeal>0 then
			for j=1,recap_temp.ListSize-1 do
				thisCombatant = recap_temp.List[j].Name
				if thisCombatant and recap.Combatant[thisCombatant] and not recap.Combatant[thisCombatant].Friend then
					if recap_temp.List[j].MaxHit > maxhit then
						maxhit = recap_temp.List[j].MaxHit
					end
					dmgin = dmgin + recap_temp.List[j].DmgIn
					kills = kills + recap_temp.List[j].Kills
					dmgout = dmgout + recap_temp.List[j].DmgOut
					heal = heal + recap_temp.List[j].Heal
				end
			end
			Recap_InsertChat(string_format(recap_temp.Localize.VerboseNonGroupTotalStart,
								"("..Recap_PetsMergedText()..")",
								dmgin,
								_G["RecapTotals_TimeIn"]:GetText(),
								(((durationIn>0) and Recap_Div1(dmgin,durationIn)) or 0),
								kills,
								dmgout,
								_G["RecapTotals_Time"]:GetText(),
								(((duration>0) and Recap_Div1(dmgout,duration)) or 0),
								maxhit,
								heal,
								_G["RecapTotals_TimeHeal"]:GetText(),
								(((durationHeal>0) and Recap_Div1(heal,durationHeal)) or 0)).." "..recap_temp.Localize.For.." "..
								recap_temp.LastAll[recap.Opt.View.value])
		end

	elseif not IsShiftKeyDown() and isDoubleClick then
		-- double-click on total line shows all recent combat event information (may have to limit this since 10,000 lines could take a while and be much more than one wants to see)
		-- control+double-click on total line shows all recent dispel information (including breaking crowd control)
		recap_temp.Selected = 0
		RecapPanel_Hide()
		if recap.Opt.RecentData.value then
			if IsControlKeyDown() then
				-- with control down for the double-click, show all dispels (which includes breaking crowd control)
				RecapRecent_PopulateAll(true)
			else
				-- ordinary double-click, show all recent events including dispels
				RecapRecent_PopulateAll(nil)
			end
			RecapRecent:Show()
		end
	end
end

function Recap_GroupTotal_OnClick(frame, button, down)
	if recap.Opt.ShowPanel.value then
		if (recap_temp.Selected == recap_temp.GroupIndex) and RecapPanel:IsShown() then
			-- toggle off
			recap_temp.Selected = 0
			RecapPanel_Hide()
		else
			-- calculate our special combatant "Group Total" (on demand only, since it takes a significant amount of time)
			Recap_ClearGrandTotal(recap_temp.GroupTotal)
			Recap_DoGrandTotal(recap_temp.GroupTotal)
			recap_temp.Selected = recap_temp.GroupIndex -- non-zero value to keep the panel showing and indicate which total we are showing
			RecapScrollBar_Update()
			RecapPanel_Populate(recap_temp.GroupTotal)
			RecapPanel:Show()
		end
	end
end

function Recap_NonGroupTotal_OnClick(frame, button, down)
	if recap.Opt.ShowPanel.value then
		if (recap_temp.Selected == recap_temp.NonGroupIndex) and RecapPanel:IsShown() then
			-- toggle off
			recap_temp.Selected = 0
			RecapPanel_Hide()
		else
			-- calculate our special combatant "Non-Group Total" (on demand only, since it takes a significant amount of time)
			Recap_ClearGrandTotal(recap_temp.NonGroupTotal)
			Recap_DoGrandTotal(recap_temp.NonGroupTotal)
			recap_temp.Selected = recap_temp.NonGroupIndex -- non-zero value to keep the panel showing and indicate which total we are showing
			RecapScrollBar_Update()
			RecapPanel_Populate(recap_temp.NonGroupTotal)
			RecapPanel:Show()
		end
	end
end

function Recap_ClearGrandTotal(thisTotal)

	recap.Combatant[thisTotal] = {}
	if thisTotal == recap_temp.GroupTotal then
		recap.Combatant[thisTotal].Friend = true
	else
		recap.Combatant[thisTotal].Friend = false
	end
end

function Recap_DoGrandTotal(thisTotal)

	local i, iCombatant, iTotal

	local AllLastOutgoingDetail = "OutgoingDetail"
	local AllLastIncomingDetail = "IncomingDetail"
	local AllLastOtherDetail = "OtherDetail"
	if recap.Opt.View.value=="Last" then
		AllLastOutgoingDetail = "LastOutgoingDetail_"..recap_temp.DisplayLastFight
		AllLastIncomingDetail = "LastIncomingDetail_"..recap_temp.DisplayLastFight
		AllLastOtherDetail = "LastOtherDetail_"..recap_temp.DisplayLastFight
	end

	-- accumulate
	if not recap.Combatant then
		recap.Combatant = {}
	end
	for i in pairs(recap.Combatant) do
		if (i ~= recap_temp.GroupTotal) and (i ~= recap_temp.NonGroupTotal) then
			iCombatant = recap.Combatant[i]
			if ((iCombatant["LastDmgIn_"..recap_temp.DisplayLastFight]==nil or iCombatant["LastDmgIn_"..recap_temp.DisplayLastFight]==0) and
				(iCombatant["LastDmgOut_"..recap_temp.DisplayLastFight]==nil or iCombatant["LastDmgOut_"..recap_temp.DisplayLastFight]==0) and
				(iCombatant.TotalDmgOut==nil or iCombatant.TotalDmgOut==0) and
				(iCombatant.TotalDmgIn==nil or iCombatant.TotalDmgIn==0) and
				(iCombatant["LastRawHeal_"..recap_temp.DisplayLastFight]==nil or iCombatant["LastRawHeal_"..recap_temp.DisplayLastFight]==0) and
				(iCombatant.TotalRawHeal==nil or iCombatant.TotalRawHeal==0)) or
			   (recap.Opt.HideOthers.value and (not iCombatant.Friend)) or
			   (recap.Opt.HideGroup.value and (not Recap_CheckForSelf(i)) and iCombatant.Friend) or
			   (recap.Opt.HideYardTrash.value and not iCombatant.Friend and Recap_CombatantIsTrash(i)) or
			   (iCombatant.Ignore) then
				-- ignore unwanted combatants (if-statement code duplicated from earlier)

			elseif recap.Opt.View.value=="Last" and iCombatant.WasInLast then
				if not recap.Opt.HideZero.value or ((iCombatant["LastTime_"..recap_temp.DisplayLastFight] and (iCombatant["LastTime_"..recap_temp.DisplayLastFight] > recap_temp.MinTime)) or
													(iCombatant["LastTimeIn_"..recap_temp.DisplayLastFight] and (iCombatant["LastTimeIn_"..recap_temp.DisplayLastFight] > recap_temp.MinTime)) or
													(iCombatant["LastTimeHeal_"..recap_temp.DisplayLastFight] and (iCombatant["LastTimeHeal_"..recap_temp.DisplayLastFight] > recap_temp.MinTime))) then
					if (thisTotal == recap_temp.GroupTotal) and iCombatant.Friend then
						-- this is a valid group combatant; add their Outgoing, Incoming, and Other Details to a hidden combatant called "Group Total"
						Recap_AccumulateGrandTotal(thisTotal, i, AllLastOutgoingDetail, AllLastIncomingDetail, AllLastOtherDetail)
					elseif (thisTotal == recap_temp.NonGroupTotal) and not iCombatant.Friend then
						-- this is a valid non-group combatant; add their Outgoing, Incoming, and Other Details to a hidden combatant called "Non-Group Total"
						Recap_AccumulateGrandTotal(thisTotal, i, AllLastOutgoingDetail, AllLastIncomingDetail, AllLastOtherDetail)
					end
				end

			elseif recap.Opt.View.value=="All" then
				if not recap.Opt.HideZero.value or ((iCombatant.TotalTime and (iCombatant.TotalTime > recap_temp.MinTime)) or
													(iCombatant.TotalTimeIn and (iCombatant.TotalTimeIn > recap_temp.MinTime)) or
													(iCombatant.TotalTimeHeal and (iCombatant.TotalTimeHeal > recap_temp.MinTime))) then
					if (thisTotal == recap_temp.GroupTotal) and iCombatant.Friend then
						-- this is a valid group combatant; add their Outgoing, Incoming, and Other Details to a hidden combatant called "Group Total"
						Recap_AccumulateGrandTotal(thisTotal, i, AllLastOutgoingDetail, AllLastIncomingDetail, AllLastOtherDetail)
					elseif (thisTotal == recap_temp.NonGroupTotal) and not iCombatant.Friend then
						-- this is a valid non-group combatant; add their Outgoing, Incoming, and Other Details to a hidden combatant called "Non-Group Total"
						Recap_AccumulateGrandTotal(thisTotal, i, AllLastOutgoingDetail, AllLastIncomingDetail, AllLastOtherDetail)
					end
				end
			end
		end
	end

	-- per second values
	iTotal = recap.Combatant[thisTotal]
	if iTotal.TotalTime and (iTotal.TotalTime > recap_temp.MinTime) and ((iTotal.TotalDmgOut or 0) > 0) then
		iTotal.TotalDPS = Recap_Div1((iTotal.TotalDmgOut or 0), iTotal.TotalTime)
	end
	if iTotal.TotalTimeIn and (iTotal.TotalTimeIn > recap_temp.MinTime) and ((iTotal.TotalDmgIn or 0) > 0) then
		iTotal.TotalDPSIn = Recap_Div1((iTotal.TotalDmgIn or 0), iTotal.TotalTimeIn)
	end
	if iTotal.TotalTimeHeal and (iTotal.TotalTimeHeal > recap_temp.MinTime) and (((iTotal.TotalRawHeal or 0) - (iTotal.TotalOverHeal or 0)) > 0) then
		iTotal.TotalHPS = Recap_Div1(((iTotal.TotalRawHeal or 0) - (iTotal.TotalOverHeal or 0)), iTotal.TotalTimeHeal)
	end
	if iTotal["LastTime_"..recap_temp.DisplayLastFight] and (iTotal["LastTime_"..recap_temp.DisplayLastFight] > recap_temp.MinTime) and ((iTotal["LastDmgOut_"..recap_temp.DisplayLastFight] or 0) > 0) then
		iTotal["LastDPS_"..recap_temp.DisplayLastFight] = Recap_Div1((iTotal["LastDmgOut_"..recap_temp.DisplayLastFight] or 0), iTotal["LastTime_"..recap_temp.DisplayLastFight])
	end
	if iTotal["LastTimeIn_"..recap_temp.DisplayLastFight] and (iTotal["LastTimeIn_"..recap_temp.DisplayLastFight] > recap_temp.MinTime) and ((iTotal["LastDmgIn_"..recap_temp.DisplayLastFight] or 0) > 0) then
		iTotal["LastDPSIn_"..recap_temp.DisplayLastFight] = Recap_Div1((iTotal["LastDmgIn_"..recap_temp.DisplayLastFight] or 0), iTotal["LastTimeIn_"..recap_temp.DisplayLastFight])
	end
	if iTotal["LastTimeHeal_"..recap_temp.DisplayLastFight] and (iTotal["LastTimeHeal_"..recap_temp.DisplayLastFight] > recap_temp.MinTime) and (((iTotal["LastRawHeal_"..recap_temp.DisplayLastFight] or 0) - (iTotal["LastOverHeal_"..recap_temp.DisplayLastFight] or 0)) > 0) then
		iTotal["LastHPS_"..recap_temp.DisplayLastFight] = Recap_Div1(((iTotal["LastRawHeal_"..recap_temp.DisplayLastFight] or 0) - (iTotal["LastOverHeal_"..recap_temp.DisplayLastFight] or 0)), iTotal["LastTimeHeal_"..recap_temp.DisplayLastFight])
	end

end

function Recap_AccumulateGrandTotal(thisTotal, thisCombatant, AllLastOutgoingDetail, AllLastIncomingDetail, AllLastOtherDetail)

	local i, j, iTotal, iCombatant

	iTotal = recap.Combatant[thisTotal]
	iCombatant = recap.Combatant[thisCombatant]

	-- accumulate across all combatants into a single hidden combatant named "Group Total"
	if iCombatant[AllLastOutgoingDetail] then
		for i in pairs(iCombatant[AllLastOutgoingDetail]) do
			if not iTotal[AllLastOutgoingDetail] then
				iTotal[AllLastOutgoingDetail] = {}
			end
			if not iTotal[AllLastOutgoingDetail][i] then
				iTotal[AllLastOutgoingDetail][i] = {}
			end
			Recap_AccumulateDetails(iTotal[AllLastOutgoingDetail][i], iCombatant[AllLastOutgoingDetail][i])
		end
	end
	if iCombatant[AllLastIncomingDetail] then
		for i in pairs(iCombatant[AllLastIncomingDetail]) do
			if not iTotal[AllLastIncomingDetail] then
				iTotal[AllLastIncomingDetail] = {}
			end
			if not iTotal[AllLastIncomingDetail][i] then
				iTotal[AllLastIncomingDetail][i] = {}
			end
			Recap_AccumulateDetails(iTotal[AllLastIncomingDetail][i], iCombatant[AllLastIncomingDetail][i])
		end
	end
	if iCombatant[AllLastOtherDetail] then
		for i in pairs(iCombatant[AllLastOtherDetail]) do
			if not iTotal[AllLastOtherDetail] then
				iTotal[AllLastOtherDetail] = {}
			end
			if not iTotal[AllLastOtherDetail][i] then
				iTotal[AllLastOtherDetail][i] = {}
			end
			Recap_AccumulateDetails(iTotal[AllLastOtherDetail][i], iCombatant[AllLastOtherDetail][i])
		end
	end

	-- include some total values
	j = (iTotal.TotalTime or 0) + (iCombatant.TotalTime or 0)
	if j>0 then
		iTotal.TotalTime = j
	end
	j = (iTotal.TotalTimeIn or 0) + (iCombatant.TotalTimeIn or 0)
	if j>0 then
		iTotal.TotalTimeIn = j
	end
	j = (iTotal.TotalTimeHeal or 0) + (iCombatant.TotalTimeHeal or 0)
	if j>0 then
		iTotal.TotalTimeHeal = j
	end
	j = math_max((iTotal.TotalMaxHit or 0), (iCombatant.TotalMaxHit or 0))
	if j>0 then
		iTotal.TotalMaxHit = j
	end
	j = (iTotal.TotalKills or 0) + (iCombatant.TotalKills or 0)
	if j>0 then
		iTotal.TotalKills = j
	end
	j = (iTotal.TotalRawHeal or 0) + (iCombatant.TotalRawHeal or 0)
	if j>0 then
		iTotal.TotalRawHeal = j
	end
	j = (iTotal.TotalOverHeal or 0) + (iCombatant.TotalOverHeal or 0)
	if j>0 then
		iTotal.TotalOverHeal = j
	end
	j = (iTotal.TotalDmgIn or 0) + (iCombatant.TotalDmgIn or 0)
	if j>0 then
		iTotal.TotalDmgIn = j
	end
	j = (iTotal.TotalDmgOut or 0) + (iCombatant.TotalDmgOut or 0)
	if j>0 then
		iTotal.TotalDmgOut = j
	end
	if iCombatant.WasInLast then
		j = (iTotal["LastTime_"..recap_temp.DisplayLastFight] or 0) + (iCombatant["LastTime_"..recap_temp.DisplayLastFight] or 0)
		if j>0 then
			iTotal["LastTime_"..recap_temp.DisplayLastFight] = j
		end
		j = (iTotal["LastTimeIn_"..recap_temp.DisplayLastFight] or 0) + (iCombatant["LastTimeIn_"..recap_temp.DisplayLastFight] or 0)
		if j>0 then
			iTotal["LastTimeIn_"..recap_temp.DisplayLastFight] = j
		end
		j = (iTotal["LastTimeHeal_"..recap_temp.DisplayLastFight] or 0) + (iCombatant["LastTimeHeal_"..recap_temp.DisplayLastFight] or 0)
		if j>0 then
			iTotal["LastTimeHeal_"..recap_temp.DisplayLastFight] = j
		end
		j = math_max((iTotal["LastMaxHit_"..recap_temp.DisplayLastFight] or 0), (iCombatant["LastMaxHit_"..recap_temp.DisplayLastFight] or 0))
		if j>0 then
			iTotal["LastMaxHit_"..recap_temp.DisplayLastFight] = j
		end
		j = (iTotal["LastKills_"..recap_temp.DisplayLastFight] or 0) + (iCombatant["LastKills_"..recap_temp.DisplayLastFight] or 0)
		if j>0 then
			iTotal["LastKills_"..recap_temp.DisplayLastFight] = j
		end
		j = (iTotal["LastRawHeal_"..recap_temp.DisplayLastFight] or 0) + (iCombatant["LastRawHeal_"..recap_temp.DisplayLastFight] or 0)
		if j>0 then
			iTotal["LastRawHeal_"..recap_temp.DisplayLastFight] = j
		end
		j = (iTotal["LastOverHeal_"..recap_temp.DisplayLastFight] or 0) + (iCombatant["LastOverHeal_"..recap_temp.DisplayLastFight] or 0)
		if j>0 then
			iTotal["LastOverHeal_"..recap_temp.DisplayLastFight] = j
		end
		j = (iTotal["LastDmgIn_"..recap_temp.DisplayLastFight] or 0) + (iCombatant["LastDmgIn_"..recap_temp.DisplayLastFight] or 0)
		if j>0 then
			iTotal["LastDmgIn_"..recap_temp.DisplayLastFight] = j
		end
		j = (iTotal["LastDmgOut_"..recap_temp.DisplayLastFight] or 0) + (iCombatant["LastDmgOut_"..recap_temp.DisplayLastFight] or 0)
		if j>0 then
			iTotal["LastDmgOut_"..recap_temp.DisplayLastFight] = j
		end
	end
end

function Recap_AccumulateDetails(iTotalDetail, iDetail)

	local j

	if iDetail then
		for j in pairs(iDetail) do
			if (j == "Element") then
				-- fancy merge
				iTotalDetail[j] = Recap_MergeElements(iTotalDetail[j], iDetail[j])
			elseif (j == "Attribute") then
				-- direct copy (not a composite string)
				iTotalDetail[j] = iDetail[j]
			elseif (j == "PrevTime") or (j == "PrevTimeDur") then
				-- ignore
			elseif (j == "GlancesMin") or (j == "HitsMin") or (j == "TicksMin") or (j == "CritsMin") or (j == "CrushMin") then
				-- minima
				iTotalDetail[j] = Recap_Min(iTotalDetail[j], iDetail[j])
			elseif (j == "GlancesMax") or (j == "HitsMax") or (j == "TicksMax") or (j == "CritsMax") or (j == "CrushMax") then
				-- maxima
				iTotalDetail[j] = math_max((iTotalDetail[j] or 0), iDetail[j])
			else
				-- everything else is a straight sum
				iTotalDetail[j] = (iTotalDetail[j] or 0) + iDetail[j]
			end
		end
	end
end

local mergeElements = {}
function Recap_MergeElements(first, second)

	if not first then
		return second
	elseif not second then
		return first
	else
		-- need to do something fancier
		local i, result
		for i in pairs(mergeElements) do
			mergeElements[i] = nil
		end
		for i in string_gmatch(first, "[^%+]+") do
			mergeElements[i] = true
		end
		for i in string_gmatch(second, "[^%+]+") do
			mergeElements[i] = true
		end
		result = nil
		for i in pairs(mergeElements) do
			if mergeElements[i] then
				if not result then
					result = i
				else
					result = result.."+"..i
				end
			end
		end
		return result
	end
end

function Recap_Recent_OnClick(frame, button, down)

	local id, index, thisCombatant
	local _G = getfenv(0)

	id = this:GetID()
	index = id + FauxScrollFrame_GetOffset(RecapScrollBar)

	if recap.Opt.RecentData.value then
		if recap.Opt.SelfView.value then
			if index<recap_temp.SelfListSize then
				if recap_temp.RecentSelected==index then
					recap_temp.RecentSelected = 0
					RecapRecent:Hide()
				else
					recap_temp.RecentSelected = index
					local sourceName, effectType, effectName, found, effectFirstPart, effectSecondPart, simpleEffect
					sourceName = recap_temp.PlayerGUID
					effectType = string_sub(recap_temp.SelfList[index].EName,1,1)
					effectName = string_sub(recap_temp.SelfList[index].EName,2)
					if (effectType == "2") or (effectType == "4") then
						-- "pet: effect" or "pet: effectFirstPart: effectSecondPart"
						found, _, _, effectFirstPart, effectSecondPart = string_find(effectName, "^(.+): (.+): (.+)$")
						if found then
							-- "pet: effectFirstPart: effectSecondPart"
							effectName = effectFirstPart..": "..effectSecondPart
						else
							-- "pet: effect"
							found, _, _, simpleEffect = string_find(effectName, "^(.+): (.+)$")
							if found then
								-- "pet: effect"
								effectName = simpleEffect
							else
								-- shouldn't get here
							end
						end
					else
						-- "effect" or "effectFirstPart: effectSecondPart"
						-- effectName should already be correct
					end
					RecapRecent_PopulateByEffect(true, sourceName, effectName) -- from Self always selected Outgoing
					RecapRecent:Show()
				end
			end
		else
			if index<recap_temp.ListSize then
				if recap_temp.RecentSelected==index then
					recap_temp.RecentSelected = 0
					RecapRecent:Hide()
				else
					recap_temp.RecentSelected = index
					thisCombatant = recap_temp.List[index].Name
					if IsControlKeyDown() then
						-- with control down for the double-click, show dispels (which includes breaking crowd control)
						RecapRecent_Populate(thisCombatant, true)
					else
						-- ordinary click, show recent events including dispels
						RecapRecent_Populate(thisCombatant, nil)
					end
					RecapRecent:Show()
				end
			end
		end
	else
		PlaySound("igQuestFailed")
	end
end


--[[ Tooltip functions ]]

function Recap_MultilineTooltip(line1, line2, line3, line4)

	if recap_temp.Loaded and recap.Opt.ShowTooltips.value then
		recap_temp.RecapTooltip:ClearAllPoints()
		if not recap.Opt.TooltipFollow.value then
			GameTooltip_SetDefaultAnchor(recap_temp.RecapTooltip,this)
		else
			recap_temp.RecapTooltip:SetOwner(this,Recap_TooltipAndMenuAnchor())
		end
		recap_temp.RecapTooltip:SetText(line1)
		if line2 ~= "" then
			recap_temp.RecapTooltip:AddLine(line2, .75, .75, .75, 1)
		end
		if line3 ~= "" then
			recap_temp.RecapTooltip:AddLine(line3, .75, .75, .75, 1)
		end
		if line4 ~= "" then
			recap_temp.RecapTooltip:AddLine(line4, .75, .75, .75, 1)
		end
		recap_temp.RecapTooltip:Show()
	end
end

-- returns line1,line2 of a tooltip for type in OptList (for generic static tooltips)
function Recap_GetTooltip(myType)

	local i

	if myType then
		for i in pairs(recap_temp.OptList) do
			if recap_temp.OptList[i][1]==myType then
				return recap_temp.OptList[i][2],recap_temp.OptList[i][3]
			end
		end
	end
end

-- type=tooltip index, addition=optional addition to header
function Recap_Tooltip(myType, addition)

	local line1, line2

	if myType=="Status" then
		Recap_MultilineTooltip(recap_temp.Recap.." "..recap_temp.Localize.Status..": "..recap_temp.StoppedActiveIdle[recap.Opt.State.value],recap_temp.Localize.StatusTooltip)
	elseif myType=="Close" then
		if recap.Opt.State.value=="Stopped" then
			Recap_Tooltip("ExitRecap")
		else
			Recap_Tooltip("HideWindow")
		end
	elseif myType=="Minimize" then
		if recap.Opt.Minimized.value then
			Recap_Tooltip("ExpandWindow")
		else
			Recap_Tooltip("MinimizeWindow")
		end
	elseif myType=="Pin" then
		if recap.Opt.Pinned.value then
			Recap_Tooltip("UnPinWindow")
		else
			Recap_Tooltip("PinWindow")
		end
	elseif myType=="Pause" then
		if recap.Opt.State.value=="Stopped" then
			Recap_Tooltip("Resume")
		else
			Recap_Tooltip("PauseMonitoring")
		end
	elseif myType=="ShowAll" then
		if recap.Opt.View.value=="Last" then
			Recap_Tooltip("ShowAllFights")
		else
			Recap_Tooltip("ShowLastFight")
		end
	elseif myType=="HeaderName" then
		if recap.Opt.View.value=="Last" then
			Recap_Tooltip("CombatLast")
		else
			Recap_Tooltip("CombatAll")
		end
	elseif myType=="Reset" then
		if recap.Opt.SelfView.value then
			Recap_Tooltip("ResetSelfView")
		elseif recap.Opt.View.value=="Last" then
			Recap_Tooltip("ResetLastFight")
		else
			Recap_Tooltip("ResetAllTotals")
		end

	elseif myType=="SelfView" then
		if recap.Opt.SelfView.value then
			Recap_Tooltip("HideSelfView")
		else
			Recap_Tooltip("ShowSelfView")
		end
	else
		line1,line2 = Recap_GetTooltip(myType)
		if line1 and line2 then
			if addition then
				Recap_MultilineTooltip(line1..": "..addition, line2)
			else
				Recap_MultilineTooltip(line1, line2)
			end
		end
	end
end

function Recap_List_OnEnter()

	-- lock OnEnter-OnLeave events
	if recap_temp.OnEnterOnLeave == true then return end
	recap_temp.OnEnterOnLeave = true

	local index, id, secondLine, thirdLine, fourthLine, thisCombatant, iCombatant

	id = this:GetID()
	index = id + FauxScrollFrame_GetOffset(RecapScrollBar)

	thisCombatant = recap_temp.List[index].Name
	if thisCombatant then
		iCombatant = recap.Combatant[thisCombatant]
		secondLine = ""
		if iCombatant.Class and recap_temp.Localize.ClassName[iCombatant.Class] then
			secondLine = recap_temp.Localize.ClassName[iCombatant.Class]
		end
		if iCombatant.Faction and recap_temp.Localize.FactionName[iCombatant.Faction] then
			secondLine = secondLine.." (".. recap_temp.Localize.FactionName[iCombatant.Faction]..")"
		end
		if Recap_ExtractOwner(thisCombatant) then
			secondLine = secondLine.." ("..recap_temp.Localize.OwnedBy.." "..Recap_NameFromNameGUID(Recap_ExtractOwner(thisCombatant))..")"
		elseif recap.Combatant[thisCombatant].OwnedBy then
			secondLine = secondLine.." ("..recap_temp.Localize.OwnedBy.." "..Recap_NameFromNameGUID(recap.Combatant[thisCombatant].OwnedBy)..")"
		end
		thirdLine = ""
		if iCombatant.MinMaxHealth then
			if iCombatant.MinMaxHealth == iCombatant.MaxMaxHealth then
				thirdLine = RECAP_MAX.." "..recap_temp.Localize.PowerName[-2]..":  "..iCombatant.MinMaxHealth
			else
				thirdLine = RECAP_MAX.." "..recap_temp.Localize.PowerName[-2]..":  "..iCombatant.MinMaxHealth..".."..iCombatant.MaxMaxHealth
			end
		end
		fourthLine = ""
		if iCombatant.MinMaxPower and (type(iCombatant.PowerType) == "number") then
			if iCombatant.MinMaxPower == iCombatant.MaxMaxPower then
				fourthLine = RECAP_MAX.." "..recap_temp.Localize.PowerName[iCombatant.PowerType]..":  "..iCombatant.MinMaxPower
			else
				fourthLine = RECAP_MAX.." "..recap_temp.Localize.PowerName[iCombatant.PowerType]..":  "..iCombatant.MinMaxPower..".."..iCombatant.MaxMaxPower
			end
		end
		Recap_MultilineTooltip(Recap_NameOnlyFromCombatant(thisCombatant), secondLine, thirdLine, fourthLine)
	end
	if (index<recap_temp.ListSize) and recap_temp.Selected==0 then
		if thisCombatant then
			RecapPanel_Show(thisCombatant)
		end
	end

	-- unlock OnEnter-OnLeave events
	recap_temp.OnEnterOnLeave = false
end

function Recap_Totals_OnEnter()

	-- lock OnEnter-OnLeave events
	if recap_temp.OnEnterOnLeave == true then return end
	recap_temp.OnEnterOnLeave = true

	local i, thisCombatant, iTotal
	local r = recap_temp.ColorWhite.r
	local g = recap_temp.ColorWhite.g
	local b = recap_temp.ColorWhite.b
	local other_kills = 0

	if recap.Opt.ShowTooltips.value then

		if recap.Opt.TooltipFollow.value then
			recap_temp.RecapTooltip:SetOwner(this,Recap_TooltipAndMenuAnchor())
		else
			GameTooltip_SetDefaultAnchor(recap_temp.RecapTooltip,this)
		end

		recap_temp.RecapTooltip:AddLine(recap_temp.Localize.Totals.." "..recap_temp.Localize.For.." "..recap_temp.LastAll[recap.Opt.View.value])

		if recap_temp.ListSize>1 then

			for i=1,(recap_temp.ListSize-1) do
				thisCombatant = recap_temp.List[i].Name
				if thisCombatant and recap.Combatant[thisCombatant] and (not recap.Combatant[thisCombatant].Friend) then
					other_kills = other_kills + recap_temp.List[i].Kills
				end
			end
			iTotal = recap_temp.List[recap_temp.ListSize]
			recap_temp.RecapTooltip:AddDoubleLine(RECAP_COMBATANTS..":",recap_temp.ListSize-1,r,g,b,r,g,b)
			recap_temp.RecapTooltip:AddDoubleLine(" ") -- blank line
			recap_temp.RecapTooltip:AddDoubleLine(RECAP_DAMAGE_OUT..":",iTotal.DmgOut,recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b,recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
			recap_temp.RecapTooltip:AddDoubleLine(RECAP_TIME_FIGHTING..":",Recap_FormatTime(iTotal.Time),recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b,recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
			recap_temp.RecapTooltip:AddDoubleLine(RECAP_DPS_OUT..":",string_format("%.1f",iTotal.TotDPSOut),recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b,recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
			recap_temp.RecapTooltip:AddDoubleLine(RECAP_MAX_HIT..":",iTotal.MaxHit,r,g,b,r,g,b)
			recap_temp.RecapTooltip:AddDoubleLine(RECAP_KILLS..":",other_kills,r,g,b,r,g,b)
			recap_temp.RecapTooltip:AddDoubleLine(" ") -- blank line
			recap_temp.RecapTooltip:AddDoubleLine(RECAP_DAMAGE_IN..":",iTotal.DmgIn,recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b,recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b)
			recap_temp.RecapTooltip:AddDoubleLine(RECAP_TIME_DAMAGED..":",Recap_FormatTime(iTotal.TimeIn),recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b,recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b)
			recap_temp.RecapTooltip:AddDoubleLine(RECAP_DPS_IN..":",string_format("%.1f",iTotal.TotDPSIn),recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b,recap_temp.ColorDmgIn.r,recap_temp.ColorDmgIn.g,recap_temp.ColorDmgIn.b)
			recap_temp.RecapTooltip:AddDoubleLine(RECAP_DEATHS..":",iTotal.Kills,r,g,b,r,g,b)
			recap_temp.RecapTooltip:AddDoubleLine(" ") -- blank line
			recap_temp.RecapTooltip:AddDoubleLine(RECAP_HEALS..":",iTotal.Heal,recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b,recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
			recap_temp.RecapTooltip:AddDoubleLine(RECAP_TIME_HEALING..":",Recap_FormatTime(iTotal.TimeHeal),recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b,recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
			recap_temp.RecapTooltip:AddDoubleLine(RECAP_HPS_OUT..":",string_format("%.1f",iTotal.TotHPS),recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b,recap_temp.ColorHeal.r,recap_temp.ColorHeal.g,recap_temp.ColorHeal.b)
			recap_temp.RecapTooltip:AddDoubleLine(" ") -- blank line
			recap_temp.RecapTooltip:AddDoubleLine(RECAP_GROUP_FIGHT_TIME..":",Recap_FormatTime(iTotal.OverallDuration),recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b,recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
			recap_temp.RecapTooltip:AddDoubleLine(RECAP_GROUP_DPS..":",string_format("%.1f",iTotal.OverallDPS),recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b,recap_temp.ColorDmgOut.r,recap_temp.ColorDmgOut.g,recap_temp.ColorDmgOut.b)
		else
			recap_temp.RecapTooltip:AddLine(RECAP_COMBATANTS..": "..recap_temp.Localize.None,r,g,b)
		end

		recap_temp.RecapTooltip:Show()
	end

	-- unlock OnEnter-OnLeave events
	recap_temp.OnEnterOnLeave = false
end

function Recap_Self_OnEnter()

	-- lock OnEnter-OnLeave events
	if recap_temp.OnEnterOnLeave == true then return end
	recap_temp.OnEnterOnLeave = true

	local index, id, thisEffect

	id = this:GetID()
	index = id + FauxScrollFrame_GetOffset(RecapScrollBar)

	thisEffect = recap_temp.SelfList[index].EName
	if thisEffect then
		Recap_MultilineTooltip(string_sub(thisEffect,2))
	end

	-- unlock OnEnter-OnLeave events
	recap_temp.OnEnterOnLeave = false
end

function Recap_TooltipAndMenuAnchor()

	local anchor = "ANCHOR_LEFT"

	if GetCursorPosition("UIParent") < (UIParent:GetWidth()/2) then
		anchor = "ANCHOR_RIGHT"
	end
	return anchor
end

--[[ Context menu functions ]]

function RecapMenu_OnUpdate(frame, elapsed)

	local i
	local _G = getfenv(0)

	if not recap_temp.MenuTimer or MouseIsOver(RecapMenu) then
		recap_temp.MenuTimer = 0
	end

	recap_temp.MenuTimer = recap_temp.MenuTimer + elapsed
	if recap_temp.MenuTimer > 0.5 then
		recap_temp.MenuTimer = 0
		RecapMenu:Hide()
		if recap_temp.SelectedEffect then
			for i=1,15 do
				_G["RecapSelf"..i]:UnlockHighlight()
			end
		end
	end
end

function RecapMenu_SetCheck(id,checked)

	if checked then
		_G["RecapMenu"..id.."_Check"]:Show()
	else
		_G["RecapMenu"..id.."_Check"]:Hide()
	end
end

function RecapMenu_OnClick(frame, button, down)

	local i, j, pet
	local id, index = this:GetID()
	local _G = getfenv(0)

	if recap_temp.Menu==recap_temp.Localize.ColumnMenu or recap_temp.Menu==recap_temp.Localize.MinMenu or recap_temp.Menu==recap_temp.Localize.EffectOptMenu then
		index = recap_temp.Menu[id].Info -- .Info of menu item selected
		if recap.Opt[index] then
			recap.Opt[index].value = not recap.Opt[index].value
			_G["RecapOptCheck_"..recap_temp.Menu[id].Info]:SetChecked(0)
			if recap.Opt[index].value then
				_G["RecapOptCheck_"..recap_temp.Menu[id].Info]:SetChecked(1)
			end
			RecapMenu_SetCheck(id,recap.Opt[index].value)
			if recap.Opt.Minimized.value then
				Recap_Minimize()
			else
				Recap_Maximize()
			end
		elseif index=="Pin" then
			recap.Opt.Pinned.value = not recap.Opt.Pinned.value
			Recap_SetButtons()
			RecapMenu:Hide()
		end
	end

	-- popup menu
	if (recap_temp.Selected > 0) and
	   (recap_temp.Menu==recap_temp.Localize.AddMenu or recap_temp.Menu==recap_temp.Localize.AddLockMenu or recap_temp.Menu==recap_temp.Localize.AddUnlockMenu or
		recap_temp.Menu==recap_temp.Localize.DropMenu or recap_temp.Menu==recap_temp.Localize.DropLockMenu or recap_temp.Menu==recap_temp.Localize.DropUnlockMenu) then

		RecapMenu:Hide()

		local thisCombatant
		thisCombatant = recap_temp.List[recap_temp.Selected].Name -- name selected

		if id==1 and ((recap_temp.Menu==recap_temp.Localize.DropMenu) or (recap_temp.Menu==recap_temp.Localize.DropLockMenu) or (recap_temp.Menu==recap_temp.Localize.DropUnlockMenu)) and thisCombatant~=recap_temp.PlayerGUID then
			-- Make them no longer a 'group combatant'
			recap.Combatant[thisCombatant].Friend = false
			recap_temp.InFriend[thisCombatant] = nil
			-- them and the pets they rode in on
			for pet in pairs(recap.Combatant) do
				if Recap_IsOwnedBy(pet, thisCombatant) then
					recap.Combatant[pet].Friend = false
					recap_temp.InFriend[pet] = nil
				end
			end

		elseif id==1 and thisCombatant~=recap_temp.PlayerGUID then
			-- Toggle their 'group combatant' status
			if recap.Combatant[thisCombatant].Friend then
				-- make unfriend
				recap.Combatant[thisCombatant].Friend = false
				recap_temp.InFriend[thisCombatant] = nil
				-- them and the pets they rode in on
				for pet in pairs(recap.Combatant) do
					if Recap_IsOwnedBy(pet, thisCombatant) then
						recap.Combatant[pet].Friend = false
						recap_temp.InFriend[pet] = nil
					end
				end
			else
				-- make friend
				recap.Combatant[thisCombatant].Friend = true
				recap_temp.InFriend[thisCombatant] = true
				-- them and the pets they rode in on
				for pet in pairs(recap.Combatant) do
					if Recap_IsOwnedBy(pet, thisCombatant) then
						recap.Combatant[pet].Friend = true
						recap_temp.InFriend[pet] = true
					end
				end
			end

		elseif id==2 and recap.Opt.View.value=="All" then -- reset
			if ((recap.Opt.SyncState.value == "Member") or (recap.Opt.SyncState.value == "Leader")) then
				-- ignore if in synchronization
				PlaySound("igQuestFailed")
				Recap_WarnNotAllowedDuringSync()
			else
				-- Reset a combatant, meaning force all their numbers to zero
				local seen = recap.Combatant[thisCombatant].Seen
				local flags = recap.Combatant[thisCombatant].Flags
				recap.Combatant[thisCombatant] = nil -- keep as nil
				Recap_CreateBlankCombatant(thisCombatant, seen, flags)
			end
			collectgarbage("collect")

		elseif id==2 and recap.Opt.View.value=="Last" then -- reset
			if ((recap.Opt.SyncState.value == "Member") or (recap.Opt.SyncState.value == "Leader")) then
				-- ignore if in synchronization
				PlaySound("igQuestFailed")
				Recap_WarnNotAllowedDuringSync()
			else
				-- Partially Reset a combatant, meaning SUBTRACT their last fight information
				if recap.Combatant[thisCombatant].WasInLast then
					StaticPopupDialogs["recap_temp.CONFIRMLASTRESET"] = {
						text = TEXT(recap_temp.Localize.ConfirmLastReset),
						button1 = TEXT(ACCEPT),
						button2 = TEXT(CANCEL),
						OnAccept = function()
							-- SUBTRACT the last fight --
							Recap_ResetLastFight(thisCombatant)
							-- force redisplay (not sure if there might not be a cheaper call)
							Recap_Maximize()
						end,
						OnHide = function()
						end,
						OnCancel = function()
						end,
						timeout = 0,
						showAlert = 1,
						whileDead = 1
					}
					StaticPopup_Show("recap_temp.CONFIRMLASTRESET")
				end
			end
			collectgarbage("collect")

		elseif id==3 and thisCombatant~=recap_temp.PlayerGUID then -- ignore
			if (recap.Opt.SyncState.value == "Member") or (recap.Opt.SyncState.value == "Leader") then
				-- don't ignore a combatant when in synchronization
				PlaySound("igQuestFailed")
				Recap_WarnNotAllowedDuringSync()
			else
				-- Put this combatant on 'ignore' (after forcing all their numbers to zero)
				local seen = recap.Combatant[thisCombatant].Seen
				local flags = recap.Combatant[thisCombatant].Flags
				recap.Combatant[thisCombatant] = nil -- keep as nil
				Recap_CreateBlankCombatant(thisCombatant, seen, flags)
				recap.Combatant[thisCombatant].Ignore = true
			end
			collectgarbage("collect")

		elseif id==4 then
			-- Toggle their Locked status (makes them stick around through an All Fights Reset)
			recap.Combatant[thisCombatant].Locked = not recap.Combatant[thisCombatant].Locked
			-- Set the Locked status of any pets to match
			if not recap.Combatant then
				recap.Combatant = {}
			end
			for i in pairs(recap.Combatant) do
				if (i ~= recap_temp.GroupTotal) and (i ~= recap_temp.NonGroupTotal) then
					if Recap_IsOwnedBy(i, thisCombatant) then
						recap.Combatant[i].Locked = recap.Combatant[thisCombatant].Locked
					end
				end
			end
		end

		Recap_SetView()
	else
		-- remove this effect
		if recap_temp.Menu==recap_temp.Localize.EffectMenu then
			RecapMenu:Hide()
			for i=1,15 do
				_G["RecapSelf"..i]:UnlockHighlight()
			end
			if recap_temp.SelectedEffect then
				-- could be for player, or could be for one of the player's pets
				if (string_sub(recap_temp.SelectedEffect,1,1)=="1") or (string_sub(recap_temp.SelectedEffect,1,1)=="3") then
					-- player
					if recap.Self[recap_temp.s][recap_temp.SelectedEffect] then
						recap.Self[recap_temp.s][recap_temp.SelectedEffect] = nil -- keep as nil
					end
				else
					-- player's pet
					local found, selfType, selfName, selfEffect, selfIndex
					-- check first for TypePet: effectA: effectB
					found,_,selfType,selfName,selfEffect = string_find(recap_temp.SelectedEffect, "^(.)(.+): (.+: .+)")
					if not found then
						-- now get the regular TypePet: effect
						_,_,selfType,selfName,selfEffect = string_find(recap_temp.SelectedEffect, "^(.)(.+): (.+)")
					end
					selfIndex = recap_temp.s..":"..selfName
					if selfType=="2" then
						selfEffect = "1"..selfEffect
					else
						selfEffect = "3"..selfEffect
					end
					if recap.Self[selfIndex][selfEffect] then
						recap.Self[selfIndex][selfEffect] = nil -- keep as nil
					end
					local k = 0
					for j in pairs(recap.Self[selfIndex]) do
						k = k + 1
					end
					if k==0 then
						-- nothing left, clear it out entirely
						recap.Self[selfIndex] = nil -- keep as nil
					end
				end
				recap_temp.SelectedEffect = false
				Recap_SetView()
			end
		end

		-- other actions
		if recap_temp.Menu==recap_temp.Localize.DetailMenu then
			if recap_temp.OutgoingDetailsList and recap_temp.OutgoingDetailsList[1][recap_temp.Menu[id].Info] then
				recap.Opt.OutgoingPanelDetail.value = recap_temp.Menu[id].Info
				if recap_temp.Selected == recap_temp.GroupIndex then
					RecapPanel_Populate(recap_temp.GroupTotal)
				elseif recap_temp.Selected == recap_temp.NonGroupIndex then
					RecapPanel_Populate(recap_temp.NonGroupTotal)
				else
					RecapPanel_Populate(recap_temp.List[recap_temp.Selected].Name)
				end
			end
			RecapMenu:Hide()
		end
		if recap_temp.Menu==recap_temp.Localize.DetailMenu then
			if recap_temp.IncomingDetailsList and recap_temp.IncomingDetailsList[1][recap_temp.Menu[id].Info] then
				recap.Opt.IncomingPanelDetail.value = recap_temp.Menu[id].Info
				if recap_temp.Selected == recap_temp.GroupIndex then
					RecapPanel_Populate(recap_temp.GroupTotal)
				elseif recap_temp.Selected == recap_temp.NonGroupIndex then
					RecapPanel_Populate(recap_temp.NonGroupTotal)
				else
					RecapPanel_Populate(recap_temp.List[recap_temp.Selected].Name)
				end
			end
			RecapMenu:Hide()
		end
	end
end

-- offset=1 to move window so it's under pointer
function Recap_CreateMenu(menu, offset)

	local i, cy, x, y, lines, newScale

	recap_temp.Menu = menu

	if recap_temp.Menu==recap_temp.Localize.ColumnMenu or recap_temp.Menu==recap_temp.Localize.MinMenu or recap_temp.Menu==recap_temp.Localize.EffectOptMenu then
		for i in pairs(recap_temp.Menu) do
			if recap.Opt[recap_temp.Menu[i].Info] then
				recap_temp.Menu[i].Check = recap.Opt[recap_temp.Menu[i].Info].value
			end
		end
	end

	if recap_temp.Menu==recap_temp.Localize.MinMenu then
		recap_temp.Menu[1].Check = recap.Opt.Pinned.value
	end

	if recap_temp.Menu==recap_temp.Localize.DetailMenu then
		for i in pairs(recap_temp.Menu) do
			recap_temp.Menu[i].Check = recap.Opt.OutgoingPanelDetail.value==recap_temp.Menu[i].Info
		end
	end
	if recap_temp.Menu==recap_temp.Localize.DetailMenu then
		for i in pairs(recap_temp.Menu) do
			recap_temp.Menu[i].Check = recap.Opt.IncomingPanelDetail.value==recap_temp.Menu[i].Info
		end
	end

	lines = math_min(#recap_temp.Menu,recap_temp.MaxMenuLines)

	cy = 44 -- 12+32
	for i=1,lines do
		_G["RecapMenu"..i.."_Text"]:SetText(recap_temp.Menu[i].Text)
		RecapMenu_SetCheck(i,recap_temp.Menu[i].Check)
		_G["RecapMenu"..i]:Show()
		cy = cy + 14
	end
	for i=(lines+1),recap_temp.MaxMenuLines do
		_G["RecapMenu"..i]:Hide()
	end

	RecapMenu:SetHeight(cy)
	RecapDropSubFrame:SetHeight(cy-32)
	RecapMenu:ClearAllPoints()

	x = GetCursorPosition("UIParent")
	newScale = Recap_Div2(recap.Opt.SetScale.value,100)
	x = x / UIParent:GetScale() / newScale
	if Recap_TooltipAndMenuAnchor() == "ANCHOR_LEFT" then
		if recap.Opt.GrowUpwards.value and not offset then
			y = this:GetBottom()
			RecapMenu:SetPoint("BOTTOMRIGHT","UIParent","BOTTOMLEFT",(x+20)/newScale,(y-4)/newScale)
		else
			y = this:GetTop()
			RecapMenu:SetPoint("TOPRIGHT","UIParent","BOTTOMLEFT",(x+20)/newScale,(y+(offset and 16 or 4))/newScale)
		end
	else
		if recap.Opt.GrowUpwards.value and not offset then
			y = this:GetBottom()
			RecapMenu:SetPoint("BOTTOMLEFT","UIParent","BOTTOMLEFT",(x-20)/newScale,(y-4)/newScale)
		else
			y = this:GetTop()
			RecapMenu:SetPoint("TOPLEFT","UIParent","BOTTOMLEFT",(x-20)/newScale,(y+(offset and 16 or 4))/newScale)
		end
	end

	RecapMenu:Show()

end

function RecapMenu_OnEnter()

	-- lock OnEnter-OnLeave events
	if recap_temp.OnEnterOnLeave == true then return end
	recap_temp.OnEnterOnLeave = true

	id = this:GetID()
	if recap_temp.Menu[id] and recap_temp.Menu[id].Info then
		if recap_temp.Menu==recap_temp.Localize.AddLockMenu or recap_temp.Menu==recap_temp.Localize.AddUnlockMenu or recap_temp.Menu==recap_temp.Localize.DropLockMenu or recap_temp.Menu==recap_temp.Localize.DropUnlockMenu then
			if recap_temp.Selected ~= 0 then
				-- TODO: cool, the tooltip shows the appended GUID, I'm gonna leave it there for a while since I might find it useful and it is relatively obscure
				Recap_Tooltip(recap_temp.Menu[id].Info, recap_temp.List[recap_temp.Selected].Name)
			end
		elseif recap_temp.Menu==recap_temp.Localize.EffectMenu and recap_temp.SelectedEffect then
			Recap_Tooltip(recap_temp.Menu[id].Info, string_sub(recap_temp.SelectedEffect,2))
		else
			Recap_Tooltip(recap_temp.Menu[id].Info)
		end
	end

	-- unlock OnEnter-OnLeave events
	recap_temp.OnEnterOnLeave = false
end

function RecapEffectsHeader_OnEnter()

	-- lock OnEnter-OnLeave events
	if recap_temp.OnEnterOnLeave == true then return end
	recap_temp.OnEnterOnLeave = true

	local s

	_,_,s = string_find(this:GetName(), "RecapHeader_(.+)")
	if s then
		Recap_Tooltip("Header"..s)
	end

	-- unlock OnEnter-OnLeave events
	recap_temp.OnEnterOnLeave = false
end

function RecapSelf_OnMouseUp(frame, event, ...)

	recap_temp.SelectedEffect = false
	Recap_OnMouseUp(frame, event, ...)
end

function RecapEffectsHeader_OnMouseUp(frame, button)

	if (button == "RightButton") and not IsShiftKeyDown() then
		Recap_CreateMenu(recap_temp.Localize.EffectOptMenu, nil)
	end
end

function RecapEffectsHeader_OnClick(frame, button, down)

	local i, lineno
	local alltext, text = ""
	local header = string_gsub(this:GetName(),"RecapHeader_","")
	local print_chat = SendChatMessage
	local chatchan, chatnum
	local maxLines = recap.Opt.MaxRank.value

	-- new code to support sorting effects on a per column basis
	if not IsShiftKeyDown() then
		if recap.Opt.ESortBy.value==string_gsub(header,"$","") then
			recap.Opt.ESortDir.value = not recap.Opt.ESortDir.value
		else
			recap.Opt.ESortBy.value = string_gsub(header,"$","")
			if (header=="EName") or (header=="EElement") then
				recap.Opt.ESortDir.value = true
			else
				recap.Opt.ESortDir.value = false
			end
		end
		Recap_SortSelfList()
		RecapScrollBar_Update()

	elseif IsShiftKeyDown() and recap_temp.SelfListSize>1 then

		recap.Opt.ESortBy.value = header

		-- only report for columns other than EName
		if recap.Opt.ESortBy.value~="EName" then

			if (header=="EName") or (header=="EElement") then
				recap.Opt.ESortDir.value = true
			else
				recap.Opt.ESortDir.value = false
			end
			Recap_SortSelfList()
			RecapScrollBar_Update()

			chatchan, chatnum = Recap_GetChannelInfo(nil, nil)
			if chatchan=="Self" then
				print_chat = Recap_Print
			end

			-- if the focus is on a WIM (WoW Instant Messenger) edit box, post there
			if WIM_EditBoxInFocus then
				print_chat = Recap_WIM_Print
			end

			-- If the Clip box on the Options : Reports panel is open, post there instead of to chat or console
			if RecapClipEditBox:IsVisible() then
				print_chat = Recap_LineToClipboard
				maxLines = recap_temp.MaxRecentEventLinesClipboard
			end

			alltext = "__ Recap ("..Recap_PetsMergedText().."): "..recap_temp.Player..": "..Recap_GetTooltip("Header"..header).." __"
			lineno = 0
			local transition = 0
			for i=1, math_min(recap_temp.SelfListSize-1, maxLines) do
				if recap_temp.SelfList[i][header]~="0.0%" and recap_temp.SelfList[i][header]~="--" and tostring(recap_temp.SelfList[i][header])~="0" then
					local effectType = string_sub(recap_temp.SelfList[i].EName,1,1)
					print_chat(alltext, chatchan, nil, chatnum)
					if (transition==0) and ((effectType=="1") or (effectType=="2")) then
						-- remember if we saw damage
						transition = 1
					end
					if (transition==1) and ((effectType=="3") or (effectType=="4")) then
						-- extra line between damage and healing
						print_chat("+", chatchan, nil, chatnum)
						transition = 2
					end
					text = string_sub(recap_temp.SelfList[i].EName,2)..(((effectType=="3") or (effectType=="4")) and "+" or "")..": "..recap_temp.SelfList[i][header]..(header=="ETotal" and (" ("..recap_temp.SelfList[i].ETotalP..")") or "")
					lineno = lineno + 1
					text = tostring(lineno)..". "..text
					print_chat(text, chatchan, nil, chatnum)
				end
			end
		end

	else
		DEFAULT_CHAT_FRAME:AddMessage(recap_temp.Localize.RankUsage)
	end
end


function RecapSelf_OnClick(frame, button, down)

	local id = this:GetID()
	local index = id + FauxScrollFrame_GetOffset(RecapScrollBar)
	local linkformat = recap_temp.Localize.OutgoingDamageDetailLink
	local text = ""

	if index<recap_temp.SelfListSize then

		-- detect double-click
		local isDoubleClick = false
		local thisEffect = recap_temp.SelfList[index].EName
		local thisClickTime = GetTime()
		if thisEffect == recap_temp.SelfPriorEffect then
			-- another click on the same Effect
			if (thisClickTime - recap_temp.SelfPriorClickTime) < 0.3 then
				-- two clicks on the same Effect within less than 0.3 seconds, call it a double-click
				isDoubleClick = true
			end
		end
		recap_temp.SelfPriorEffect = thisEffect
		recap_temp.SelfPriorClickTime = thisClickTime

		local effectType = string_sub(recap_temp.SelfList[index].EName,1,1)

		if IsShiftKeyDown() and not isDoubleClick then
			if (effectType=="3") or (effectType=="4") then
				linkformat = recap_temp.Localize.OutgoingHealDetailLink
			end
			text = string_format(linkformat,
								 "("..Recap_PetsMergedText()..")",
								 recap_temp.Player,
								 string_sub(recap_temp.SelfList[index].EName,2),
								 (recap_temp.SelfList[index].EElement or "?"),
								 recap_temp.SelfList[index].ETotal,
								 recap_temp.SelfList[index].ETotalP,
								 Recap_StripGUIDsFromCombatant(recap_temp.PlayerGUID))..", "..RECAP_MAX_HIT..": "..recap_temp.SelfList[index].EMaxAll..((recap_temp.SelfList[index].ECritsP~="--") and (", "..RECAP_CRIT_RATE..": "..recap_temp.SelfList[index].ECritsP) or "")
			Recap_InsertChat(text," ")

		elseif (button == "LeftButton") and not IsShiftKeyDown() and isDoubleClick then
			local sourceName, effectName, found, effectFirstPart, effectSecondPart, simpleEffect
			sourceName = recap_temp.PlayerGUID
			effectName = string_sub(recap_temp.SelfList[index].EName,2)
			if (effectType == "2") or (effectType == "4") then
				-- "pet: effect" or "pet: effectFirstPart: effectSecondPart"
				found, _, _, effectFirstPart, effectSecondPart = string_find(effectName, "^(.+): (.+): (.+)$")
				if found then
					-- "pet: effectFirstPart: effectSecondPart"
					effectName = effectFirstPart..": "..effectSecondPart
				else
					-- "pet: effect"
					found, _, _, simpleEffect = string_find(effectName, "^(.+): (.+)$")
					if found then
						-- "pet: effect"
						effectName = simpleEffect
					else
						-- shouldn't get here
					end
				end
			else
				-- "effect" or "effectFirstPart: effectSecondPart"
				-- effectName should already be correct
			end
			RecapRecent_PopulateByEffect(true, sourceName, effectName) -- from Self always selected Outgoing
			RecapRecent:Show()

		elseif (button == "RightButton") and not IsShiftKeyDown() and not isDoubleClick then
			this:LockHighlight()
			recap_temp.SelectedEffect = recap_temp.SelfList[index].EName
			Recap_CreateMenu(recap_temp.Localize.EffectMenu, 1)
		end
	end
end

Recap_lua_411 = true
