--[[
ReadySpells
Written by Aldmehr

]]--

ReadySpells = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0", "AceDebug-2.0")
local parser = ParserLib:GetInstance("1.1")
local waterfall = AceLibrary:HasInstance("Waterfall-1.0") and AceLibrary("Waterfall-1.0") or nil
local BS = AceLibrary("Babble-Spell-2.2")


local displaySlots = {}
local mouseoverSlots = {}

----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
--configs : class init
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------

function ReadySpells:DruidInit()
	if self.db.profile.classes[self.playerclass].watchSpells == nil then
		self.db.profile.classes[self.playerclass].watchSpells = {
			{BS["Mangle (Bear)"], BS["Prowl"], BS["Pounce"], BS["Swiftmend"], BS["Innervate"]},
			{BS["Bash"], BS["Lacerate"], BS["Mangle (Cat)"], BS["Regrowth"], BS["Moonfire"]},
			{BS["Maul"], BS["Lifebloom"], BS["Rake"], BS["Insect Swarm"]}, 
			{BS["Growl"], BS["Feral Charge"], BS["Maim"], BS["Rejuvenation"], BS["Faerie Fire"]}, 
			{BS["Demoralizing Roar"], BS["Faerie Fire (Feral)"], BS["Barkskin"]},
			{BS["War Stomp"], BS["Nature's Grasp"], BS["Cower"]},
			{BS["Nature's Swiftness"]},
		}
	end
	if self.db.profile.classes[self.playerclass].buffStacks == nil then
		self.db.profile.classes[self.playerclass].buffStacks = {
			[BS["Lifebloom"]] = true,
		}
	end
	if self.db.profile.classes[self.playerclass].debuffStacks == nil then
		self.db.profile.classes[self.playerclass].debuffStacks = {
			[BS["Lacerate"]] = true,
		}
	end
	if self.db.profile.classes[self.playerclass].manaChecks == nil then
		self.db.profile.classes[self.playerclass].manaChecks = {
			[BS["Maul"]] = 50,
			[BS["Demoralizing Roar"]] = 30,
		}
	end
	if self.db.profile.classes[self.playerclass].swingActivations == nil then
		self.db.profile.classes[self.playerclass].swingActivations = {
			[BS["Maul"]] = true,
		}
	end
end

function ReadySpells:HunterInit()
	if self.db.profile.classes[self.playerclass].watchSpells == nil then
		self.db.profile.classes[self.playerclass].watchSpells = {
			{BS["Concussive Shot"], BS["Raptor Strike"]},
			{BS["Serpent Sting"], BS["Scare Beast"]},
			{BS["Arcane Shot"], BS["Wing Clip"]},
			{BS["Multi-Shot"], BS["Disengage"]},
			{BS["Aimed Shot"], BS["Counterattack"], BS["Mongoose Bite"]},
			{BS["Silencing Shot"], BS["Arcane Torrent"], BS["Kill Command"]},
		}
	end
	if self.db.profile.classes[self.playerclass].swingActivations == nil then
		self.db.profile.classes[self.playerclass].swingActivations = {
			[BS["Raptor Strike"]] = true,
		}
	end
end

function ReadySpells:MageInit()
	if self.db.profile.classes[self.playerclass].watchSpells == nil then
		self.db.profile.classes[self.playerclass].watchSpells = {
			{BS["Fire Blast"]},
			{BS["Frost Nova"]},
			{BS["Blink"]},
			{BS["Counterspell"], BS["Arcane Torrent"], BS["Arcane Power"], BS["Combustion"], BS["Ice Barrier"]},
			{BS["Slow"], BS["Dragon's Breath"], BS["Summon Water Elemental"]},
			{BS["Presence of Mind"]},
		}
	end
	--BS["Evocation"] BS["Invisibility"] BS["Cone of Cold"] BS["Blast Wave"] BS["Pyroblast"] BS["Ice Block"] BS["Cold Snap"]
	--future? "!Fire Vulnerability=Scorch"
end

function ReadySpells:PaladinInit()
	if self.db.profile.classes[self.playerclass].watchSpells == nil then
		self.db.profile.classes[self.playerclass].watchSpells = {
			{BS["Divine Favor"], BS["Divine Illumination"]},
			{BS["Arcane Torrent"], BS["Hammer of Wrath"]},
		}
	end
end

function ReadySpells:PriestInit()
	if self.db.profile.classes[self.playerclass].watchSpells == nil then
		self.db.profile.classes[self.playerclass].watchSpells = {
			{BS["Mind Flay"]},
			{BS["Vampiric Embrace"]},
			{BS["Shadow Word: Pain"]},
			{BS["Vampiric Touch"]},
			{BS["Silence"], BS["Arcane Torrent"]},
		}
	end
	
	--future?"!Shadow Vulnerablity=?"
end

function ReadySpells:RogueInit()
	if self.db.profile.classes[self.playerclass].watchSpells == nil then
		self.db.profile.classes[self.playerclass].watchSpells = {
			{BS["Stealth"], BS["Cheap Shot"]},
			{BS["Kick"], BS["Gouge"], BS["Kidney Shot"]}, 
			{BS["Hemorrhage"], BS["Deadly Throw"]},
			{BS["Riposte"], BS["Slice and Dice"]},
			{BS["Feint"]}, 
			{BS["Arcane Torrent"]},
		}
	end
end

function ReadySpells:ShamanInit()
	if self.db.profile.classes[self.playerclass].watchSpells == nil then
		self.db.profile.classes[self.playerclass].watchSpells = {
			{BS["Earth Shock"],BS["Flame Shock"],BS["Frost Shock"]},
			{BS["Stormstrike"], BS["Chain Lightning"], BS["Lightning Bolt"]},
			{BS["Lightning Shield"]},
			{BS["Nature's Swiftness"]},
		}
	end
end

function ReadySpells:WarlockInit()
	if self.db.profile.classes[self.playerclass].watchSpells == nil then
		self.db.profile.classes[self.playerclass].watchSpells = {
			{BS["Curse of Agony"]},
			{BS["Corruption"]},
			{BS["Unstable Affliction"], BS["Conflagrate"], BS["Immolate"]},
			{BS["Siphon Life"]},
			{BS["Howl of Terror"], BS["Fear"]},
			{BS["Shadowburn"]},
			{BS["Arcane Torrent"]},
		}
	end
	--future?{"!Curses=Curse of Agony"},
end

function ReadySpells:WarriorInit()
	if self.db.profile.classes[self.playerclass].watchSpells == nil then
		self.db.profile.classes[self.playerclass].watchSpells = {
			{BS["Shield Block"], BS["Sweeping Strikes"], BS["Whirlwind"], BS["Thunder Clap"], BS["Demoralizing Shout"]},
			{BS["Victory Rush"], BS["Overpower"], BS["Revenge"], BS["Execute"], BS["Shield Slam"], BS["Mortal Strike"], BS["Bloodthirst"]},
			{BS["Spell Reflection"], BS["Shield Bash"], BS["Pummel"], BS["Sunder Armor"], BS["Rend"]},
			{BS["Heroic Strike"]},
			{BS["Charge"], BS["Intervene"], BS["Intercept"], BS["Mocking Blow"], BS["Taunt"]},
			{BS["Commanding Shout"], BS["Battle Shout"]},
			{BS["Concussion Blow"], BS["War Stomp"]},
		}
		--BS["Hamstring"] BS["Disarm"] BS["Intimidating Shout"] BS["Last Stand"] BS["Berserker Rage"]
	end

	if self.db.profile.classes[self.playerclass].debuffStacks == nil then
		self.db.profile.classes[self.playerclass].debuffStacks = {
			[BS["Sunder Armor"]] = true,
		}
	end
	if self.db.profile.classes[self.playerclass].manaChecks == nil then
		self.db.profile.classes[self.playerclass].manaChecks = {
			[BS["Cleave"]] = 50,
			[BS["Heroic Strike"]] = 50,
			[BS["Demoralizing Shout"]] = 30,
			[BS["Thunder Clap"]] = 30,
		}
	end
	if self.db.profile.classes[self.playerclass].swingActivations == nil then
		self.db.profile.classes[self.playerclass].swingActivations = {
			[BS["Heroic Strike"]] = true,
			[BS["Cleave"]] = true,
		}
	end
end


----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
--configs: CheckSpecialCases
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
--any de/buffs that you want to see a countdown on must call one of the ...buffDown functions and return this value if == -1.

--returns 1xx failCodes 
function ReadySpells:CheckSpecialCasesNoRange(unit, spellName, spellId)
	--must special case all AE debuffs or they'll always show as ready in combat, regardless of range and help/harm target.
	--all AE debuffs that should show up on mouseover have to be special cased or they won't show.
	--self buffs should return 101 if unit is mouseover
	if self.playerclass == "DRUID" then
		if spellName == BS["Demoralizing Roar"]	then
			failCode = self:TestInCombat()
			if failCode ~= 0 then return failCode end
			failCode = self:TestAEDebuffDown(unit, spellName, true)
			if failCode ~= 0 then return failCode end
			failCode = self:TestAEDebuffDown(unit, BS["Demoralizing Shout"], true)
			if failCode ~= 0 then return failCode end
			return self:TestUnitBuffOrDebuffDown(unit, BS["Curse of Weakness"], true, true)
		elseif spellName == BS["Prowl"] then
			if unit == "mouseover" then return 101 end
			return 0
		end
	elseif self.playerclass == "HUNTER" then
	elseif self.playerclass == "MAGE" then
		if spellName == BS["Frost Nova"] or spellName == BS["Arcane Explosion"] or spellName == BS["Blast Wave"] then
			failCode = self:TestInCombat()
			if failCode ~= 0 then return failCode end
			return self:TestAEDebuffDown(unit, spellName, false)
		elseif spellName == BS["Ice Block"] then
			if unit == "mouseover" then return 101 end
			failCode = self:TestInCombat()
			if failCode ~= 0 then return failCode end
			--not sure if Hypothermia is a buff or debuff, so check them both for now.
			failCode = self:TestUnitBuffOrDebuffDown("player", BS["Hypothermia"], false, false)
			if failCode ~= 0 then return failCode end
			failCode = self:TestUnitBuffOrDebuffDown("player", BS["Hypothermia"], true, false)
			return failCode
		end
	elseif self.playerclass == "PALADIN" then
	elseif self.playerclass == "PRIEST" then
	elseif self.playerclass == "ROGUE" then
		if spellName == BS["Stealth"] then
			if unit == "mouseover" then return 101 end
			return 0
		end
	elseif self.playerclass == "SHAMAN" then
	elseif self.playerclass == "WARLOCK" then
		if spellName == BS["Hellfire"] then
			failCode = self:TestInCombat()
			if failCode ~= 0 then return failCode end
			return self:TestAEDebuffDown(unit, spellName, false)
		elseif spellName == BS["Howl of Terror"] then
			failCode = self:TestCanFear(unit)
			if failCode ~= 0 then return failCode end
			failCode = self:TestInCombat()
			if failCode ~= 0 then return failCode end
			return self:TestAEDebuffDown(unit, spellName, false)
		end
	elseif self.playerclass == "WARRIOR" then
		if spellName == BS["Commanding Shout"] then
			if unit == "mouseover" then return 101 end
			failCode = self:TestUnitBuffOrDebuffDown("player", spellName, false, true)
			if failCode ~= 0 then return failCode end
			return self:TestUnitBuffOrDebuffDown("player", BS["Battle Shout"], false, true)
		elseif spellName == BS["Battle Shout"] then
			if unit == "mouseover" then return 101 end
			failCode = self:TestUnitBuffOrDebuffDown("player", spellName, false, true)
			if failCode ~= 0 then return failCode end
			return self:TestUnitBuffOrDebuffDown("player", BS["Commanding Shout"], false, true)
		elseif spellName == BS["Demoralizing Shout"] then
			failCode = self:TestInCombat()
			if failCode ~= 0 then return failCode end
			failCode = self:TestAEDebuffDown(unit, spellName, true)
			if failCode ~= 0 then return failCode end
			failCode = self:TestAEDebuffDown(unit, BS["Demoralizing Roar"], true)
			if failCode ~= 0 then return failCode end
			return self:TestUnitBuffOrDebuffDown(unit, BS["Curse of Weakness"], true, true)
		elseif spellName == BS["Thunder Clap"] then
			failCode = self:TestInCombat()
			if failCode ~= 0 then return failCode end
			return self:TestAEDebuffDown(unit, spellName, true)
		elseif spellName == BS["Spell Reflection"] then
			return self:TestCanReflectSpell(unit, spellName)
		end
	end

	if spellName == BS["War Stomp"] then
		failCode = self:TestInCombat()
		if failCode ~= 0 then return failCode end
		return self:TestAEDebuffDown(unit, spellName, true)
	elseif spellName == BS["Arcane Torrent"] then
		failCode = self:TestAEDebuffDown(unit, spellName, false)
		if failCode ~= 0 then return failCode end
		failCode = self:TestCanInterruptSpell(unit)
		return failCode
	end

	--general cases
	if unit == "mouseover" then return 101 end -- this means all AE debuffs that should show up on mouseover have to be special cased.
	failCode = self:TestUnitBuffOrDebuffDown("player", spellName, false, true)
	if failCode ~= 0 then return failCode end
	return self:TestInCombat()
end


--returns 2xx failCodes
function ReadySpells:CheckSpecialCasesValidTarget(unit, spellName, spellId)
	--default to show
	local failCode = 0
	if self.playerclass == "DRUID" then
		if spellName == BS["Cower"] then
			return self:TestGroupPVETarget(unit)
		elseif spellName == BS["Growl"] then
			return self:TestTauntTarget(unit)
		elseif spellName == BS["Maim"] then
			failCode = self:TestCanInterruptSpell(unit) 
			if failCode == 0 and GetComboPoints() > 0 then return failCode end
			local failCode2 =  self:TestUnitBuffOrDebuffDown(unit, spellName, true, false)
			if failCode2 == -1 then 
				return failCode2
			else
				return failCode
			end
		elseif spellName == BS["Bash"] then
			failCode = self:TestCanInterruptSpell(unit) 
			if failCode == 0 then return failCode end --if casting, debuff is down already... no need to check for it.
			local failCode2 =  self:TestUnitBuffOrDebuffDown(unit, spellName, true, false)
			if failCode2 == -1 then 
				return failCode2
			else
				return failCode
			end
		elseif spellName == BS["Faerie Fire (Feral)"] then
			--failCode = self:TestDamageTypeWorks(unit, "Nature")
			--if failCode ~= 0 then return failCode end
			failCode = self:TestUnitBuffOrDebuffDown(unit, spellName, true, true)
			if failCode ~= 0 then return failCode end
			return self:TestUnitBuffOrDebuffDown(unit, BS["Faerie Fire"], true, true)
		elseif spellName == BS["Faerie Fire"] then
			--failCode = self:TestDamageTypeWorks(unit, "Nature")
			--if failCode ~= 0 then return failCode end
			failCode = self:TestUnitBuffOrDebuffDown(unit, spellName, true, true)
			if failCode ~= 0 then return failCode end
			return self:TestUnitBuffOrDebuffDown(unit, BS["Faerie Fire (Feral)"], true, true)
		elseif spellName == BS["Mangle (Cat)"] then
			failCode = self:TestUnitBuffOrDebuffDown(unit, spellName, true, true)
			if failCode ~= 0 then return failCode end
			return self:TestUnitBuffOrDebuffDown(unit, BS["Mangle (Bear)"], true, true)
		elseif spellName == BS["Mangle (Bear)"] then
			return 0 --show even if its up
		elseif spellName == BS["Rip"] then
			failCode = self:TestCanBleed(unit)
			if failCode ~= 0 then return failCode end
			failCode = self:TestUnitBuffOrDebuffDown(unit, spellName, true, false)
			if failCode ~= 0 then return failCode end
			return self:TestComboPoints()
		elseif spellName == BS["Ferocious Bite"] then
			return self:TestComboPoints()
		elseif spellName == BS["Rake"] then
			failCode = self:TestCanBleed(unit)
			if failCode ~= 0 then return failCode end
			return self:TestUnitBuffOrDebuffDown(unit, spellName, true, false)
		elseif spellName == BS["Innervate"] then
			if UnitPowerType(unit) == 0 then --have mana
				return self:TestUnitBuffOrDebuffDown(unit, spellName, false, true)
			else
				return 202
			end
		elseif spellName == BS["Insect Swarm"] or spellName == BS["Wrath"] or spellName == BS["Entangling Roots"] then
			failCode = self:TestDamageTypeWorks(unit, "Nature")
			if failCode ~= 0 then return failCode end
			return self:TestUnitBuffOrDebuffDown(unit, spellName, true, false)
		end
	elseif self.playerclass == "HUNTER" then
		if spellName == BS["Raptor Strike"] then
			if CheckInteractDistance(unit, 2)==1 or self.swingActivated then
			else
				return 203
			end
		elseif spellName == BS["Silencing Shot"] then
			failCode = self:TestCanInterruptSpell(unit) 
			if failCode == 0 then return failCode end --if casting, debuff is down already... no need to check for it.
			--What is the silencing shot debuff called?
			local failCode2 =  self:TestUnitBuffOrDebuffDown(unit, spellName, true, false)
			if failCode2 == -1 then 
				return failCode2
			else
				return failCode
			end
		elseif spellName == BS["Scorpid Sting"] or spellName == BS["Serpent Sting"] or spellName == BS["Viper Sting"] or spellName == BS["Wyvern Sting"] then
			failCode = self:TestDamageTypeWorks(unit, "Nature")
			if failCode ~= 0 then return failCode end
			return self:TestUnitBuffOrDebuffDown(unit, spellName, true, false)
		end
	elseif self.playerclass == "MAGE" then
		if spellName == BS["Counterspell"] then
			failCode = self:TestCanInterruptSpell(unit) 
			if failCode == 0 then return failCode end
			--What is the improved counterspell debuff called?  
			local failCode2 =  self:TestUnitBuffOrDebuffDown(unit, spellName.." - Silenced", true, false)
			if failCode2 == -1 then 
				return failCode2
			else
				return failCode
			end
		end
	elseif self.playerclass == "PALADIN" then
	elseif self.playerclass == "PRIEST" then
		if spellName == BS["Silence"] then
			failCode = self:TestCanInterruptSpell(unit) 
			if failCode == 0 then return failCode end
			local failCode2 =  self:TestUnitBuffOrDebuffDown(unit, spellName, true, false)
			if failCode2 == -1 then 
				return failCode2
			else
				return failCode
			end
		end
	elseif self.playerclass == "ROGUE" then
		if spellName == BS["Feint"] then
			return self:TestGroupPVETarget(unit)
		elseif spellName == BS["Kick"] then
			failCode = self:TestCanInterruptSpell(unit) 
			if failCode == 0 then return failCode end
			local failCode2 = self:TestUnitBuffOrDebuffDown(unit, spellName.." - Silenced", true, false)
			if failCode2 == -1 then 
				return failCode2
			else
				return failCode
			end
		elseif spellName == BS["Kidney Shot"] then
			failCode = self:TestCanInterruptSpell(unit) 
			if failCode == 0 and GetComboPoints() > 0 then return failCode end
			local failCode2 = self:TestUnitBuffOrDebuffDown(unit, spellName, true, false)
			if failCode2 == -1 then 
				return failCode2
			else
				return failCode
			end
		elseif spellName == BS["Gouge"] then
			failCode = self:TestCanInterruptSpell(unit) 
			if failCode == 0 then return failCode end
			local failCode2 = self:TestUnitBuffOrDebuffDown(unit, spellName, true, false)
			if failCode2 == -1 then 
				return failCode2
			else
				return failCode
			end
		elseif spellName == BS["Slice and Dice"] then
			return self:TestUnitBuffOrDebuffDown("player", spellName, false, false)
		end
	elseif self.playerclass == "SHAMAN" then
		if  spellName == BS["Earth Shock"] then
			failCode = self:TestCanInterruptSpell(unit)
			return failCode
		end
	elseif self.playerclass == "WARLOCK" then
		--[[
			Curse of Agony
			Curse of Doom
			Curse of Exhaustion
			Curse of Recklessness
			Curse of Shadow
			Curse of Tongues
			Curse of Weakness
			Curse of the Elements
			]]--
		if spellName == BS["Conflagrate"] then
			failCode = self:TestUnitBuffOrDebuffDown(unit, BS["Immolate"], true, false) --update the caches for later
			if self.dLeftCache > 0.1 then
				return 0
			else
				return 204
			end
		elseif spellName == BS["Incinerate"] then
			--check for backlash?
			failCode = self:TestUnitBuffOrDebuffDown(unit, BS["Immolate"], true, false) --update the caches for later
			if self.dLeftCache > 0.1 then
				return 0
			else
				return 205
			end
		elseif spellName == BS["Curse of Weakness"] then
			failCode = self:TestUnitBuffOrDebuffDown(unit, spellName, true, true)
			if failCode ~= 0 then return failCode end
			failCode = self:TestUnitBuffOrDebuffDown(unit, BS["Demoralizing Roar"], true, true)
			if failCode ~= 0 then return failCode end
			return self:TestUnitBuffOrDebuffDown(unit, BS["Demoralizing Shout"], true, true)
		elseif spellName == BS["Fear"] or spellName == BS["Death Coil"] then
			failCode = self:TestCanFear(unit)
			if failCode ~= 0 then return failCode end
			return self:TestUnitBuffOrDebuffDown(unit, BS["Demoralizing Roar"], true, false)
		end
	elseif self.playerclass == "WARRIOR" then
		if spellName == BS["Pummel"] then
			failCode = self:TestCanInterruptSpell(unit) 
			return failCode --pummel does not leave a debuff.
		elseif spellName == BS["Shield Bash"] then
			failCode = self:TestCanInterruptSpell(unit) 
			if failCode == 0 then return failCode end
			--what is the name of the improved bash debuff?
			local failCode2 =  self:TestUnitBuffOrDebuffDown(unit, spellName.." - Silenced", true, false)
			if failCode2 == -1 then 
				return failCode2
			else
				return failCode
			end
		elseif spellName == BS["Mocking Blow"] or spellName == BS["Taunt"] then
			return self:TestTauntTarget(unit)
		--[[ --removed with multiple profiles, can have a pvp profile with hamstring for the player test
		elseif spellName == BS["Hamstring"] then
			failCode = self:TestUnitBuffOrDebuffDown(unit, spellName, true, ?)
			if failCode ~= 0 then return failCode end
			return self:TestTargetIsPlayer(unit)
		]]--
		elseif spellName == BS["Rend"] then
			failCode = self:TestCanBleed(unit)
			if failCode ~= 0 then return failCode end
			return self:TestUnitBuffOrDebuffDown(unit, spellName, true, false)
		elseif spellName == BS["Disarm"] then
			local failCode2 =  self:TestUnitBuffOrDebuffDown(unit, spellName, true, false)
			if failCode2 == -1 then 
				return failCode2
			else
				return self:TestCanDisarm(unit)
			end
		--[[ --add targettarget check?
		elseif spellName == BS["Intervene"] then
		]]--
		end
	end

	if self.db.profile.classes[self.playerclass].debuffStacks ~= nil and self.db.profile.classes[self.playerclass].debuffStacks[spellName] == true then
		--last arg is true since all players debuff stacks combine into one per spell.
		failCode = self:TestUnitBuffOrDebuffDown(unit, spellName, true, true) --update the caches for later
		if failCode == -1 then return -2 end
		if self.dLeftCache > 0 then --only care ours is up and was first.  this is fine for sunder,lacerate but might need to be updated if other debuff stacks are added.
			return 0
		else
			return 206
		end
		
	end

	if self.db.profile.classes[self.playerclass].buffStacks ~= nil and self.db.profile.classes[self.playerclass].buffStacks[spellName] == true then
		--last arg is false since each druid gets a different stack of lifebloom... update if there are other buff stacks.
		failCode = self:TestUnitBuffOrDebuffDown(unit, spellName, false, false) --update the caches for later
		if failCode == -1 then return -2 end
		return 0
	end

	--general case de/buff handling, don't show if already up
	failCode = self:TestUnitBuffOrDebuffDown(unit, spellName, true, false)
	if failCode ~= 0 then return failCode end
	failCode = self:TestUnitBuffOrDebuffDown(unit, spellName, false, false)
	return failCode
end


--returns 3xx failCodes
function ReadySpells:CheckSpecialCasesHelpInvalidTarget(spellName, spellId)
	-- helpful spell with harm or no target.
	if self.playerclass == "DRUID" then
		if spellName == BS["Innervate"] or spellName == BS["Swiftmend"] then
			return self:TestInCombat()
		end
	elseif self.playerclass == "HUNTER" then
	elseif self.playerclass == "MAGE" then
	elseif self.playerclass == "PALADIN" then
	elseif self.playerclass == "PRIEST" then
	elseif self.playerclass == "ROGUE" then
	elseif self.playerclass == "SHAMAN" then
	elseif self.playerclass == "WARLOCK" then
	elseif self.playerclass == "WARRIOR" then
	end

	--don't show by default
	return 301
end


--returns 4xx failCodes
function ReadySpells:CheckSpecialCasesHarmInvalidTarget(spellName, spellId)
	--harmful spell with help or no target.
	--or AE circle target spell
	if self.playerclass == "DRUID" then
		if spellName == BS["Hurricane"] then
			return self:TestInCombat()
		end
	elseif self.playerclass == "HUNTER" then
	elseif self.playerclass == "MAGE" then
	elseif self.playerclass == "PALADIN" then
	elseif self.playerclass == "PRIEST" then
	elseif self.playerclass == "ROGUE" then
	elseif self.playerclass == "SHAMAN" then
	elseif self.playerclass == "WARLOCK" then
		if spellName == BS["Shadowfury"] then
			return self:TestInCombat()
		end
	elseif self.playerclass == "WARRIOR" then
	end

	--don't show by default
	return 401
end


----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
--CheckSpecialCases tester functions
--these return 0 for true
--returns 5xx failCodes
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------


function ReadySpells:TestInCombat()
	if not InCombatLockdown() then
		return 501
	else
		return 0
	end
end

function ReadySpells:TestAEDebuffDown(unit, spellName, checkDebuff)
	--CheckInteractDistance(unit, 2) This works for checking if the range is <= 10yards, but not sure how supported it is... 
	--if checkDebuff is false, then this is mainly being used as a range check.
	if UnitExists(unit) and UnitIsVisible(unit) and not UnitIsDead(unit) and UnitCanAttack("player", unit) and CheckInteractDistance(unit, 2)==1 then
		if checkDebuff then
			return self:TestUnitBuffOrDebuffDown(unit, spellName, true, true)
		else
			return 0
		end
	else
		return 502
	end
end

function ReadySpells:TestGroupPVETarget(unit)
	if (GetNumPartyMembers() == 0 and GetNumRaidMembers() == 0) or UnitIsPlayer(unit) then
		return 503
	else
		return 0
	end
end

function ReadySpells:TestCanReflectSpell(unit, spellName)
	--if UnitCastingInfo(unit) ~= nil and UnitCanAttack("player", unit) then
	if UnitCastingInfo(unit) ~= nil and UnitCanAttack("player", unit) and IsHarmfulSpell(spellName) and UnitIsUnit(unit.."target", "player") then
		return 0
	else
		return 504
	end
end

function ReadySpells:TestCanInterruptSpell(unit)
	if UnitCastingInfo(unit) ~= nil or UnitChannelInfo(unit) ~= nil then
		return 0
	else
		return 505
	end
end

function ReadySpells:TestUnitBuffOrDebuffDown(unit, spellName, isDebuff, otherIsOK)
	local dCount, dLeft, dDur
	if isDebuff then
		dCount, dLeft, dDur = self:GetUnitDebuffStackCount(unit, spellName)
	else
		dCount, dLeft, dDur = self:GetUnitBuffStackCount(unit, spellName)
	end
	if dCount >= 0 then --its up
		self.dCountCache = dCount
		if dLeft ~= nil then --mine is up
			self.dLeftCache = dLeft
			self.dDurCache = dDur
			if (isDebuff and dLeft <= self.db.profile.classes[self.playerclass].debuffCountdown) or (not isDebuff and dLeft <= self.db.profile.classes[self.playerclass].buffCountdown) then
				return -1
			else
				return 506
			end
		else --mine is down
			if dCount > 0 then 			--stackable, up, but mine was not first.  Don't show for debuff stacks.  There is no combining buff stack in game that I know of atm.  Revisit when adding other stacks?
				self.dCountCache = 0	--not sure what happens if another player puts it up #1, I put up #2 (which does not renew the timer for player1), then #1 drops.  Does the entire stack drop or is #2 left and is my dLeft now non nil? I assume the entire stack drops.
				return 516				--also fixes a weird problem right when buff is going down or monster dies where dLeft is nil, but ours was up and first.
			else
				if otherIsOK then
					return 507
				else
					return 0
				end
			end
		end
	end
	return 0
end

function ReadySpells:TestTargetIsPlayer(unit)
	if UnitIsPlayer(unit) then
		return 0
	else
		return 508
	end
end

function ReadySpells:TestComboPoints()
	if GetComboPoints() < 4 then
		return 509
	else
		return 0
	end
end

function ReadySpells:TestSolo(unit)
	if GetNumPartyMembers() > 0 or GetNumRaidMembers() > 0 then
		return 510
	else
		return 0
	end
end

--[[
"Beast" "Demon" "Elemental" "Humanoid" "Undead"
]]--
function ReadySpells:TestCanBleed(unit)
	if UnitCreatureType(unit) == "Undead" then --or UnitCreatureType(unit) == "Elemental" then
		return 511
	else
		return 0
	end
end

function ReadySpells:TestCanDisarm(unit)
	if UnitCreatureType(unit) == "Beast" or UnitCreatureType(unit) == "Elemental" then
		return 512
	else
		return 0
	end
end

--[[
"Arcane" "Fire" "Frost" "Holy" "Nature" "Shadow"
]]--
function ReadySpells:TestDamageTypeWorks(unit, damageType)
	if UnitCreatureType(unit) == "Elemental" and damageType == "Nature" then
		return 513
	else
		return 0
	end
end

function ReadySpells:TestTauntTarget(unit)
	if UnitIsUnit(unit.."target", "player") or UnitIsPlayer(unit) or not InCombatLockdown() then
		return 514
	else
		return 0
	end
end

function ReadySpells:TestCanFear(unit)
	if UnitCreatureType(unit) == "Undead" then
		return 515
	else
		return 0
	end
end
--516

----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
--the worker functions
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------


function ReadySpells:CheckReadySpell(k, v, unit)
		local usable, nomana = IsUsableSpell(k.."()") -- add .."()" for spells like Mangle (Bear) to work 
		if not usable then
			if nomana then
				if UnitMana("player") > 0 and self.db.profile.classes[self.playerclass].showNoMana then
				else
					return 1
				end
			else
				--for these spells requiring combo points or stealth, allow them to show for countdowns even if those conditions not met.
				--deadly countdown won't show if too close...
				--pounce won't work since it doesn't leave a pounce stun debuff up  or k == BS["Pounce"]
				if (k == BS["Maim"] and UnitPowerType("player") == 3) or k == BS["Kidney Shot"] or k == BS["Deadly Throw"] or k == BS["Cheap Shot"] then
					local failCode = self:TestUnitBuffOrDebuffDown(unit, k, true, false)
					if failCode ~= -1 then
						return 2
					end
				else
					return 2
				end
			end
		end

		--fix for 2.3.  because a spell will autoUnshift you, it now passes the IsUsableSpell test above.
		if (self.playerclass == "DRUID") then
			if (UnitPowerType("player") == 1 
				and k ~= BS["Bash"] 
				and k ~= BS["Growl"] 
				and k ~= BS["Lacerate"] 
				and k ~= BS["Mangle (Bear)"] 
				and k ~= BS["Feral Charge"] 
				and k ~= BS["Maul"] 
				and k ~= BS["Swipe"] 
				and k ~= BS["Demoralizing Roar"] 
				and k ~= BS["Challenging Roar"] 
				and k ~= BS["Enrage"] 
				and k ~= BS["Faerie Fire (Feral)"] 
				and k ~= BS["Frenzied Regeneration"] 
			) then
				return 21
			elseif (UnitPowerType("player") == 3 
				and k ~= BS["Mangle (Cat)"] 
				and k ~= BS["Faerie Fire (Feral)"]
				and k ~= BS["Cower"] 
				and k ~= BS["Maim"] 
				and k ~= BS["Ferocious Bite"] 
				and k ~= BS["Shred"] 
				and k ~= BS["Pounce"] 
				and k ~= BS["Ravage"] 
				and k ~= BS["Prowl"] 
				and k ~= BS["Rake"] 
				and k ~= BS["Rip"] 
				and k ~= BS["Tiger's Fury"] 
				and k ~= BS["Claw"] 
				and k ~= BS["Dash"] 
			) then
				return 22
			end
		end
		
		if self.db.profile.classes[self.playerclass].manaChecks ~= nil then
			local manaCheck = self.db.profile.classes[self.playerclass].manaChecks[k]
			if manaCheck ~= nil then
				local swingActivations = self.db.profile.classes[self.playerclass].swingActivations
				if UnitMana("player") < manaCheck and not (self.swingActivated and swingActivations ~= nil and swingActivations[k] == true) then
					if self.db.profile.classes[self.playerclass].showNoMana then
						if nomana == 1 then
							nomana = 2 --not enough mana and not enough to show
						else
							nomana = 3 --have enough mana, but not enough to show
						end
					else
						return 3
					end
				end
			end
		end

		if not SpellHasRange(k.."()") then
			return self:CheckSpecialCasesNoRange(unit, k, v.id), nomana
		end

		if UnitExists(unit) and UnitIsVisible(unit) then
			local result = IsSpellInRange(v.id, BOOKTYPE_SPELL, unit)
			if result == 1 then --in range
				return self:CheckSpecialCasesValidTarget(unit, k, v.id), nomana
			elseif result == 0 then --not in range
				return 4
			end
		end

		--spell can't be cast on unit or is an AE circle target spell
		local result = IsSpellInRange(v.id, BOOKTYPE_SPELL, "player") --how else to check if this is a helpful spell?
		if result == 1 then
			return self:CheckSpecialCasesHelpInvalidTarget(k, v.id), nomana --"player" is always in range, so this is a helpful spell with a harmful target or no target
		elseif result == 0 then
			self:Debug("ReadySpells error, failcode = "..failCode.." "..k)
			return 5 --"player" is always in range, so this should never happen
		else
			return self:CheckSpecialCasesHarmInvalidTarget(k, v.id), nomana --harmful spell on help or no target is invalid, AE circle target spells are here also, regardless of target
		end
end


function ReadySpells:UpdateDisplaySlots()
	if self.checkGroup == 1 then -- group changed?
		local cur = self:GetProfile()
		local group = self:GetGroup()
		if cur ~= group and (cur == "Default" or cur == "Group" or cur == "Raid") then
			self:Print("AutoSwitch from "..cur.." to "..group..".")
			self:SetProfile(group)
		end
		self.checkGroup = 0
	end
	if self.needCreate == 1 then -- spells changed or profile changed
		self:CreateDisplaySlots()
		self.needCreate = 0
		self:SetupDisplaySlots()
	end

	local gcd
	if UnitPowerType("player") == 3 then
		gcd = 1.0 --energy
	else
		gcd = 1.5 --mana or rage
	end

	self.lastTime = GetTime()	
	self:UpdateDisplaySlotsForUnit("target", gcd, displaySlots)
	
	if self.db.profile.mouseover then
		if UnitExists("mouseover") and UnitIsVisible("mouseover") and not UnitIsUnit("mouseover", "target") and not UnitIsDead("mouseover") then
			self:UpdateDisplaySlotsForUnit("mouseover", gcd, mouseoverSlots)
		else
			self.mframe:Hide()
			self.mframe.anchoredTo = -1
		end
	end

end


function ReadySpells:UpdateDisplaySlotsForUnit(unit, gcd, currentSlots)
	local first = 0
	local last = 0

	for i = 1, #displaySlots do
		local show = 0 --0==nothing, 3==swing,  4==countdown, 5==gcd_cooldown, 10 ==ready 2==cooldown_countdown and countdown 1==nomana
		local showIcon
		local showSpell
		local showdLeft
		local showdCount
		local showResult
		if self.db.profile.classes[self.playerclass].onlyShowInCombat and not InCombatLockdown() then
			--show nothing
		else
		  for j = 1, #displaySlots[i].spells do
			local spellName = displaySlots[i].spells[j].name
			self.dLeftCache = 0
			self.dCountCache = 0
			self.dDurCache = 0
			local result, nomana = self:CheckReadySpell(spellName, displaySlots[i].spells[j], unit)
			if result <= 0 then
				local start, duration, enable = GetSpellCooldown(displaySlots[i].spells[j].id, BOOKTYPE_SPELL)
				local cooldownLeft = duration - (self.lastTime - start)
				if nomana then
					if show <= 0 and ((nomana == 1 and start == 0) or (nomana == 2 and result < 0)) then --or (nomana == -1 and result < 0)) then
						showIcon = displaySlots[i].spells[j].icon
						showSpell = spellName
						showdLeft = self.dLeftCache
						showdCount = self.dCountCache
						showResult = result
						show = 1
					elseif show <= 3 and nomana == 3 and result < 0 then
						showIcon = displaySlots[i].spells[j].icon
						showSpell = spellName
						showdLeft = self.dLeftCache
						showdCount = self.dCountCache
						showResult = result
						show = 4
					end
				elseif start == 0 then --not on cooldown, show it
					showIcon = displaySlots[i].spells[j].icon
					showSpell = spellName
					showdLeft = self.dLeftCache
					showdCount = self.dCountCache
					showResult = result
					if result == 0 or result == -2 then --stack watch takes priority over ready, with either countdown or stackcount displayed
						show = 10
						if self.swingActivated and self.db.profile.classes[self.playerclass].swingActivations ~= nil and self.db.profile.classes[self.playerclass].swingActivations[spellName] == true then
							show = 3 --already activated, show gcd cooldowns over this
						end
						if show == 10 then break end --decided which to display, stop checking
					else -- is -1
						show = 4
					end
				elseif show <= 4 and cooldownLeft <= gcd then
						showIcon = displaySlots[i].spells[j].icon
						showSpell = spellName
						showdLeft = self.dLeftCache
						showdCount = self.dCountCache
						showResult = result
						show = 5
				elseif show <= 1 and self.db.profile.classes[self.playerclass].onCooldownCountdown and result == -1 and duration > self.dDurCache then 
						showIcon = displaySlots[i].spells[j].icon
						showSpell = spellName
						showdLeft = self.dLeftCache
						showdCount = self.dCountCache
						showResult = result
						show = 2
				end
			end --checkready
		  end --for spells in slot
		end --combat check
					
		if show == 0 then
			currentSlots[i].texture:Hide()
			currentSlots[i].textFrame:Hide()
		else
			if first == 0 then
				first = i
			end
			last = i
			currentSlots[i].texture:SetTexture(showIcon)
			if show == 3 then -- swing activated gray it
				if showSpell == BS["Heroic Strike"] then
					currentSlots[i].texture:SetTexture("Interface\\AddOns\\ReadySpells\\hs");
				elseif showSpell == BS["Maul"] then
					currentSlots[i].texture:SetTexture("Interface\\AddOns\\ReadySpells\\maul");
				elseif showSpell == BS["Cleave"] then
					currentSlots[i].texture:SetTexture("Interface\\AddOns\\ReadySpells\\cleave");
				elseif showSpell == BS["Raptor Strike"] then
					currentSlots[i].texture:SetTexture("Interface\\AddOns\\ReadySpells\\raptor");
				else
					currentSlots[i].texture:SetVertexColor(0.4, 0.4, 0.3, self.db.profile.alpha - 0.2)
				end
			elseif show == 5 then -- gcd_cooldown gray it
				currentSlots[i].texture:SetVertexColor(0.4, 0.4, 0.4, self.db.profile.alpha - 0.2)
			elseif show == 2 then --  cooldown countdown red it
				currentSlots[i].texture:SetVertexColor(0.7, 0.1, 0.1, self.db.profile.alpha - 0.2)
			elseif show == 10 then -- ready full color
				currentSlots[i].texture:SetVertexColor(1.0, 1.0, 1.0, self.db.profile.alpha)
			elseif show == 4 then -- falling  dim it
				currentSlots[i].texture:SetVertexColor(0.8, 0.8, 0.8, self.db.profile.alpha - 0.2)
			elseif show == 1 then -- no mana blue it
				currentSlots[i].texture:SetVertexColor(0.1, 0.1, 0.7, self.db.profile.alpha - 0.2)
			end
			currentSlots[i].texture:Show()

			if showResult < 0 then
				--[[  -- was more distracting to me than useful, have to change textFrame width if reenabled.
				if showdLeft < 1 then --show remaining countdown in tenths of seconds instead of seconds
					currentSlots[i].textFrame.text:SetFont(STANDARD_TEXT_FONT, 20, "OUTLINE")
					currentSlots[i].textFrame.text:SetText(('%.1f'):format(showdLeft))
				else
				]]--
				if showdCount > 0 then
					currentSlots[i].textFrame.text:SetFont(STANDARD_TEXT_FONT, 20, "OUTLINE")
					currentSlots[i].textFrame.text:SetText(math.floor(showdLeft)..":"..showdCount)
				else
					currentSlots[i].textFrame.text:SetFont(STANDARD_TEXT_FONT, 24, "OUTLINE")
					currentSlots[i].textFrame.text:SetText(math.floor(showdLeft))
				end
				--end
				currentSlots[i].textFrame.text:SetTextColor(1, 0, 0, self.db.profile.alpha)
				currentSlots[i].textFrame:Show()
			elseif showdCount > 0 then
				currentSlots[i].textFrame.text:SetFont(STANDARD_TEXT_FONT, 20, "OUTLINE")
				currentSlots[i].textFrame.text:SetTextColor(1, 1, 0.2, self.db.profile.alpha)
				currentSlots[i].textFrame.text:SetText(showdCount)
				currentSlots[i].textFrame:Show()
			else
				currentSlots[i].textFrame:Hide()
			end
		end
	end --for displaySlots

	if unit == "mouseover" then
		self:UpdateMouseover(first, last)
	end
end

		
function ReadySpells:UpdateMouseover(first, last)
	if first == 0 then
		self.mframe:Hide()
		self.mframe.anchoredTo = -1
	else
		local xspacing, yspacing, xspacingLeft, yspacingDown, xborder, yborder, width, height, relPoint
	
		if self.db.profile.vertical then
			yspacing = (first - 1) * 32 + (first - 1) * self.db.profile.spacing
			yspacingDown = (#displaySlots - last) * 32 + (#displaySlots - last) * self.db.profile.spacing
			yborder = yspacing - 5
			if self.db.profile.reverse then
				yborder = 0 - yborder
				relPoint = "TOP"
			else
				relPoint = "BOTTOM"
			end
			xspacing = 0
			xspacingLeft = 0
			xborder = 0
			width = 32
			height = (last - first + 1) * 32 + (last - first) * self.db.profile.spacing
		else
			xspacing = (first - 1) * 32 + (first - 1) * self.db.profile.spacing
			xspacingLeft = (#displaySlots - last) * 32 + (#displaySlots - last) * self.db.profile.spacing
			xborder = xspacing - 5
			if self.db.profile.reverse then
				xborder = 0 - xborder
				relPoint = "RIGHT"
			else
				relPoint = "LEFT"
			end
			yspacing = 0
			yspacingDown = 0
			yborder = 0
			width = (last - first + 1) * 32 + (last - first) * self.db.profile.spacing
			height = 32
		end
		
		self.border:SetWidth(width+10)
		self.border:SetHeight(height+10)
		self.border:ClearAllPoints()
		self.border:SetPoint(relPoint, self.mframe, relPoint, xborder, yborder)

		if self.db.profile.mouseoverAnchor == 0 then
			if self.mframe.anchoredTo ~= 0 or self.reanchor == 1 then
				self:AnchorToAnchor()
				self.mframe.anchoredTo = 0
				self.mframe:Show()
			end
		elseif self.db.profile.mouseoverAnchor == 2 then
			if self.mframe.anchoredTo ~= 2 or self.reanchor == 1 then
				self:AnchorToCursor(xspacing, yspacing, width, height)
				self.mframe.anchoredTo = 2
				self.mframe:Show()
			else
				local scaleUI = UIParent:GetScale()
				local x,y = GetCursorPosition()
				x = x / scaleUI
				y = y / scaleUI

				local x1, y1 = self.border:GetCenter()
				x1 = x1 * self.db.profile.scale
				y1 = y1 * self.db.profile.scale
					
				local moveit = false
				local diff = x - x1
				if diff < 0 then diff = 0 - diff end
				if diff > 30 then 
					moveit = true 
				else
					diff = y - y1
					if diff < 0 then diff = 0 - diff end
					if diff > 30 then
						moveit = true
					end
				end

				if moveit then
					self:AnchorToCursor(xspacing, yspacing, width, height)
					self.mframe.anchoredTo = 2
					self.mframe:Show()
				end
			end
		elseif self.db.profile.mouseoverAnchor == 1 then
			if self.mframe.anchoredTo ~= 1 or self.reanchor == 1 then
				if self:AnchorToTooltip(xspacing, yspacing, xspacingLeft, yspacingDown) then
					self.mframe.anchoredTo = 1
					self.mframe:Show()
				end
			end
		end
	end
	self.reanchor = 0
end


function ReadySpells:AnchorToAnchor()
	local point
	local relpoint
	local adjx = 0 --for now, hard code to show up to the right or above current ReadySpell frame.
	local adjy = 0
		
	if self.db.profile.vertical then
		adjx = 32 + 5 + self.db.profile.spacing
		if self.db.profile.reverse then
			point = "TOP"
			relPoint = "BOTTOM"
		else
			point = "BOTTOM"
			relPoint = "TOP"
		end
	else
		adjy = 32 + 5 + self.db.profile.spacing
		if self.db.profile.reverse then
			point = "RIGHT"
			relPoint = "LEFT"
		else
			point = "LEFT"
			relPoint = "RIGHT"
		end
	end

	self.mframe:ClearAllPoints()
	self.mframe:SetPoint(point, self.anchor, relPoint, adjx, adjy)
end

function ReadySpells:AnchorToTooltip(xspacing, yspacing, xspacingLeft, yspacingDown)
	local object = getglobal("GameTooltip")
	local tipcenterx, tipcentery = object:GetCenter()
	if tipcenterx == nil or tipcentery == nil then
		return false
	end
	tipcenterx = tipcenterx * object:GetScale()
	tipcentery = tipcentery * object:GetScale()
	
	if tipcenterx >= UIParent:GetRight()/2 then
		if tipcentery >= UIParent:GetTop()/2 then --top right
			point = "TOPRIGHT"
			relPoint = "TOPLEFT"

		else --bottom right
			point = "BOTTOMRIGHT"
			relPoint = "BOTTOMLEFT"
		end
	else
		if tipcentery >= UIParent:GetTop()/2 then --top left
			point = "TOPLEFT"
			relPoint = "TOPRIGHT"
		else --bottom left
			point = "BOTTOMLEFT"
			relPoint = "BOTTOMRIGHT"
		end
	end

	local adjx = 0
	local adjy = 0

	if self.db.profile.vertical then
		if tipcentery >= UIParent:GetTop()/2 then --top 
			if self.db.profile.reverse then
				adjy = yspacing
			else
				adjy = yspacingDown
			end
		else -- bottom
			if self.db.profile.reverse then
				adjy = -yspacingDown
			else
				adjy = -yspacing
			end
		end
	else
		if tipcenterx >= UIParent:GetRight()/2 then -- right
			if self.db.profile.reverse then
				adjx = xspacing
			else
				adjx = xspacingLeft
			end
		else -- left
			if self.db.profile.reverse then
				adjx = -xspacingLeft
			else
				adjx = -xspacing
			end
		end
	end

	self.mframe:ClearAllPoints()
	self.mframe:SetPoint(point, object, relPoint, adjx, adjy)
	return true
end

function ReadySpells:AnchorToCursor(xspacing, yspacing, width, height)
	local scaleUI = UIParent:GetScale()
	local topUI = UIParent:GetTop()
	local rightUI = UIParent:GetRight()
	local halfHeight = (height/2)*self.db.profile.scale
	local halfWidth = (width/2)*self.db.profile.scale
	local adjx = (((self.mframe:GetWidth() - width) /2) - xspacing) * self.db.profile.scale
	local adjy = (((self.mframe:GetHeight() - height) /2) - yspacing) * self.db.profile.scale

	if self.db.profile.vertical then
		if self.db.profile.reverse then
			adjy = 0 - adjy
		end
	else
		if self.db.profile.reverse then
			adjx = 0 - adjx
		end
	end

	local x,y = GetCursorPosition()

	x = x / scaleUI
	y = y / scaleUI

	if y + halfHeight > topUI then
		y = y - (y + halfHeight - topUI) - 32
	elseif y - halfHeight < 0 then
		y = y + (0 - y + halfHeight) + 32
	elseif x + halfWidth > rightUI then
		x = x - (x + halfWidth - rightUI) - 32
	elseif x - halfWidth < 0 then
		x = x + (0 - x + halfWidth) + 32
	end

    x = x + adjx
    y = y + adjy

	self.mframe:ClearAllPoints()
	self.mframe:SetPoint("CENTER", UIParent, "BOTTOMLEFT", x/self.db.profile.scale, y/self.db.profile.scale)
end


function ReadySpells:GetUnitDebuffStackCount(unit, spellName)
	local iIterator = 1
	local found = -1
	while (UnitDebuff(unit, iIterator)) do
		local dName, dCount, dLeft
		dName, dRank, dTexture, dCount, dType, dDur, dLeft = UnitDebuff(unit, iIterator)
		if (dName == spellName) then
			if dLeft ~= nil then
				return dCount, dLeft, dDur
			else
				found = dCount
			end
		end
		iIterator = iIterator + 1
	end
	return found
end

function ReadySpells:GetUnitBuffStackCount(unit, spellName)
	local iIterator = 1
	local found = -1
	while (UnitBuff(unit, iIterator)) do
		local dName, dCount, dLeft
		dName, dRank, dTexture, dCount, dDur, dLeft = UnitBuff(unit, iIterator)
		if (dName == spellName) then
			if dLeft ~= nil then
				return dCount, dLeft, dDur
			else
				found = dCount
			end
		end
		iIterator = iIterator + 1
	end
	return found
end

function ReadySpells:GetGroup()
	if GetNumRaidMembers() > 0 then
		return "Raid"
	elseif GetNumPartyMembers() > 0 then
		return "Group"
	else
		return "Default"
	end
end


----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
--addon setup stuff
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------


function ReadySpells:CreateDisplaySlots()
	local watchSpells = self.db.profile.classes[self.playerclass].watchSpells
	local i = 1
	local lastSpellName = nil
	local ids = {}

	if watchSpells == nil then return end

	i = 1
	while true do
		local spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
		if not spellName then
			break
		end
		if spellName ~= lastSpellName then -- rank 1 is fine, we're just taking its texture and spellName
			lastSpellName = spellName
			local found = false
			local j = 1
			while not found and j <= #watchSpells do
				local k = 1
				while not found and k <= #watchSpells[j] do
					if spellName == watchSpells[j][k] then
						ids[spellName] = i
						found = true
					end
					k = k + 1
				end
				j = j + 1
			end
		end
		i = i + 1
	end
	
	self.lastSpellID = i - 1
	self.frame:SetScale(1.0) -- bug workaround? if you create textures with the parent shown/hidden, it uses the scale of parent/1.0.
		
	for j = 1, #watchSpells do
		if displaySlots[j] == nil then
			displaySlots[j] = {}
		end
		displaySlots[j].spells = {}
		if displaySlots[j].texture == nil then
			displaySlots[j].texture = self.frame:CreateTexture(nil, 'DIALOG')
		end
		if displaySlots[j].textFrame == nil then
			displaySlots[j].textFrame = self:CreateTextFrame(j, false)
		end
		displaySlots[j].texture:SetWidth(32)
		displaySlots[j].texture:SetHeight(32)
		displaySlots[j].texture:Hide()

		if mouseoverSlots[j] == nil then
			mouseoverSlots[j] = {}
		end
		if mouseoverSlots[j].texture == nil then
			mouseoverSlots[j].texture = self.mframe:CreateTexture(nil, 'DIALOG')
		end
		if mouseoverSlots[j].textFrame == nil then
			mouseoverSlots[j].textFrame = self:CreateTextFrame(j, true)
		end
		mouseoverSlots[j].texture:SetWidth(32)
		mouseoverSlots[j].texture:SetHeight(32)
		mouseoverSlots[j].texture:Hide()

		for k = 1, #watchSpells[j] do
			local spellName = watchSpells[j][k]
			local id = ids[spellName]
			if id ~= nil then
				self:Debug("Watching "..spellName.." slot = "..j.." priority = "..k.." id = "..id)

				local next = #displaySlots[j].spells + 1
				local icon = GetSpellTexture(id, BOOKTYPE_SPELL)

				displaySlots[j].spells[next] = {
					["name"] = spellName,
					["id"] = id,
					["icon"] = icon,
				}
			else
				self:Debug("Didn't find "..spellName.." in spellbook.")
			end
		end
	end
end


function ReadySpells:CreateTextFrame(slotNum, mouseover)
	local textFrame
	if mouseover then
		textFrame = CreateFrame("Frame", "ReadySpellsMouseoverTextFrame"..slotNum, self.mframe)
		textFrame:SetFrameLevel(self.mframe:GetFrameLevel() + 1)
	else
		textFrame = CreateFrame("Frame", "ReadySpellsTextFrame"..slotNum, self.frame)
		textFrame:SetFrameLevel(self.frame:GetFrameLevel() + 1)
	end
	textFrame:SetWidth(32)
	textFrame:SetHeight(32)
	textFrame.text = textFrame:CreateFontString(nil, "OVERLAY")
	textFrame.text:SetWidth(64)
	textFrame.text:SetHeight(32)
	textFrame.text:ClearAllPoints()
	textFrame.text:SetPoint("CENTER", textFrame, "CENTER")
	textFrame.text:SetJustifyH("CENTER")
	textFrame.text:SetJustifyV("MIDDLE")
	textFrame:Hide()
	return textFrame
end


function ReadySpells:SetupDisplaySlots()
	local point
	local relpoint
	local xspacing
	local yspacing
	local width
	local height
		
	if self.db.profile.vertical then
		if self.db.profile.reverse then
			point = "TOP"
			relPoint = "BOTTOM"
			yspacing = 0 - self.db.profile.spacing
		else
			point = "BOTTOM"
			relPoint = "TOP"
			yspacing = self.db.profile.spacing
		end
		xspacing = 0
		width = 32
		height = #displaySlots * 32 + (#displaySlots - 1) * self.db.profile.spacing
	else
		if self.db.profile.reverse then
			point = "RIGHT"
			relPoint = "LEFT"
			xspacing = 0 - self.db.profile.spacing
		else
			point = "LEFT"
			relPoint = "RIGHT"
			xspacing = self.db.profile.spacing
		end
		yspacing = 0
		width = #displaySlots * 32 + (#displaySlots - 1) * self.db.profile.spacing
		height = 32
	end

	self.anchor:ClearAllPoints()
	if self.db.profile.x and self.db.profile.y and self.db.profile.rel1 and self.db.profile.rel2 then
		self.anchor:SetPoint(self.db.profile.rel1, UIParent, self.db.profile.rel2, self.db.profile.x, self.db.profile.y)
	else
		self.anchor:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
	end

	if self.db.profile.locked then
		self:HideAnchor()
	else
		self:ShowAnchor()
	end

	self.frame:SetScale(self.db.profile.scale)
	self.frame:SetAlpha(self.db.profile.alpha)
	self.frame:SetWidth(width)
	self.frame:SetHeight(height)
	self.frame:ClearAllPoints()
	self.frame:SetPoint(point, self.anchor, relPoint, 0, 0)

	self.mframe:SetWidth(width)
	self.mframe:SetHeight(height)
	self.mframe:Hide()
	self.mframe.anchoredTo = -1

	for j= 1, #displaySlots do
		displaySlots[j].texture:ClearAllPoints()
		displaySlots[j].textFrame:ClearAllPoints()
		mouseoverSlots[j].texture:ClearAllPoints()
		mouseoverSlots[j].textFrame:ClearAllPoints()
		if j == 1 then
			displaySlots[j].texture:SetPoint(point, self.frame, point, 0, 0)
			displaySlots[j].textFrame:SetPoint(point, self.frame, point, 0, 0)
			mouseoverSlots[j].texture:SetPoint(point, self.mframe, point, 0, 0)
			mouseoverSlots[j].textFrame:SetPoint(point, self.mframe, point, 0, 0)
		else
			displaySlots[j].texture:SetPoint(point, displaySlots[j-1].texture, relPoint, xspacing, yspacing)
			displaySlots[j].textFrame:SetPoint(point, displaySlots[j-1].texture, relPoint, xspacing, yspacing)
			mouseoverSlots[j].texture:SetPoint(point, mouseoverSlots[j-1].texture, relPoint, xspacing, yspacing)
			mouseoverSlots[j].textFrame:SetPoint(point, mouseoverSlots[j-1].texture, relPoint, xspacing, yspacing)
		end
	end
end


function ReadySpells:CreateAnchor()
	local width = 80
	local height = 25
	local f = CreateFrame("Frame", "ReadySpellsAnchor", UIParent)
	f:SetWidth(width)
	f:SetHeight(height)
	f:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background",
					edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
					tile = false, tileSize = 16, edgeSize = 16,
					insets = { left = 5, right =5, top = 5, bottom = 5 }})
	f:SetBackdropColor(0.2,0.2,0.2)

	f:EnableMouse(true)
	f:SetMovable(true)
	f:RegisterForDrag("LeftButton")
	f:SetScript("OnDragStart", 
		function() 
			this:StartMoving() 
		end)
	f:SetScript("OnDragStop",
		function()
			this:StopMovingOrSizing()
			local a, _, b, x, y = this:GetPoint()
			self.db.profile.x = math.floor(x)
			self.db.profile.y = math.floor(y)
			self.db.profile.rel1 = a
			self.db.profile.rel2 = b
        end)
	f:SetScript("OnMouseUp", 
		function() 
			if IsShiftKeyDown() then
				self:HideAnchor()
			end
			if IsAltKeyDown() then
				self:RotateAnchor()
			end
		end)
	f.Text = f:CreateFontString(nil, "OVERLAY")
	f.Text:SetFontObject(GameFontNormalSmall)
	f.Text:ClearAllPoints()
	f.Text:SetTextColor(1, 1, 1, 1)
	f.Text:SetWidth(width)
	f.Text:SetHeight(height)
	f.Text:SetPoint("TOPLEFT", f, "TOPLEFT")
	f.Text:SetJustifyH("CENTER")
	f.Text:SetJustifyV("MIDDLE")
	f.Text:SetText("/ReadySpells")
	return f
end

function ReadySpells:HideAnchor()
	self.anchor:Hide()
	self.db.profile.locked = true
	self.frame:SetBackdropColor(0.3,0.3,0.3,0)
end

function ReadySpells:ShowAnchor()
	self.anchor:Show()
	self.db.profile.locked = false
	self.frame:SetBackdropColor(0.3,0.3,0.3,1)
end

function ReadySpells:RotateAnchor()
	if not self.db.profile.vertical then
		self.db.profile.reverse = not self.db.profile.reverse
	end
	self.db.profile.vertical = not self.db.profile.vertical
	self:SetupDisplaySlots()
end


function ReadySpells:CreateReadySpellsFrame()
	local f = CreateFrame("Frame", "ReadySpellsFrame", UIParent)
	f:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background",
					edgeFile = nil, tile = false, tileSize = 16, edgeSize = 16,
					insets = { left = 0, right =0, top = 0, bottom = 0 }})
	f:EnableMouse(false)
	f:SetScript("OnUpdate", 
		function() 
				now = GetTime()
				elapsed = now - self.lastTime
				if elapsed > 0.15 then
					self:UpdateDisplaySlots()
				end
		end)
	f:Show()
	return f
end


function ReadySpells:CreateReadySpellsMouseoverFrame()
	local f = CreateFrame("Frame", "ReadySpellsMouseoverFrame", self.frame)
	f:SetBackdrop({bgFile = nil, edgeFile = nil, tile = false, tileSize = 16, edgeSize = 16, 
					insets = { left = 0, right =0, top = 0, bottom = 0 }})
	f:SetFrameStrata("TOOLTIP")
	f:SetFrameLevel(getglobal("GameTooltip"):GetFrameLevel() + 1)
	f:EnableMouse(false)
	f:Hide()
	f.anchoredTo = -1
	return f
end


function ReadySpells:CreateReadySpellsAdjustingBorder()
	local f = CreateFrame("Frame", "ReadySpellsAdjustingBorder", self.mframe)
	f:SetBackdrop({bgFile = nil, edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
					tile = false, tileSize = 16, edgeSize = 16,
					insets = { left = 0, right =0, top = 0, bottom = 0 }})
	f:SetBackdropBorderColor(0.4,0.4,0.4)
	f:EnableMouse(false)
	f:Show()
	return f
end

function ReadySpells:OnProfileEnable(oldName, oldData, newName)
		if self.playerclass == "DRUID" then
			self:DruidInit()
		elseif self.playerclass == "HUNTER" then
			self:HunterInit()
		elseif self.playerclass == "MAGE" then
			self:MageInit()
		elseif self.playerclass == "PALADIN" then
			self:PaladinInit()
		elseif self.playerclass == "PRIEST" then
			self:PriestInit()
		elseif self.playerclass == "ROGUE" then
			self:RogueInit()
		elseif self.playerclass == "SHAMAN" then
			self:ShamanInit()
		elseif self.playerclass == "WARLOCK" then
			self:WarlockInit()
		elseif self.playerclass == "WARRIOR" then
			self:WarriorInit()
		end

	if self.db.profile.mouseover and self.db.profile.mouseoverAnchor > 0 then
		self:RegisterEvent("UPDATE_MOUSEOVER_UNIT")
	end
	if self.db.profile.autoSwitchProfile then
		self:RegisterEvent("RAID_ROSTER_UPDATE")
		self:RegisterEvent("PARTY_MEMBERS_CHANGED")
	end
	if self.db.profile.classes[self.playerclass].swingActivations ~= nil then
		self:RegisterEvent("UNIT_SPELLCAST_SENT")
		self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
		self:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED")
		self:RegisterEvent("PLAYER_TARGET_CHANGED")
		self:RegisterEvent("PLAYER_LEAVE_COMBAT")
		self:RegisterEvent("UNIT_SPELLCAST_START")
		parser:RegisterEvent("ReadySpells", "CHAT_MSG_SPELL_FAILED_LOCALPLAYER", function (event, info) self:Callback_CHAT_MSG_SPELL_FAILED_LOCALPLAYER(event, info) end)
	end

	self.needCreate = 1
	self.checkGroup = 0
end

function ReadySpells:OnProfileDisable()
	--have to check IsEventRegistered in case we are autoswitching right on UI load, before we Register them.
	if self.db.profile.mouseover and self.db.profile.mouseoverAnchor > 0 then
		if self:IsEventRegistered("UPDATE_MOUSEOVER_UNIT") then
			self:UnregisterEvent("UPDATE_MOUSEOVER_UNIT")
		end
	end
	if self.db.profile.autoSwitchProfile then
		if self:IsEventRegistered("RAID_ROSTER_UPDATE") then
			self:UnregisterEvent("RAID_ROSTER_UPDATE")
		end
		if self:IsEventRegistered("PARTY_MEMBERS_CHANGED") then
			self:UnregisterEvent("PARTY_MEMBERS_CHANGED")
		end
	end
	if self.db.profile.classes[self.playerclass].swingActivations ~= nil then
		if self:IsEventRegistered("UNIT_SPELLCAST_SENT") then
			self:UnregisterEvent("UNIT_SPELLCAST_SENT")
			self:UnregisterEvent("UNIT_SPELLCAST_SUCCEEDED")
			self:UnregisterEvent("UNIT_SPELLCAST_INTERRUPTED")
			self:UnregisterEvent("PLAYER_TARGET_CHANGED")
			self:UnregisterEvent("PLAYER_LEAVE_COMBAT")
			self:UnregisterEvent("UNIT_SPELLCAST_START")
			parser:UnregisterAllEvents("ReadySpells")
		end
	end
end


function ReadySpells:OnEnable(first)
    --self:SetDebugging(true)
	self.swingActivated = false
	self.lastTime = GetTime()

	if first then
		self.anchor = self:CreateAnchor()
		self.frame = self:CreateReadySpellsFrame()
		self.mframe = self:CreateReadySpellsMouseoverFrame()
		self.border = self:CreateReadySpellsAdjustingBorder()
	else
		self.frame:Show()
	end

	if self.db.profile.autoSwitchProfile and self:GetProfile() ~= self:GetGroup() then
		self:Print("AutoSwitch from "..self:GetProfile().." to "..self:GetGroup().." (during OnEnable).")
		self:SetProfile(self:GetGroup())
	else
		self:OnProfileEnable()
	end

	self:RegisterEvent("CHARACTER_POINTS_CHANGED")
	self:RegisterEvent("LEARNED_SPELL_IN_TAB")
end


function ReadySpells:OnDisable()
	self.anchor:Hide()
	self.frame:Hide()
	self.mframe:Hide()
	f.anchoredTo = -1
	self:OnProfileDisable()
	--other events should be automatically unregistered
end

function ReadySpells:OnInitialize()
	self:RegisterDB("ReadySpellsDB", nil, "Default")
	self:RegisterDefaults("profile", {
			scale = 0.8,
			alpha = 0.8,
			spacing = 2,
			vertical = true,
			reverse = false,
			locked = false,
			mouseover = true,
			mouseoverAnchor = 1,
			autoSwitchProfile = false,
			classes = {
				['*'] = {
					onlyShowInCombat = false,
					buffCountdown = 4,
					debuffCountdown = 5,
					onCooldownCountdown = true,
					showNoMana = true,
--[[				
					watchSpells = nil,
					buffStacks = nil,
					debuffStacks = nil,
					manaChecks = nil,
					swingActivations = nil,
]]--
				}
			},
	} )

	local opts = { 
    type='group',
    args = {
		anchorHide = {
			name = 'anchorHide',
			desc = 'Anchor display on/off', 
			type = 'toggle', 
			get = function()
				return self.db.profile.locked
			end,
			set = function(f) 
				self.db.profile.locked = f
				if self.db.profile.locked then
					self:HideAnchor()
				else
					self:ShowAnchor()
				end
			end,
		},
		anchorReset = {
			name = 'anchorReset',
			desc = 'Reset anchor position and set anchor display on', 
			type = 'execute', 
			func = function() 
				self:Print("resetAnchor.")
				self.anchor:ClearAllPoints()
				self.anchor:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
				self.db.profile.x = nil
				self.db.profile.y = nil
				self.db.profile.rel1 = nil
				self.db.profile.rel2 = nil
				self:ShowAnchor()
			end,
		},
		setAlpha = {
			name = 'setAlpha',
			desc = 'setAlpha desc', 
			type = 'range', 
			get = function() 
				return self.db.profile.alpha 
			end,
			set = function(f) 
				self.db.profile.alpha = f 
				self.frame:SetAlpha(self.db.profile.alpha)
			end,
			min = 0.3, max = 1.0, step = 0.1
		},
		setScale = {
			name = 'setScale',
			desc = 'setScale desc', 
			type = 'range', 
			get = function() 
				return self.db.profile.scale
			end,
			set = function(f) 
				self.db.profile.scale = f 
				self.frame:SetScale(self.db.profile.scale)
			end,
			min = 0.5, max = 2.0, step = 0.1
		},
		setSpacing = {
			name = 'setSpacing',
			desc = 'setSpacing between images', 
			type = 'range', 
			get = function() 
				return self.db.profile.spacing
			end,
			set = function(f) 
				self.db.profile.spacing = f 
				self:SetupDisplaySlots()
			end,
			min = 0, max = 10, step = 1
		},
		toggleVertical = {
			name = 'toggleVertical',
			desc = 'toggleVertical desc',
			type = 'toggle', 
			get = function()
				return self.db.profile.vertical
			end,
			set = function(f) 
				self.db.profile.vertical = f
				self:SetupDisplaySlots()
			end,
		},
		toggleReverse = {
			name = 'toggleReverse',
			desc = 'toggleReverse desc',
			type = 'toggle', 
			get = function()
				return self.db.profile.reverse
			end,
			set = function(f) 
				self.db.profile.reverse = f
				self:SetupDisplaySlots()
			end,
		},
		toggleMouseover = {
			name = 'toggleMouseover',
			desc = 'Toggle whether ReadySpells uses mouseover.',
			type = 'toggle', 
			get = function()
				return self.db.profile.mouseover
			end,
			set = function(f) 
				self.db.profile.mouseover = f
				if self.db.profile.mouseover then
					if self.db.profile.mouseoverAnchor ~= 0 then
						self:RegisterEvent("UPDATE_MOUSEOVER_UNIT")
					end
				else
					self.mframe:Hide()
					self.mframe.anchoredTo = -1
					if self.db.profile.mouseoverAnchor ~= 0 then
						self:UnregisterEvent("UPDATE_MOUSEOVER_UNIT")
					end
				end
			end,
		},
		setMouseoverAnchor = {
			name = 'setMouseoverAnchor',
			desc = 'set where the ReadySpells frame is anchored to during a mouseover.',
			type = 'text',
			get = function()
				if self.db.profile.mouseoverAnchor == 0 then
					return "anchor"
				elseif self.db.profile.mouseoverAnchor == 1 then
					return "tooltip"
				else
					return "cursor"
				end
			end,
			set = function(f) 
				if not self.db.profile.mouseover then
					self:Print("mouseover is not currently enabled. Nothing done.")
					return
				end
				if f == "anchor" then
					if self:IsEventRegistered("UPDATE_MOUSEOVER_UNIT") then
						self:UnregisterEvent("UPDATE_MOUSEOVER_UNIT")
					end
					self.db.profile.mouseoverAnchor = 0
				elseif f == "tooltip" then
					if not self:IsEventRegistered("UPDATE_MOUSEOVER_UNIT") then
						self:RegisterEvent("UPDATE_MOUSEOVER_UNIT")
					end
					self.db.profile.mouseoverAnchor = 1
				else
					if not self:IsEventRegistered("UPDATE_MOUSEOVER_UNIT") then
						self:RegisterEvent("UPDATE_MOUSEOVER_UNIT")
					end
					self.db.profile.mouseoverAnchor = 2
				end
			end,
			validate = { [1] = "anchor", [2] = "tooltip", [3] = "cursor"},
		},
		toggleAutoSwitch = {
			name = 'toggleAutoSwitch',
			desc = 'Toggle AutoSwitching of profiles between (only) Default, Group, and Raid.',
			type = 'toggle', 
			get = function()
				return self.db.profile.autoSwitchProfile
			end,
			set = function(f) 
				self.db.profile.autoSwitchProfile = f
				if self.db.profile.autoSwitchProfile then
					self.checkGroup = 1
					self:RegisterEvent("RAID_ROSTER_UPDATE")
					self:RegisterEvent("PARTY_MEMBERS_CHANGED")
				else
					self:UnregisterEvent("RAID_ROSTER_UPDATE")
					self:UnregisterEvent("PARTY_MEMBERS_CHANGED")
				end
			end,
		},
		onlyShowInCombat = {
			name = 'onlyShowInCombat',
			desc = 'only show Readyspells in combat.',
			type = 'toggle', 
			get = function()
				return self.db.profile.classes[self.playerclass].onlyShowInCombat
			end,
			set = function(f) 
				self.db.profile.classes[self.playerclass].onlyShowInCombat = f
			end,
		},
		buffCountdown = {
			name = 'buffCountDown',
			desc = 'Show countdown when this number of seconds is left.', 
			type = 'range', 
			get = function() 
				return self.db.profile.classes[self.playerclass].buffCountdown
			end,
			set = function(f) 
				self.db.profile.classes[self.playerclass].buffCountdown = f 
			end,
			min = 0, max = 30, step = 1
		},
		debuffCountdown = {
			name = 'debuffCountDown',
			desc = 'Show countdown when this number of seconds is left.', 
			type = 'range', 
			get = function() 
				return self.db.profile.classes[self.playerclass].debuffCountdown
			end,
			set = function(f) 
				self.db.profile.classes[self.playerclass].debuffCountdown = f 
			end,
			min = 0, max = 30, step = 1
		},
		onCooldownCountdown = {
			name = 'onCooldownCountdown',
			desc = 'Toggle showing a countdown for watched de/buff spells about to expire, even if on a long cooldown.',
			type = 'toggle', 
			get = function()
				return self.db.profile.classes[self.playerclass].onCooldownCountdown
			end,
			set = function(f) 
				self.db.profile.classes[self.playerclass].onCooldownCountdown = f 
			end,
		},
		showNoMana = {
			name = 'showNoMana',
			desc = 'Toggle showing an image when not enough mana for spell.',
			type = 'toggle', 
			get = function()
				return self.db.profile.classes[self.playerclass].showNoMana
			end,
			set = function(f) 
				self.db.profile.classes[self.playerclass].showNoMana = f 
			end,
		},

		gui = {
			name = "gui",
			desc="Waterfall GUI",
			type = "execute",
			guiHidden = true,
			func = function()
				waterfall:Open("ReadySpells")
			end,
			hidden = function() return not waterfall end,
		},
	},
	}

	if waterfall then
		waterfall:Register(
			"ReadySpells",
			"aceOptions", opts,
			"colorR", .6, "colorG", .5, "colorB", .8
		)
	end

	self:RegisterChatCommand({"/ReadySpells", "/rsp"}, opts)

    _, self.playerclass = UnitClass("player")
end


----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
--events
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------


function ReadySpells:UNIT_SPELLCAST_SENT()
	if arg1 == "player" then
		if self.db.profile.classes[self.playerclass].swingActivations ~= nil and self.db.profile.classes[self.playerclass].swingActivations[arg2] == true then
			self.swingActivated = true
		end
	end
end

function ReadySpells:UNIT_SPELLCAST_SUCCEEDED()
	if self.swingActivated then
		if arg1 == "player" then
			if self.db.profile.classes[self.playerclass].swingActivations ~= nil and self.db.profile.classes[self.playerclass].swingActivations[arg2] == true then
				self.swingActivated = false
			end
		end
	end
end

function ReadySpells:UNIT_SPELLCAST_INTERRUPTED()
	if self.swingActivated then
		if arg1 == "player" then
			if self.db.profile.classes[self.playerclass].swingActivations ~= nil and self.db.profile.classes[self.playerclass].swingActivations[arg2] == true then
				--I don't think it is possible to be here for these type of spells...
				self:Debug("UNIT_SPELLCAST_INTERRUPTED player swingActivated "..arg2)
				self.swingActivated = false
			end
		end
	end
end

function ReadySpells:PLAYER_TARGET_CHANGED()
	self.swingActivated = false
end

function ReadySpells:PLAYER_LEAVE_COMBAT()
	self.swingActivated = false
end

function ReadySpells:UNIT_SPELLCAST_START()
	if arg1 == "player" then
		self.swingActivated = false
	end
end

--You fail to perform <Skill>: Not enough rage. Interrupted, Can't do that while stunned., etc.
function ReadySpells:Callback_CHAT_MSG_SPELL_FAILED_LOCALPLAYER(event, info)
	if self.swingActivated then
		if self.db.profile.classes[self.playerclass].swingActivations ~= nil and self.db.profile.classes[self.playerclass].swingActivations[info.skill] == true then
			if info.reason == "Another action is in progress" then
				--fix a bug with the swing activation icon ungreying when it shouldn't
			else
				--self:Debug("FAILED "..info.reason.." "..info.skill)
				self.swingActivated = false
			end
		end
	end
end 

function ReadySpells:UPDATE_MOUSEOVER_UNIT()
	self.reanchor = 1
end

function ReadySpells:CHARACTER_POINTS_CHANGED()
	--gets fired when talents are unlearned, among other places
	if GetSpellName(self.lastSpellID, BOOKTYPE_SPELL) == nil then
		self.needCreate = 1
	end
end

function ReadySpells:LEARNED_SPELL_IN_TAB()
	self.needCreate = 1
end

function ReadySpells:RAID_ROSTER_UPDATE()
	self.checkGroup = 1
end

function ReadySpells:PARTY_MEMBERS_CHANGED()
	self.checkGroup = 1
end

