local L = AceLibrary("AceLocale-2.2"):new("ReTotem")

local totemFilter = {"Stoneclaw", "Fire Elemental", "Earth Elemental"}

local options = {
	type = 'group',
	args = {
		unlock = {
			type = 'toggle',
			name = L['unlock'],
			desc = L["Lock/unlock the text frame anchor"],
			get = "FrameUnlocked",
			set = "ToggleFrame",
		},
		textColor = {
			type = "color",
			name = L["Text Color"],
			desc = L["Set the display text color"],
			get =  "GetTextColor",
			set = "SetTextColor",
		},
		resetPos = {
			type = 'execute',
			name = L["Reset position"],
			desc = L["Resets the text position"],
			func = function() ReTotem.frame:SetPoint("CENTER", nil, "CENTER", 0, 0) end,
		},
		fontSize = {
			type = "range",
			name = L["Font Size"],
			desc = L["Set the font size"],
			max = 45,
			min = 10,
			get = "GetFontSize",
			set = "SetFontSize",
		},
		attackerInfo = {
			type = "toggle",
			name = L["Attacker Info"],
			desc = L["Displays attacker information (name, spell, damage done)"],
			get = "AttackerInfoEnabled",
			set = "ToggleAttackerInfo",	
		},
		filter = {
			type = "toggle",
			name = L["Filter out high-health totems"],
			desc = L["Enable/disable reporting for high-health totems like Stoneclaw Totem"],
			get = "FilterStatus",
			set = "ToggleFilter",	
		},
		
	},
}

ReTotem = AceLibrary("AceAddon-2.0"):new("AceDB-2.0", "AceConsole-2.0", "AceEvent-2.0", "AceHook-2.1")
ReTotem:RegisterChatCommand("/retotem", options)

ReTotem.version = "1.4"

ReTotem.title = "ReTotem"
ReTotem.unlocked = false

ReTotem:RegisterDB("ReTotemDB")
ReTotem:RegisterDefaults("profile", { 
	unlock=false, 
	textR=1,
	textG=1,
	textB=1, 
	fontSize=20, 
	x = 0, 
	y = 0, 
	relPoint = "CENTER", 
	filter = false,
	attackerInfo = false,
})

function ReTotem:OnInitialize()
	--DEFAULT_CHAT_FRAME:AddMessage("ReTotem: Initializing")
end

function ReTotem:OnEnable(first)
	ReTotem:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	ReTotem.HasEnabled = true

	
	ReTotem.frame = CreateFrame("Frame", "ReTotem_Frame", UIParent)

	local frame = ReTotem.frame

	frame:SetBackdrop( {
		bgFile="Interface/Tooltips/UI-Tooltip-Background",
		edgeFile="Interface/Tooltips/UI-Tooltip-Border",
		tile=false,
		tileSize=16,
		edgeSize=16,
		insets = { left = 4, right = 4, top = 4, bottom = 4 }
		} )

	frame:SetBackdropColor(0,0,0,0)
	frame:SetBackdropBorderColor(1,1,1,0)
	frame:SetPoint("CENTER",nil,ReTotem.db.profile.relPoint,ReTotem.db.profile.x,ReTotem.db.profile.y)
	frame:EnableMouse()
	frame:SetMovable(true)
	frame:RegisterForDrag("LeftButton")
	
	frame:SetScript("OnMouseDown", 
		function() 
			--DEFAULT_CHAT_FRAME:AddMessage("StartDrag")
			if ReTotem.unlocked then
				ReTotem.frame:StartMoving()
			end
		end
	)
	
	frame:SetScript("OnMouseUp", 
		function()
			--DEFAULT_CHAT_FRAME:AddMessage("StopDrag")
			ReTotem.frame:StopMovingOrSizing()
			a,b,c,x,y = ReTotem.frame:GetPoint(1)
			ReTotem.db.profile.x = x
			ReTotem.db.profile.y = y
			ReTotem.db.profile.relPoint = c
		end
	)
	
	ReTotem.text = frame:CreateFontString("ReTotem_Text", "OVERLAY", "NumberFontNormal")

	local text = ReTotem.text

	text:SetFont("Fonts\\FRIZQT__.TTF", ReTotem.db.profile.fontSize, "THICKOUTLINE")
	--text:SetFontObject("GameFontNormal")
	
	text:SetTextColor(ReTotem.db.profile.textR,ReTotem.db.profile.textG,ReTotem.db.profile.textB)
	text:SetParent(frame)
	text:SetPoint("CENTER",0,0)
	--text:SetText("text string")
	
	frame:SetWidth(30)
	frame:SetHeight(30)
	
	frame.fs = text
	
	text:Show()
	frame:Show()
end

function ReTotem:OnDisable()
	if not ReTotem.HasEnabled then
		return
	end
	ReTotem.HasEnabled = false
end

function ReTotem:COMBAT_LOG_EVENT_UNFILTERED(time, event, sGUID, sName, sFlags, dGUID, dName, dFlags, a1,a2,a3,a4,...)
	--[[
	local display = false
	
	-- it's ours, and it's of type guardian
	if (bit.band(dFlags, COMBATLOG_OBJECT_AFFILIATION_MASK) == COMBATLOG_OBJECT_AFFILIATION_MINE) and
		(bit.band(dFlags, COMBATLOG_OBJECT_TYPE_MASK) == COMBATLOG_OBJECT_TYPE_GUARDIAN) then
		
		display = true
		
		local text_string
		
		-- damage event
		if string.find(event, "_DAMAGE") then
		
			text_string = dName .. " " .. L["killed"]
			
			if ReTotem.db.profile.attackerInfo then
				local damage, spell
			
				if event == "SPELL_DAMAGE" then
					damage = a4
					spell = a2
				elseif event == "SWING_DAMAGE" then
					damage = a1
					spell = "Attack"
				end
				text_string = text_string .. string.format("\n(%s, %s, %d)", sName, spell, damage)
			end
				
			if ReTotem:FilteredTotem(dName) then
				if ReTotem.db.profile.filter then
					display = false				
				else
					text_string = string.gsub(text_string, L["killed"], L["under attack"])
				end
			end
			
		-- spell missed due to immunity - grounding totem
		elseif string.find(event, "SPELL_MISSED") and (a4 == "IMMUNE") then
		
			text_string = dName .. " " .. L["destroyed"]
		
			if ReTotem.db.profile.attackerInfo then
				text_string = text_string .. string.format("\n(%s, %s)", sName, a2)
			end
		
		end
	
	end
	
	if display then
		ReTotem.text:SetText(text_string)
			
		-- Cancel any current fading
		if UIFrameIsFading(ReTotem.text) then
			UIFrameFlashRemoveFrame(ReTotem.text)
		end

		UIFrameFlash(ReTotem.text, .5, 2, 7.5, false, 0, 5)	
	end
	
	]]
	
	-- DEFAULT_CHAT_FRAME:AddMessage(event)
	if string.find(event, "_DAMAGE") then
		-- To one of our guardians
		if bit.band(dFlags, COMBATLOG_OBJECT_AFFILIATION_MASK) == COMBATLOG_OBJECT_AFFILIATION_MINE and
			bit.band(dFlags, COMBATLOG_OBJECT_TYPE_MASK) == COMBATLOG_OBJECT_TYPE_GUARDIAN then
			
			local text_string = dName .. " " .. L["killed"]
			
			if ReTotem.db.profile.attackerInfo then
				local damage, spell
			
				if event == "SPELL_DAMAGE" then
					damage = a4
					spell = a2
				elseif event == "SWING_DAMAGE" then
					damage = a1
					spell = "Attack"
				end
				text_string = text_string .. string.format("\n(%s, %s, %d)", sName, spell, damage)
			end
				
			if ReTotem:FilteredTotem(dName) then
				if ReTotem.db.profile.filter then
					text_string = ""				
				else
					text_string = string.gsub(text_string, L["killed"], L["under attack"])
				end
			end
					
			-- DEFAULT_CHAT_FRAME:AddMessage(text_string)
			ReTotem.text:SetText(text_string)
			
			-- Cancel any current fading
			if UIFrameIsFading(ReTotem.text) then
				UIFrameFlashRemoveFrame(ReTotem.text)
			end
	
			UIFrameFlash(ReTotem.text, .5, 2, 7.5, false, 0, 5)
			
		end
	-- 7/4 17:34:00.814  SPELL_MISSED,0xF130001977178743,"Tar Lord",0x10a48,0xF130001725179286,"Grounding Totem",0x2111,12747,"Entangling Roots",0x8,IMMUNE
	
	elseif string.find(event, "SPELL_MISSED") and (a4 == "IMMUNE") and
		(bit.band(dFlags, COMBATLOG_OBJECT_AFFILIATION_MASK) == COMBATLOG_OBJECT_AFFILIATION_MINE) and
		(bit.band(dFlags, COMBATLOG_OBJECT_TYPE_MASK) == COMBATLOG_OBJECT_TYPE_GUARDIAN) and
		(dName == "Grounding Totem") then
		
		local text_string = dName .. " " .. L["destroyed"]
		
		if ReTotem.db.profile.attackerInfo then
			text_string = text_string .. string.format("\n(%s, %s)", sName, a2)
		end
		
		-- DEFAULT_CHAT_FRAME:AddMessage(text_string)
		ReTotem.text:SetText(text_string)
		
		-- Cancel any current fading
		if UIFrameIsFading(ReTotem.text) then
			UIFrameFlashRemoveFrame(ReTotem.text)
		end

		UIFrameFlash(ReTotem.text, .5, 2, 7.5, false, 0, 5)
	end
end

function ReTotem:FilteredTotem(name)
	for _,totem in pairs(totemFilter) do
		if string.find(name, totem) then
			return true
		end	
	end
	return false
end

function ReTotem:ToggleAttackerInfo(b)
	ReTotem.db.profile.attackerInfo = b
end

function ReTotem:AttackerInfoEnabled()
	return ReTotem.db.profile.attackerInfo
end

function ReTotem:FilterStatus()
	return ReTotem.db.profile.filter
end

function ReTotem:ToggleFilter(f)
	ReTotem.db.profile.filter = f
end

function ReTotem:FrameUnlocked()
	return ReTotem.unlocked
end

function ReTotem:ToggleFrame(b)
	ReTotem.unlocked = b
	if b then
		ReTotem.frame:SetBackdropColor(0,0,0,1)
		ReTotem.frame:SetBackdropBorderColor(1,1,1,1)
	else
		ReTotem.frame:SetBackdropColor(0,0,0,0)
		ReTotem.frame:SetBackdropBorderColor(1,1,1,0)
	end
end

function ReTotem:GetFontSize()
	return ReTotem.db.profile.fontSize
end

function ReTotem:SetFontSize(s)
	ReTotem.db.profile.fontSize = s
	ReTotem:RefreshFont()
end

function ReTotem:RefreshFont()
	ReTotem.text:SetFont("Fonts\\FRIZQT__.TTF", ReTotem.db.profile.fontSize, "THICKOUTLINE")
	ReTotem.text:SetTextColor(ReTotem.db.profile.textR,ReTotem.db.profile.textG,ReTotem.db.profile.textB)
end

function ReTotem:GetTextColor()
	return ReTotem.db.profile.textR,ReTotem.db.profile.textG,ReTotem.db.profile.textB
end

function ReTotem:SetTextColor(r,g,b)
	ReTotem.db.profile.textR,ReTotem.db.profile.textG,ReTotem.db.profile.textB = r,g,b
	ReTotem:RefreshFont()
end