﻿Raidtargets = LibStub("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0", "AceEvent-2.0", "AceHook-2.1", "FuBarPlugin-2.0")
local rt = Raidtargets

--Saved Raidtargeticons
rt.iconPath = 'Interface\\AddOns\\Raidtargets\\Textures\\%d.tga'
rt.iconname = {'Star', 'Circle', 'Diamond', 'Triangle', 'Moon', 'Square', 'Cross', 'Skull'}

--Options
rt.options = {
	handler = rt,
	type = 'group',
	args = {
        --Report
        report = {
            name = 'Report',
            desc = 'Report it in the Chat',
            type = 'group',
            pass = true,
            func = 'Report',
            order = 111,
            args = {
                ['WHISPER'] = {
                    name = 'Whisper to target',
                    desc = 'Report to your target',
                    type = 'execute',
                    order = 1,
                    },
                ['SAY'] = {
                    name = 'Say',
                    desc = 'Report in the say-channel',
                    type = 'execute',
                    order = 2,
                    },
                ['PARTY'] = {
                    name = 'Party',
                    desc = 'Report in the party-channel',
                    type = 'execute',
                    order = 3,
                    },
                ['RAID'] = {
                    name = 'Raid',
                    desc = 'Report in the raid-channel',
                    type = 'execute',
                    order = 4,
                    },
                ['OFFICER'] = {
                    name = 'Officer',
                    desc = 'Report in the officer-channel',
                    type = 'execute',
                    order = 5,
                    },
                }
            },
        --Set a Raidtarget
        setRaidtarget = {
			name = 'Set a Raidtarget',
            type = 'group',
			desc = 'Set a Raidtarget',
			pass = true,
			get = function(index) return rt.db.profile.assignment[index] end,
			set = "assignPlayer",
			order = 100,
			args = {
				[1] = {
					name = "Star", type = "text", desc = "Set Star",
					usage = "",
					order = 1,
                    disabled = 'checkdisabled',
                    icon = rt.iconPath:format(1),
				},
				[2] = {
					name = "Circle", type = "text", desc = "Set Circle",
					usage = "",
					order = 2,
                    disabled = function ()
                         return string.len(rt.db.profile.assignment[order]) > 0
                    end,
                    icon = rt.iconPath:format(2),
				},
				[3] = {
					name = "Diamond", type = "text", desc = "Set Diamond",
					usage = "",
					order = 3,
                    icon = rt.iconPath:format(3),
				},
				[4] = {
					name = "Triangle", type = "text", desc = "Set Triangle",
					usage = "",
					order = 4,
                    icon = rt.iconPath:format(4),
				},
				[5] = {
					name = "Moon", type = "text", desc = "Set Moon",
					usage = "",
					order = 5,
                    icon = rt.iconPath:format(5),
				},
				[6] = {
					name = "Square", type = "text", desc = "Set Square",
					usage = "",
					order = 6,
                    icon = rt.iconPath:format(6),
				},
				[7] = {
					name = "Cross", type = "text", desc = "Set Cross",
					usage = "",
					order = 7,
                    icon = rt.iconPath:format(7),
				},
				[8] = {
					name = "Skull", type = "text", desc = "Set Skull",
					usage = "",
					order = 8,
                    icon = rt.iconPath:format(8),
				},
			},
		},
        --remove a Player
        removeraidtarget = {
            name = 'Remove a Raidtarget',
            desc = 'Remove a Raidtarget',
            type = 'group',
            pass = true,
            func = 'removeraidtarget',
            order = 101,
            args = {
                }
            },
        --Set the killorder
        killorder = {
			name = 'Set the Killorder',
            type = 'group',
			desc = 'Set the Killorder',
			pass = true,
			get = function (index) return rt.db.profile.order[index] end,
			set = "setorder",
			order = 102,
			args = {
				[1] = {
					name = "Star", type = "range", desc = "Set Star",
                    min = 1, max = 8, step = 1,
                    order = 1,
                    icon = rt.iconPath:format(1),
				},
				[2] = {
					name = "Circle", type = "range", desc = "Set Circle",
                    min = 1, max = 8, step = 1,
                    order = 2,
                    icon = rt.iconPath:format(2),
				},
				[3] = {
					name = "Diamond", type = "range", desc = "Set Diamond",
                    min = 1, max = 8, step = 1,
					order = 3,
                    icon = rt.iconPath:format(3),
				},
				[4] = {
					name = "Triangle", type = "range", desc = "Set Triangle",
                    min = 1, max = 8, step = 1,
					order = 4,
                    icon = rt.iconPath:format(4),
				},
				[5] = {
					name = "Moon", type = "range", desc = "Set Moon",
                    min = 1, max = 8, step = 1,
					order = 5,
                    icon = rt.iconPath:format(5),
				},
				[6] = {
					name = "Square", type = "range", desc = "Set Square",
                    min = 1, max = 8, step = 1,
					order = 6,
                    icon = rt.iconPath:format(6),
				},
				[7] = {
					name = "Cross", type = "range", desc = "Set Cross",
                    min = 1, max = 8, step = 1,
					order = 7,
                    icon = rt.iconPath:format(7),
				},
				[8] = {
					name = "Skull", type = "range", desc = "Set Skull",
                    min = 1, max = 8, step = 1,
					order = 8,
                    icon = rt.iconPath:format(8),
				},
			},
        }
    }
 }
 
function rt:checkdisabled(index)
    rt:Print(index)
    if string.len(rt.db.profile.assignment[index]) > 0 then
        return true
    else
        return false
    end
end

-- Set the Raidkillorder (which is changed, new value)
function rt:setorder(index, value)
    --Set the Order in the db
    for k,v in ipairs(rt.db.profile.order) do
        -- New Value is lower than the orign
        if rt.db.profile.order[index] > value then        
            if v >= value and v < rt.db.profile.order[index] then
                rt.db.profile.order[k] = v + 1
            end
        else --New Value is higher than the orign
            if v <= value and v > rt.db.profile.order[index] then
                rt.db.profile.order[k] = v - 1
            end
        end
    end
    rt.db.profile.order[index] = value
    --update order in the optionstable
    rt:UpdateOrder()
end

function rt:UpdateOrder()
    -- update order
    for k,v in ipairs(rt.db.profile.order) do
        rt.options.args.killorder.args[k].order = rt.db.profile.order[k]
    end
    -- update the view
    rt:UpdateTooltip()
end

-- report in a channel (which channel)
function rt:Report(index)
    local output = {}
    local beforeoutput = {}
    local where, typ = nil
    local i = 0
    
    -- create table with non numeric entries
    for k,v in pairs(rt.db.profile.assignment) do 
        if v ~= '' and v~= nil then
            beforeoutput[rt.db.profile.order[k] + 1] = '. I {rt'..k..'} I '..v
        end
    end  
    -- clear non numeric entries
    for index, value in pairs(beforeoutput) do 
        i = i + 1
        table.insert(output, i..value) 
    end
    table.insert(output,1, '....::: Raidtargetassignment / Killorder :::....')
    -- if something is assigned
    if table.getn(output) > 1 then
        if index == 'SAY' then
            where = 'SAY'
        elseif index == 'PARTY' then
            where = 'PARTY'
        elseif index == 'RAID' then
            where = 'RAID'
        elseif index == 'OFFICER' then
            where = 'OFFICER'
        else
            where = 'WHISPER'
            typ = UnitName('target')
        end
        -- report it
        for k,v in pairs(output) do 
            if string.len(v) > 0 then
                SendChatMessage(v,where, nil, typ)
            end
        end
    end

end

--assign  a raidicon to a Player (which should be assigned, the player)
function rt:assignPlayer(index, name)
    -- only player which are in the (raid)group
    if UnitExists(name) then
        rt.db.profile.assignment[index] = name
        rt:UpdateRemoveRaidicon()
    else
        rt:Print('Player is not in your group')
    end
end

-- remove a Raidtarget(which should be removed)
function rt:removeraidtarget(index)
    rt.db.profile.assignment[index] = ''
    rt:UpdateRemoveRaidicon()
end

-- updates the Removelist with the assigned players
function rt:UpdateRemoveRaidicon()
    local menu = {}
    local menuitem = {}
    for k,v in pairs(rt.db.profile.assignment) do
        if v ~= '' and v ~= nil then
            menuitem = {name = v,
                        desc = 'Remove the '..rt.iconname[k]..' from '..v..'.',
                        type = 'execute',
                        icon = rt.iconPath:format(k),
                        order = k,
                        }
            table.insert(menu,k,menuitem)
        end
    end
    
    rt.options.args.removeraidtarget.args = menu
    rt:UpdateTooltip()
end

-- Initialize
function rt:OnInitialize()

    self:RegisterChatCommand("/rt", self.options)
    self.OnMenuRequest = rt.options
    rt:RegisterDB("mydb")
    rt:RegisterDefaults("profile", {assignment = {'','','','','','','',''},
                                    order = {4,3,5,8,6,7,2,1}})
    self:UpdateOrder()  
    rt:UpdateRemoveRaidicon()
end

function rt:OnEnable()
    self:AddChannellistcolor()
end

-- GetChatColour (thx to Grimreaper)
-- name = Chatname, output: Colorstring form the Chat
local function GetChatColour(name)
	local info = ChatTypeInfo[name]
    local clr = {r = 0.5, g = 0.5, b = 0.5}
	if (info) then
		clr.r = (info.r or 0.5)
		clr.g = (info.g or 0.5)
		clr.b = (info.b or 0.5)
	end
	return '|cff'..string.format("%02x%02x%02x",clr.r*255, clr.g*255, clr.b*255)
end

-- GetChannelList (thx to Grimreaper)
-- get all important Chatnames / Colors
function rt:GetChannelList()
	local cList = {}
	local l = {"WHISPER", "RAID", "OFFICER", "PARTY", "SAY"}
	for k,v in pairs(l) do
		tinsert(cList, {name = v, colour = GetChatColour(v)})
	end
    return cList
end

-- AddChannellistcolor
-- Update the Menu with the Channelcolors
function rt:AddChannellistcolor()
    local cList = rt:GetChannelList()
    for k,channel in pairs(cList) do
       rt.options.args.report.args[channel.name].name = channel.colour..rt.options.args.report.args[channel.name].name
    end
    self:UpdateTooltip()
end