


function RaidSnapshot:printUnit( unit )
    self:Print( "Name: " .. tostring( unit.name ) )
    self:Print( "Unitid: " .. tostring( unit.unitid ) )
    self:Print( "Class: " .. tostring( unit.class ) )
    self:Print( "Subgroup: " .. tostring( unit.subgroup ) )
    self:Print( "Raidrank: " .. tostring( unit.rank ) )
end



function RaidSnapshot:isPlayerRaidLeader( )
    return IsRaidLeader( )

    --local player = self.rosterlib:GetUnitObjectFromUnit( "player" )

    --return ( 2 == player.rank )
end



function RaidSnapshot:isPlayerInBattlefield( )
    for i = 1, MAX_BATTLEFIELD_QUEUES do
        status = GetBattlefieldStatus( i )

        if ( "active" == status ) then
            return true
        end
    end

    return false
end



function RaidSnapshot:isUnitEqual( u1, u2 )
    return ( ( u1.subgroup == u2.subgroup )
            and ( u1.name == u2.name )
                and ( u1.class == u2.class )
                and ( u1.rank == u2.rank ) )
end



function RaidSnapshot:Debug( str )
    if ( self.isDebug ) then
        self:Print( str )
    end
end



function RaidSnapshot:raidIdFromUnit( unit )
    --
    -- TODO: BUG: What if the current group is only a Party and not a
    --            Raid group?
    --            Current implementation: Assume we are in a raid group.
    --

    local pattern = "raid(%d+)"
    return string.match( unit.unitid, pattern )
end



function RaidSnapshot:getUnitByName( name )
    return self.rosterlib:GetUnitObjectFromName( name )
end



function RaidSnapshot:findUnit( roster, name )
    --
    -- Find a unit in the given roster
    --

    for i, unit in ipairs( roster ) do
        if ( unit.name == name ) then
            return unit
        end
    end

    return nil
end



function RaidSnapshot:isSubgroupFullEx( roster, subgroup, maxSubgroupSize )
    local subgroupUnits = self:getSubgroupUnits( roster, subgroup )
    local size = table.getn( subgroupUnits )

    return ( size >= maxSubgroupSize )
end



function RaidSnapshot:isSubgroupFull( roster, subgroup )
    return ( self:isSubgroupFullEx( roster, subgroup, self.MAX_SUBGROUP_SIZE ) )
end



function RaidSnapshot:getSubgroupUnits( roster, subgroup )
    --
    -- Get the units in the given subgroup.
    --

    local subgroupUnits = { }

    for i, u in pairs( roster ) do
        if ( subgroup == u.subgroup ) then
            table.insert( subgroupUnits, u )
        end
    end

    return subgroupUnits
end



function RaidSnapshot:getRandomUnitFromSubgroup( snapshot, current, subgroup )
    --
    --
    -- Find the unit that does not belong in this group.
    --
    --

    for i, currentUnit in pairs( current ) do
        if ( currentUnit.subgroup == subgroup ) then
            storedUnit = RaidSnapshot:findUnit( snapshot, currentUnit.name )

            -- Was this unit stored in the snapshot?
            if ( not storedUnit ) then
                return currentUnit
            end
        end
    end

    -- No random unit found in this subgroup
    return nil
end



function RaidSnapshot:tcopy( t )
    local tnew = { }

    for i, v in pairs( t ) do
        tnew[ i ] = v
    end

    return tnew
end



function RaidSnapshot:fullnameToSinglename( fullname )
    --
    -- Remove the realm from the full name.
    -- e.g. "Breezze-Hellscream" becomes "Breezze"
    --

    local REALM_SEPARATOR = "-"
    local pos = strfind( fullname, REALM_SEPARATOR )

    if ( nil == pos ) then
        return fullname
    end

    return strsub( fullname, 1, pos - 1 )
end



function RaidSnapshot:getRaidUnits( )
    --
    -- Get the raid roster from the current group.
    --

    local units = { }

    for u in self.rosterlib:IterateRoster( ) do -- Skipping pets
        table.insert( units, self:tcopy( u ) )
    end

    return units
end


