


function RaidSnapshot:getSnapshot( id )
    return self.db.profile.snapshots[ self:makeSnapshotId( id ) ]
end



function RaidSnapshot:removeSnapshot( id )
    self.db.profile.snapshots[ self:makeSnapshotId( id ) ] = nil
end



function RaidSnapshot:copySnapshot( srcId, destId )
    src = self.db.profile.snapshots[ srcId ]

    if ( not src ) then
        return false
    end

    self.db.profile.snapshots[ destId ] = self:tcopy( src )

    return true
end



function RaidSnapshot:renameSnapshot( srcId, destId )
    -- NOTE: BUG: Code duplication. See copySnapshot( ).

    src = self.db.profile.snapshots[ srcId ]

    if ( not src ) then
        return false
    end

    self.db.profile.snapshots[ destId ] = src

    self.db.profile.snapshots[ srcId ] = nil

    return true
end



function RaidSnapshot:makeSnapshotId( id )
    --
    -- Normalize the id for use as array key.
    --

    if ( nil == id or 0 == strlen( id ) ) then
        return "default"
    end

    return id
end



function RaidSnapshot:clearAll( )
    --
    -- Remove all stored snapshot.
    --

    self.db.profile.snapshots = { }
end



function RaidSnapshot:verifySnapshotExists( id )
    local snapshot = self:getSnapshot( id )

    if ( nil == snapshot ) then
        self:Print( "Snapshot \"" .. self:makeSnapshotId( id ) .. "\" does not exist." )
    end

    return snapshot
end



function RaidSnapshot:storeCurrent( id )
    --
    -- Store a snapshot of the current group.
    --

    return self:setSnapshot( id, self:getCurrent( ) )
end



function RaidSnapshot:getCurrent( )
    --
    -- Get a snapshot of the current group.
    --

    return self:getRaidUnits( )
end



function RaidSnapshot:setSnapshot( id, snapshot )
    self.db.profile.snapshots[ self:makeSnapshotId( id ) ] = snapshot

    return snapshot
end



function RaidSnapshot:getAllIds( )
    --
    -- Get a list of keys for the stored snapshots.
    --

    local ids = { }

    for id, snapshot in pairs( self.db.profile.snapshots ) do
        table.insert( ids, id )
    end

    return ids
end



function RaidSnapshot:listAllIds( id )
    local ids = self:getAllIds( )

    str = "Stored snapshot IDs: "

    for i, id in ipairs( self:getAllIds( ) ) do
        str = str .. id .. ", "
    end

    self:Print( str )
end



function RaidSnapshot:printSnapshot( snapshot )
    local nGroups = 8

    if ( nil == snapshot ) then
        self:Print( "Snapshot not found." )
    end

    for subgroup = 1, nGroups do
        units = self:getSubgroupUnits( snapshot, subgroup )

        str = "   Group " .. tostring( subgroup ) .. ": "

        -- Make a list of unit names in this group.
        for i, unit in pairs( units ) do
            str = str .. unit.name

            if ( 0 ~= unit.rank ) then
                str = str .. "(A)"
            end

            str = str.. ", "
        end

        -- Empty groups don't have to be displayed.
        if ( table.getn( units ) > 0 ) then
            self:Print( str )
        end
    end
end



