



function RaidSnapshot:restore( id, unit )
    --
    -- Restore a snapshot to the current raid.
    --

    snapshot = self:getSnapshot( id )
    current = self:getCurrent( )

    if ( nil == snapshot ) then
        self:Print( "There is no snapshot to be restored with id " .. tostring( id ) )
        return
    end


    -- TODO: Check current player's raid rank.
    --       Current implementation: Assume player is the raid leader.

    if ( not ( self:isPlayerRaidLeader( ) or IsRaidOfficer( ) ) ) then
        self:Print( "You must be raid leader or assistant to restore a snapshot" )
        return
    end

    if ( not self:isPlayerRaidLeader( ) ) then
        self:Print( "Warning: You're not the raid leader. Raid ranks will not be restored." )
    end


    for i, storedUnit in pairs( snapshot ) do
        if ( nil == unit or storedUnit.name == unit.name ) then
            currentUnit = self:findUnit( current, storedUnit.name )

            if ( nil == currentUnit ) then
                self:Debug( "Current unit is nil. storedunitname = " .. tostring( storedUnit.name ) )
            else
                self:Debug( "Checking player '" .. storedUnit.name .. "'" )

                self:restoreUnit( current, snapshot, storedUnit, currentUnit )
            end

            if ( unit ~= nil ) then
                return
            end
        end
    end
end



function RaidSnapshot:restoreSingleUnit( id, currentUnit )
    local snapshot = self:getSnapshot( id )
    local current = self:getCurrent( )

    if ( nil == snapshot ) then
        -- TODO: Add debug
        return false
    end

    local storedUnit = self:findUnit( snapshot, currentUnit.name )

    if ( not storedUnit ) then
        return false
    end

    self:restoreUnit( current, snapshot, storedUnit, currentUnit )

    return true
end



function RaidSnapshot:restoreUnit( currentSnapshot, snapshot, storedUnit, currentUnit )
    -- Restore the raidrank first.
    self:restoreRaidRank( currentSnapshot, snapshot, storedUnit, currentUnit )

    -- Now restore the groups.
    self:restoreGroup( currentSnapshot, snapshot, storedUnit, currentUnit )
end



function RaidSnapshot:restoreRaidRank( currentSnapshot, snapshot, storedUnit, currentUnit )
    if ( not self:isPlayerRaidLeader( ) ) then
        return
    end

    if ( storedUnit.rank == currentUnit.rank ) then
        -- Raid rank already has the right setting. We're done here.
        return
    end

    self:Debug( "Changing rank from " .. tostring( currentUnit.rank ) .. " to " .. tostring( storedUnit.rank ) )
    if ( 0 == storedUnit.rank ) then
        DemoteAssistant( storedUnit.name )
    else
        -- NOTE: If the unit was a raid leader before, ignore it and promote
        --       him to Raid Assistant (rank 1)
        PromoteToAssistant( storedUnit.name )
    end
end



function RaidSnapshot:restoreGroup( current, snapshot, storedUnit, currentUnit )
    if ( storedUnit.subgroup == currentUnit.subgroup ) then
        -- The unit is already in the right group. Nothing to do here.
        self:Debug( currentUnit.name .. " is already in the right group" )
        return
    end

    if ( RaidSnapshot:isSubgroupFull( current, storedUnit.subgroup ) ) then
        -- Swap with a random unit that was not in the original raid group.
        randomUnit = RaidSnapshot:getRandomUnitFromSubgroup( snapshot, current, storedUnit.subgroup )

        if ( nil == randomUnit ) then
            -- This can only happen when everyone from the snapshot in this group is
            -- also in the current group. Unless something strange happened in randomUnit.
            self:Print( "Error while restoring " .. storedUnit.name )
            return
        end

        self:Debug( "Swapping to group " .. tostring( currentUnit.subgroup ) .. ": " .. currentUnit.name .. " with " .. randomUnit.name )
        SwapRaidSubgroup( self:raidIdFromUnit( randomUnit ), self:raidIdFromUnit( currentUnit ) )



        --
        -- Swap the subgroups in the objects
        -- This is required in order to prevent double swaps
        -- We don't have to wait for acknowledgement of the swap, but
        -- we'll send the changes in one batch.
        --

        tmp = randomUnit.subgroup
        randomUnit.subgroup = currentUnit.subgroup
        currentUnit.subgroup = tmp

    else
        -- Subgroup is not full yet
        self:Debug( "Moving " .. currentUnit.name .. " from group " .. currentUnit.subgroup .. " to group " .. tostring( storedUnit.subgroup ) )
        SetRaidSubgroup( self:raidIdFromUnit( currentUnit ), storedUnit.subgroup )
        currentUnit.subgroup = storedUnit.subgroup
    end
end -- storedunit subgroup = currentunit subgroup



