


--
-- TODO: Set timed function for auto restore.
--



function RaidSnapshot:initializeAutoRestore( )
    if ( nil == self.db.profile.autoRestoreUnits ) then
        self.db.profile.autoRestoreUnits = { }
    end

    if ( nil == self.db.autoRestoreQueuedUnits ) then
        self.db.profile.autoRestoreQueuedUnits = { }
    end

    -- AceEvent2.0 is required for RosterLib-2.1 events.
    self.AceEvent2 = AceLibrary( "AceEvent-2.0" )
    self.AceEvent2:RegisterEvent( "RosterLib_UnitChanged",
                                 function ( ... )
                                     RaidSnapshot:RosterLib_UnitChanged( ... )
                                 end )
end



function RaidSnapshot:enableAutoRestore( )
    self:Hook( "AcceptBattlefieldPort" )
end



function RaidSnapshot:disableAutoRestore( )
    self:Unhook( "AcceptBattlefieldPort" )
end



function RaidSnapshot:isAutoRestore( )
    return RaidSnapshot.db.profile.isBgAutoRestore
end



function RaidSnapshot:setAutoRestore( isEnabled )
    RaidSnapshot.db.profile.isBgAutoRestore = isEnabled
end



function RaidSnapshot:isInBattlefield( )
    --
    -- Is the player currently in a battlefield?
    --

    for i = 1, MAX_BATTLEFIELD_QUEUES do
        local status, mapName, instanceId, minlevel, maxlevel = GetBattlefieldStatus( i )

        if ( "active" == status ) then
            return true;
        end
    end
    return false
end



function RaidSnapshot:AcceptBattlefieldPort( index, accept )
    local snapshot = nil
    
    if ( self:isPlayerInBattlefield( ) ) then
        -- Use the snapshot that was created before entering the battleground,
        snapshot = self:getSnapshot( "bgautosave" )
    else
        self:Print( "Autosaving snapshot \"bgautosave\"" )
        snapshot = self:storeCurrent( "bgautosave" )
    end

    
    self.db.profile.autoRestoreUnits = { }
    self.db.profile.autoRestoreQueuedUnits = { }
    for i, unit in pairs( snapshot ) do
        self.db.profile.autoRestoreUnits[ unit.name ] = unit
    end

    return self.hooks["AcceptBattlefieldPort"]( index, accept )
end



function RaidSnapshot:autoRestore( )
    if ( not self:isPlayerInBattlefield( ) ) then
        return
    end

    --
    -- Restore everyone that was queued for auto restore.
    --

    if ( self:isPlayerRaidLeader( ) ) then
        for i, unit in pairs( self.db.profile.autoRestoreQueuedUnits ) do
            self:autoRestoreUnit( unit )
        end
    end
end



function RaidSnapshot:autoRestoreUnit( unit )
    if ( ( not self:isPlayerInBattlefield( ) )
        or self:hasBeenAutoRestored( unit ) ) then

        return
    end

    self:Debug( "Checking " .. tostring( unit.name ) )

    if ( self:isPlayerRaidLeader( ) ) then
        self:Debug( "Auto restoring new unit " .. unit.name )
        self:restoreSingleUnit( "bgautosave", unit )
    end
end



function RaidSnapshot:isAutoRestoreUnit( unit )
    return self.db.profile.autoRestoreUnits[ unit.name ]
end



function RaidSnapshot:hasBeenAutoRestored( unit )
    --
    -- Check whether the unit is in the right group now.
    -- and whether he has the right attributes.
    --

    if ( not self:isAutoRestoreUnit( unit ) ) then
        self.db.profile.autoRestoreQueuedUnits[ unit.name ] = nil
        return true
    end

    local snapshot = self:getSnapshot( "bgautosave" )

    if ( nil == snapshot ) then
        return false
    end

    local storedUnit = self:findUnit( snapshot,  unit.name )

    if ( nil == storedUnit ) then
        return false
    end

    if ( self:isUnitEqual( unit, storedUnit ) ) then
        self:Debug( "Unit restored: " .. unit.name )

        self.db.profile.autoRestoreUnits[ unit.name ] = nil
        self.db.profile.autoRestoreQueuedUnits[ unit.name ] = nil
        return true
    end

    return false
end



function RaidSnapshot:RosterLib_UnitChanged(new_unitid, new_name, new_class, new_subgroup, new_rank,
                                            old_name, old_unitid, old_class, old_subgroup, old_rank,
                                            new_role, new_ML,
                                            old_role, old_ML)

    if ( false ) then
        self:Debug( " " )
        self:Debug( "UnitChanged: " )
        self:Debug( string.format( "UnitID:   %q => %q", tostring( old_unitid ), tostring( new_unitid ) ) )
        self:Debug( string.format( "Name:     %q => %q", tostring( old_name ), tostring( new_name ) ) )
        self:Debug( string.format( "Class:    %q => %q", tostring( old_class ), tostring( new_class ) ) )
        self:Debug( string.format( "Subgroup: %q => %q", tostring( old_subgroup ), tostring( new_subgroup ) ) )
        self:Debug( string.format( "Rank:     %q => %q", tostring( old_rank ), tostring( new_rank ) ) )
        self:Debug( string.format( "Role:     %q => %q", tostring( old_role ), tostring( new_role ) ) )
        self:Debug( string.format( "ML:       %q => %q", tostring( old_ML ), tostring( new_ML ) ) )
    end


    local unitChanged =
        nil ~= new_unitid
        and ( new_subgroup ~= old_subgroup
             or new_rank ~= old_rank
                 or new_role ~= old_role
                 or new_ML ~= old_ML )

    local hasNotLeft =
        nil ~= new_unitid
        and nil ~= new_name
        and nil ~= new_subgroup
        and nil ~= new_class

    local isPet =
        ( nil ~= new_class and "PET" == new_class )
        or ( nil ~= old_class and "PET" == old_class )


    if ( ( nil ~= new_unitid ) and ( not isPet ) ) then
        local unit = self.rosterlib:GetUnitObjectFromUnit( new_unitid )

        if ( self:isAutoRestoreUnit( unit ) ) then
            self.db.profile.autoRestoreQueuedUnits[ unit.name ] = unit
            self:autoRestore( )
        end
    end

    local isPlayerPromoted =
        nil ~= new_unitid
        and UnitIsUnit( "player", new_unitid )
        and new_rank ~= old_rank
        and 2 == new_rank

    if ( isPlayerPromoted ) then
        self:Print( "Player is promoted" )
        self:autoRestore( )
    end

    return nil
end


