--@Name:RaidRogue (A Raiding Rogue's Personal Assistant)
--@Author: Adoren
--@Version: 1.7

--===============================================================================
--[[
TO DO LIST:
	-RaidRogue Status Frame
		-No Bugs Found. Ready for Release.
	-RaidRogue Options GUI
		-No Bugs Found. Ready for Release.
	-RogueReadyCheck
		-No Bugs Found. Ready for Release.
	-RogueVersionCheck
		-No Bugs Found. Ready for Release.
	-Continue PvE Stat Tracker
		-No Bugs Found. Ready For Release.
NOTES:
*This is my first addon, so if you're looking around for something to play with to learn LUA, this is a good place to start, because it's simple code. ]]--
--===============================================================================

--===============================================================================
--You Should Not Be Editing Beneath this Point unless you know a bit of LUA.
--===============================================================================

--===== Tracking Benchmark Variables =====
RR_BENCH_FLASH=20;
RR_BENCH_POISONS={10,10,10,10,10};
RR_BENCH_ANESTHETIC=10;
RR_BENCH_DURABILITY=75; --Must be greater than or equal to 60. Note: This cannot be edited in game.
RR_BENCH_BANDAGES=25;
RR_BENCH_AMMO=200;
RR_MAXCHARS=20;

--====== Default Tracking Benchmark Variables =====
RR_DEFAULT_FLASH=20;
RR_DEFAULT_POISON=10;
RR_DEFAULT_DURABILITY=75; --Must be greater than or equal to 60. Note: this cannot be edited in game.
RR_DEFAULT_BANDAGES=25;
RR_DEFAULT_AMMO=200;
RR_DEFAULT_MAXCHARS=20;

--===== Custom Track Variables =====
RR_CUSTOMTRACKS={"","",""}
RR_CUSTOMBENCHES={10,10,10};
RR_CUSTOMTRACKINPUTS={}; --Initiated after 'ADDON_LOADED'
RR_CUSTOMBENCHINPUTS={}; --Initiated after 'ADDON_LOADED'
RR_CUSTOMTRACKOUTPUTS={}; --Initiated after 'ADDON_LOADED'

--===== Default Custom Track Variables =====
RR_DCUSTOMTRACK="";
RR_DCUSTOMBENCH=10;

--===== Overall Status =====
RR_REAGENTCHECK=true;
RR_AMMOCHECK=true;
RR_POISONCHECK=true;
RR_DURABILITYCHECK=true;
RR_BANDAGECHECK=true;
RR_CUSTOMCHECK=true;

--===== Bandages =====
RR_ITEM_BANDAGES={"Heavy Netherweave","Neatherweave","Heavy Runecloth","Runecloth","Heavy Mageweave","Mageweave","Heavy Silk","Silk","Heavy Wool","Wool","Heavy Linen","Linen"};

--=====	Reagents =====
RR_ITEM_FLASH = "Flash Powder";

--===== Poisons =====
RR_ITEM_POISONS={"Crippling Poison","Deadly Poison","Mind--numbing Poison","Instant Poison","Wound Poison"};
RR_ITEM_DPOISONS={"Crippling Poison","Deadly Poison","Mind-numbing Poison","Instant Poison","Wound Poison"};
RR_ITEM_ANESTHETIC="Anesthetic Poison";
RR_POISONOUTPUTS={}; --Initiated after 'ADDON_LOADED'

--===== Settings Variables =====
RR_LOCKED=false;
RR_REFRESH=false;
RR_COLOR=true;
RR_STANDBY=false;
RR_SHOWBENCH=false;
RR_ROGUELOAD=false;
RR_AUTOALERTS=true;
RR_AUTOACHAT=true;
RR_AUTOASYSTEM=true;
RR_STATUSHEIGHT=262;
RR_STATUSWIDTH=215;
RR_STATUSBWIDTH=RR_STATUSWIDTH+20;
RR_AUTOREPLYMSG="I am currently fighting a boss. Please send me a tell again later."
RR_AUTOREPLY=false;
RR_AUTORPARTY=false;
RR_AUTORRAID=false;
RR_STATTRACKER=true;
RR_OFFICERREQUESTSONLY=false;

--===== Stat Tracking Variables =====
RR_COUNTTRIVIAL=true;

--Session
RR_KILLINGBLOWS=0;
RR_BOSSKILLS=0;
RR_SELFDEATHS=0;
RR_RAIDWIPES=0;
RR_LOOTSACQUIRED=0;
RR_TRASHKILLS=0;

--Lifetime
RR_OKILLINGBLOWS=0;
RR_OBOSSKILLS=0;
RR_OSELFDEATHS=0;
RR_ORAIDWIPES=0;
RR_OLOOTSACQUIRED=0;
RR_OTRASHKILLS=0;

--Crit Tracker
RR_CRITLISTNUM=5;
RR_CRITLISTABILITIES={"","","","",""};
RR_CRITLIST={0,0,0,0,0};
RR_CRITLISTCRITS={"","","","",""};

RR_FILTERLIST={"Shockwave"};
RR_DFILTERLIST={"Shockwave"};
RR_FILTERS=true;

--===== Other Variables =====
RR_OVERALLSTATUS="|cFF00FF00Ready|r";
RR_STATUSMAXCHARS=10;

--===== Instance/Raid Boss Table Variables =====
--=========================================
--The Bosses of Eastern Kingdoms  Instances
--=========================================
RR_DEADMINES={"Eastern Kingdoms","The Deadmines","Rhahk'Zor","Sneed","Sneed's Shredder","Gilnid","Cookie","Mr. Smite","Captain Greenskin","Edwin VanCleef"};
RR_SHADOWFANG={"Eastern Kingdoms","Shadowfang Keep","Archmage Arugal","Baron Silverlaine","Commander Springvale","Deathsworn Captain","Fenrus the Devourer","Odo the Blindwatcher",
	"Razorclaw the Butcher","Rethilgore","Wolf Master Nandos"};
RR_STOCKADE={"Eastern Kingdoms","The Stockade","Bazil Thredd","Bruegal Ironknuckle","Dextren Ward","Hamhock","Kam Deepfury","Targorr the Dread"};
RR_GNOMER={"Eastern Kingdoms","Gnomeregan","Dark Iron Ambassador","Crowd Pummeler 9--60","Electrocutioner 6000","Grubbis","Chomper","Mekgineer Thermaplugg","Viscous Fallout"};
RR_SCARLETGY={"Eastern Kingdoms","Scarlet Monastery","Interrogator Vishas","Fallen Champions","Azshir the Sleepless","Ironspine","Bloodmage Thalnos"};
RR_SCARLETLIB={"Eastern Kingdoms","Scarlet Monastery","Houndmaster Loksey","Arcanist Doan"};
RR_SCARLETARM={"Eastern Kingdoms","Scarlet Monastery","Herod"};
RR_SCARLETCATH={"Eastern Kingdoms","Scarlet Monastery","High Inquisitor Fairbanks","High Inquisitor Whitemane","Scarlet Commander Mograine"};
RR_ULDAMAN={"Eastern Kingdoms","Uldaman","Archaedas","Digmaster Shovelphlange","Galgann Firehammer","Grimlok","Ironaya","Magregan Deepshadow","Obsidian Sentinel","Revelosh"};
RR_SUNKTEMPLE={"Eastern Kingdoms","The Temple of Atal'Hakkar","Atal'alarion","Avatar of Hakkar","Dreamscythe","Jammal'an the Prophet","Morphaz","Ogom the Wretched","Hazzas","Shade of Eranikus","Weaver"};
RR_BLACKROCKDEP={"Eastern Kingdoms","Blackrock Depths","Commander Gor'shak","High Interrogator Gerstahn","Hurley Blackbreath","Lokhtos Darkbargainer","Phalanx","Plugger Spazzring","Private Rocknot",
	"Ribbly Screwspigot","Ambassador Flamelash","Bael'Gar","Emperor Dagran Thaurissan","Fineous Darkvire","General Angerforge","Golem Lord Argelmach","Lord Incendius",
	"Lord Roccor","Magmus","Panzor the Invincible","Princess Moira Bronzebeard","Pyromancer Loregrain","Anger'rel","Doom'rel","Dope'rel","Gloom'rel","Hate'rel","Seeth'rel","Vile'rel"};
RR_LOWERBLACK={"Eastern Kingdoms","Lower Blackrock Spire","Highlord Omokk","Shadow Hunter Vosh'gajin","War Master Voone","Urok Doomhowl","Mother Smolderweb","Halycon","Gizrul the Slavener"," Overlord Wyrmthalak"};
RR_UPPERBLACK={"Eastern Kingdoms","Upper Blackrock Spire","Pyroguard Emberseer","Solakar Flamewreath","Goraluk Anvilcrack","Gyth","Rend Blackhand","The Beast","Lord Valthalak","General Drakkisath"};
RR_STRAT={"Eastern Kingdoms","Stratholme","Archivist Galford","Atiesh","Balnazzar","Baron Rivendare","Baroness Anastari","Cannon Master Willey","Fras Siabi","Hearthsinger Forresten","Jarien",
	"Sothos","Magistrate Barthilas","Maleki the Pallid","Malor the Zealous","Nerub'enkan","Postmaster Malown","Ramstein the Gorger","Skul","Stonepsine","Timmy the Cruel"};
RR_SCHOLO={"Eastern Kingdoms","Scholomance","Darkmaster Gandling","Death Knight Darkreaver","Doctor Theolen Krastinov","Instructor Malicia","Janice Barov","Kirtonos the Herald","Kormok","Lady Illucia Barov",
	"Lord Alexei Barov","Lord Blackwood","Lorekeeper Polkelt","Marduk Blackpool","Ras Frostwhisper","Rattlegore","The Ravenian","Vectus"};
RR_MAGISTERS={"Easter Kingdoms","Magisters' Terrace","Sellin Fireheart","Vexallus","Priestess Delrissa","Kael'thas Sunstrider"};

--=================================
--The Bosses of Kalimdor  Instances
--=================================
RR_RAGEFIRE={"Kalimdor","Ragefire Chasm","Bazzalan","Jergosh the Invoker","Ogglefint","Taragaman the Hungerer"};
RR_WAILINGCAV={"Kalimdor","Wailing Caverns","Mutanus the Devourer","Kresh","Deviate Faerie Dragon","Skum","Verdan the Everliving","Lord Serpentis","Lord Pythas","Lord Cobrahn","Lady Anacondra"};
RR_BLACKFATH={"Kalimdor","Blackfathom Deeps","Aku'mai","Baron Aquanis","Gelihast","Ghamoo--ra","Lady Sarevess","Lorgus Jett","Old Serra'kis","Twilight Lord Kelris"};
RR_RFK={"Kalimdor","Razorfen Kraul","Agathelos the Raging","Aggem Thorncurse","Blind Hunter","Charlga Razorflank","Death Speaker Jargba","Earthcaller Halmgar","Overlord Ramtusk","Roogug"};
RR_RFD={"Kalimdor","Razorfen Downs","Amnennar the Coldbringer","Glutton","Mordresh Fire Eye","Plaguemaw the Rotting","Ragglesnout","Tuten'kash"};
RR_ZULFARRAK={"Kalimdor","Zul'Farrak","Antu'sul","Chief Ukorz Sandscalp","Dustwraith","Gahz'rilla","Hydromancer Velratha","Nekrum Gutchewer","Ruuzlu","Sandarr Dunereaver","Sandfury Executioner",
	"Shadowpriest Sezz'ziz","Theka the Martyr","Witch Doctor Zum'rah","Zerillis"};
RR_MARA={"Kalimdor","Maraudon","Celebras","Lord Vyletongue","Maraudos","Meshlok the Harvester","Noxxion","Razorlash","Veng","Landslide","Princess Theradras","Rotgrip","Tinkerer Gizlock"};
RR_DMWEST={"Kalimdor","Dire Maul","Illyanna Ravenoak","Ferra","Immol'thar","Lord Hel'nurath","Magister Kalendris","Prince Tortheldrin","Tendris Warpwood","Tsu'zee"};
RR_DMEAST={"Kalimdor","Dire Maul","Alzzin the Wildshaper","Hydrospawn","Isalien","Lethtendris","Pimgib","Pusillin","Zevim Thornhoof"};
RR_DMNORTH={"Kalimdor","Dire Maul","Captain Kromcrush","Cho'Rush the Observer","Guard Fengus","Guard Mol'dar","Guard Slip'kik","King Gordok","Stomper Kreeg"};
RR_OLDHILLS={"Kalimdor","Old Hillsbrad Foothills","Lieutenant Drake","Captain Skarloc","Epoch Hunter"};
RR_BLACKMORASS={"Kalimdor","Black Morass","Chrono Lord Deja","Temporus","Aeonus"};

--=================================
--The Bosses of Outlands  Instances
--=================================
RR_RAMPARTS={"Outland","Hellfire Ramparts","Watchkeeper Gargolmar","Omor the Unscarred","Vazruden","Nazan"};
RR_BFURNACE={"Outland","Blood Furnace","The Maker","Broggok","Keli'dan the Breaker"};
RR_SHATTERHALLS={"Outland","Shattered Halls","Grand Warlock Netherkurse","Blood Guard Porung","Warbringer O'mrogg","Warchief Kargath Bladefist"};
RR_SLAVEPENS={"Outland","The Slave Pens","Mennu the Betrayer","Rokmar the Crackler","Quagmirran"};
RR_UNDERBOG={"Outland","The Underbog","Hungarfen","Ghaz'an","Swamplord Musel'ek","The Back Stalker"};
RR_STEAMVAULT={"Outland","The Steamvault","Hydromancer Thespia","Mekgineer Steamrigger","Warlord Kalithresh"};
RR_MANATOMBS={"Outland","Mana Tombs","Pandemonius","Tavarok","Yor","Nexus--Prince Shaffar"};
RR_AUCHCRYPTS={"Outland","Auchenai Crypts","Shirrak the Dead Watcher","Exarch Maladaar"};
RR_SETHHALLS={"Outland","Sethekk Halls","Darkweaver Syth","Anzu","Talon King Ikiss"};
RR_SHADOWLABS={"Outland","Shadow Labyrinth","Ambassador Hellmaw","Blackheart the Inciter","Grandmaster Vorpil","Murmur"};
RR_MECHANAR={"Outland","The Mechanar","Gatewatcher Gyro--Kill","Gatewatcher Iron--Hand","Mechano--Lord Capacitus","Nethermancer Sepethrea","Pathaleon the Calculator"};
RR_BOTANICA={"Outland","The Botanica","Commander Sarannis","High Botanist Freywinn","Thorngrin the Tender","Laj","Warp Splinter"};
RR_ARCATRAZ={"Outland","The Arcatraz","Zereketh the Unbound","Wrath--Scryer Soccothrates","Dalliah the Doomsayer","Warden Mellichar","Harbinger Skyriss"};

--=====================================
--All Zones Requiring 10-People or More
--=====================================
RR_EASTERNKINGDOMSRAIDS={"Karazhan","Zul'Gurub","Molten Core","Blackwing Lair","Naxxramas","Zul'Aman","Sunwell Plateau"};
RR_KALIMDORRAIDS={"Ruins of Ahn'Qiraj","Temple of Ahn'Qiraj","Battle for Mount Hyjal","Onyxia's Lair"};
RR_OUTLANDRAIDS={"Karazhan","Gruul's Lair","Magtheridon's Lair","Serpentshrine Cavern","The Eye","Black Temple"};
RR_ALLRAIDZONES={RR_KALIMDORRAIDS,RR_EASTERNKINGDOMSRAIDS,RR_OUTLANDRAIDS};

--====================================
--A Table of the Instance Boss Tables'
--====================================
RR_KALIMDORINSTANCES={"Kalimdor",RR_RAGEFIRE,RR_WAILINGCAV,RR_BLACKFATH,RR_RFK,RR_RFD,RR_ZULFARRAK,RR_MARA,RR_DMWEST,RR_DMEAST,RR_DMNORTH,
	RR_OLDHILLS,RR_BLACKMORASS};
RR_EASTERNKINGDOMSINSTANCES={"Eastern Kingdoms",RR_DEADMINES,RR_SHADOWFANG,RR_STOCKADE,RR_GNOMER,RR_SCARLETGY,RR_SCARLETLIB,RR_SCARLETARM,RR_SCARLETCATH,
	RR_ULDAMAN,RR_SUNKTEMPLE,RR_BLACKROCKDEP,RR_LOWERBLACK,RR_UPPERBLACK,RR_STRAT,RR_SCHOLO,RR_MAGISTERS};
RR_OUTLANDINSTANCES={"Outland",RR_RAMPARTS, RR_BFURNACE,RR_SHATTERHALLS,RR_SLAVEPENS,RR_UNDERBOG,RR_STEAMVAULT,RR_MANATOMBS,RR_AUCHCRYPTS,RR_SETHHALLS,
	RR_SHADOWLABS,RR_MECHANAR,RR_BOTANICA,RR_ARCATRAZ};
RR_ALLINSTANCEZONES={RR_KALIMDORINSTANCES,RR_EASTERNKINGDOMSINSTANCES,RR_OUTLANDINSTANCES};

--===== Version and Debug Variables =====
RR_VERSION = "1.7";
RR_DEBUG = false;
RR_BETA = false;

--===== Other Lists and Variables =====
RR_RAIDVERSIONNAMES={};
RR_RAIDVERSIONVERSIONS={};
RR_RAIDVERSIONBETAS={}
RR_RAIDREADYNAMES={};
RR_RAIDREADYSTATUS={};

RR_READYSREJECTED=0;
RR_VERSIONSREJECTED=0;

--=========================================
--		Printing Functions
--=========================================

--===== Printing to Chat =====
function DoubleOut(text)
	DEFAULT_CHAT_FRAME:AddMessage(text)
 	UIErrorsFrame:AddMessage(text, 1.0, 1.0, 0, 1, 10)
end

function SystemOut(text)
	UIErrorsFrame:AddMessage(text, 1.0, 1.0, 9, 1, 10)
end

function Out(text)
	DEFAULT_CHAT_FRAME:AddMessage(text);
end

function DebugOut(text)
	if(RR_DEBUG) then
		DEFAULT_CHAT_FRAME:AddMessage(text);
	end
end

--=========================================
--	OnLoad/OnEvent Functions
--=========================================

--===== How to Load RaidRogue =====
function RaidRogue_OnLoad()

	local _,englishClass=UnitClass("player");

	if((englishClass=="ROGUE" and RR_ROGUELOAD==true) or RR_ROGUELOAD==false) then
		this:RegisterEvent("PLAYER_LEAVING_WORLD");
		this:RegisterEvent("PLAYER_ENTERING_WORLD");
		this:RegisterEvent("ADDON_LOADED");
		this:RegisterEvent("VARIABLES_LOADED");
		this:RegisterEvent("BAG_UPDATE");
		this:RegisterEvent("UNIT_INVENTORY_CHANGED");
		this:RegisterEvent("PLAYER_REGEN_ENABLED");
		this:RegisterEvent("PLAYER_REGEN_DISABLED");
		this:RegisterEvent("RAID_ROSTER_UPDATE");
		this:RegisterEvent("PLAYER_MONEY");
		this:RegisterEvent("ZONE_CHANGED_NEW_AREA");
		this:RegisterEvent("CHAT_MSG_WHISPER");
		this:RegisterEvent("CHAT_MSG_ADDON");
		this:RegisterEvent("CHAT_MSG_LOOT");
		this:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
		this:RegisterEvent("PLAYER_DEAD");
		this:RegisterEvent("PARTY_MEMBERS_CHANGED");
		this:RegisterEvent("RAID_ROSTER_UPDATE");

		DoubleOut("|cFFFF0000RaidRogue|r "..RaidRogue_dispVersion(RR_VERSION,RR_BETA).." : Loaded Successfully. Type |cFFFF0000/rr help|r for help.");


		if(RR_STANDBY) then
			RaidRogue_Refresh();
		end
		
	
  		SLASH_RAIDROGUE1 = "/raidrogue";
  		SLASH_RAIDROGUE2 = "/rr";
  		SlashCmdList["RAIDROGUE"] = function(msg)
			RaidRogue_SlashCommandHandler(msg);
			end
	end
end

--===== Update Information according to Events =====
function RaidRogue_OnEvent()

	RaidRogue_getOverallStatus();

	if(event=="ADDON_LOADED") then
		if(arg1=="RaidRogue") then
			--Instantiate these here to make sure that all the XML has been opened and parsed, to ensure the tables are not nil when set.
			RR_CUSTOMTRACKINPUTS={RaidRogueOptions_CustomOneInput,RaidRogueOptions_CustomTwoInput,RaidRogueOptions_CustomThreeInput};
			RR_CUSTOMBENCHINPUTS={RaidRogueOptions_CustomOneSlider,RaidRogueOptions_CustomTwoSlider,RaidRogueOptions_CustomThreeSlider};
			RR_CUSTOMTRACKOUTPUTS={RaidRogue_CustomOne,RaidRogue_CustomTwo,RaidRogue_CustomThree};
			RR_POISONOUTPUTS={RaidRogue_CripPoison,RaidRogue_DeadlyPoison,RaidRogue_MindNumbPoison,RaidRogue_InstantPoison,RaidRogue_WoundPoison};

			RaidRogue_restoreOptions();
			RaidRogue_restoreStats();
			RaidRogue_getOverallStatus();
			RaidRogue_autoAlert();

			DebugOut("Event: RaidRogue Loaded")
		end
	end
	
	if(RR_STANDBY==false and event=="CHAT_MSG_WHISPER") then
		DebugOut("Event: Whisper Received. Sent By: "..arg2);		
		RaidRogue_autoReply(arg1, arg2,"target");
	end

	if((RR_STANDBY==false and RR_STATTRACKER==true and (event=="COMBAT_LOG_EVENT_UNFILTERED" or event=="PLAYER_DEAD"  or event=="CHAT_MSG_LOOT")) or RR_REFRESH) then
		if(GetNumPartyMembers()>0 or GetNumRaidMembers()>0) then
			inInst, instType = IsInInstance()
			if(inInst==1 and instType~="arena" or "pvp" or "none") then
				RaidRogue_calcPVEStats(event,"target");
				DebugOut("Event: Combat Log Event, Player Died, Loot Message.");
			end
		end
	end

	if(event=="CHAT_MSG_ADDON") then
		if(arg1=="RaidRogue") then
			RaidRogue_processAddonRequest(arg2, arg4);
			DebugOut("Event: RaidRogue Addon Request Received from : "..arg4);
		else
			DebugOut("Event: Foreign Addon Request Received from : "..arg4);
		end
	end

	if((RR_STANDBY==false and (event=="PLAYER_ENTERING_WORLD" or event=="UNIT_INVENTORY_CHANGED" or event=="PLAYER_REGEN_ENABLED" or event=="PLAYER_REGEN_DISABLED" or event=="PLAYER_MONEY")) or RR_REFRESH) then
		RaidRogue_Durability();
		DebugOut("Event: World Entered, Inv Change, Regen En/Dis, Player Money")
	end

	if((RR_STANDBY==false and (event=="PLAYER_ENTERING_WORLD" or event=="PLAYER_MONEY" or event=="UNIT_INVENTORY_CHANGED" or event=="BAG_UPDATE")) or RR_REFRESH) then
 		RaidRogue_getReagentCount();	
		RaidRogue_getBandageCount();
		DebugOut("Event: Player Money, Inv Change, Bag Update")
	end

	if((RR_STANDBY==false and event=="ZONE_CHANGED_NEW_AREA") or RR_REFRESH) then
		RaidRogue_getOverallStatus();
		RaidRogue_autoAlert();
		DebugOut("Event: Zone Changed");
	end

	RaidRogue_getOverallStatus();
	DebugOut("Event: OnEvent Method has Completed Running.")

	RR_REFRESH=false;
end

--=========================================
--	   Slash Command Handler
--=========================================

--===== Handling Slash Commands =====
function RaidRogue_SlashCommandHandler(msg)

	local Cmd, SubCmd=RaidRogue_getCmd(msg);

	if((Cmd=="rl" or Cmd=="reloadui") and RR_STANDBY==false) then
		ReloadUI();
	
	elseif (Cmd =="options" and RR_STANDBY==false) then
		RaidRogue_Toggle("RaidRogueOptions");
	
	elseif (Cmd =="refresh") then
		RaidRogue_Refresh();
		Out("|cFFFF0000RaidRogue:|r Mod Forced Refresh Complete.")

	elseif (Cmd =="status") then
		RaidRogue_Toggle("RaidRogue");

	elseif(Cmd=="stats") then
		RaidRogue_Toggle("RaidRogueStats");

	elseif (Cmd =="color" and RR_STANDBY==false) then
		if(SubCmd=="on") then
			RR_COLOR=true;
			Out("|cFFFF0000RaidRogue:|r Color |cFF00FF00Enabled.|r")
			RaidRogue_Refresh();
		elseif(SubCmd=="off") then
			RR_COLOR=false;
			Out("|cFFFF0000RaidRogue:|r Color |cFFFF0000Disabled.|r")
			RaidRogue_Refresh();
		elseif(SubCmd=="") then
			if(RR_COLOR==true) then
				RR_COLOR=false;
				Out("|cFFFF0000RaidRogue:|r Color |cFFFF0000Disabled.|r")
				RaidRogue_Refresh();
			else
				RR_COLOR=true;
				Out("|cFFFF0000RaidRogue:|r Color |cFF00FF00Enabled.|r")
				RaidRogue_Refresh();
			end
		else
			Out("Not a recognized |cFFFF0000RaidRogue|r command.");
		end
	elseif (Cmd =="loadoptions") then
		if(string.find(SubCmd,"rogueonly")) then
			Cmd, SubCmd=RaidRogue_getCmd(SubCmd)

			if(SubCmd=="on") then
				RR_ROGUELOAD=true;
				Out("|cFFFF0000RaidRogue:|r Loads for |cFF00FF00Rogues Only.|r")
				RaidRogue_Refresh();
			elseif(SubCmd=="off") then
				RR_ROGUELOAD=false;
				Out("|cFFFF0000RaidRogue:|r Loads for |cFFFF0000ALL Classes.|r")
				RaidRogue_Refresh();
			elseif(SubCmd=="") then
				if(RR_ROGUELOAD==true) then
					RR_ROGUELOAD=false;
					Out("|cFFFF0000RaidRogue:|r Loads for |cFFFF0000ALL Classes.|r")
					RaidRogue_Refresh();
				else
					RR_ROGUELOAD=true;
					Out("|cFFFF0000RaidRogue:|r Loads for |cFF00FF00Rogues Only.|r")
					RaidRogue_Refresh();
				end
			else
				Out("Not a recognized |cFFFF0000RaidRogue|r command.");
			end
		elseif(SubCmd=="") then
			Out("|cFFFF0000RaidRogue Load Options:|r");
			Out("- |cFFFF0000rogueonly|r: "..RaidRogue_enhanceChat(RR_ROGUELOAD).." Loads RaidRogue for Rogues only.") 
		else
			Out("Not a recognized |cFFFF0000RaidRogue|r command.");
		end

	elseif(Cmd=="standby") then
		if(SubCmd=="on") then
			RR_STANDBY=true;
  			if(RaidRogue:IsVisible() ) then
  			    RaidRogue:Hide();
			end
			Out("|cFFFF0000RaidRogue|r: State is now |cFFFF0000Standby.|r")
			RaidRogue_Refresh();
		elseif(SubCmd=="off") then
			RR_STANDBY=false;
			Out("|cFFFF0000RaidRogue|r: State is now |cFF00FF00Active.|r")
		elseif(SubCmd=="") then
			if(RR_STANDBY==true) then
				RR_STANDBY=false;
				Out("|cFFFF0000RaidRogue|r: State is now |cFF00FF00Active.|r")
			elseif(RR_STANDBY==false) then
				RR_STANDBY=true;
  				if(RaidRogue:IsVisible() ) then
  				    RaidRogue:Hide();
				end
				Out("|cFFFF0000RaidRogue|r: State is now |cFFFF0000Standby.|r")
				RaidRogue_Refresh();
			end
		else
			Out("Not a recognized |cFFFF0000RaidRogue|r command.");
		end
	
	elseif (Cmd =="locked" and RR_STANDBY==false) then
		if(SubCmd=="on") then
			RR_LOCKED=true;
			Out("|cFFFF0000RaidRogue:|r Frames |cFFFF0000Locked.|r")
		elseif(SubCmd=="off") then
			RR_LOCKED=false;
			Out("|cFFFF0000RaidRogue:|r Frames |cFF00FF00UnLocked.|r")
		elseif(SubCmd=="") then
			if(RR_LOCKED==true) then
				RR_LOCKED=false;
				Out("|cFFFF0000RaidRogue:|r Frames |cFF00FF00UnLocked.|r")
			elseif(RR_LOCKED==false) then
				RR_LOCKED=true;
				Out("|cFFFF0000RaidRogue:|r Frames |cFFFF0000Locked.|r")
			end
		else
			Out("Not a recognized |cFFFF0000RaidRogue|r command.");
		end
	
	elseif (Cmd=="benchmarks" and RR_STANDBY==false) then
		if(SubCmd=="on") then
			RR_SHOWBENCH=true;
			Out("|cFFFF0000RaidRogue:|r Benchmarks now |cFF00FF00Shown|r in Status Frame.")
			RaidRogue_Refresh();
		elseif(SubCmd=="off") then
			RR_SHOWBENCH=false;
			Out("|cFFFF0000RaidRogue:|r Benchmarks now |cFFFF0000Hidden|r in Status Frame.")
			RaidRogue_Refresh();
		elseif(SubCmd=="") then
			if(RR_SHOWBENCH==true) then
				RR_SHOWBENCH=false;
				Out("|cFFFF0000RaidRogue:|r Benchmarks now |cFFFF0000Hidden|r in Status Frame.")
				RaidRogue_Refresh();
			else
				RR_SHOWBENCH=true;
				Out("|cFFFF0000RaidRogue:|r Benchmarks now |cFF00FF00Shown|r in Status Frame.")
				RaidRogue_Refresh();
			end
		else
			Out("Not a recognized |cFFFF0000RaidRogue|r command.");
		end
	
	elseif(Cmd=="rogueVC" and RR_STANDBY==false) then
		RaidRogue_getPartyVersionInfo();

	elseif(Cmd=="rogueRC" and RR_STANDBY==false) then
		RaidRogue_getPartyReadyInfo();

	elseif (Cmd=="autoreply" and RR_STANDBY==false) then
		if(string.find(SubCmd,"toggle")) then
			Cmd, SubCmd=RaidRogue_getCmd(SubCmd)
			
			if(string.find(SubCmd,"raid")) then
				Cmd, SubCmd=RaidRogue_getCmd(SubCmd)
				if(SubCmd=="on") then
					RR_AUTORRAID=true;
					Out("|cFFFF0000RaidRogue:|r Auto-Replies now |cFF00FF00Enabled|r while in Raid Groups.")

					if(RR_AUTORPARTY==true and RR_AUTOREPLY==false) then
						RR_AUTOREPLY=true;
					end
					RaidRogue_Refresh();
				elseif(SubCmd=="off") then
					RR_AUTORRAID=false;
					Out("|cFFFF0000RaidRogue:|r Auto-Replies now |cFFFF0000Disabled|r while in Raid Groups.")
					
					if(RR_AUTOREPLY==true) then
						RR_AUTOREPLY=false;
					end
					RaidRogue_Refresh();
				elseif(SubCmd=="") then
					if(RR_AUTORRAID==true) then
						RR_AUTORRAID=false;
						Out("|cFFFF0000RaidRogue:|r Auto-Replies now |cFFFF0000Disabled|r while in Raid Groups.")

						if(RR_AUTOREPLY==true) then
							RR_AUTOREPLY=false;
						end
						RaidRogue_Refresh();
					else
						Out("|cFFFF0000RaidRogue:|r Auto-Replies now |cFF00FF00Enabled|r while in Raid Groups.")						
						RR_AUTORRAID=true;
						if(RR_AUTORPARTY==true and RR_AUTOREPLY==false) then
							RR_AUTOREPLY=true;
						end
						RaidRogue_Refresh();
					end
				else
					Out("Not a recognized |cFFFF0000RaidRogue|r command.");
				end
			elseif(string.find(SubCmd,"party")) then
				Cmd, SubCmd=RaidRogue_getCmd(SubCmd)
				if(SubCmd=="on") then
					RR_AUTORPARTY=true;
					Out("|cFFFF0000RaidRogue:|r Auto-Replies now |cFF00FF00Enabled|r while in Parties.")
					if(RR_AUTORRAID==true and RR_AUTOREPLY==false) then
						RR_AUTOREPLY=true;
					end
					RaidRogue_Refresh();
				elseif(SubCmd=="off") then
					RR_AUTORPARTY=false;
					Out("|cFFFF0000RaidRogue:|r Auto-Replies now |cFFFF0000Disabled|r while in Parties.")
					
					if(RR_AUTOREPLY==true) then
						RR_AUTOREPLY=false;
					end
					RaidRogue_Refresh();
				elseif(SubCmd=="") then
					if(RR_AUTORPARTY==true) then
						RR_AUTORPARTY=false;
						Out("|cFFFF0000RaidRogue:|r Auto-Replies now |cFFFF0000Disabled|r while in Parties.")
						if(RR_AUTOREPLY==true) then
							RR_AUTOREPLY=false;
						end
						RaidRogue_Refresh();
					else
						RR_AUTORPARTY=true;
						Out("|cFFFF0000RaidRogue:|r Auto-Replies now |cFF00FF00Enabled|r while in Parties.")
						if(RR_AUTORRAID==true and RR_AUTOREPLY==false) then
							RR_AUTOREPLY=true;
						end
						RaidRogue_Refresh();
					end
				else
					Out("Not a recognized |cFFFF0000RaidRogue|r command.");
				end
			elseif(string.find(SubCmd,"overall")) then
				Cmd, SubCmd=RaidRogue_getCmd(SubCmd)
				if(SubCmd=="on") then
					RR_AUTOREPLY=true;
					Out("|cFFFF0000RaidRogue:|r Auto-Replies now |cFF00FF00Enabled|r in Raids and Parties..")
					if(RR_AUTORPARTY==false or RR_AUTORRAID==false) then
						if(RR_AUTORPARTY==false) then
							RR_AUTORPARTY=true;
						end
						if(RR_AUTORRAID==false) then
							RR_AUTORRAID=true;
						end
					end
					RaidRogue_Refresh();
				elseif(SubCmd=="off") then
					RR_AUTOREPLY=false;
					Out("|cFFFF0000RaidRogue:|r Auto-Replies now |cFFFF0000Disabled|r while in Raids and Parties.")

					if(RR_AUTORPARTY==true or RR_AUTORRAID==true) then
							if(RR_AUTORPARTY==true) then
								RR_AUTORPARTY=false;
							end
							if(RR_AUTORRAID==true) then
								RR_AUTORRAID=false;
							end
					end
					RaidRogue_Refresh();
				elseif(SubCmd=="") then
					if(RR_AUTOREPLY==true) then
						RR_AUTOREPLY=false;
						Out("|cFFFF0000RaidRogue:|r Auto-Replies now |cFFFF0000Disabled|r while in Raids and Parties.")
						if(RR_AUTORPARTY==true or RR_AUTORRAID==true) then
							if(RR_AUTORPARTY==true) then
								RR_AUTORPARTY=false;
							end
							if(RR_AUTORRAID==true) then
								RR_AUTORRAID=false;
							end
						end
						RaidRogue_Refresh();
					else
						RR_AUTOREPLY=true;
						Out("|cFFFF0000RaidRogue:|r Auto-Replies now |cFF00FF00Enabled|r while in Raids and Parties.")
						if(RR_AUTORPARTY==false or RR_AUTORRAID==false) then
							if(RR_AUTORPARTY==false) then
								RR_AUTORPARTY=true;
							end
							if(RR_AUTORRAID==false) then
								RR_AUTORRAID=true;
							end
						end
						RaidRogue_Refresh();
					end
				else
					Out("Not a recognized |cFFFF0000RaidRogue|r command.");
				end
			elseif(SubCmd=="") then
				Out("|cFFFF0000RaidRogue Auto-Reply Toggle Commands:");
				Out("- |cFFFF0000raid|r: "..RaidRogue_enhanceChat(RR_AUTORRAID).." Toggles Auto-Reply for in-Combat Whispers On/Off for Raids.") 
				Out("- |cFFFF0000party|r: "..RaidRogue_enhanceChat(RR_AUTORPARTY).." Toggles Auto-Reply for in-Combat Whispers On/Off for Parties.") 
				Out("- |cFFFF0000overall|r: "..RaidRogue_enhanceChat(RR_AUTOREPLY).." Toggles Auto-Reply for in-Combat Whispers On/Off.") 

			else
				Out("Not a recognized |cFFFF0000RaidRogue|r command.");
			end

		elseif(SubCmd=="setmsg") then
			Out("|cFFFF0000RaidRogue:|r No Custom Message Entered.");

		elseif(string.find(SubCmd,"setmsg")) then
			Cmd, SubCmd=RaidRogue_getCmd(SubCmd);
			RR_AUTOREPLYMSG=SubCmd;

		elseif(SubCmd=="viewmsg") then
			DoubleOut("|cFFFF0000Auto-Reply Message|r: "..RR_AUTOREPLYMSG);

		elseif(SubCmd=="viewshortcuts") then
			Out("|cFFFF0000Auto-Reply Shortcuts|r: $P=Player Name | $I=Instance Name | $B=Boss Name | $HP=Boss HP (Includes %) | $RA=Raid Members Alive | $RM= Total Raid Members")

		elseif(SubCmd=="") then
			Out("|cFFFF0000RaidRogue Auto-Reply List of Commands:");
			Out("- |cFFFF0000toggle|r: Customize Auto-Reply Settings for Whispers.") 
			Out("- |cFFFF0000setmsg|r: Set a Custom Auto-Reply Message.")
			Out("- |cFFFF0000viewmsg|r: View your current Auto-Reply Message.")
			Out("- |cFFFF0000viewshortcuts|r: View currently recognized keyboard shortcuts.")
		else
			Out("Not a recognized |cFFFF0000RaidRogue|r command.");
		end

	elseif(Cmd=="stattrack" and RR_STANDBY==false) then

		if(string.find(SubCmd,"enable")) then
			Cmd, SubCmd=RaidRogue_getCmd(SubCmd)

			if(SubCmd=="on") then
				RR_STATTRACKER=true;
				Out("|cFFFF0000RaidRogue:|r PvE Stat Tracker |cFF00FF00Enabled.|r")
				RaidRogue_Refresh();
			elseif(SubCmd=="off") then
				RR_STATTRACKER=false;
				Out("|cFFFF0000RaidRogue:|r PvE Stat Tracker |cFFFF0000Disabled.|r")
				RaidRogue_Refresh();
			elseif(SubCmd=="") then
				if(RR_STATTRACKER==true) then
					RR_STATTRACKER=false;
					Out("|cFFFF0000RaidRogue:|r PvE Stat Tracker |cFFFF0000Disabled.|r")
					RaidRogue_Refresh();
				else
					RR_STATTRACKER=true;
					Out("|cFFFF0000RaidRogue:|r PvE Stat Tracker |cFF00FF00Enabled.|r")
					RaidRogue_Refresh();
				end
			else
				Out("Not a recognized |cFFFF0000RaidRogue|r command.");
			end
		elseif(string.find(SubCmd,"counttrivial")) then
			Cmd, SubCmd=RaidRogue_getCmd(SubCmd)

			if(SubCmd=="on") then
				RR_COUNTTRIVIAL=true;
				Out("|cFFFF0000RaidRogue:|r Now Counting Stats from  |cFF00FF00ALL Levels.|r")
				RaidRogue_Refresh();
			elseif(SubCmd=="off") then
				RR_COUNTTRIVIAL=false;
				Out("|cFFFF0000RaidRogue:|r Trivial Level Gap (10 Lvls) now |cFFFF0000Enabled.|r")			
				RaidRogue_Refresh();
			elseif(SubCmd=="") then
				if(RR_COUNTTRIVIAL==true) then
					RR_COUNTTRIVIAL=false;
					Out("|cFFFF0000RaidRogue:|r Trivial Level Gap (10 Lvls) now |cFFFF0000Enabled.|r")	
					RaidRogue_Refresh();
				else
					RR_COUNTTRIVIAL=true;
					Out("|cFFFF0000RaidRogue:|r Now Counting Stats from  |cFF00FF00ALL Levels.|r")		
					RaidRogue_Refresh();
				end
			else
				Out("Not a recognized |cFFFF0000RaidRogue|r command.");
			end

		elseif(string.find(SubCmd,"filters")) then
			Cmd, SubCmd=RaidRogue_getCmd(SubCmd);
	
			if(SubCmd=="toggle") then
				Cmd, SubCmd=RaidRogue_getCmd(SubCmd)

				if(SubCmd=="on") then
					RR_FILTERS=true;
					Out("|cFFFF0000RaidRogue:|r Filters on Crit List now |cFF00FF00Enabled.|r")
					RaidRogue_Refresh();
				elseif(SubCmd=="off") then
					RR_FILTERS=false;
					Out("|cFFFF0000RaidRogue:|r Filters on Crit List now |cFFFF0000Disabled.|r")			
					RaidRogue_Refresh();
				elseif(SubCmd=="") then
					if(RR_FILTERS==true) then
						RR_FILTERS=false;
						Out("|cFFFF0000RaidRogue:|r Filters on Crit List now |cFFFF0000Disabled.|r")	
						RaidRogue_Refresh();
					else
						RR_FILTERS=true;
						Out("|cFFFF0000RaidRogue:|r Filters on Crit List now |cFF00FF00Enabled.|r")	
						RaidRogue_Refresh();
					end
				else
					Out("Not a recognized |cFFFF0000RaidRogue|r command.");
				end

			elseif(SubCmd=="view") then
				Out("|cFFFF0000RaidRogue:|r List of Crit Filters");
				RaidRogue_PrintTable(RR_FILTERLIST);

			elseif(string.find(SubCmd,"add")) then	
				if(string.find(SubCmd, "ability") and RR_FILTERS) then
					Arg, Ans=RaidRogue_getArgument(SubCmd)
					if(RaidRogue_TableContains(RR_FILTERLIST, Ans)==false) then
						table.insert(RR_FILTERLIST,Ans);
						RaidRogue_FilterCritList();
						Out("|cFFFF0000RaidRogue:|r Successfully added to filter list: |cFFFF0000"..Ans..".|r");
						RaidRogue_Refresh();
					end
				else
					Out("|cFFFF0000RaidRogue:|r Filters cannot be changed while |cFFFF0000Disabled.|r");
				end

			elseif(string.find(SubCmd,"remove")) then

				Cmd, SubCmd=RaidRogue_getCmd(SubCmd);

				if(string.find(SubCmd,"ability") and RR_FILTERS) then
					Arg, Ans=RaidRogue_getArgument(SubCmd)
					if(RaidRogue_TableContains(RR_FILTERLIST, Ans) and RaidRogue_getIndexOf(RR_FILTERLIST, Ans)~=-1) then
						table.remove(RR_FILTERLIST, RaidRogue_getIndexOf(RR_FILTERLIST, Ans));
						RaidRogue_FilterCritList();
						Out("|cFFFF0000RaidRogue:|r Successfully removed from filter list: |cFFFF0000"..Ans..".|r");
						RaidRogue_Refresh();
					end
				else
					Out("|cFFFF0000RaidRogue:|r Filters cannot be changed while |cFFFF0000Disabled.|r");
				end

			elseif(SubCmd=="reset") then
				RaidRogue_resetFilters();

			elseif(SubCmd=="") then
				Out("|cFFFF0000RaidRogue Stat Track Filter Options:");
				Out("- |cFFFF0000toggle|r: "..RaidRogue_enhanceChat(RR_FILTERS).."Toggles the Crit List Filters on/off.") 
				Out("- |cFFFF0000view|r: View a list of currently filtered abilities.");
				Out("- |cFFFF0000add|r: Add an ability to filtered list (Usage: add ability=[Ability]).")
				Out("- |cFFFF0000remove|r: Remove an ability from filtered list (Usage: remove ability=[Ability]).")
				Out("- |cFFFF0000reset|r: Reset your filters to default.")
			else
				Out("Not a recognized |cFFFF0000RaidRogue|r command.");
			end

		elseif(SubCmd=="resetsession") then
			RaidRogue_resetSessionPVEStats();

		elseif(SubCmd=="resetlife") then
			RaidRogue_resetLifePVEStats();

		elseif(SubCmd=="resetcrits") then
			RaidRogue_ResetCritList();

		elseif(SubCmd=="resetall") then
			RaidRogue_resetAllPVEStats();

		elseif(SubCmd=="toggle") then
			RaidRogue_Toggle("RaidRogueStats");
		
		elseif(SubCmd=="") then
			Out("|cFFFF0000RaidRogue Stat Track Options:");
			Out("- |cFFFF0000enable|r: "..RaidRogue_enhanceChat(RR_STATTRACKER).."Toggles the Stat Tracker on/off.") 
			Out("- |cFFFF0000counttrivial|r: "..RaidRogue_enhanceChat(RR_COUNTTRIVIAL).." Toggle the trivial level gap for KBs/TKs/BKs.");
			Out("- |cFFFF0000filters|r: Customize your crit list filters.");
			Out("- |cFFFF0000resetsession|r: Reset your Session PvE Stats.")
			Out("- |cFFFF0000resetlife|r: Reset your Lifetime PvE Stats.")
			Out("- |cFFFF0000resetall|r: Reset your Session and Lifetime PvE Stats.")
			Out("- |cFFFF0000resetcrits|r: Reset your Crit List.");
			Out("- |cFFFF0000stattrack:|r Show/Hide the Stat Track Frame.")
		else
			Out("Not a recognized |cFFFF0000RaidRogue|r command.");
		end

	elseif(Cmd=="sync" and RR_STANDBY==false) then
		if(string.find(SubCmd,"limitrequests")) then
			Cmd, SubCmd=RaidRogue_getCmd(SubCmd)

			if(SubCmd=="on") then
				RR_OFFICERREQUESTSONLY=true
				Out("|cFFFF0000RaidRogue:|r Now Accepting Addon Info Requests from: |cFF00FF00Raid Officers Only.|r")			
				RaidRogue_Refresh();
			elseif(SubCmd=="off") then
				RR_OFFICERREQUESTSONLY=false;
				Out("|cFFFF0000RaidRogue:|r Now Accepting Addon Info Requests from: |cFFFF0000Anyone.|r")
				RaidRogue_Refresh();
			elseif(SubCmd=="") then
				if(RR_OFFICERREQUESTSONLY==true) then
					RR_OFFICERREQUESTSONLY=false;
					Out("|cFFFF0000RaidRogue:|r Now Accepting Addon Info Requests from: |cFFFF0000Anyone.|r")
					RaidRogue_Refresh();
				else
					RR_OFFICERREQUESTSONLY=true
					Out("|cFFFF0000RaidRogue:|r Now Accepting Addon Info Requests from: |cFF00FF00Raid Officers Only.|r")			
					RaidRogue_Refresh();
				end
			else
				Out("Not a recognized |cFFFF0000RaidRogue|r command.");
			end
		elseif(SubCmd=="") then
			Out("|cFFFF0000RaidRogue Sync Options:");
			Out("- |cFFFF0000limitrequests|r: "..RaidRogue_enhanceChat(RR_OFFICERREQUESTSONLY).." Respond to queries from Officers only.")
		else
			Out("Not a recognized |cFFFF0000RaidRogue|r command.");
		end

	elseif (Cmd=="autoalerts" and RR_STANDBY==false) then
			if(string.find(SubCmd,"toggle")) then
			Cmd, SubCmd=RaidRogue_getCmd(SubCmd)
			
			if(string.find(SubCmd,"system")) then
				Cmd, SubCmd=RaidRogue_getCmd(SubCmd)
				if(SubCmd=="on") then
					RR_AUTOAYSTEM=true;
					Out("|cFFFF0000RaidRogue:|r  System Auto-Alerts are now |cFF00FF00Enabled|r.")

					if(RR_AUTOACHAT==true and RR_AUTOALERTS==false) then
						RR_AUTOALERTS=true;
					end
					RaidRogue_Refresh();

				elseif(SubCmd=="off") then
					RR_AUTOASYSTEM=false;
					Out("|cFFFF0000RaidRogue:|r  System Auto-Alerts are now |cFFFF0000Disabled|r.")
					
					if(RR_AUTOALERTS==true) then
						RR_AUTOALERTS=false;
					end
					RaidRogue_Refresh();

				elseif(SubCmd=="") then
					if(RR_AUTOASYSTEM==true) then
						RR_AUTOASYSTEM=false;
						Out("|cFFFF0000RaidRogue:|r  System Auto-Alerts are now |cFFFF0000Disabled|r.")

						if(RR_AUTOALERTS==true) then
							RR_AUTOALERTS=false;
						end
						RaidRogue_Refresh();
					else
						RR_AUTOASYSTEM=true;
						Out("|cFFFF0000RaidRogue:|r  System Auto-Alerts are now  |cFF00FF00Enabled|r.")
						if(RR_AUTOACHAT==true and RR_AUTOALERTS==false) then
							RR_AUTOALERTS=true;
						end
						RaidRogue_Refresh();
					end
				else
					Out("Not a recognized |cFFFF0000RaidRogue|r command.");
				end
			elseif(string.find(SubCmd,"chat")) then
				Cmd, SubCmd=RaidRogue_getCmd(SubCmd)
				if(SubCmd=="on") then
					RR_AUTOACHAT=true;
					Out("|cFFFF0000RaidRogue:|r Chat Auto-Alerts are now |cFF00FF00Enabled|r.")
					if(RR_AUTOASYSTEM==true and RR_AUTOALERTS==false) then
						RR_AUTOALERTS=true;
					end
					RaidRogue_Refresh();
				elseif(SubCmd=="off") then
					RR_AUTORACHAT=false;
					Out("|cFFFF0000RaidRogue:|r Chat Auto-Alerts are now |cFFFF0000Disabled|r.")
					
					if(RR_AUTOALERTS==true) then
						RR_AUTOALERTS=false;
					end
					RaidRogue_Refresh();
				elseif(SubCmd=="") then
					if(RR_AUTOACHAT==true) then
						RR_AUTOACHAT=false;
						Out("|cFFFF0000RaidRogue:|r Chat Auto-Alerts are now |cFFFF0000Disabled|r.")
						if(RR_AUTOALERTS==true) then
							RR_AUTOALERTS=false;
						end
						RaidRogue_Refresh();
					else
						RR_AUTOACHAT=true;
						Out("|cFFFF0000RaidRogue:|r Chat Auto-Alerts are now |cFF00FF00Enabled|r.")
						if(RR_AUTOASYSTEM==true and RR_AUTOALERTS==false) then
							RR_AUTOALERTS=true;
						end
						RaidRogue_Refresh();
					end
				else
					Out("Not a recognized |cFFFF0000RaidRogue|r command.");
				end
			elseif(string.find(SubCmd,"overall")) then
				Cmd, SubCmd=RaidRogue_getCmd(SubCmd)
				if(SubCmd=="on") then
					RR_AUTOALERTS=true;
					Out("|cFFFF0000RaidRogue:|r Auto-Alerts are now |cFF00FF00Enabled|r.")
					if(RR_AUTOACHAT==false or RR_AUTOASYSTEM==false) then
						if(RR_AUTOACHAT==false) then
							RR_AUTOACHAT=true;
						end
						if(RR_AUTOASYSTEM==false) then
							RR_AUTOASYSTEM=true;
						end
					end
					RaidRogue_Refresh();
				elseif(SubCmd=="off") then
					RR_AUTOALERTS=false;
					Out("|cFFFF0000RaidRogue:|r Auto-Alerts are now |cFFFF0000Disabled|r.")
					if(RR_AUTOACHAT==true or RR_AUTOASYSTEM==true) then
						if(RR_AUTOACHAT==true) then
							RR_AUTOACHAT=false;
						end
						if(RR_AUTOASYSTEM==true) then
							RR_AUTOASYSTEM=false;
						end
					end
					RaidRogue_Refresh();
				elseif(SubCmd=="") then
					if(RR_AUTOALERTS==true) then
						RR_AUTOALERTS=false;
						Out("|cFFFF0000RaidRogue:|r Auto-Alerts are now |cFFFF0000Disabled|r.")
						if(RR_AUTOACHAT==true or RR_AUTOASYSTEM==true) then
							if(RR_AUTOACHAT==true) then
								RR_AUTOACHAT=false;
							end
							if(RR_AUTOASYSTEM==true) then
								RR_AUTOASYSTEM=false;
							end
						end
						RaidRogue_Refresh();
					else
						RR_AUTOALERTS=true;
						Out("|cFFFF0000RaidRogue:|r Auto-Alerts are now |cFF00FF00Enabled|r.")
						if(RR_AUTOACHAT==false or RR_AUTOASYSTEM==false) then
							if(RR_AUTOACHAT==false) then
								RR_AUTOACHAT=true;
							end
							if(RR_AUTOASYSTEM==false) then
								RR_AUTOASYSTEM=true;
							end
						end
						RaidRogue_Refresh();
					end
				else
					Out("Not a recognized |cFFFF0000RaidRogue|r command.");
				end
			elseif(SubCmd=="") then
				Out("|cFFFF0000RaidRogue Auto-Alert Toggle Commands:");
				Out("- |cFFFF0000system|r: "..RaidRogue_enhanceChat(RR_AUTOASYSTEM).." Toggles Auto-Alerts chat messages On/Off.") 
				Out("- |cFFFF0000chat|r: "..RaidRogue_enhanceChat(RR_AUTOACHAT).." Toggles Auto-Alerts system messages On/Off.") 
				Out("- |cFFFF0000overall|r: "..RaidRogue_enhanceChat(RR_AUTOALERTS).." Toggles Auto-Alerts chat and system messages On/Off.") 

			else
				Out("Not a recognized |cFFFF0000RaidRogue|r command.");
			end
		elseif(SubCmd=="") then
			Out("|cFFFF0000RaidRogue Auto-Alert List of Commands:");
			Out("- |cFFFF0000toggle|r: Toggle Auto-Alert to display in System or Chat.") 
		else
			Out("Not a recognized |cFFFF0000RaidRogue|r command.");
		end

	elseif (Cmd == "debug" and RR_STANDBY==false) then
		if(SubCmd=="on") then
			RR_DEBUG=true
			Out("|cFFFF0000RaidRogue:|r Debug now turned |cFF00FF00On.|r")			
			RaidRogue_Refresh();
		elseif(SubCmd=="off") then
			RR_DEBUG=false;
			Out("|cFFFF0000RaidRogue:|r Debug now turned |cFFFF0000Off.|r")
			RaidRogue_Refresh();
		elseif(SubCmd=="") then
			if(RR_DEBUG==true) then
				RR_DEBUG=false;
				Out("|cFFFF0000RaidRogue:|r Debug now turned |cFFFF0000Off.|r")
				RaidRogue_Refresh();
			else
				RR_DEBUG=true
				Out("|cFFFF0000RaidRogue:|r Debug now turned |cFF00FF00On.|r")			
				RaidRogue_Refresh();
			end
		else
			Out("Not a recognized |cFFFF0000RaidRogue|r command.");
		end

	elseif (Cmd == "reset" and RR_STANDBY==false) then
		RaidRogue_resetOptions();
		RaidRogue_resetAllPVEStats();
		RaidRogue_ResetCritList();
		RaidRogue_resetSettings();
		RaidRogue_Refresh();

	elseif (Cmd=="help") then
		
		Out("|cFFFF0000RaidRogue|r "..RaidRogue_dispVersion(RR_VERSION, RR_BETA).." is loaded. List of Commands:");	
		
		Out("- |cFFFF0000status|r: ["..RR_OVERALLSTATUS.."] Toggles the Status GUI.")
		Out("- |cFFFF0000options|r: Toggles the Options GUI.")
		Out("- |cFFFF0000stats|r: Toggles the Stat Tracking GUI.")
		Out("- |cFFFF0000rl|r: Reloads the UI.")
		Out("- |cFFFF0000refresh|r: Forces a Mod Refresh.")
		Out("- |cFFFF0000loadoptions|r: Customizes when addon loads.");
		Out("- |cFFFF0000color|r: "..RaidRogue_enhanceChat(RR_COLOR).." Toggles Color on and off.")
		Out("- |cFFFF0000locked|r: "..RaidRogue_enhanceChat(RR_LOCKED).." Lock/Unlock the RaidRogue Frames.")
		Out("- |cFFFF0000debug|r: "..RaidRogue_enhanceChat(RR_DEBUG).." Toggles Debugging on and off.")
		Out("- |cFFFF0000benchmarks|r: "..RaidRogue_enhanceChat(RR_SHOWBENCH).." Show/Hide Benchmark Values.")
		Out("- |cFFFF0000rogueVC|r: Initiate a raid-wide Rogue Version Check.")
		Out("- |cFFFF0000rogueRC|r: Initiate a raid-wide Rogue Ready Check.")
		Out("- |cFFFF0000autoreply|r: Customize Auto-Replies while in Combat.")
		Out("- |cFFFF0000stattrack|r: Customize your Stat Track preferences.")
		Out("- |cFFFF0000sync|r: Customize your Syncing Options.");
		Out("- |cFFFF0000autoalerts|r: Customize your Auto-Alerts preferences.")
		Out("- |cFFFF0000standby|r: "..RaidRogue_enhanceChat(RR_STANDBY).." Suspend/Resume this Addon.")
		Out("- |cFFFF0000reset|r: Reset all Options to Defaults.");

	elseif (Cmd=="" or Cmd=="rr") then
		RaidRogue_Toggle("RaidRogue");
	
	elseif (RR_STANDBY==true) then
		Out("|cFFFF0000RaidRogue|r is on |cFFFF0000Standby|r.");


	--======================================================
			-- DEBUG ONLY CHAT COMMANDS
	--======================================================

	elseif (Cmd=="custom1" and RR_DEBUG and RR_STANDBY==false) then
		Out ("Custom Track 1: "..RR_CUSTOMTRACKS[1])

	elseif (Cmd=="custom2" and RR_DEBUG and RR_STANDBY==false) then
		Out ("Custom Track 2: "..RR_CUSTOMTRACKS[2])

	elseif (Cmd=="custom3" and RR_DEBUG and RR_STANDBY==false) then
		Out ("Custom Track 3: "..RR_CUSTOMTRACKS[3])
	
	elseif(Cmd=="getGroupSize" and RR_DEBUG) then
		Out(" Group Size: "..RaidRogue_getNumMembers())

	elseif(Cmd=="inGroup" and RR_DEBUG) then
		if(RaidRogue_IsInGroup()==true) then
			Out("In Group?: True");
		else
			Out("In Group?: False");
		end

	elseif(Cmd=="inCombatLockdown" and RR_DEBUG) then
		if(InCombatLockdown()==1) then
			Out("Player is IN Combat.")
		else
			Out("Player is OUT OF Combat.")
		end
	
	elseif(Cmd=="UnitAffectingCombat" and RR_DEBUG) then
		if(UnitAffectingCombat("player")==1) then
			Out("Player is IN Combat.")
		else
			Out("Player is OUT OF Combat.")
		end


	--============================================================
			-- DEVELOPER TESTING CHAT COMMANDS
	--============================================================

	--Use at your own risk, many of these commands are being beta tested.

	elseif(Cmd=="isBoss") then
		if(RaidRogue_UnitIsBoss(UnitName("target"))==true) then
			Out("Unit Is Boss: True");
		else
			Out("Unit Is Boss: False");
		end

	elseif(Cmd=="IsUsing") then
		if(SubCmd~="") then
			--SubCmd is the player to request info from.
			RaidRogue_getRRPlayerInfo(SubCmd);
		end

	elseif(Cmd=="getZone") then
		Out(GetRealZoneText());

	elseif(Cmd=="getNumAlive") then
		Out("Raid Members Alive: "..RaidRogue_getNumAlive());

	else
		if(RR_STANDBY==true) then
			Out("|cFFFF0000RaidRogue|r is on |cFFFF0000Standby|r.");
		else
			Out("Not a recognized |cFFFF0000RaidRogue|r command.");
		end
	end
end


--=========================================
--	Calculating Status Functions
--=========================================

--===== Get the Current and Maximum Durability Value from Tooltip.
function RaidRogue_itemDur(index)

	RaidRogue_TT:SetOwner(WorldFrame, "ANCHOR_NONE");
	local id, hasItem, repairCost, current, maximum;
	
	id = GetInventorySlotInfo( index );
	hasItem, _, repairCost = RaidRogue_TT:SetInventoryItem("player", id);
	
	--===== Scan the Item's Description =====
	if (hasItem) then
		for i = 1,30 do
			local row = getglobal("RaidRogue_TTTextLeft" .. i);
			if (row) then
				local text = row:GetText();
				if (text) then
					-- Scan for Durability Information
					local _, _, cur, max = string.find(text, "Durability (%d+) / (%d+)");
					
					-- Convert Strings to Numbers
					if (cur) then
						current = tonumber(cur);
						maximum = tonumber(max);
					end
				end
			end
		end
	else
		current=100;
		maximum=100;
	end
	return current, maximum;
end

--===== Get the Lowest Durability Percent out of equipped items.
function RaidRogue_Durability()
	local gearslots, current, maximum, percent, duraPercent, lowPercent, lowItem, mostDamaged, itemsBroken;
	current = 0;
	maximum = 0;
	duraPercent=0;
	lowPercent=100;
	lowItem="";
	itemsBroken=0;
	
	
	gearslots = {"HeadSlot","ShoulderSlot","ChestSlot","WristSlot","HandsSlot","WaistSlot","LegsSlot","FeetSlot","MainHandSlot","SecondaryHandSlot","RangedSlot"};
	gearNames = {"Helmet","Shoulders","Chest","Bracers","Gloves","Belt","Legs","Boots","Main Hand","Off Hand","Ranged"};
	
	--===== Check all Gear Slots =====

	for i=1,11 do
		current, maximum = RaidRogue_itemDur(gearslots[i]); 
	
		if (maximum) then
			duraPercent=(current/maximum)*100;
			if(current==0) then
				itemsBroken=itemsBroken+1;
			end
		else
			duraPercent=100.0;
		end

		if (duraPercent<lowPercent) then
			lowPercent=duraPercent;
			lowItem=gearNames[i];
		end
		
	end	

	if(lowPercent==100) then
		lowItem="None"
	end

	if(lowPercent>=RR_BENCH_DURABILITY) then
		RR_DURABILITYCHECK=true;
	else
		RR_DURABILITYCHECK=false;
	end
	
	local duraColor=RaidRogue_getDuraColor(lowPercent);
	local brokenColor=RaidRogue_getBrokenColor(itemsBroken);

	if(duraColor~="|cFF00FF00" and duraColor~="|cFFFF0000" and duraColor ~= "|cFFFFFF00") then
		DebugOut("DuraColor is NIL.")
	end
	
	--===== Output to the Status Frame =====

	lowPercent = format("%.1f", lowPercent);
	if (RR_DEBUG) then
		RaidRogue_DuraPercent:SetText("Durability Percent: "..duraColor..""..lowPercent .."% ("..lowItem..")");
		RaidRogue_LowItem:SetText("Most Damaged: "..lowItem.." ("..lowPercent.."%)");
		RaidRogue_NumBroken:SetText("Items Broken: "..brokenColor..""..itemsBroken);
	else
		RaidRogue_DuraPercent:SetText("Durability Percent: "..duraColor..""..lowPercent .."%");
		RaidRogue_LowItem:SetText("Most Damaged: "..lowItem);
		RaidRogue_NumBroken:SetText("Items Broken: "..brokenColor..""..itemsBroken);
	end
end

--===== Gets the Name of the Item currently being checked =====
function RaidRogue_getItemName(bag, slot)
	local linktext = nil;
  
	if (bag == -1) then
		linktext = GetInventoryItemLink("player", slot);
  	else
		linktext = GetContainerItemLink(bag, slot);
	end

	if linktext then
		local _,_,name = string.find(linktext, "^.*%[(.*)%].*$");
		return name;
	else
		return "";
	end
end

--===== Calculate the Amount of Flash Powder/Poisons/Custom Tracks in Possession =====
function RaidRogue_getReagentCount()

	RaidRogue:SetHeight(RR_STATUSHEIGHT);
	RaidRogue:SetWidth(RR_STATUSWIDTH);
	local flash = 0;
	local ammo = 0;
	local custom1=0;
	local custom2=0;
	local custom3=0;
	local crip=0;
	local deadly=0;
	local wound=0;
	local instant=0;
	local anesthetic=0;
	local mind=0;

	local poisonranks={""," II"," III"," IV"," V"," VI"," VII"};
	local highranks={"","","","","",""};
	local crips={0,0,0,0,0,0,0};
        local deadlies={0,0,0,0,0,0,0};
	local wounds={0,0,0,0,0,0,0};
	local instants={0,0,0,0,0,0,0};
	local minds={0,0,0,0,0,0,0};

	local poisonranknums={crips,deadlies,minds,instants,wounds};
	local fpoisons={crip,deadly,mind,instant,wound};

	for bag = 0, 4, 1 do
		for slot = 1, GetContainerNumSlots(bag), 1 do
			local name = RaidRogue_getItemName(bag, slot);
			local _,_,_,_,_,itemType,_,_,_=GetItemInfo(name);
			-- check if item is a reagent we are counting

			for i=1,#RR_ITEM_POISONS do
				if (string.find(name,RR_ITEM_POISONS[i])~=nil) then
					for k=#poisonranks,1,-1 do
						if(name==RR_ITEM_DPOISONS[i]..""..poisonranks[k]) then
							local _, itemCount = GetContainerItemInfo(bag, slot);	
							poisonranknums[i][k] = poisonranknums[i][k] + itemCount;
						end
					end	
				end
			end
			if (name==RR_ITEM_ANESTHETIC) then
				local _, itemCount = GetContainerItemInfo(bag, slot);
				anesthetic = anesthetic + itemCount;
			elseif (name == RR_ITEM_FLASH) then
				local _, itemCount = GetContainerItemInfo(bag, slot);
				flash = flash + itemCount;
			elseif (RR_CUSTOMTRACKS[1]~="" and name== RR_CUSTOMTRACKS[1]) then
				local _, itemCount= GetContainerItemInfo(bag, slot);
				custom1=custom1 + itemCount;
			elseif (RR_CUSTOMTRACKS[2]~="" and name== RR_CUSTOMTRACKS[2]) then
				local _, itemCount= GetContainerItemInfo(bag, slot);
				custom2=custom2 + itemCount;
			elseif (RR_CUSTOMTRACKS[3]~="" and name== RR_CUSTOMTRACKS[3]) then
				local _, itemCount= GetContainerItemInfo(bag, slot);
				custom3=custom3 + itemCount;
			elseif (itemType=="Projectile") then
				local _, itemCount= GetContainerItemInfo(bag, slot);
				ammo=ammo+itemCount;
			end
		end
	end

	local customs={custom1,custom2,custom3};

	--Check to see if any Custom Tracks are same, and so missing count values.
	for i=1,#RR_CUSTOMTRACKS do
		for k=i,#RR_CUSTOMTRACKS do
			if(RR_CUSTOMTRACKS[i]==RR_CUSTOMTRACKS[k]) then
				customs[k]=customs[i];
			end
		end
	end

	--Save only the highest poison rank's amount.
	for i=1,#poisonranknums do
		for k=#poisonranknums[i],1,-1 do
			if(poisonranknums[i][k]>0) then
				fpoisons[i]=poisonranknums[i][k];
				highranks[i]=poisonranks[k];
				break;
			end	
		end
	end
						
	--Check to see if status is "Ready" for Flash Powder
	if(flash>=RR_BENCH_FLASH) then
		RR_REAGENTCHECK=true
	else
		RR_REAGENTCHECK=false	
	end

	--Check to see if status is "Ready" for Ammo
	if(ammo>=RR_BENCH_AMMO) then
		RR_AMMOCHECK=true
	else
		RR_AMMOCHECK=false
	end

	--Check to see if status is "Ready" for Poisons
	for i=1,#RR_BENCH_POISONS do
		if(fpoisons[i]>=RR_BENCH_POISONS[i] and anesthetic>RR_BENCH_ANESTHETIC) then
			RR_POISONCHECK=true
		else
			RR_POISONCHECK=false
			break;
		end
	end
				

	--Check to see if status is "Ready" for Custom Tracks
	for i=1,#RR_CUSTOMTRACKS do
		if(RR_CUSTOMTRACKS[i]~="") then
			if(customs[i]>=RR_CUSTOMBENCHES[i]) then
	 			RR_CUSTOMCHECK=true
			else	
				RR_CUSTOMCHECK=false
				break;
			end	
		end
	end
	
	local flashColor=RaidRogue_getFlashColor(flash)
	RaidRogue_FlashPowder:SetText("Flash Powder: "..flashColor..""..flash.." "..RaidRogue_showBenchmark(RR_BENCH_FLASH));
	local ammoColor=RaidRogue_getAmmoColor(ammo)
	local anesColor=RaidRogue_getPoisonColor(anesthetic, 0);
	RaidRogue_Ammo:SetText("Ammunition: "..ammoColor..""..ammo.." "..RaidRogue_showBenchmark(RR_BENCH_AMMO));
	RaidRogue_AnestheticPoison:SetText("Anesthetic Poison: "..anesColor..""..anesthetic.." "..RaidRogue_showBenchmark(RR_BENCH_ANESTHETIC));

	for i=1,#fpoisons do
		local poisonColor=RaidRogue_getPoisonColor(fpoisons[i],i);
		RR_POISONOUTPUTS[i]:SetText(RR_ITEM_DPOISONS[i]..""..highranks[i]..": "..poisonColor..""..fpoisons[i].." "..RaidRogue_showBenchmark(RR_BENCH_POISONS[i]));


	end

	for i=1,#RR_CUSTOMTRACKS do
		if(RR_CUSTOMTRACKS[i]~="") then
			RaidRogue:SetHeight(RaidRogue:GetHeight()+14)
			local customColor=RaidRogue_getCustomColor(customs[i],i)
			RR_CUSTOMTRACKOUTPUTS[i]:SetText(""..RaidRogue_setToMaxChars(RR_CUSTOMTRACKS[i])..": "..customColor..""..customs[i].." "..RaidRogue_showBenchmark(RR_CUSTOMBENCHES[i]));
		else
			RR_CUSTOMTRACKOUTPUTS[i]:SetText("");
		end
	end
end

--===== Get Bandage count, Display Only Highest Power Bandage =====
function RaidRogue_getBandageCount()
	--Temporary Table containing the Count Variables for each type of Bandage
	local bandageCounts={0,0,0,0,0,0,0,0,0,0,0,0};
	local highBandageCount=0;
	local highBandage="";

	for bag = 0, 4, 1 do
		for slot = 1, GetContainerNumSlots(bag), 1 do
			local name = RaidRogue_getItemName(bag, slot);
			-- check if item is a bandage

			for i=1,#RR_ITEM_BANDAGES do
				if(name == ""..RR_ITEM_BANDAGES[i].." Bandage") then
					local_, itemCount=GetContainerItemInfo(bag, slot);
					bandageCounts[i]=bandageCounts[i]+itemCount;
				end	
			end		
		end
	end

	for k=1,#bandageCounts do
		if(bandageCounts[k]>0) then
			highBandageCount=bandageCounts[k];
			highBandage=RR_ITEM_BANDAGES[k];
			break;
		end
	end
		
	--===== Output the Bandage Text, Along with Color =====
	if (highBandage~="") then
		local bandageColor=RaidRogue_getBandageColor(highBandageCount)
		RaidRogue_Bandages:SetText(""..highBandage..": "..bandageColor..""..highBandageCount.." "..RaidRogue_showBenchmark(RR_BENCH_BANDAGES));
	else
		RaidRogue_Bandages:SetText("|cFFFF0000No Bandages|r");
	end

	if (highBandageCount>=RR_BENCH_BANDAGES) then
		RR_BANDAGECHECK=true
	else
		RR_BANDAGECHECK=false
	end

end

--===== Get Overall Status (Needs Attention/Buy Supplies/Ready) =====
function RaidRogue_getOverallStatus()

	local zoneName=GetRealZoneText();
	local faction=UnitFactionGroup("player");

	if (RR_REAGENTCHECK==true and RR_POISONCHECK==true and RR_DURABILITYCHECK==true and RR_BANDAGECHECK==true and RR_CUSTOMCHECK==true and RR_AMMOCHECK==true) then
		if(RR_COLOR==true) then
			RaidRogue_Title:SetText("RaidRogue: |cFF00FF00Ready|r");
			RR_OVERALLSTATUS="|cFF00FF00Ready|r";
		else
			RaidRogue_Title:SetText("RaidRogue: Ready");
			RR_OVERALLSTATUS="Ready";
		end
	else
		if(faction=="Alliance") then	
			if(zoneName=="Stormwind City" or zoneName=="Ironforge" or zoneName=="Darnassus" or zoneName=="Exodar" or zoneName=="Shattrath City" or zoneName=="Booty Bay") then	
				if(RR_COLOR==true) then
					RaidRogue_Title:SetText("RaidRogue: |cFFFFFF00Buy Supplies|r");
					RR_OVERALLSTATUS="|cFFFFFF00Buy Supplies|r";
				else
					RaidRogue_Title:SetText("RaidRogue: Buy Supplies");
					RR_OVERALLSTATUS="Buy Supplies";
				end
			else
				if(RR_COLOR==true) then
					RaidRogue_Title:SetText("RaidRogue: |cFFFF0000Needs Attention|r");
					RR_OVERALLSTATUS="|cFFFF0000Needs Attention|r";
				else
					RaidRogue_Title:SetText("RaidRogue: Needs Attention");
					RR_OVERALLSTATUS="Needs Attention";
				end
			end

		elseif(faction=="Horde") then
			if(zoneName=="Orgimmar" or zoneName=="Undercity" or zoneName=="Thunder Bluff" or zoneName=="Silvermoon City" or zoneName=="Shattrath City" or zoneName=="Booty Bay") then
				if(RR_COLOR==true) then
					RaidRogue_Title:SetText("RaidRogue: |cFFFFFF00Buy Supplies|r");
					RR_OVERALLSTATUS="|cFFFFFF00Buy Supplies|r";
				else
					RaidRogue_Title:SetText("RaidRogue: Buy Supplies");
					RR_OVERALLSTATUS="Buy Supplies";
				end
			else
				RR_OVERALLSTATUS="Needs Attention";
				if(RR_COLOR==true) then
					RaidRogue_Title:SetText("RaidRogue: |cFFFF0000Needs Attention|r");
					RR_OVERALLSTATUS="|cFFFF0000Needs Attention|r";
				else
					RaidRogue_Title:SetText("RaidRogue: Needs Attention");
					RR_OVERALLSTATUS="Needs Attention";
				end
			end	
		end
	end	
end

--=========================================
--	Getting Color Functions
--=========================================

--===== Get Flash Powder Color =====
function RaidRogue_getFlashColor(flash)
	
	if (RR_COLOR==false) then
		return "";	
	end

	if (flash>=RR_BENCH_FLASH+5) then
		return "|cFF00FF00";
	elseif (flash>=RR_BENCH_FLASH) then
		return "|cFFFFFF00";
	elseif (flash<RR_BENCH_FLASH) then
		return "|cFFFF0000";
	end
end

--===== Get Durability Color =====
function RaidRogue_getDuraColor(lowPercent)
	
	if (RR_COLOR==false) then
		return "";
	end

	if (lowPercent>=RR_BENCH_DURABILITY) then
		return "|cFF00FF00";
	elseif(lowPercent>=60 and lowPercent<RR_BENCH_DURABILITY) then
		return "|cFFFFFF00";
	elseif(lowPercent>=35 and lowPercent<60) then
		return "|cFFFF4500";
	else
		return "|cFFFF0000";
	end
end

--===== Get Bandage Color =====
function RaidRogue_getBandageColor(highBandageCount)
	
	if (RR_COLOR==false) then
		return "";
	end

	if (highBandageCount>=RR_BENCH_BANDAGES+5) then
		return "|cFF00FF00";
	elseif (highBandageCount>=RR_BENCH_BANDAGES) then
		return "|cFFFFFF00";
	elseif (highBandageCount<RR_BENCH_BANDAGES) then
		return "|cFFFF0000";
	end
end

--===== Get Custom Track Color =====
function RaidRogue_getCustomColor(custom,i)

	if (RR_COLOR==false) then
		return "";
	end

	if(custom>=RR_CUSTOMBENCHES[i]+5) then
		return "|cFF00FF00";
	elseif(custom>=RR_CUSTOMBENCHES[i]) then
		return "|cFFFFFF00";
	elseif(custom<RR_CUSTOMBENCHES[i]) then
		return "|cFFFF0000";
	end
end

--===== Get Color for all Poisons =====
function RaidRogue_getPoisonColor(poison,i)

	if (RR_COLOR==false) then
		return "";
	end

	if(i==0) then
		if(poison>=RR_BENCH_ANESTHETIC+5) then
			return "|cFF00FF00";
		elseif(poison>=RR_BENCH_ANESTHETIC) then
			return "|cFFFFFF00";
		elseif(poison<RR_BENCH_ANESTHETIC) then
			return "|cFFFF0000";
		end
	end

	if(poison>=RR_BENCH_POISONS[i]+5) then
		return "|cFF00FF00";
	elseif(poison>=RR_BENCH_POISONS[i]) then
		return "|cFFFFFF00";
	elseif(poison<RR_BENCH_POISONS[i]) then
		return "|cFFFF0000";
	end
end

--===== Get Item Broken Color =====
function RaidRogue_getBrokenColor(broken)

	if (RR_COLOR==false) then
		return "";
	end

	if(broken==0) then
		return "|cFF00FF00";
	elseif(broken>0 and broken<=2) then
		return "|cFFFFFF00";	
	elseif(broken>2) then
		return "|cFFFF0000";
	end
end

--===== Get Ammo Color =====
function RaidRogue_getAmmoColor(ammo)

	if (RR_COLOR==false) then
		return "";
	end

	if(ammo>=RR_BENCH_AMMO+100) then
		return "|cFF00FF00";
	elseif(ammo>=RR_BENCH_AMMO) then
		return "|cFFFFFF00";
	elseif(ammo<RR_BENCH_AMMO) then
		return "|cFFFF0000";
	end
end

--===== Get vList Color =====
function RaidRogue_getVListColor(clientV, clientB)

	systemV=tonumber(RR_VERSION);

	if(RR_COLOR==false) then
		return "";
	end

	if(clientV>systemV) then
		return "|cFF0000FF";
	elseif(clientV==systemV) then
		if(clientB==RR_BETA) then
			return "|cFF00FF00";
		elseif(clientB and not RR_BETA) then
			return "|cFF0000FF";
		else
			return "|cFFFFFF00";
		end
	elseif(clientV<systemV) then
		return "|cFFFFFF00";
	end
end

--===== Get rList Color =====
function RaidRogue_getRListColor(clientStatus)

	if(string.find(clientStatus, "|c")) then
		return "";
	end

	if(RR_COLOR==false) then
		return "";
	end

	if(clientstatus=="Ready") then
		return "|cFF00FF00";
	elseif(clientStatus=="Buy Supplies") then
		return "|cFFFFFF00";
	elseif(clientStatus=="Needs Attention") then
		return "|cFFFFFF00";
	else
		return "|cFF0000FF";
	end
end
		

--===== Print Benchmark Value next to Current in Status Window =====
function RaidRogue_showBenchmark(bench)
	if(RR_SHOWBENCH) then
		if(RaidRogue:GetWidth()<RR_STATUSBWIDTH) then
			RaidRogue:SetWidth(RaidRogue:GetWidth()+20);
		end
		return "|cFFFFFFFF["..bench.."]|r";
	else
		return "";
	end
end

--=========================================
--		GUI Functions
--=========================================
		
--===== Save and Validate the Options GUI =====
function RaidRogue_validateOptions(arg1)

	-- Change the Benchmark Track Values According to Sliders.
	RR_BENCH_FLASH=RaidRogueOptions_FlashSlider:GetValue();
	RR_BENCH_AMMO=RaidRogueOptions_AmmoSlider:GetValue();
	RR_BENCH_POISONS[1]=RaidRogueOptions_CripSlider:GetValue();
	RR_BENCH_POISONS[2]=RaidRogueOptions_DeadlySlider:GetValue();
	RR_BENCH_POISONS[3]=RaidRogueOptions_MindSlider:GetValue();
	RR_BENCH_POISONS[4]=RaidRogueOptions_InstantSlider:GetValue();
	RR_BENCH_POISONS[5]=RaidRogueOptions_WoundSlider:GetValue();
	RR_BENCH_ANESTHETIC=RaidRogueOptions_AnestheticSlider:GetValue();

	RR_MAXCHARS=RaidRogueOptions_MaxCharSlider:GetValue();
	RR_BENCH_BANDAGES=RaidRogueOptions_BandageSlider:GetValue();

        -- Get Custom Track Strings and Add to RaidRogue Status Window
	for i=1,#RR_CUSTOMTRACKINPUTS do
		RR_CUSTOMTRACKS[i]=RR_CUSTOMTRACKINPUTS[i]:GetText();
	end

	--Read in the Benchmarks for the Custom Tracks if they exist
	for i=1,#RR_CUSTOMTRACKINPUTS do
		if(RR_CUSTOMTRACKS[i]~="") then
			RR_CUSTOMBENCHES[i]=RR_CUSTOMBENCHINPUTS[i]:GetValue();
		else
			RR_CUSTOMBENCHES[i]=RR_DCUSTOMBENCH;
		end
	end	

	--Move the Custom Tracks to lowest slot depending on which are available.
	for i= #RR_CUSTOMTRACKINPUTS,1,-1 do 
	--The last integer "-1" means, count down by 1's
		for k=i,1,-1 do
		--The last integer "-1" means, count down by 1's
			if(RR_CUSTOMTRACKS[i]~="" and RR_CUSTOMTRACKS[k]=="") then
				RR_CUSTOMTRACKS[k]=RR_CUSTOMTRACKS[i]
				RR_CUSTOMBENCHES[k]=RR_CUSTOMBENCHES[i]
				RR_CUSTOMTRACKS[i]=RR_DCUSTOMTRACK
				RR_CUSTOMBENCHES[i]=RR_DCUSTOMBENCH
			end
		end
	end

	--Put the current Tracks in their appropriate textbox
	for i=1,#RR_CUSTOMTRACKINPUTS do
		RR_CUSTOMTRACKINPUTS[i]:SetText(""..RR_CUSTOMTRACKS[i])
	end

	--Put the current benchmarks into the appropriate slider
	for i=1,#RR_CUSTOMBENCHINPUTS do
		RR_CUSTOMBENCHINPUTS[i]:SetValue(""..RR_CUSTOMBENCHES[i]);
	end	
	

	DebugOut("Custom Track 1: "..RR_CUSTOMTRACKS[1].." | Custom Track 2:"..RR_CUSTOMTRACKS[2].." | Custom Track 3:"..RR_CUSTOMTRACKS[3]);
	RaidRogue_Refresh();

end

--===== Restore the Options GUI with the Variables from the Last Session or if ResetOptions() has been called.
function RaidRogue_restoreOptions()

	-- Set the Values on the Slider to those from Last Session.

	RaidRogueOptions_FlashSlider:SetValue(RR_BENCH_FLASH);
	RaidRogueOptions_AmmoSlider:SetValue(RR_BENCH_AMMO);
	RaidRogueOptions_CripSlider:SetValue(RR_BENCH_POISONS[1]);
	RaidRogueOptions_DeadlySlider:SetValue(RR_BENCH_POISONS[2]);
	RaidRogueOptions_MindSlider:SetValue(RR_BENCH_POISONS[3]);
	RaidRogueOptions_InstantSlider:SetValue(RR_BENCH_POISONS[4]);
	RaidRogueOptions_WoundSlider:SetValue(RR_BENCH_POISONS[5]);
	RaidRogueOptions_AnestheticSlider:SetValue(RR_BENCH_ANESTHETIC);
	RaidRogueOptions_MaxCharSlider:SetValue(RR_MAXCHARS);
	RaidRogueOptions_BandageSlider:SetValue(RR_BENCH_BANDAGES);

	-- Set the Custom Track Values to those from Last Session.

	for i=1,#RR_CUSTOMTRACKINPUTS do
		RR_CUSTOMTRACKINPUTS[i]:SetText(""..RR_CUSTOMTRACKS[i])
	end
	
	for i=1,#RR_CUSTOMBENCHINPUTS do
		RR_CUSTOMBENCHINPUTS[i]:SetValue(""..RR_CUSTOMBENCHES[i]);
	end

end

--===== Function called on startup to populate the Stats frame with info.
function RaidRogue_restoreStats()

	RaidRogueStats_SessionStats_TrashKills:SetText("Trash Kills: "..RR_TRASHKILLS);
	RaidRogueStats_LifetimeStats_OTrashKills:SetText("Trash Kills: "..RR_OTRASHKILLS);
	RaidRogueStats_SessionStats_BossKills:SetText("Boss Kills: "..RR_BOSSKILLS);
	RaidRogueStats_LifetimeStats_OBossKills:SetText("Boss Kills: "..RR_OBOSSKILLS);
	RaidRogueStats_SessionStats_KillingBlows:SetText("Killing Blows: "..RR_KILLINGBLOWS);
	RaidRogueStats_LifetimeStats_OKillingBlows:SetText("Killing Blows: "..RR_OKILLINGBLOWS);
	RaidRogueStats_SessionStats_SelfDeaths:SetText("Player Deaths: "..RR_SELFDEATHS);
	RaidRogueStats_LifetimeStats_OSelfDeaths:SetText("Player Deaths: "..RR_OSELFDEATHS);
	RaidRogueStats_SessionStats_RaidWipes:SetText("Raid Wipes: "..RR_RAIDWIPES);
	RaidRogueStats_LifetimeStats_ORaidWipes:SetText("Raid Wipes: "..RR_ORAIDWIPES);
	RaidRogueStats_SessionStats_LootAcquired:SetText("Loot Acquired: "..RR_LOOTSACQUIRED);
	RaidRogueStats_LifetimeStats_OLootAcquired:SetText("Loot Acquired: "..RR_OLOOTSACQUIRED);
	
	RaidRogueStats_CritTracker_CritTrackerListPt1:SetText("");
	RaidRogueStats_CritTracker_CritTrackerListPt2:SetText("");

	for i=1,#RR_CRITLIST do
		local currentText=RaidRogueStats_CritTracker_CritTrackerListPt1:GetText();
		local currentText2=RaidRogueStats_CritTracker_CritTrackerListPt2:GetText();
		if(RR_CRITLIST[i]~=0) then
			if(currentText~=nil and currentText2~=nil) then
				RaidRogueStats_CritTracker_CritTrackerListPt1:SetText(currentText..""..i..".) "..RR_CRITLISTABILITIES[i].."|n");
				RaidRogueStats_CritTracker_CritTrackerListPt2:SetText(currentText2..""..RR_CRITLIST[i].." "..RR_CRITLISTCRITS[i].."|n");
			else
				RaidRogueStats_CritTracker_CritTrackerListPt1:SetText(""..i..".) "..RR_CRITLISTABILITIES[i].."|n");
				RaidRogueStats_CritTracker_CritTrackerListPt2:SetText(""..RR_CRITLIST[i].." "..RR_CRITLISTCRITS[i].."|n");
			end
		elseif(i==1) then
			RaidRogueStats_CritTracker_CritTrackerListPt1:SetText("No Info Available.");
			break;
		else
			break;
		end
	end
end

--===== Initialise Sliders =====
function RaidRogue_InitSlider(slider)
	local sl = getglobal(slider)
	local min,max=sl:GetMinMaxValues();

	sl.tooltipText = "Use to adjust benchmark values."; 

	getglobal(slider .. "Low"):SetText(min);
	getglobal(slider .. "High"):SetText(max); 
	getglobal(slider .. "Text"):SetText(""..sl:GetValue());
end

--=========================================
--		Reset Functions
--=========================================

--===== Reset All the Options GUI Variables to their Defaults. =====
function RaidRogue_resetOptions()

	-- Reset the Values on the Sliders to Defaults.
	RR_BENCH_FLASH=RR_DEFAULT_FLASH;
	RR_BENCH_AMMO=RR_DEFAULT_AMMO;
	RR_BENCH_POISONS[1]=RR_DEFAULT_POISON;
	RR_BENCH_POISONS[2]=RR_DEFAULT_POISON;
	RR_BENCH_POISONS[3]=RR_DEFAULT_POISON;
	RR_BENCH_POISONS[4]=RR_DEFAULT_POISON;
	RR_BENCH_POISONS[5]=RR_DEFAULT_POISON;
	RR_BENCH_ANESTHETIC=RR_DEFAULT_POISON;
	RR_MAXCHARS=RR_DEFAULT_MAXCHARS;
	RR_BENCH_BANDAGES=RR_DEFAULT_BANDAGES;

	--Reset the Custom Track Values to Defaults.
	for i=1,#RR_CUSTOMTRACKINPUTS do
		RR_CUSTOMTRACKS[i]=RR_DCUSTOMTRACK;
	end

	for i=1,#RR_CUSTOMBENCHINPUTS do
		RR_CUSTOMBENCHES[i]=RR_DCUSTOMBENCH;
	end

	--Calls RestoreOptions to output these to the options frame.	
	RaidRogue_restoreOptions();
	Out("|cFFFF0000RaidRogue:|r All Benchmark Options Reset Complete.");

end

--===== Reset Settings to Defaults =====
function RaidRogue_resetSettings()

	RR_LOCKED=false;
	RR_REFRESH=false;
	RR_COLOR=true;
	RR_STANDBY=false;
	RR_SHOWBENCH=false;
	RR_ROGUELOAD=false;
	RR_GROUPLOAD=false;
	RR_AUTOALERTS=true;
	RR_AUTOACHAT=true;
	RR_AUTOASYSTEM=true;
	RR_STATUSHEIGHT=262;
	RR_STATUSWIDTH=215;
	RR_STATUSBWIDTH=RR_STATUSWIDTH+20;
	RR_AUTOREPLYMSG="I am currently fighting a boss. Please send me a tell again later."
	RR_AUTOREPLY=false;
	RR_AUTORPARTY=false;
	RR_AUTORRAID=false;
	RR_STATTRACKER=true;
	RR_OFFICERREQUESTSONLY=false;
	RR_COUNTTRIVIAL=true;

	RaidRogue_Refresh();
	Out("|cFFFF0000RaidRogue:|r All Settings Reset Complete.");
end

--===== Reset ALL PvE Stats- Lifetime and Current. =====
function RaidRogue_resetAllPVEStats()

	RR_KILLINGBLOWS=0;
	RR_BOSSKILLS=0;
	RR_SELFDEATHS=0;
	RR_RAIDWIPES=0;
	RR_LOOTSACQUIRED=0;
	RR_TRASHKILLS=0;
	RR_OKILLINGBLOWS=0;
	RR_OBOSSKILLS=0;
	RR_OSELFDEATHS=0;
	RR_ORAIDWIPES=0;
	RR_OLOOTSACQUIRED=0;
	RR_OTRASHKILLS=0;
	RaidRogue_Refresh();
	Out("|cFFFF0000RaidRogue:|r All PvE Stat Reset Complete.")
end

--===== Reset only Lifetime PvE Stats. =====
function RaidRogue_resetLifePVEStats()

	RR_OKILLINGBLOWS=0;
	RR_OBOSSKILLS=0;
	RR_OSELFDEATHS=0;
	RR_ORAIDWIPES=0;
	RR_OLOOTSACQUIRED=0;
	RR_OTRASHKILLS=0;
	RaidRogue_resetNumTable(RR_CRITLIST);
	RaidRogue_resetStringTable(RR_CRITLISTCRITS);
	RaidRogue_resetStringTable(RR_CRITLISTAFFECTED);
	RaidRogue_resetStringTable(RR_CRITLISTABILITIES);
	RaidRogue_Refresh();
	Out("|cFFFF0000RaidRogue:|r Lifetime PvE Stat Reset Complete.")
end

--===== Reset only Session PvE Stats. =====
function RaidRogue_resetSessionPVEStats()

	RR_KILLINGBLOWS=0;
	RR_BOSSKILLS=0;
	RR_SELFDEATHS=0;
	RR_RAIDWIPES=0;
	RR_LOOTSACQUIRED=0;
	RR_TRASHKILLS=0;
	RaidRogue_Refresh();
	Out("|cFFFF0000RaidRogue:|r Session PvE Stat Reset Complete.")
end

--===== Reset the Crit List =====
function RaidRogue_ResetCritList()

	RaidRogue_resetNumTable(RR_CRITLIST);
	RaidRogue_resetStringTable(RR_CRITLISTCRITS);
	RaidRogue_resetStringTable(RR_CRITLISTABILITIES);
	RaidRogue_Refresh();
	Out("|cFFFF0000RaidRogue:|r Crit List Reset Complete.")
end

--===== Reset Filter Options =====
function Raidrogue_resetFilters()
	
	RR_FILTERLIST=RR_DFILTERLIST;
	RR_FILTERS=true;
	RaidRogue_Refresh();
	Out("|cFFFF0000RaidRogue:|r Filter Reset Complete.")
end

--=========================================
--		Module Functions
--=========================================

--===== Automatic Readiness Alerts =====
function RaidRogue_autoAlert()
	local zoneName=GetRealZoneText();
	local faction=UnitFactionGroup("player");
	
	if(faction=="Alliance" and RR_AUTOALERTS==true) then
		if(zoneName=="Stormwind City" or zoneName=="Ironforge" or zoneName=="Darnassus" or zoneName=="Exodar" or zoneName=="Shattrath City") then
			if(string.find(RR_OVERALLSTATUS,"Buy Supplies")) then
				if(not RaidRogue:IsVisible()) then
					RaidRogue_Toggle("RaidRogue");
				end

				--Output Text and Label to Remind User to Buy Supplies
				if(RR_AUTOACHAT==true) then
					Out("|cFFFF0000Raidrogue|r: You have entered "..zoneName.." and your status|cFFFF0000 Needs Attention|r. You should stock up on |cFF00FF00supplies|r for the next raid.")
				end

				if(RR_AUTOASYSTEM==true) then
					SystemOut("|cFFFF0000Recommendation|r: Buy Supplies while in "..zoneName..".");				
					SystemOut("|cFFFF0000RaidRogue|r: Status |cFFFF0000Needs Attention|r.")
				end

				RaidRogue_Title:SetText("RaidRogue: |cFFFFFF00Buy Supplies|r"); 

			end
		end
	elseif(faction=="Horde" and RR_AUTOALERTS==true) then
		if(zoneName=="Orgimmar" or zoneName=="Undercity" or zoneName=="Thunder Bluff" or zoneName=="Silvermoon City" or zoneName=="Shattrath City") then
			if(string.find(RR_OVERALLSTATUS,"Buy Supplies")) then			
				if(not RaidRogue:IsVisible()) then
					RaidRogue_Toggle("RaidRogue");
				end

				--Output Text and Label to Remind User to Buy Supplies
				if(RR_AUTOACHAT==true) then
					Out("|cFFFF0000RaidRogue|r: You have entered "..zoneName.." and your status|cFFFF0000 Needs Attention|r. You should stock up on |cFF00FF00supplies|r for the next raid.")
				end
				
				if(RR_AUTOASYSTEM==true) then
					SystemOut("|cFFFF0000Recommendation|r: Buy Supplies while in "..zoneName..".");				
					SystemOut("|cFFFF0000RaidRogue|r: Status |cFFFF0000Needs Attention|r.")
				end

				RaidRogue_Title:SetText("RaidRogue: |cFFFFFF00Buy Supplies|r"); 
			end
		end
	end
end



--===== Auto-Reply to Private Messages when in Combat =====
function RaidRogue_autoReply(message, author, unit)

	--First check to make sure the incoming message is not the Auto-Reply message, to prevent an infinite loop.
	if(message~=RaidRogue_processAutoReply(RR_AUTOREPLYMSG)) then
		
		--Use this code if you are in a raid group.
		if(GetNumRaidMembers()>0) then
			if(RR_AUTORRRAID==true) then
				if(InCombatLockdown()==1) then
					if(UnitIsBoss(unit)) then
						SendChatMessage(RaidRogue_processAutoReply(RR_AUTOREPLYMSG), "WHISPER", "Common", author);
							
					end
				end
			end
		
		--Use this code if you are in a party, not a raid or solo.
		elseif(GetNumPartyMembers()>=0) then
			if(RR_AUTORPARTY==true) then
				if(InCombatLockdown()==1) then
					if(RaidRogue_UnitIsBoss(unit)) then
						SendChatMessage(RaidRogue_processAutoReply(RR_AUTOREPLYMSG), "WHISPER", "Common", author);
					end
				end
			end
		end
	end			
end
		
--===== Processes Auto-Reply Message, allowing for Keyboard shortcuts. =====
function RaidRogue_processAutoReply(autoreply)
	
	local modAutoReply="";
	--Currently Recognized Shortcuts: $N=Boss Name, $P=Player Name, $HP=Boss Health, $I=Instance, $RM=Total Raid Members $RA=Raid Members Alive

	--Make Simple Replacements (Boss Name, Player Name, Boss Health Left, Instance Name, etc...)
	if(UnitName("target")~=nil and UnitName("target")~="Unknown") then
		modAutoReply=string.gsub(autoreply,"$B",""..UnitName("target"));
		modAutoReply=string.gsub(modAutoReply,"$HP",""..((UnitHealth("target")/UnitHealthMax("target"))*100).."%%");
	else
		modAutoReply=string.gsub(modAutoReply,"$B","Unknown");
		modAutoReply=string.gsub(modAutoReply,"$HP","100%%");
	end

	modAutoReply=string.gsub(modAutoReply,"$I",GetRealZoneText());
	modAutoReply=string.gsub(modAutoReply,"$P",UnitName("player"));
	
	--Make Number of Raiders and Living Raid Members Replacement
	modAutoReply=string.gsub(modAutoReply,"$RM",""..RaidRogue_getNumMembers())
	modAutoReply=string.gsub(modAutoReply,"$RA",""..RaidRogue_getNumAlive())

	--Output to Store Auto-Reply Message
	return modAutoReply;			

end

--===== Calculate PVE Stats =====
function RaidRogue_calcPVEStats(event, unit) --Note: the "unit" parameter must be a UnitID ("player","target", etc.) for the method to work correctly. It will not generate errors if it is not though.

	local subevent, affected, attacker, ability, amount, isCrit
	--Set to 11, so if levelCheck is unable to be calculated, nothing is done.
	local levelcheck=11;

	--Check when a unit is killed to see who killed it and if it's a boss.
	if(event=="COMBAT_LOG_EVENT_UNFILTERED") then
		subevent=arg2;
		attacker=arg4;
		affected=arg7;
		

		--Make sure the target is the unit is killed, otherwise use levelCheck=11, thus doing nothing.
		if(UnitName("target")==affected) then

			--Check to make sure the unit is not a boss, if it is the levelcheck passes anyway.
			if(UnitLevel("target")~="??") then
				levelcheck=(UnitLevel("player")-UnitLevel("target"))
			else
				levelcheck=0;
			end
		end

		if(subevent=="SPELL_DAMAGE" and attacker==UnitName("player")) then
			if(RR_COUNTTRIVIAL==true or (RR_COUNTTRIVIAL==false and levelcheck<=10)) then
				--Process the crit using: value, ability, performed on, crit?
				RaidRogue_processCrits(arg12, arg10, affected, arg17);
			end
		
		elseif(subevent=="RANGE_DAMAGE" and attacker==UnitName("player")) then	
			if(RR_COUNTTRIVIAL==true or (RR_COUNTTRIVIAL==false and levelcheck<=10)) then
				--Process the crit using: value, ability, performed on, crit?
				RaidRogue_processCrits(arg12, arg10, affected, arg17);
			end

		elseif(subevent=="SWING_DAMAGE" and attacker==UnitName("player")) then
			if(RR_COUNTTRIVIAL==true or (RR_COUNTTRIVIAL==false and levelcheck<=10)) then
				--Process the crit using: value, ability, performed on, crit?
				RaidRogue_processCrits(arg9, "Auto-Attack", affected,arg14);
			end
				
		elseif(subevent=="PARTY_KILL") then
			if(RR_COUNTTRIVIAL==true or (RR_COUNTTRIVIAL==false and levelcheck<=10)) then
				if(RaidRogue_UnitIsBoss("target")) then
					RR_BOSSKILLS=RR_BOSSKILLS+1;
					RR_OBOSSKILLS=RR_OBOSSKILLS+1;
				else
					RR_TRASHKILLS=RR_TRASHKILLS+1;
					RR_OTRASHKILLS=RR_OTRASHKILLS+1;
				end
			end

			--Check to see if the player is the killer.
			if(attacker==UnitName("player")) then
				if(RR_COUNTTRIVIAL==true or (RR_COUNTTRIVIAL==false and levelcheck<=10)) then
					RR_KILLINGBLOWS=RR_KILLINGBLOWS+1;
					RR_OKILLINGBLOWS=RR_OKILLINGBLOWS+1;
				end
			end

		elseif(subevent=="UNIT_DIED") then
			--check to see if the dead unit is in the player's group, but is not the player.
			if(RaidRogue_getNumMembers()>0) then
				if(RaidRogue_TableContains(RaidRogue_getGroupMemberNames(), affected) and UnitName("player")~=affected) then
					if(RaidRogue_getNumAlive()==0) then
						RR_RAIDWIPES=RR_RAIDWIPES+1;
						RR_ORAIDWIPES=RR_ORAIDWIPES+1;
					end
				end
			end
		end

	elseif(event=="PLAYER_DEAD") then
		RR_SELFDEATHS=RR_SELFDEATHS+1;
		RR_OSELFDEATHS=RR_OSELFDEATHS+1;
		if(RaidRogue_getNumAlive()==0) then
			RR_RAIDWIPES=RR_RAIDWIPES+1;
			RR_ORAIDWIPES=RR_ORAIDWIPES+1;
		end	
	
	--Check when loot is given out to see if the player has won. NOTE: Must be rolled for to be counted.
	elseif(event=="CHAT_MSG_LOOT") then

		pattern = string.gsub(LOOT_ITEM_SELF, "(%%s)", "(.+)")
		pattern2 = string.gsub(string.gsub(LOOT_ITEM_SELF_MULTIPLE, "(%%s)", "(.+)"), "(%%d)", "(.+)")
		
		--Check for the appropriate strings in the two loot messages.
		local _,_, item=string.find(arg1,pattern);
		local _,_, multitem, amount=string.find(arg1,pattern2);

		--Check to see if they were found, and then to see if they are "Green" rarity or higher.
		if(multitem and amount) then
			---take a look at this.
			_,_,itemRarity,_,_,_,_,_,_,_,_ = GetItemInfo(multitem);
			if(itemRarity>=2) then
				RR_LOOTSACQUIRED=RR_LOOTSACQUIRED+amount;
				RR_OLOOTSACQUIRED=RR_OLOOTSACQUIRED+amount;
			end

		elseif(item) then
			_,_,itemRarity,_,_,_,_,_,_,_,_ = GetItemInfo(item);
			if(itemRarity>=2) then
				RR_LOOTSACQUIRED=RR_LOOTSACQUIRED+1;
				RR_OLOOTSACQUIRED=RR_OLOOTSACQUIRED+1;
			end
		end
	end

	if(event=="PLAYER_DEAD" or event=="CHAT_MSG_LOOT" or event=="COMBAT_LOG_EVENT_UNFILTERED" or RR_REFRESH) then
		RaidRogueStats_SessionStats_TrashKills:SetText("Trash Kills: "..RR_TRASHKILLS);
		RaidRogueStats_LifetimeStats_OTrashKills:SetText("Trash Kills: "..RR_OTRASHKILLS);
		RaidRogueStats_SessionStats_BossKills:SetText("Boss Kills: "..RR_BOSSKILLS);
		RaidRogueStats_LifetimeStats_OBossKills:SetText("Boss Kills: "..RR_OBOSSKILLS);
		RaidRogueStats_SessionStats_KillingBlows:SetText("Killing Blows: "..RR_KILLINGBLOWS);
		RaidRogueStats_LifetimeStats_OKillingBlows:SetText("Killing Blows: "..RR_OKILLINGBLOWS);
		RaidRogueStats_SessionStats_SelfDeaths:SetText("Player Deaths: "..RR_SELFDEATHS);
		RaidRogueStats_LifetimeStats_OSelfDeaths:SetText("Player Deaths: "..RR_OSELFDEATHS);
		RaidRogueStats_SessionStats_RaidWipes:SetText("Raid Wipes: "..RR_RAIDWIPES);
		RaidRogueStats_LifetimeStats_ORaidWipes:SetText("Raid Wipes: "..RR_ORAIDWIPES);
		RaidRogueStats_SessionStats_LootAcquired:SetText("Loot Acquired: "..RR_LOOTSACQUIRED);
		RaidRogueStats_LifetimeStats_OLootAcquired:SetText("Loot Acquired: "..RR_OLOOTSACQUIRED);
	end

	if(subevent=="SWING_DAMAGE" or subevent=="RANGE_DAMAGE" or subevent=="SPELL_DAMAGE" or RR_REFRESH) then
		if(UnitName("player")==attacker or RR_REFRESH) then

			RaidRogueStats_CritTracker_CritTrackerListPt1:SetText("");
			RaidRogueStats_CritTracker_CritTrackerListPt2:SetText("");
			
			for i=1,#RR_CRITLIST do
				local currentText=RaidRogueStats_CritTracker_CritTrackerListPt1:GetText();
				local currentText2=RaidRogueStats_CritTracker_CritTrackerListPt2:GetText();

				if(RR_CRITLIST[i]~=0) then
					if(currentText~=nil and currentText2~=nil) then
						RaidRogueStats_CritTracker_CritTrackerListPt1:SetText(currentText..""..i..".) "..RR_CRITLISTABILITIES[i].."|n");
						RaidRogueStats_CritTracker_CritTrackerListPt2:SetText(currentText2..""..RR_CRITLIST[i].." "..RR_CRITLISTCRITS[i].."|n");
					else
						RaidRogueStats_CritTracker_CritTrackerListPt1:SetText(""..i..".) "..RR_CRITLISTABILITIES[i].."|n");
						RaidRogueStats_CritTracker_CritTrackerListPt2:SetText(""..RR_CRITLIST[i].." "..RR_CRITLISTCRITS[i].."|n");
					end
				elseif(i==1) then
					RaidRogueStats_CritTracker_CritTrackerListPt1:SetText("No Info Available.");
					break;
				else
					break;
				end
			end
		end
	end
end	

--===== Process High Crits =====
function RaidRogue_processCrits(crit, ability, affected, isCrit)
	for i=1,#RR_CRITLIST do
		--If the new crit is higher than the current one, replace and drop lower crits.
		if(crit>RR_CRITLIST[i] and RaidRogue_IsFiltered(ability)==false) then
			table.insert(RR_CRITLIST, i, crit);
			table.insert(RR_CRITLISTABILITIES, i, ability);
			if(isCrit~=nil and isCrit==1) then
				table.insert(RR_CRITLISTCRITS, i, "[Crit]");
			else
				table.insert(RR_CRITLISTCRITS, i , "");
			end
			break;
		end
	end

	--Remove any 'filtered' abilities from the list.
	RaidRogue_FilterCritList();

	--Remove any remaining crits that are past RR_CRITLISTNUM so the list remains 5 crits long.
	if(#RR_CRITLIST>=RR_CRITLISTNUM) then
		for i=#RR_CRITLIST,RR_CRITLISTNUM, -1 do
			table.remove(RR_CRITLIST,i);
			table.remove(RR_CRITLISTABILITIES,i);
			table.remove(RR_CRITLISTCRITS,i);
		end
	end
end

--=========================================
--		Syncing Functions
--=========================================

--===== Get Version Info From All Players in the Party/Raid =====
function RaidRogue_getPartyReadyInfo()
	
	RR_READYSREJECTED=0;
	RR_RAIDREADYNAMES={};
	RR_RAIDREADYSTATUS={};
	
	SendAddonMessage("RaidRogue","Ready Info Request","Raid");
	RaidRogueRCheck_ReadyList:SetText(RaidRogue_setToStatusMaxChars(UnitName("player"))..":   "..RR_OVERALLSTATUS.."|n");
	RaidRogueRCheck_ReadyRejects:SetText("Requests Rejected: "..RR_READYSREJECTED);

	table.insert(RR_RAIDREADYNAMES,1,""..UnitName("player"));
	table.insert(RR_RAIDREADYSTATUS,1,RR_OVERALLSTATUS);

	if(not RaidRogueRCheck:IsVisible()) then
		RaidRogue_Toggle("RaidRogueRCheck");
	end
	
	DebugOut("Sent Initial Addon Ready Request");
end


--===== Get Ready Info From All Players in the Party/Raid =====
function RaidRogue_getPartyVersionInfo()
	
	RR_VERSIONSREJECTED=0;
	RR_RAIDVERSIONNAMES={};
	RR_RAIDVERSIONVERSIONS={};
	RR_RAIDVERSIONBETAS={};
	
	SendAddonMessage("RaidRogue","Version Info Request","Raid");
	RaidRogueVCheck_VersionList:SetText(""..RaidRogue_setToStatusMaxChars(UnitName("player"))..":            "..RaidRogue_dispVersion(RR_VERSION, RR_BETA).."|n");
	RaidRogueVCheck_VersionRejects:SetText("Requests Rejected: "..RR_VERSIONSREJECTED);

	table.insert(RR_RAIDVERSIONNAMES,1,""..UnitName("player"));
	table.insert(RR_RAIDVERSIONVERSIONS,1,(tonumber(RR_VERSION)));
	table.insert(RR_RAIDVERSIONBETAS,1,RR_BETA);

	if(not RaidRogueVCheck:IsVisible()) then
		RaidRogue_Toggle("RaidRogueVCheck");
	end
	
	DebugOut("Sent Initial Addon Version Request");
end	

--===== Find out if any named player is using RaidRogue =====
function RaidRogue_getRRPlayerInfo(player)
	SendAddonMessage("RaidRogue","RAIDROGUE PRESENT?","WHISPER",player);
end

--===== Process Addon Messages, Determinining What to Send Back. Note: Does not take action if the sender is the player.
function RaidRogue_processAddonRequest(message, sender)

	local allowRequests=true;

	--==================================================================================================================
	--If only requesting from Raid Officers/Raid Leaders/Group Leaders make sure the person who has sent the addon message is of that rank.
	--==================================================================================================================

	if(RR_OFFICERREQUESTSONLY==true) then
		if(sender==RaidRogue_getPartyLeaderName() or RaidRogue_TableContains(sender, RaidRogue_getRaidOfficerNames())) then
			allowRequests=true;
		else
			allowRequests=false;
		end
	end

	--=======================================================
	--Receiving a request to send version info to the sender.
	--=======================================================

	if(message=="Version Info Request" and ""..UnitName("player")~=sender) then
		if(allowRequests==true) then
			if(RR_BETA) then
				SendAddonMessage("RaidRogue","BVERSION:v"..RR_VERSION.."","WHISPER",sender);
			else
				SendAddonMessage("RaidRogue","VERSION:v"..RR_VERSION.."","WHISPER",sender);
			end	
			
			DebugOut("Sent Reply to Addon Request.");

		else
			SendAddonMessage("RaidRogue","VERSION REQUEST REJECTED","WHISPER",sender);
			Out("|cFFFF0000RaidRogue|r: Rejected Version Info Request From: "..sender);
		end

	--===============================================================================
	--Receiving a reply to a version request, and processing to Version Check Dialog.
	--===============================================================================

	elseif(string.find(message,"VERSION:") or string.find(message,"BVERSION:")) then

		local clientVersion, versionNum, versionText, isBeta, newmessage;
		
		--Your Version: Yellow | Same Version as Player: Green | Higher Version than Player: Blue | Lower Version than Player: Red
		if(string.find(message,"BVERSION:")) then
			versionText=string.gsub(message,"BVERSION:v","")
			isBeta=true;
		else
			versionText=string.gsub(message,"VERSION:v","")
			isBeta=false;
		end

		clientVersion=(tonumber(versionText));
		versionNum=(tonumber(RR_VERSION));

		table.insert(RR_RAIDVERSIONNAMES,sender);
		table.insert(RR_RAIDVERSIONVERSIONS,clientVersion);
		table.insert(RR_RAIDVERSIONBETAS,isBeta);

		RaidRogue_sortVList(RR_RAIDVERSIONNAMES,RR_RAIDVERSIONVERSIONS,RR_RAIDVERSIONBETAS);

		for i=1,#RR_RAIDVERSIONNAMES do
			if(i==1) then
				if(RR_RAIDVERSIONNAMES[i]==""..UnitName("player")) then
					newmessage=">"..RaidRogue_setToStatusMaxChars(RR_RAIDVERSIONNAMES[i])..":        "..RaidRogue_dispVersion(RR_RAIDVERSIONVERSIONS[i], RR_RAIDVERSIONBETAS[i]).."|r|n";
				else
					newmessage=""..RaidRogue_setToStatusMaxChars(RR_RAIDVERSIONNAMES[i])..":        "..RaidRogue_getVListColor(RR_RAIDVERSIONVERSIONS[i], RR_RAIDVERSIONBETAS[i])..""..RaidRogue_dispVersion(RR_RAIDVERSIONVERSIONS[i], RR_RAIDVERSIONBETAS[i]).."|r|n";				
				end	
			else
				if(RR_RAIDVERSIONNAMES[i]==""..UnitName("player")) then
					newmessage=newmessage..">"..RaidRogue_setToStatusMaxChars(RR_RAIDVERSIONNAMES[i])..":        "..RaidRogue_dispVersion(RR_RAIDVERSIONVERSIONS[i], RR_RAIDVERSIONBETAS[i]).."|r|n";
				else
					newmessage=newmessage..""..RaidRogue_setToStatusMaxChars(RR_RAIDVERSIONNAMES[i])..":        "..RaidRogue_getVListColor(versionNum,RR_RAIDVERSIONVERSIONS[i])..""..RaidRogue_dispVersion(RR_RAIDVERSIONVERSIONS[i], RR_RAIDVERSIONBETAS[i]).."|r|n";
				end			
			end
		end	

		if(newmessage==nil) then
			DebugOut("String: finalmessage is nil") 
		end

		RaidRogueVCheck_VersionList:SetText(newmessage);

	--===========================================================
	--Receiving a request for ready status to send to the sender.
	--===========================================================

	elseif(message=="Ready Info Request" and ""..UnitName("player")~=sender) then
		if(allowRequests==true) then
			SendAddonMessage("RaidRogue","STATUS:"..RR_OVERALLSTATUS.."","WHISPER",sender);
			DebugOut("Sent Reply to Addon Request.");

		else
			SendAddonMessage("RaidRogue","READY REQUEST REJECTED","WHISPER",sender);
			Out("|cFFFF0000RaidRogue|r: Rejected Ready Info Request From: "..sender);
		end

	--===================================================================================
	--Receiving a reply from a ready status request and processing to Ready Check Dialog.
	--===================================================================================

	elseif(string.find(message,"STATUS:")) then

		local status, newmessage;

		status=string.gsub(message,"STATUS:","");

		table.insert(RR_RAIDREADYNAMES,sender);
		table.insert(RR_RAIDREADYSTATUS,status);

		RaidRogue_sortRList(RR_RAIDREADYNAMES,RR_RAIDREADYSTATUS);

		for i=1,#RR_RAIDREADYNAMES do	
			if(i==1) then			
				if(RR_RAIDREADYNAMES[i]==""..UnitName("player")) then
					newmessage=">"..RaidRogue_setToStatusMaxChars(RR_RAIDREADYNAMES[i])..":   "..RaidRogue_getRListColor(RR_RAIDREADYSTATUS[i])..""..RR_RAIDREADYSTATUS[i].."|r|n";

				else
					newmessage=""..RaidRogue_setToStatusMaxChars(RR_RAIDREADYNAMES[i])..":   "..RaidRogue_getRListColor(RR_RAIDREADYSTATUS[i])..""..RR_RAIDREADYSTATUS[i].."|r|n";
				end
			else
				if(RR_RAIDREADYNAMES[i]==""..UnitName("player")) then
					newmessage=newmessage..">"..RaidRogue_setToStatusMaxChars(RR_RAIDREADYNAMES[i])..":   "..RaidRogue_getRListColor(RR_RAIDREADYSTATUS[i])..""..RR_RAIDREADYSTATUS[i].."|r|n";	
				else
					newmessage=newmessage..""..RaidRogue_setToStatusMaxChars(RR_RAIDREADYNAMES[i])..":   "..RaidRogue_getRListColor(RR_RAIDREADYSTATUS[i])..""..RR_RAIDREADYSTATUS[i].."|r|n";			
				end	
			end
		end

		RaidRogueRCheck_ReadyList:SetText(newmessage);

	--===========================================================
	--Receiving an 'is RaidRogue Present' reply and processing.
	--===========================================================
	
	elseif(message=="RAIDROGUE PRESENT?: TRUE") then
		Out(sender.." is using RaidRogue");

	--===========================================================
	--Handling request rejections from other players.
	--===========================================================

	elseif(message=="VERSION REQUEST REJECTED") then
		DebugOut("Version Request Rejected");
		RR_VERSIONSREJECTED=RR_VERSIONSREJECTED+1;
		RaidRogueVCheck_VersionRejects:SetText("Requests Rejected: "..RR_VERSIONSREJECTED);

	elseif(message=="READY REQUEST REJECTED") then
		DebugOut("Ready Request Rejected");
		RR_READYSREJECTED=RR_READYSREJECTED+1;
		RaidRogueRCheck_ReadyRejects:SetText("Requests Rejected: "..RR_READYSREJECTED);

	--===========================================================
	--Handling an 'Is RaidRogue Present' Request.
	--===========================================================

	elseif(message=="RAIDROGUE PRESENT?") then
		SendAddonMessage("RaidRogue","RAIDROGUE PRESENT?: TRUE","WHISPER",sender);

	end

	DebugOut("Received and Processed Addon Reply");

end

--=========================================
--		Utility Functions
--=========================================

--===== Used to Extract Commands and Subcommands from Slash Commands.
function RaidRogue_getCmd(message)
 	if message then
 		local a,b,c=strfind(message, "(%S+)"); --contiguous string of non-space characters
 		if a then
 			return c, strsub(message, b+2);
 		else	
 			return "";
 		end
 	end
 end

--===== Get the Arguments from Slash Commands to Allow for Editing through Chat. =====
function RaidRogue_getArgument(msg)
 	if msg then
 		local a,b=strfind(msg, "=");
 		if a then
 			return strsub(msg,1,a-1), strsub(msg, b+1);
 		else	
 			return "";
 		end
 	end
 end

--===== Determine if the Target is a "boss" or not. ===== Note: It is passed the UnitID, not a name, otherwise only finding instance bosses will work. 
function RaidRogue_UnitIsBoss(unit)
	--Check to see if player is in a raid
	if(GetNumRaidMembers()>0) then
		for i=1,#RR_RAIDZONES do
			--Check if Current Zone is considered a "Raid" or the unit is a "World Boss"
			if(GetRealZoneText()==RR_RAIDZONES[i] or UnitClassification(unit)=="worldboss") then 
				--Check if Target is an NPC with a "??" level--
				if(UnitIsPlayer(unit)==false and UnitLevel(unit)==-1) then
					return true;
				end
			end
		end

	--Check to see if a player is in a party or solo.
	elseif(GetNumPartyMembers()>=0) then
		for i=1,#RR_ALLINSTANCEZONES do
			--Check to see if the current table is of the right continent
			if(RR_ALLINSTANCEZONES[i][1]==RaidRogue_GetContinent()) then
				for k=2,#RR_ALLINSTANCEZONES[i] do
					--Check to see if you're in an instance
					if(RR_ALLINSTANCEZONES[i][k][2]==GetRealZoneText()) then
						--Check to see if the target is a listed boss of the instance
						if(RaidRogue_TableContains(RR_ALLINSTANCEZONES[i][k],unit)) then
							return true
						end
					end
				end
			end
		end
	end
	return false;
end

--===== Filter the Crit List =====
function RaidRogue_FilterCritList()
	for i=1,#RR_CRITLISTABILITIES do
		if(RaidRogue_IsFiltered(RR_CRITLISTABILITIES[i])) then
			table.remove(RR_CRITLISTABILITIES, i);
			table.remove(RR_CRITLIST,i);
			table.remove(RR_CRITLISTCRITS,i);
		end
	end
end

--===== Check to see that the ability about to be added is not filtered. =====
function RaidRogue_IsFiltered(ability)
	if(RaidRogue_TableContains(RR_FILTERLIST, ability)) then
		return true;
	else
		return false;
	end
end

--===== Enhance Chat Messages "[On/Off]" =====
function RaidRogue_enhanceChat(boolean)
    if(boolean==true) then
	return "[|cFF00FF00On|r]"
    else
	return "[|cFFFF0000Off|r]"
    end
end

--===== A simple table utility to check if the parameter table contains a string =====
function RaidRogue_TableContains(table, containstring)
	
	for i=1,#table do
		if(table[i]==containstring) then
			return true;
		end
	end
	return false;
end

--===== Get Number of Group Members =====
function RaidRogue_getNumMembers()
	if(GetNumRaidMembers()>0) then
		return GetNumRaidMembers()
	elseif(GetNumPartyMembers()>0) then
		return GetNumPartyMembers()
	else
		return 1;
	end
end

--===== Get the Number of Living Members in a Group (Party or Raid) =====
function RaidRogue_getNumAlive()
	local aliveMembers=0;

	if(GetNumRaidMembers()>0) then
		for i=1,GetNumRaidMembers() do 
			_,_,_,_,_,_,_,_,isDead,_,_=GetRaidRosterInfo(i)
			if(isDead==false) then
				aliveMembers=aliveMembers+1;
			end
		end
	elseif(GetNumPartyMembers()>0) then
		if(UnitIsDeadOrGhost("party1")==nil) then
			aliveMembers=aliveMembers+1;
		end
		if(UnitIsDeadOrGhost("party2")==nil) then
			aliveMembers=aliveMembers+1;
		end
		if(UnitIsDeadOrGhost("party3")==nil) then
			aliveMembers=aliveMembers+1;
		end
		if(UnitIsDeadOrGhost("party4")==nil) then
			aliveMembers=aliveMembers+1;
		end
		if(UnitIsDeadOrGhost("player")==nil) then
			aliveMembers=aliveMembers+1;
		end
	else
		if(UnitIsDeadOrGhost("player")==nil) then
			aliveMembers=aliveMembers+1;
		end
	end
			
	return aliveMembers;

end	

--===== Get Group Members' Names =====
function RaidRogue_getGroupMemberNames()

	--Does not include player's name.

	local groupNames={};

	if(GetNumRaidMembers()>0) then
		for i=1,GetNumRaidMembers() do 
			name,_,_,_,_,_,_,_,_,_,_=GetRaidRosterInfo(i)
			table.insert(groupNames, name);
		end
	elseif(GetNumPartyMembers()>0) then

		if(UnitName("party1")) then
			table.insert(groupNames, ""..UnitName("party1"));
		end

		if(UnitName("party2")) then
			table.insert(groupNames, ""..UnitName("party2"));
		end

		if(UnitName("party3")) then
			table.insert(groupNames, ""..UnitName("party3"));
		end

		if(UnitName("party4")) then
			table.insert(groupNames, ""..UnitName("party4"));
		end
	end
	
	return groupNames;
end

--===== Toggle Windows =====
function RaidRogue_Toggle(frameName)
   local frame=getglobal(frameName);
   if (frame) then
   if(frame:IsVisible() ) then
      frame:Hide();
   else
      frame:Show();
   end
   end
end


--===== Toggling the Locking of the Frame On and Off =====
function RaidRogue_checkLocked(frameName)
   local frame= getglobal(frameName)
     if(RR_LOCKED==false) then
	frame:StartMoving();
     else
	Out("|cFFFF0000RaidRogue|r: Frame is Locked.")
     end	
end

--===== Concatenate Strings to be MaxChars if necessary =====
function RaidRogue_setToMaxChars(longstring)
	if(string.len(longstring)>RR_MAXCHARS) then
		return string.sub(longstring,0,RR_MAXCHARS).."... ";
	else
		return longstring;
	end
end

--===== Concatenate Names to be MaxChars if necessary (RogueReadyCheck and RogueVersionCheck) =====
function RaidRogue_setToStatusMaxChars(longstring)
	if(string.len(longstring)>RR_STATUSMAXCHARS) then
		return string.sub(longstring,0,RR_STATUSMAXCHARS)..".. ";
	else
		return longstring;
	end
end

--===== Using GetContinentInstances(), returns which continent player is located on =====
function RaidRogue_GetContinent()
	local curzone=GetRealZoneText()
	for i=1,3 do --3 continents

		local zoneNames= { GetMapZones(i) };
		local instNames=  RaidRogue_GetContinentInstances(i);
		local raidNames= RaidRogue_GetContinentRaids(i);

		if(RR_DEBUG) then
			RaidRogue_PrintTable(zoneNames);
			RaidRogue_PrintTable(instNames);
			RaidRogue_PrintTable(raidNames);
		end

		if(RaidRogue_TableContains(instNames, curzone) or RaidRogue_TableContains(zoneNames, curzone) or RaidRogue_TableContains(raidNames, curzone)) then
			return RaidRogue_continentToString(i);
		end
	end
	return "Unknown"
end

--===== A simple utility function to print out a table (1-D Only) =====
function RaidRogue_PrintTable(table)
	local text=""..table[1];
	
	for i=2,#table do
		text=text..", "..table[i];
	end

	Out(text);
end

--===== Returns a table of all Instances on the given continent.
function RaidRogue_GetContinentInstances(continent)
	result={};
	for k=1,#RR_ALLINSTANCEZONES[continent] do
		table.insert(result,RR_ALLINSTANCEZONES[continent][k][2])
	end
	return result;
end

--====== Returns a table of all raids on the given continent
function RaidRogue_GetContinentRaids(continent)
	result={};
	for k=1,#RR_ALLRAIDZONES[continent] do
		table.insert(result,RR_ALLRAIDZONES[continent][k])
	end
	return result;	
end

--===== Given the Complete Version List, it returns it sorted. =====
function RaidRogue_sortVList(vListNames, vListVers, vListBetas)

	--All three passed in array's should have the same length.

	--First Sort the list by Version.
	for i=1,#vListVers do
		for k=1,#vListVers-i do
			if(vListVers[k+1] > vListVers[k]) then
				RaidRogue_switchValues(vListNames, k, k+1);
				RaidRogue_switchValues(vListVers, k, k+1);
				RaidRogue_switchValues(vListBetas, k, k+1);
			end

			if(vListVers[k+1]==vListVers[k] and vListBetas[k+1]==true and vListBetas[k]==false) then
				RaidRogue_switchValues(vListNames, k, k+1);
				RaidRogue_switchValues(vListVers, k, k+1);
				RaidRogue_switchValues(vListBetas, k, k+1);
			end

			if(vListVers[k+1]==vListVers[k] and vListBetas[k+1]==vListBetas[k] and vListNames[k+1] < vListNames[k]) then
				RaidRogue_switchValues(vListNames, k, k+1);
				RaidRogue_switchValues(vListVers, k, k+1);
				RaidRogue_switchValues(vListBetas, k, k+1);
			end
		end
	end
end

--===== Given the Complete Ready List, it returns it sorted. =====
function RaidRogue_sortRList(rListNames, rListStatus)

	--All three passed in array's should have the same length.

	for i=1,#rListStatus do
		for k=1,#rListStatus-i do
			if(RaidRogue_compareOStatus(rListStatus[k+1],rListStatus[k])==1) then
				RaidRogue_switchValues(rListNames, k, k+1);
				RaidRogue_switchValues(rListStatus, k, k+1);
			end

			if(RaidRogue_compareOStatus(rListStatus[k+1],rListStatus[k])==0 and rListNames[k+1] < rListNames[k]) then
				RaidRogue_switchValues(rListNames, k, k+1);
				RaidRogue_switchValues(rListStatus, k, k+1);
			end
		end
	end
end

--===== Switches the indeces of two values, with ind1 being the value closer to the front of the array. =====
function RaidRogue_switchValues(table, ind1, ind2)
	local temp;

	temp=table[ind1];
	table[ind1]=table[ind2];
	table[ind2]=temp;
end

--===== Compares two Overall Status'.
function RaidRogue_compareOStatus(status1,status2)

	if(status1=="Needs Attention" or status1=="|cFFFF0000Needs Attention|r") then
		if(status2=="Buy Supplies" or status2=="|cFFFFFF00Buy Supplies|r" or status2=="Ready" or status2=="|cFF00FF00Ready|r") then
			return -1;
		elseif(status2=="Needs Attention" or status2=="|cFFFF0000Needs Attention|r") then
			return 0;
		end
	elseif(status1=="Buy Supplies" or status1=="|cFFFFFF00Buy Supplies|r") then
		if(status2=="Ready" or status2=="|cFF00FF00Ready|r") then
			return -1;
		elseif(status2=="Needs Attention" or status2=="|cFFFF0000Needs Attention|r") then
			return 1;
		elseif(status2=="Buy Supplies" or status2=="|cFFFFFF00Buy Supplies|r") then
			return 0;
		end
	elseif(status1=="Ready" or status1=="|cFF00FF00Ready|r") then
		if(status2=="Ready" or status2=="|cFF00FF00Ready|r") then
			return 0;
		elseif(status2=="Buy Supplies" or status2=="|cFFFFFF00Buy Supplies|r" or status2=="Needs Attention" or status2=="|cFFFF0000Needs Attention|r") then
			return 1;
		end
	end
end	

--===== Return the index of this string in the table.
function RaidRogue_getIndexOf(table, string)

	for i=1,#table do
		if(table[i]==string) then
			return i;
		end
	end
	
	return -1;
end

--===== Runs through OnEvent to refresh RaidRogue. =====
function RaidRogue_Refresh()
	RR_REFRESH=true;
	RaidRogue_OnEvent();
end

--===== Tests to see whether the player is in a party or raid.
function RaidRogue_IsInGroup() --Note: Works for player only.
	return GetNumRaidMembers()>0 or GetNumPartyMembers()>0;	
end

--===== Displays Version and Beta depending on which is True. =====
function RaidRogue_dispVersion(version, isBeta) 
	
	if(isBeta) then
		return "v"..string.format("%.1f", version).." BETA";
	else
		return "v"..string.format("%.1f", version);
	end
end

--===== Tests whether any UnitId is in a group. =====
function RaidRogue_UnitInGroup(unit) --Note: unit parameter must be a UnitID
	return UnitInParty(unit) or UnitInRaid(unit);
end

--===== Resets a table of numbers to 0's. =====
function RaidRogue_resetNumTable(table)
	for i=1,#table do
		table[i]=0;
	end
end

--===== Resets a table of strings to ""'s. =====
function RaidRogue_resetStringTable(table)
	for i=1,#table do
		table[i]="";
	end
end

--===== Function to return the party leader's name. =====
function RaidRogue_getPartyLeaderName()
	if(GetNumPartyMembers()>0) then
		if(GetPartyMember(1) and UnitIsPartyLeader("party1")) then
			return UnitName("party1");
		elseif(GetPartyMember(2) and UnitIsPartyLeader("party2")) then
			return UnitName("party2");
		elseif(GetPartyMember(3) and UnitIsPartyLeader("party3")) then
			return UnitName("party3");
		elseif(GetPartyMember(4) and UnitIsPartyLeader("party4")) then
			return UnitName("party4");
		else
			return UnitName("player");
		end
	end
end

--===== Function to return an array of all the Raid's Officers. =====
function RaidRogue_getRaidOfficerNames()
	
	local result={};

	if(GetNumRaidMembers()>0) then
		for i=1,GetNumRaidMembers() do
			name, rank,_,_,_,_,_,_,_,_,_=GetRaidRosterInfo(i)
			if(rank>0) then
				table.insert(result, name);
			end
		end
	end

	return result;
end

--===== Returns the continent in string form =====
function RaidRogue_continentToString(continent)
	if(continent==1) then
		return "Kalimdor";
	elseif(continent==2) then
		return "Eastern Kingdoms";
	elseif(continent==3) then
		return "Outland";
	else
		return "Unknown";

	end
end