--[[ 

title: RaidMobMarker
author: Nighti&Nyn@Blackhand
quick-description: help to set raidtargets


==Current Features==

==Help==
  - Click right lower corner to drag and reposition the toolbar.
  - Commands:
  - '''/rmm''' -> toogles show/hide toolbar.
  - '''/rmm auto n''' (n=0,1) -> 1=enables autoshow on join/leave party, 0=disables.
  - '''/rmm reset''' -> resets to default settings.
  - '''/rmm alpha n''' (n=0.5 - 1) -> sets toolbar transparency.
  - '''/rmm scale n''' (n=0.5 - 1) -> sets toolbar scale.
  - '''/rmm mark n''' (n=0-8) -> sets mark to current target (useful for use within macros).
	- '''/rmm mt n player (n=0-8) -> set mt target
  - '''/rmm allow n''' (n=0,1) -> 1=allow other party members to mark, 0=disallow.
  - '''/rmm whisper n''' (n=0,1) -> 1=send whisper to player on assign, 0=doesn't.
  - '''/rmm showtooltip n''' (n=0,1) -> 1=shows tooltip on mouse over mark, 0=doesn't.

== HISTORY ==

version 1.0
- Initial release.
version 1.1
- fixed some localization bugs
- activated automatic mark
version 1.2
- fixed bug with targeting
- changeable order of symbols
version 1.3
- fixed a bug with announce
- announce propagate now to the other RaidMobMarkers
version 1.3b
- new function string parser
- fixed bug with special chars while syncing
- send sync when you close a settings window
version 1.3c
- fxied a bug in sync-function
version 1.4
- whisper on unassign
- whisper just to people are in party/raid
version 1.5
- Bugfix: whisper on unassign checks options
- set assigned players as mts
version 1.5a
- new /raidmobmarker command
version 1.5b
- Patch 2.4
version 1.6
- new "/rmm mt" command
- settings-window redisgned
- Bugfix: Set Target without CC available now
- every assigned person can be set as mt separatly
- changed save behaviour
version 1.7
- you can see all available cc in a tooltip
version 1.7b
- Bugfix: uses player language for whispers

== TODO ==
- Markieren mit Mouse-Over als Option einbauen
  + Event: UPDATE_MOUSEOVER_UNIT
  + UnitID "mouseover"

]]


-- Global Vars
MobDB = {};
MobDB.Version = "MOBDB01";

-- Key Bindings
BINDING_HEADER_RMM = "RaidMobMarker";
BINDING_NAME_RMMMARKMODE = RaidMobMarker_MARKDESC;
BINDING_NAME_RMMSENDSET = RaidMobMarker_SENDSETCMD;
BINDING_NAME_RMMSKIPSET = RaidMobMarker_SKIPSET;

Profile = "ONEPROFILE";
PlayerDB = {};
PlayerDB.Version = "PDB01";
PlayerDB[Profile] = {};
PlayerDB[Profile]["1"] = {};
PlayerDB[Profile]["2"] = {};
PlayerDB[Profile]["3"] = {};
PlayerDB[Profile]["4"] = {};
PlayerDB[Profile]["5"] = {};
PlayerDB[Profile]["6"] = {};
PlayerDB[Profile]["7"] = {};
PlayerDB[Profile]["8"] = {};


IconDB = {};
IconDB["1"] = {};
IconDB["2"] = {};
IconDB["3"] = {};
IconDB["4"] = {};
IconDB["5"] = {};
IconDB["6"] = {};
IconDB["7"] = {};
IconDB["8"] = {};


RaidMobMarker = {};
RaidMobMarker.title       = "RaidMobMarker";
RaidMobMarker.version     = "1.7b";
RaidMobMarker.author      = "Nighti&Nyn@Blackhand";
--- comm. commands
RaidMobMarker.CMD_PREFIX = "RAIDMOBMARKER";
RaidMobMarker.CMD_MARK   = "MARK";
RaidMobMarker.CMD_SETOWNMARK = "MARKTARGET";
RaidMobMarker.CMD_ANNOUNCE_MARKS = "ANNOUNCEMARKS";
RaidMobMarker.CMD_TOKEN  = "#";


-- onload event handle
function RaidMobMarker.OnLoad()
	--register slash commands
	SLASH_RAIDMOBMARKER1 = "/rmm";
	SLASH_RAIDMOBMARKER2 = "/raidmobmarker";
	SlashCmdList["RAIDMOBMARKER"] = function(msg) 
		RaidMobMarker.Command(msg);
	end

	-- events to handle
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("PARTY_MEMBERS_CHANGED");
	this:RegisterEvent("PARTY_LEADER_CHANGED");
	this:RegisterEvent("CHAT_MSG_ADDON");
	this:RegisterEvent("PLAYER_TARGET_CHANGED");

	-- in order to close with ESC
	tinsert(UISpecialFrames,"RaidMobMarker_SettingsFrame");

	RaidMobMarker.Print("Version "..RaidMobMarker.version.." by "..RaidMobMarker.author.." loaded. Type \"/rmm help\" for help.");
end

-- When vars are loadad
function RaidMobMarker.OnVariablesLoaded()
	--Saved vars (gets defaults if needed)
	if (not RaidMobMarkerOptions) then
		RaidMobMarkerOptions = {
			XPos = 300,
			YPos = 200,
			Scale = 0.7,
			Alpha = 1,
			ShowTooltip = 1,
			AllowRemote = 0,
			AutoToogle = 1,
			SendWhisper = 0,
			SkipNotAssigned = 1,
			SetMTs = 1,
			ActiveSet = "Default",
			Debug = 0
		}
		

		if ( not RaidMobMarkerOptions.SkipNotAssigned ) then
			RaidMobMarkerOptions.SkipNotAssigned = 1;
		end
		if ( not RaidMobMarkerOptions.AllowRemote ) then
			RaidMobMarkerOptions.AllowRemote = 0;
		end
		if ( not RaidMobMarkerOptions.SendWhisper ) then
			RaidMobMarkerOptions.SendWhisper = 0;
		end
		if ( not RaidMobMarkerOptions.SetMTs ) then
			RaidMobMarkerOptions.SetMTs = 1;
		end
		if ( not RaidMobMarkerOptions.Debug ) then
			RaidMobMarkerOptions.Debug = 0;
		end
	end
	-- initial pos, size, etc
	RaidMobMarker_MainFrame:SetPoint("CENTER", "UIParent", "CENTER", 0 , 0); -- ,RaidMobMarkerOptions.XPos, RaidMobMarkerOptions.YPos);
	RaidMobMarker_MainFrame:SetScale(RaidMobMarkerOptions.Scale);
	RaidMobMarker_MainFrame:SetAlpha(RaidMobMarkerOptions.Alpha);

	--Temp vars
	RaidMobMarkerVars = {
		closedByUser = nil,
		inGroup = nil,
		TimeSinceLastUpdate = 0,
		MarksAssignments = {
			Mark1 = "",
			Mark2 = "",
			Mark3 = "",
			Mark4 = "",
			Mark5 = "",
			Mark6 = "",
			Mark7 = "",
			Mark8 = ""
		},
		MarksNames = {
			Mark1 = RaidMobMarker_MARKNAME1,
			Mark2 = RaidMobMarker_MARKNAME2,
			Mark3 = RaidMobMarker_MARKNAME3,
			Mark4 = RaidMobMarker_MARKNAME4,
			Mark5 = RaidMobMarker_MARKNAME5,
			Mark6 = RaidMobMarker_MARKNAME6,
			Mark7 = RaidMobMarker_MARKNAME7,
			Mark8 = RaidMobMarker_MARKNAME8
		}
	}
	-- PlayerDB
-- Reihenfolge: 8,1,2,3,4,6,5,7
	PlayerDB[Profile]["1"].Nr    = 1;
	PlayerDB[Profile]["2"].Nr    = 2;
	PlayerDB[Profile]["3"].Nr    = 3;
	PlayerDB[Profile]["4"].Nr    = 4;
	PlayerDB[Profile]["5"].Nr    = 5;
	PlayerDB[Profile]["6"].Nr    = 6;
	PlayerDB[Profile]["7"].Nr    = 7;
	PlayerDB[Profile]["8"].Nr    = 8;
	for i=1,8 do
		if ( PlayerDB[Profile][tostring(i)].Player == nil ) then
			PlayerDB[Profile][tostring(i)].Player = "";
		end
	end

	if not ( PlayerDB[Profile]["1"].Order ) then
		PlayerDB[Profile]["1"].Order = 1;
		PlayerDB[Profile]["2"].Order = 2;
		PlayerDB[Profile]["3"].Order = 3;
		PlayerDB[Profile]["4"].Order = 4;
		PlayerDB[Profile]["5"].Order = 5;
		PlayerDB[Profile]["6"].Order = 6;
		PlayerDB[Profile]["7"].Order = 7;
		PlayerDB[Profile]["8"].Order = 8;
	end

	IconDB["1"].Nr    = 1;
	IconDB["1"].Name  = RaidMobMarker_MARKNAME1;
	IconDB["2"].Nr    = 2;
	IconDB["2"].Name  = RaidMobMarker_MARKNAME2;
	IconDB["3"].Nr    = 3;
	IconDB["3"].Name  = RaidMobMarker_MARKNAME3;
	IconDB["4"].Nr    = 4;
	IconDB["4"].Name  = RaidMobMarker_MARKNAME4;
	IconDB["5"].Nr    = 5;
	IconDB["5"].Name  = RaidMobMarker_MARKNAME5;	
	IconDB["6"].Nr    = 6;
	IconDB["6"].Name  = RaidMobMarker_MARKNAME6;
	IconDB["7"].Nr    = 7;
	IconDB["7"].Name  = RaidMobMarker_MARKNAME7;
	IconDB["8"].Nr    = 8;
	IconDB["8"].Name  = RaidMobMarker_MARKNAME8;

	RaidMobMarker.SetRaidTargetOrder();
end

-- slash function handle
function RaidMobMarker.Command(msg)
	local cmd, param1, param2 = RaidMobMarker.ParamParser(msg);

	if ( cmd == "" ) then
		-- by default toggles visibility
		RaidMobMarker.ToggleBar();
	elseif(cmd=="help") then
		RaidMobMarker.ShowHelp();
	elseif(cmd=="reset") then
		RaidMobMarker.ResetPlayerSet();
	elseif(cmd=="auto") then
		RaidMobMarkerOptions.AutoToogle = param1; 
	elseif(cmd=="alpha") then
		RaidMobMarkerOptions.Alpha = param1; 
		RaidMobMarker_MainFrame:SetAlpha(RaidMobMarkerOptions.Alpha);
	elseif(cmd=="showtooltip") then
		RaidMobMarkerOptions.ShowTooltip = param1; 
	elseif(cmd=="scale") then
		RaidMobMarkerOptions.Scale = param1; 
		RaidMobMarker_MainFrame:SetScale(RaidMobMarkerOptions.Scale);
	elseif(cmd=="allow") then 
		RaidMobMarkerOptions.AllowRemote = param1;
	elseif(cmd=="whisper") then 
		RaidMobMarkerOptions.SendWhisper = param1;
	elseif(cmd=="skip") then 
		RaidMobMarkerOptions.SkipNotAssigned = param1;
	elseif(cmd=="debug") then 
		RaidMobMarkerOptions.Debug = param1;
	elseif(cmd=="mt") then
		if ( tonumber(param1) >=0 and tonumber(param1)<=8 and param2 ~= nil ) then
			RaidMobMarker.SetMT(param1, param2);
		end
	elseif(cmd=="mark") then
		if ( tonumber(param1) >=0 and tonumber(param1)<=8 ) then
			SetRaidTargetIcon("target", tonumber(param1));
			return;
		end
		RaidMobMarker.Print(RaidMobMarker_ERRICONNUMBER);
	else
		RaidMobMarker.Print(RaidMobMarker_ERRUNKNOWNCMD);
		RaidMobMarker.ShowHelp();
	end
end

-- Whenever an event triggers
function RaidMobMarker.OnEvent()
	if ( event == "VARIABLES_LOADED" ) then
		RaidMobMarker.OnVariablesLoaded();
		local orig = GameTooltip:GetScript("OnTooltipSetUnit");
		GameTooltip:SetScript("OnTooltipSetUnit", function(tooltip, ...)
			local unitName, unitid = tooltip:GetUnit();
			local zoneText = GetRealZoneText();
			local groupText = "UnassignedGroup";
			if ( MobDB[zoneText] ~= nil ) then
				if ( MobDB[zoneText][groupText] ~= nil ) then
					if ( MobDB[zoneText][groupText][unitName] ~= nil ) then
						if ( UnitExists(unitid) and MobDB[zoneText][groupText][unitName].Name == unitName ) then
							-- Croud Control Zeilenweise ausgeben
							if ( MobDB[zoneText][groupText][unitName]["CC"] ~= nil ) then
								for ccIndex, ccValue in pairs(MobDB[zoneText][groupText][unitName]["CC"]) do
									GameTooltip:AddLine(ccValue, 0.5, 0.5, 0.5, 1);
								end
							end
						end
					end
				end
			end

			return orig(tooltip, ...)
		end)
	--Handles party/raid changes to Toggle bar if needed (player must be leader/assistant in order to mark targets)
	elseif ( event == "PARTY_MEMBERS_CHANGED" or event == "PARTY_LEADER_CHANGED" ) then
		local inParty, inRaid = RaidMobMarker.GroupMode();
		RaidMobMarkerVars.inGroup = (inParty or inRaid);
		--checks if toolbar was not previously closed by user
		if ( RaidMobMarkerOptions.AutoToogle==1 and not RaidMobMarkerVars.closedByUser ) then
			if ( (inRaid and (IsRaidLeader() or IsRaidOfficer()) ) 
				  or (inParty and IsPartyLeader()) ) then -- in raid
				RaidMobMarker_MainFrame:Show();
			else
				RaidMobMarker.ResetPlayerSet();
				RaidMobMarker_MainFrame:Hide();
			end
		end
		if (not RaidMobMarkerVars.inGroup) then
			RaidMobMarkerVars.closedByUser = nil; --resets when leave group
		end
	elseif ( event=="CHAT_MSG_ADDON" and arg1 == RaidMobMarker.CMD_PREFIX and (arg3=="PARTY" or arg3=="RAID") ) then
		RaidMobMarker.CommHandler(arg2, arg4); --message, sender
	elseif ( RaidMobMarkerVars.markMode and event=="PLAYER_TARGET_CHANGED" ) then
		if ( UnitExists("target") ) then
			if not ( GetRaidTargetIndex("target") ) then
				-- if target is not marked yet, mark it
				RaidMobMarker.SetMark();
			end
		end
	end
end

-- prints command line help
function RaidMobMarker.ShowHelp()
	RaidMobMarker.Print(RaidMobMarker.title.." "..RaidMobMarker.version )
	RaidMobMarker.Print(COLOR_GOLD.."/rmm "..COLOR_END..COLOR_WHITE..RaidMobMarker_HELP1..COLOR_END);
	RaidMobMarker.Print(COLOR_GOLD.."/rmm auto n "..COLOR_END..COLOR_WHITE..RaidMobMarker_HELP2..COLOR_END);
	RaidMobMarker.Print(COLOR_GOLD.."/rmm reset "..COLOR_END..COLOR_WHITE..RaidMobMarker_HELP3..COLOR_END);
	RaidMobMarker.Print(COLOR_GOLD.."/rmm alpha n "..COLOR_END..COLOR_WHITE..RaidMobMarker_HELP4..COLOR_END);
	RaidMobMarker.Print(COLOR_GOLD.."/rmm scale n "..COLOR_END..COLOR_WHITE..RaidMobMarker_HELP5..COLOR_END);
	RaidMobMarker.Print(COLOR_GOLD.."/rmm mark n "..COLOR_END..COLOR_WHITE..RaidMobMarker_HELP6..COLOR_END);
	RaidMobMarker.Print(COLOR_GOLD.."/rmm allow n "..COLOR_END..COLOR_WHITE..RaidMobMarker_HELP7..COLOR_END);
	RaidMobMarker.Print(COLOR_GOLD.."/rmm whisper n "..COLOR_END..COLOR_WHITE..RaidMobMarker_HELP10..COLOR_END);
	RaidMobMarker.Print(COLOR_GOLD.."/rmm showtooltip n "..COLOR_END..COLOR_WHITE..RaidMobMarker_HELP8..COLOR_END);
	RaidMobMarker.Print(COLOR_GOLD.."/rmm skip n "..COLOR_END..COLOR_WHITE..RaidMobMarker_HELP9..COLOR_END);
	RaidMobMarker.Print(COLOR_GOLD.."/rmm mt n player"..COLOR_END..COLOR_WHITE..RaidMobMarker_HELP11..COLOR_END);
end

-- reset iconset
function RaidMobMarker.ResetPlayerSet()
	for index,value in pairs(PlayerDB[Profile]) do
		value.isSet = false
	end	
end

-- set markmode
function RaidMobMarker.SetMarkMode()
	if not ( RaidMobMarkerVars.markMode ) then
		RaidMobMarkerVars.markMode = true;
		RaidMobMarker.ResetPlayerSet();
		RaidMobMarker.Print( RaidMobMarker_MARKMODEACTIVATED );
	else
		RaidMobMarkerVars.markMode = false;
		RaidMobMarker.ResetPlayerSet();
		RaidMobMarker.Print( RaidMobMarker_MARKMODEDEACTIVATED );
	end
end

function RaidMobMarker.SetMark()
	local zoneText = GetRealZoneText();
	local groupText = "UnassignedGroup";
	local unitName = UnitName("target");
	local markIcon = 0;
	
	if ( MobDB[zoneText] ~= nil ) then
		if ( MobDB[zoneText][groupText] ~= nil ) then
			if ( MobDB[zoneText][groupText][unitName] ~= nil ) then
				if ( MobDB[zoneText][groupText][unitName].Name == unitName ) then
					markIcon = RaidMobMarker.GetIcon(unitName);
					markIconNr = tonumber(markIcon);
					if ( markIconNr > 0 ) then
						--RaidMobMarker.Print(COLOR_GREEN.."Der Mob "..unitName.." wird markiert "..markIconNr..COLOR_END);
						SetRaidTargetIcon("target", markIconNr);
					end
				end
			end
		end
	end
end

function RaidMobMarker.GetIcon(unitName)
	local zoneText = GetRealZoneText();
	local groupText = "UnassignedGroup";
	local markIcon = 0;

	if ( MobDB[zoneText][groupText][unitName]["CC"] ~= nil ) then
		for ccIndex, ccValue in pairs(MobDB[zoneText][groupText][unitName]["CC"]) do
			for index,value in pairs(PlayerDB[Profile]) do
				if ( value.CC == ccValue and value.isSet == false )  then
					if ( value.Player ~= "" ) then
						value.isSet = true;
						return value.Order;
					end
				end
			end

		end
	end
	return markIcon;
end

-- remove CC from selected target
function RaidMobMarker.RemoveCC(icon)
	if ( UnitExists("target") ) then
		local zoneText = GetRealZoneText();
		local groupText = "UnassignedGroup";
		local unitName = UnitName("target");

		if ( MobDB[zoneText] ~= nil ) then
			if ( MobDB[zoneText][groupText] ~= nil ) then
				if ( MobDB[zoneText][groupText][unitName] ~= nil ) then
					if ( MobDB[zoneText][groupText][unitName]["CC"] ~= nil ) then
						if ( PlayerDB[Profile][icon].CC ~= "" ) then
							local assignedCC = PlayerDB[Profile][icon].CC;
							for index,value in pairs(MobDB[zoneText][groupText][unitName]["CC"]) do
								if ( value == assignedCC ) then
									table.remove(MobDB[zoneText][groupText][unitName]["CC"], index);
								end
							end
						end
					end
				end
			end
		end

	end
end

-- save selected target
function RaidMobMarker.SaveTarget(icon)
	if not ( UnitExists("target") )then
		return;
	end
	
	local zoneText = GetRealZoneText();
	local groupText = "UnassignedGroup";
	local unitName = UnitName("target");
	local class, englishClass = UnitClass("target");
	local race, englishRace = UnitRace("target");


	if ( MobDB[zoneText] == nil ) then
		MobDB[zoneText] = {};
	end
	if ( MobDB[zoneText][groupText] == nil ) then
		MobDB[zoneText][groupText] = {};
	end
	if ( MobDB[zoneText][groupText][unitName] == nil ) then
		MobDB[zoneText][groupText][unitName] = {};
	end
	if ( MobDB[zoneText][groupText][unitName]["CC"] == nil ) then
		MobDB[zoneText][groupText][unitName]["CC"] = {};
	end

--	if ( unitName ~= MobDB[zoneText][groupText][unitName].Name ) then
		MobDB[zoneText][groupText][unitName].Name = unitName;
		MobDB[zoneText][groupText][unitName].Classification = UnitClassification("target");
		MobDB[zoneText][groupText][unitName].Class = englishClass;
		MobDB[zoneText][groupText][unitName].Creature = UnitCreatureFamily("target");
		MobDB[zoneText][groupText][unitName].CreatureType = UnitCreatureType("target");
		MobDB[zoneText][groupText][unitName].Level = UnitLevel("target");
		MobDB[zoneText][groupText][unitName].PowerType = UnitPowerType("target");
		MobDB[zoneText][groupText][unitName].Race = race;
		
		-- save CC in the MobDB
		local toSetCC = PlayerDB[Profile][icon].CC;
		local existCC = false;
		for index,value in pairs(MobDB[zoneText][groupText][unitName]["CC"]) do
			if ( toSetCC == value ) then
				existCC = true;
			end
		end
		if not ( existCC ) then
			table.insert(MobDB[zoneText][groupText][unitName]["CC"], PlayerDB[Profile][icon].CC);
		end

		PlayerDB[Profile][icon].isSet = true;
		
		-- Debugausgabe
		-- RaidMobMarker.Print(COLOR_GREEN.."Der Mob "..unitName.." wurde in die DB aufgenommen"..COLOR_END);



--[[
--	Lesen der Tabelle
--------------------------
--	for index,value in pairs(MobDB[zoneText][groupText]) do
--		mobName = value.Name;
--		mobClassification = value.Classification;
--	end
--]]
end




-- [[ MainFrame ]]

-- Shows/Hides the main bar
function RaidMobMarker.ToggleBar(arg)
	local show;

	if (arg) then
		show = arg;
	else
		if( RaidMobMarker_MainFrame:IsVisible() ) then
			show = 0;
		else
			show = 1;
		end
	end
	
	if( show==1 ) then
		RaidMobMarker_MainFrame:Show();
	else
		RaidMobMarker_MainFrame:Hide();
		if (RaidMobMarkerVars.inGroup) then --means closed by user when in group
			RaidMobMarkerVars.closedByUser = 1; 
		end
	end
end

function RaidMobMarker.MainFrame_OnUpdate(elapsed)
end

function RaidMobMarker.SetRaidTargetOrder()

	for id=1,8 do
		local iconNr = PlayerDB[Profile][tostring(id)].Order;
		local info = UnitPopupButtons["RAID_TARGET_"..iconNr];
		
		-- define Markbuttons 
		local iconButton = getglobal("RaidMobMarker_M"..id.."Icon");
 		iconButton:SetTexture("Interface\\TargetingFrame\\UI-RaidTargetingIcons");
		iconButton:SetTexCoord(info.tCoordLeft, info.tCoordRight, info.tCoordTop, info.tCoordBottom);
	
		-- define icons in the setting window
		local iconSet = getglobal("RaidMobMarker_Set"..id.."Icon");
 		iconSet:SetTexture("Interface\\TargetingFrame\\UI-RaidTargetingIcons");
		iconSet:SetTexCoord(info.tCoordLeft, info.tCoordRight, info.tCoordTop, info.tCoordBottom);

		-- define name
		local markName = IconDB[tostring(iconNr)].Name;
		PlayerDB[Profile][tostring(id)].Name = markName;
		
	end

end

function RaidMobMarker.GetNextOrderId(id)
	local nextId;
	if ( id == 8 ) then
		nextId = 1;
	else
		nextId = id + 1;
	end
	return nextId;
end

-- [[ Mark Button handlers ]] 

function RaidMobMarker.Mark_OnClick(arg1)
	--local icon = PlayerDB[Profile][tostring(this:GetID())].Order;
	local icon = this:GetID();
	local stringIcon = tostring(icon);
	this:SetChecked(0);
	if (arg1 == "LeftButton") then
		if ( UnitExists("target") ) then
			if ( IsRaidLeader() or IsRaidOfficer() ) then
				if ( PlayerDB[Profile][stringIcon].CC ~= "" ) then
					SetRaidTargetIcon("target", PlayerDB[Profile][tostring(icon)].Order); -- function defined in Blizz's TargetFrame.lua
					RaidMobMarker.SaveTarget(stringIcon);
				else
					SetRaidTargetIcon("target", PlayerDB[Profile][tostring(icon)].Order);
				end
			end
		end
	else
		--On right click assigns mark to current target if friendly 
		if( UnitIsFriend("player","target") ) then
			local mark =  "Mark"..icon;
			local textbox = getglobal("RaidMobMarker_Set"..icon.."Description");
			--local assignlabel = getglobal("RaidMobMarker_Set"..icon.."Assignment");
			local assignbutton = getglobal("RaidMobMarker_Set"..icon.."Clear");
			local mtoption = getglobal("RaidMobMarker_Set"..icon.."MTCheck");
			local icon = getglobal("RaidMobMarker_Set"..icon.."Icon");
			local lastPlayer = PlayerDB[Profile][tostring(stringIcon)].Player;
			--TODO: loeschen
			--assignlabel:SetText(UnitName("target"));
			--
			assignbutton:SetText(UnitName("target"));
			mtoption:Enable();
			icon:SetAlpha(1.0);
			PlayerDB[Profile][tostring(stringIcon)].Player = UnitName("target");
			local msg = format(RaidMobMarker_ASSIGNED, PlayerDB[Profile][tostring(stringIcon)].Name, UnitName("target"));
			-- einen Whisper an den betroffenen Spieler senden
			if ( RaidMobMarkerOptions.SendWhisper == 1 ) then
				RaidMobMarker.SendWhisper (RaidMobMarker_WHISPER1..PlayerDB[Profile][tostring(stringIcon)].Name..RaidMobMarker_WHISPER2, UnitName("target"));
				RaidMobMarker.SendWhisper (RaidMobMarker_WHISPER_AS, lastPlayer);
			end
			if ( RaidMobMarkerOptions.SetMTs == 1 ) then
				RaidMobMarker.SetMT(stringIcon, UnitName("target"));
				mtoption:SetChecked(true);
			end
			RaidMobMarker.Print(msg);
		else
			-- Remove Targeticon and CC
			SetRaidTargetIcon("target", 0);
			RaidMobMarker.RemoveCC(stringIcon);
		end
	end
end

function RaidMobMarker.Mark_OnEnter(arg1)
	if ( RaidMobMarkerOptions.ShowTooltip == 1 ) then
		local set, icon, assignedTo, color = RaidMobMarkerOptions.ActiveSet, this:GetID();
		assignedTo = PlayerDB[Profile][tostring(icon)].Player;
		if (not assignedTo or assignedTo=="" ) then
			color = { r=0.7, g=0.7, b=0.7}; -- gray
			assignedTo = RaidMobMarker_NOTASSIGNED;
		else
			color = { r=1.0, g=1.0, b=1.0};
		end
		GameTooltip:SetOwner(this, "ANCHOR_BOTTOMLEFT");
		GameTooltip:AddLine(assignedTo, color.r, color.g, color.b); -- assignment
		GameTooltip:AddLine(PlayerDB[Profile][tostring(icon)].CC, color.r, color.g, color.b); -- assignment
		GameTooltip:Show();
	end
end

function RaidMobMarker.MoveHandler_OnMouseDown(arg1)
	if (arg1 == "LeftButton") then
		RaidMobMarker_MainFrame:StartMoving();
	end
end

function RaidMobMarker.MoveHandler_OnMouseUp(arg1)
	if (arg1 == "LeftButton") then
		RaidMobMarker_MainFrame:StopMovingOrSizing();
	else
		RaidMobMarkerVars.Scaling = nil;
	end
end

function RaidMobMarker.MoveSettingsHandler_OnMouseDown(arg1)
	if (arg1 == "LeftButton") then
		RaidMobMarker_SettingsFrame:StartMoving();
	end
end

function RaidMobMarker.MoveSettingsHandler_OnMouseUp(arg1)
	if (arg1 == "LeftButton") then
		RaidMobMarker_SettingsFrame:StopMovingOrSizing();
	end
end

-- [[ Settings Frame ]]

-- load current profile onto settings
function RaidMobMarker.LoadSettings()
	for i=1,8 do
		local set = RaidMobMarkerOptions.ActiveSet;
		local mark = "Mark"..i;
		local orderbox = getglobal("RaidMobMarker_Set"..i.."Order");
		local textbox = getglobal("RaidMobMarker_Set"..i.."Description");
		--local assignlabel = getglobal("RaidMobMarker_Set"..i.."Assignment");
		local assignbutton = getglobal("RaidMobMarker_Set"..i.."Clear");
		local mtoption = getglobal("RaidMobMarker_Set"..i.."MTCheck");
		local icon = getglobal("RaidMobMarker_Set"..i.."Icon");
		local desc, assignment = PlayerDB[Profile][tostring(i)].CC, PlayerDB[Profile][tostring(i)].Player;
		local orderId = PlayerDB[Profile][tostring(i)].Order;
		orderbox:SetText(orderId);
		if ( assignment==nil or assignment=="" or desc==nil or desc=="") then
			icon:SetAlpha(0.3);
		else
			textbox:SetText(desc);
		  --assignlabel:SetText(assignment);
			assignbutton:SetText(assignment);
			icon:SetAlpha(1);
		end
		if ( assignment==nil or assignment=="" ) then
			mtoption:Disable();
		else
			mtoption:Enable();
		end
	end
	RaidMobMarker_ChkAutoToggle:SetChecked(RaidMobMarkerOptions.AutoToogle);
	RaidMobMarker_ChkShowTooltip:SetChecked(RaidMobMarkerOptions.ShowTooltip);
	RaidMobMarker_ChkSkipNA:SetChecked(RaidMobMarkerOptions.SkipNotAssigned);
	RaidMobMarker_AllowRemote:SetChecked(RaidMobMarkerOptions.AllowRemote);
	RaidMobMarker_SendWhisper:SetChecked(RaidMobMarkerOptions.SendWhisper);
	RaidMobMarker_AllowSetMT:SetChecked(RaidMobMarkerOptions.SetMTs);
	RaidMobMarker_ScaleSlider:SetValue(RaidMobMarkerOptions.Scale);
	RaidMobMarker_AlphaSlider:SetValue(RaidMobMarkerOptions.Alpha);
end

-- save current profile settings
function RaidMobMarker.SaveSettings()
	for i=1,8 do
		local set = RaidMobMarkerOptions.ActiveSet;
		local desc = getglobal("RaidMobMarker_Set"..i.."Description"):GetText();
		local orderbox = getglobal("RaidMobMarker_Set"..i.."Order"):GetText();
		local iconId = PlayerDB[Profile][tostring(i)].Order;
		PlayerDB[Profile][tostring(i)].CC = desc;
		PlayerDB[Profile][tostring(i)].Order = orderbox;
	end
	if ( RaidMobMarker_ChkAutoToggle:GetChecked() ) then
		RaidMobMarkerOptions.AutoToogle = 1;
	else
		RaidMobMarkerOptions.AutoToogle = 0;
	end
	if ( RaidMobMarker_ChkShowTooltip:GetChecked() ) then
		RaidMobMarkerOptions.ShowTooltip = 1;
	else
		RaidMobMarkerOptions.ShowTooltip = 0;
	end
	if ( RaidMobMarker_ChkSkipNA:GetChecked() ) then
		RaidMobMarkerOptions.SkipNotAssigned = 1;
	else
		RaidMobMarkerOptions.SkipNotAssigned = 0;
	end
	if ( RaidMobMarker_AllowRemote:GetChecked() ) then
		RaidMobMarkerOptions.AllowRemote = 1;
	else
		RaidMobMarkerOptions.AllowRemote = 0;
	end
	if ( RaidMobMarker_SendWhisper:GetChecked() ) then
		RaidMobMarkerOptions.SendWhisper = 1;
	else
		RaidMobMarkerOptions.SendWhisper = 0;
	end
	if ( RaidMobMarker_AllowSetMT:GetChecked() ) then
		RaidMobMarkerOptions.SetMTs = 1;
	else
		RaidMobMarkerOptions.SetMTs = 0;
	end
	RaidMobMarker.SetRaidTargetOrder();
	RaidMobMarker.Announce(0);
end

function RaidMobMarker.ToggleSettings()
	if ( RaidMobMarker_SettingsFrame:IsVisible() ) then
		RaidMobMarker.SaveSettings();
		RaidMobMarker_SettingsFrame:Hide();
	else
		RaidMobMarkerTab_OnClick(1);
		RaidMobMarker.LoadSettings();
		RaidMobMarker_SettingsFrame:Show();
	end
end

function RaidMobMarker.ClearAssign_OnClick()
	local p = this:GetParent();
	local i = p:GetID();
	local mark = "Mark"..i;
	local lastPlayer = PlayerDB[Profile][tostring(i)].Player;
	PlayerDB[Profile][tostring(i)].Player = "";
	local set = RaidMobMarkerOptions.ActiveSet;
	local textbox, icon = getglobal("RaidMobMarker_Set"..i.."Description"), getglobal("RaidMobMarker_Set"..i.."Icon");
	local assignButton = getglobal("RaidMobMarker_Set"..i.."Clear");
	local mtoption = getglobal("RaidMobMarker_Set"..i.."MTCheck");
	--TODO: loeschen
	--assignlabel:SetText("");
	--
	assignButton:SetText(RaidMobMarker_LB_CLEARASSIGN);
	icon:SetAlpha(0.3);
	if ( RaidMobMarkerOptions.SendWhisper == 1 ) then
		RaidMobMarker.SendWhisper(RaidMobMarker_WHISPER_AS, lastPlayer);
	end
	if ( RaidMobMarkerOptions.SetMTs == 1 ) then
		RaidMobMarker.SetMT(i, " " );
	end
	mtoption:SetChecked(false);
	mtoption:Disable();
end

function RaidMobMarkerScaleSlider_OnValueChanged(value)
	RaidMobMarkerOptions.Scale = value;
	RaidMobMarker_MainFrame:SetScale(RaidMobMarkerOptions.Scale);
end

function RaidMobMarkerAlphaSlider_OnValueChanged(value)
	RaidMobMarkerOptions.Alpha = value;
	RaidMobMarker_MainFrame:SetAlpha(RaidMobMarkerOptions.Alpha);
end

function RaidMobMarkerTab_OnClick(index)
	if ( not index ) then
		index = this:GetID();
	end

	if ( RaidMobMarker_SettingsFrame.numTabs == nil) then
		PanelTemplates_SetNumTabs(RaidMobMarker_SettingsFrame, 2);
	end

	PanelTemplates_SetTab(RaidMobMarker_SettingsFrame, index);
	RaidMobMarker_SettingsFrameMarks:Hide();
	RaidMobMarker_SettingsFrameSettings:Hide();
	if ( index == 1 ) then
		-- Marks Tab
		RaidMobMarker_SettingsFrameSettings:Hide();
		RaidMobMarker_SettingsFrameMarks:Show();
	elseif ( index == 2 ) then
		-- General Settings Tab
		RaidMobMarker_SettingsFrameMarks:Hide();
		RaidMobMarker_SettingsFrameSettings:Show();
	end
end


-- [[ Announce ]]
function RaidMobMarker.Announce( withChat )
	if not ( withChat ) then
		withChat = 1;
	end
	-- guess the channel to use (raid or party)
	local inParty, inRaid = RaidMobMarker.GroupMode();
	
	if (not inParty and not inRaid and RaidMobMarkerOptions.Debug==0) then
--		RaidMobMarker.Print(RaidMobMarker_NOTGROUPED);
		return;
	else
		-- guess proper channel
		local channel;
		if (inRaid) then
			channel = "RAID";
		else
			channel = "PARTY";
		end
		if ( withChat == 1 ) then
			SendChatMessage(RaidMobMarker_MARKSANNOUNCETITLE, "RAID_WARNING"); -- warns all about the announcement
		end
		--compose output
		--local orderNrs = { 8,1,2,3,4,6,5,7 }
		for i=1,8 do
			local skip = 0;
			local name, assignedTo, description;
			local iconNr = PlayerDB[Profile][tostring(i)].Order;
			name = IconDB[tostring(iconNr)].Name;
			assignedTo = PlayerDB[Profile][tostring(i)].Player;
			description = PlayerDB[Profile][tostring(i)].CC;

			if ( name == nil or name == "" or name == " " ) then
				name = "";
				skip = 1;
			end
			if ( assignedTo == nil or assignedTo == "" or assignedTo == " " ) then
				assignedTo = "";
				skip = 1;
			end
			if ( description == nil or description == "" or description == " ") then
				description = "";
				skip = 1;
			end
			if ( RaidMobMarkerOptions.SkipNotAssigned == 0 ) then
				skip = 0;
			end

			if ( skip == 0 ) then
				if ( withChat == 1 ) then
					local msg=format("%s: %s >> %s", name, description, assignedTo);
					SendChatMessage(msg, channel);
				end
			end
	  	-- remote send
			if ( (inRaid and (IsRaidLeader() or IsRaidOfficer()) ) or (inParty and IsPartyLeader()) ) then -- in raid
				local cmd = RaidMobMarker.CMD_ANNOUNCE_MARKS..RaidMobMarker.CMD_TOKEN..assignedTo..RaidMobMarker.CMD_TOKEN..iconNr..RaidMobMarker.CMD_TOKEN..description;
   	 	 	SendAddonMessage(RaidMobMarker.CMD_PREFIX, cmd, channel);
			end
			-- publish mt list
			if ( RaidMobMarkerOptions.SetMTs == 1 ) then
				RaidMobMarker.SetMT(i, assignedTo);
			end
		end
	end
end

-- [[ Addon Comms / Message Format:	"COMMAND..TOKEN..PARAM" ]]
function RaidMobMarker.CommHandler( msg, sender )
	--get sender's unitid 
	local target = RaidMobMarker.GetUnitIdByName(sender);
--	local _, _, cmd, param1, param2, param3 = string.find(msg, "(%a+)"..RaidMobMarker.CMD_TOKEN.."(%a+)"..RaidMobMarker.CMD_TOKEN.."(%d+)"..RaidMobMarker.CMD_TOKEN.."(%a+)");
	local splitResult = RaidMobMarker.SplitString ( RaidMobMarker.CMD_TOKEN, msg );
	local cmd = splitResult[1];
	local param1 = splitResult[2];
	local param2 = splitResult[3];
	local param3 = splitResult[4];
	--if (RaidMobMarkerOptions.Debug==1) then
--		RaidMobMarker.Print("Debug>msg="..msg);
--		RaidMobMarker.Print("Debug>sender="..sender);
--		RaidMobMarker.Print("Debug>cmd="..cmd);
--		RaidMobMarker.Print("Debug>param1="..param1);	
--		RaidMobMarker.Print("Debug>param2="..param2);
--		RaidMobMarker.Print("Debug>param3="..param3);	
--		RaidMobMarker.Print("Debug>target="..target);
	--end

	-- set own mark
	if ( cmd == RaidMobMarker.CMD_SETOWNMARK ) then
		local playerName = param1;
		local iconNr = param2;
		-- Wenn Fernsteuerung erlaubt, dann setze auf aktuelles Target das Zeichen
		if ( RaidMobMarkerOptions.AllowRemote == 1 ) then
			--RaidMobMarker.Print("Debug>Spieler "..playerName.. " soll "..iconNr.." setzen!");
			local myName = UnitName("player");
			if ( myName == playerName ) then	
				--RaidMobMarker.Print("Debug>Ich soll "..iconNr.." setzen!");
				if( UnitExists("target") ) then
					SetRaidTargetIcon("target", tonumber(iconNr));
				end
			end
		end
	end

	-- set announce
	if ( cmd == RaidMobMarker.CMD_ANNOUNCE_MARKS ) then
		local playerName = param1;
		local iconNr = param2;
		local playerCC = param3;
		if ( RaidMobMarkerOptions.AllowRemote == 1 ) then
			local playerNr = RaidMobMarker.GetPlayerNrByIcon(tostring(iconNr));
      PlayerDB[Profile][tostring(playerNr)].Player = playerName;
      PlayerDB[Profile][tostring(playerNr)].CC = playerCC;
			RaidMobMarker.LoadSettings();
		end
	end
		
end

function RaidMobMarker.GetPlayerNrByIcon(iconNr)
	for index,value in pairs(PlayerDB[Profile]) do
		if ( value.Order == iconNr ) then
			return value.Nr;
		end
	end
end

--send set command
function RaidMobMarker.SendSetCmd()
  local inParty, inRaid = RaidMobMarker.GroupMode();
	if (not inParty and not inRaid ) then
		RaidMobMarker.Print(RaidMobMarker_NOTGROUPED);
		return;
  else
    -- guess proper channel
    local channel;
    if (inRaid) then
      channel = "RAID";
    else
      channel = "PARTY";
    end
		for index,value in pairs( PlayerDB[Profile] ) do
      local playerName = value.Player;
      local iconNr = value.Order;
			if ( playerName ~= "" ) then
				local cmd = RaidMobMarker.CMD_SETOWNMARK..RaidMobMarker.CMD_TOKEN..playerName..RaidMobMarker.CMD_TOKEN..iconNr..RaidMobMarker.CMD_TOKEN.."a";
				SendAddonMessage(RaidMobMarker.CMD_PREFIX, cmd, channel);
			end
		end
	end
end

--get UnitId 
function RaidMobMarker.GetUnitIdByName(name)
	local inParty, inRaid = RaidMobMarker.GroupMode();
	local z, gtype, target;
	local me = UnitName("player");
	if ( inRaid ) then
		z = GetNumRaidMembers();
		gtype = "raid";
	elseif ( inParty ) then
		z = GetNumPartyMembers();
		gtype = "party";
	else
		return ""; 
	end
	if ( UnitName("player")==name ) then
		return "player";
	end
	for i = 1,z do
		if ( UnitName(gtype..i)==name ) then
			return gtype..i;
		end
	end
	return "";
end

-- Parse data after /slash command
function RaidMobMarker.ParamParser(msg)
 	if msg then
 		local a,b,c=strfind(msg, "(%S+)"); --contiguous string of non-space characters
 		if a then
 			return c, strsub(msg, b+2);
 		else	
 			return "";
 		end
 	end
end

function RaidMobMarker.SplitString(inSplitPattern, inString)
	outResults = { };
  local theStart = 1;
  local theSplitStart, theSplitEnd = string.find( inString, inSplitPattern, theStart );
  while theSplitStart do
    table.insert( outResults, string.sub( inString, theStart, theSplitStart-1 ) );
    theStart = theSplitEnd + 1;
    theSplitStart, theSplitEnd = string.find( inString, inSplitPattern, theStart );
  end
  table.insert( outResults, string.sub( inString, theStart ) );
  return outResults;
end

-- print function
function RaidMobMarker.Print (msg)
	DEFAULT_CHAT_FRAME:AddMessage(COLOR_ORANGE..RaidMobMarker.title.."> "..COLOR_END..msg);
end

-- group mode function
function RaidMobMarker.GroupMode()
	--returns notGrouped, inParty, inRaid
	local inRaid = (GetNumRaidMembers() > 0);
	local inParty = (GetNumPartyMembers() > 0);
	return inParty, inRaid; 
end

-- whisper function
function RaidMobMarker.SendWhisper(msg, player)
	if ( UnitName("player")~=player ) then
		if ( RaidMobMarker.GetUnitIdByName(player) ~= "" ) then
			local language = GetDefaultLanguage("player");
			SendChatMessage(msg, "WHISPER", language, player);
		end
	end
end

-- set mt
function RaidMobMarker.SetMT(nr, player)
	local msg = "SET " .. nr .. " " .. player;
	SendAddonMessage("oRA", msg, "RAID");
	SendAddonMessage("CTRA", msg, "RAID");
end

-- set all mts
function RaidMobMarker.SetSelectedMTS()
	-- let rmm manage mt list
  if (RaidMobMarkerOptions.SetMTs == 1 ) then
	  for i=1,8 do
			if ( getglobal("RaidMobMarker_Set"..i.."MTCheck"):GetChecked() ) then
				local playerNr = RaidMobMarker.GetPlayerNrByIcon(tostring(i));
				local playerName = PlayerDB[Profile][tostring(playerNr)].Player;
				if ( playerName ~= "" ) then
					RaidMobMarker.SetMT(i, playerName);
				end
			else
				RaidMobMarker.SetMT(i," ");
			end
	  end
	else
		local p = this:GetParent();
		local i = p:GetID()
		if ( getglobal("RaidMobMarker_Set"..i.."MTCheck"):GetChecked() ) then
			local playerNr = RaidMobMarker.GetPlayerNrByIcon(tostring(i));
			local playerName = PlayerDB[Profile][tostring(playerNr)].Player;
			if ( playerName ~= "" ) then
				RaidMobMarker.SetMT(i, playerName);
			end
		else
			RaidMobMarker.SetMT(i," ");
		end
	end
end

---------------------------------------------------
---------------------------------------------------
function RaidMobMarker.SetMTButton(id)
	local p = this:GetParent();
  local i = p:GetID();
	local MTButton = getglobal("RaidMobMarker_Set"..i.."MenuButton");
	--RaidMobMarker.Print(i); 
	UIDropDownMenu_SetSelectedID(this, id);
end

function MyDropDownMenu_OnLoad()
	info            = {};
	info.text       = "   ";
	info.func       = RaidMobMarker.SetMTButton(); 
       
	-- Add the above information to the options menu as a button.
	UIDropDownMenu_AddButton(info);

	info            = {};
	info.text       = "MT1";
	info.func       = RaidMobMarker.SetMTButton(1); 
       
	-- Add the above information to the options menu as a button.
	UIDropDownMenu_AddButton(info);
end


function MyDropDownMenuButton_OnClick() 
	local p = this:GetParent();
  local i = p:GetID();
	local MTButton = getglobal("RaidMobMarker_Set"..i.."MenuButton");

	ToggleDropDownMenu(1, nil, this, MTButton, 0, 0);
end
