local Tablet = AceLibrary("Tablet-2.0")
local L = AceLibrary("AceLocale-2.2"):new("RaidMarshal")
local BabbleClass = AceLibrary("Babble-Class-2.2")

-- fubar method: show tooltip on fubar mouseover 
--      this shows first: the current group participants and their duration in group
--      second (under that): the bench of online players and their attendance scores and time online since track start

function RaidMarshal:AddRaidTablet()	
	local summaryCat = Tablet:AddCategory(
		'text', "Current Raid: "..self.currentRaid.zoneName,
		'columns', 2,
		'size', 16
	)
	summaryCat:AddLine(
		'text', 'Raid Leader: '..self.currentRaid.currentLeader,		
		'text2', 'Log Owner: '..self.currentRaid.owner
	)	
	local startString
	if not self.currentRaid.startTime then
		startString = "Not Started"
	else
		startString = date("%I:%M %p",self.currentRaid.startTime)
	end
	summaryCat:AddLine(
		'text', 'Start Time: '..startString,
		'text2', 'Duration: '..math.floor(self.currentRaid.duration/60)..'m'
	)
	local roles = {"Tank","Healer","DPS","Non Raiders"}
	local rolesPlural = {"Tanks","Healers","DPS", "Non Raiders"}
	local roleCategories = {}	
	local roleSizes = {}
	
	local participantCat = Tablet:AddCategory(
		'text', "Participants",
		'columns', 2,
		'size', 14
	)	
	
	for name, duration in pairs(self.currentRaid.participantDurationTable) do
		local char = RMCharacter:Load(name)
		participantCat:AddLine(
			'text',RMBrowser.GetNameWithMain(char),
			'text2',math.floor(duration / 60).."m"
		)
	end
	
	local benchCat = Tablet:AddCategory(
		'text', "Bench",
		'columns', 2,
		'size', 14
	)		
	
	for name, duration in pairs(self.currentRaid.benchDurationTable) do
		local char = RMCharacter:Load(name)
		benchCat:AddLine(
			'text',RMBrowser.GetNameWithMain(char),
			'text2',math.floor(duration / 60).."m"
		)
	end					                 
	
end

function RaidMarshal:AddNoRaidTablet()
					
	local roleCategories = {}
			
	for role, roleTable in pairs(RMCharacter.roleOnlineMap) do							
		local r, g, b = RMBrowser.GetRoleColor(role)		
		local cat = Tablet:AddCategory(			
			'text', RMCharacter:GetRolePlural(role) .. " (".. #roleTable ..")",
			'textR', r,
			'textG', g,
			'textB', b,
			'columns',3,
			'size',16
		)
		
		for i, charName in ipairs(roleTable) do
			local character = RMCharacter:Load(charName)
			local altCharacter = nil		
			if character.mainName then
				altCharacter = character
				character = RMCharacter:Load(altCharacter.mainName)
			end			
			if altCharacter then			
				cat:AddLine(
					'text', RMBrowser.GetNameWithMain(altCharacter),
					'indentation', 10				
				)
			else
				cat:AddLine(
					'text', RMBrowser.GetNameWithColor(character),
					'indentation', 10			
				)
			end			
		end		
				
	end	
end

function RaidMarshal:OnTooltipUpdate()
	if not self.hasSynced then return end
	RMCharacter:BuildOnlineMap()
	if self.currentRaid then
		self:AddRaidTablet()
	else
		self:AddNoRaidTablet()
	end
	--[[
    if self.db.profile.currentRaid then    
        local headerCat = Tablet:AddCategory(
            'text',self.db.profile.currentRaid.zoneName.." ("..self.db.profile.currentRaid.currentLeader..")",
            'columns', 1           
        )
		if self.db.profile.currentRaid.startTime then
	        headerCat:AddLine(
	            'text',"Started: "..date("%H:%M",self.db.profile.currentRaid.startTime).." Server Time"
	        )
		end
		
        local benchCat = Tablet:AddCategory(
            'text', "Bench",
            'columns', 2
        )
        benchCat:AddLine(
            'text',"Player",
            'text2',"Time on Bench"
        )
        for key, value in pairs(self.db.profile.currentRaid.benchDurationTable) do
            benchCat:AddLine('text',key, 'text2',value.."m")
        end
        
        local raidCat = Tablet:AddCategory(
            'text', "Raid Participants",
            'columns', 2
        )
        raidCat:AddLine(
            'text',"Player",
            'text2',"Time in Raid"
        )
        for key, value in pairs(self.db.profile.currentRaid.participantDurationTable) do
            raidCat:AddLine('text',key, 'text2',value.."m")
        end

        Tablet:SetHint("Click a bench member to invite")        
    else
        local onlineCat = Tablet:AddCategory(
            'text',GetGuildInfo("player"),
            'columns', 1           
        )
        
        local numGuildMembers = GetNumGuildMembers(true)
        local name, rank, rankIndex, level, characterClass, zone, note, officernote, online, status
        local classcolorR, classcolorG, classcolorB
        for i = 1, numGuildMembers, 1 do
            name, rank, rankIndex, level, characterClass, zone, note, officernote, online, status = GetGuildRosterInfo(i)
            -- if the guild member is online and not an alt, then add them to the player database
            if online then                                                                        
                    classcolorR, classcolorG, classcolorB = BabbleClass:GetColor(characterClass)                    
                    onlineCat:AddLine(
                        'text', name,
                        'textR',classcolorR,
                        'textG',classcolorG,
                        'textB',classcolorB
                    )                                
            end
        end
        
        Tablet:SetHint("Join or start a raid group to enable tracking")        
    end 
	]]           
    -- as a rule, if you have an OnClick or 
    -- OnDoubleClick or OnMouseUp or OnMouseDown, 
    -- you should set a hint.
end

RaidMarshal.options = {    
    type='group',
    name="RaidMarshal",
    args = {                         
        start = {
            type="toggle",
            name="Tracking",			
            desc="Toggle tracking current raid group",
            set = function(value)
            	if not RaidMarshal.hasSynced then
            		RaidMarshal:Print("Waiting for synchronization")
					return
            	end 
            	if RaidMarshal:IsTracking() then 
                    RaidMarshal:StopTracking() 
                else 
                    RaidMarshal:StartTracking() 
                end 
            end,
            get = function() return RaidMarshal:IsTracking() end,
            order = 10
        },                        
        durationInterval = {
           type = "range",		   
           name = "Duration Update Interval (minutes)",
           min = 5,
           max = 30,
           step = 5,
           desc = "Duration Update Interval (minutes)",
           get = function() return RaidMarshal.db.profile.durationInterval end,
           set = function(x) RaidMarshal.db.profile.durationInterval = x end,
           order = 25
        },
		scoringGroup = {
		   type = "group",		   
		   name = "Scoring",		   
		   desc = "Whether to score 10 or 25 person raids or both",
		   args = {
		   	Score10Line = {
		   		name = "10 member raids",				
		   		type="toggle",
				desc = "Display score only for 10 person raids",
				get = function() return RaidMarshal.db.profile.raidsToScore == "10" end,
				set = function(x) 
					RaidMarshal.db.profile.raidsToScore = "10"
					RMRaid:BuildMaps()
					RMBrowser.UpdateCharacterTable()					
				end,
				order = 1,
		   	},
			Score25Line = {
				name = "25 member raids",				
				type="toggle",
				desc = "Display score only for 25 person raids",
				get = function() return RaidMarshal.db.profile.raidsToScore == "25" end,
				set = function(x) 
					RaidMarshal.db.profile.raidsToScore = "25"
					RMRaid:BuildMaps()
					RMBrowser.UpdateCharacterTable()					 
				end,
				order = 2,				
			},
			ScoreBothLine = {
				name = "Both",
				type="toggle",
				desc = "Display score for both 10 person and 25 person raids",
				get = function() return RaidMarshal.db.profile.raidsToScore == "both" end,
				set = function(x) 
					RaidMarshal.db.profile.raidsToScore = "both"
					RMRaid:BuildMaps()
					RMBrowser.UpdateCharacterTable()					 
				end,
				order = 3,
			}						
		   }, 
		   order = 20
		},         		               
        autoTrackRaids = {
           type = "toggle",
           name = "Auto Track Raids",
           desc = "Whether to automatically track raid groups",
           get = function() return RaidMarshal.db.profile.autoRaidTracking end,
           set = function(flag) RaidMarshal.db.profile.autoRaidTracking = flag end,
           order = 40 
        },                   
		debug = {
		   type = "toggle",
		   name = "Debug",
		   desc = "Outputs debug statements to chat window",
		   get = function() return RaidMarshal.db.profile.debug end,
		   set = function(flag) RaidMarshal.db.profile.debug = flag end,
		   order = 50 
		},		
    }
}

RaidMarshal:RegisterChatCommand({"/RaidMarshal"}, RaidMarshal.options)
RaidMarshal.OnMenuRequest = RaidMarshal.options