-- Initialize our AceAddOn class with the desired mixins
RaidMarshal = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0","AceEvent-2.0","AceDB-2.0","FuBarPlugin-2.0","AceComm-2.0")
--RaidMarshal = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0","AceEvent-2.0","AceDB-2.0","FuBarPlugin-2.0")
-- Create a library object reference for Tablet and BabbleClass
local Tablet = AceLibrary("Tablet-2.0")
local L = AceLibrary("AceLocale-2.2"):new("RaidMarshal")
local BabbleClass = AceLibrary("Babble-Class-2.2")
local Dewdrop = AceLibrary("Dewdrop-2.0")

-- Declare static variable for the current actively tracked group or raid
RaidMarshal.currentRaid = nil
RaidMarshal.hasSynced = false
RaidMarshal.syncLeader = nil
-- declare comms table
RaidMarshal.OnCommReceive = {}
-- static table variable for our convenience alt map (reassembled when we rebuild the player list) (key alt, value main)
RaidMarshal.activeGroups = {}
RaidMarshal.hasIcon = "Interface\\Icons\\INV_BannerPVP_02"
RaidMarshal.lootTarget = nil
RaidMarshal.lootSlotMap  = {}
RaidMarshal.retryAttempts = 0
-- Initialize this add on, called on load. Builds the Ace options map but does not register event handlers
function RaidMarshal:OnInitialize()
	-- self:Print("RaidMarshal Initialized!")
    -- MOVED OPTION TABLE SETUP TO RaidMarshalOptions.lua
    -- initialize our Ace options map for console control
    --self:RegisterChatCommand("/RaidMarshal", self.options)
    -- mount our options map to the fubar menu 
    --self.OnMenuRequest = self.options
	self:RegisterDB("RaidMarshalDB", "RaidMarshalDBPC")
	self:RegisterDefaults(
		"profile",  {               
			autoRaidTracking = false,    
			autoStartConfirming = false,
			showAlts = false,
			show10 = true,
			show25 = true,
			showDeleted = false,
			showOffline = false,
			showNonRaiders = true,
			debug = false,
			characterComparator = "NAME",
			raidComparator = "DATE_REVERSE",
			raidsToScore = "25",			       
			durationInterval = 5,			
			raids = {},
			characters = {}
		} 
	)	
	
	-- loop to clean character db
	for name, char in pairs(self.db.profile.characters) do
		if not char.lastUpdated then 
			char.lastUpdated = 0
			if self.db.profile.debug then self:Print("Added timestamp to "..name) end 
		end
	end
	
	-- loop to scrub raid db
	for key, raid in pairs(self.db.profile.raids) do
		-- if a raid has no duration then its corrupt record (from old bug) delete it		
		if not raid.duration then
			if self.db.profile.debug then self:Print("found bad key="..key) end			
			self.db.profile.raids[key] = nil
		end
		
		--[[clean loot table if loot table is array for old versions
		if #raid.lootTable > 0 then			
			local newLootTable = {}
			for i, loot in ipairs(raid.lootTable) do
			  newLootTable[loot.atTime] = loot 
			end
			if self.db.profile.debug then self:Print("cleaned old loot table for raid key="..key) end
			raid.lootTable = newLootTable
		end
		]]			
	end	
		
end

-- enable addon, this registers event handlers, saved variables (db), and other services
function RaidMarshal:OnEnable()		
	if self.db.profile.debug then self:Print("RaidMarshal enabled but waiting for synchronization") end            				    
    -- register comm events
	self:SetCommPrefix(self.name .. "-" .. self.version)
    self:RegisterComm(self.commPrefix, "GUILD")                    			    		
	self:RegisterComm(self.commPrefix, "WHISPER")			
	self:RegisterEvent("RaidMarshal_CheckSyncTimeout", "CheckSyncTimeout")	
	self:BroadcastSyncLeaderRequest()	
end

function RaidMarshal:SynchronizationComplete()		
	self:RegisterEvent("LOOT_OPENED","OnLootOpened")
	self:RegisterEvent("LOOT_CLOSED","OnLootClosed")
	--self:RegisterEvent("RAID_ROSTER_UPDATE", "OnRaidRosterUpdate")                   
	self:RegisterEvent("RAID_MARSHAL_DURATION_INTERVAL", "OnDurationInterval")
	
	self.hasSynced = true
	if self.db.profile.debug then self:Print("Synchronization complete!") end
	
	-- initialize the character cache maps
	RMCharacter:Init()	
	-- initialize the raid cache maps
	RMRaid:Init()	
	
	if self.db.profile.currentRaid then
		local raid = RMRaid:Load(self.db.profile.currentRaid)
		if raid and raid.syncLeader == UnitName("player") then 
			if UnitInRaid("player") and (time() - raid.lastDuration) < 600 then			
				self:StartTracking()				
			else
				raid.endTime = raid.lastDuration
				RMRaid:Save(raid)
				self.db.profile.currentRaid = nil
			end				 								
		else
			self.db.profile.currentRaid = nil
		end				
	end					
	self:UpdateText()	
end		

function RaidMarshal:BroadcastSyncLeaderRequest()	 	 
	self:SendCommMessage("GUILD", "SyncLeaderRequest")
	if self.db.profile.debug then self:Print("Broadcasting sync leader request") end	
	self:ScheduleEvent("RaidMarshal_TimeoutEvent","RaidMarshal_CheckSyncTimeout",5)	
end

function RaidMarshal:CheckSyncTimeout()			
	if not self.syncLeader then
		-- request sync has timed out, there is no one else online to sync with
		if self.db.profile.debug then self:Print("Sync leader request timed out, there is no one online to sync with") end
		self:SynchronizationComplete()
	else
		 
		-- else we have failed somewhere along the line to receive a synchronization reply
		-- so clear the sync leader field and start over again
		if self.db.profile.debug then self:Print("Synchronization with "..self.syncLeader.." has timed out, requesting new sync leader") end
		self.syncLeader = nil
		if self.retryAttempts < 2 then 
			self.retryAttempts = self.retryAttempts + 1
			self:BroadcastSyncLeaderRequest()
		else
			if self.db.profile.debug then self:Print("Sync communication timed out, aborting sync") end
			self:SynchronizationComplete()
		end
	end
end

function RaidMarshal.OnCommReceive:SyncLeaderRequest(prefix, sender, distribution)
	-- do NOT reply if we haven't finished syncing ourselves
	if not self.hasSynced then return end		
	if self.db.profile.debug then self:Print("Received sync leader request from "..sender) end
	-- ping back to new player, but ONLY if we are a guild officer (only guild officers can synchronize)
	if CanEditOfficerNote then	
		if self.db.profile.debug then self:Print("Synchronization authorized, beginning sync with "..sender) end
		self:SendCommMessage("WHISPER", sender, "SyncLeaderReply")
	else
		if self.db.profile.debug then self:Print("Synchronization forbidden, ignoring sync request from "..sender) end
	end	
end

function RaidMarshal.OnCommReceive:SyncLeaderReply(prefix, sender, distribution)
	self:CancelScheduledEvent("RaidMarshal_TimeoutEvent")
	if self.db.profile.debug then self:Print("Received sync leader reply from "..sender) end	
	-- do nothing if we've already started to sync with someone
	if self.syncLeader then 
		return 
	else -- otherwise story sender as sync leader so we can begin syncing
		-- stop timeout			
		self.syncLeader = sender
	end			
	self:SendCommMessage("WHISPER", sender, "SyncKeysRequest")
	-- restart timeout	
	self:ScheduleEvent("RaidMarshal_TimeoutEvent","RaidMarshal_CheckSyncTimeout",60)
end

function RaidMarshal.OnCommReceive:SyncKeysRequest(prefix, sender, distribution)
	if self.db.profile.debug then self:Print("Received sync keys request from "..sender) end
	self:SendCommMessage("WHISPER", sender, "SyncKeysReply", RMCharacter:GetSyncKeys(), RMRaid:GetSyncKeys())			
end
	
function RaidMarshal.OnCommReceive:SyncKeysReply(prefix, sender, distribution, charSyncKeys, raidSyncKeys)
	-- stop timeout
	self:CancelScheduledEvent("RaidMarshal_TimeoutEvent")	
			
	local charTable = self.db.profile.characters	
	local charsToSync = {}
	local charsToBroadcast = {}	
	-- loop through character sync keys received to see if they have anything we don't or haven't anything thats newer 		
	for name, lastUpdated in pairs(charSyncKeys) do		
		local localChar = RMCharacter:Load(name)			
		if localChar and localChar.lastUpdated > lastUpdated and RMCharacter:CanEdit(localChar) then
			tinsert(charsToBroadcast, localChar)
		-- extra logic because of bogus records flying around on syncs :(
		elseif not localChar or localChar.lastUpdated < lastUpdated then		
			tinsert(charsToSync, name)
		end
	end
	-- loop through our characters to see if we have anything cluster did not have	
	for name, character in pairs(charTable) do			
		if not charSyncKeys[name] and RMCharacter:CanEdit(character) then
			tinsert(charsToBroadcast, character)
		end
	end
	
	-- loop through raid sync keys received to see if they have anything we don't or haven't anything thats newer
	local raidsToSync = {}
	local raidsToBroadcast = {}
	local raidTable = self.db.profile.raids	
	for raidKey, lastUpdated in pairs(raidSyncKeys) do
		local localRaid = RMRaid:Load(raidKey)
		if localRaid and localRaid.lastUpdated > lastUpdated and RMRaid:CanEdit(localRaid) then
			tinsert(raidsToBroadcast, localRaid)
		elseif not localRaid or localRaid.lastUpdated < lastUpdated then
			tinsert(raidsToSync, raidKey)
		end
	end
	-- loop through our raids to see if we have anything cluster did not have
	for key, raid in pairs(raidTable) do
		if not raidSyncKeys[key] and RMRaid:CanEdit(raid) then
			tinsert(raidsToBroadcast, raid)
		end
	end		
	
	-- then send key request
	if #charsToSync > 0 or #raidsToSync > 0 then
		self:SendCommMessage("WHISPER", sender, "SyncRequest", charsToSync, raidsToSync)
		self:ScheduleEvent("RaidMarshal_TimeoutEvent","RaidMarshal_CheckSyncTimeout",180)
	else
		self:SynchronizationComplete()
	end
	
	-- now broadcast my changes, if any
	if #charsToBroadcast > 0 or #raidsToBroadcast > 0 then
		self:BroadcastCharsAndRaids(charsToBroadcast, raidsToBroadcast)
	end
						
end

function RaidMarshal.OnCommReceive:SyncRequest(prefix, sender, distribution, charSyncKeys, raidSyncKeys)	
	if self.db.profile.debug then self:Print("Received sync request of "..#charSyncKeys.." character(s) and "..#raidSyncKeys.." raid(s)") end
	-- load requested characters
	local chars = {}
	for i, name in ipairs(charSyncKeys) do
		tinsert(chars, RMCharacter:Load(name))
	end
	-- load requested raids
	local raids = {}
	for i, key in ipairs(raidSyncKeys) do
		tinsert(raids, RMRaid:Load(key))
	end	
	self:SendCommMessage("WHISPER", sender, "SyncReply", chars, raids)
end 

function RaidMarshal.OnCommReceive:SyncReply(prefix, sender, distribution, chars, raids)
	-- stop timeout
	self:CancelScheduledEvent("RaidMarshal_TimeoutEvent")	
	if self.db.profile.debug then self:Print("Received sync reply of "..#chars.." character(s) and "..#raids.." raid(s)") end
	-- save requested characters	
	RMCharacter:SaveAll(chars)
	-- save requested raids		
	RMRaid:SaveAll(raids)	
	self:SynchronizationComplete()
end 

function RaidMarshal:BroadcastCharsAndRaids(charsToBroadcast, raidsToBroadcast) 
	if self.db.profile.debug then self:Print("Broadcasting "..#charsToBroadcast.." character(s) and "..#raidsToBroadcast.." raid(s)") end
	self:SendCommMessage("GUILD", "CharsAndRaids", charsToBroadcast, raidsToBroadcast)	
end

function RaidMarshal.OnCommReceive:CharsAndRaids(prefix, sender, distribution, chars, raids)
	if self.db.profile.debug then self:Print("Broadcast received of "..#chars.." character(s) and "..#raids.." raid(s) from "..sender) end	
	RMCharacter:SaveAll(chars)
	if #chars > 0 then
		RMBrowser.UpdateCharacterTable()
	end	
	local charsToSync = {}
	local raidsToSync = {}
	local raidsUpdated = false
	
	for key, raid in pairs(raids) do
		local tables = {raid.participantDurationTable, raid.benchDurationTable}
		local missingChar = false
		for i, table in ipairs(tables) do			
			for key, value in pairs(table) do
				if not RMCharacter:Load(key) then
					missingChar = true
					tinsert(charsToSync, key);
				end
			end
		end
		if missingChar then
			tinsert(raidsToSync, raid)
		else
			RMRaid:Save(raid, true)
			raidsUpdated = true
		end
	end		
	
	if #charsToSync > 0 or #raidsToSync > 0 then
		self:SendCommMessage("WHISPER", sender, "SyncRequest", charsToSync, raidsToSync)		
	end
	if raidsUpdated then
		RMRaid:BuildMaps()
		RMBrowser.UpdateRaidTable()
	end		   
end	

function RaidMarshal:BroadcastCharacterUpdated(character)
	if self.db.profile.debug then self:Print("Broadcasting character upate") end
	self:BroadcastCharsAndRaids({character}, {})
end

function RaidMarshal:BroadcastRaidUpdated(raid)
	if self.db.profile.debug then self:Print("Broadcasting raid upate") end	
    self:BroadcastCharsAndRaids({}, {raid})
end

-- disabled addon, this should UNregister event handlers, or anything that could consume CPU resources
function RaidMarshal:OnDisable()
	if self.db.profile.debug then self:Print("RaidMarshal Disabled!") end
    -- unregisters all events, to be tidy
    self:UnregisterAllEvents()
    -- Called when the addon is disabled
end

function RaidMarshal:Synchronize()
    -- maybe add a sync on request command
end

function RaidMarshal:OnLootOpened()	
	self.lootSlotMap = {}
	local lootMethod, masterLooterPartyId, masterLooterRaidId = GetLootMethod()
	if lootMethod=="master" then		
		if masterLooterPartyId == 0 then			
			self:AddLootMenu()			
		end
	end
end

function RaidMarshal:BuildMasterLootCandidateTable(itemSlot, itemString)
	local candidateTable = {}
	local notEmpty = false
	for i=1,40 do 
		local candidateName = GetMasterLootCandidate(i)
		if candidateName then
			notEmpty = true
			--self:Print("Adding candidateName "..candidateName) 				
			local char = RMCharacter:Load(candidateName)		
			local role
			if char and char.roleName then
				role = char.roleName
			else
				role = "Non Raider"
			end
			--self:Print("building cadidate role "..role)
			if not candidateTable[role] then
				candidateTable[role] = {
					name = RMBrowser.GetRoleWithColor(role),
					type = "group",
					desc = "All Master Loot Candidates of role: "..role,
					args = {}				
				}
			end		
			local orderScore = RMRaid:GetNeedScore(char)
			if orderScore < 1 then 
				orderScore = 1
			end				
			tinsert(candidateTable[role].args, {						
				name = RMRaid:GetNeedScore(char).."/"..RMRaid:GetGreedScore(char).." "..RMBrowser.GetNameWithColor(char),
				type = "group",
				desc = "Distribute "..itemString.." to "..candidateName,
				order = orderScore, 
				args = {
					NeedLine = {
						name = "|cFF"..RMBrowser.GetClassHexColor("Druid").."Need|r",				
						type = "execute",
						desc = "Distribute "..itemString.." to "..candidateName.." as NEED",
						order = 1,
						func = function()
							-- distribute the loot
							GiveMasterLoot(itemSlot, i)
							Dewdrop:Close()																	
							SendChatMessage("Needing "..itemString.." to "..candidateName, "RAID_WARNING")
							
							local itemName, itemId, enchantId, jewelId1, jewelId2, jewelId3, jewelId4, suffixId, uniqueId = strsplit(":", itemString)																					
							RMRaid:AddLoot(self.currentRaid, candidateName, self.lootTarget, itemName, true, itemId)
							self.lootSlotMap["Slot"..itemSlot] = true
							-- rebuild loot table
							self:AddLootMenu()							
						end 			
					},
					GreedLine = {
						name = "|cFF"..RMBrowser.GetClassHexColor("Rogue").."Greed|r",				
						type = "execute",
						order = 2,
						desc = "Distribute "..itemString.." to "..candidateName.." as GREED",
						func = function()
							-- distribute the loot
							GiveMasterLoot(itemSlot, i)
							Dewdrop:Close()											
							-- SendChatMessage raid warning announcing distribution											
							SendChatMessage("Greeding "..itemString.." to "..candidateName, "RAID_WARNING")
							local itemName, itemId, enchantId, jewelId1, jewelId2, jewelId3, jewelId4, suffixId, uniqueId = strsplit(":", itemString)				
							RMRaid:AddLoot(self.currentRaid, candidateName, self.lootTarget, itemName, false, itemId)
							self.lootSlotMap["Slot"..itemSlot] = true
							-- rebuild loot table
							self:AddLootMenu()
						end 			
					},
				}				
			})		
		end
	end		
	if notEmpty then	
		return candidateTable
	else
		return nil;
	end
end

function RaidMarshal:AddLootMenu()
	-- recalculate scores to ensure correctness
	RMRaid:BuildMaps()
	self.lootTarget = UnitName("target")
	local lootThreshold = GetLootThreshold()
	local lootTable =  {		
		type="group",
		name="Distribute Loot",
		desc="Distribute Master Loot items from current open corpse",		
		order = 15,
		args = {}					
	}
	local lootCount = GetNumLootItems()
	local notEmpty = false;	
	if lootCount > 0 then
		for i=1,lootCount do
			local lootIcon, lootName, lootQuantity, rarity = GetLootSlotInfo(i);
			-- if item exceed threshold and this item hasn't been distributed yet, then build its table
			if rarity >= lootThreshold and not self.lootSlotMap["Slot"..i] then
				--self:Print("Adding item for slot "..i)
				local itemString = GetLootSlotLink(i)
				local itemTable = {
					name = itemString,
					order = i,
					icon = lootIcon,
					type = "group",										
					desc = "Distribute "..lootName,
					args = {},							
				}
				local candidateTable = self:BuildMasterLootCandidateTable(i, itemString, lootTable.args, #lootTable.args - 1)				
				if candidateTable then
					itemTable.args = candidateTable
					tinsert(lootTable.args, itemTable)
					notEmpty = true
				end								
			end			
		end
		
	end		
	
	if notEmpty then 
		self.options.args.LootLine = lootTable
	else 
		--self:Print("Loot table is empty")
	end
end

function RaidMarshal:RemoveLootMenu()	
	self.options.args.LootLine = nil
	self.lootTarget = nil
end

function RaidMarshal:OnLootClosed()	
	self:RemoveLootMenu()	
end

--[[ event handler called when joining a raid, and everytime the raid roster changes
function RaidMarshal:OnRaidRosterUpdate() 
	if self.currentRaid and self.currentRaid.syncLeader == UnitName("player") then
		RMRaid:UpdateDurations(self.currentRaid)    
    end
end
]]

function RaidMarshal:OnDurationInterval()					
    if self.currentRaid and self.currentRaid.syncLeader == UnitName("player") then
    	RMRaid:UpdateDurations(self.currentRaid)
    end		
end

function RaidMarshal:UpdateText()
	if not self.hasSynced then
		self:SetText(self.name..":Synchronizing")
		return
	end
	local tankCount = 0
	local dpsCount = 0
	local healerCount = 0	
	if RMCharacter.roleOnlineMap[RMCharacter.ROLE_TANK] then
		tankCount = #RMCharacter.roleOnlineMap[RMCharacter.ROLE_TANK]
	end
	if RMCharacter.roleOnlineMap[RMCharacter.ROLE_DPS] then
		dpsCount = #RMCharacter.roleOnlineMap[RMCharacter.ROLE_DPS]
	end
	if RMCharacter.roleOnlineMap[RMCharacter.ROLE_HEALER] then
		healerCount = #RMCharacter.roleOnlineMap[RMCharacter.ROLE_HEALER]
	end				
	local status = ""
    if (self.db.profile.currentRaid) then
        status = ":Tracking"
    end
	status = status .. " (|cFF"..RMBrowser.GetRoleHexColor(RMCharacter.ROLE_TANK)..tankCount.."|r+|cFF"..RMBrowser.GetRoleHexColor(RMCharacter.ROLE_HEALER)..healerCount.."|r+|cFF"..RMBrowser.GetRoleHexColor(RMCharacter.ROLE_DPS)..dpsCount.."|r="..(tankCount+healerCount+dpsCount)..")"        
    self:SetText(self.name .. status)
end

function RaidMarshal:Continue(raid)
	if RaidMarshal:IsTracking() then
		self:StopTracking()
	end
	self.db.profile.currentRaid = raid.key
	
	-- reset last duration so if we picked this raid up a day later it doesnt add 24 hrs to duration
	raid.lastDuration = time()
	-- clear end time since we restarted it
	raid.endTime = nil
	RMRaid:Save(raid)
	self:StartTracking()
end

function RaidMarshal:StartTracking() 		    		
	-- reload the current raid if one was stored but not initiliazed	
	if self.db.profile.currentRaid then		
		self.currentRaid = RMRaid:Load(self.db.profile.currentRaid)
		self:Print("Restoring existing raid")		
	else
		if not UnitInRaid("player") then    	    		 								    	      
			self:Print("You must be in a raid group to track!")
			return		
		end				
    	self.currentRaid = RMRaid:New(UnitName("player"))		
		self.db.profile.currentRaid = self.currentRaid.key
	end			
    self:ScheduleRepeatingEvent("RaidMarshal_DurationEvent","RAID_MARSHAL_DURATION_INTERVAL", self.db.profile.durationInterval*60) -- event every 60 secs    
    self:Print("Tracking started")
	RMRaid:UpdateDurations(self.currentRaid)    
    self:UpdateText()	
    self.options.args.durationInterval.disabled = true
end

function RaidMarshal:StopTracking()    
	if not self:IsTracking() then return end
    local raid = self.currentRaid
	
	self:CancelScheduledEvent("RaidMarshal_DurationEvent")        
	RMRaid:Finish(raid)
	self.currentRaid = nil    
    self.db.profile.currentRaid = nil	
        
    self:Print("Tracking stopped")
    self:UpdateText()
    self.options.args.durationInterval.disabled = false
end

-- fubar method 
function RaidMarshal:OnDataUpdate()
--~    self.num = self.num + 1
end

function RaidMarshal:IsTracking() 
    return self.db.profile.currentRaid ~= nil
end

function RaidMarshal:OnClick()
	if not self.hasSynced then 
		self:Print("Please wait for synchronization")
		return
	end		
	if RMBrowserFrame:IsShown() then		
		RMBrowserFrame:Hide()
	else		
		RMBrowserFrame:Show()
	end
end