--RMRaid = AceLibrary("AceOO-2.0").Class() -- declare new class with mixin event
RMRaid = {}
RMRaid.RMLoot = {}
local Tourist = AceLibrary("Tourist-2.0")
-- declare constants
RMRaid.RANK_LEADER = 2
RMRaid.RANK_ASSISTANT = 1

RMRaid.durationMap = {}
RMRaid.needLootMap = {}
RMRaid.greedLootMap = {}
RMRaid.totalDuration = 0

-- Inner Class Loot declaration
function RMRaid.RMLoot:New(recipient, lootedFrom, itemString, isNeed, atTime, itemId)
	local newLoot = {}
	newLoot.recipient = recipient
	newLoot.lootedFrom = lootedFrom
	newLoot.itemString = itemString
	newLoot.isNeed = isNeed
	newLoot.atTime = atTime
	newLoot.itemId = itemId
	return newLoot
end 

-- RMRaid object constructor
function RMRaid:New(owner)
    -- execute the super class constructor to inherit Ace2 Object behavior    
    local newRaid = {}
	local createTime = time()            
    newRaid.owner = owner
	newRaid.syncLeader = owner	
	newRaid.key = newRaid.owner .. "||" .. createTime	
	newRaid.lastUpdated = createTime	
	newRaid.lastDuration = createTime
	newRaid.currentLeader = nil
    newRaid.startTime = createTime
	newRaid.endTime = nil
	newRaid.leaders = {}
	newRaid.officers = {}
	newRaid.raidZoneEntered = false        
    newRaid.participantDurationTable = {}
    newRaid.benchDurationTable = {}
    newRaid.zoneName = "Unknown"
    newRaid.duration = 0
	newRaid.bossKills = {}    
	newRaid.lootTable = {}
	newRaid.isDeleted = false
	if RaidMarshal.db.profile.debug then RaidMarshal:Print("New Group Created") end
	return newRaid
end

-- loop through the list of raid participants, and make sure anyone present is stored
-- in the participants table
function RMRaid:UpdateParticipants(raid, durationIncrement)		    
    -- loop through all members of the raid
	local name, rank, subgroup, level, class, fileName, zone, online, isDead, role, isML
    for i= 1,40 do
        name, rank, subgroup, level, class, fileName, zone, online, isDead, role, isML = GetRaidRosterInfo(i)				
		-- save them to character db if not present
		if name and not RMCharacter:Load(name) then
			RMCharacter:Save(RMCharacter:New(name, class))            
		end
		
		-- update leader and officer tables
        if rank == RMRaid.RANK_LEADER then
        	raid.currentLeader = name
            raid.leaders[name] = name                        
        elseif rank == RMRaid.RANK_ASSISTANT then
            raid.officers[name] = name        
        end
        
        -- if there is an online player in a raid slot
        if online then			
            -- if the player is not yet in the duration table, add them with zero duration
            if not raid.participantDurationTable[name] then            
            	raid.participantDurationTable[name] = durationIncrement
            end
            -- increment duration for the player unless our increment is zero or nil
            if durationIncrement and durationIncrement > 0 then
                raid.participantDurationTable[name] = raid.participantDurationTable[name]+durationIncrement
            end
        end
    end            
end

function RMRaid:GetCurrentRaid()
	return RaidMarshal.db.profile.currentRaid
end 

-- loop through the guild list, and increment their bench duration if they are online but not in raid
function RMRaid:UpdateBench(raid, durationIncrement)
    -- loop through all guild members	   
	GuildRoster()
    local numGuildMembers = GetNumGuildMembers(true)
    local name, rank, rankIndex, level, class, zone, note, officernote, online, status
    for i = 1, numGuildMembers, 1 do
        name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(i)		
        -- if the guild member is online and not in the raid
        if online and not UnitInRaid(name) then
        	-- save them to character db if not present
			if not RMCharacter:Load(name) then
				RMCharacter:Save(RMCharacter:New(name, class))            
			end			
        	
            -- if they are not yet in the bench table, add them with zero duration            
            if not raid.benchDurationTable[name] then
            	raid.benchDurationTable[name] = durationIncrement
            end
            -- increment duration for the player unless our increment is zero or nil
            if durationIncrement and durationIncrement > 0 then
                raid.benchDurationTable[name] = raid.benchDurationTable[name]+durationIncrement
            end
        --[[ EDITED: DO NOT REMOVE FROM BENCH: remove any player in the raid from the bench duration table
        elseif UnitInRaid(name) and self.benchDurationTable[name] then            
            self.benchDurationTable[name] = nil ]]
    	end        
    end
end

function RMRaid:SaveAll(raids)
	for i, raid in ipairs(raids) do		
		RaidMarshal.db.profile.raids[raid.key] = raid		
	end
end

function RMRaid:Save(raid, fromSyncEvent)
	if not fromSyncEvent then	
		raid.lastUpdated = time()
	end
	RaidMarshal.db.profile.raids[raid.key] = raid
	self:BuildMaps()
	RMBrowser.UpdateRaidTable()
	--RaidMarshal:Print("Saving raid key: "..raid.key)
	-- do not broadcast from sync or when in combat
	if not fromSyncEvent and UnitAffectingCombat("player")~=1 then
		-- reload the raid and broadcast, ensuring that the object can be serialized
		RaidMarshal:BroadcastRaidUpdated(self:Load(raid.key))
	end
end

function RMRaid:Load(raidKey) 
	return RaidMarshal.db.profile.raids[raidKey]
end

function RMRaid:GetSize(raid)
	local zoneSize = Tourist:GetInstanceGroupSize(raid.zoneName)
	-- hack for tempest keep since tourist lib seems to know it only as "The Eye"	
	if raid.zoneName == "Tempest Keep" or zoneSize == 25 then
		return "25"
	else
		return "10"
	end
end

function RMRaid:UpdateZone(raid, zoneName)
	local zoneSize = Tourist:GetInstanceGroupSize(zoneName)
	-- hack for tempest keep since tourist lib seems to know it only as "The Eye"	
	if not raid.raidZoneEntered and (zoneName == "Tempest Keep" or zoneSize > 5) then		
		raid.raidZoneEntered = true
		raid.zoneName = zoneName
		--RaidMarshal:Print("Raid zone detected: "..zoneName)		
	elseif not raid.raidZoneEntered then
		--RaidMarshal:Print("Did NOT detect raid zone, name="..zoneName.."; size="..zoneSize)
	end
end

function RMRaid:UpdateDurations(raid)
    -- update participants
	local newTime = time()
	local durationIncrement = newTime - raid.lastDuration
	raid.lastDuration = newTime 
	raid.duration = raid.duration + durationIncrement
	self:UpdateZone(raid, GetRealZoneText())        
    self:UpdateParticipants(raid, durationIncrement)
    self:UpdateBench(raid, durationIncrement)
    self:Save(raid)
	--RaidMarshal:Print("Bench and Participant Durations Updated!")
end

-- marks the raid as completed, logs end time, and cleans up raid object
function RMRaid:Finish(raid)
    -- marks end time
	raid.endTime = time()
	self:UpdateDurations(raid)	    	
	--RaidMarshal:Print("Finishing raid, endTime = "..raid.endTime)		
end

function RMRaid:IsComplete(raid)	
	if raid.endTime then 
        return true
    else
        return false
    end
end

function RMRaid:BuildMaps()
	-- reset all maps and total duration  
	self.totalDuration = 0
	self.needLootMap = {}
	self.greedLootMap = {}
	self.durationMap = {}
	
	-- build maps by looping through all raid records
	for key, raid in pairs(RaidMarshal.db.profile.raids) do
		local raidSize = self:GetSize(raid)
		--RaidMarshal:Print("raid.zone="..raid.zoneName.."; size="..raidSize.."; raidsToScore="..RaidMarshal.db.profile.raidsToScore)				
		if not raid.isDeleted and 
			(RaidMarshal.db.profile.raidsToScore == "both" or RaidMarshal.db.profile.raidsToScore == raidSize) then 
			self.totalDuration = self.totalDuration + raid.duration
			-- make sure alts classified correctly
			for name, duration in pairs(raid.participantDurationTable) do
				local main = RMCharacter:GetMainName(name)
				if not self.durationMap[main] then 
					self.durationMap[main] = duration
				else
					self.durationMap[main] = self.durationMap[main] + duration
				end
			end
			-- make sure alts classified correctly
			for name, duration in pairs(raid.benchDurationTable) do
				local main = RMCharacter:GetMainName(name)
				if not self.durationMap[main] then 
					self.durationMap[main] = duration
				else
					self.durationMap[main] = self.durationMap[main] + duration
				end
			end
			-- make sure alts classified correctly
			if raid.lootTable then
				for i, loot in ipairs(raid.lootTable) do
					local lootMap
					local main = RMCharacter:GetMainName(loot.recipient)
					if loot.isNeed then
						lootMap = self.needLootMap
					else
						lootMap = self.greedLootMap
					end																																		
					if not lootMap[main] then
						lootMap[main] = {loot}									
					else
						tinsert(lootMap[main], loot)					
					end
				end	
			end
		end 					
	end
end

function RMRaid:GetGreedCount(character)	
	if not self.greedLootMap[character.name] then
		return 0
	else
		return #self.greedLootMap[character.name]
	end	
end


function RMRaid:GetNeedCount(character)	
	if not self.needLootMap[character.name] then
		return 0
	else
		return #self.needLootMap[character.name]
	end	
end

function RMRaid:GetNeedScore(character)
	local attendance = RMRaid:GetAttendance(character)
	if attendance==0 then
		return 0
	else
		return math.ceil(attendance / (RMRaid:GetNeedCount(character) + 1))
	end
end	

function RMRaid:GetGreedScore(character)
	local attendance = RMRaid:GetAttendance(character)
	if attendance==0 then
		return 0
	else
		return math.ceil(attendance / (RMRaid:GetGreedCount(character) + 1))
	end
end

function RMRaid:GetAttendance(character)	
	if not self.durationMap[character.name] then 
		return 0
	else
		return math.ceil((self.durationMap[character.name] / self.totalDuration) * 100)
	end
end				

function RMRaid:Init()
	self:BuildMaps()
	-- load db maps for attendance, scoring, etc
	-- init UI
end

function RMRaid:CanEdit(raid)		
	return UnitName("player")==raid.owner or UnitName("player")==raid.currentLeader or CanEditOfficerNote()		
end

function RMRaid:LoadAll()	
	local raidTable = {}	
	for key, raid in pairs(RaidMarshal.db.profile.raids) do		
		table.insert(raidTable, raid)		
	end		
	return raidTable
end

function RMRaid:AddLoot(raid, recipient, lootedFrom, itemString, isNeed, itemId)
	local newLoot = RMRaid.RMLoot:New(recipient, lootedFrom, itemString, isNeed, time(), itemId)
	--RaidMarshal:Print("Added new loot "..newLoot.itemString.." to "..newLoot.recipient .. " from " .. newLoot.lootedFrom.." at "..newLoot.atTime)
	tinsert(raid.lootTable, newLoot)
	-- rebuild maps
	self:Save(raid)	
end

function RMRaid:GetSyncKeys()
	local raidTable = RaidMarshal.db.profile.raids
	local syncKeyTable = {}
	for key, raid in pairs(raidTable) do
		syncKeyTable[key]=raid.lastUpdated
	end
	return syncKeyTable
end