RMCharacter = {}

-- constants
RMCharacter.ROLE_DPS = "DPS"
RMCharacter.ROLE_TANK = "Tank"
RMCharacter.ROLE_HEALER = "Healer"

RMCharacter.rolePlural = {
	["Tank"] = "Tanks",
	["Healer"] = "Healers",
	["DPS"] = "DPS",
	["Non Raiders"]="Non Raiders"		
}


-- this db static var is initialized by RaidMarshal on enable with raid marshalls player db
RMCharacter.charDB = nil
RMCharacter.altMap = {}
RMCharacter.onlineMap = {}
RMCharacter.roleOnlineMap = {}
RMCharacter.classOnlineMap = {}
-- an array of times, should be alternating start and stop times
--RCParticpant.prototype.startStopLog = nil
RMCharacter.charactersOnlineCache = {}
RMCharacter.altToMainMap = {}
RMCharacter.mainToAltMap = {}

-- RMCharacter object constructor
function RMCharacter:New(name, className, mainName, role, nick)    
	local newChar = {}       
    newChar.name = name
    newChar.mainName = mainName
    newChar.className = className
	newChar.role = role
	newChar.nick = nick
	newChar.lastUpdated = 0
	return newChar
end

function RMCharacter:Load(name)
	return RaidMarshal.db.profile.characters[name]
end

function RMCharacter:SaveAll(chars)
	for i, char in ipairs(chars) do
		RaidMarshal.db.profile.characters[char.name] = char
	end
end

function RMCharacter:Save(char, fromSyncEvent)
	if not fromSyncEvent then		
		char.lastUpdated = time()
	end		
	RaidMarshal.db.profile.characters[char.name] = char	
	if RaidMarshal.db.profile.debug then RaidMarshal:Print("Saved " .. char.name .. " to player database") end
	if not fromSyncEvent then		
		RaidMarshal:BroadcastCharacterUpdated(char)
	end
	RMBrowser.UpdateCharacterTable()	
end

function RMCharacter:BuildAltMap()	
	local dbSize = 0
	self.mainToAltMap = {}
	self.altToMainMap = {}
	for playerName, player in pairs(RaidMarshal.db.profile.characters) do
		dbSize = dbSize + 1		
    	if player.mainName then
    		self.altToMainMap[player.name] = player.mainName
			if not self.mainToAltMap[player.mainName] then
				self.mainToAltMap[player.mainName] = {}
			end	
			self.mainToAltMap[player.mainName][player.name] = player.name                           						
        end        
    end	
	if RaidMarshal.db.profile.debug then RaidMarshal:Print("Loaded "..dbSize.." players from database") end
end

function RMCharacter:IsMain(playerName) 
    return not self.altMap[playerName]
end

function RMCharacter:GetMainName(characterName)
	local char = self:Load(characterName)
	if not char or not char.mainName then
		return characterName
	else
		return char.mainName
	end
end

function RMCharacter:GetMain(characterName)    
    local mainName = self.altMap[characterName]
    if not mainName then mainName = characterName end
    return self:Load(mainName)
end

function RMCharacter:MapAlt(altCharacter, mainCharacter)
	if not mainCharacter then
		altCharacter.mainName = nil
		if RaidMarshal.db.profile.debug then RaidMarshal:Print("Mapping "..altCharacter.name.." as main") end
	else 	
		if RaidMarshal.db.profile.debug then RaidMarshal:Print("Mapping "..altCharacter.name.." as alt of "..mainCharacter.name) end
		altCharacter.mainName = mainCharacter.name			
		mainCharacter.mainName = nil
		self:Save(mainCharacter)
	end
	self:Save(altCharacter)	
    self:BuildAltMap()        
end

function RMCharacter:GetAltNames(mainName)
	return self.mainToAltMap[mainName]
end

function RMCharacter:Init()
	self:BuildOnlineMap()
	self:BuildAltMap()	
end

-- imports the guild roster to the character db if a character is absent
function RMCharacter:BuildOnlineMap()	       			   
    -- add guild members to character db if not present		
	if RaidMarshal.db.profile.debug then RaidMarshal:Print("Scanning who is online") end
	self.onlineMap = {}
	self.roleOnlineMap = {}
	self.classOnlineMap = {}
	GuildRoster()				
    local numGuildMembers = GetNumGuildMembers(true)
    local name, rank, rankIndex, level, characterClass, zone, note, officernote, online, status
    for i = 1, numGuildMembers, 1 do
        name, rank, rankIndex, level, characterClass, zone, note, officernote, online, status = GetGuildRosterInfo(i)		        		
		-- if the guildie isn't in the DB, save them		   					       
		if online then
			if not self:Load(name) then
				--if RaidMarshal.db.profile.debug then RaidMarshal:Print("Adding "..name.." to character database") end				
				-- save as sync event so it doesn't flag last updated or broadcast
				self:Save(self:New(name, characterClass), true)            
			end
			local char = RMCharacter:Load(name)								
			self.onlineMap[name] = name
			if not self.classOnlineMap[characterClass] then
				self.classOnlineMap[characterClass] = {}
			end
			table.insert(self.classOnlineMap[characterClass], name)
			local roleName = char.role
			if not roleName then
				roleName = "Non Raider"
			end
			if not self.roleOnlineMap[roleName] then
				self.roleOnlineMap[roleName] = {}
			end
			table.insert(self.roleOnlineMap[roleName], name)												
    	end
    end
end

-- return an array of all characters
function RMCharacter:LoadAll()	
	local charTable = {}	
	for name, char in pairs(RaidMarshal.db.profile.characters) do		
		table.insert(charTable, char)		
	end		
	return charTable
end

function RMCharacter:GetRolePlural(role)
	if not self.rolePlural[role] then
		return "Non Raiders"
	else
		return self.rolePlural[role] 
	end 
end
-- let people edit themselves for now
function RMCharacter:CanEdit(charName)
	return UnitName("player")==charName or CanEditOfficerNote()	
end		

function RMCharacter:CanEditAlts(charName)
	return UnitName("player")==charName or CanEditOfficerNote()	
end
		
function RMCharacter:GetSyncKeys()
	local charTable = RaidMarshal.db.profile.characters
	local syncKeyTable = {}
	for key, char in pairs(charTable) do			
		syncKeyTable[key]=char.lastUpdated
	end
	return syncKeyTable
end
