-- Hooks.lua
-- Part of RS_ClassColors by Stupid (Crushridge-US, Horde)
--
-- Colorization methods for the various parts of the in-game UI.

-- Colors instances of a player's name in chat with that of their class, when
-- possible.
-- frame: the chat frame
-- text: the text to add
-- r, g, b: the message color
-- id: the message's unique ID, for later reference
function RS_ClassColors:AddMessage(frame, text, r, g, b, id)
	local formMsg = text;
	if (self.db.profile.colorizeChat and text ~= nil) then
		for internal, displayed in string.gmatch(text, "|Hplayer:(.-)|h%[(.-)%]|h") do
			local groupNum = self:FindPlayerClasses(displayed);
			if (groupNum and self.db.profile.showGroupNumbers) then
				formMsg = string.gsub(formMsg, "|Hplayer:" .. internal .. "|h%[" .. displayed .. "%]|h", "|Hplayer:" .. internal .. "|h%[" .. self:GetClassColor(self:GetPlayerClass(displayed)) .. displayed .. ":" .. groupNum .. "|r%]|h");
			else
				formMsg = string.gsub(formMsg, "|Hplayer:" .. internal .. "|h%[" .. displayed .. "%]|h", "|Hplayer:" .. internal .. "|h%[" .. self:GetClassColor(self:GetPlayerClass(displayed)) .. displayed .. "|r%]|h");
			end
		end
	end
	self.hooks[frame].AddMessage(frame, formMsg, r, g, b, id);
end

-- Replaces the default Score Frame painter with one that colorizes player names
-- by class.
function RS_ClassColors:WorldStateScoreFrame_Update()
	if (self.db.profile.colorizeBGs == false) then return; end
	for i=1,MAX_WORLDSTATE_SCORE_BUTTONS do
		local index = FauxScrollFrame_GetOffset(WorldStateScoreScrollFrame) + i;
		if index > GetNumBattlefieldScores() then break; end
		local _,_,_,_,_,_,_,_, class = GetBattlefieldScore(index);
		local nameText = getglobal("WorldStateScoreButton" .. i .. "NameText"):GetText();
		if (nameText == UnitName("player")) then
			getglobal("WorldStateScoreButton" .. i .. "NameText"):SetText("|cff00ff00" .. nameText .. "|r");
		else
			getglobal("WorldStateScoreButton" .. i .. "NameText"):SetText(self:GetClassColor(class) .. nameText .. "|r");
		end
	end
end

-- Replaces the default Friends Frame painter with one that colorizes player
-- names by class.
function RS_ClassColors:FriendsList_Update()
	if (self.db.profile.colorizeFriends == false) then return; end
	local friendOffset = FauxScrollFrame_GetOffset(FriendsFrameFriendsScrollFrame);
	local friendIndex;
	for i=1,FRIENDS_TO_DISPLAY do
		friendIndex = friendOffset + i;
		local name, level, class, area, connected, status = GetFriendInfo(friendIndex);
		local nameText = getglobal("FriendsFrameFriendButton" .. i .. "ButtonTextName");
		local nameLocationText = getglobal("FriendsFrameFriendButton" .. i .. "ButtonTextLocation");
		local infoText = getglobal("FriendsFrameFriendButton"..i.."ButtonTextInfo");
		if (name) then
			if (connected) then
				name = self:GetClassColor(class) .. name .. "|r";
				nameText:SetText(name)
				if (self.db.profile.colorizeZones and GetRealZoneText() == area) then
					nameLocationText:SetText(format(TEXT("|cff00ff00- %s|r %s"), area, status));
				else
					nameLocationText:SetText(format(TEXT(FRIENDS_LIST_TEMPLATE), area, status));
				end
				if (self.db.profile.colorizePlayerLevels or self.db.profile.colorizeClassNames) then
					local newLevelTemplate = string.gsub(FRIENDS_LEVEL_TEMPLATE, "%%d", "%%s");
					if (self.db.profile.colorizePlayerLevels) then
						level = self:ColorizeLevel(level);
					end
					if (self.db.profile.colorizeClassNames) then
						class = self:GetClassColor(class) .. class .. "|r";
					end
					infoText:SetText(format(TEXT(newLevelTemplate), level, class));
				end
			elseif (self.db.profile.colorizeOffline) then
				name = self:GetClassColor(self:GetPlayerClass(name)) .. name .. "|r";
				local offlineWord = string.match(FRIENDS_LIST_OFFLINE_TEMPLATE, "^|cff999999%%s %- (.+)|r$")
				nameLocationText:SetText(format(TEXT("|cff999999 - %s|r"), offlineWord));
				nameText:SetText(name)
			end
		end
	end
end

-- Replaces the default Who Frame painter with one that colorizes player names
-- by class.
function RS_ClassColors:WhoList_Update()
	if (self.db.profile.colorizeWho == false) then return; end
	local whoOffset = FauxScrollFrame_GetOffset(WhoListScrollFrame);
	local whoIndex;
	for i=1,WHOS_TO_DISPLAY do
		whoIndex = whoOffset + i;
		local name, _, level, _, class, zone = GetWhoInfo(whoIndex);
		if (name) then
			local r,g,b = self:GetClassColorComponents(class)
			getglobal("WhoFrameButton"..i.."Name"):SetTextColor(r,g,b);
			if (self.db.profile.colorizePlayerLevels) then
				level = self:ColorizeLevel(level);
				getglobal("WhoFrameButton"..i.."Level"):SetText(level);
			end
			if (self.db.profile.colorizeZones and UIDropDownMenu_GetSelectedID(WhoFrameDropDown) == 1 and GetRealZoneText() == zone) then
				local variableText = getglobal("WhoFrameButton"..i.."Variable");
				variableText:SetText("|cff00ff00" .. zone .. "|r");
			end
		end
	end
end

-- Replaces the default Guild Frame painter with one that colorizes player names
-- by class.
function RS_ClassColors:GuildStatus_Update()
	if (self.db.profile.colorizeGuild == false) then return; end
	local guildOffset = FauxScrollFrame_GetOffset(GuildListScrollFrame);
	local guildIndex;
	for i=1,GUILDMEMBERS_TO_DISPLAY do
		guildIndex = guildOffset + i;
		local name, _,_, level, class, zone, _,_, online = GetGuildRosterInfo(guildIndex);
		if (name and (online or self.db.profile.colorizeOffline)) then
			local r,g,b = self:GetClassColorComponents(class)
			getglobal("GuildFrameButton"..i.."Name"):SetTextColor(r,g,b);
			getglobal("GuildFrameGuildStatusButton"..i.."Name"):SetTextColor(r,g,b);
			if (self.db.profile.colorizeZones and GetRealZoneText() == zone) then
				getglobal("GuildFrameButton"..i.."Zone"):SetText("|cff00ff00" .. zone .. "|r");
			end
			if (self.db.profile.colorizePlayerLevels) then
				level = self:ColorizeLevel(level);
				getglobal("GuildFrameButton"..i.."Level"):SetText(level);
			end
		end
	end
end
