local ModName = "RPLanguage 0.1.025"

RPLanguage = LibStub("AceAddon-3.0"):NewAddon(ModName, "AceConsole-3.0", "AceEvent-3.0")

local configoptions = {
    name = ModName,
    type = 'group',
    args = {

		debug={
            name="Debug",
            desc="Enables / Disables RPLanguage Addon Debugging",
            type="toggle",
			order=1,
            set = function(info,val) RPLanguage.debug = val end,
            get = function(info) return RPLanguage.debug end
        }, -- Debug

        enable={
            name="Enable",
            desc="Enables / Disables RPLanguage Addon",
            type="toggle",
			order=0,
            set = function(info,val) if val then RPLanguage:OnEnable() else RPLanguage:OnDisable() end end,
            get = function(info) return RPLanguage.db.profile.enabled end
        }, -- Enable

		help = {
			name="Instructions",
            type="group",
			order = 50,
			args={
				helpheader={
				  type="header",
				  name="RPLanguage Instructions",
				  order=0,
				}, -- helpheader
				
				instructions = {
					type = "description",
					order=25,
					name = 	"RPLanguage is a flexible and extensible language emulation tool for WoW.\n\n" .. 
							"Command List:\n/rpl - Calls up this configuration screen\n" .. 
							"/rps - SAY something in RPLanguage (Syntax: /rps <message>)\n" ..
							"/rpg - GUILD chat in RPLanguage (Syntax: /rpg <message>)\n" ..
							"/rpp - PARTY chat in RPLanguage (Syntax: /rpp <message>)\n" ..
							"/rpr - RAID chat in RPLanguage (Syntax: /rpr <message>)\n" ..
							"/rpy - YELL something in RPLanguage (Syntax: /rpy <message>)\n" ..
							"/rp  - speak using last chat type. (Syntax: /rp <message>)\n" ..
							"\n\nRPLanguage was created by A. Koelewyn.",		
		
				}, -- ParseDesc
				
			}, -- help args
		}, -- help

		languages = {
            name="Known Languages",
            type="group",
			order=75,
			args={
				builtinheader={
				  type="header",
				  name="Built-In RPLanguages",
				  order=0,
				}, -- builtinheader
		    	
				celestial={
		    	  name="Celestial",
            	  desc="Allows your Character to understand the Celestial RPLanguage",
            	  type="toggle",
				  order=10,
            	  set = function(info,val) RPLanguage.db.profile.ParseCelestial = val end,
            	  get = function(info) return RPLanguage.db.profile.ParseCelestial end
        	    },  -- Celestial
				
				draconic={
		    	  name="Draconic",
            	  desc="Allows your Character to understand the Draconic RPLanguage",
            	  type="toggle",
				  order=13,
            	  set = function(info,val) RPLanguage.db.profile.ParseDraconic = val end,
            	  get = function(info) return RPLanguage.db.profile.ParseDraconic end
        	    }, -- Draconic

		    	dreamspeak={
		    	  name="Dreamspeak",
            	  desc="Allows your Character to understand the Dreamspeak RPLanguage",
            	  type="toggle",
				  order=16,
            	  set = function(info,val) RPLanguage.db.profile.ParseDream = val end,
            	  get = function(info) return RPLanguage.db.profile.ParseDream end
        	    },  -- Dreamspeak
				
				elemental={
		    	  name="Elemental",
            	  desc="Allows your Character to understand the Elemental(Kalimag) RPLanguage",
            	  type="toggle",
				  order=19,
            	  set = function(info,val) RPLanguage.db.profile.ParseElemental = val end,
            	  get = function(info) return RPLanguage.db.profile.ParseElemental end
        	    },  -- Elemental
				
				eredun={
		    	  name="Eredun",
            	  desc="Allows your Character to understand the Eredun(Demonic) RPLanguage",
            	  type="toggle",
				  order=22,
            	  set = function(info,val) RPLanguage.db.profile.ParseEredun = val end,
            	  get = function(info) return RPLanguage.db.profile.ParseEredun end
        	    }, -- Eredun

		    	rogue={
		    	  name="Rogue's Cant",
            	  desc="Allows your Character to understand the Rogue's Cant RPLanguage",
            	  type="toggle",
				  order=25,
            	  set = function(info,val) RPLanguage.db.profile.ParseRCant = val end,
            	  get = function(info) return RPLanguage.db.profile.ParseRCant end
        	    },  -- Rogues cant
				
				secret={
		    	  name="Secret",
            	  desc="Allows your Character to understand the Secret RPLanguage",
            	  type="toggle",
				  order=1,
            	  set = function(info,val) RPLanguage.db.profile.ParseSecret = val end,
            	  get = function(info) return RPLanguage.db.profile.ParseSecret end
        	    }, -- Secret

				Parsedesc = {
					type = "description",
					order=28,
					name = "Select the RPLanguages you wish to have your character understand, there are some preset languages, such as Eredun, the language of the Burning Legion; as well as a nondescript \"Secret\" RPLanguage.  You are also given the option to specify up to two custom Languages.",
				}, -- ParseDesc
				
				customheader={
				  type="header",
				  order=50,
				  name="Custom RPLanguages",
				}, -- customheader
		    	
				custom1={
		    	  name= function(info) if RPLanguage.db.profile.Custom1Name and string.trim(RPLanguage.db.profile.Custom1Name) ~= "" then return RPLanguage.db.profile.Custom1Name else return "Custom #1" end end,
            	  desc="Allows your Character to understand a custom-named RPLanguage",
            	  type="toggle",
				  disabled = function(info) if RPLanguage.db.profile.Custom1Name and string.trim(RPLanguage.db.profile.Custom1Name) ~= "" then return false else return true end end, 
				  order=53,
            	  set = function(info,val) RPLanguage.db.profile.ParseCustom1 = val end,
            	  get = function(info) return RPLanguage.db.profile.ParseCustom1 end
        	    }, -- Custom1
				
				custom1name={
				  name = "Custom RPLanguage #1",
				  type = "input",
				  order=55,
				  validate= function(info, val) if val == "" then RPLanguage.db.profile.ParseCustom1 = false; return true end if not string.match(val, "%u%l%l%l[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?") then return "The name of the language must be a properly capitalized name between 5 and 25 characters long." else return true end end,
				  desc = "Type the name of the Custom RPLanguage you would like to understand.",
				  set = function(info,val) RPLanguage.db.profile.Custom1Name = val; if not val or val:trim() == "" then RPLanguage.db.profile.ParseCustom1 = false; end end,
            	  get = function(info) return RPLanguage.db.profile.Custom1Name end
				}, -- Custom1Name
				
				custom2={
		    	  name= function(info) if RPLanguage.db.profile.Custom2Name and string.trim(RPLanguage.db.profile.Custom2Name) ~= "" then return RPLanguage.db.profile.Custom2Name else return "Custom #2" end end,
            	  desc="Allows your Character to understand a custom-named RPLanguage",
            	  type="toggle",
				  disabled = function(info) if RPLanguage.db.profile.Custom2Name and string.trim(RPLanguage.db.profile.Custom2Name) ~= "" then return false else return true end end, 
				  order=57,
            	  set = function(info,val) RPLanguage.db.profile.ParseCustom2 = val end,
            	  get = function(info) return RPLanguage.db.profile.ParseCustom2 end
        	    }, -- Custom2
				
				custom2name={
				  name = "Custom RPLanguage #2",
				  type = "input",
				  order=59,
				  validate= function(info, val) if val == "" then RPLanguage.db.profile.ParseCustom2 = false; return true end if not string.match(val, "%u%l%l%l[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?[%a ]?") then return "The name of the language must be a properly capitalized name between 5 and 25 characters long." else return true end end,
				  desc = "Type the name of the Custom RPLanguage you would like to understand.",
				  set = function(info,val) RPLanguage.db.profile.Custom2Name = val; if not val or val:trim() == "" then RPLanguage.db.profile.ParseCustom2 = false; end end,
            	  get = function(info) return RPLanguage.db.profile.Custom2Name end
				}, -- Custom2Name
				
				speakingheader={
				  type="header",
				  order=70,
				  name="Spoken RPLanguage",
				}, -- speaking
				
				speaking={
				  name = "Select an RPLanguage to Speak",
				  type="select",
				  order=75,
				  disabled = function(info) 
				    if RPLanguage.db.profile.ParseSecret or RPLanguage.db.profile.ParseCelestial or RPLanguage.db.profile.ParseDraconic or 
				  	RPLanguage.db.profile.ParseDream or RPLanguage.db.profile.ParseElemental or RPLanguage.db.profile.ParseEredun or
					RPLanguage.db.profile.ParseRCant or RPLanguage.db.profile.ParseCustom1 or RPLanguage.db.profile.ParseCustom2 
					then return false 
					else RPLanguage.db.profile.Speaking = "None"; return true 
					end end,
				  values = function(info)
				  		local valtable = {None="None"}
				  		if RPLanguage.db.profile.ParseSecret then valtable.Secret="Secret"; end
				  		if RPLanguage.db.profile.ParseCelestial then valtable.Celestial="Celestial"; end
				  		if RPLanguage.db.profile.ParseDraconic then valtable.Draconic="Draconic"; end
				  		if RPLanguage.db.profile.ParseDream then valtable.Dreamspeak="Dreamspeak"; end
				  		if RPLanguage.db.profile.ParseElemental then valtable.Elemental="Elemental"; end
				  		if RPLanguage.db.profile.ParseEredun then valtable.Eredun="Eredun"; end
				  		if RPLanguage.db.profile.ParseRCant then valtable.RCant="Rogue's Cant"; end
				  		if RPLanguage.db.profile.ParseCustom1 then valtable.Custom1 = (RPLanguage.db.profile.Custom1Name); end
				  		if RPLanguage.db.profile.ParseCustom2 then valtable.Custom2 = (RPLanguage.db.profile.Custom2Name); end
						return valtable
						end,
				  width="full",
				  get= function(info) if not RPLanguage.db.profile.Speaking or string.trim(RPLanguage.db.profile.Speaking) == "" then RPLanguage.db.profile.Speaking = "None" end return RPLanguage.db.profile.Speaking end,
				  set= function(info, val) RPLanguage.db.profile.Speaking = val end,
				}, -- speaking		
				  
			}, -- Languages Args
		}, -- Languages

    }, -- Configopts Args
} -- Configopts

local defaults = {
	profile = {
		ParseSecret = true,
		ParseCelestial = false, 
		ParseDraconic = false,
		ParseDream = false,
		ParseElemental = false,
		ParseEredun = false,
		ParseRCant = false,
		ParseCustom1 = false,
		Custom1Name = "",
		ParseCustom2 = false,
		Custom2Name = "",
		Speaking = "Secret",
		enabled = true,
	} -- profile
} -- defaults

local DIRECTION_FORWARD = 1
local DIRECTION_BACKWARD = -1
local INDEX_PLAINTEXT = 2
local INDEX_CIPHERTEXT = 4

-- Length, Match pattern, 							Skip, Replace pattern
local MangleSecret = {
	{8, "[iI]nimicus",								8, "Inimicus"	},
	{2, "([Qq])u",									2, "%1'"		},
	{1, "-",										1, "~"			},
	{3,	"n%'t",										3, "xdt"		},
	{3,	"%sa%s",									3, "-k'"		},
	{2,	"A%s",										2, "L'"			},
	{4,	"%san%s",									4, "-uk'"		},
	{3,	"An%s",										3, "Qu'"		},
	{5,	"(%s)([Tt])he%s",							5, "%1%2al'"	},
	{3, "ing",										3, "'ak"		},
}

-- Length, Replace pattern, 						Skip, Match pattern
local UnmangleSecret = {
	{8,	"Inimicus",									8, "Inimicus"	},
	{2, "%1u",										2, "([Qq])'"	},
	{1, "-",										1, "~"			},
	{3,	"n't",										3, "xdt"		},
	{3,	" a ",										3, "%-k'"		},
	{2,	"A ",										2, "L'"			},
	{4,	" an ",										4, "%-uk'"		},
	{3,	"An ",										3, "Qu'"		},
	{5,	"%1%2he ",									5, "(%s)([Tt])al'"	},
	{3, "ing",										3, "'ak"		}
}


--	SS, EE, TT, FF, LL, MM, OO - mangled doubles (lowercase only)
--	TH, HE, AN, IN, ER, ON, RE - mangled digraphs (lowercase only)

-- ATH, THA, SHE, HES, ANF, FAN, LIN, INL, ERR, RER, covering trigraphs (lowercase only)
-- 

--  A E I O U Y - Mangled Vowels
--  B D G H J K M N P R S T W Z - Mangled Consonants

-- Length, plaintext pattern, 						Skip, Cipher pattern
local CipherSecret = {

-- covering trigraphs
	{3, "ath",										3, "e%-x"	}, -- covering ciphertext eee
	{3, "tha",										3, "t%-x"	}, -- covering ciphertext eee
--	{3, "aaa",										3, "   "    }, -- covering ciphertext eee
	{3, "she",										3, "s%-x"	}, -- covering ciphertext ttt
	{3, "hes",										3, "h%-x"	}, -- covering ciphertext ttt
--	{3, "sss",										3, "   "	}, -- covering ciphertext ttt
	{3, "anf",										3, "a%-x"	}, -- covering ciphertext fff
	{3, "fan",										3, "f%-x"	}, -- covering ciphertext fff
--	{3, "fff",										3, "   "	}, -- covering ciphertext fff	
	{3, "lin",										3, "l%-x"	}, -- covering ciphertext lll
	{3, "inl",										3, "i%-x"	}, -- covering ciphertext lll
--	{3, "lll",										3, "   "	}, -- covering ciphertext lll
	{3, "err",										3, "r%-x"	}, -- covering ciphertext mmm
	{3, "rer",										3, "m%-x"	}, -- covering ciphertext mmm
--	{3, "rrr",										3, "   "	}, -- covering ciphertext mmm
	{3, "ion",										3, "n%-x"	}, -- covering ciphertext ooo
	{3, "oni",										3, "o%-x"	}, -- covering ciphertext ooo
--	{3, "iii",										3, "   "	}, -- covering ciphertext ooo
	{3, "rek",										3, "k%-x"	}, -- covering ciphertext sss
	{3, "kre",										3, "d%-x"	}, -- covering ciphertext sss
--	{3, "kkk",										3, "   "	}, -- covering ciphertext sss

-- original digraphs
    {2,	"ss",										2, "th"		}, -- covered by sm
	{2,	"th",										2, "ee"		}, -- conflicts with aa
	{2,	"ee",										2, "he"		}, -- conflicts with ma
	{2,	"he",										2, "tt"		}, -- covered by ss
	{2,	"tt",										2, "an"		}, -- conflicts with yh
	{2,	"an",										2, "ff"		}, -- covered by ff,
	{2,	"ff",										2, "in"		}, -- conflicts with eh
	{2,	"in",										2, "ll"		}, -- covered by ll
	{2,	"ll",										2, "er"		}, -- covered by an
	{2,	"er",										2, "mm"		}, -- conflicts with rr
	{2,	"mm",										2, "on"		}, -- conflicts with ih
	{2,	"on",										2, "oo"		}, -- conflicts with ii
	{2,	"oo",										2, "re"		}, -- conflicts with na
	{2,	"re",										2, "ss"		}, -- conflicts with kk
	
-- covering digraphs
	{2, "sm",										2, "kk"		}, -- covering ciphertext th, covered by tt
	{2, "aa",										2, "-m"		}, -- covering ciphertext ee, formerly sm, no longer conflicts with tr
	{2, "ma",										2, "-a"		}, -- covering ciphertext he, formerly aa, no longer conflicts with yy
	{2, "yh",										2, "-j"		}, -- covering ciphertext an, formerly ma, no longer conflicts with ry
	{2, "eh",										2, "-w"		}, -- covering ciphertext in, formerly yh, no longer conflicts with un
	{2, "rr",										2, "eh"		}, -- covering ciphertext mm, covered by an
	{2, "ih",										2, "-r"		}, -- covering ciphertext on, formerly rr, no longer conflicts with nn
	{2, "ii",										2, "-i"		}, -- covering ciphertext oo, formerly ih, no longer conflicts with em
	{2, "na",										2, "ii"		}, -- covering ciphertext re, covered by ee
	{2, "kk",										2, "-n"		}, -- covering ciphertext ss, formerly na, no longer conflicts with hy

-- monographs
	{1, 	"a",									1, "e"		},
	{1, 	"e",									1, "i"		},
	{1, 	"i",									1, "o"		},
	{1, 	"o",									1, "u"		},
	{1, 	"u",									1, "y"		},
	{1, 	"y",									1, "a"		},
		
	{1, 	"A",									1, "U"		},
	{1, 	"E",									1, "Y"		},
	{1, 	"I",									1, "A"		},
	{1, 	"O",									1, "E"		},
	{1, 	"U",									1, "I"		},
	{1, 	"Y",									1, "O"		},

	{1, 	"k",									1, "s"		},
	{1, 	"s",									1, "t"		},
	{1, 	"t",									1, "k"		},

	{1, 	"K",									1, "T"		},
	{1, 	"S",									1, "K"		},
	{1, 	"T",									1, "S"		},

	{1, 	"n",									1, "r"		},
	{1, 	"h",									1, "n"		},
	{1, 	"m",									1, "h"		},
	{1, 	"r",									1, "m"		},
	
	{1, 	"N",									1, "H"		},
	{1, 	"H",									1, "M"		},
	{1, 	"M",									1, "R"		},
	{1, 	"R",									1, "N"		},

	{1, 	"w",									1, "g"		},
	{1, 	"g",									1, "z"		},
	{1, 	"z",									1, "w"		},

	{1, 	"W",									1, "Z"		},
	{1, 	"G",									1, "W"		},
	{1, 	"Z",									1, "G"		},

	{1, 	"d",									1, "p"		},
	{1, 	"b",									1, "d"		},
	{1, 	"j",									1, "b"		},
	{1, 	"p",									1, "j"		},

	{1, 	"D",									1, "B"		},
	{1, 	"B",									1, "J"		},
	{1, 	"J",									1, "P"		},
	{1, 	"P",									1, "D"		}
}

local function RPL_ChatFilter(msg)
  if RPLanguage.db.profile.ParseSecret and string.match(msg, "^%[Secret%] ") then	
	return false, "[Secret] "..RPLanguage:UnmangleSecret(string.sub(msg, 9));
  elseif RPLanguage.db.profile.ParseCelestial and string.match(msg, "^%[Celestial%] ") then	
	return false, "[Celestial] "..RPLanguage:UnmangleSecret(string.sub(msg, 12));
  elseif RPLanguage.db.profile.ParseDraconic and string.match(msg, "^%[Draconic%] ") then	
	return false, "[Draconic] "..RPLanguage:UnmangleSecret(string.sub(msg, 11));
  elseif RPLanguage.db.profile.ParseDream and string.match(msg, "^%[Dreamspeak%] ") then	
	return false, "[Dreamspeak] "..RPLanguage:UnmangleSecret(string.sub(msg, 13));
  elseif RPLanguage.db.profile.ParseElemental and string.match(msg, "^%[Elemental%] ") then	
	return false, "[Elemental] "..RPLanguage:UnmangleSecret(string.sub(msg, 12));
  elseif RPLanguage.db.profile.ParseEredun and string.match(msg, "^%[Eredun%] ") then	
	return false, "[Eredun] "..RPLanguage:UnmangleSecret(string.sub(msg, 9));
  elseif RPLanguage.db.profile.ParseRCant and string.match(msg, "^%[Rogue%'s Cant%] ") then
	return false, "[Rogue's Cant] "..RPLanguage:UnmangleSecret(string.sub(msg, 15));
  elseif RPLanguage.db.profile.ParseCustom1 and string.match(msg, "^%[".. RPLanguage.db.profile.Custom1Name .."%] ") then	
	return false, "[".. RPLanguage.db.profile.Custom1Name .."] "..RPLanguage:UnmangleSecret(string.sub(msg, 3 + #RPLanguage.db.profile.Custom1Name));
  elseif RPLanguage.db.profile.ParseCustom2 and string.match(msg, "^%[".. RPLanguage.db.profile.Custom2Name .."%] ") then	
	return false, "[".. RPLanguage.db.profile.Custom2Name .."] "..RPLanguage:UnmangleSecret(string.sub(msg, 3 + #RPLanguage.db.profile.Custom2Name));
  end
  return false
end
		
		
		
-- ###################################################
-- ## RPLanguage Method Functions ####################
-- ###################################################
		
function RPLanguage:OnInitialize()
    -- Called when the addon is loaded
    LibStub("AceConfig-3.0"):RegisterOptionsTable(ModName, configoptions)
	self.db = LibStub("AceDB-3.0"):New("RPLangDB", defaults)
    self:RegisterChatCommand("rpl", "OptionsCmd")
    self:RegisterChatCommand("rpltest", "QuickTestCmd")
	self:RegisterChatCommand("rp", "RPSpeakCmd")
	self:RegisterChatCommand("rps", "RPSayCmd")
	self:RegisterChatCommand("rpg", "RPGuildCmd")
	self:RegisterChatCommand("rpp", "RPPartyCmd")
	self:RegisterChatCommand("rpr", "RPRaidCmd")
	self:RegisterChatCommand("rpy", "RPYellCmd")
	self.chatType = "SAY"
	self:Print("RPLanguage Loaded.  (/rpl to configure)")
	ChatFrame_AddMessageEventFilter("CHAT_MSG_SAY", RPL_ChatFilter)
	ChatFrame_AddMessageEventFilter("CHAT_MSG_GUILD", RPL_ChatFilter)
	ChatFrame_AddMessageEventFilter("CHAT_MSG_PARTY", RPL_ChatFilter)
	ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", RPL_ChatFilter)
	ChatFrame_AddMessageEventFilter("CHAT_MSG_YELL", RPL_ChatFilter)
end

function RPLanguage:OnEnable()
    -- Called when the addon is enabled
	ChatFrame_AddMessageEventFilter("CHAT_MSG_SAY", RPL_ChatFilter)
	ChatFrame_AddMessageEventFilter("CHAT_MSG_GUILD", RPL_ChatFilter)
	ChatFrame_AddMessageEventFilter("CHAT_MSG_PARTY", RPL_ChatFilter)
	ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", RPL_ChatFilter)
	ChatFrame_AddMessageEventFilter("CHAT_MSG_YELL", RPL_ChatFilter)
	self.db.profile.enabled = true
end

function RPLanguage:OnDisable()
    -- Called when the addon is disabled
	ChatFrame_RemoveMessageEventFilter("CHAT_MSG_SAY", RPL_ChatFilter)
	ChatFrame_RemoveMessageEventFilter("CHAT_MSG_GUILD", RPL_ChatFilter)
	ChatFrame_RemoveMessageEventFilter("CHAT_MSG_PARTY", RPL_ChatFilter)
	ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", RPL_ChatFilter)
	ChatFrame_RemoveMessageEventFilter("CHAT_MSG_YELL", RPL_ChatFilter)
	self.db.profile.enabled = false
end

function RPLanguage:OptionsCmd(input)
    if not input or input:trim() == "" then 
        LibStub("AceConfigDialog-3.0"):Open(ModName)
    else
        LibStub("AceConfigCmd-3.0").HandleCommand(RPLanguage, "rpl", ModName, input)
    end
end

function RPLanguage:QuickTestCmd(input)

    if input and #input <= 225 and input:trim() ~= "" then
	  manglebuf = self:MangleSecret(input)
	  unmanglebuf = self:UnmangleSecret(manglebuf)

	  self:Print("Testing Mangling logic.")
      self:Print("You say: "..input)
	  self:Print("You say: [Secret] "..manglebuf)
	  self:Print("You say: [Secret] "..unmanglebuf)
	  
    end
end

function RPLanguage:RPSpeakCmd(input)
  local Speak
  if not self.db.profile.enabled then return; end
  if not self.db.profile.Speaking or string.trim(self.db.profile.Speaking) == "" 
  		or self.db.profile.Speaking == "None" then 
	self:Print("You are not speaking any RPLanguage");
	return;
  end
  
  -- make sure we have the right language
  if RPLanguage.db.profile.Speaking == "RCant" then Speak = "Rogue's Cant"
  elseif RPLanguage.db.profile.Speaking == "Custom1" then Speak = RPLanguage.db.profile.Custom1Name
  elseif RPLanguage.db.profile.Speaking == "Custom2" then Speak = RPLanguage.db.profile.Custom2Name
  else Speak = RPLanguage.db.profile.Speaking end
  
  SendChatMessage("[".. Speak .."] "..self:MangleSecret(input), self.ChatType, GetDefaultLanguage("player") )
  if self.debug then self:Print("Translating: "..input); end
end

function RPLanguage:RPSayCmd(input)
	self.ChatType = "SAY"
	if not input or input:trim() == "" then return; end
	self:RPSpeakCmd(input)
end

function RPLanguage:RPGuildCmd(input)
	self.ChatType = "GUILD"
	if not input or input:trim() == "" then return; end
	self:RPSpeakCmd(input)
end

function RPLanguage:RPPartyCmd(input)
	self.ChatType = "PARTY"
	if not input or input:trim() == "" then return; end
	self:RPSpeakCmd(input)
end

function RPLanguage:RPRaidCmd(input)
	self.ChatType = "RAID"
	if not input or input:trim() == "" then return; end
	self:RPSpeakCmd(input)
end

function RPLanguage:RPYellCmd(input)
	self.ChatType = "YELL"
	if not input or input:trim() == "" then return; end
	self:RPSpeakCmd(input)
end

function RPLanguage:Mangle(input, ruletable, ciphertable, matchindex, replaceindex, direction)

inlen = #input
offset = 0
buildstring = ""
buffer = ""

if inlen == 0 then return input; end

offset = 0  -- Deliberately not setting to -1, to account for the +1 I'll have to add later in string.sub()

lcv = 0

while (offset * direction) < inlen do
    
	-- sometime later, process quotes and escape them from mangling
    
	lcv = lcv + 1
	if lcv > 256 then self:Print("Runaway caught");return "error"; end
	  
	matchfound = false
	
	
	--  Rule Table  (Unidirectional Transformations)
	for ruleindex = 1, #ruletable, 1 do
		rule = ruletable[ruleindex]
		
		-- ensure proper retrieval of the substring.
		if direction == DIRECTION_BACKWARD then
			buffer = string.sub(input, (offset - rule[1]), offset - 1)
		else
			buffer = string.sub(input, offset + 1, (offset + rule[1]) )
		end
		
		if string.match(buffer, rule[matchindex]) then
			-- ensure proper iteration
			if direction == DIRECTION_BACKWARD then
				buildstring = string.gsub(buffer, rule[matchindex], rule[replaceindex], 1) .. buildstring
			else 
				buildstring = buildstring .. string.gsub(buffer, rule[matchindex], rule[replaceindex], 1)
			end
			
			offset = offset + (direction * rule[3])
			matchfound = true
			
			-- debug
			if self.debug then self:Print("Match: "..rule[matchindex].."->"..rule[replaceindex]); end
			break
		end -- if string.match
	end  -- for ruletable rule



	-- Cipher Table (Bidirectional Transformations)
	for ruleindex = 1, #ciphertable, 1 do
		-- short-circuit any found and handled matches
		if matchfound == true then break; end

		rule = ciphertable[ruleindex]
		
		if direction == DIRECTION_BACKWARD then
			buffer = string.sub(input, (offset - rule[1]), offset - 1)
		else
			buffer = string.sub(input, offset + 1, (offset + rule[1]) )
		end
		
		if string.match(buffer, rule[matchindex]) then
			if direction == DIRECTION_BACKWARD then
				buildstring = string.gsub(buffer, rule[matchindex], rule[replaceindex], 1) .. buildstring
			else 
				buildstring = buildstring .. string.gsub(buffer, rule[matchindex], rule[replaceindex], 1)
			end
			offset = offset + (direction * rule[3])
			matchfound = true
			if self.debug then self:Print("Match: "..rule[matchindex].."->"..rule[replaceindex]); end
			break
		end -- if string.match
	end  -- for cipher rule
	
	-- only iterate here if nothing else was found.
	if matchfound == false then
		if direction == DIRECTION_BACKWARD then
			buildstring = string.sub(input, offset + direction, offset + direction) .. buildstring
		else 
			buildstring = buildstring .. string.sub(input, offset + direction, offset + direction)
		end
		offset = offset + direction; 
	end 
end  -- while offset

return buildstring

end  -- Mangle function


function RPLanguage:MangleSecret(input)
return self:Mangle(input, MangleSecret, CipherSecret, INDEX_PLAINTEXT, INDEX_CIPHERTEXT, DIRECTION_BACKWARD)
end

function RPLanguage:UnmangleSecret(input)
return self:Mangle(input, UnmangleSecret, CipherSecret, INDEX_CIPHERTEXT, INDEX_PLAINTEXT, DIRECTION_BACKWARD)
end
