-------------------------------------------------------------------
-- CONTROL SET
--
-- A control set is a grouping of functional control definitions.
-------------------------------------------------------------------

VFL.ControlSet = {};
VFL.ControlSet.__index = VFL.ControlSet;

--- Create a new ControlSet.
function VFL.ControlSet:new()
	local self = {};
	setmetatable(self, VFL.ControlSet);
	self.ctls = {};
	return self;
end

--- Define a control on this ControlSet.
function VFL.ControlSet:DefineControl(tbl)
	if not tbl then error("expected table, got nil"); end
	local name = tbl.name;
	if not name then error("attempt to register anonymous control"); end
	if self.ctls[name] then error("attempt to register duplicate control"); end
	self.ctls[name] = tbl;
end

--- Return the control array for this ControlSet.
function VFL.ControlSet:Controls() return self.ctls; end

---------------------------------------------------------------------
-- UI CONTEXT
--
-- A UI context is a set of control constructors and framepools. All
-- controls generated by a UI context are automatically freed into
-- that context.
---------------------------------------------------------------------

-- Helper functions
local function MakePoolConstructor(name, acquire, cleanup, create)
	local pool = VFL.Pool:new();
	pool.name = name; 
	pool.OnRelease = cleanup; pool.OnFallback = create;
	return function(cc, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20)
		local ret = pool:Acquire();
		ret.Destroy = function(s) pool:Release(s); s.Destroy = nil; end
	end
end

VFL.UIContext = {};
function VFL.UIContext:new(name)
	local self = {};
	self.name = name or "(anonymous)";

	local controlDefs;
	local texp, fsp;
	local pools;
	
	--- Use the given control definition on this context.
	function self:UseControl(ctl)
		if (not ctl) then error("expected controlDef, got nil"); end
		local n = ctl.name; if not n then error("invalid controlDef"); end
		if controlDefs[ctl.name] then return nil; end
		controlDefs[ctl.name] = ctl;
	end
end
