-- StatusBarTexture.lua
-- VFL
-- (C)2006 The VFL Project
--
-- A status bar system that provides some essential features missing from Blizzard's internal
-- StatusBar object.

local function statusBar_SetValueAndColorTable(self, v, c)
	self:SetValue(v); 
	self:SetVertexColor(c.r, c.g, c.b, c.a or 1);
end
local function statusBar_SetColorTable(self, c)
	self:SetVertexColor(c.r, c.g, c.b, c.a or 1);
end

VFLUI.StatusBarTexture = {};
function VFLUI.StatusBarTexture:new(parent)
	local s = VFLUI.CreateTexture(parent);
	s:SetDrawLayer("ARTWORK");
	s:SetWidth(0.001); s:SetHeight(0.001);

	-- Internal state variables
	local color1, color2 = nil, nil;
	local maxw, maxh = 0.001, 0.001;

	local bSetWidth, bSetHeight = s.SetWidth, s.SetHeight;
	function s:SetWidth(w) maxw = w; bSetWidth(self, w); end
	function s:SetHeight(h) maxh = h; bSetHeight(self, h); end
	function s:SetColors(c1, c2) color1 = c1; color2 = c2; end

	function s:SetOrientation(o)
		bSetWidth(self, maxw); bSetHeight(self, maxh);
		if(o == "HORIZONTAL") then
			function self.SetValue(self2, v)
				bSetWidth(self2, v*maxw + (1-v)*0.001);
				self2:SetTexCoord(0, v, 0, 1);
				if color1 then self2:SetVertexColor(CVFromCTLerp(color1, color2, v)); end
			end
		elseif(o == "VERTICAL") then
			function self.SetValue(self2, v)
				bSetHeight(self2, v*maxh + (1-v)*0.001);
				self2:SetTexCoord(0, 1, 0, v);
				if color1 then self2:SetVertexColor(CVFromCTLerp(color1, color2, v)); end
			end
		end
	end

	s.SetValueAndColorTable = statusBar_SetValueAndColorTable;
	s.SetColorTable = statusBar_SetColorTable;

	s.Destroy = VFL.hook(function(s2)
		s2.SetValueAndColorTable = nil; s2.SetColorTable = nil;
		color1 = nil; color2 = nil;
		s2.SetOrientation = nil; s2.SetWidth = nil; s2.SetHeight = nil; s2.SetColors = nil;
	end, s.Destroy);
	
	return s;
end
