-- Shaders.lua
-- RDX - Raid Data Exchange
-- (C)2006 Bill Johnson
--
-- THIS FILE CONTAINS COPYRIGHTED MATERIAL SUBJECT TO THE TERMS OF A SEPARATE
-- LICENSE. UNLICENSED COPYING IS PROHIBITED.
--
-- "Shaders" are independent pieces of code that change the way unit frames are
-- painted.

------------------------------------
-- Scripted Shader - a shader driven by a Script object.
------------------------------------
RDX.RegisterFeature({
	name = "Shader: Scripted";
	category = i18n("Shaders");
	multiple = true;
	IsPossible = function(state)
		if not state:Slot("EmitPaint") then return nil; end
		return true;
	end;
	ExposeFeature = function(desc, state, errs)
		if not desc then VFL.AddError(errs, i18n("Missing descriptor.")); return nil; end
		local md,_,_,ty = RDXDB.GetObjectData(desc.script);
		if (not md) or (ty ~= "Script") or (not md.data) or (not md.data.script) then
			VFL.AddError(errs, i18n("Invalid script pointer.")); return nil;
		end
		return true;
	end;
	ApplyFeature = function(desc, state)
		-- Apply the custom code.
		local paintCode = [[

]];
		paintCode = paintCode .. (RDXDB.GetObjectData(desc.script)).data.script;
		paintCode = paintCode .. [[

]];

		state:Attach(state:Slot("EmitPaint"), true, function(code) code:AppendCode(paintCode); end);
		
		return true;
	end;
	UIFromDescriptor = function(desc, parent, state)
		local ui = VFLUI.CompoundFrame:new(parent);

		local scriptsel = RDXDB.ObjectFinder:new(ui, function(_,_,d) return d and (d.ty == "Script"); end);
		scriptsel:SetLabel("Script object"); scriptsel:Show();
		if desc and desc.script then scriptsel:SetPath(desc.script); end
		ui:InsertFrame(scriptsel);

		function ui:GetDescriptor()
			return { 
				feature = "Shader: Scripted";
				script = scriptsel:GetPath();
			};
		end
		
		return ui;
	end;
	CreateDescriptor = function()
		return { 
			feature = "Shader: Scripted", 
		};
	end;
});

------------------------------
-- Show/Hide Element shader
------------------------------
RDX.RegisterFeature({
	name = "shader_showhide"; version = 1;
	title = i18n("Show/Hide"); category = i18n("Shaders");
	multiple = true;
	IsPossible = function(state)
		if not state:Slot("UnitFrame") then return nil; end
		if not state:Slot("Base") then return nil; end
		return true;
	end;
	ExposeFeature = function(desc, state, errs)
		if not desc then VFL.AddError(errs, i18n("No descriptor.")); return nil; end
		--if (not desc.flag) or (not state:Slot("BoolVar_" .. desc.flag)) then
		--	VFL.AddError(errs, i18n("Invalid condition")); return nil;
		--end
		return true;
	end;
	ApplyFeature = function(desc, state)
		local fname = RDXUI.ResolveFrameReference(desc.owner);
		local paintCode = [[
if ]] .. desc.flag .. [[ or not RDXWM.IsRDXLocked() then ]] .. fname .. [[:Show(); else ]] .. fname .. [[:Hide(); end
]];
		state:Attach(state:Slot("EmitPaint"), true, function(code) code:AppendCode(paintCode); end);
	end;
	UIFromDescriptor = function(desc, parent, state)
		local ui = VFLUI.CompoundFrame:new(parent);

		-- Owner
		local owner = RDXUI.MakeSlotSelectorDropdown(ui, i18n("Target subframe"), state, "Subframe_", true);
		if desc and desc.owner then owner:SetSelection(desc.owner); end

		local flag = RDXUI.MakeSlotSelectorDropdown(ui, i18n("Condition variable"), state, "BoolVar_", nil, "true", "false");
		if desc and desc.flag then flag:SetSelection(desc.flag); end
		
		function ui:GetDescriptor()
			return {
				feature = "shader_showhide"; version = 1;
				owner = owner:GetSelection();
				flag = flag:GetSelection();
			};
		end

		return ui;
	end;
	CreateDescriptor = function()
		return {
			feature = "shader_showhide"; version = 1;
			owner = "Base"; flag = "true";
		};
	end;
});

------------------------------
-- Show/Hide Element shader
------------------------------
RDX.RegisterFeature({
	name = "shader_applytex"; version = 1;
	title = i18n("Apply Texture"); category = i18n("Shaders");
	multiple = true;
	IsPossible = function(state)
		if not state:Slot("UnitFrame") then return nil; end
		if not state:Slot("Base") then return nil; end
		return true;
	end;
	ExposeFeature = function(desc, state, errs)
		if not desc then VFL.AddError(errs, i18n("No descriptor.")); return nil; end
		if (not desc.owner) or (not state:Slot("Tex_" .. desc.owner)) then
			VFL.AddError(errs, i18n("Invalid texture")); return nil;
		end
		if (not desc.var) then VFL.AddError(errs, i18n("Invalid variable")); return nil; end
		return true;
	end;
	ApplyFeature = function(desc, state)
		local paintCode = [[
frame.Tex_]] .. desc.owner .. [[:SetTexture(]] .. desc.var .. [[);
]];
		state:Attach(state:Slot("EmitPaint"), true, function(code) code:AppendCode(paintCode); end);
	end;
	UIFromDescriptor = function(desc, parent, state)
		local ui = VFLUI.CompoundFrame:new(parent);

		-- Owner
		local owner = RDXUI.MakeSlotSelectorDropdown(ui, i18n("Target texture"), state, "Tex_");
		if desc and desc.owner then owner:SetSelection(desc.owner); end

		local flag = RDXUI.MakeSlotSelectorDropdown(ui, i18n("Texture variable"), state, "TexNameVar_");
		if desc and desc.var then flag:SetSelection(desc.var); end
		
		function ui:GetDescriptor()
			return {
				feature = "shader_applytex"; version = 1;
				owner = owner:GetSelection();
				var = flag:GetSelection();
			};
		end

		return ui;
	end;
	CreateDescriptor = function()
		return {
			feature = "shader_applytex"; version = 1;
		};
	end;
});
