-- OpenRDX

----------------------------------------------------------------------
-- An iconic representation of the underlying unit's raid target icon.
----------------------------------------------------------------------
RDX.RegisterFeature({
	name = "Raid Target Icon";
	category = i18n("Icon");
	IsPossible = function(state)
		if not state:Slot("UnitFrame") then return nil; end
		if not state:Slot("Base") then return nil; end
		return true;
	end;
	ExposeFeature = function(desc, state, errs)
		if not desc then VFL.AddError(errs, i18n("Missing descriptor.")); return nil; end
		local flg = true;
		flg = flg and __UFFrameCheck_Proto("Frame_", desc, state, errs);
		flg = flg and __UFAnchorCheck(desc.anchor, state, errs);
		flg = flg and __UFOwnerCheck(desc.owner, state, errs);
		if flg then state:AddSlot("Frame_" .. desc.name); end
		return flg;
	end;
	ApplyFeature = function(desc, state)
		local objname = "Frame_" .. desc.name;

		------------------ On frame creation
		local createCode = [[
local _t = VFLUI.CreateTexture(]] .. RDXUI.ResolveFrameReference(desc.owner) .. [[);
frame.]] .. objname .. [[ = _t;
_t:SetDrawLayer("]] .. (desc.drawLayer or "ARTWORK") .. [[");
_t:SetPoint(]] .. RDXUI.AnchorCodeFromDescriptor(desc.anchor) .. [[);
_t:SetWidth(]] .. desc.w .. [[); _t:SetHeight(]] .. desc.h .. [[);
_t:SetVertexColor(1,1,1,1);
_t:SetTexture("Interface\\TargetingFrame\\UI-RaidTargetingIcons");
_t:Hide();
]];
		state:Attach(state:Slot("EmitCreate"), true, function(code) code:AppendCode(createCode); end);

		------------------ On frame destruction.
		state:Attach(state:Slot("EmitDestroy"), true, function(code) code:AppendCode([[
VFLUI.ReleaseRegion(frame.]] .. objname .. [[);
frame.]] .. objname .. [[ = nil;
]]); end);
		state:Attach(state:Slot("EmitCleanup"), true, function(code) code:AppendCode([[
frame.]] .. objname .. [[:Hide();
]]); end);

		------------------ On paint.
		state:Attach(state:Slot("EmitPaint"), true, function(code) code:AppendCode([[
if GetRaidTargetIndex(uid) then
	frame.]] .. objname .. [[:Show();
	SetRaidTargetIconTexture(frame.]] .. objname .. [[, GetRaidTargetIndex(uid));
else
	frame.]] .. objname .. [[:Hide();
end
]]); end);

		local mux = state:GetContainingWindowState():GetSlotValue("Multiplexer");
		mux:Event_MaskAll("RAID_TARGET_UPDATE", 2);

		return true;
	end;
	UIFromDescriptor = function(desc, parent, state)
		local ui = VFLUI.CompoundFrame:new(parent);

		-- Name/width/height
		local ed_name, ed_width, ed_height = RDXUI.GenNameWidthHeightPortion(ui, desc);

		-- Owner
		local owner = RDXUI.MakeSlotSelectorDropdown(ui, i18n("Owner"), state, "Subframe_", true);
		if desc and desc.owner then owner:SetSelection(desc.owner); end

		-- Drawlayer
		local er = RDXUI.EmbedRight(ui, i18n("Draw layer:"));
		local drawLayer = VFLUI.Dropdown:new(er, RDXUI.DrawLayerDropdownFunction);
		drawLayer:SetWidth(100); drawLayer:Show();
		if desc and desc.drawLayer then drawLayer:SetSelection(desc.drawLayer); else drawLayer:SetSelection("ARTWORK"); end
		er:EmbedChild(drawLayer); er:Show();
		ui:InsertFrame(er);

		-- Anchor
		local anchor = RDXUI.UnitFrameAnchorSelector:new(ui); anchor:Show();
		anchor:SetAFArray(RDXUI.ComposeFrameList(state));
		if desc and desc.anchor then anchor:SetAnchorInfo(desc.anchor); end
		ui:InsertFrame(anchor);
		
		function ui:GetDescriptor()
			local name = ed_name.editBox:GetText();
			return { 
				feature = "Raid Target Icon", name = name, owner = owner:GetSelection();
				drawLayer = drawLayer:GetSelection();
			  w = VFL.clamp(ed_width.editBox:GetNumber(), 0, 1000);
				h = VFL.clamp(ed_height.editBox:GetNumber(), 0, 1000);
				anchor = anchor:GetAnchorInfo();
			};
		end

		return ui;
	end;
	CreateDescriptor = function()
		return { 
			feature = "Raid Target Icon", name = "rti", owner = "Base", drawLayer = "ARTWORK";
		  w = 14; h = 14;
			anchor = { lp = "TOPLEFT", af = "Base", rp = "TOPLEFT", dx = 0, dy = 0};
		};
	end;
});

----------------------------------------------------------------------
-- An iconic representation of Unit status icon for player frame. (made by superraider)
----------------------------------------------------------------------
RDX.RegisterFeature({
   name = "Player Status Icon";
   category = i18n("Icon");
   IsPossible = function(state)
      if not state:Slot("UnitFrame") then return nil; end
      if not state:Slot("Base") then return nil; end
      return true;
   end;
   ExposeFeature = function(desc, state, errs)
      if not desc then VFL.AddError(errs, i18n("Missing descriptor.")); return nil; end
      local flg = true;
      flg = flg and __UFFrameCheck_Proto("Frame_", desc, state, errs);
      flg = flg and __UFAnchorCheck(desc.anchor, state, errs);
      flg = flg and __UFOwnerCheck(desc.owner, state, errs);
      if flg then state:AddSlot("Frame_" .. desc.name); end
      return flg;
   end;
   ApplyFeature = function(desc, state)
      local objname = "Frame_" .. desc.name;

      ------------------ On frame creation
      local createCode = [[
local _t = VFLUI.CreateTexture(]] .. RDXUI.ResolveFrameReference(desc.owner) .. [[);
frame.]] .. objname .. [[ = _t;
_t:SetDrawLayer("]] .. (desc.drawLayer or "ARTWORK") .. [[");
_t:SetPoint(]] .. RDXUI.AnchorCodeFromDescriptor(desc.anchor) .. [[);
_t:SetWidth(]] .. desc.w .. [[); _t:SetHeight(]] .. desc.h .. [[);
_t:SetVertexColor(1,1,1,1);
_t:SetTexture("Interface\\CharacterFrame\\UI-StateIcon");
_t:Hide();
]];
      state:Attach(state:Slot("EmitCreate"), true, function(code) code:AppendCode(createCode); end);

      ------------------ On frame destruction.
      state:Attach(state:Slot("EmitDestroy"), true, function(code) code:AppendCode([[
VFLUI.ReleaseRegion(frame.]] .. objname .. [[);
frame.]] .. objname .. [[ = nil;
]]); end);
      state:Attach(state:Slot("EmitCleanup"), true, function(code) code:AppendCode([[
frame.]] .. objname .. [[:Hide();
]]); end);

      ------------------ On paint.
      state:Attach(state:Slot("EmitPaint"), true, function(code) code:AppendCode([[
local _name = UnitName(uid);
if UnitAffectingCombat(uid) then
   frame.]] .. objname .. [[:Show();
   frame.]] .. objname .. [[:SetTexCoord(0.5, 1, 0, 0.5);
elseif (RDXPlayer.rosterName == _name) and IsResting() then
   frame.]] .. objname .. [[:Show();
   frame.]] .. objname .. [[:SetTexCoord(0, 0.5, 0, 0.421875)
else
   frame.]] .. objname .. [[:Hide();
end
_name = nil;
]]); end);

      local mux = state:GetContainingWindowState():GetSlotValue("Multiplexer");
      mux:Event_MaskAll("PLAYER_UPDATE_RESTING", 2);
      return true;
   end;
   UIFromDescriptor = function(desc, parent, state)
      local ui = VFLUI.CompoundFrame:new(parent);

      -- Name/width/height
      local ed_name, ed_width, ed_height = RDXUI.GenNameWidthHeightPortion(ui, desc);

      -- Owner
      local owner = RDXUI.MakeSlotSelectorDropdown(ui, "Owner", state, "Subframe_", true);
      if desc and desc.owner then owner:SetSelection(desc.owner); end

      -- Drawlayer
      local er = RDXUI.EmbedRight(ui, "Draw layer:");
      local drawLayer = VFLUI.Dropdown:new(er, RDXUI.DrawLayerDropdownFunction);
      drawLayer:SetWidth(100); drawLayer:Show();
      if desc and desc.drawLayer then drawLayer:SetSelection(desc.drawLayer); else drawLayer:SetSelection("ARTWORK"); end
      er:EmbedChild(drawLayer); er:Show();
      ui:InsertFrame(er);

      -- Anchor
      local anchor = RDXUI.UnitFrameAnchorSelector:new(ui); anchor:Show();
      anchor:SetAFArray(RDXUI.ComposeFrameList(state));
      if desc and desc.anchor then anchor:SetAnchorInfo(desc.anchor); end
      ui:InsertFrame(anchor);
      
      function ui:GetDescriptor()
         local name = ed_name.editBox:GetText();
         return {
            feature = "Player Status Icon", name = name, owner = owner:GetSelection();
            drawLayer = drawLayer:GetSelection();
           w = VFL.clamp(ed_width.editBox:GetNumber(), 0, 1000);
            h = VFL.clamp(ed_height.editBox:GetNumber(), 0, 1000);
            anchor = anchor:GetAnchorInfo();
         };
      end

      return ui;
   end;
   CreateDescriptor = function()
      return {
         feature = "Player Status Icon", name = "sti", owner = "Base", drawLayer = "ARTWORK";
        w = 14; h = 14;
         anchor = { lp = "TOPLEFT", af = "Base", rp = "TOPLEFT", dx = 0, dy = 0};
      };
   end;
}); 

----------------------------------------------------------------------
-- An iconic representation if unit is master looter (made by superraider)
----------------------------------------------------------------------
RDX.RegisterFeature({
   name = "Master Looter Icon";
   category = i18n("Icon");
   IsPossible = function(state)
      if not state:Slot("UnitFrame") then return nil; end
      if not state:Slot("Base") then return nil; end
      return true;
   end;
   ExposeFeature = function(desc, state, errs)
      if not desc then VFL.AddError(errs, i18n("Missing descriptor.")); return nil; end
      local flg = true;
      flg = flg and __UFFrameCheck_Proto("Frame_", desc, state, errs);
      flg = flg and __UFAnchorCheck(desc.anchor, state, errs);
      flg = flg and __UFOwnerCheck(desc.owner, state, errs);
      if flg then state:AddSlot("Frame_" .. desc.name); end
      return flg;
   end;
   ApplyFeature = function(desc, state)
      local objname = "Frame_" .. desc.name;

      ------------------ On frame creation
      local createCode = [[
local _t = VFLUI.CreateTexture(]] .. RDXUI.ResolveFrameReference(desc.owner) .. [[);
frame.]] .. objname .. [[ = _t;
_t:SetDrawLayer("]] .. (desc.drawLayer or "ARTWORK") .. [[");
_t:SetPoint(]] .. RDXUI.AnchorCodeFromDescriptor(desc.anchor) .. [[);
_t:SetWidth(]] .. desc.w .. [[); _t:SetHeight(]] .. desc.h .. [[);
_t:SetVertexColor(1,1,1,1);
_t:SetTexture("Interface\\GroupFrame\\UI-Group-MasterLooter");
_t:Hide();
]];
      state:Attach(state:Slot("EmitCreate"), true, function(code) code:AppendCode(createCode); end);

      ------------------ On frame destruction.
      state:Attach(state:Slot("EmitDestroy"), true, function(code) code:AppendCode([[
VFLUI.ReleaseRegion(frame.]] .. objname .. [[);
frame.]] .. objname .. [[ = nil;
]]); end);
      state:Attach(state:Slot("EmitCleanup"), true, function(code) code:AppendCode([[
frame.]] .. objname .. [[:Hide();
]]); end);

      ------------------ On paint. --fridg
      state:Attach(state:Slot("EmitPaint"), true, function(code) code:AppendCode([[
local _, partyMaster, raidMaster = GetLootMethod()
if raidMaster then
	local _name = "";
	if unit.rosterName then
		_name = unit.rosterName;
	else
		_name = UnitName(uid);
	end
	if (_name == RDX.GetUnitByNumber(raidMaster).rosterName) then
		frame.]] .. objname .. [[:Show();
	else
		frame.]] .. objname .. [[:Hide();
	end
elseif partyMaster then
	local _name = UnitName(uid);
	local _pname = UnitName("party"..partyMaster);
	if (partyMaster == 0) and (RDXPlayer.rosterName == _name) then
		frame.]] .. objname .. [[:Show();
	elseif (_name == _pname) then
		frame.]] .. objname .. [[:Show();
	else
		frame.]] .. objname .. [[:Hide();
	end
else
	frame.]] .. objname .. [[:Hide();
end
]]); end);

      return true;
   end;
   UIFromDescriptor = function(desc, parent, state)
      local ui = VFLUI.CompoundFrame:new(parent);

      -- Name/width/height
      local ed_name, ed_width, ed_height = RDXUI.GenNameWidthHeightPortion(ui, desc);

      -- Owner
      local owner = RDXUI.MakeSlotSelectorDropdown(ui, i18n("Owner"), state, "Subframe_", true);
      if desc and desc.owner then owner:SetSelection(desc.owner); end

      -- Drawlayer
      local er = RDXUI.EmbedRight(ui, i18n("Draw layer:"));
      local drawLayer = VFLUI.Dropdown:new(er, RDXUI.DrawLayerDropdownFunction);
      drawLayer:SetWidth(100); drawLayer:Show();
      if desc and desc.drawLayer then drawLayer:SetSelection(desc.drawLayer); else drawLayer:SetSelection("ARTWORK"); end
      er:EmbedChild(drawLayer); er:Show();
      ui:InsertFrame(er);

      -- Anchor
      local anchor = RDXUI.UnitFrameAnchorSelector:new(ui); anchor:Show();
      anchor:SetAFArray(RDXUI.ComposeFrameList(state));
      if desc and desc.anchor then anchor:SetAnchorInfo(desc.anchor); end
      ui:InsertFrame(anchor);
      
      function ui:GetDescriptor()
         local name = ed_name.editBox:GetText();
         return {
            feature = "Master Looter Icon", name = name, owner = owner:GetSelection();
            drawLayer = drawLayer:GetSelection();
           w = VFL.clamp(ed_width.editBox:GetNumber(), 0, 1000);
            h = VFL.clamp(ed_height.editBox:GetNumber(), 0, 1000);
            anchor = anchor:GetAnchorInfo();
         };
      end

      return ui;
   end;
   CreateDescriptor = function()
      return {
         feature = "Master Looter Icon", name = "mli", owner = "Base", drawLayer = "ARTWORK";
        w = 14; h = 14;
         anchor = { lp = "TOPLEFT", af = "Base", rp = "TOPLEFT", dx = 0, dy = 0};
      };
   end;
}); 

----------------------------------------------------------------------
-- An iconic representation if unit is leader (made by superraider)
----------------------------------------------------------------------
RDX.RegisterFeature({
   name = "Raid Leader Icon";
   category = i18n("Icon");
   IsPossible = function(state)
      if not state:Slot("UnitFrame") then return nil; end
      if not state:Slot("Base") then return nil; end
      return true;
   end;
   ExposeFeature = function(desc, state, errs)
      if not desc then VFL.AddError(errs, i18n("Missing descriptor.")); return nil; end
      local flg = true;
      flg = flg and __UFFrameCheck_Proto("Frame_", desc, state, errs);
      flg = flg and __UFAnchorCheck(desc.anchor, state, errs);
      flg = flg and __UFOwnerCheck(desc.owner, state, errs);
      if flg then state:AddSlot("Frame_" .. desc.name); end
      return flg;
   end;
   ApplyFeature = function(desc, state)
      local objname = "Frame_" .. desc.name;

      ------------------ On frame creation
      local createCode = [[
local _t = VFLUI.CreateTexture(]] .. RDXUI.ResolveFrameReference(desc.owner) .. [[);
frame.]] .. objname .. [[ = _t;
_t:SetDrawLayer("]] .. (desc.drawLayer or "ARTWORK") .. [[");
_t:SetPoint(]] .. RDXUI.AnchorCodeFromDescriptor(desc.anchor) .. [[);
_t:SetWidth(]] .. desc.w .. [[); _t:SetHeight(]] .. desc.h .. [[);
_t:SetVertexColor(1,1,1,1);
_t:SetTexture("Interface\\GroupFrame\\UI-Group-LeaderIcon");
_t:Hide();
]];
      state:Attach(state:Slot("EmitCreate"), true, function(code) code:AppendCode(createCode); end);

      ------------------ On frame destruction.
      state:Attach(state:Slot("EmitDestroy"), true, function(code) code:AppendCode([[
VFLUI.ReleaseRegion(frame.]] .. objname .. [[);
frame.]] .. objname .. [[ = nil;
]]); end);
      state:Attach(state:Slot("EmitCleanup"), true, function(code) code:AppendCode([[
frame.]] .. objname .. [[:Hide();
]]); end);

      ------------------ On paint.
      state:Attach(state:Slot("EmitPaint"), true, function(code) code:AppendCode([[
if UnitIsPartyLeader(uid) then
   frame.]] .. objname .. [[:Show();
else
   frame.]] .. objname .. [[:Hide();
end
]]); end);
      local mux = state:GetContainingWindowState():GetSlotValue("Multiplexer");
      mux:Event_MaskAll("PARTY_LOOT_METHOD_CHANGED", 2);
      return true;
   end;
   UIFromDescriptor = function(desc, parent, state)
      local ui = VFLUI.CompoundFrame:new(parent);

      -- Name/width/height
      local ed_name, ed_width, ed_height = RDXUI.GenNameWidthHeightPortion(ui, desc);

      -- Owner
      local owner = RDXUI.MakeSlotSelectorDropdown(ui, i18n("Owner"), state, "Subframe_", true);
      if desc and desc.owner then owner:SetSelection(desc.owner); end

      -- Drawlayer
      local er = RDXUI.EmbedRight(ui, i18n("Draw layer:"));
      local drawLayer = VFLUI.Dropdown:new(er, RDXUI.DrawLayerDropdownFunction);
      drawLayer:SetWidth(100); drawLayer:Show();
      if desc and desc.drawLayer then drawLayer:SetSelection(desc.drawLayer); else drawLayer:SetSelection("ARTWORK"); end
      er:EmbedChild(drawLayer); er:Show();
      ui:InsertFrame(er);

      -- Anchor
      local anchor = RDXUI.UnitFrameAnchorSelector:new(ui); anchor:Show();
      anchor:SetAFArray(RDXUI.ComposeFrameList(state));
      if desc and desc.anchor then anchor:SetAnchorInfo(desc.anchor); end
      ui:InsertFrame(anchor);
      
      function ui:GetDescriptor()
         local name = ed_name.editBox:GetText();
         return {
            feature = "Raid Leader Icon", name = name, owner = owner:GetSelection();
            drawLayer = drawLayer:GetSelection();
           w = VFL.clamp(ed_width.editBox:GetNumber(), 0, 1000);
            h = VFL.clamp(ed_height.editBox:GetNumber(), 0, 1000);
            anchor = anchor:GetAnchorInfo();
         };
      end

      return ui;
   end;
   CreateDescriptor = function()
      return {
         feature = "Raid Leader Icon", name = "rli", owner = "Base", drawLayer = "ARTWORK";
        w = 14; h = 14;
         anchor = { lp = "TOPLEFT", af = "Base", rp = "TOPLEFT", dx = 0, dy = 0};
      };
   end;
});

local pvpIcons = {
	["Horde"] = {0.08, 0.58, 0.045, 0.545},
	["Alliance"] = {0.07, 0.58, 0.06, 0.57},
	["FFA"] = {0.05, 0.605, 0.015, 0.57},
}

function VFLGetPVPIcon(cl)
	return pvpIcons[cl];
end

RDX.RegisterFeature({
	name = "tex_pvp";
	title = i18n("Faction Icon");
	category = i18n("Icon");
	IsPossible = function(state)
		if not state:Slot("UnitFrame") then return nil; end
		if not state:Slot("Base") then return nil; end
		return true;
	end;
	ExposeFeature = function(desc, state, errs)
		if not desc then VFL.AddError(errs, i18n("Missing descriptor.")); return nil; end
		local flg = true;
		flg = flg and __UFFrameCheck_Proto("Frame_", desc, state, errs);
		flg = flg and __UFAnchorCheck(desc.anchor, state, errs);
		flg = flg and __UFOwnerCheck(desc.owner, state, errs);
		if flg then state:AddSlot("Frame_" .. desc.name); end
		return flg;
	end;
	ApplyFeature = function(desc, state)
	local objname = "Frame_" .. desc.name;

		------------------ On frame creation
		local createCode = [[
local _t = VFLUI.CreateTexture(]] .. RDXUI.ResolveFrameReference(desc.owner) .. [[);
frame.]] .. objname .. [[ = _t;
_t:SetDrawLayer("]] .. (desc.drawLayer or "ARTWORK") .. [[");
_t:SetPoint(]] .. RDXUI.AnchorCodeFromDescriptor(desc.anchor) .. [[);
_t:SetWidth(]] .. desc.w .. [[); _t:SetHeight(]] .. desc.h .. [[);
_t:SetVertexColor(1,1,1,1);
_t:Show();
]];
		state:Attach(state:Slot("EmitCreate"), true, function(code) code:AppendCode(createCode); end);

		------------------ On frame destruction.
		state:Attach(state:Slot("EmitDestroy"), true, function(code) code:AppendCode([[
VFLUI.ReleaseRegion(frame.]] .. objname .. [[);
frame.]] .. objname .. [[ = nil;
]]); end);
		state:Attach(state:Slot("EmitCleanup"), true, function(code) code:AppendCode([[
frame.]] .. objname .. [[:Hide();
]]); end);

		------------------ On paint.
		state:Attach(state:Slot("EmitPaint"), true, function(code) code:AppendCode([[
local pvptype = false;
if UnitIsPVPFreeForAll(uid) then pvptype = "FFA";
else
	local faction = UnitFactionGroup(uid);
	if faction then pvptype = faction; end
end
if pvptype and UnitExists(uid) then
local pvpc = VFLGetPVPIcon(pvptype);
frame.]] .. objname .. [[:SetTexture("Interface\\TargetingFrame\\UI-PVP-" .. pvptype);
frame.]] .. objname .. [[:SetTexCoord(pvpc[1], pvpc[2], pvpc[3], pvpc[4]);
frame.]] .. objname .. [[:Show();
else
frame.]] .. objname .. [[:Hide();
end;
]]); end);
	local mux = state:GetContainingWindowState():GetSlotValue("Multiplexer");
	mux:Event_MaskAll("UNIT_FACTION", 2);
	return true;
	end;
	UIFromDescriptor = function(desc, parent, state)
		local ui = VFLUI.CompoundFrame:new(parent);

		-- Name/width/height
		local ed_name, ed_width, ed_height = RDXUI.GenNameWidthHeightPortion(ui, desc);

		-- Owner
		local owner = RDXUI.MakeSlotSelectorDropdown(ui, i18n("Owner"), state, "Subframe_", true);
		if desc and desc.owner then owner:SetSelection(desc.owner); end

		-- Drawlayer
		local er = RDXUI.EmbedRight(ui, i18n("Draw layer:"));
		local drawLayer = VFLUI.Dropdown:new(er, RDXUI.DrawLayerDropdownFunction);
		drawLayer:SetWidth(100); drawLayer:Show();
		if desc and desc.drawLayer then drawLayer:SetSelection(desc.drawLayer); else drawLayer:SetSelection("ARTWORK"); end
		er:EmbedChild(drawLayer); er:Show();
		ui:InsertFrame(er);

		-- Anchor
		local anchor = RDXUI.UnitFrameAnchorSelector:new(ui); anchor:Show();
		anchor:SetAFArray(RDXUI.ComposeFrameList(state));
		if desc and desc.anchor then anchor:SetAnchorInfo(desc.anchor); end
		ui:InsertFrame(anchor);
		
		function ui:GetDescriptor()
			local name = ed_name.editBox:GetText();
			return { 
				feature = "tex_pvp", name = name, owner = owner:GetSelection();
				drawLayer = drawLayer:GetSelection();
				w = VFL.clamp(ed_width.editBox:GetNumber(), 0, 1000);
				h = VFL.clamp(ed_height.editBox:GetNumber(), 0, 1000);
				anchor = anchor:GetAnchorInfo();
			};
		end

		return ui;
	end;
	CreateDescriptor = function()
		return { 
			feature = "tex_pvp", name = "faction", owner = "Base", drawLayer = "ARTWORK";
			w = 14; h = 14;
			anchor = { lp = "TOPLEFT", af = "Base", rp = "TOPLEFT", dx = 0, dy = 0};
		};
	end;
});

RDX.RegisterFeature({
	name = "tex_pvp2";
	title = i18n("PVP Icon");
	category = i18n("Icon");
	IsPossible = function(state)
		if not state:Slot("UnitFrame") then return nil; end
		if not state:Slot("Base") then return nil; end
		return true;
	end;
	ExposeFeature = function(desc, state, errs)
		if not desc then VFL.AddError(errs, i18n("Missing descriptor.")); return nil; end
		local flg = true;
		flg = flg and __UFFrameCheck_Proto("Frame_", desc, state, errs);
		flg = flg and __UFAnchorCheck(desc.anchor, state, errs);
		flg = flg and __UFOwnerCheck(desc.owner, state, errs);
		if flg then state:AddSlot("Frame_" .. desc.name); end
		return flg;
	end;
	ApplyFeature = function(desc, state)
	local objname = "Frame_" .. desc.name;

		------------------ On frame creation
		local createCode = [[
local _t = VFLUI.CreateTexture(]] .. RDXUI.ResolveFrameReference(desc.owner) .. [[);
frame.]] .. objname .. [[ = _t;
_t:SetDrawLayer("]] .. (desc.drawLayer or "ARTWORK") .. [[");
_t:SetPoint(]] .. RDXUI.AnchorCodeFromDescriptor(desc.anchor) .. [[);
_t:SetWidth(]] .. desc.w .. [[); _t:SetHeight(]] .. desc.h .. [[);
_t:SetVertexColor(1,1,1,1);
_t:Show();
]];
		state:Attach(state:Slot("EmitCreate"), true, function(code) code:AppendCode(createCode); end);

		------------------ On frame destruction.
		state:Attach(state:Slot("EmitDestroy"), true, function(code) code:AppendCode([[
VFLUI.ReleaseRegion(frame.]] .. objname .. [[);
frame.]] .. objname .. [[ = nil;
]]); end);
		state:Attach(state:Slot("EmitCleanup"), true, function(code) code:AppendCode([[
frame.]] .. objname .. [[:Hide();
]]); end);

		------------------ On paint.
		state:Attach(state:Slot("EmitPaint"), true, function(code) code:AppendCode([[
if UnitIsPVP(uid) and UnitExists(uid) then
local pvptype, pvpc = UnitFactionGroup(uid), nil;
if UnitIsPVPFreeForAll(uid) then pvptype = "FFA"; end
if pvptype then 
pvpc = VFLGetPVPIcon(pvptype);
frame.]] .. objname .. [[:SetTexture("Interface\\TargetingFrame\\UI-PVP-" .. pvptype);
frame.]] .. objname .. [[:SetTexCoord(pvpc[1], pvpc[2], pvpc[3], pvpc[4]);
frame.]] .. objname .. [[:Show();
else
frame.]] .. objname .. [[:Hide();
end
else
frame.]] .. objname .. [[:Hide();
end;
]]); end);
	local mux = state:GetContainingWindowState():GetSlotValue("Multiplexer");
	mux:Event_MaskAll("UNIT_FACTION", 2);
	return true;
	end;
	UIFromDescriptor = function(desc, parent, state)
		local ui = VFLUI.CompoundFrame:new(parent);

		-- Name/width/height
		local ed_name, ed_width, ed_height = RDXUI.GenNameWidthHeightPortion(ui, desc);

		-- Owner
		local owner = RDXUI.MakeSlotSelectorDropdown(ui, i18n("Owner"), state, "Subframe_", true);
		if desc and desc.owner then owner:SetSelection(desc.owner); end

		-- Drawlayer
		local er = RDXUI.EmbedRight(ui, i18n("Draw layer:"));
		local drawLayer = VFLUI.Dropdown:new(er, RDXUI.DrawLayerDropdownFunction);
		drawLayer:SetWidth(100); drawLayer:Show();
		if desc and desc.drawLayer then drawLayer:SetSelection(desc.drawLayer); else drawLayer:SetSelection("ARTWORK"); end
		er:EmbedChild(drawLayer); er:Show();
		ui:InsertFrame(er);

		-- Anchor
		local anchor = RDXUI.UnitFrameAnchorSelector:new(ui); anchor:Show();
		anchor:SetAFArray(RDXUI.ComposeFrameList(state));
		if desc and desc.anchor then anchor:SetAnchorInfo(desc.anchor); end
		ui:InsertFrame(anchor);
		
		function ui:GetDescriptor()
			local name = ed_name.editBox:GetText();
			return { 
				feature = "tex_pvp2", name = name, owner = owner:GetSelection();
				drawLayer = drawLayer:GetSelection();
				w = VFL.clamp(ed_width.editBox:GetNumber(), 0, 1000);
				h = VFL.clamp(ed_height.editBox:GetNumber(), 0, 1000);
				anchor = anchor:GetAnchorInfo();
			};
		end

		return ui;
	end;
	CreateDescriptor = function()
		return { 
			feature = "tex_pvp2", name = "pvp", owner = "Base", drawLayer = "ARTWORK";
			w = 14; h = 14;
			anchor = { lp = "TOPLEFT", af = "Base", rp = "TOPLEFT", dx = 0, dy = 0};
		};
	end;
});


-- by Aichi

RDX.RegisterFeature({
   name = "Ready Check Icon";
   category = i18n("Icon");
   IsPossible = function(state)
      if not state:Slot("UnitFrame") then return nil; end
      if not state:Slot("Base") then return nil; end
      return true;
   end;
   ExposeFeature = function(desc, state, errs)
      if not desc then VFL.AddError(errs, i18n("Missing descriptor.")); return nil; end
      local flg = true;
      flg = flg and __UFFrameCheck_Proto("Frame_", desc, state, errs);
      flg = flg and __UFAnchorCheck(desc.anchor, state, errs);
      flg = flg and __UFOwnerCheck(desc.owner, state, errs);
      if flg then state:AddSlot("Frame_" .. desc.name); end
      return flg;
   end;
   ApplyFeature = function(desc, state)
      local objname = "Frame_" .. desc.name;

      ------------------ On frame creation
      local createCode = [[
local _t = VFLUI.CreateTexture(]] .. RDXUI.ResolveFrameReference(desc.owner) .. [[);
frame.]] .. objname .. [[ = _t;
_t:SetDrawLayer("]] .. (desc.drawLayer or "ARTWORK") .. [[");
_t:SetPoint(]] .. RDXUI.AnchorCodeFromDescriptor(desc.anchor) .. [[);
_t:SetWidth(]] .. desc.w .. [[); _t:SetHeight(]] .. desc.h .. [[);
_t:SetVertexColor(1,1,1,1);
_t:SetTexture("Interface\\RAIDFRAME\\ReadyCheck-Waiting");
_t:Hide();
]];
      state:Attach(state:Slot("EmitCreate"), true, function(code) code:AppendCode(createCode); end);

      ------------------ On frame destruction.
      state:Attach(state:Slot("EmitDestroy"), true, function(code) code:AppendCode([[
VFLUI.ReleaseRegion(frame.]] .. objname .. [[);
frame.]] .. objname .. [[ = nil;
]]); end);
      state:Attach(state:Slot("EmitCleanup"), true, function(code) code:AppendCode([[
frame.]] .. objname .. [[:Hide();
]]); end);

      ------------------ On paint.
      state:Attach(state:Slot("EmitPaint"), true, function(code) code:AppendCode([[
local readyCheckStatus;
if IsRaidLeader() or IsRaidOfficer() or IsPartyLeader() then
    readyCheckStatus = GetReadyCheckStatus(uid);
end
if readyCheckStatus then
  if ( readyCheckStatus == "ready" ) then
     frame.]] .. objname .. [[:Show();
     frame.]] .. objname .. [[:SetTexture("Interface\\RAIDFRAME\\ReadyCheck-Ready");
  elseif ( readyCheckStatus == "notready" ) then
     frame.]] .. objname .. [[:Show();
     frame.]] .. objname .. [[:SetTexture("Interface\\RAIDFRAME\\ReadyCheck-NotReady");
  elseif ( readyCheckStatus == "waiting" ) then
     frame.]] .. objname .. [[:Show();
     frame.]] .. objname .. [[:SetTexture("Interface\\RAIDFRAME\\ReadyCheck-Waiting");
  end
else
    frame.]] .. objname .. [[:Hide();
end
]]); end);

      local mux = state:GetContainingWindowState():GetSlotValue("Multiplexer");
      mux:Event_MaskAll("READY_CHECK", 2);
      mux:Event_MaskAll("READY_CHECK_CONFIRM", 2);
      mux:Event_MaskAll("READY_CHECK_FINISHED", 2);
      return true;
   end;
   UIFromDescriptor = function(desc, parent, state)
      local ui = VFLUI.CompoundFrame:new(parent);

      -- Name/width/height
      local ed_name, ed_width, ed_height = RDXUI.GenNameWidthHeightPortion(ui, desc);

      -- Owner
      local owner = RDXUI.MakeSlotSelectorDropdown(ui, "Owner", state, "Subframe_", true);
      if desc and desc.owner then owner:SetSelection(desc.owner); end

      -- Drawlayer
      local er = RDXUI.EmbedRight(ui, "Draw layer:");
      local drawLayer = VFLUI.Dropdown:new(er, RDXUI.DrawLayerDropdownFunction);
      drawLayer:SetWidth(100); drawLayer:Show();
      if desc and desc.drawLayer then drawLayer:SetSelection(desc.drawLayer); else drawLayer:SetSelection("ARTWORK"); end
      er:EmbedChild(drawLayer); er:Show();
      ui:InsertFrame(er);

      -- Anchor
      local anchor = RDXUI.UnitFrameAnchorSelector:new(ui); anchor:Show();
      anchor:SetAFArray(RDXUI.ComposeFrameList(state));
      if desc and desc.anchor then anchor:SetAnchorInfo(desc.anchor); end
      ui:InsertFrame(anchor);
     
      function ui:GetDescriptor()
         local name = ed_name.editBox:GetText();
         return {
            feature = "Ready Check Icon", name = name, owner = owner:GetSelection();
            drawLayer = drawLayer:GetSelection();
           w = VFL.clamp(ed_width.editBox:GetNumber(), 0, 1000);
            h = VFL.clamp(ed_height.editBox:GetNumber(), 0, 1000);
            anchor = anchor:GetAnchorInfo();
         };
      end

      return ui;
   end;
   CreateDescriptor = function()
      return {
         feature = "Ready Check Icon", name = "rci", owner = "Base", drawLayer = "ARTWORK";
        w = 14; h = 14;
         anchor = { lp = "TOPLEFT", af = "Base", rp = "TOPLEFT", dx = 0, dy = 0};
      };
   end;
}); 
