-- AuraIcons.lua
-- RDX - Raid Data Exchange
-- (C)2006-2007 Raid Informatics
--
-- THIS FILE CONTAINS COPYRIGHTED MATERIAL SUBJECT TO THE TERMS OF A SEPARATE
-- LICENSE. UNLICENSED COPYING IS PROHIBITED.
--
-- Code for aura icons attached to unitframes.
--


function __SetAuraIcon(btn, meta, tex, apps, dur, tl, showTime, dispelType, bkd)
	btn:Show(); btn.meta = meta;
	btn.tex:SetTexture(tex);
	if bkd.edgeSize then
		if dispelType then
			btn:SetBackdropBorderColor(explodeColor(DebuffTypeColor[dispelType]));
		else
			btn:SetBackdropBorderColor(bkd.br, bkd.bg, bkd.bb, bkd.ba);
		end
	else
		if dispelType then
			btn:SetBackdropColor(explodeColor(DebuffTypeColor[dispelType]));
		else
			btn:SetBackdropColor(bkd.kr, bkd.kg, bkd.kb, bkd.ka);
		end
	end
	-- Cooldown
	if dur and dur > 0 then
		btn.cd:SetCooldown(GetTime() + tl - dur , dur);
	else
		btn.cd:SetCooldown(0, 0);
	end
	-- Text
	--if not showTime then
		if apps and (apps > 1) then btn.sttxt:SetText(apps); else btn.sttxt:SetText(""); end
	--end
	return true;
end

function __AuraIconOnEnter()
	if this.meta then RDX.ShowAuraTooltip(this.meta, this, "RIGHT"); end
end
function __AuraIconOnLeave()
	GameTooltip:Hide();
end
function __AuraIconOnClick()
	if this.meta then CancelPlayerBuff(this.meta.properName); end
end

--------------- Code emitter helpers
local function _EmitCreateCode(objname, desc)
	local nRows = VFL.clamp(desc.rows, 1, 40);
	if desc and (not desc.iconspx) then desc.iconspx = "0"; end
	if desc and (not desc.iconspy) then desc.iconspy = "0"; end
	if desc and (not desc.cdoffx) then desc.cdoffx = "0"; end
	if desc and (not desc.cdoffy) then desc.cdoffy = "0"; end
	local ty = '"Frame"'; if (not desc.ephemeral) then ty = '"Button"'; end
	local cdtext, cdgfx = "true", "false"; if desc.cooldownGfx then cdtext = "false"; cdgfx = "true"; end
	--local cdtext = "nil"; if desc.text == "TIME" then cdtext = "true"; end
	local bs, chkbd = 1, "false";
	if not desc.bkd then desc.bkd = {}; end
	if desc.bkd.edgeSize then bs = desc.bkd.edgeSize/3; chkbd = "true"; end
	local createCode = [[
frame.]] .. objname .. [[ = {};
local btn, btnOwner = nil, ]] .. RDXUI.ResolveFrameReference(desc.owner) .. [[;
for i=1,]] .. desc.nIcons .. [[ do
	btn = VFLUI.AcquireFrame(]] .. ty .. [[);
	btn:SetParent(btnOwner);
	btn:SetFrameLevel(btnOwner:GetFrameLevel());
	btn:SetWidth(]] .. desc.size .. [[); btn:SetHeight(]] .. desc.size .. [[);
	--if ]] .. chkbd .. [[ then btn:SetBackdrop(]] .. Serialize(desc.bkd) .. [[); else btn:SetBackdrop(VFLUI.WhiteBackdrop); end
	VFLUI.SetBackdrop(btn, ]] .. Serialize(desc.bkd) .. [[);
	btn.tex = VFLUI.CreateTexture(btn);
	btn.tex:SetPoint("TOPLEFT", btn, "TOPLEFT", ]] .. bs .. [[, -]] .. bs .. [[);
	btn.tex:SetPoint("BOTTOMRIGHT", btn, "BOTTOMRIGHT", -]] .. bs .. [[, ]] .. bs .. [[);
	btn.tex:SetTexCoord(0.08, 1-0.08, 0.08, 1-0.08);
	btn.tex:Show();
	btn.sttxt = VFLUI.CreateFontString(btn);
	btn.sttxt:SetAllPoints(btn.tex); 
	btn.sttxt:Show();
	btn.cd = RDXUI.CooldownCounter:new(btn, ]] .. cdtext .. ", " .. cdgfx .. [[, true, 0.3);
	btn.cd:SetPoint("TOPLEFT", btn.tex, "TOPLEFT", ]] .. desc.cdoffx .. [[, ]] .. desc.cdoffy .. [[);
	btn.cd:SetPoint("BOTTOMRIGHT", btn.tex, "BOTTOMRIGHT", ]] .. desc.cdoffx .. [[, ]] .. desc.cdoffy .. [[);
	btn.cd:Show();
]];
	createCode = createCode .. VFLUI.GenerateSetFontCode("btn.cd.fs", desc.font, nil, true);
	createCode = createCode .. VFLUI.GenerateSetFontCode("btn.sttxt", desc.fontst, nil, true);
	if (not desc.ephemeral) then createCode = createCode .. [[
	btn:SetScript("OnEnter", __AuraIconOnEnter);
	btn:SetScript("OnLeave", __AuraIconOnLeave);
	btn:RegisterForClicks("RightButtonUp");
	btn:SetScript("OnClick", __AuraIconOnClick);
]]; 
	end
createCode = createCode .. [[
	frame.]] .. objname .. [[[i] = btn;
end
frame.]] .. objname .. [[[1]:SetPoint(]] .. RDXUI.AnchorCodeFromDescriptor(desc.anchor) .. [[);
for i=2,]] .. desc.nIcons .. [[ do ]];
	local opri1, opri2, osec1, osec2, csx, csy, csxm, csym = '"RIGHT"', '"LEFT"', '"TOP"', '"BOTTOM"', -tonumber(desc.iconspx), 0, 0, -tonumber(desc.iconspy);
	if desc.orientation == "RIGHT" then
		opri1 = '"LEFT"'; opri2 = '"RIGHT"'; csx = tonumber(desc.iconspx); csy = 0;
	elseif desc.orientation == "DOWN" then
		opri1 = '"TOP"'; opri2 = '"BOTTOM"'; osec1 = '"LEFT"'; osec2 = '"RIGHT"'; csx = 0; csy = -tonumber(desc.iconspy); csxm = tonumber(desc.iconspx); csym = 0;
	elseif desc.orientation == "UP" then
		opri1 = '"BOTTOM"'; opri2 = '"TOP"'; osec1 = '"LEFT"'; osec2 = '"RIGHT"'; csx = 0; csy = tonumber(desc.iconspy); csxm = tonumber(desc.iconspx); csym = 0;
	end
	if nRows == 1 then 
		-- Single-row code
		createCode = createCode .. [[frame.]] .. objname .. [[[i]:SetPoint(]] .. opri1 .. [[, frame.]] .. objname .. [[[i-1], ]] .. opri2 .. [[, ]] .. csx .. [[, ]] .. csy .. [[);]];
	else 
		-- Multi-row code
		createCode = createCode .. [[
if( VFL.mmod ( i + ]] .. nRows .. [[-1,]] .. nRows .. [[)  == 0 ) then 
    frame.]] .. objname .. [[[i]:SetPoint(]] .. osec1 .. [[, frame.]] .. objname .. "[i-" .. nRows .. [[], ]] .. osec2 .. [[, ]] .. csxm .. [[, ]] .. csym .. [[);
else 
    frame.]] .. objname .. [[[i]:SetPoint(]] .. opri1 .. [[, frame.]] .. objname .. "[i-1], " .. opri2 .. [[, ]] .. csx .. [[, ]] .. csy .. [[);
end
]];
	end
	createCode = createCode .. [[
end
]];
	return createCode;
end


local _orientations = {
	{ text = "LEFT"},
	{ text = "RIGHT"},
	{ text = "DOWN"},
	{ text = "UP"},
};
local function _dd_orientations() return _orientations; end
local _types = {
	{ text = "BUFFS" },
	{ text = "DEBUFFS" },
};
local function _dd_types() return _types; end

-----------------------------
-- AURA ICONS
-----------------------------
RDX.RegisterFeature({
	name = "aura_icons"; version = 1; title = i18n("Aura Icons"); category = i18n("Buffs/Debuffs");
	multiple = true;
	IsPossible = function(state)
		if not state:Slot("UnitFrame") then return nil; end
		if not state:Slot("Base") then return nil; end
		return true;
	end;
	ExposeFeature = function(desc, state, errs)
		local flg = true;
		if not desc then VFL.AddError(errs, i18n("No descriptor")); return nil; end
		if not __UFOwnerCheck(desc.owner, state, errs) then return nil; end
		if not desc.auraType then VFL.AddError(errs, i18n("Bad aura type")); return nil; end
		if desc.name and (not state:Slot("Frame_" .. desc.name)) then
			state:AddSlot("Frame_" .. desc.name);
		else
			flg = nil; VFL.AddError(errs, i18n("Missing or duplicate object name."));
		end
		return flg;
	end;
	ApplyFeature = function(desc, state)
		local objname = "Frame_" .. desc.name;
		local loadCode = "RDX.LoadBuffFromUnit";

		-- Event hinting.
		local mux, mask = state:GetContainingWindowState():GetSlotValue("Multiplexer"), 0;
		if desc.auraType == "DEBUFFS" then
			mask = mux:GetPaintMask("DEBUFFS");
			mux:Event_UnitMask("UNIT_DEBUFF_*", mask);
			loadCode = "RDX.LoadDebuffFromUnit";
		else
			mask = mux:GetPaintMask("BUFFS");
			mux:Event_UnitMask("UNIT_BUFF_*", mask);
		end
		mask = bit.bor(mask, 1);

		-- If there's an external filter, add a quick menu to the window to edit it.
		if desc.externalNameFilter then
			local path = desc.externalNameFilter; local afname = desc.name;
			state:GetContainingWindowState():Attach("Menu", true, function(win, mnu)
				table.insert(mnu, {
					text = i18n("Edit AuraFilter: ") .. afname;
					OnClick = function()
						VFL.poptree:Release();
						RDXDB.OpenObject(path, "Edit");
					end;
				});
			end);
		end

		------------ Closure (name filter array)
		if desc.filterName then
			local closureCode = [[
local ]] .. objname .. [[_fnames = ]];
			if desc.externalNameFilter then
				closureCode = closureCode .. [[RDXDB.GetObjectInstance(]] .. string.format("%q", desc.externalNameFilter) .. [[);
]];
			else
				-- Internal filter
				closureCode = closureCode .. [[{};
]];
				for _,name in pairs(desc.filterNameList) do
					closureCode = closureCode .. objname .. "_fnames[" .. string.format("%q", name) .. "] = true; ";
				end
			end
			state:Attach("EmitClosure", true, function(code) code:AppendCode(closureCode); end);
		end

		----------------- Creation
		local createCode = _EmitCreateCode(objname, desc);
		state:Attach("EmitCreate", true, function(code) code:AppendCode(createCode); end);

		------------------- Destruction
		local destroyCode = [[
local btn = nil;
for i=1,]] .. desc.nIcons .. [[ do
	btn = frame.]] .. objname .. [[[i]
	btn.meta = nil;
	VFLUI.ReleaseRegion(btn.tex); btn.tex = nil;
	VFLUI.ReleaseRegion(btn.sttxt); btn.sttxt = nil;
	btn.cd:Destroy(); btn.cd = nil;
	btn:Destroy();
end
frame.]] .. objname .. [[ = nil;
]];
		state:Attach("EmitDestroy", true, function(code) code:AppendCode(destroyCode); end);

		------------------- Paint
		local engselftimer = "false"; if desc.selftimer then engselftimer = "true"; end
		local engauratimer = "false"; if desc.auratimer then engauratimer = "true"; end
		local raidfilter = "nil"; if desc.raidfilter then raidfilter = "true"; end
		local myaurasfilter = "true"; if desc.myaurasfilter then myaurasfilter = "mycast"; end
		local timefilter = "true"; if desc.timefilter then timefilter = "(_dur and _dur > 0)"; end
		local namefilter = "true";
		if desc.filterName == "include" then
			namefilter = "(" .. objname .. "_fnames[_bn] or " .. objname .. "_fnames[_meta.category])";
		elseif desc.filterName == "exclude" then
			namefilter = "(not (" .. objname .. "_fnames[_bn] or " .. objname .. "_fnames[_meta.category]))"
		end
		local showTime = "nil"; if desc.text == "TIME" then showTime = "true"; end

		local paintCode = [[
if band(paintmask, ]] .. mask .. [[) ~= 0 then
	local _i,_j,_bn,_tex,_apps,_meta,_dur,_tl,_dispelt,mycast,who=1,1,nil,nil,nil,nil,nil,nil,nil,nil;
	local _icons = frame.]] .. objname .. [[;
	while true do
		if (_j > ]] .. desc.nIcons .. [[) then break; end
		_, _bn, _, _apps, _, _tex, _meta, _dur, _tl, _dispelt, mycast, who = ]] .. loadCode .. [[(uid, _i, ]] .. raidfilter .. [[, ]] .. engselftimer .. [[, ]] .. engauratimer .. [[);
		if not _meta then break; end
		if (not _meta.isInvisible) and ]] .. myaurasfilter .. [[ and ]] .. timefilter .. [[ and ]] .. namefilter .. [[ then
			__SetAuraIcon(_icons[_j], _meta, _tex, _apps, _dur, _tl, ]] .. showTime .. [[, _dispelt, ]] .. Serialize(desc.bkd) .. [[);
			_j = _j + 1;
		end
		_i = _i + 1;
	end
	while _j <= ]] .. desc.nIcons .. [[ do
		_icons[_j]:Hide(); _j = _j + 1;
	end
end
]];
		state:Attach("EmitPaint", true, function(code) code:AppendCode(paintCode); end);
		------------------- Cleanup
		local cleanupCode = [[
local btn = nil;
for i=1,]] .. desc.nIcons .. [[ do
	btn = frame.]] .. objname .. [[[i];
	btn:Hide(); btn.meta = nil;
end
]];
		state:Attach("EmitCleanup", true, function(code) code:AppendCode(cleanupCode); end);


		return true;
	end;
	UIFromDescriptor = function(desc, parent, state)
		local ui = VFLUI.CompoundFrame:new(parent);

		------------- Core
		ui:InsertFrame(VFLUI.Separator:new(ui, i18n("Core Parameters")));

		local ed_name = VFLUI.LabeledEdit:new(ui, 100); ed_name:Show();
		ed_name:SetText(i18n("Name"));
		ed_name.editBox:SetText(desc.name);
		ui:InsertFrame(ed_name);

		local er = RDXUI.EmbedRight(ui, i18n("Aura Type:"));
		local dd_auraType = VFLUI.Dropdown:new(er, _dd_types);
		dd_auraType:SetWidth(75); dd_auraType:Show();
		if desc and desc.auraType then 
			dd_auraType:SetSelection(desc.auraType); 
		else
			dd_auraType:SetSelection("BUFFS");
		end
		er:EmbedChild(dd_auraType); er:Show();
		ui:InsertFrame(er);

		------------- Layout
		ui:InsertFrame(VFLUI.Separator:new(ui, i18n("Layout")));

		local owner = RDXUI.MakeSlotSelectorDropdown(ui, "Owner", state, "Subframe_", true);
		if desc and desc.owner then owner:SetSelection(desc.owner); end

		local anchor = RDXUI.UnitFrameAnchorSelector:new(ui); anchor:Show();
		anchor:SetAFArray(RDXUI.ComposeFrameList(state));
		if desc and desc.anchor then anchor:SetAnchorInfo(desc.anchor); end
		ui:InsertFrame(anchor);

		local ed_width = VFLUI.LabeledEdit:new(ui, 50); ed_width:Show();
		ed_width:SetText(i18n("Max icons"));
		if desc and desc.nIcons then ed_width.editBox:SetText(desc.nIcons); end
		ui:InsertFrame(ed_width);

		local ed_rows = VFLUI.LabeledEdit:new(ui, 50); ed_rows:Show();
		ed_rows:SetText(i18n("Row size"));
		if desc and desc.rows then ed_rows.editBox:SetText(desc.rows); end
		ui:InsertFrame(ed_rows);

		local er = RDXUI.EmbedRight(ui, i18n("Orientation:"));
		local dd_orientation = VFLUI.Dropdown:new(er, _dd_orientations);
		dd_orientation:SetWidth(75); dd_orientation:Show();
		if desc and desc.orientation then 
			dd_orientation:SetSelection(desc.orientation); 
		else
			dd_orientation:SetSelection("RIGHT");
		end
		er:EmbedChild(dd_orientation); er:Show();
		ui:InsertFrame(er);
		
		local ed_iconspx = VFLUI.LabeledEdit:new(ui, 50); ed_iconspx:Show();
		ed_iconspx:SetText(i18n("Icons spacing width"));
		if desc and desc.iconspx then ed_iconspx.editBox:SetText(desc.iconspx); else ed_iconspx.editBox:SetText("0"); end
		ui:InsertFrame(ed_iconspx);
		
		local ed_iconspy = VFLUI.LabeledEdit:new(ui, 50); ed_iconspy:Show();
		ed_iconspy:SetText(i18n("Icons spacing height"));
		if desc and desc.iconspy then ed_iconspy.editBox:SetText(desc.iconspy); else ed_iconspy.editBox:SetText("0"); end
		ui:InsertFrame(ed_iconspy);
		
		local ed_size = VFLUI.LabeledEdit:new(ui, 50); ed_size:Show();
		ed_size:SetText(i18n("Icon Size"));
		if desc and desc.size then ed_size.editBox:SetText(desc.size); end
		ui:InsertFrame(ed_size);

		-------------- Display
		ui:InsertFrame(VFLUI.Separator:new(ui, i18n("Display")));
		
		local er_st = RDXUI.EmbedRight(ui, i18n("Font stack"));
		local fontsel2 = VFLUI.MakeFontSelectButton(er_st, desc.fontst); fontsel2:Show();
		er_st:EmbedChild(fontsel2); er_st:Show();
		ui:InsertFrame(er_st);

		local chk_cooldownGfx = VFLUI.Checkbox:new(ui); chk_cooldownGfx:Show();
		chk_cooldownGfx:SetText(i18n("Show timer graphic"));
		if desc and desc.cooldownGfx then chk_cooldownGfx:SetChecked(true); else chk_cooldownGfx:SetChecked(); end
		ui:InsertFrame(chk_cooldownGfx);
		
		local er = RDXUI.EmbedRight(ui, i18n("Font timer"));
		local fontsel = VFLUI.MakeFontSelectButton(er, desc.font); fontsel:Show();
		er:EmbedChild(fontsel); er:Show();
		ui:InsertFrame(er);
		
		local rg_cdoffx = VFLUI.LabeledEdit:new(ui, 50); rg_cdoffx:Show();
		rg_cdoffx:SetText(i18n("Frame timer Offset X"));
		if desc and desc.cdoffx then rg_cdoffx.editBox:SetText(desc.cdoffx); else rg_cdoffx.editBox:SetText("0"); end
		ui:InsertFrame(rg_cdoffx);
		
		local rg_cdoffy = VFLUI.LabeledEdit:new(ui, 50); rg_cdoffy:Show();
		rg_cdoffy:SetText(i18n("Frame timer Offset Y"));
		if desc and desc.cdoffy then rg_cdoffy.editBox:SetText(desc.cdoffy); else rg_cdoffy.editBox:SetText("0"); end
		ui:InsertFrame(rg_cdoffy);
		
		local er2 = RDXUI.EmbedRight(ui, i18n("Backdrop style"));
		local bkd = VFLUI.MakeBackdropSelectButton(er2, desc.bkd); bkd:Show();
		er2:EmbedChild(bkd); er2:Show();
		ui:InsertFrame(er2);
		
		local chk_ephemeral = VFLUI.Checkbox:new(ui); chk_ephemeral:Show();
		chk_ephemeral:SetText(i18n("No tooltips on mouseover / No drop on click"));
		if desc and desc.ephemeral then chk_ephemeral:SetChecked(true); else chk_ephemeral:SetChecked(); end
		ui:InsertFrame(chk_ephemeral);
		
		-------------- Timer
		ui:InsertFrame(VFLUI.Separator:new(ui, i18n("Timer")));
		
		local eng_selftimer = VFLUI.Checkbox:new(ui); eng_selftimer:Show();
		eng_selftimer:SetText(i18n("Use GetPlayerBuffName"));
		if desc and desc.selftimer then eng_selftimer:SetChecked(true); else eng_selftimer:SetChecked(); end
		ui:InsertFrame(eng_selftimer);
		
		local eng_auratimer = VFLUI.Checkbox:new(ui); eng_auratimer:Show();
		eng_auratimer:SetText(i18n("Use Aura Timer Engine"));
		if desc and desc.auratimer then eng_auratimer:SetChecked(true); else eng_auratimer:SetChecked(); end
		ui:InsertFrame(eng_auratimer);

		------------ Filter
		ui:InsertFrame(VFLUI.Separator:new(ui, i18n("Filtering")));

		local chk_raidfilter = VFLUI.Checkbox:new(ui); chk_raidfilter:Show();
		chk_raidfilter:SetText(i18n("Use Blizzard raid filter"));
		if desc and desc.raidfilter then chk_raidfilter:SetChecked(true); else chk_raidfilter:SetChecked(); end
		ui:InsertFrame(chk_raidfilter);
		
		local chk_myauras = VFLUI.Checkbox:new(ui); chk_myauras:Show();
		chk_myauras:SetText(i18n("Show only my auras cast"));
		if desc and desc.myaurasfilter then chk_myauras:SetChecked(true); else chk_myauras:SetChecked(); end
		ui:InsertFrame(chk_myauras);

		local chk_timefilter = VFLUI.Checkbox:new(ui); chk_timefilter:Show();
		chk_timefilter:SetText(i18n("Show only auras for which timers are known"));
		if desc and desc.timefilter then chk_timefilter:SetChecked(true); else chk_timefilter:SetChecked(); end
		ui:InsertFrame(chk_timefilter);

		local chk_filterName = VFLUI.Checkbox:new(ui); chk_filterName:Show();
		chk_filterName:SetText(i18n("Filter by aura name"));
		if desc and desc.filterName then chk_filterName:SetChecked(true); else chk_filterName:SetChecked(); end
		ui:InsertFrame(chk_filterName);

		local rg_ie = VFLUI.RadioGroup:new(ui); rg_ie:Show();
		rg_ie:SetLayout(2,2);
		rg_ie.buttons[1]:SetText(i18n("Include")); rg_ie.buttons[2]:SetText(i18n("Exclude"));
		if desc and desc.filterName == "include" then
			rg_ie:SetValue(1);
		elseif desc and desc.filterName == "exclude" then
			rg_ie:SetValue(2);
		end
		ui:InsertFrame(rg_ie);

		local chk_external = RDXUI.CheckEmbedRight(ui, i18n("Use external aura list"));
		local file_external = RDXDB.ObjectFinder:new(chk_external, function(p,f,md) return (md and md.ty and string.find(md.ty, "AuraFilter$")); end);
		file_external:SetWidth(200); file_external:Show();
		chk_external:EmbedChild(file_external); chk_external:Show();
		ui:InsertFrame(chk_external);
		if desc.externalNameFilter then
			chk_external:SetChecked(true); file_external:SetPath(desc.externalNameFilter);
		else
			chk_external:SetChecked();
		end

		local le_names = VFLUI.ListEditor:new(ui, desc.filterNameList or {}, function(cell,data) cell.text:SetText(data); end);
		le_names:SetHeight(183); le_names:Show();
		ui:InsertFrame(le_names);
		
		function ui:GetDescriptor()
			local filterName, filterNameList, ext = nil, nil, nil;
			if chk_filterName:GetChecked() then
				filterName = "include";
				if rg_ie:GetValue() == 2 then filterName = "exclude"; end
				filterNameList = le_names:GetList();
				for k,v in pairs(filterNameList) do filterNameList[k] = string.lower(v); end
				if chk_external:GetChecked() then	ext = file_external:GetPath(); end
			end
			return { 
				feature = "aura_icons"; version = 1;
				name = ed_name.editBox:GetText();
				auraType = dd_auraType:GetSelection();
				owner = owner:GetSelection();
				anchor = anchor:GetAnchorInfo();
				nIcons = VFL.clamp(ed_width.editBox:GetNumber(), 1, 40);
				rows = VFL.clamp(ed_rows.editBox:GetNumber(), 1, 40);
				orientation = dd_orientation:GetSelection();
				iconspx = VFL.clamp(ed_iconspx.editBox:GetNumber(), 0, 200);
				iconspy = VFL.clamp(ed_iconspy.editBox:GetNumber(), 0, 200);
				size = VFL.clamp(ed_size.editBox:GetNumber(), 1, 50);
				fontst = fontsel2:GetSelectedFont();
				font = fontsel:GetSelectedFont();
				bkd = bkd:GetSelectedBackdrop();
				selftimer = eng_selftimer:GetChecked();
				auratimer = eng_auratimer:GetChecked();
				cooldownGfx = chk_cooldownGfx:GetChecked();
				cdoffx = VFL.clamp(rg_cdoffx.editBox:GetNumber(), -50, 50);
				cdoffy = VFL.clamp(rg_cdoffy.editBox:GetNumber(), -50, 50);
				ephemeral = chk_ephemeral:GetChecked();
				raidfilter = chk_raidfilter:GetChecked();
				myaurasfilter = chk_myauras:GetChecked();
				timefilter = chk_timefilter:GetChecked();
				filterName = filterName;
				externalNameFilter = ext;
				filterNameList = filterNameList;
			};
		end

		return ui;
	end;
	CreateDescriptor = function()
		local font = VFL.copy(Fonts.Default); font.size = 8;
		return { 
			feature = "aura_icons"; version = 1;
			name = "ai1"; auraType = "BUFFS";
			owner = "Base";
			anchor = { lp = "LEFT", af = "Base", rp = "RIGHT", dx = 4, dy = 0};
			nIcons = 4; size = 12; rows = 1; orientation = "RIGHT"; iconspx = 0; iconspy = 0;
			font = font; text = "STACK"; cooldownGfx = true; cdoffx = 0; cdoffy = 0;
			bkd = VFL.copy(VFLUI.defaultBackdrop);
		};
	end;
});

-----------------------------------
-- The AuraFilter object type.
-----------------------------------
local dlg = nil;

local function WriteFilter(dest, src)
	VFL.empty(dest);
	for _,v in ipairs(src) do
		if type(v) == "string" then
			dest[string.lower(v)] = true; 
		end
	end
end

RDXDB.WriteFilter = WriteFilter;

RDXDB.RegisterObjectType({
	name = "AuraFilter";
	New = function(path, md)
		md.version = 1;
	end;
	Edit = function(path, md, parent)
		if dlg then return; end
		if (not path) or (not md) or (not md.data) then return nil; end
		local inst = RDXDB.GetObjectInstance(path, true);

		dlg = VFLUI.Window:new(parent or VFLHigh);
		VFLUI.Window.SetDefaultFraming(dlg, 22);
		dlg:SetTitleColor(0,0,.6);
		dlg:SetBackdrop(VFLUI.BlackDialogBackdrop);
		dlg:SetPoint("CENTER", UIParent, "CENTER");
		dlg:SetWidth(310); dlg:SetHeight(270);
		dlg:SetText(i18n("Edit AuraFilter: ") .. path);
		VFLUI.Window.StdMove(dlg, dlg:GetTitleBar());
		dlg:Show();

		local le_names = VFLUI.ListEditor:new(dlg, md.data, function(cell,data) cell.text:SetText(data); end);
		le_names:SetPoint("TOPLEFT", dlg:GetClientArea(), "TOPLEFT");
		le_names:SetWidth(300);	le_names:SetHeight(183); le_names:Show();

		local esch = function() dlg:Destroy(); end
		VFL.AddEscapeHandler(esch);
		local btnClose = VFLUI.CloseButton:new(dlg);
		dlg:AddButton(btnClose);
		btnClose:SetScript("OnClick", function() VFL.EscapeTo(esch); end);

		local btnOK = VFLUI.OKButton:new(dlg);
		btnOK:SetText(i18n("OK")); btnOK:SetHeight(25); btnOK:SetWidth(75);
		btnOK:SetPoint("BOTTOMRIGHT", dlg:GetClientArea(), "BOTTOMRIGHT");
		btnOK:Show();
		btnOK:SetScript("OnClick", function()
			local desc = le_names:GetList();
			if desc then
				md.data = desc;
				if inst then WriteFilter(inst, desc); end
			end
			VFL.EscapeTo(esch);
		end);

		dlg.Destroy = VFL.hook(function(s)
			btnOK:Destroy(); btnOK = nil;
			le_names:Destroy(); le_names = nil;
			dlg = nil;
		end, dlg.Destroy);
	end;
	Instantiate = function(path, md)
		if type(md.data) ~= "table" then return nil; end
		local inst = {};
		WriteFilter(inst, md.data);
		return inst;
	end;
	GenerateBrowserMenu = function(mnu, path, md, dlg)
		table.insert(mnu, {
			text = i18n("Edit..."),
			OnClick = function()
				VFL.poptree:Release();
				RDXDB.OpenObject(path, "Edit", dlg);
			end
		});
	end;
});

-----------------------------------
-- Updaters for old stuff.
-----------------------------------
RDX.RegisterFeature({
	name = "Buff Icons"; version = 31337; invisible = true;
	IsPossible = VFL.Nil;
	VersionMismatch = function(desc)
		local font = VFL.copy(Fonts.Default); font.size = 8;
		desc.feature = "aura_icons"; desc.version = 1; desc.auraType = "BUFFS";
		desc.owner = "Base";
		desc.color = nil; desc.font = font; desc.text = "STACK";
	end;
});

RDX.RegisterFeature({
	name = "Debuff Icons"; version = 31337; invisible = true;
	IsPossible = VFL.Nil;
	VersionMismatch = function(desc)
		local font = VFL.copy(Fonts.Default); font.size = 8;
		desc.feature = "aura_icons"; desc.version = 1; desc.auraType = "DEBUFFS";
		desc.owner = "Base";
		desc.color = nil; desc.font = font; desc.text = "STACK";
	end;
});


