-- Orphanage.lua
-- RDX - Raid Data Exchange
-- (C)2007 Raid Informatics
--
-- THIS FILE CONTAINS COPYRIGHTED CONTENT SUBJECT TO THE TERMS OF A SEPARATE
-- LICENSE. UNLICENSED COPYING IS PROHIBITED.
--
-- Stuff that doesn't have a home anywhere else.

-----------------------------------------
-- Code/option to hide all the blizzard default unitframes.
-----------------------------------------

local function HideBlizzardUnitframes()
	-- Hide player frame
	PlayerFrame:UnregisterAllEvents();
	PlayerFrameHealthBar:UnregisterAllEvents();
	PlayerFrameManaBar:UnregisterAllEvents();
	PlayerFrame:Hide();

	-- Hide target frame
	TargetFrame:UnregisterAllEvents();
	TargetFrame:Hide();
	ComboFrame:UnregisterAllEvents();
	ComboFrame:Hide();

	-- Hide party frames
	RaidOptionsFrame_UpdatePartyFrames = function() end;
	for i=1,4 do
		local x = getglobal("PartyMemberFrame" .. i);
		x:UnregisterAllEvents(); 
		x:Hide();
		x.Show = function() end
	end
end

RDX.systemMenu:RegisterMenuFunction(function(ent)
	if RDXU.noBUF then
		ent.text = i18n("Blizzard Unitframes |cFFFF0000[OFF]|r"); 
		ent.OnClick = function() RDXU.noBUF = nil; VFL.poptree:Release(); ReloadUI(); end;
	else
		ent.text = i18n("Blizzard Unitframes |cFF00FF00[ON]|r");
		ent.OnClick = function() RDXU.noBUF = true; VFL.poptree:Release(); HideBlizzardUnitframes(); end;
	end
end);

RDXEvents:Bind("INIT_VARIABLES_LOADED", nil, function()
	if RDXU.noBUF then HideBlizzardUnitframes(); end
end);

-----------------------------------------
-- Code/option to hide the blizzard auraframes by sigg
-----------------------------------------

local function HideBlizzardAuraFrame()
	BuffFrame:Hide()
	TemporaryEnchantFrame:Hide()
	BuffFrame:UnregisterAllEvents()
end

RDX.systemMenu:RegisterMenuFunction(function(ent)
	if RDXU.noBAF then
		ent.text = i18n("Blizzard Auraframes |cFFFF0000[OFF]|r"); 
		ent.OnClick = function() RDXU.noBAF = nil; VFL.poptree:Release(); ReloadUI(); end;
	else
		ent.text = i18n("Blizzard Auraframes |cFF00FF00[ON]|r");
		ent.OnClick = function() RDXU.noBAF = true; VFL.poptree:Release(); HideBlizzardAuraFrame(); end;
	end
end);

RDXEvents:Bind("INIT_VARIABLES_LOADED", nil, function()
	if RDXU.noBAF then HideBlizzardAuraFrame(); end
end);

-----------------------------------------
-- Code/option to hide the blizzard castbar
-----------------------------------------
local function HideBlizzardCastBar()
	CastingBarFrame:UnregisterAllEvents();
end

RDX.systemMenu:RegisterMenuFunction(function(ent)
	if RDXU.noBCB then
		ent.text = i18n("Blizzard Cast Bar |cFFFF0000[OFF]|r"); 
		ent.OnClick = function() RDXU.noBCB = nil; VFL.poptree:Release(); ReloadUI(); end;
	else
		ent.text = i18n("Blizzard Cast Bar |cFF00FF00[ON]|r");
		ent.OnClick = function() RDXU.noBCB = true; VFL.poptree:Release(); HideBlizzardCastBar(); end;
	end
end);

RDXEvents:Bind("INIT_VARIABLES_LOADED", nil, function()
	if RDXU.noBCB then HideBlizzardCastBar(); end
end);

