-- omniscience
-- OpenRDX
-- (C)2007 Sigg / Rashgarroth eu

-- this file contains the ndata for damage meter, thread for the UnitDB.

local sig_unit_omnisc = RDXEvents:LockSignal("UNIT_OMNISC");
local sig_unit_omnisct = RDXEvents:LockSignal("UNIT_OMNIT");
local sig_unit_omniscf = RDXEvents:LockSignal("UNIT_OMNIF");

----------------------------------------------------------
-- UNIT API MODS
----------------------------------------------------------

local ttdone_max, tfdone_max, ddone_max, hdone_max, dtaken_max, htaken_max, ohdone_max = 1, 1, 1, 1, 1, 1, 1;
local ttdone_total, tfdone_total, ddone_total, hdone_total, dtaken_total, htaken_total, ohdone_total = 0, 0, 0, 0, 0, 0, 0;

RDX.Unit.OmniGetInfo = function()
	return 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0;
end

RDX.Unit.OmniGetThread = function()
	return 0, 0, 1, 1, 0, 0;
end

-- TTDone Thread target done
-- TFDone Thread focus done
-- DDone  Damage done
-- HDone  Healing done
-- DTaken Damage taken
-- HTaken Healing taken
-- OHDone OverHealing done

RDX.Unit.OmniResetInfo = VFL.Zero;
RDX.Unit.OmniTTDone = VFL.Zero;
RDX.Unit.OmniTFDone = VFL.Zero;
RDX.Unit.OmniDDone = VFL.Zero;
RDX.Unit.OmniHDone = VFL.Zero;
RDX.Unit.OmniDTaken = VFL.Zero;
RDX.Unit.OmniHTaken = VFL.Zero;
RDX.Unit.OmniOHDone = VFL.Zero;

-- EDATA extension data for a unit by id
RDXEvents:Bind("EDATA_CREATED", nil, function(edata, idx)
	
	local t = {};
	t.ttdone = 0;
	t.tfdone = 0;
	t.ddone = 0;
	t.hdone = 0;
	t.dtaken = 0;
	t.htaken = 0;
	t.ohdone = 0;
	
	edata.OmniGetInfo = function()
		return t.ddone, t.hdone, t.dtaken, t.htaken, t.ohdone, ddone_max, hdone_max, dtaken_max, htaken_max, ohdone_max, ddone_total, hdone_total, dtaken_total, htaken_total, ohdone_total;
	end;
	
	edata.OmniGetThread = function()
		return t.ttdone, t.tfdone, ttdone_max, tfdone_max, ttdone_total, tfdone_total;
	end;
	
	edata.OmniResetInfo = function()
		t.ddone = 0; 
		t.hdone = 0; 
		t.dtaken = 0; 
		t.htaken = 0;
		t.ohdone = 0;
	end;
	
	edata.OmniResetThreadT = function()
		t.ttdone = 0; 
	end;
	
	edata.OmniResetThreadF = function()
		t.tfdone = 0; 
	end;
	
	edata.OmniTTDone = function()
		return t.ttdone;
	end;
	edata.OmniTFDone = function()
		return t.tfdone;
	end;
	edata.OmniDDone = function()
		return t.ddone;
	end;
	edata.OmniHDone = function()
		return t.hdone;
	end
	edata.OmniDTaken = function()
		return t.dtaken;
	end
	edata.OmniHTaken = function()
		return t.htaken;
	end
	edata.OmniOHDone = function()
		return t.ohdone;
	end
	
	edata.OmniSetTTDone = function(am)
		t.ttdone = am;
	end;
	edata.OmniSetTFDone = function(am)
		t.tfdone = am;
	end;
	
	edata.OmniSetDDone = function(am)
		t.ddone = am;
	end;
	edata.OmniSetHDone = function(am)
		t.hdone = am;
	end
	edata.OmniSetDTaken = function(am)
		t.dtaken = am;
	end
	edata.OmniSetHTaken = function(am)
		t.htaken = am;
	end
	edata.OmniSetOHDone = function(am)
		t.ohdone = am;
	end
	
	edata:SetEField("omniscience", t);
end);

-----------------------------------------------------
-- damagemeter
-----------------------------------------------------

-- function uploadDamagefromOmniDB and aggregate data
local function uploadInfofromOmniDB()
	local tmpddone_total, tmphdone_total, tmpdtaken_total, tmphtaken_total, tmpohdone_total = 0, 0, 0, 0, 0;
	local tmpddone_max, tmphdone_max, tmpdtaken_max, tmphtaken_max, tmpohdone_max = 1, 1, 1, 1, 1;
	local omniddone, omnihdone, omnidtaken, omnihtaken, omniohdone = 0, 0, 0, 0, 0;
	for _,unit in RDX.RaidAll() do
		if UnitExists(unit.uid) then
			omnidtaken, omniddone, omnihdone, omnihtaken, omniohdone = OmniDB.GetGUIDInfo(unit.guid, unit.name);
			tmpddone_total = tmpddone_total + omniddone;
			tmphdone_total = tmphdone_total + omnihdone;
			tmpdtaken_total = tmpdtaken_total + omnidtaken;
			tmphtaken_total = tmphtaken_total + omnihtaken;
			tmpohdone_total = tmpohdone_total + omniohdone;
			if (omniddone > tmpddone_max) then tmpddone_max = omniddone; end
			if (omnihdone > tmphdone_max) then tmphdone_max = omnihdone; end
			if (omnidtaken > tmpdtaken_max) then tmpdtaken_max = omnidtaken; end
			if (omnihtaken > tmphtaken_max) then tmphtaken_max = omnihtaken; end
			if (omniohdone > tmpohdone_max) then tmpohdone_max = omniohdone; end
			unit.OmniSetDDone(omniddone);
			unit.OmniSetHDone(omnihdone);
			unit.OmniSetDTaken(omnidtaken);
			unit.OmniSetHTaken(omnihtaken);
			unit.OmniSetOHDone(omniohdone);
		end
	end
	ddone_total, hdone_total, dtaken_total, htaken_total, ohdone_total = tmpddone_total, tmphdone_total, tmpdtaken_total, tmphtaken_total, tmpohdone_total;
	ddone_max, hdone_max, dtaken_max, htaken_max, ohdone_max = tmpddone_max, tmphdone_max, tmpdtaken_max, tmphtaken_max, tmpohdone_max;
	
	RDX.BeginEventBatch();
	for _,unit in RDX.RaidAll() do
		sig_unit_omnisc:Raise(unit, unit.nid, unit.uid);
	end
	RDX.EndEventBatch();
end

---------------------------------------------
-- thread
---------------------------------------------

local tguid , fguid = "Unknown", "Unknown";

local function resetOmniUnitThreadT()
	for _,unit in RDX.Raid() do
		unit.OmniResetThreadT();
	end
end

local function resetOmniUnitThreadF()
	for _,unit in RDX.Raid() do
		unit.OmniResetThreadF();
	end
end

local function ChangeTarget(arg1)
	-- If we were called via targeting update, ignore nonplayer target changes
	tguid = "Unknown";
	if arg1 and arg1 ~= "player" then return; end
	-- No target = no threat assessment
	if not UnitExists("target") then
		tguid = "Unknown";
	end
	-- If target is hostile, use it, else use targettarget.
	if UnitIsFriend("player", "target") then
		tguid = UnitGUID("targettarget"); 
		--tankUnit = "targettargettarget";
		--SetThreatUnit();
	else
		tguid = UnitGUID("target");
		--tankUnit = "targettarget";
		--SetThreatUnit();
	end
	--FindTank();
	resetOmniUnitThreadT();
end

local function ChangeFocus()
	fguid = UnitGUID("focus") or "Unknown";
	resetOmniUnitThreadF();
end

-- function 
-- upload thread data from omnidb

local function uploadThreatfromOmniDB()
	local tmpdb, tmpu = 0, 0;
	if (tguid == "Unknown") then
		resetOmniUnitThreadT();
	else
		for _,unit in RDX.RaidAll() do
			tmpdb = OmniDB.GetThreat(tguid, unit.guid);
			tmpu = unit.OmniTTDone();
			if (tmpdb ~= tmpu) then
				unit.OmniSetTTDone(tmpdb);
			end
		end
	end
	if (fguid == "Unknown") then
		resetOmniUnitThreadF();
	else
		for _,unit in RDX.RaidAll() do
			tmpdb = OmniDB.GetThreat(fguid, unit.guid);
			tmpu = unit.OmniTFDone();
			if (tmpdb ~= tmpu) then
				unit.OmniSetTFDone(tmpdb);
			end
		end
	end

end

--------------------------------------------------
-- bind RPC
--------------------------------------------------


local function RPCResetOmnilog(ci, rowlog)
	local unit = RPC.GetSenderUnit(ci);
	if (not unit) or (not unit:IsValid()) then return; end
	if not unit:IsLeader() then
		RPC:Debug(1, "Got ResetOmnilog from non-leader " .. unit.name);
		return; 
	end
	RDX.print("|cFFAAFF00Omniscience:|r |cFFFFFFFFReset OmniUnit from " .. ci.sender);
	resetOmniUnitInfo();
end


------------------------------------------------
-- INIT
------------------------------------------------
RDXEvents:Bind("INIT_VARIABLES_LOADED", nil, function()
	
	-- aggegate all data
	VFL.AdaptiveSchedule("omni_updateInfo", 0.5, uploadInfofromOmniDB);
	
	-- upload data from omnidb
	--VFL.AdaptiveSchedule("omni_updateThread", 0.5, uploadThreatfromOmniDB);
	
	-- bind to Target Change, to load new Threat
	--WoWEvents:Bind("UNIT_TARGET", nil, ChangeTarget);
	--WoWEvents:Bind("UNIT_FOCUS", nil, ChangeFocus);
	
end);

------------------------------------------------
-- Omniscience UNITFRAME VARS
------------------------------------------------
--- Unit frame variables for Omniscience data.

RDX.RegisterFeature({
	name = "var_omniscience";
	title = i18n("Vars: OmniMeters (damage,healing,overhealing/done,taken)");
	category = i18n("Variables: Unit Status");
	IsPossible = function(state)
		if not state:Slot("EmitPaintPreamble") then return nil; end
		if state:Slot("Var_damagedone") then return nil; end
		return true;
	end;
	ExposeFeature = function(desc, state, errs)
		state:AddSlot("Var_damagedone"); state:AddSlot("Var_healingdone"); state:AddSlot("Var_damagetaken"); state:AddSlot("Var_healingtaken"); state:AddSlot("Var_overhealingdone");
		state:AddSlot("BoolVar_bdamagedone"); state:AddSlot("BoolVar_bhealingdone"); state:AddSlot("BoolVar_bdamagetaken"); state:AddSlot("BoolVar_bhealingtaken"); state:AddSlot("BoolVar_boverhealingdone");
		state:AddSlot("FracVar_fdamagedone"); state:AddSlot("FracVar_fhealingdone"); state:AddSlot("FracVar_fdamagetaken"); state:AddSlot("FracVar_fhealingtaken"); state:AddSlot("FracVar_foverhealingdone");
		state:AddSlot("Txt_damagedone_text"); state:AddSlot("Txt_healingdone_text"); state:AddSlot("Txt_damagetaken_text"); state:AddSlot("Txt_healingtaken_text"); state:AddSlot("Txt_overhealingdone_text");
		return true;
	end;
	ApplyFeature = function(desc, state)
		state:Attach(state:Slot("EmitPaintPreamble"), true, function(code) code:AppendCode([[
local damagedone, healingdone, damagetaken, healingtaken, overhealingdone, damagedone_max, healingdone_max, damagetaken_max, healingtaken_max, overhealingdone_max, damagedone_total, healingdone_total, damagetaken_total, healingtaken_total, overhealingdone_total = unit:OmniGetInfo();
local bdamagedone, bhealingdone, bdamagetaken, bhealingtaken, boverhealingdone = false, false, false, false, false;
local damagedone_text, healingdone_text, damagetaken_text, healingtaken_text, overhealingdone_text = "", "", "", "", "";
if damagedone and (damagedone > 0) then 
	bdamagedone = true;
	damagedone_text = damagedone .. " / " .. string.format("%.1f", VFL.clamp(damagedone/damagedone_total, 0, 1) * 100) .. "%";
end
if healingdone and (healingdone > 0) then 
	bhealingdone = true;
	healingdone_text = healingdone .. " / " .. string.format("%.1f", VFL.clamp(healingdone/healingdone_total, 0, 1) * 100) .. "%";
end
if damagetaken and (damagetaken > 0) then 
	bdamagetaken = true;
	damagetaken_text = damagetaken .. " / " .. string.format("%.1f", VFL.clamp(damagetaken/damagetaken_total, 0, 1) * 100) .. "%";
end
if healingtaken and (healingtaken > 0) then 
	bhealingtaken = true;
	healingtaken_text = healingtaken .. " / " .. string.format("%.1f", VFL.clamp(healingtaken/healingtaken_total, 0, 1) * 100) .. "%";
end
if overhealingdone and (overhealingdone > 0) then
	boverhealingdone = true;
	overhealingdone_text = overhealingdone .. " / " .. string.format("%.1f", VFL.clamp(overhealingdone/overhealingdone_total, 0, 1) * 100) .. "%";
end
local fdamagedone, fhealingdone, fdamagetaken, fhealingtaken, foverhealingdone = VFL.clamp(damagedone/damagedone_max, 0, 1), VFL.clamp(healingdone/healingdone_max, 0, 1), VFL.clamp(damagetaken/damagetaken_max, 0, 1), VFL.clamp(healingtaken/healingtaken_max, 0, 1), VFL.clamp(overhealingdone/overhealingdone_max, 0, 1);


]]); end);
		-- Event hinting
		local mux = state:GetContainingWindowState():GetSlotValue("Multiplexer");
		mux:Event_MaskAll("UNIT_OMNISC", mux:GetPaintMask("OMNISC"));
	end;
	UIFromDescriptor = VFL.Nil;
	CreateDescriptor = function() return { feature = "var_omniscience" }; end
});

RDX.RegisterFeature({
	name = "var_omniThreadT";
	title = i18n("Vars: OmniThreadTarget");
	category = i18n("Variables: Unit Status");
	invisible = true; -- disable
	IsPossible = function(state)
		if not state:Slot("EmitPaintPreamble") then return nil; end
		if state:Slot("Var_threatTdone") then return nil; end
		return true;
	end;
	ExposeFeature = function(desc, state, errs)
		state:AddSlot("Var_threatTdone");
		state:AddSlot("BoolVar_bthreatTdone");
		state:AddSlot("FracVar_fthreatTdone"); 
		return true;
	end;
	ApplyFeature = function(desc, state)
		state:Attach(state:Slot("EmitPaintPreamble"), true, function(code) code:AppendCode([[
local threadTdone, _, threadT_max, _, threadT_total, _ = unit:OmniGetThread();
local bdthreadTdone = false;
if threadTdone and (threadTdone > 0) then bthreadTdone = true; end
local fthreadTdone = VFL.clamp(threadTdone/threadT_max, 0, 1);
]]); end);
		-- Event hinting
		local mux = state:GetContainingWindowState():GetSlotValue("Multiplexer");
		mux:Event_MaskAll("UNIT_OMNIT", mux:GetPaintMask("OMNIT"));
	end;
	UIFromDescriptor = VFL.Nil;
	CreateDescriptor = function() return { feature = "var_omniThreadT" }; end
});


RDX.RegisterFeature({
	name = "var_omniThreadF";
	title = i18n("Vars: OmniThreadFocus");
	category = i18n("Variables: Unit Status");
	invisible = true; -- disable
	IsPossible = function(state)
		if not state:Slot("EmitPaintPreamble") then return nil; end
		if state:Slot("Var_threatFdone") then return nil; end
		return true;
	end;
	ExposeFeature = function(desc, state, errs)
		state:AddSlot("Var_threatFdone");
		state:AddSlot("BoolVar_bthreatFdone");
		state:AddSlot("FracVar_fthreatFdone"); 
		return true;
	end;
	ApplyFeature = function(desc, state)
		state:Attach(state:Slot("EmitPaintPreamble"), true, function(code) code:AppendCode([[
local _, threadFdone, _, threadF_max, _, threadF_total = unit:OmniGetThread();
local bdthreadFdone = false;
if threadFdone and (threadFdone > 0) then bthreadFdone = true; end
local fthreadFdone = VFL.clamp(threadFdone/threadF_max, 0, 1);
]]); end);
		-- Event hinting
		local mux = state:GetContainingWindowState():GetSlotValue("Multiplexer");
		mux:Event_MaskAll("UNIT_OMNIF", mux:GetPaintMask("OMNIF"));
	end;
	UIFromDescriptor = VFL.Nil;
	CreateDescriptor = function() return { feature = "var_omniThreadF" }; end
});

----------------------------------------------------------
-- OMNISCIENCE FILTER
----------------------------------------------------------
RDX.RegisterFilterComponent({
	name = "omniscience", title = i18n("Omniscience..."), category = i18n("Unit Status"),
	UIFromDescriptor = function(desc, parent)
		local ui = RDXUI.FilterDialogFrame:new(parent);
		ui:SetText(i18n("Omniscience...")); ui:Show();
		local container = VFLUI.CompoundFrame:new(ui);
		ui:SetChild(container); container:Show();

		local perc_numer = VFLUI.RadioGroup:new(container);
		container:InsertFrame(perc_numer);
		perc_numer:SetLayout(5, 1);
		perc_numer.buttons[1]:SetText(i18n("Damage Done"));
		perc_numer.buttons[2]:SetText(i18n("Healing Done"));
		perc_numer.buttons[3]:SetText(i18n("Damage Taken"));
		perc_numer.buttons[4]:SetText(i18n("Healing Taken"));
		perc_numer.buttons[5]:SetText(i18n("Overhealing Done"));
		perc_numer:SetValue(desc[2]);
		perc_numer:Show();

		local lb = VFLUI.LabeledEdit:new(container, 50);
		container:InsertFrame(lb);
		lb:SetText(i18n("Lower bound")); lb.editBox:SetText(desc[3]);
		lb:Show();
		local ub = VFLUI.LabeledEdit:new(container, 50);
		container:InsertFrame(ub);
		ub:SetText(i18n("Upper bound")); ub.editBox:SetText(desc[4]);
		ub:Show();

		ui.GetDescriptor = function(x)
			local lwr = lb.editBox:GetNumber(); if (not lwr) or (lwr < 0) then lwr = 0; end
			local upr = ub.editBox:GetNumber(); if (not upr) or (upr < 0) then upr = 1; end
			if(upr < lwr) then local temp = upr; upr = lwr; lwr = temp; end
			return {"omniscience", perc_numer:GetValue(), lwr, upr};
		end

		return ui;
	end,
	GetBlankDescriptor = function() return {"omniscience", 1, 10000, 10000000}; end,
	FilterFromDescriptor = function(desc, metadata)
		local lb, ub, vexpr = desc[3], desc[4];
		-- Figure out which stat we want to use
		if desc[2] == 1 then -- damage done
			vexpr = "(unit:OmniDDone())";
		elseif desc[2] == 2 then -- healing done
			vexpr = "(unit:OmniHDone())";
		elseif desc[2] == 3 then -- damage taken
			vexpr = "(unit:OmniDTaken())";
		elseif desc[2] == 4 then -- healing taken
			vexpr = "(unit:OmniHTaken())";
		elseif desc[2] == 5 then -- overhealing done
			vexpr = "(unit:OmniOHDone())";
		end
		-- Generate the closures/locals
		local vC = RDX.GenerateFilterUpvalue();
		table.insert(metadata, { class = "LOCAL", name = vC, value = vexpr });
		-- Generate the filtration expression.
		return "((" .. vC .. " >= " .. lb ..") and (" .. vC .. " <= " .. ub .."))";
	end;
	ValidateDescriptor = VFL.True;
	SetsFromDescriptor = VFL.Noop;
	EventsFromDescriptor = function(desc, metadata)
		RDX.FilterEvents_FullUpdate(metadata, "UNIT_OMNISC");
	end;
});
--[[
RDX.RegisterFilterComponent({
	name = "omniThreadT", title = i18n("OmniThread Target..."), category = i18n("Unit Status"),
	UIFromDescriptor = function(desc, parent)
		local ui = RDXUI.FilterDialogFrame:new(parent);
		ui:SetText(i18n("OmniThread Target...")); ui:Show();
		local container = VFLUI.CompoundFrame:new(ui);
		ui:SetChild(container); container:Show();

		local perc_numer = VFLUI.RadioGroup:new(container);
		container:InsertFrame(perc_numer);
		perc_numer:SetLayout(1, 1);
		perc_numer.buttons[1]:SetText(i18n("Threat Target Done"));
		perc_numer:SetValue(desc[2]);
		perc_numer:Show();

		local lb = VFLUI.LabeledEdit:new(container, 50);
		container:InsertFrame(lb);
		lb:SetText(i18n("Lower bound")); lb.editBox:SetText(desc[3]);
		lb:Show();
		local ub = VFLUI.LabeledEdit:new(container, 50);
		container:InsertFrame(ub);
		ub:SetText(i18n("Upper bound")); ub.editBox:SetText(desc[4]);
		ub:Show();

		ui.GetDescriptor = function(x)
			local lwr = lb.editBox:GetNumber(); if (not lwr) or (lwr < 0) then lwr = 0; end
			local upr = ub.editBox:GetNumber(); if (not upr) or (upr < 0) then upr = 1; end
			if(upr < lwr) then local temp = upr; upr = lwr; lwr = temp; end
			return {"omniThreadT", perc_numer:GetValue(), lwr, upr};
		end

		return ui;
	end,
	GetBlankDescriptor = function() return {"omniThreadT", 1, 10000, 10000000}; end,
	FilterFromDescriptor = function(desc, metadata)
		local lb, ub, vexpr = desc[3], desc[4];
		-- Figure out which stat we want to use
		if desc[2] == 1 then -- damage done
			vexpr = "(unit:OmniTTDone())";
		end
		-- Generate the closures/locals
		local vC = RDX.GenerateFilterUpvalue();
		table.insert(metadata, { class = "LOCAL", name = vC, value = vexpr });
		-- Generate the filtration expression.
		return "((" .. vC .. " >= " .. lb ..") and (" .. vC .. " <= " .. ub .."))";
	end;
	ValidateDescriptor = VFL.True;
	SetsFromDescriptor = VFL.Noop;
	EventsFromDescriptor = function(desc, metadata)
		RDX.FilterEvents_FullUpdate(metadata, "UNIT_OMNIT");
	end;
});

RDX.RegisterFilterComponent({
	name = "omniThreadF", title = i18n("OmniThread Focus..."), category = i18n("Unit Status"),
	UIFromDescriptor = function(desc, parent)
		local ui = RDXUI.FilterDialogFrame:new(parent);
		ui:SetText(i18n("OmniThread Focus...")); ui:Show();
		local container = VFLUI.CompoundFrame:new(ui);
		ui:SetChild(container); container:Show();

		local perc_numer = VFLUI.RadioGroup:new(container);
		container:InsertFrame(perc_numer);
		perc_numer:SetLayout(1, 1);
		perc_numer.buttons[1]:SetText(i18n("Threat Focus Done"));
		perc_numer:SetValue(desc[2]);
		perc_numer:Show();

		local lb = VFLUI.LabeledEdit:new(container, 50);
		container:InsertFrame(lb);
		lb:SetText(i18n("Lower bound")); lb.editBox:SetText(desc[3]);
		lb:Show();
		local ub = VFLUI.LabeledEdit:new(container, 50);
		container:InsertFrame(ub);
		ub:SetText(i18n("Upper bound")); ub.editBox:SetText(desc[4]);
		ub:Show();

		ui.GetDescriptor = function(x)
			local lwr = lb.editBox:GetNumber(); if (not lwr) or (lwr < 0) then lwr = 0; end
			local upr = ub.editBox:GetNumber(); if (not upr) or (upr < 0) then upr = 1; end
			if(upr < lwr) then local temp = upr; upr = lwr; lwr = temp; end
			return {"omniThreadF", perc_numer:GetValue(), lwr, upr};
		end

		return ui;
	end,
	GetBlankDescriptor = function() return {"omniThreadF", 1, 10000, 10000000}; end,
	FilterFromDescriptor = function(desc, metadata)
		local lb, ub, vexpr = desc[3], desc[4];
		-- Figure out which stat we want to use
		if desc[2] == 1 then -- damage done
			vexpr = "(unit:OmniTFDone())";
		end
		-- Generate the closures/locals
		local vC = RDX.GenerateFilterUpvalue();
		table.insert(metadata, { class = "LOCAL", name = vC, value = vexpr });
		-- Generate the filtration expression.
		return "((" .. vC .. " >= " .. lb ..") and (" .. vC .. " <= " .. ub .."))";
	end;
	ValidateDescriptor = VFL.True;
	SetsFromDescriptor = VFL.Noop;
	EventsFromDescriptor = function(desc, metadata)
		RDX.FilterEvents_FullUpdate(metadata, "UNIT_OMNIF");
	end;
});
]]
----------------------------------------------------------
-- Omniscience SORT
----------------------------------------------------------
RDX.RegisterSortOperator({
	name = "omnidamagedone";
	title = i18n("Omni Damage Done");
	category = i18n("Status");
	EmitLocals = function(desc, code, vars)
		if not vars["omnidamagedone"] then
			vars["omnidamagedone"] = true;
			code:AppendCode([[
local damagedone1,damagedone2 = u1:OmniDDone(), u2:OmniDDone();
]]);
		end
	end;
	EmitCode = function(desc, code, context)
		code:AppendCode([[
if(damagedone1 == damagedone2) then
]]);
		RDX._SortContinuation(context);
		code:AppendCode([[else
]]);
		if desc.reversed then
			code:AppendCode([[return damagedone1 < damagedone2;]]);
		else
			code:AppendCode([[return damagedone1 > damagedone2;]]);
		end
code:AppendCode([[
end
]]);
	end;
	GetUI = RDX.TrivialSortUI("omnidamagedone", i18n("Omni Damage Done"));
	GetBlankDescriptor = function() return {op = "omnidamagedone"}; end;
	Events = function(desc, ev) 
		ev["UNIT_OMNISC"] = true;
	end;
});

RDX.RegisterSortOperator({
	name = "omnihealingdone";
	title = i18n("Omni Healing Done");
	category = i18n("Status");
	EmitLocals = function(desc, code, vars)
		if not vars["omnihealingdone"] then
			vars["omnihealingdone"] = true;
			code:AppendCode([[
local healingdone1,healingdone2 = u1:OmniHDone(), u2:OmniHDone();
]]);
		end
	end;
	EmitCode = function(desc, code, context)
		code:AppendCode([[
if(healingdone1 == healingdone2) then
]]);
		RDX._SortContinuation(context);
		code:AppendCode([[else
]]);
		if desc.reversed then
			code:AppendCode([[return healingdone1 < healingdone2;]]);
		else
			code:AppendCode([[return healingdone1 > healingdone2;]]);
		end
code:AppendCode([[
end
]]);
	end;
	GetUI = RDX.TrivialSortUI("omnihealingdone", i18n("Omni Healing Done"));
	GetBlankDescriptor = function() return {op = "omnihealingdone"}; end;
	Events = function(desc, ev) 
		ev["UNIT_OMNISC"] = true;
	end;
});

RDX.RegisterSortOperator({
	name = "omnidamagetaken";
	title = i18n("Omni Damage Taken");
	category = i18n("Status");
	EmitLocals = function(desc, code, vars)
		if not vars["omnidamagetaken"] then
			vars["omnidamagetaken"] = true;
			code:AppendCode([[
local damagetaken1,damagetaken2 = u1:OmniDTaken(), u2:OmniDTaken();
]]);
		end
	end;
	EmitCode = function(desc, code, context)
		code:AppendCode([[
if(damagetaken1 == damagetaken2) then
]]);
		RDX._SortContinuation(context);
		code:AppendCode([[else
]]);
		if desc.reversed then
			code:AppendCode([[return damagetaken1 < damagetaken2;]]);
		else
			code:AppendCode([[return damagetaken1 > damagetaken2;]]);
		end
code:AppendCode([[
end
]]);
	end;
	GetUI = RDX.TrivialSortUI("omnidamagetaken", i18n("Omni Damage Taken"));
	GetBlankDescriptor = function() return {op = "omnidamagetaken"}; end;
	Events = function(desc, ev) 
		ev["UNIT_OMNISC"] = true;
	end;
});

RDX.RegisterSortOperator({
	name = "omnihealingtaken";
	title = i18n("Omni Healing Taken");
	category = i18n("Status");
	EmitLocals = function(desc, code, vars)
		if not vars["omnihealingtaken"] then
			vars["omnihealingtaken"] = true;
			code:AppendCode([[
local healingtaken1,healingtaken2 = u1:OmniHTaken(), u2:OmniHTaken();
]]);
		end
	end;
	EmitCode = function(desc, code, context)
		code:AppendCode([[
if(healingtaken1 == healingtaken2) then
]]);
		RDX._SortContinuation(context);
		code:AppendCode([[else
]]);
		if desc.reversed then
			code:AppendCode([[return healingtaken1 < healingtaken2;]]);
		else
			code:AppendCode([[return healingtaken1 > healingtaken2;]]);
		end
code:AppendCode([[
end
]]);
	end;
	GetUI = RDX.TrivialSortUI("omnihealingtaken", i18n("Omni Healing Taken"));
	GetBlankDescriptor = function() return {op = "omnihealingtaken"}; end;
	Events = function(desc, ev) 
		ev["UNIT_OMNISC"] = true;
	end;
});

RDX.RegisterSortOperator({
	name = "omnioverhealingdone";
	title = i18n("Omni Overhealing Done");
	category = i18n("Status");
	EmitLocals = function(desc, code, vars)
		if not vars["omnioverhealingdone"] then
			vars["omnioverhealingdone"] = true;
			code:AppendCode([[
local overhealingdone1,overhealingdone2 = u1:OmniOHDone(), u2:OmniOHDone();
]]);
		end
	end;
	EmitCode = function(desc, code, context)
		code:AppendCode([[
if(overhealingdone1 == overhealingdone2) then
]]);
		RDX._SortContinuation(context);
		code:AppendCode([[else
]]);
		if desc.reversed then
			code:AppendCode([[return overhealingdone1 < overhealingdone2;]]);
		else
			code:AppendCode([[return overhealingdone1 > overhealingdone2;]]);
		end
code:AppendCode([[
end
]]);
	end;
	GetUI = RDX.TrivialSortUI("omnioverhealingdone", i18n("Omni Overhealing Done"));
	GetBlankDescriptor = function() return {op = "omnioverhealingdone"}; end;
	Events = function(desc, ev) 
		ev["UNIT_OMNISC"] = true;
	end;
});

RDX.RegisterSortOperator({
	name = "omniThreatTdone";
	title = i18n("Omni Threat Target Done");
	category = i18n("Status");
	EmitLocals = function(desc, code, vars)
		if not vars["omniThreatTdone"] then
			vars["omniThreatTdone"] = true;
			code:AppendCode([[
local threadTdone1,threadTdone2 = u1:OmniTTDone(), u2:OmniTTDone();
]]);
		end
	end;
	EmitCode = function(desc, code, context)
		code:AppendCode([[
if(threadTdone1 == threadTdone2) then
]]);
		RDX._SortContinuation(context);
		code:AppendCode([[else
]]);
		if desc.reversed then
			code:AppendCode([[return threadTdone1 < threadTdone2;]]);
		else
			code:AppendCode([[return threadTdone1 > threadTdone2;]]);
		end
code:AppendCode([[
end
]]);
	end;
	GetUI = RDX.TrivialSortUI("omniThreatTdone", i18n("Omni Threat Target Done"));
	GetBlankDescriptor = function() return {op = "omniThreatTdone"}; end;
	Events = function(desc, ev) 
		ev["UNIT_OMNIT"] = true;
	end;
});

RDX.RegisterSortOperator({
	name = "omniThreatFdone";
	title = i18n("Omni Threat Focus Done");
	category = i18n("Status");
	EmitLocals = function(desc, code, vars)
		if not vars["omniThreatFdone"] then
			vars["omniThreatFdone"] = true;
			code:AppendCode([[
local threadFdone1,threadFdone2 = u1:OmniTFDone(), u2:OmniTFDone();
]]);
		end
	end;
	EmitCode = function(desc, code, context)
		code:AppendCode([[
if(threadFdone1 == threadFdone2) then
]]);
		RDX._SortContinuation(context);
		code:AppendCode([[else
]]);
		if desc.reversed then
			code:AppendCode([[return threadFdone1 < threadFdone2;]]);
		else
			code:AppendCode([[return threadFdone1 > threadFdone2;]]);
		end
code:AppendCode([[
end
]]);
	end;
	GetUI = RDX.TrivialSortUI("omniThreatFdone", i18n("Omni Threat Focus Done"));
	GetBlankDescriptor = function() return {op = "omniThreatFdone"}; end;
	Events = function(desc, ev) 
		ev["UNIT_OMNIF"] = true;
	end;
});

