-- OpenRDX
-- sigg / rashgarroth EU

-- The Omni.tguid object

Omni.tguid = {};
Omni.tguid.__index = Omni.tguid;

function Omni.tguid:new(tguid, name)
	local self = {};
	self.tguid = tguid;
	self.name = name;
	self.last = GetTime();
	self.mtguid = nil; -- maintankguid
	self.lock = false;
	self.sguid = {};
	self.debuff = {};
	self.buff = {};
	setmetatable(self, Omni.tguid);
	return self;
end

-- return the target guid of this object
function Omni.tguid:getObjectGuid()
	return self.tguid;
end

-- return the last change time of this object
function Omni.tguid:getObjectName()
	return self.name;
end

-- return the last change time of this object
function Omni.tguid:getObjectTime()
	return self.last;
end

-- return the maintank guid of this tguid
function Omni.tguid:getMTguid()
	return self.mtguid;
end

-- set the maintank guid of this tguid
function Omni.tguid:setMTguid(mtguid)
	self.mtguid = mtguid;
	if (not self.sguid[mtguid]) then
		obj = {name = "titi", thread = 0};
		self.sguid[mtguid] = obj;
	end
end

-- in case of lock, no new source can be add.
function Omni.tguid:lockObject()
	self.lock = true;
end
function Omni.tguid:unlockObject()
	self.lock = false;
end

-- return number of source of this object
function Omni.tguid:getSize()
	return table.getn(self.sguid);
end

-- get a source
--[[function Omni.tguid:getSguid(sid)
	-- sid is guid source
	-- On each getSguid, update time
	self.last = GetTime();
	if (not self.sguid[sid]) then
		self.sguid[sid] = {name = "anonymous", thread = 0};
	end
	return self.sguid[sid];
end]]

function Omni.tguid:isSguid(sid)
	if self.sguid[sid] then return true;
	else
		return false;
	end
end

function Omni.tguid:addSguid(sid, nm)
	if (self.sguid[sid] or self.lock) then return false; end
	local obj = {name = nm, thread = 0};
	self.sguid[sid] = obj;
	self.last = GetTime();
	return true;
end

function Omni.tguid:updateSguidThread(sid, v)
	if (not self.lock) or (mtguid == sid) then 
		local obj = nil;
		if (not self.sguid[sid]) then
			obj = {name = "titi", thread = v};
			self.sguid[sid] = obj;
		else
			obj = self.sguid[sid];
			obj.thread = v;
		end
		self.last = GetTime();
		return true;
	else return false;
	end
end

function Omni.tguid:getSguidThread(sid)
	if (not self.sguid[sid]) then return 0; end
	local obj = self.sguid[sid];
	return obj.thread or 0;
end

-- Empty out the tguid, calling the optional destructor function for each object in the tguid.
function Omni.tguid:emptySguid(destr)
	if not destr then destr = VFL.Noop; end
	for _,obj in pairs(self.sguid) do destr(obj); end
	self.sguid = nil;
end

-- Buff AURA Timer Engine

function Omni.tguid:GetDebuffstartime(ldn)
	if (not self.debuff[ldn]) then return nil; end
	return self.debuff[ldn];
end

function Omni.tguid:GetBuffstartime(ldn)
	if (not self.buff[ldn]) then return nil; end
	return self.buff[ldn];
end


