-- OpenRDX
-- sigg / rashgarroth EU

-- The Omni.sguid object

Omni.sguid = {};
Omni.sguid.__index = Omni.sguid;

function Omni.sguid:new(sguid, name)
	local self = {};
	self.sguid = sguid;
	if name then name = string.lower(name);end
	self.name = name;
	self.last = GetTime();
	self.sinfo = {};
	--self.debuff = {};
	--self.buff = {};
	setmetatable(self, Omni.sguid);
	return self;
end

-- return the target guid of this object
function Omni.sguid:getObjectGuid()
	return self.sguid;
end

-- return the last change time of this object
function Omni.sguid:getObjectName()
	return self.name;
end

-- return the last change time of this object
function Omni.sguid:getObjectTime()
	return self.last;
end

-- update data stype = damagedone, damagetaken, healdone etc...
function Omni.sguid:addSguidData(stype, v)
	if (not stype) or (not v) then return nil; end
	local obj = self.sinfo[stype];
	if (not obj) then
		--VFL.print("addguid not found" .. v);
		obj = {nb = 1, data = v};
		self.sinfo[stype] = obj;
	else
		--VFL.print("addguid found" .. v);
		obj.data = obj.data + v;
		obj.nb = obj.nb + 1;
		self.sinfo[stype] = obj;
	end
	--VFL.print("data " .. self.sinfo[stype].data);
	self.last = GetTime();
end

-- get data stype = damagedone, damagetaken, healdone etc...
function Omni.sguid:getSguidData(stype)
	if (not stype) then return nil; end
	local obj = self.sinfo[stype];
	if (not obj) then
		obj = {nb = 1, data = 0};
		self.sinfo[stype] = obj;
	end
	self.last = GetTime();
	return obj.data;
end

-- update data stype = damagedone, damagetaken, healdone etc...
function Omni.sguid:setSguidData(stype, v)
	if (not stype) or (not v) then return nil; end
	local obj = self.sinfo[stype];
	if (not obj) then
		obj = {nb = 1, data = v};
		self.sinfo[stype] = obj;
	else
		obj.data = v;
	end
	--self.last = GetTime();
end

-- Empty out the sguid, calling the optional destructor function for each object in the sguid.
function Omni.sguid:emptySinfo(destr)
	if not destr then destr = VFL.Noop; end
	for _,obj in pairs(self.sinfo) do destr(obj); end
	self.sinfo = nil;
end




