-- OpenRDX
-- sigg / rashgarroth EU

-- The Omni.GUID object

Omni.GUID = {};
Omni.GUID.__index = Omni.GUID;

function Omni.GUID:new(GUID, name)
	local self = {};
	-- id
	self.GUID = GUID;
	if name then name = string.lower(name); end
	self.name = name;
	self.last = GetTime();
	
	-- Omni heart info (aggro)
	self.mtGUID = nil; -- main tank guid ref
	self.lock = false; -- flag to indicate this guid has no aggro
	self.aggro = {}; -- list of guid and aggro
	
	-- Omni meters info (damage, heal, overhealing)
	self.info = {};
	
	-- Omni ATE info (debuff, buff, startime and who guid)
	self.debuff = {};
	self.buff = {};
	
	setmetatable(self, Omni.GUID);
	--VFL.print("ok");
	return self;
end

-- return the guid of this object
function Omni.GUID:getObjectGUID()
	return self.GUID;
end

-- return the name
function Omni.GUID:getObjectName()
	return self.name or "";
end

-- return the last change time of this guid
function Omni.GUID:getObjectTime()
	return self.last;
end

---------------------------------------
-- Omniheart
---------------------------------------

-- return the maintank guid of this guid
function Omni.GUID:getMTGUID()
	return self.mtGUID;
end

-- set the maintank guid of this guid
function Omni.GUID:setMTGUID(mtGUID, mtname)
	self.mtGUID = mtGUID;
	if (not self.aggro[mtGUID]) then
		obj = {name = mtname, thread = 0};
		self.aggro[mtGUID] = obj;
	end
end

-- in case of lock, no new source can be add.
function Omni.GUID:lockObject()
	self.lock = true;
end
function Omni.GUID:unlockObject()
	self.lock = false;
end

-- return number of source of this object
function Omni.GUID:getAggroListSize()
	return table.getn(self.aggro);
end

-- Empty out the guid, calling the optional destructor function for each object in the tguid.
function Omni.GUID:emptyAggroList(destr)
	if not destr then destr = VFL.Noop; end
	for _,obj in pairs(self.aggro) do destr(obj); end
	self.aggro = nil;
end

-- get a source
function Omni.GUID:getGUIDAggro(aGUID, aname)
	-- sid is guid source
	-- On each getSguid, update time
	-- self.last = GetTime();
	if (not self.aggro[aGUID]) then
		self.aggro[aGUID] = {name = aname, thread = 0};
	end
	return self.aggro[aGUID];
end

function Omni.GUID:isGUIDAggro(aGUID)
	if self.aggro[aGUID] then return true;
	else
		return false;
	end
end

function Omni.GUID:addGUIDAggro(aGUID, nm)
	if (self.aggro[aGUID] or self.lock) then return false; end
	local obj = {name = nm, thread = 0};
	self.aggro[aGUID] = obj;
	self.last = GetTime();
	return true;
end

function Omni.GUID:updateGUIDThread(aGUID, v)
	if (not self.lock) or (mtGUID == aGUID) then 
		local obj = nil;
		if (not self.aggro[aGUID]) then
			obj = {name = "titi", thread = v};
			self.aggro[aGUID] = obj;
		else
			obj = self.aggro[aGUID];
			obj.thread = v;
		end
		self.last = GetTime();
		return true;
	else return false;
	end
end

function Omni.GUID:getGUIDThread(GUID)
	if (not self.aggro[GUID]) then return 0; end
	local obj = self.aggro[GUID];
	return obj.thread or 0;
end

---------------------------------------------
-- Omnimeters
---------------------------------------------

-- update data stype = damagedone, damagetaken, healdone etc...
function Omni.GUID:addGUIDData(stype, v)
	if (not stype) or (not v) then return nil; end
	local obj = self.info[stype];
	if (not obj) then
		--VFL.print("addguid not found" .. v);
		obj = {nb = 1, data = v};
		self.info[stype] = obj;
	else
		--VFL.print("addguid found" .. v);
		obj.data = obj.data + v;
		obj.nb = obj.nb + 1;
		self.info[stype] = obj;
	end
	--VFL.print("data " .. self.sinfo[stype].data);
	self.last = GetTime();
end

-- get data stype = damagedone, damagetaken, healdone etc...
function Omni.GUID:getGUIDData(stype)
	if (not stype) then return nil; end
	local obj = self.info[stype];
	if (not obj) then
		obj = {nb = 1, data = 0};
		self.info[stype] = obj;
	end
	self.last = GetTime();
	return obj.data;
end

-- update data stype = damagedone, damagetaken, healdone etc...
function Omni.GUID:setGUIDData(stype, v)
	if (not stype) or (not v) then return nil; end
	local obj = self.info[stype];
	if (not obj) then
		obj = {nb = 1, data = v};
		self.info[stype] = obj;
	else
		obj.data = v;
	end
	--self.last = GetTime();
end

-- Empty Info.
function Omni.GUID:emptyINFO()
	VFL.empty(self.info);
end

------------------------------------------------------------
-- Buff AURA Timer Engine
-- Only work with unique debuff/buff (not regen for example)
------------------------------------------------------------

function Omni.GUID:GetGUIDDebuff(ldn)
	if (not ldn) then return nil, nil, nil, ""; end
	local obj = self.debuff[ldn];
	if (not obj) then return nil, nil, nil, ""; end
	self.last = GetTime();
	local tl = obj.timeleft - (GetTime() - obj.startime);
	if tl < 0 then self.debuff[ldn] = nil; return nil, nil, nil, ""; end
	return obj.startime, obj.duration, tl, obj.who;
end

function Omni.GUID:SetGUIDDebuff(ldn, dur, tl, name)
	if (not ldn) or (not name) then return nil; end
	local obj = self.debuff[ldn];
	if (not obj) then
		obj = {startime = GetTime(), duration = dur, timeleft = tl,  who = name};
		self.debuff[ldn] = obj;
	else
		obj.startime = GetTime();
		obj.duration = dur;
		obj.timeleft = tl;
		obj.who = name;
	end
	--self.last = GetTime();
end

function Omni.GUID:GetGUIDBuff(ldn)
	if (not ldn) then return nil; end
	local obj = self.buff[ldn];
	if (not obj) then return nil, nil, nil, ""; end
	self.last = GetTime();
	local tl = obj.timeleft - (GetTime() - obj.startime);
	if tl < 0 then self.buff[ldn] = nil; return nil, nil, nil, ""; end
	return obj.startime, obj.duration, tl, obj.who;
end

function Omni.GUID:SetGUIDBuff(ldn, dur, tl, name)
	if (not ldn) or (not name) then return nil; end
	local obj = self.buff[ldn];
	if (not obj) then
		obj = {startime = GetTime(), duration = dur, timeleft = tl, who = name};
		self.buff[ldn] = obj;
	else
		obj.startime = GetTime();
		obj.duration = dur;
		obj.timeleft = tl
		obj.who = name;
	end
	--self.last = GetTime();
end

function Omni.GUID:ListGUIDBuff()
	for k,v in pairs(self.buff) do
		_, _, a = self:GetGUIDBuff(k);
		VFL.print("buff " .. k .. " timeleft " .. a);
	end
end

function Omni.GUID:ListGUIDDebuff()
	for k,v in pairs(self.debuff) do
		VFL.print("debuff " .. k);
	end
end


