-- OpenRDX
-- Sigg Rashgarroth EU

OmniDB = RegisterVFLModule({
	name = "OmniDB";
	title = i18n("OmniDB");
	description = "Omni DataBase for RDX";
	version = {1,0,0};
	parent = RDX;
});

VFLP.RegisterCategory(i18n("RDX: OmniDB"));

local myGUID = nil;
local myname = string.lower(UnitName("player"));
local timeGC_default = 60;
local GUIDs, targetslock, targetsunlock = {}, {}, {};

local infotype = {};
infotype[1] = "dtaken";
infotype[2] = "ddone";
infotype[3] = "hdone";
infotype[4] = "htaken";
infotype[5] = "ohdone";

-- Get DB Size
local function OmniDBgetSize()
	return table.getn(GUIDs);
end

-- Return GUIDs
local function OmniDBgetGUIDs()
	return GUIDs;
end

-- Return one GUID
local function OmniDBgetGUID(id, name, force)
	if not id then return nil; end
	if (not GUIDs[id]) and force then
		GUIDs[id] = Omni.GUID:new(id, name);
	end
	return GUIDs[id];
end

-- Remove one GUID
local function OmniDBremoveGUID(id)
	local tmpGUID = OmniDBgetGUID(id);
	if tmpGUID then
		tmpGUID:emptyINFO();
		tmpGUID = nil;
		GUIDs[id] = nil;
	end
	return true;
end

-- Empty GUIDs
local function OmniDBemptyGUIDs()
	for k,_ in pairs(GUIDs) do
		OmniDBremoveGUID(k);
	end
	return true;
end

----------------------------------------------
-- services
----------------------------------------------

local function OmniDBservices()
	local time, flag, myThreads, myInfos = 0, {}, {},{};
	for k,v in pairs(GUIDs) do
		-- remove tguid with time superior to tm_default
		time = (GetTime() - v:getObjectTime());
		if time > timeGC_default then table.insert(flag, v:getObjectGUID()); end
		
		-- Omniheart
		-- lock any tguids found in targetslock
		for _,y in ipairs(targetslock) do 
			if y == v:getObjectName() then v:lockObject(); end
		end
		-- unlock any tguids found in targetsunlock
		for _,y in ipairs(targetsunlock) do 
			if y == v:getObjectName() then v:unlockObject(); end
		end
		-- create a table of yours Threads data
		--myThreads[k] = v:getSguidThread(myGUID);
	end
	-- removing
	for _,w in pairs(flag) do
		OmniDBremoveGUID(w);
		--VFL.print("debug remove GUID " .. w);
	end
	
	-- Omnimeters
	local tmpGUID = OmniDBgetGUID(myGUID, myname, true); -- This line will also create it.
	if tmpGUID then
		local myInfos = {};
		myInfos.OmniDTaken = tmpGUID:getGUIDData(infotype[1]); -- also update time of guid so ths GC won't remove it.
		myInfos.OmniDDone = tmpGUID:getGUIDData(infotype[2]);
		myInfos.OmniHDone = tmpGUID:getGUIDData(infotype[3]);
		myInfos.OmniHTaken = tmpGUID:getGUIDData(infotype[4]);
		myInfos.OmniOHDone = tmpGUID:getGUIDData(infotype[5]);
		RPC_Group:Flash("OmniDBInfo", myInfos);
	end
	
	-- Sync your thread
	--RPC_Group:Flash("OmniDBTguids", myThreads);
	
end

-- Updating omnimeters and ATE

local pp = {};
pp.OmniUnitUpdate = function(...)
	local rowlog = select(3, ...);
	if rowlog.x then 
		local srcGUID, tgtGUID;
		if rowlog.sg then srcGUID = OmniDBgetGUID(rowlog.sg, rowlog.s, true); end
		if rowlog.rg then tgtGUID = OmniDBgetGUID(rowlog.rg, rowlog.r, true); end
		if rowlog.y == 1 then
			if tgtGUID then tgtGUID:addGUIDData(infotype[1], rowlog.x); end
		elseif rowlog.y == 2 then
			if srcGUID then srcGUID:addGUIDData(infotype[2], rowlog.x); end
		elseif (rowlog.y == 8) then
			if srcGUID then srcGUID:addGUIDData(infotype[3], rowlog.x); end
			if tgtGUID then tgtGUID:addGUIDData(infotype[4], rowlog.x); end
			if rowlog.oh and (rowlog.oh > 0) then
				if srcGUID then srcGUID:addGUIDData(infotype[5], rowlog.oh); end
			end
		--elseif (rowlog.y == 5) and rowlog.a then
		--	if tgtGUID and RDXATE.listDebuffs[rowlog.a] then tgtGUID:setGUIDDebuff(rowlog.rg, rowlog.r, rowlog.a, GetTime(), "Unknown", false); end
		end
	end
end


-------------------------------------
-- Global high level functions
-------------------------------------

function OmniDB.GetGUID(guid)
	return OmniDBgetGUID(guid);
end

--------------------------------------
-- Omniheart
--------------------------------------

function OmniDB.ChangeThreat(amt, school, source)
	
end

-- Addthreat
-- amt = amount thread
-- target = target to add thread
-- tall = boolean threat add to all target
-- source = the one
-- send = dispatch to all members
-- time = thread over time (example fade)
-- reset = boolean to rest thread after time

function OmniDB.AddThreat(amt, target, targetname, tall, source, send, time, reset)
	local v, t = nil, 0;
	
	--if sguid[source] then amt = amt * sguid[source]; end
	
	if tall then
		for _,v in pairs(tguids) do
			t = (v:getSguidThread(source)) + amt;
			v:updateSguidThread(source, t);
		end
	else
		v = tguids[target];
		if v == nil then
			-- this guid don't exist, send to everyone
			v = Omni.tguid:new(target, targetname);
			local p = { guid = target, name = targetname };
			RPC_Group:Flash("omniDBsynctguid",p);
		end
		t = (v:getSguidThread(source)) + amt;
		v:updateSguidThread(source, t);
		tguids[target] = v ;
	end
	
	-- remove thread after time seconds
	
	if time then
		VFL.ZMSchedule(time, function(tall, source, amt)
			if tall then
				for _,v in pairs(tguids) do
					t = (v:getSguidThread(source)) - amt;
					v:updateSguidThread(source, t);
				end
			else
				v = tguids[target];
				t = (v:getSguidThread(source)) - amt;
				v:updateSguidThread(source, t);
			end;
		end);
	end
	
	return true;
end



-- Resetthreat
-- target = target
-- tall = boolean to reset all target
--

function OmniDB.ResetThreat(target, tall, source, sall)
	if (target == nil) or (tall == nil) then 
		-- error
		return nil;
	elseif (source == nil) or (sall == nil) then 
		-- error
		return nil;
	end
	local v = nil;
	if tall then
		for _,v in pairs(tguids) do
			if sall then
				v:emptySguid();
			else
				v:updateSguidThread(source, 0);
			end
		end
	else
		v = tguids[target];
		if sall then
			v:emptySguid();
		else
			v:updateSguidThread(source, 0);
		end
	end
	return true;
end

-- Function reduceThreat
-- example : priest Pain Suppression -5%
function OmniDB.reduceThreat(pct, source)
	for _,v in pairs(tguids) do
		local value = v:getSguidThread(source);
		value = value * (pct / 100);
		v:updateSguidThread(source, value);
	end
end

-- Function extendThreat
function OmniDB.extendThreat(pct, source)
	for _,v in pairs(tguids) do
		local value = v:getSguidThread(source);
		value = value + value * (pct / 100);
		v:updateSguidThread(source, value);
	end
end

-- Lock Threat use by the bossmod
function OmniDB.LockThreat(targetname)
	-- the guid can't be give from the bossmod object.
	-- we use the name of the target
	VFL.vremove(targetsunlock,targetname);
	table.insert(targetslock,targetname);
end

function OmniDB.UnlockThreat(targetname)
	VFL.vremove(targetslock,targetname);
	table.insert(targetsunlock,targetname);
end


function OmniDB.GetThreat(target, source)
	if (target == nil) or (source == nil) then 
		return 0;
	end
	local tguid = tguids[target]
	if tguid then return tguid:getSguidThread(source);
	else return 0;
	end
end

function OmniDB.DEBUGGADD()
	OmniDB.AddThreat(1000, "testguid", "aaname", false, "me");
end

function OmniDB.DEBUGGLIST()
	for k,v in pairs(GUIDs) do
		VFL.print("guid " .. k .. " " .. v:getObjectName());
	end
end

function OmniDB.DEBUGGLISTBuff()
	for k,v in pairs(GUIDs) do
		VFL.print("guid " .. k .. " " .. v:getObjectName());
		v:ListGUIDBuff();
	end
end

function OmniDB.DEBUGGLISTDebuff()
	for k,v in pairs(GUIDs) do
		VFL.print("guid " .. k .. " " .. v:getObjectName());
		v:ListGUIDDebuff();
	end
end


----------------------------------------------------------
-- damage meter High API Level
----------------------------------------------------------

function OmniDB.GetGUIDInfo(guid, name)
	local tmpGUID = OmniDBgetGUID(guid, name);
	if not tmpGUID then return 0,0,0,0,0; end
	return tmpGUID:getGUIDData(infotype[1]), tmpGUID:getGUIDData(infotype[2]), tmpGUID:getGUIDData(infotype[3]), tmpGUID:getGUIDData(infotype[4]), tmpGUID:getGUIDData(infotype[5]);
end

-----------------------------------------------------------
-- ATE
-----------------------------------------------------------

function OmniDB.GetGUIDDebuff(guid, debuff)
	local tmpGUID = OmniDBgetGUID(guid, name);
	if not tmpGUID then return nil, nil, nil, ""; end
	return tmpGUID:GetGUIDDebuff(debuff);
end

function OmniDB.SetGUIDDebuff(guid, name, debuff, duration, timeleft, who, RPCFlag)
	local tmpGUID = OmniDBgetGUID(guid, name, true);
	tmpGUID:SetGUIDDebuff(debuff, duration, timeleft, who);
	if RPCFlag then
		--RPC
		local obj = {g = guid, n = name, d = debuff, u = duration, t = timeleft, w = who};
		--VFL.print("ATE Debuff Send RPC " .. obj.n .. " " .. obj.d .. " " .. obj.u .. " " .. obj.t .. " " .. obj.w);
		--RPC_Group:Flash("OmniDBATEDebuff", obj);
	end
end

VFLP.RegisterFunc(i18n("RDX: OmniDB"), "SetGUIDDebuff", OmniDB.SetGUIDDebuff, true);

function OmniDB.GetGUIDBuff(guid, buff)
	local tmpGUID = OmniDBgetGUID(guid, name);
	if not tmpGUID then return  nil, nil, nil, ""; end
	return tmpGUID:GetGUIDBuff(buff);
end

function OmniDB.SetGUIDBuff(guid, name, buff, duration, timeleft, who, RPCFlag)
	local tmpGUID = OmniDBgetGUID(guid, name, true);
	tmpGUID:SetGUIDBuff(buff, duration, timeleft, who);
	if RPCFlag then
		--RPC
		local obj = {g = guid, n = name, b = buff, u = duration, t = timeleft, w = who};
		--VFL.print("ATE Buff Send RPC " .. obj.n .. " " .. obj.b .. " " .. obj.u .. " " .. obj.t .. " " .. obj.w);
		--RPC_Group:Flash("OmniDBATEBuff", obj);
	end
end

VFLP.RegisterFunc(i18n("RDX: OmniDB"), "SetGUIDBuff", OmniDB.SetGUIDBuff, true);

----------------------------------------------
-- RPC
----------------------------------------------

-- function update thread
local function RPCOmniDBservices(ci, p)
	local unit = RPC.GetSenderUnit(ci);
	if (not unit) or (not unit:IsValid()) then return; end
	if myGUID == unit.guid then return; end
	local tguid = nil;
	for k,v in pairs(p) do
		tguid = tguids[k];
		tguid:updateSguidThread(unit:GetGuid(), v);		
	end
end

-- function update info
local function RPCOmniDBInfoSync(ci, myInfos)
	local unit = RPC.GetSenderUnit(ci);
	if (not unit) or (not unit:IsValid()) then return; end
	if unit.guid ~= myGUID then
		local tmpGUID = OmniDBgetGUID(unit.guid, unit.name, true);
		if tmpGUID then
			tmpGUID:setGUIDData(infotype[1], myInfos.OmniDTaken);
			tmpGUID:setGUIDData(infotype[2], myInfos.OmniDDone);
			tmpGUID:setGUIDData(infotype[3], myInfos.OmniHDone);
			tmpGUID:setGUIDData(infotype[4], myInfos.OmniHTaken);
			tmpGUID:setGUIDData(infotype[5], myInfos.OmniOHDone);
		end
	end
end

-- function ATE
local function RPCOmniDBATEDebuffSync(ci, obj)
	local unit = RPC.GetSenderUnit(ci);
	if (not unit) or (not unit:IsValid()) then return; end
	if not myGUID or not unit.guid then return; end
	if unit.guid ~= myGUID then
		--VFL.print("ATE Debuff Receive RPC " .. obj.n .. " " .. obj.d .. " " .. obj.u .. " " .. obj.t .. " " .. obj.w);
		OmniDB.SetGUIDDebuff(obj.g, obj.n, obj.d, obj.u, obj.t, obj.w, false)
		RDX.ATEProcess(obj);
	end
end

local function RPCOmniDBATEBuffSync(ci, obj)
	local unit = RPC.GetSenderUnit(ci);
	if (not unit) or (not unit:IsValid()) then return; end
	if not myGUID or not unit.guid then return; end
	if unit.guid ~= myGUID then
		--VFL.print("ATE Buff Receive RPC " .. obj.n .. " " .. obj.b .. " " .. obj.u .. " " .. obj.t .. " " .. obj.w);
		OmniDB.SetGUIDBuff(obj.g, obj.n, obj.b, obj.u, obj.t, obj.w, false)
		--RDX.ATEProcess(obj);
	end
end

-- function send a reset to all raid
local function sendResetOmniDB()
	if not RDXPlayer:IsLeader() then return; end
	RPC_Group:Flash("ResetOmniLog");
end

-- reset
local function RPCResetOmnilog(ci, rowlog)
	local unit = RPC.GetSenderUnit(ci);
	if (not unit) or (not unit:IsValid()) then return; end
	if not unit:IsLeader() then
		RPC:Debug(1, "Got ResetOmniDB from non-leader " .. unit.name);
		return; 
	end
	RDX.print("|cFFAAFF00Omniscience:|r |cFFFFFFFFReset OmniDB from " .. ci.sender);
	OmniDBemptyGUIDs();
	-- resync ATE
	RDX._Disrupt();
end

----------------------------------------------
-- INIT
----------------------------------------------

--RDXEvents:Bind("INIT_DEFERRED", nil, function()
RDXEvents:Bind("INIT_DEFERRED", nil, function()
	Omni.menu:RegisterMenuFunction(function(ent)
		ent.text = "Reset OmniDB (Only leaders)";
		ent.OnClick = function()
			VFL.poptree:Release();
			VFLUI.MessageBox("Clear OmniDB data", "Do you want to reset? This will clear everyone omniDB.", nil, "No", nil, "Yes", sendResetOmniDB);
		end;
	end);
	
	myGUID = UnitGUID("player");
	-- bind : receive reset request
	RPC_Group:Bind("ResetOmniLog", RPCResetOmnilog);
	
	-- bind to omnievent to get damage meter
	OmniEvents:Bind("LOGALL_ROW_ADDED", pp, pp.OmniUnitUpdate, "BindUnits");
	
	-- services sguid and bind data from members
	VFL.AdaptiveSchedule("OmniDBservices", 30, OmniDBservices);
	RPC_Group:Bind("OmniDBInfo", RPCOmniDBInfoSync);
	
	
	RPC_Group:Bind("OmniDBATEDebuff", RPCOmniDBATEDebuffSync);
	RPC_Group:Bind("OmniDBATEBuff", RPCOmniDBATEBuffSync);
	
	-- launch the first time
	OmniDBservices();
	
end);

