-- LogisticsWindow.lua
-- RDX - Raid Data Exchange
-- (C)2006 Raid Informatics
--
-- THIS FILE CONTAINS COPYRIGHTED CONTENT SUBJECT TO THE TERMS OF A SEPARATE
-- LICENSE. UNLICENSED COPYING IS PROHIBITED.
--
-- General-purpose windows for displaying results from logistics queries.

--- Core logistics window moved into RDX main codebase; point to that code.
Logistics.NewWindow = RDX.CreateLogisticsWindow;
Logistics.StdSort = function(w,f) w:Sort(f); end;
Logistics.StdSortGT = function(w,f) w:SortGT(f); end;

------------------------------------------------------------------------------
-- A general purpose scrolling list used by several of the logistics modules.
------------------------------------------------------------------------------
-- Individual results window
local function rwframe()
	local self = VFLUI.AcquireFrame("Button");
	self:SetWidth(250); self:SetHeight(12);

	-- Create the text
	local text1 = VFLUI.CreateFontString(self);
	text1:SetPoint("LEFT", self, "LEFT"); text1:SetWidth(250); text1:SetHeight(12);
	text1:Show();
	text1:SetFontObject(Fonts.Default);
	text1:SetTextColor(1,1,1,1);
	text1:SetJustifyH("LEFT");
	self.text1 = text1;

	self.Destroy = VFL.hook(function(self)
		VFLUI.ReleaseRegion(self.text1); self.text1 = nil;
	end, self.Destroy);
	self.OnDeparent = self.Destroy;

	return self;
end

function Logistics.MakeDetailWindow(fnAD)
	local rwin = VFLUI.Window:new(UIParent);
	rwin:SetFraming(VFLUI.Framing.Default, 22);
	rwin:SetTitleColor(0,0,0.6);
	rwin:SetPoint("CENTER", UIParent, "CENTER");
	rwin:Accomodate(250, 240);
	VFLUI.Window.StdMove(rwin, rwin:GetTitleBar());
	rwin:Show();
	local ca = rwin:GetClientArea();

	local data = {};
	rwin.data = data;

	local list = VFLUI.List:new(ca, 12, rwframe);
	list:SetPoint("TOPLEFT", ca, "TOPLEFT");
	list:SetWidth(250); list:SetHeight(240);
	list:Rebuild(); list:Show();
	list:SetDataSource(fnAD, VFL.ArrayLiterator(data));
	function rwin:Update() list:Update();	end

	local closebtn = VFLUI.CloseButton:new();
	closebtn:SetScript("OnClick", function() rwin:Destroy(); end);
	rwin:AddButton(closebtn);

	rwin.Destroy = VFL.hook(function(s)
		s.Update = nil;
		list:Destroy(); list = nil;
		s.data = nil; data = nil;
		rwin = nil;
	end, rwin.Destroy);

	return rwin;
end
