-- RDX6_Class.lua
-- RDX - Raid Data Exchange
-- (C)2007 Sigg / Rashgarroth eu

-- Unit Icon

------------------------------------------------
-- Should be add in VFL ??
------------------------------------------------

local class_un = {0, 0, 0, 0};

local classIcons = {
	["WARRIOR"] = {0, 0.25, 0, 0.25},
	["MAGE"] = {0.25, 0.49609375, 0, 0.25},
	["ROGUE"] = {0.49609375, 0.7421875, 0, 0.25},
	["DRUID"] = {0.7421875, 0.98828125, 0, 0.25},
	["HUNTER"] = {0, 0.25, 0.25, 0.5},
	["SHAMAN"] = {0.25, 0.49609375, 0.25, 0.5},
	["PRIEST"] = {0.49609375, 0.7421875, 0.25, 0.5},
	["WARLOCK"] = {0.7421875, 0.98828125, 0.25, 0.5},
	["PALADIN"] = {0, 0.25, 0.5, 0.75},
}

function VFLGetClassIcon(cl)
	return classIcons[cl] or class_un;
end


------------------------------------------------
-- UNITFRAME
------------------------------------------------
--- Unit frame class icon
RDX.RegisterFeature({
	name = "tex_class";
	title = i18n("Class Icon");
	category = i18n("Icon");
	IsPossible = function(state)
		if not state:Slot("UnitFrame") then return nil; end
		if not state:Slot("Base") then return nil; end
		return true;
	end;
	ExposeFeature = function(desc, state, errs)
		if not desc then VFL.AddError(errs, i18n("Missing descriptor.")); return nil; end
		-- Verify our owner frame exists
		if (not desc.owner) or ((desc.owner ~= "Base") and (not state:Slot("Subframe_" .. desc.owner))) then
			VFL.AddError(errs, i18n("Owner frame does not exist.")); return nil;
		end
		local flg = true;
		flg = flg and __UFFrameCheck_Proto("Icon_", desc, state, errs);
		flg = flg and __UFAnchorCheck(desc.anchor, state, errs);
		if flg then state:AddSlot("Icon_" .. desc.name); end
		return flg;
	end;
	ApplyFeature = function(desc, state)
	local objname = "Icon_" .. desc.name;

		------------------ On frame creation
		local createCode = [[
local _t = VFLUI.CreateTexture(]] .. RDXUI.ResolveFrameReference(desc.owner) .. [[);
frame.]] .. objname .. [[ = _t;
_t:SetDrawLayer("]] .. (desc.drawLayer or "ARTWORK") .. [[");
_t:SetPoint(]] .. RDXUI.AnchorCodeFromDescriptor(desc.anchor) .. [[);
_t:SetWidth(]] .. desc.w .. [[); _t:SetHeight(]] .. desc.h .. [[);
_t:SetVertexColor(1,1,1,1);
_t:SetTexture("Interface\\Glues\\CharacterCreate\\UI-CharacterCreate-Classes");
_t:Show();
]];
		state:Attach(state:Slot("EmitCreate"), true, function(code) code:AppendCode(createCode); end);

		------------------ On frame destruction.
		state:Attach(state:Slot("EmitDestroy"), true, function(code) code:AppendCode([[
VFLUI.ReleaseRegion(frame.]] .. objname .. [[);
frame.]] .. objname .. [[ = nil;
]]); end);
		state:Attach(state:Slot("EmitCleanup"), true, function(code) code:AppendCode([[
frame.]] .. objname .. [[:Hide();
]]); end);

		------------------ On paint.
		state:Attach(state:Slot("EmitPaint"), true, function(code) code:AppendCode([[
if UnitIsPlayer(uid) then
local classii = VFLGetClassIcon(unit:GetClassMnemonic());
frame.]] .. objname .. [[:SetTexCoord(classii[1], classii[2], classii[3], classii[4]);
frame.]] .. objname .. [[:Show();
else
frame.]] .. objname .. [[:Hide();
end
]]); end);

		return true;
	end;
	UIFromDescriptor = function(desc, parent, state)
		local ui = VFLUI.CompoundFrame:new(parent);

		-- Name/width/height
		local ed_name, ed_width, ed_height = RDXUI.GenNameWidthHeightPortion(ui, desc);

		-- Owner
		local owner = RDXUI.MakeSlotSelectorDropdown(ui, i18n("Owner"), state, "Subframe_", true);
		if desc and desc.owner then owner:SetSelection(desc.owner); end

		-- Drawlayer
		local er = RDXUI.EmbedRight(ui, i18n("Draw layer:"));
		local drawLayer = VFLUI.Dropdown:new(er, RDXUI.DrawLayerDropdownFunction);
		drawLayer:SetWidth(100); drawLayer:Show();
		if desc and desc.drawLayer then drawLayer:SetSelection(desc.drawLayer); else drawLayer:SetSelection("ARTWORK"); end
		er:EmbedChild(drawLayer); er:Show();
		ui:InsertFrame(er);

		-- Anchor
		local anchor = RDXUI.UnitFrameAnchorSelector:new(ui); anchor:Show();
		anchor:SetAFArray(RDXUI.ComposeFrameList(state));
		if desc and desc.anchor then anchor:SetAnchorInfo(desc.anchor); end
		ui:InsertFrame(anchor);
		
		function ui:GetDescriptor()
			local name = ed_name.editBox:GetText();
			return { 
				feature = "tex_class", name = name, owner = owner:GetSelection();
				drawLayer = drawLayer:GetSelection();
				w = VFL.clamp(ed_width.editBox:GetNumber(), 0, 1000);
				h = VFL.clamp(ed_height.editBox:GetNumber(), 0, 1000);
				anchor = anchor:GetAnchorInfo();
			};
		end

		return ui;
	end;
	CreateDescriptor = function()
		return { 
			feature = "tex_class", name = "rci", owner = "Base", drawLayer = "ARTWORK";
			w = 14; h = 14;
			anchor = { lp = "TOPLEFT", af = "Base", rp = "TOPLEFT", dx = 0, dy = 0};
		};
	end;
});


-----------------------------------
-- Subclass talent
-----------------------------------

local sig_unit_subclass = RDXEvents:LockSignal("UNIT_SUBCLASS");

--------------------------------------------------------------
-- table talent (can be add in the VFL system)
-------------------------------------------------------------

local _unsubclass = i18n("Unknown");

local idToLocalsubclass = { 
	i18n("PRIEST_Discipline"), i18n("PRIEST_Holy"), i18n("PRIEST_Shadow"),
	i18n("DRUID_Balance"), i18n("DRUID_Feral Combat"), i18n("DRUID_Restoration"),
	i18n("PALADIN_Holy"), i18n("PALADIN_Protection"), i18n("PALADIN_Retribution"),
	i18n("SHAMAN_Elemental"), i18n("SHAMAN_Enhancement"), i18n("SHAMAN_Restoration"),
	i18n("WARRIOR_Arms"), i18n("WARRIOR_Fury"), i18n("WARRIOR_Protection"),
	i18n("WARLOCK_Affliction"), i18n("WARLOCK_Demonology"), i18n("WARLOCK_Destruction"),
	i18n("MAGE_Arcane"), i18n("MAGE_Fire"), i18n("MAGE_Frost"),
	i18n("ROGUE_Assassination"), i18n("ROGUE_Combat"), i18n("ROGUE_Subtlety"),
	i18n("HUNTER_Beast Mastery"), i18n("HUNTER_Marksmanship"), i18n("HUNTER_Survival"),
};

local localsubclassToID = VFL.invert(idToLocalsubclass);

local _unsbColor = { r=.5, g=.5, b=.5};

local idToColor = { 
	RAID_CLASS_COLORS["PRIEST"], RAID_CLASS_COLORS["PRIEST"], RAID_CLASS_COLORS["PRIEST"],
	RAID_CLASS_COLORS["DRUID"], RAID_CLASS_COLORS["DRUID"], RAID_CLASS_COLORS["DRUID"],
	RAID_CLASS_COLORS["PALADIN"], RAID_CLASS_COLORS["PALADIN"], RAID_CLASS_COLORS["PALADIN"],
	RAID_CLASS_COLORS["SHAMAN"], RAID_CLASS_COLORS["SHAMAN"], RAID_CLASS_COLORS["SHAMAN"],
	RAID_CLASS_COLORS["WARRIOR"], RAID_CLASS_COLORS["WARRIOR"], RAID_CLASS_COLORS["WARRIOR"],
	RAID_CLASS_COLORS["WARLOCK"], RAID_CLASS_COLORS["WARLOCK"], RAID_CLASS_COLORS["WARLOCK"],
	RAID_CLASS_COLORS["MAGE"], RAID_CLASS_COLORS["MAGE"], RAID_CLASS_COLORS["MAGE"],
	RAID_CLASS_COLORS["ROGUE"], RAID_CLASS_COLORS["ROGUE"], RAID_CLASS_COLORS["ROGUE"],
	RAID_CLASS_COLORS["HUNTER"], RAID_CLASS_COLORS["HUNTER"], RAID_CLASS_COLORS["HUNTER"],
};

local localColorToID = VFL.invert(idToColor);

local _unsbTex = "Interface\\InventoryItems\\WoWUnknownItem01.blp";

local idToTexture = {};
idToTexture[1] = "Interface\\Icons\\Spell_Holy_PowerInfusion";
idToTexture[2] = "Interface\\Icons\\Spell_Holy_HolyBolt";
idToTexture[3] = "Interface\\Icons\\Spell_Shadow_ShadowWordPain";
idToTexture[4] = "Interface\\Icons\\Spell_Nature_Preservation";
idToTexture[5] = "Interface\\Icons\\Ability_Racial_BearForm";
idToTexture[6] = "Interface\\Icons\\Spell_Nature_HealingTouch";
idToTexture[7] = "Interface\\Icons\\Spell_Holy_HolyGuidance";
idToTexture[8] = "Interface\\Icons\\SPELL_HOLY_DEVOTIONAURA";
idToTexture[9] = "Interface\\Icons\\Spell_Holy_AuraOfLight";
idToTexture[10] = "Interface\\Icons\\Spell_Nature_Lightning";
idToTexture[11] = "Interface\\Icons\\Spell_Nature_LightningShield";
idToTexture[12] = "Interface\\Icons\\Spell_Nature_MagicImmunity";
idToTexture[13] = "Interface\\Icons\\Ability_MeleeDamage";
idToTexture[14] = "Interface\\Icons\\Ability_Warrior_InnerRage";
idToTexture[15] = "Interface\\Icons\\Ability_Warrior_DefensiveStance";
idToTexture[16] = "Interface\\Icons\\Spell_Shadow_DeathCoil";
idToTexture[17] = "Interface\\Icons\\Spell_Shadow_Metamorphosis";
idToTexture[18] = "Interface\\Icons\\Spell_Shadow_RainOfFire";
idToTexture[19] = "Interface\\Icons\\Spell_Arcane_Blast";
idToTexture[20] = "Interface\\Icons\\Spell_Fire_FlameBolt";
idToTexture[21] = "Interface\\Icons\\Spell_Frost_FrostBolt02";
idToTexture[22] = "Interface\\Icons\\Ability_Rogue_Eviscerate";
idToTexture[23] = "Interface\\Icons\\Ability_BackStab";
idToTexture[24] = "Interface\\Icons\\Ability_Rogue_MasterOfSubtlety";
idToTexture[25] = "Interface\\Icons\\Ability_Hunter_BeastTaming";
idToTexture[26] = "Interface\\Icons\\Ability_Marksmanship";
idToTexture[27] = "Interface\\Icons\\Ability_Hunter_SwiftStrike";

function VFL.GetIdSubClassByLocal(mt)
	return localsubclassToID[mt] or 0;
end

function VFL.GetLocalSubclassById(id)
	return idToLocalsubclass[id] or _unsubclass;
end

function VFL.GetColorSubClass(mt)
	local idn = VFL.GetSubClassID(mt);
	return idToColor[idn] or _unsbColor;
end

function VFL.GetColorSubClassById(id)
	return idToColor[id] or _unsbColor;
end

function VFL.GetTextureSubClass(mt)
	local idn = VFL.GetSubClassID(mt);
	return idToTexture[idn] or _unsbTex;
end

function VFL.GetTextureSubClassById(id)
	return idToTexture[id] or _unsbTex;
end


-----------------------------------------------
-- Talent ndata def
-----------------------------------------------

-- MainTalent is a number
RDX.Unit.GetMainTalent = function()
	return 0;
end;
RDX.Unit.SetMainTalent = VFL.Zero;
RDX.Unit.GetMainTalent = VFL.Zero;


RDXEvents:Bind("NDATA_CREATED", nil, function(ndata, name)
	local t = {};
	t.mainTalent = 0;
	ndata.GetMainTalent = function()
		return t.mainTalent;
	end;
	ndata.SetMainTalent = function(tname)
		t.mainTalent = tname;
	end;
	ndata:SetNField("subclass", t);
end);

--------------------------------------------------
-- bind
--------------------------------------------------

local function RPCSendSubClass()
	local t = {};
	local tabPSTmp = 0;
	local tabNameTmp = "";
	for i=1,GetNumTalentTabs() do
		local tabName, _, tabPS = GetTalentTabInfo(i);
		if tabPS > tabPSTmp then 
			tabPSTmp = tabPS;
			tabNameTmp = tabName;
		end;
	end;
	_, a = UnitClass("player");
	t.mainTalent = VFL.GetIdSubClassByLocal(a .. "_" .. tabNameTmp);
	RPC_Group:Flash("sync_SubClass", t);
end;

local function RPCSyncSubClass(ci, tabInfo)
	local unit = RPC.GetSenderUnit(ci);
	if (not unit) or (not unit:IsValid()) then return; end	
	unit.SetMainTalent(tabInfo.mainTalent);
	sig_unit_subclass:Raise(unit, unit.nid, unit.uid);
end

RPC_Group:Bind("sync_SubClass", RPCSyncSubClass);

------------------------------------------------
-- INIT
------------------------------------------------
RDXEvents:Bind("INIT_VARIABLES_LOADED", nil, function()
	VFL.ZMSchedule(5, function() RPCSendSubClass(); end);
	-- Start periodic broadcasts
	VFL.AdaptiveSchedule(nil, 120, RPCSendSubClass);
end);
------------------------------------------------
-- UNITFRAME
------------------------------------------------
--- Unit frame sub class icon
RDX.RegisterFeature({
	name = "ico_subclass";
	title = i18n("Subclass Icon");
	category = i18n("Icon");
	IsPossible = function(state)
		if not state:Slot("UnitFrame") then return nil; end
		if not state:Slot("Base") then return nil; end
		return true;
	end;
	ExposeFeature = function(desc, state, errs)
		if not desc then VFL.AddError(errs, i18n("Missing descriptor.")); return nil; end
		-- Verify our owner frame exists
		if (not desc.owner) or ((desc.owner ~= "Base") and (not state:Slot("Subframe_" .. desc.owner))) then
			VFL.AddError(errs, i18n("Owner frame does not exist.")); return nil;
		end
		local flg = true;
		flg = flg and __UFFrameCheck_Proto("Icon_", desc, state, errs);
		flg = flg and __UFAnchorCheck(desc.anchor, state, errs);
		if flg then state:AddSlot("Icon_" .. desc.name); end
		return flg;
	end;
	ApplyFeature = function(desc, state)
		local objname = "Icon_" .. desc.name;
		local flag = "false";
		if desc and desc.ukfilter then flag = "true";end;

		------------------ On frame creation
		local createCode = [[
local _t = VFLUI.CreateTexture(]] .. RDXUI.ResolveFrameReference(desc.owner) .. [[);
frame.]] .. objname .. [[ = _t;
_t:SetDrawLayer("]] .. (desc.drawLayer or "ARTWORK") .. [[");
_t:SetPoint(]] .. RDXUI.AnchorCodeFromDescriptor(desc.anchor) .. [[);
_t:SetWidth(]] .. desc.w .. [[); _t:SetHeight(]] .. desc.h .. [[);
_t:SetVertexColor(1,1,1,1);
_t:SetTexture("Interface\\InventoryItems\\WoWUnknownItem01.blp");
_t:Show();
]];
		state:Attach(state:Slot("EmitCreate"), true, function(code) code:AppendCode(createCode); end);

		------------------ On frame destruction.
		state:Attach(state:Slot("EmitDestroy"), true, function(code) code:AppendCode([[
VFLUI.ReleaseRegion(frame.]] .. objname .. [[);
frame.]] .. objname .. [[ = nil;
]]); end);
		state:Attach(state:Slot("EmitCleanup"), true, function(code) code:AppendCode([[
frame.]] .. objname .. [[:Hide();
]]); end);

		------------------ On paint.
		state:Attach(state:Slot("EmitPaint"), true, function(code) code:AppendCode([[

frame.]] .. objname .. [[:SetTexture(VFL.GetTextureSubClassById(unit.GetMainTalent()));
if ]] .. flag .. [[ and unit.GetMainTalent() == 0 then
	frame.]] .. objname .. [[:Hide();
else
	frame.]] .. objname .. [[:Show();
end;
]]); end);
		local mux = state:GetContainingWindowState():GetSlotValue("Multiplexer");
		mux:Event_MaskAll("UNIT_SUBCLASS", mux:GetPaintMask("SUBCLASS"));
		
		return true;
	end;
	UIFromDescriptor = function(desc, parent, state)
		local ui = VFLUI.CompoundFrame:new(parent);

		-- Name/width/height
		local ed_name, ed_width, ed_height = RDXUI.GenNameWidthHeightPortion(ui, desc);

		-- Owner
		local owner = RDXUI.MakeSlotSelectorDropdown(ui, i18n("Owner"), state, "Subframe_", true);
		if desc and desc.owner then owner:SetSelection(desc.owner); end

		-- Drawlayer
		local er = RDXUI.EmbedRight(ui, i18n("Draw layer:"));
		local drawLayer = VFLUI.Dropdown:new(er, RDXUI.DrawLayerDropdownFunction);
		drawLayer:SetWidth(100); drawLayer:Show();
		if desc and desc.drawLayer then drawLayer:SetSelection(desc.drawLayer); else drawLayer:SetSelection("ARTWORK"); end
		er:EmbedChild(drawLayer); er:Show();
		ui:InsertFrame(er);

		-- Anchor
		local anchor = RDXUI.UnitFrameAnchorSelector:new(ui); anchor:Show();
		anchor:SetAFArray(RDXUI.ComposeFrameList(state));
		if desc and desc.anchor then anchor:SetAnchorInfo(desc.anchor); end
		ui:InsertFrame(anchor);
		
		local chk_ukfilter = VFLUI.Checkbox:new(ui); chk_ukfilter:Show();
		chk_ukfilter:SetText(i18n("Hide unknown icon"));
		if desc and desc.ukfilter then chk_ukfilter:SetChecked(true); else chk_ukfilter:SetChecked(false); end
		ui:InsertFrame(chk_ukfilter);
		
		function ui:GetDescriptor()
			local name = ed_name.editBox:GetText();
			return { 
				feature = "ico_subclass", name = name, owner = owner:GetSelection();
				drawLayer = drawLayer:GetSelection();
				w = VFL.clamp(ed_width.editBox:GetNumber(), 0, 1000);
				h = VFL.clamp(ed_height.editBox:GetNumber(), 0, 1000);
				anchor = anchor:GetAnchorInfo();
				ukfilter = chk_ukfilter:GetChecked();
			};
		end

		return ui;
	end;
	CreateDescriptor = function()
		return { 
			feature = "ico_subclass", name = "rtai", owner = "Base", drawLayer = "ARTWORK";
			w = 14; h = 14;
			anchor = { lp = "TOPLEFT", af = "Base", rp = "TOPLEFT", dx = 0, dy = 0};
		};
	end;
});

---------------------------------------------------------------
-- Match subclasses
---------------------------------------------------------------
RDX.RegisterFilterComponent({
	name = "subclasses", title = i18n("Subclasses..."), category = i18n("Group Composition"),
	UIFromDescriptor = function(desc, parent)
		-- Setup the base frame and the checkboxes for subclasses
		local ui = RDXUI.FilterDialogFrame:new(parent);
		ui:SetText(i18n("Subclasses..."));
		local checks = VFLUI.CheckGroup:new(ui);
		ui:SetChild(checks);
		checks:SetLayout(28, 2);
		-- Populate checkboxes
		for i=1,27 do 
			checks.checkBox[i]:SetText(strtcolor(VFL.GetColorSubClassById(i)) .. VFL.GetLocalSubclassById(i) .. "|r"); 
			if desc[i + 1] then checks.checkBox[i]:SetChecked(true); end
		end
		checks.checkBox[28]:SetText(strcolor(.5,.5,.5) .. i18n("Unknown|r"));
		if desc[29] then checks.checkBox[28]:SetChecked(true); end

		ui.GetDescriptor = function(x)
			local ret = {"subclasses"};
			for i=1,28 do
				if checks.checkBox[i]:GetChecked() then ret[i+1] = true; else ret[i+1] = nil; end
			end
			return ret;
		end
		return ui;
	end,
	GetBlankDescriptor = function() return {"subclasses"}; end,
	FilterFromDescriptor = function(desc, metadata)
		-- Build the filtration array
		local v = RDX.GenerateFilterUpvalue();
		local script = v .. "={};";
		for i=2,28 do
			if desc[i] then script = script .. v .. "[" .. i-1 .. "]=true;"; end
		end
		if desc[29] then script = script .. v .. "[0]=true;"; end
		table.insert(metadata, { class = "CLOSURE", name = v, script = script });
		-- Now, our filter expression is just a check on the closure array against the unit's subclass number.
		return "(" .. v .. "[unit.GetMainTalent()])";
	end,
	ValidateDescriptor = VFL.True,
	EventsFromDescriptor = function(desc, metadata)
		RDX.FilterEvents_FullUpdate(metadata, "ROSTER_UPDATE");
		RDX.FilterEvents_FullUpdate(metadata, "UNIT_SUBCLASS");
	end,
	SetsFromDescriptor = VFL.Noop,
});
