-- Metadata_Cooldowns.lua
--
-- Definitions for common cooldowns from WoW.

Logistics.RegisterSpellBasedCooldown("manat", i18n("Mana Tap"), 30, "Interface\Icons\Spell_Arcane_ManaTap");

-- Druid
Logistics.RegisterSpellBasedCooldown("inn", i18n("Innervate"), 6*60, "Interface\\Icons\\Spell_Nature_Lightning");
Logistics.RegisterSpellBasedCooldown("reb", i18n("Rebirth"), 30*60, "Interface\\Icons\\Spell_Nature_Reincarnation");
Logistics.RegisterSpellBasedCooldown("chalr", i18n("Challenging Roar"), 10*60, "Interface\\Icons\\Ability_Druid_ChallangingRoar");

-- Priest
Logistics.RegisterSpellBasedCooldown("pi", i18n("Power Infusion"), 3*60, "Interface\\Icons\\Spell_Holy_PowerInfusion");
Logistics.RegisterSpellBasedCooldown("lolwell", i18n("Lightwell"), 6*60, "Interface\\Icons\\Spell_Holy_SummonLightwell");
Logistics.RegisterSpellBasedCooldown("fw", i18n("Fear Ward"), 3*60, "Interface\\Icons\\Spell_Holy_Excorcism");
Logistics.RegisterSpellBasedCooldown("sp", i18n("Pain Suppression"), 2*60, "Interface\\Icons\\Spell_Holy_PainSupression");
Logistics.RegisterSpellBasedCooldown("sf", i18n("Shadowfiend"), 5*60, "Interface\\Icons\\Spell_Shadow_Shadowfiend");

-- Warrior
Logistics.RegisterSpellBasedCooldown("chal", i18n("Challenging Shout"), 10*60, "Interface\\Icons\\Ability_BullRush");
Logistics.RegisterSpellBasedCooldown("sw", i18n("Shield Wall"), 30*60, "Interface\\Icons\\Ability_Warrior_ShieldWall");
Logistics.RegisterSpellBasedCooldown("ret", i18n("Retaliation"), 30*60, "Interface\\Icons\\Ability_Warrior_Challange");
Logistics.RegisterSpellBasedCooldown("ls", i18n("Last Stand"), 8*60, "Interface\\Icons\\Spell_Holy_AshesToAshes");
Logistics.RegisterSpellBasedCooldown("shbash", i18n("Shield Bash"), 12, "Interface\\Icons\\Ability_Warrior_ShieldBash");
Logistics.RegisterSpellBasedCooldown("pummel", i18n("Pummel"), 10);
Logistics.RegisterQuasiSpellCooldown("lgg", i18n("Lifegiving Gem"), i18n("Gift of Life"), 5*60);
Logistics.RegisterSpellBasedCooldown("int", i18n("Intervene"), 30, "Interface\\Icons\\Ability_Warrior_VictoryRush");


-- Shaman
Logistics.RegisterSpellBasedCooldown("mtt", i18n("Mana Tide Totem"), 5*60, "Interface\\Icons\\Spell_Frost_SummonWaterElemental");
Logistics.RegisterSpellBasedCooldown("ns", i18n("Nature's Swiftness"), 3*60);
Logistics.RegisterSpellBasedCooldown("hero", i18n("Heroism"), 10*60, "Interface\\Icons\\Ability_Shaman_Heroism");
Logistics.RegisterSpellBasedCooldown("bl", i18n("Bloodlust"), 10*60, "Interface\\Icons\\Spell_Nature_BloodLust");
Logistics.RegisterSpellBasedCooldown("eshock", i18n("Earth Shock"), 6, "Interface\\Icons\\Spell_Nature_EarthShock");

-- Paladin
Logistics.RegisterSpellBasedCooldown("loh", i18n("Lay on Hands"), 60*60, "Interface\\Icons\\Spell_Holy_LayOnHands");
Logistics.RegisterSpellBasedCooldown("di", i18n("Divine Intervention"), 60*60, "Interface\\Icons\\Spell_Nature_TimeStop");
Logistics.RegisterSpellBasedCooldown("bop", i18n("Blessing of Protection"), 5*60, "Interface\\Icons\\Spell_Holy_SealOfProtection");

-- Hunter
Logistics.RegisterSpellBasedCooldown("mis", i18n("Misdirection"), 2*60, "Interface\\Icons\\Ability_Hunter_Misdirection");
--Interface\Icons\Ability_GolemStormBolt

-- Mage
Logistics.RegisterSpellBasedCooldown("cs", i18n("Counterspell"), 30, "Interface\\Icons\\Spell_Frost_IceShock");

-- Rogue
Logistics.RegisterSpellBasedCooldown("kick", i18n("Kick"), 10, "Interface\\Icons\\Ability_Kick");

-- Soulstone
Logistics.RegisterCooldown({
	name = "ss";
	title = i18n("Soulstone");
	icon = "Interface\\Icons\\Spell_Shadow_SoulGem";
	_timer = -1;
	Initialize = VFL.Noop;
	IsPossible = function()
		local _,c = UnitClass("player");
		if(c == "WARLOCK") then return true; end
	end;
	Activate = function(self)
		Logistics._RegisterForUSS(self, i18n("Soulstone Resurrection"));		
	end;
	CooldownUsed = function(self)
		self._timer = GetTime() + 1800;
	end;
	GetValue = function(self)
		if self._timer < 0 then
			return -1,1800;
		else
			return VFL.clamp(self._timer - GetTime(), 0, 1800), 1800;
		end
	end;
});

-- Reinc
Logistics.RegisterCooldown({
	name = "reinc"; title = i18n("Reincarnation");
	icon = "Interface\\Icons\\Spell_Nature_AgitatingTotem";
	_timer = -1;
	Initialize = VFL.Noop;
	IsPossible = function()
		local _,c = UnitClass("player");
		if (c == "SHAMAN") then return true; end
	end;
	Activate = function(self)
		self._rank = VFL.GetPlayerTalentRank(i18n("Improved Reincarnation"));
		hooksecurefunc("UseSoulstone", function()
			if HasSoulstone() == i18n("Reincarnation") then self:CooldownUsed();	end
		end);
	end;
	CooldownUsed = function(self)
		self._timer = GetTime() + 3600 - (10 * self._rank);
	end;
	GetValue = function(self)
		if self._timer < 0 then
			return -1, 3600 - (10 * self._rank);
		else
			return VFL.clamp(self._timer - GetTime(), 0, 3600), 3600 - (10 * self._rank);
		end
	end;
});

