-- Module.lua
-- RDX - Raid Data Exchange
-- (C)2006 Raid Informatics
--
-- The RDXM_Debug base module
RDXM_Debug = RegisterVFLModule({
	name = "Debug";
	title = "Debug";
	description = "Debugging functionality for RDX6.";
	parent = RDX;
});
RDXM_Debug:LoadVersionFromTOC("RDX6_Debug");

local function TheDebugMenu(menu, cell)
	local mnu = {};
	table.insert(mnu, {text = "Set debugger", OnClick = function() RDXM_Debug.SetDebugger(); menu:Release(); end});
	table.insert(mnu, {text = "Disrupt", OnClick = function() RDX._Disrupt(); menu:Release(); end});
	menu:Expand(cell, mnu);
end

RDXEvents:Bind("INIT_VARIABLES_LOADED", nil, function()
	RDX.RegisterMainMenuEntry("Debug", true, TheDebugMenu);
end);

local function Breakdown(str, n)
	local ret, i = {}, 1;
	while str and string.len(str) > 0 do
		ret[i] = string.sub(str, 1, n);
		str = string.sub(str, n+1, -1);
		i=i+1;
	end
	return ret;
end

-- Serialized form viewer for objects
RDXDB.RegisterObjectMenuHandler(function(mnu, opath, dialog)
	table.insert(mnu, {
		text = "Serialized form"; 
		OnClick = function()
			VFL.poptree:Release();
			VFL.print("-------------------------------");
			local tbl = Breakdown(Serialize(RDXDB.GetObjectData(opath)), 50);
			for _,v in ipairs(tbl) do VFL.print(v); end
			VFL.print("-------------------------------");
		end;
	});
end);
