-- CompilerCache.lua
-- RDX - Raid Data Exchange
-- (C)2006 Raid Informatics
--
-- A system for storing compiled code generated by RDX internals and retrieving
-- it for later viewing.
local ccCache = {};

-- Store the cache for public access
RDXM_Debug.ccCache = ccCache;

function RDXM_Debug.StoreCompiledObject(key, value)
	ccCache[key] = value;
end

-- Register a menu hook to view compiled code on path entries that have it.
RDXDB.RegisterObjectMenuHandler(function(mnu, opath, dialog)
	if ccCache[opath] then
		local x = tostring(ccCache[opath]);
		table.insert(mnu, {
			text = "View Compiled Code...";
			OnClick = function() VFL.poptree:Release(); VFL.Debug_ShowCode(x);	end;
		});
	end
end);
