﻿-- Author      : Apoco
-- Create Date : 4/8/2008 4:40:17 PM
if select(2, UnitClass("player")) ~= "HUNTER" or not RBM then return end

local module = RBM:NewPlugin("Trap Watch")
local player = UnitName("player")

local L = module:GetTranslations()
module:RegisterTranslations("enUS", -- translation automatically generated
	"Freezing Trap", true,
	"Freezing Trap Effect", true,
	"Freezing Trap: Announce", true,
	"Freezing Trap: Announce Cooldown", true,
	"Freezing Trap: Active", true,
	"Trapped", true,
	"Active", true,
	"%s is trapped!", true,
	"%s trap broke!", true
)

module:RegisterTranslations("zhTW", -- translation automatically generated
	"Freezing Trap", "冰凍陷阱",
	"Freezing Trap Effect", "冰凍陷阱效果",
	"Freezing Trap: Announce", "冰凍陷阱：通報",
	"Freezing Trap: Announce Cooldown", "冰凍陷阱：通報冷卻",
	"Freezing Trap: Active", "冰凍陷阱：啟動",
	"Trapped", "陷阱成功",
	"Active", "啟動",
	"%s is trapped!", "%s被陷阱控制!",
	"%s trap broke!", "%s的陷阱被打破!"
)

module:RegisterTranslations("koKR",
	"Freezing Trap", "얼음의 덫",
	"Freezing Trap Effect", "얼음의 덫",
	"Freezing Trap: Announce", "얼음의 덫: 알림",
	"Freezing Trap: Announce Cooldown", "얼음의 덫: 대기시간 알림",
	"Freezing Trap: Active", "얼음의 덫: 활성화",
	"Trapped", "덫",
	"Active", "활성화",
	"%s is trapped!", "%s 덫!",
	"%s trap broke!", "%s 덫 깨짐!"
)

module:RegisterTranslations("zhCN", -- translation automatically generated
	"Freezing Trap", "冰冻陷阱",
	"Freezing Trap Effect", "冰冻陷阱效果",
	"Freezing Trap: Announce", "冰冻陷阱：通报",
	"Freezing Trap: Announce Cooldown", "冰冻陷阱：通报冷却",
	"Freezing Trap: Active", "冰冻陷阱：激活",
	"Trapped", "陷阱成功",
	"Active", "激活",
	"%s is trapped!", "%s被陷阱控制！",
	"%s trap broke!", "%s的陷阱被打破！"
)

function module:OnInitialize()
	self:RegisterToggles(L["Freezing Trap: Announce"], false,
						 L["Freezing Trap: Announce Cooldown"], false
						 )

	self:RegisterCategory(L["Freezing Trap: Active"], L["Freezing Trap: Active"], 0.7, 0.4, 0.7)
	self:RegisterCategory(L["Trapped"], L["Trapped"], 0.3, 0.3, 1.0)
end

function module:OnEnable()
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	self:RegisterEvent("PLAYER_TARGET_CHANGED", "UpdateDebuffs", nil, self, "target")
	self:RegisterEvent("PLAYER_FOCUS_CHANGED", "UpdateDebuffs", nil, self, "focus")
	self.ActiveTrap = self:CreateLabel(L["Freezing Trap"], L["Active"])
	self.trapped = false
end

function module:UpdateDebuffs(self, unit)
	local name = UnitName(unit)
	if not name then 
		return 
	end
	
	local label = self:CreateLabel(L["Trapped"], name)
	if self:IsBarActive(label) then
		local i = 1
		while UnitDebuff(unit, i) do
			local aura, _, texture, _, _, duration, remaining = UnitDebuff(unit, i)
			if duration and aura == L["Freezing Trap Effect"] then
				if self:GetBarTimeLeft(label) + .1 < remaining then
					self:SetBarCurrentTime(label, remaining, false)
					if self:IsBarActive(self.ActiveTrap) then
						self:CancelBar(self.ActiveTrap)
					end
				end
			end
			i = i + 1
		end
	end
end

function module:COMBAT_LOG_EVENT_UNFILTERED(_, _, event, _, sourceName, _, _, name, _, id)
	if event == "SPELL_CREATE" and sourceName == player and id == 14311 then
		self:LocalTimedBar(self.ActiveTrap, L["Freezing Trap: Active"], 60, "Spell_Frost_ChainsOfIce")
		if self:CheckToggle(L["Freezing Trap: Announce Cooldown"]) then
			self:ScheduleTimer(function()
				SendChatMessage(L["Trap Usable in ~10 Seconds"], "PARTY")
			end, 50)
		end
		self.trapped = true
		--[[self:AddTimer(60, function()
			trapped = false
		end)]]
		self:ScheduleTimer(function() self.trapped = false end, 60)
		
	elseif event == "SPELL_AURA_APPLIED" and name and id == 14309 and self.trapped then
		if self:IsBarActive(self.ActiveTrap) then
			self:CancelBar(self.ActiveTrap)
		end
		self:LocalTimedBar(self:CreateLabel(L["Trapped"], name), L["Trapped"], 20, "Spell_Frost_ChainsOfIce", true)
		if self:CheckToggle(L["Freezing Trap: Announce"]) then
			SendChatMessage(string.format(L["%s is c!"], name), "PARTY")
		end
	
	elseif event == "SPELL_AURA_REMOVED" and name and id == 14309 and self.trapped then
		local label = self:CreateLabel(L["Trapped"], name)
		if label then
			if self:IsBarActive(label) then
				self:CancelBar(label)
				self:Alert("Normal", "*** Freezing Trap BROKE! ***")
				if self:CheckToggle(L["Freezing Trap: Announce"]) then
					SendChatMessage(string.format(L["%s trap broke!"], name), "PARTY")
				end
			end
		end
		self.trapped = false
	end
end