if select(2, UnitClass("player")) ~= "SHAMAN" or not RBM then return end

local GetPlayerBuffApplications = GetPlayerBuffApplications
local GetTime = GetTime
local GetNetStats = GetNetStats
local select = select
local stopUpdatingWF
local totemGUID = {}
local playerGUID

local WindfuryTotem
local windfuryLst
local MediaHandler = LibStub("LibSharedMedia-3.0")--#NO_LOCALIZE

local module = RBM:NewPlugin("Totem Watch")
local L = module:GetTranslations()

module:RegisterTranslations("enUS", -- translation automatically generated
	"Air Totems", true,
	"Bar that times the duration of windfury totem enchantment.", true,
	"Custom frame", true,
	"Displays a message in the center of the screen when Water Shield expires.", true,
	"Earth Totems", true,
	"Enamored Water Spirit", true,
	"Enter the message you want displayed and press enter.", true,
	"Fire Totems", true,
	"Font", true,
	"Font color", true,
	"Font size", true,
	"Interface\\Icons\\(.+)", true,
	"Lock custom frame", true,
	"Locks the custom frame in place.", true,
	"Mana Spring Totem", true,
	"Missing Water Shield", true,
	"No Water Shield!", true,
	"Options specific to Water Shield.", true,
	"Pulse", true,
	"Rank 1", true,
	"Rank 2", true,
	"Rank 3", true,
	"Rank 4", true,
	"Rank 5", true,
	"Rank 6", true,
	"Rank 7", true,
	"Sets the custom frame font size.", true,
	"Sets the custom frame font.", true,
	"Sets the font color of the Water Shield frame.", true,
	"Show Water Shield message", true,
	"Shows a bar that keeps track of the charges left on your Water Shield buff.", true,
	"Shows a bar when you're missing the Water Shield buff.", true,
	"Stoneclaw Totem", true,
	"The internal cooldown of windfury weapon buff.", true,
	"The message that should be displayed when Water Shield expires.", true,
	"Totem timers", true,
	"Totem timers for air totems.", true,
	"Totem timers for earth totems.", true,
	"Totem timers for fire totems.", true,
	"Totem timers for water totems.", true,
	"Totemic Call", true,
	"Tracks the Windfury totem enchantment duration.", true,
	"Tracks the duration of each totem placed.", true,
	"Tracks the internal cooldown on Windfury weapon.", true,
	"Uses a custom frame for the Water Shield alert instead of the default RBM alert.", true,
	"Water Shield", true,
	"Water Shield bar that keeps track of the buff and charges left.", true,
	"Water Shield charges", true,
	"Water Shield expired!", true,
	"Water Shield message", true,
	"Water Totems", true,
	"Watershield", true,
	"Windfury :: Cooldown", true,
	"Windfury Cooldown", true,
	"Windfury Pulse", true,
	"Windfury Totem", true,
	"Windfury cooldown", true,
	"Windfury totem pulses", true,
	"[crh]its (.-) ?[IV]- for (%d+)%.$", true,
	"^Your Windfury Attack", true
)

module:RegisterTranslations("koKR",
	"Air Totems", "바람의 토템",
	"Bar that times the duration of windfury totem enchantment.", "질풍의 토템의 부여된 효과 지속시간 바입니다.",
	"Custom frame", "사용자 프레임",
	"Displays a message in the center of the screen when Water Shield expires.", "물의 보호막이 끝나면 화면 중앙에 메세지를 표시합니다.",
	"Earth Totems", "대지의 토템",
	"Enamored Water Spirit", "물 정령의 선물",
	"Enter the message you want displayed and press enter.", "원하는 표시와 메세지를 입력합니다.",
	"Fire Totems", "불의 토템",
	"Font", "글꼴",
	"Font color", "글꼴 색상",
	"Font size", "글꼴 크기",
	"Interface\\Icons\\(.+)", true,
	"Lock custom frame", "사용자 프레임 잠금",
	"Locks the custom frame in place.", "사용자 프레임의 위치를 잠급니다.",
	"Mana Spring Totem", "마나샘 토템",
	"Missing Water Shield", "물의 보호막 보이지 않음",
	"No Water Shield!", "물의 보호막 없음!",
	"Options specific to Water Shield.", "물의 보호막 세부 설정",
	"Pulse", "맥박",
	"Rank 1", "1 레벨",
	"Rank 2", "2 레벨",
	"Rank 3", "3 레벨",
	"Rank 4", "4 레벨",
	"Rank 5", "5 레벨",
	"Rank 6", "6 레벨",
	"Rank 7", "7 레벨",
	"Sets the custom frame font size.", "사용자 프레임의 글꼴 크기를 설정합니다.",
	"Sets the custom frame font.", "사용자 프레임의 글꼴을 설정합니다.",
	"Sets the font color of the Water Shield frame.", "물의 보호막 프레임의 글꼴 색상을 설정합니다.",
	"Show Water Shield message", "물의보호막 메세지 보기",
	"Shows a bar that keeps track of the charges left on your Water Shield buff.", "물의 보호막 버프 남은 충전을 추적하여 바에 보여줍니다.",
	"Shows a bar when you're missing the Water Shield buff.", "없어진 물의 보호막 버프 바를 보여줍니다.",
	"Stoneclaw Totem", "돌발톱 토템",
	"The internal cooldown of windfury weapon buff.", "질풍의 무기 버프의 재사용 대기시간입니다.",
	"The message that should be displayed when Water Shield expires.", "물의 보호막이 끝나면 해당 메세지가 표시됩니다.",
	"Totem timers", "토템 시간",
	"Totem timers for air totems.", "바람의 토템에 토템 시간입니다.",
	"Totem timers for earth totems.", "대지의 토템에 토템 시간입니다.",
	"Totem timers for fire totems.", "불의 토템에 토템 시간입니다.",
	"Totem timers for water totems.", "물의 토템에 토템 시간입니다.",
	"Totemic Call", "토템의 부름",
	"Tracks the Windfury totem enchantment duration.", "질풍의 토템의 부여된 효과 지속을 추적합니다.",
	"Tracks the duration of each totem placed.", "확인된 각 토템의 지속을 추적합니다.",
	"Tracks the internal cooldown on Windfury weapon.", "질풍의 무기의 재사용 대기시간을 추적합니다.",
	"Uses a custom frame for the Water Shield alert instead of the default RBM alert.", "물의 보호막 경고를 기본 RBM 경보에 대신해 사용자 프레임에 사용합니다.",
	"Water Shield", "물의 보호막",
	"Water Shield bar that keeps track of the buff and charges left.", "물의 보호막 바의 추적한 버프와 남은 충전입니다.",
	"Water Shield charges", "물의 보호막 충전",
	"Water Shield expired!", "물의 보호막 끝남!",
	"Water Shield message", "물의 보호막 메세지",
	"Water Totems", "물의 토템",
	"Watershield", "물의 보호막",
	"Windfury :: Cooldown", "질풍 :: 재사용 대기시간",
	"Windfury Cooldown", "질풍 재사용 대기시간",
	"Windfury Pulse", "질풍 맥박",
	"Windfury Totem", "질풍의 토템",
	"Windfury cooldown", "질풍 재사용 대기시간",
	"Windfury totem pulses", "질풍의 토템 맥박",
	"[crh]its (.-) ?[IV]- for (%d+)%.$", "[crh]its (.-) ?[IV]- for (%d+)%.$",
	"^Your Windfury Attack", "^당신은 질풍의 공격으로"
)

local WINDFURY_PULSE_LABEL

local totemCategory, totemIcons, totemTimes, totemRankedTimes, totemHP
local BuildTotems, UpdateEvents
local WSFrame

local db
function module:OnInitialize()
	self:RegisterCategory(L["Air Totems"], L["Totem timers for air totems."], .8, .7, .9)
	self:RegisterCategory(L["Earth Totems"], L["Totem timers for earth totems."], .4, .21, .13)
	self:RegisterCategory(L["Fire Totems"], L["Totem timers for fire totems."], .9, .2, .2)
	self:RegisterCategory(L["Water Totems"], L["Totem timers for water totems."], .25, .25, .8)

	self:RegisterCategory(L["Windfury Cooldown"], L["The internal cooldown of windfury weapon buff."], .7, .9, .7)
	self:RegisterCategory(L["Windfury Pulse"], L["Bar that times the duration of windfury totem enchantment."], .7, .1, .7)

	self:RegisterCategory(L["Water Shield"], L["Water Shield bar that keeps track of the buff and charges left."], .2, .2, 1)
	self:RegisterCategory(L["No Water Shield"], L["Water Shield bar that alerts you when your buff has expired."], .2, .2, 1)

	WINDFURY_PULSE_LABEL = self:CreateLabel(L["Windfury Totem"], L["Pulse"])

	self.db:RegisterDefaults({
		profile = {
			WindfuryTotem = true,
			WaterShieldCharges = true,
			TotemTimers = true,
			WindfuryCooldown = true,
			MissingWaterShield = true,
			ShowWaterShieldMessage = true,
			WaterShieldMessage = L["Water Shield expired!"],
			WaterShieldOwnFrame = false,
			WaterShieldFrameLocked = false,
			WaterShieldFrameFont = "Arial Narrow",--#NO_LOCALIZE
			WaterShieldFrameFontSize = 18,
			Red = 1,
			Blue = .5,
			Green = .2,
		},
	})
	local function IsHidden()
		return not db
	end
	local function SetOption(info, value, value2)
		db[info[#info]] = value
		UpdateEvents()
	end
	local function GetOption(info, value)
		if value then
			return db[info[#info]][value]
		end
		return db[info[#info]]
	end
	local function NotWSOwnFrame()
		return IsHidden() or not db.ShowWaterShieldMessage or not db.WaterShieldOwnFrame 
	end

	self:SetOptionsTable{
		args = {
			WaterShield = {
				type = "group",
				name = L["Watershield"],
				desc = L["Options specific to Water Shield."],
				inline = true,
				order = 60,
				get = GetOption,
				set = SetOption,
				hidden = IsHidden,
				args = {
					MissingWaterShield = {
						type = "toggle",
						name = L["Missing Water Shield"],
						desc = L["Shows a bar when you're missing the Water Shield buff."],
						order = 10,
					},
					WaterShieldCharges = {
						type = "toggle",
						name = L["Water Shield charges"],
						desc = L["Shows a bar that keeps track of the charges left on your Water Shield buff."],
						order = 20,
					},
					ShowWaterShieldMessage = {
						type = "toggle",
						name = L["Show Water Shield message"],
						desc = L["Displays a message in the center of the screen when Water Shield expires."],
						order = 30,
					},
					WaterShieldMessage = {
						type = "input",
						name = L["Water Shield message"],
						desc = L["The message that should be displayed when Water Shield expires."],
						disabled = function() return not db.ShowWaterShieldMessage end,
						usage = L["Enter the message you want displayed and press enter."],
						order = 40,
					},
					WaterShieldOwnFrame = {
						type = "toggle",
						name = L["Custom frame"],
						desc = L["Uses a custom frame for the Water Shield alert instead of the default RBM alert."],
						disabled = function() return not db.ShowWaterShieldMessage end,
						order = 50,
					},
					WaterShieldFrameLocked = {
						type = "toggle",
						name = L["Lock custom frame"],
						desc = L["Locks the custom frame in place."],
						hidden = NotWSOwnFrame,
						order = 60,
					},
					WaterShieldFrameFont = {
						type = "select",
						name = L["Font"],
						desc = L["Sets the custom frame font."],
						values = MediaHandler:List("font"), --#NO_LOCALIZE
						hidden = NotWSOwnFrame,
						order = 70,
					},
					WaterShieldFrameFontSize = {
						type = "range",
						name = L["Font size"],
						desc = L["Sets the custom frame font size."],
						min = 5,
						max = 24,
						step = 1,
						bigStep = 1,
						hidden = NotWSOwnFrame,
						order = 75,
					},
					FontColor = {
						type = "color",
						name = L["Font color"],
						desc = L["Sets the font color of the Water Shield frame."],
						set = function(r, g, b)
							db.Red = r
							db.Green = g
							db.Blue = b
							UpdateEvents()
						end,
						get = function()
							return db.Red, db.Green, db.Blue
						end,
						hidden = NotWSOwnFrame,
						order = 80,
					},
					
				},
			},
			WindfuryCooldown = {
				type = "toggle",
				name = L["Windfury cooldown"],
				desc = L["Tracks the internal cooldown on Windfury weapon."],
				get = GetOption,
				set = SetOption,
				hidden = IsHidden,
				order = 20,
			},
			WindfuryTotem = {
				type = "toggle",
				name = L["Windfury totem pulses"],
				desc = L["Tracks the Windfury totem enchantment duration."],
				get = GetOption,
				set = SetOption,
				hidden = IsHidden,
				order = 30,
			},
			TotemTimers = {
				type = "toggle",
				name = L["Totem timers"],
				desc = L["Tracks the duration of each totem placed."],
				get = GetOption,
				set = SetOption,
				hidden = IsHidden,
				order = 40,
			},
		},
	}
end


function module:OnEnable()
	db = self.db.profile
	self:UpgradeProfiles()
	playerGUID = UnitGUID("player")
	if BuildTotems then
		BuildTotems()
		BuildTotems = nil
	end
	if not UpdateEvents then
		function UpdateEvents()
			if db.WindfuryTotem or db.TotemTimers then
				self:RegisterEvent("PLAYER_DEAD", "CancelAllTotems")
				self:RegisterEvent("PLAYER_ENTERING_WORLD", "CancelAllTotems")
				self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
				if not totemIcons then
					totemIcons = setmetatable({[L["Enamored Water Spirit"]] = "INV_Wand_01"}, {__index = function(self, key)
						self[key] = GetSpellTexture(key):match(L["Interface\\Icons\\(.+)"])
						return self[key]
					end,})
					
				end
				if not lastCategory then
					lastCategory = {}
				end
				if not totemHP then
					totemHP = {}
				end
				self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
			else
				self:UnregisterEvent("PLAYER_DEAD")
				self:UnregisterEvent("PLAYER_ENTERING_WORLD")
				self:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
				totemIcons = nil
				lastCategory = nil
				totemHP = nil
				
			end
			if not db.WindfuryTotem then
				self:CancelTimer(WindfuryTotem, true)
				self:CancelBar(WINDFURY_PULSE_LABEL)
			end
			if not db.TotemTimers then
				self:CancelAllTotems()
			end
			if db.WaterShieldCharges or db.MissingWaterShield or db.ShowWaterShieldMessage then
				self:RegisterEvent("PLAYER_AURAS_CHANGED")
			else
				self:UnregisterEvent("PLAYER_AURAS_CHANGED")
			end
			if not db.MissingWaterShield then
				self:CancelBar(L["No Water Shield!"], false)
			end
			if not db.WaterShieldCharges then
				self:CancelBar(L["Water Shield"], false)
			end
			if db.WindfuryCooldown then
				self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
			else
				self:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERERD")
			end
			if db.WaterShieldOwnFrame then
				if not WSFrame then
					local f = CreateFrame("Frame", nil, UIParent)
					WSFrame = f
					local fs = f:CreateFontString()

					f:SetMovable(true)
					fs:SetPoint("CENTER", f, 0, 0)
					f.Text = fs
					f:SetScript("OnMouseDown", f.StartMoving)
					f:SetScript("OnMouseUp", function(self)
						self:StopMovingOrSizing()
						db.WaterShieldX, db.WaterShieldY = self:GetCenter()
					end)
				end
				if db.WaterShieldFrameLocked then
					WSFrame:SetBackdrop(nil)
					WSFrame:EnableMouse(false)
				else
					WSFrame:SetBackdrop{bgFile = [[Interface/Tooltips/UI-Tooltip-Background]]}
					WSFrame:EnableMouse(true)
				end
				local fs = WSFrame.Text
				fs:SetFont(MediaHandler:Fetch("font", db.WaterShieldFrameFont), db.WaterShieldFrameFontSize)--#NO_LOCALIZE
				fs:SetTextColor(db.Red, db.Green, db.Blue)
				fs:SetText(db.WaterShieldMessage)

				WSFrame:SetWidth(fs:GetWidth())
				WSFrame:SetHeight(fs:GetHeight())

				if not db.WaterShieldX then
					db.WaterShieldX = GetScreenWidth() / 2
				end
				if not db.WaterShieldY then
					db.WaterShieldY = GetScreenHeight() / 2
				end
				WSFrame:SetPoint("BOTTOM", UIParent, "BOTTOMLEFT", db.WaterShieldX, db.WaterShieldY - WSFrame:GetHeight() / 2)
			else
				if WSFrame then
					WSFrame:Hide()
				end
			end
			self:PLAYER_AURAS_CHANGED(true)
			
		end
	end
	
	UpdateEvents()
end

function module:OnDisable()
	db = nil
	lastCategory = nil
	totemIcons = nil
	totemHP = nil

end

--[[do
	local wfCD = GetTime()
	function module:CHAT_MSG_SPELL_SELF_DAMAGE(_, _, msg) --TODO: Update for 2.4
		if msg:match(L["^Your Windfury Attack"]) then
			local now = GetTime()
			if wfCD < now then
				wfCD = now + 3
				self:LocalTimedBar(L["Windfury :: Cooldown"], L["Windfury Cooldown"], 3, "Spell_Nature_Cyclone", true)
			end
		end
	end
end]]


function module:UpdateWindfuryTotem()
	if GetTime() > stopUpdatingWF then
		if self.wfTotemTimer then
			self:CancelTimer(self.wfTotemTimer, true)
		end
	else
		self:SetBarTime(WINDFURY_PULSE_LABEL, 10, false)
	end
end

function module:COMBAT_LOG_EVENT_UNFILTERED(_, _, event, srcGUID, srcName, srcFlags, destGUID, destName, destFlags, id, idName, c, d, e)
	if event == "SPELL_SUMMON" and srcGUID == playerGUID and totemLst[id] then
		if db.TotemTimers then
			local category = totemLst[id].type
			local lastSpell = lastCategory[category]
			if lastSpell and self:IsBarActive(lastSpell) then
				self:CancelBar(lastSpell)
			end
			self:LocalTimedBar(
				destName,
				category,
				totemLst[id].dur or 120,
				id,
				true
			)

			totemGUID[destGUID] = destName
			lastCategory[category] = destName
			if category == L["Air Totems"] then
				if self.wfTotemTimer then
					self:CancelTimer(self.wfTotemTimer, true)
				end
			end
		end	
		if windfuryLst[id] and db.WindfuryTotem then
			local latency = 2 * select(3, GetNetStats()) / 1000 --very rough estimate
			self:LocalTimedBar(WINDFURY_PULSE_LABEL, L["Windfury Pulse"], 10 - latency, "Spell_Nature_Windfury")
			self:ScheduleTimer(function() 
				self.wfTotemTimer = self:ScheduleRepeatingTimer("UpdateWindfuryTotem", 5) 
			end, latency)
			stopUpdatingWF = 120 + GetTime()
		end

	elseif event == "SPELL_CAST_SUCCESS" and id == 36936 and srcGUID == playerGUID then
		self:CancelAllTotems()

	elseif (event == "PARTY_KILL" or event == "UNIT_DIED") and totemGUID[destGUID] then
		self:CancelBar(totemGUID[destGUID])
		totemGUID[destGUID] = nil
	
	elseif event == "SPELL_DAMAGE" and id == 25504 and srcGUID == playerGUID then
		self:CancelBar(L["Windfury :: Cooldown"], false)
		self:LocalTimedBar(L["Windfury :: Cooldown"], L["Windfury Cooldown"], 3, "Spell_Nature_Cyclone", true)
	end
end

do
	local lastStacks
	function module:PLAYER_AURAS_CHANGED(reset)
		local stacks = GetPlayerBuffApplications(L["Water Shield"])
		if reset ~= true and lastStacks == stacks then
			return --no need to update without a change
		end
		if stacks == 0 then
			if self:IsBarActive(L["Water Shield"]) then
				self:CancelBar(L["Water Shield"], false)
			end
			if db.MissingWaterShield then
				self:LocalTimelessBar(L["No Water Shield!"], L["No Water Shield"], "Ability_Shaman_WaterShield")
			end
			if db.ShowWaterShieldMessage then
				if db.WaterShieldOwnFrame then
					WSFrame:Show()
				else
					self:Alert("Self", db.WaterShieldMessage)--#NO_LOCALIZE
				end
			end
			
		else
			if db.ShowWaterShieldMessage then
				if db.WaterShieldOwnFrame then
					WSFrame:Hide()
				end
			end
			if db.WaterShieldCharges then
				if self:IsBarActive(L["No Water Shield!"]) then
					self:CancelBar(L["No Water Shield!"], false)
				end
				if not self:IsBarActive(L["Water Shield"]) then
					self:LocalCountBar(L["Water Shield"], L["Water Shield"], 3, stacks, "Ability_Shaman_WaterShield")
				else
					self:SetBarCount(L["Water Shield"], stacks, false)
				end
			end
		end
		lastStacks = stacks
	end
end

--[[do
	local stopUpdatingWF
	function module:CreateWFTimer()
		self.wfTotemTimer = self:ScheduleRepeatingTimer("UpdateWindfuryTotem", 5) 
	end
	function module:UNIT_SPELLCAST_SUCCEEDED(_, _, spell, rank)
		if totemCategory[spell] then
			if db.TotemTimers then
				local category = totemCategory[spell]
				local lastSpell = lastCategory[category]
				if lastSpell and self:IsBarActive(lastSpell) then
					self:CancelBar(lastSpell)
				end
				if spell == L["Mana Spring Totem"] and rank == "" then
					spell = L["Enamored Water Spirit"]
				end
				self:LocalTimedBar(
					spell,
					category,
					totemRankedTimes[spell] and totemRankedTimes[spell][rank] or totemTimes[spell],
					totemIcons[spell],
					true
				)
				lastCategory[category] = spell
				if spell == L["Stoneclaw Totem"] then --hp actually scales with level, but oh well
					if rank == L["Rank 7"] then
						totemHP[spell] = 1315
					elseif rank == L["Rank 6"] then
						totemHP[spell] = 480
					elseif rank == L["Rank 5"] then
						totemHP[spell] = 390
					elseif rank == L["Rank 4"] then
						totemHP[spell] = 280
					elseif rank == L["Rank 3"] then
						totemHP[spell] = 220
					elseif rank == L["Rank 2"] then
						totemHP[spell] = 150
					else
						totemHP[spell] = 50
					end
				else
					totemHP[spell] = 5
				end
				if category == L["Air Totems"] then
					if self.wfTotemTimer then
						self:CancelTimer(self.wfTotemTimer, true)
					end
				end
			end
			if spell == L["Windfury Totem"] and db.WindfuryTotem then
				local latency = 2 * select(3, GetNetStats()) / 1000 --very rough estimate
				self:LocalTimedBar(WINDFURY_PULSE_LABEL, L["Windfury Pulse"], 10 - latency, "Spell_Nature_Windfury")
				self:ScheduleTimer("CreateWFTimer", latency)
				stopUpdatingWF = totemTimes[spell] + GetTime()
			end
		elseif spell == L["Totemic Call"] then
			self:CancelAllTotems()
		end
	end

	function module:UpdateWindfuryTotem()
		if GetTime() > stopUpdatingWF then
			if self.wfTotemTimer then
				self:CancelTimer(self.wfTotemTimer, true)
			end
		else
			self:SetBarTime(WINDFURY_PULSE_LABEL, 10, false)
		end
	end
end
]]

function module:CancelAllTotems()
	for label in self:IterateActiveBars() do
		local category = self:GetBarSubCategory(label)
		if category == L["Air Totems"]
		or category == L["Earth Totems"]
		or category == L["Fire Totems"]
		or category == L["Water Totems"]
		then
			self:CancelBar(label, false)
		end
	end
	if self.wfTotemTimer then
		self:CancelTimer(self.wfTotemTimer, true)
	end
	for i in pairs(totemGUID) do
		totemGUID[i] = nil
	end
end



function BuildTotems()
	totemLst = {
		-- stoneskin totem
		[8071] = {
			type = L["Earth Totems"],
		},
		[8154] = {
			type = L["Earth Totems"],
		},
		[8155] = {
			type = L["Earth Totems"],
		},
		[10406] = {
			type = L["Earth Totems"],
		},
		[10407] = {
			type = L["Earth Totems"],
		},
		[10408] = {
			type = L["Earth Totems"],
		},
		[25508] = {
			type = L["Earth Totems"],
		},
		[25509] = {
			type = L["Earth Totems"],
		},
		-- earthbind totem
		[2484] = {			
			type = L["Earth Totems"],
			dur = 45,
		},
		-- earth elemental totem
		[2062] = {
			type = L["Earth Totems"],
		},
		--stoneclaw totem
		[5730] = {
			type = L["Earth Totems"],
			dur = 15,
		},
		[6390] = {
			type = L["Earth Totems"],
			dur = 15,
		},
		[6391] = {
			type = L["Earth Totems"],
			dur = 15,
		},
		[6392] = {
			type = L["Earth Totems"],
			dur = 15,
		},
		[10427] = {
			type = L["Earth Totems"],
			dur = 15,
		},
		[10428] = {
			type = L["Earth Totems"],
			dur = 15,
		},
		[25525] = {
			type = L["Earth Totems"],
			dur = 15,
		},
		--Strength of Earth Totem
		[8075] = {
			type = L["Earth Totems"],
		},
		[8160] = {
			type = L["Earth Totems"],
		},
		[8161] = {
			type = L["Earth Totems"],
		},
		[10442] = {
			type = L["Earth Totems"],
		},
		[25361] = {
			type = L["Earth Totems"],
		},
		[25528] = {
			type = L["Earth Totems"],
		},
		--Tremor Totem
		[8143] = {
			type = L["Earth Totems"],
		},
		--Disease Cleansing Totem
		[8170] = {
			type = L["Water Totems"],
		},
		--Fire resist
		[8184] = {
			type = L["Water Totems"],
		},
		[10537] = {
			type = L["Water Totems"],
		},
		[10538] = {
			type = L["Water Totems"],
		},
		[25563] = {
			type = L["Water Totems"],
		},
		-- Healing Stream Totem
		[5394] = {
			type = L["Water Totems"],
		},
		[6375] = {
			type = L["Water Totems"],
		},
		[6377] = {
			type = L["Water Totems"],
		},
		[10462] = {
			type = L["Water Totems"],
		},
		[10463] = {
			type = L["Water Totems"],
		},
		[25567] = {
			type = L["Water Totems"],
		},
		-- Mana Spring
		[5675] = {
			type = L["Water Totems"],
		},
		[10495] = {
			type = L["Water Totems"],
		},
		[10496] = {
			type = L["Water Totems"],
		},
		[10497] = {
			type = L["Water Totems"],
		},
		[25570] = {
			type = L["Water Totems"],
		},
		-- mana spring
		[16190] = {
			type = L["Water Totems"],
			dur = 12,
		},
		-- poison cleansing
		[8166] = {
			type = L["Water Totems"],
		},
		-- fire elemental totem
		[2894] = {
			type = L["Fire Totems"],
		},
		-- fire nova
		[1535] = {
			type = L["Fire Totems"],
			dur = 5,
		},
		[8498] = {
			type = L["Fire Totems"],
			dur = 5,
		},
		[8499] = {
			type = L["Fire Totems"],
			dur = 5,
		},
		[11314] = {
			type = L["Fire Totems"],
			dur = 5,
		},
		[11315] = {
			type = L["Fire Totems"],
			dur = 5,
		},
		[25546] = {
			type = L["Fire Totems"],
			dur = 5,
		},
		[25547] = {
			type = L["Fire Totems"],
			dur = 5,
		},
		-- flametongue totem
		[8227] = {
			type = L["Fire Totems"],
		},
		[8249] = {
			type = L["Fire Totems"],
		},
		[10526] = {
			type = L["Fire Totems"],
		},
		[16387] = {
			type = L["Fire Totems"],
		},
		[25557] = {
			type = L["Fire Totems"],
		},
		-- Frost resistance
		[8181] = {
			type = L["Fire Totems"],
		},
		[10478] = {
			type = L["Fire Totems"],
		},
		[10479] = {
			type = L["Fire Totems"],
		},
		[25560] = {
			type = L["Fire Totems"],
		},
		-- magma totem
		[8190] = {
			type = L["Fire Totems"],
			dur = 20,
		},
		[10585] = {
			type = L["Fire Totems"],
			dur = 20,
		},
		[10586] = {
			type = L["Fire Totems"],
			dur = 20,
		},
		[10587] = {
			type = L["Fire Totems"],
			dur = 20,
		},
		[25552] = {
			type = L["Fire Totems"],
			dur = 20,
		},
		-- searing totem
		[3599] = {
			type = L["Fire Totems"],
			dur = 30,
		},
		[6363] = {
			type = L["Fire Totems"],
			dur = 35,
		},
		[6364] = {
			type = L["Fire Totems"],
			dur = 40,
		},
		[6365] = {
			type = L["Fire Totems"],
			dur = 45,
		},
		[10437] = {
			type = L["Fire Totems"],
			dur = 50,
		},
		[10438] = {
			type = L["Fire Totems"],
			dur = 55,
		},
		[25533] = {
			type = L["Fire Totems"],
			dur = 60,
		},
		-- Totem of Wrath
		[30706] = {
			type = L["Fire Totems"],
		},
		-- grace of air totem
		[8835] = {
			type = L["Air Totems"],
		},
		[10627] = {
			type = L["Air Totems"],
		},
		[25359] = {
			type = L["Air Totems"],
		},
		-- Grounding Totem
		[8177] = {
			type = L["Air Totems"],
			dur = 45,
		},
		-- Nature Resistance Totem
		[10595] = {
			type = L["Air Totems"],
		},
		[10600] = {
			type = L["Air Totems"],
		},
		[10601] = {
			type = L["Air Totems"],
		},
		[25574] = {
			type = L["Air Totems"],
		},
		-- Sentry Totem
		[6495] = {
			type = L["Air Totems"],
			dur = 300,
		},
		-- tranquil air totem
		[25908] = {
			type = L["Air Totems"],
		},
		-- windfury totem
		[8512] = {
			type = L["Air Totems"],
		},
		[10613] = {
			type = L["Air Totems"],
		},
		[10614] = {
			type = L["Air Totems"],
		},
		[25585] = {
			type = L["Air Totems"],
		},
		[25587] = {
			type = L["Air Totems"],
		},
		-- windwall totem
		[15107] = {
			type = L["Air Totems"],
		},
		[15111] = {
			type = L["Air Totems"],
		},
		[15112] = {
			type = L["Air Totems"],
		},
		[25577] = {
			type = L["Air Totems"],
		},
		-- Wrath of Air Totem
		[3738] = {
			type = L["Air Totems"],
		},
	}
	windfuryLst = {
		[8512] = true,
		[10613] = true,
		[10614] = true,
		[25585] = true,
		[25587] = true,
	}
end