-- Author      : Apoco
-- Create Date : 5/28/2008 12:20:01 PM
if not RBM or not Incubator then return end

local module = RBM:NewPlugin("Incubator")
local PC = LibStub("PaintChips-2.0")
local colorModule
local L = module:GetTranslations()

module:RegisterTranslations("enUS", -- translation automatically generated
	"Use Incubator Colors", true
)

module:RegisterTranslations("zhCN", -- translation automatically generated
	"Use Incubator Colors", "使用Incubator的颜色设置"
)

module:RegisterTranslations("zhTW", -- translation automatically generated
	"Use Incubator Colors", "使用Incubator的顏色設定"
)

module:RegisterTranslations("koKR",
	"Use Incubator Colors", "Incubator 색상 사용"
)

function module:OnInitialize()
	self:SetDefaultEnabledState(false)
	self:RegisterToggles(L["Announce"], false,
						L["Use Incubator Colors"], true
						)
end

function module:OnEnable()
	self.OrigStartBar = Incubator.StartCandyBar
	self.OrigRegisterBar = Incubator.RegisterCandyBar
	self.OrigStopBar = Incubator.StopCandyBar
	Incubator.StartCandyBar = self.Incubator_StartCandyBar
	Incubator.RegisterCandyBar = self.Incubator_RegisterCandyBar
	Incubator.StopCandyBar = self.Incubator_StopCandyBar
	self:RegisterCategory("Incubator", "Incubator Bars", 0.53, 1.0, 0.32)
end

function module:OnDisable()
	Incubator.StartCandyBar = self.OrigStartBar
	Incubator.RegisterCandyBar = self.OrigRegisterBar
	Incubator.StopCandyBar = self.OrigStopBar
	self:UnregisterAllEvents()
end

local colorLst = {}
function module:Incubator_RegisterCandyBar(prefixname, time, name, icon, ...)
	if type(select(1, ...)) == "string" and module:CheckToggle(L["Use Incubator Colors"]) then
		for i in pairs(colorLst) do
			colorLst[i] = nil
		end
		local i, tablenum = 1, 1
		while PC:GetRGBPercent(select(i, ...)) do
			colorLst[tablenum], colorLst[tablenum + 1], colorLst[tablenum + 2] = select(2, PC:GetRGBPercent(select(i, ...)))
			tablenum = tablenum + 3
			i = i + 1
		end
		module:TimedBar(name, "Incubator", time, icon or nil, true, nil, unpack(colorLst))	
	else
		module:TimedBar(name, "Incubator", time, icon or nil, true)
	end
end

function module:Incubator_StartCandyBar()
end

function module:Incubator_StopCandyBar(name)
	module:CancelBar(name)
end